# Google Cloud OAuth Setup Guide

Complete guide to setting up Google Cloud credentials for Gmail API access.

## Prerequisites

- Google account (Gmail)
- Web browser
- Terminal access

## Step-by-Step Setup

### 1. Create Google Cloud Project

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Sign in with your Google account
3. Click the project dropdown at the top
4. Click **"New Project"**
5. Enter project name (e.g., "Claude Gmail Integration")
6. Click **"Create"**
7. Wait for project creation (you'll see a notification)
8. Select your new project from the dropdown

### 2. Enable Gmail API

1. In the Google Cloud Console, click the hamburger menu (☰)
2. Navigate to **"APIs & Services"** → **"Library"**
3. Search for **"Gmail API"**
4. Click on **"Gmail API"**
5. Click the **"Enable"** button
6. Wait for API to be enabled

### 3. Configure OAuth Consent Screen

1. In the left sidebar, click **"OAuth consent screen"**
2. Select **"External"** user type
3. Click **"Create"**

**Fill in App Information:**
- App name: `Claude Gmail Skill` (or your preferred name)
- User support email: Your email address
- Developer contact email: Your email address

4. Click **"Save and Continue"**

**Scopes:**
5. Click **"Add or Remove Scopes"**
6. Search for `gmail` in the filter
7. Select: **`https://www.googleapis.com/auth/gmail.modify`**
   - This scope allows read, send, and modify (but not delete) emails
8. Click **"Update"**
9. Click **"Save and Continue"**

**Test Users:**
10. Click **"Add Users"**
11. Add your Gmail address
12. Click **"Add"**
13. Click **"Save and Continue"**

**Summary:**
14. Review the information
15. Click **"Back to Dashboard"**

### 4. Create OAuth Credentials

1. In the left sidebar, click **"Credentials"**
2. Click **"+ Create Credentials"** at the top
3. Select **"OAuth client ID"**

**Configure OAuth Client:**
4. Application type: Select **"Desktop app"**
5. Name: `Claude Gmail Client` (or your preferred name)
6. Click **"Create"**

**Download Credentials:**
7. A dialog will appear with your Client ID and Secret
8. Click **"Download JSON"**
9. Save the file as `credentials.json`

### 5. Save Credentials to Skill

1. Move the downloaded file to the skill's auth directory:

```bash
mv ~/Downloads/credentials.json ~/.claude/skills/gmail-skill/scripts/auth/credentials.json
```

2. Verify the file is in the correct location:

```bash
ls -la ~/.claude/skills/gmail-skill/scripts/auth/credentials.json
```

You should see the file listed.

### 6. Install Dependencies

```bash
cd ~/.claude/skills/gmail-skill
npm install
```

### 7. Run OAuth Setup

```bash
npm run setup
```

This will:
1. Open your browser automatically
2. Ask you to sign in to Google
3. Show a consent screen asking for Gmail permissions
4. Redirect to localhost (you'll see a success message)
5. Save the OAuth token to `scripts/auth/token.json`

**Important Security Notes:**
- Click **"Continue"** when you see the "App isn't verified" warning (this is expected for personal projects)
- Review the permissions carefully - you're granting access to your Gmail
- The token is stored locally on your machine only

### 8. Verify Setup

Test that everything works:

```bash
cd ~/.claude/skills/gmail-skill/scripts
node gmail-search.js --query "is:inbox" --limit 1
```

You should see JSON output with one email from your inbox.

## Troubleshooting

### "App isn't verified" Warning

**Problem:** Google shows a warning that the app isn't verified.

**Solution:** This is normal for personal projects. Click **"Advanced"** → **"Go to [App Name] (unsafe)"** → **"Continue"**.

### "Access blocked: This app's request is invalid"

**Problem:** OAuth consent screen not configured correctly.

**Solution:**
1. Go to OAuth consent screen
2. Ensure you added your email as a test user
3. Ensure Gmail API scope is added
4. Try authentication again

### "Token not found" Error

**Problem:** OAuth setup didn't complete successfully.

**Solution:**
1. Check that `credentials.json` exists in `scripts/auth/`
2. Run `npm run setup` again
3. Complete the browser authentication flow
4. Verify `token.json` was created in `scripts/auth/`

### "The user has not granted the app" Error

**Problem:** Gmail API scope wasn't granted during OAuth flow.

**Solution:**
1. Delete `scripts/auth/token.json`
2. Run `npm run setup` again
3. Carefully review permissions and click **"Allow"**

### "Invalid client" Error

**Problem:** `credentials.json` is corrupted or incorrect.

**Solution:**
1. Go back to Google Cloud Console
2. Download credentials again
3. Replace `scripts/auth/credentials.json`
4. Run `npm run setup` again

## Security Best Practices

1. **Never commit credentials:**
   - `credentials.json` and `token.json` are in `.gitignore`
   - Never share these files publicly

2. **Token refresh:**
   - Tokens expire periodically
   - Refresh by running `npm run setup` again

3. **Revoke access:**
   - Go to [Google Account Security](https://myaccount.google.com/permissions)
   - Find your app and click **"Remove Access"**

4. **Limit scope:**
   - The skill uses `gmail.modify` scope (read/send/modify)
   - This does NOT allow permanent email deletion
   - This is the minimum scope needed for full functionality

## Additional Resources

- [Gmail API Documentation](https://developers.google.com/gmail/api)
- [OAuth 2.0 for Desktop Apps](https://developers.google.com/identity/protocols/oauth2/native-app)
- [Gmail API Scopes](https://developers.google.com/gmail/api/auth/scopes)

## Next Steps

Once setup is complete:
1. Read the main `README.md` for usage examples
2. Try sending a test email
3. Explore the search functionality
4. Set up labels and drafts as needed

The skill is now ready to use with Claude Code!
