# Popular Style Guides by Language

## JavaScript/TypeScript

### Airbnb Style Guide
- **URL**: https://github.com/airbnb/javascript
- **Key Rules**:
  - Use `const` for all references, avoid `var`
  - Use single quotes for strings
  - No trailing commas in arrays/objects (ES5)
  - 2 spaces for indentation

### Standard JS
- **URL**: https://standardjs.com/
- **Key Rules**:
  - No semicolons
  - 2 spaces for indentation
  - Single quotes for strings
  - Space after keywords

### Google Style Guide
- **URL**: https://google.github.io/styleguide/jsguide.html
- **Key Rules**:
  - Use `const` and `let`, never `var`
  - Semicolons required
  - 2 spaces for indentation
  - Use arrow functions

## Python

### PEP 8
- **URL**: https://pep8.org/
- **Key Rules**:
  - 4 spaces for indentation
  - Maximum line length 79 characters
  - 2 blank lines between top-level functions
  - Imports at top of file

### Black
- **URL**: https://black.readthedocs.io/
- **Key Rules**:
  - 88 character line length
  - Double quotes for strings
  - Automatic formatting (opinionated)
  - Consistent style across projects

### Google Python Style Guide
- **URL**: https://google.github.io/styleguide/pyguide.html
- **Key Rules**:
  - 4 spaces for indentation
  - Maximum line length 80 characters
  - Use type hints
  - Docstrings for all public methods

## Go

### Effective Go
- **URL**: https://golang.org/doc/effective_go
- **Key Rules**:
  - Use `gofmt` (tabs for indentation)
  - Short variable names
  - Receiver names should be consistent
  - Error handling explicit

## Rust

### Rust Style Guide
- **URL**: https://doc.rust-lang.org/nightly/style-guide/
- **Key Rules**:
  - 4 spaces for indentation
  - Maximum line width 100 characters
  - Use `rustfmt` for consistency
  - Snake case for functions/variables

## Configuration Examples

See `configuration-examples/` for sample configs ready to use.
