# Vulnerability Databases

## Primary Sources

### npm Audit
- **URL**: https://www.npmjs.com/advisories
- **Coverage**: Node.js packages
- **Update Frequency**: Real-time
- **API**: Built into npm CLI

### GitHub Advisory Database
- **URL**: https://github.com/advisories
- **Coverage**: Multi-language
- **Update Frequency**: Real-time
- **API**: GraphQL API available

### Snyk Vulnerability DB
- **URL**: https://snyk.io/vuln
- **Coverage**: Multi-language, containers
- **Update Frequency**: Real-time
- **API**: REST API (requires account)

### OSS Index (Sonatype)
- **URL**: https://ossindex.sonatype.org/
- **Coverage**: Multi-language
- **Update Frequency**: Daily
- **API**: REST API (free tier available)

## CVE Databases

### National Vulnerability Database (NVD)
- **URL**: https://nvd.nist.gov/
- **Coverage**: All software
- **Update Frequency**: Daily
- **API**: REST API available

### MITRE CVE
- **URL**: https://cve.mitre.org/
- **Coverage**: All software
- **Update Frequency**: Real-time
- **API**: CVE JSON feeds

## Language-Specific

### PyPI Advisory Database
- **URL**: https://pypi.org/security/
- **Coverage**: Python packages
- **Tool**: pip-audit, safety

### RustSec Advisory Database
- **URL**: https://rustsec.org/
- **Coverage**: Rust crates
- **Tool**: cargo-audit

### Go Vulnerability Database
- **URL**: https://pkg.go.dev/vuln
- **Coverage**: Go modules
- **Tool**: govulncheck
