# Memory Entry Schema v1.0

## Complete Specification

All memory entries must conform to this schema:

```json
{
  "topic": "string (required, max 100 chars)",
  "scope": "global|repository (required)",
  "value": "any (required)",
  "TTL": "ISO8601 timestamp (optional)",
  "source": "user|agent|system (required)",
  "confidence": "0.0-1.0 (required)",
  "metadata": {
    "repository": "string (optional)",
    "created": "ISO8601 (auto-generated)",
    "updated": "ISO8601 (auto-generated)",
    "tags": ["array", "of", "strings"] (optional),
    "provenance": "string (optional)"
  }
}
```

## Field Definitions

### topic (required)
- **Type**: String
- **Max Length**: 100 characters
- **Description**: Brief identifier for this memory entry
- **Examples**: "react-patterns", "api-auth-method", "test-strategy"
- **Constraints**: Lowercase with hyphens preferred

### scope (required)
- **Type**: Enum
- **Values**: "global" | "repository"
- **Description**: Determines where this memory applies
- **Global**: Applies across all projects
- **Repository**: Specific to current git repository

### value (required)
- **Type**: Any
- **Description**: The actual memory content
- **Can be**: String, Object, Array, Number, Boolean
- **Examples**:
  - String: "Always use functional components in React"
  - Object: {"auth": "OAuth2", "provider": "Auth0"}
  - Array: ["jest", "react-testing-library"]

### TTL (optional)
- **Type**: ISO8601 timestamp string
- **Format**: "2025-12-31T23:59:59Z"
- **Description**: Time-to-live - when this entry expires
- **Use cases**:
  - Temporary decisions
  - Experimental features
  - Incident-related notes
- **Default**: No expiration

### source (required)
- **Type**: Enum
- **Values**: "user" | "agent" | "system"
- **Description**: Who/what created this entry
- **User**: Explicitly added by user
- **Agent**: Created by autonomous agent
- **System**: Auto-generated by memory system

### confidence (required)
- **Type**: Float
- **Range**: 0.0 to 1.0
- **Description**: Confidence level in this memory
- **Guidelines**:
  - 1.0: Verified, documented fact
  - 0.8-0.9: High confidence, tested
  - 0.6-0.7: Moderate confidence, observed pattern
  - 0.4-0.5: Low confidence, hypothesis
  - 0.0-0.3: Very uncertain, needs verification

### metadata (optional)
- **Type**: Object
- **Description**: Additional context about the entry

#### metadata.repository (optional)
- **Type**: String
- **Description**: Repository hash if scope is "repository"

#### metadata.created (auto-generated)
- **Type**: ISO8601 timestamp
- **Description**: When this entry was created

#### metadata.updated (auto-generated)
- **Type**: ISO8601 timestamp
- **Description**: Last modification timestamp

#### metadata.tags (optional)
- **Type**: Array of strings
- **Description**: Searchable tags
- **Examples**: ["react", "frontend"], ["security", "auth"]

#### metadata.provenance (optional)
- **Type**: String
- **Description**: Where this memory came from
- **Examples**: "migration from v0.9", "imported from team wiki"

## Validation Rules

1. **Required fields must be present**
   - Reject entries missing topic, scope, value, source, or confidence

2. **Type constraints must be satisfied**
   - scope must be exactly "global" or "repository"
   - source must be exactly "user", "agent", or "system"
   - confidence must be numeric between 0.0 and 1.0

3. **Length constraints must be respected**
   - topic must be ≤ 100 characters

4. **Format constraints for timestamps**
   - TTL must be valid ISO8601 if present
   - created and updated auto-generated as ISO8601

5. **Scope-specific validation**
   - If scope is "repository", metadata.repository should be set

## Schema Evolution

### Version History
- **v1.0** (2025-10-20): Initial schema

### Migration Path
If schema changes:
1. Create `migrate_v1_to_v2.py` script
2. Update schema version in all entries
3. Preserve backward compatibility
4. Document breaking changes

### Backward Compatibility
- New optional fields can be added
- Required fields cannot be removed
- Type changes require migration script

## Validation Examples

### Valid Entry
```json
{
  "topic": "react-component-pattern",
  "scope": "global",
  "value": "Use functional components with hooks",
  "TTL": "2026-01-01T00:00:00Z",
  "source": "user",
  "confidence": 0.95,
  "metadata": {
    "created": "2025-10-20T12:00:00Z",
    "updated": "2025-10-20T12:00:00Z",
    "tags": ["react", "frontend", "best-practice"]
  }
}
```

### Invalid Entry - Missing Required Field
```json
{
  "topic": "test-strategy",
  "value": "Use Jest",
  "confidence": 0.8
}
```
**Error**: Missing required field: scope, source

### Invalid Entry - Wrong Type
```json
{
  "topic": "api-pattern",
  "scope": "team",
  "value": "REST",
  "source": "user",
  "confidence": 0.9
}
```
**Error**: Scope must be 'global' or 'repository', got 'team'

### Invalid Entry - Constraint Violation
```json
{
  "topic": "very-long-topic-name-that-exceeds-the-maximum-allowed-length-of-one-hundred-characters-and-should-be-rejected",
  "scope": "global",
  "value": "test",
  "source": "user",
  "confidence": 0.5
}
```
**Error**: Topic exceeds 100 characters

---

*Schema v1.0 - Memory Hygiene Skill*
