---
name: bugfix
description: Standardized bug fix workflow using TDD (Red-Green-Refactor). Use when fixing bugs, resolving issues, or when the user invokes /bugfix. Ensures root cause analysis, failing test first, then minimal fix.
---

# Bug Fix Workflow

バグ修正の標準化されたワークフロー。TDD（Red-Green-Refactor）とroot cause analysisを組み合わせる。

## ワークフロー

### Phase 1: 理解

1. **バグの報告・症状を確認する**
   - ユーザーからの報告、issueの内容、エラーメッセージを把握
   - 再現条件を明確にする

2. **関連コードを読む**
   - バグが発生している箇所のソースコードを読む
   - 呼び出し元・呼び出し先の依存関係を理解する
   - **既存テストを確認**: 関連するテストファイルを読み、テストパターン（アサーション、データ構造、ヘルパー関数）を把握する

3. **根本原因を特定する（5 Whys）**
   - エラーメッセージの**最初**を確認する（最後ではない）
   - 症状ではなく根本原因を探る
   - 仮定に頼らず、コードを実際に読んで確認する
   - 確信が持てない場合は logic-validator で推論を検証する

### Phase 2: Red（失敗するテストを書く）

4. **バグを再現する失敗テストを書く**
   - **既存テストのパターンに合わせる**: アサーションスタイル、データ構造、命名規則を既存テストから踏襲する
   - テストがバグの症状を正確に捉えていることを確認する
   - テストを実行し、**確実に失敗する**ことを確認する

### Phase 3: Green（最小限の修正）

5. **テストが通る最小限のコード修正を行う**
   - 根本原因に対する修正のみ行う
   - 周辺コードのリファクタリングは行わない
   - テストを実行し、**新しいテストが通る**ことを確認する

### Phase 4: Refactor（リグレッション確認）

6. **全テストスイートを実行してリグレッションがないことを確認する**
   - 新しいテストだけでなく、既存テスト全体を実行する
   - lint/type checkも実行する

7. **必要に応じてコードを整理する**
   - テストが全て通った状態でのみリファクタリングする
   - 修正に直接関係する箇所のみ

### Phase 5: まとめ

8. **バグの原因と修正内容をサマリーする**
   - 根本原因は何だったか
   - どのように修正したか
   - 影響範囲と確認した内容

## 注意事項

- **症状的修正を避ける**: 「とりあえず動く」修正ではなく根本原因に対処する
- **既存パターンを尊重する**: テスト構造、エラーハンドリング、コーディングスタイルをプロジェクトに合わせる
- **最小限の変更**: バグ修正に直接関係ない変更は別コミットにする
- **debugging.md を参照**: 詳細なデバッグ手順は `@~/.claude/rules/debugging.md` に従う
