---
name: execute-plan
description: "Execute a pre-existing plan file by implementing tasks sequentially with test verification after each step. Use when plan/tasks are already decomposed and ready for implementation."
---

# Execute Plan

計画ファイルまたは分解済みタスクリストを入力として、順次実装・検証・コミットする。
`/decompose` でタスク分解した後の実装フェーズで使用する。

## 前提条件

以下のいずれかが存在すること:
- 計画ファイル（Markdown、ADRなど）のパス
- TaskCreate で作成済みのタスクリスト
- ユーザーが直接指定するタスク一覧

## ワークフロー

### 1. 計画の読み込み

- 指定されたパスの計画ファイルを Read で読む
- TaskList で既存タスクを確認する
- 計画にタスク一覧がない場合、計画から実装タスクを抽出して TaskCreate で登録する

### 2. 順次実装ループ

各タスクについて以下を実行:

```
for each task:
  1. TaskUpdate → in_progress
  2. 実装（Edit/Write で変更）
  3. ビルド実行（プロジェクトの build コマンド）
     - 失敗 → 修正して再ビルド（最大3回）
  4. テスト実行（プロジェクトの test コマンド）
     - 失敗 → 修正して再テスト（最大3回）
  5. lint/type-check 実行
  6. TaskUpdate → completed
```

### 3. 検証とコミット

- 全タスク完了後、全テストスイートを再実行
- 成功したら変更内容のサマリーをユーザーに提示
- ユーザーの指示に従ってコミット

## 制約

### 実行の継続性

- **全タスク完了まで停止しない**: タスクやフェーズが完了したら計画ドキュメントにも完了とマークし、即座に次のタスクに進む。途中で不要な確認や報告で中断しない
- **タスク間の依存**: 前のタスクのテストが通らない場合、次のタスクに進まない
- **ビルド/テスト3回失敗**: 自動修正を諦め、失敗状況をユーザーに報告して判断を仰ぐ（これが唯一の停止条件）

### コード品質

- **不要なコメント・JSDoc禁止**: 変更していないコードにコメントやJSDocを追加しない。新規コードにも自明な内容のコメントは書かない
- **unknown型禁止**: 適切な型注釈を使用する。`any` / `unknown` でごまかさない
- **typecheck継続実行**: 各タスクの実装後だけでなく、複数ファイルを変更した場合は途中でも typecheck を実行し、型エラーの蓄積を防ぐ

### その他

- **計画からの逸脱禁止**: 計画にない変更が必要な場合、ユーザーに確認してから実行する
- **コミットはユーザー指示で**: 自動コミットしない — サマリー提示後にユーザーが判断する
