---
name: logic-validation
description: Validate logical consistency of decisions and claims through context forking. Use proactively when judgment validity is unclear, but prefer direct tools (Read, Bash) for simple verifications like file contents or test results.
---

# Logic Validation Skill

logic-validatorエージェントを使用して、アシスタントの行動・判断・主張の論理的整合性を検証します。

**サブエージェントの利点**: logic-validatorはTaskツール経由で呼び出すサブエージェントです。現在のコンテキストをフォークして独立した視点で検証できるため、自分の判断の論理的妥当性を客観的にチェックできます。

**使用方針（CLAUDE.md準拠）**: 以下の場面では**プロアクティブに検討**してください：
- 動作している設定を変更する前
- 根本原因分析なしに症状的修正を適用する前
- 証拠なしに仮定する前

ただし、**単純な確認作業**（ファイル内容の読み取り、テスト結果の確認）には、logic-validatorではなく**直接Readツールやbash出力を使用**してください。logic-validatorは**判断の妥当性が不明確な場合**に使用します。

## 使用タイミング

### 判断フローチャート

まず以下の質問で適切なツールを選択してください：

```
Q1: これは単純な確認作業か？（ファイル内容、テスト結果、コマンド出力）
├─ Yes → 直接Readツールやbashを使用（logic-validator不要）
└─ No → Q2へ

Q2: 判断の論理的妥当性に不安があるか？証拠は十分か？
├─ Yes → logic-validator を使用
└─ No → Q3へ

Q3: 実装の質・設計の妥当性・ベストプラクティスについて相談したいか？
├─ Yes → codex-review を使用
└─ No → そのまま進める
```

### logic-validatorを使うべき具体的な場面

**高優先度（プロアクティブに検討）**:
1. **仮定に基づく重要な決定**: 証拠なしに「これで動くはず」と判断する前
2. **動作している設定の変更**: 以前は動いていた設定を変更しようとする前
3. **症状的修正の適用**: 根本原因を特定せずに「とりあえず修正」する前
4. **CLAUDE.mdルール抵触の懸念**: デバッグガイドライン違反の可能性がある判断

**中優先度（状況に応じて）**:
5. **複雑な推論の結論**: 多段階の論理を経た結論の妥当性確認
6. **計画完了時**: ExitPlanMode実行前の論理的整合性チェック（複雑な計画のみ）

**使用不要**:
- ファイル編集後の内容確認 → **Readツール**で直接確認
- テスト実行後の結果確認 → **bash出力**を直接読む
- 単純な情報提供や事実の報告

### codex-reviewとの使い分け

| 焦点 | 使用するスキル | 例 |
|------|-------------|-----|
| 証拠の有無・論理の妥当性 | logic-validation | 「この設定変更は、依存関係すべてを考慮しているか？」 |
| 実装の質・設計選択 | codex-review | 「この認証実装は、セキュリティベストプラクティスに従っているか？」 |
| 両方必要 | 両方使用 | 計画完了時：logic-validationで論理チェック → codex-reviewで実装妥当性確認 |

### ユーザーから明示的に呼ばれる場面

- "この判断は正しいか検証して"
- "論理的に一貫しているか確認して"
- "/logic-validation" コマンド

## 基本的な使用方法

### Taskツール経由での呼び出し

```typescript
Task({
  subagent_type: "logic-validator",
  description: "Validate action logic",
  prompt: `
以下のアクション・主張の論理的整合性を検証してください：

## 実行したアクション
[具体的に何を行ったか]

## 主張・結論
[何を主張しているか、どのような結論を出したか]

## 検証ポイント
1. 主張は実際の検証結果に基づいているか？
2. 検証なしに成功を仮定していないか？
3. 必要な確認ステップが抜けていないか？
`
})
```

## 使用例

### ケース1: テスト実行後の検証

**良い例**:
```typescript
// テスト実行後、結果を主張する前に検証
Task({
  subagent_type: "logic-validator",
  description: "Validate test completion claim",
  prompt: `
以下の主張を検証してください：

## 実行したアクション
\`npm test\` コマンドを実行

## 主張
"すべてのテストがパスしました"

## 確認ポイント
1. 実際にテスト出力を確認したか？
2. エラーメッセージを見逃していないか？

## テスト出力
[実際のコマンド出力を添付]
`
})
```

### ケース2: 設定変更の妥当性検証

**シナリオ**: ビルドエラー発生時に設定ファイルを変更しようとしている

```typescript
Task({
  subagent_type: "logic-validator",
  description: "Validate configuration change decision",
  prompt: `
以下の判断を検証してください：

## 状況
TypeScriptビルドで "tsc: not found" エラー発生

## 提案するアクション
package.json の scripts セクションを変更

## 判断の根拠
"tsc が見つからないので、ビルドスクリプトを修正する必要がある"

## 検証ポイント
1. 根本原因の分析が不足していないか？
2. エラーメッセージの全文を確認したか？
3. 設定変更前に動いていた証拠はあるか？

## エラー出力
[エラーメッセージの最後の20行のみ表示]

注意: CLAUDE.mdのデバッグガイドラインでは「エラーメッセージの最初を確認する」「動いていた設定を変更しない」とされています。
`
})
```

## プロンプト設計のベストプラクティス

効果的なプロンプト構造：

```markdown
以下の[アクション/主張/判断]の論理的整合性を検証してください：

## 実行したアクション / 現在の状況
[具体的に何を行ったか]

## 主張・結論
[何を主張しているか]

## 検証ポイント
1. [確認すべきポイント1]
2. [確認すべきポイント2]

## 証拠・根拠
[主張の根拠となる実際のデータや出力]
```

具体的で明確な検証ポイントを含めることが重要です。

## 実装パターン

### パターン1: 複雑な判断の妥当性検証

```typescript
// ❌ 悪い例: 単純確認にlogic-validator使用（不要）
Edit({ file_path: "config.json", ... })
Task({ subagent_type: "logic-validator", prompt: "編集が成功したか確認すべきか？" })
Read({ file_path: "config.json" })

// ✅ 良い例: 複数ファイルにまたがる仮定ベースの判断を検証
Read({ file_path: "config.json" })
Read({ file_path: "docker-compose.yml" })

Task({
  subagent_type: "logic-validator",
  description: "Validate config change decision",
  prompt: `
## 判断の根拠
「環境変数で上書きされるはずなので、他は変更不要」

## 検証ポイント
1. 本当に環境変数で上書きされるか確認したか？
2. この仮定が間違っていた場合の影響は？
`
})
```

### パターン2: 動作している設定変更前の検証

```typescript
// エラーメッセージ全文を確認
Bash({ command: "pnpm build 2>&1 | head -50" })

// 判断を検証
Task({
  subagent_type: "logic-validator",
  description: "Validate config change decision",
  prompt: `
## 状況
TypeScriptビルドで "tsc: not found" エラー発生

## 提案するアクション
tsconfig.json の moduleResolution を変更

## 検証ポイント
1. エラーメッセージの**最初**を確認したか？
2. これは根本原因か、症状か？
3. 以前は動いていた設定を変更しようとしていないか？

CLAUDE.md のデバッグガイドラインに照らして評価してください。
`
})
```

## 注意事項

### 検証の範囲

1. **論理的整合性**: 主張と証拠の一致、推論の妥当性
2. **証拠の有無**: 検証なしに成功を仮定していないか
3. **完全性**: 必要なステップが抜けていないか
4. **仮定の明示**: 暗黙の前提がないか

logic-validatorは **実装の正しさ** ではなく、**論理的推論の妥当性** を検証します。

### 使用判断のガイドライン

**コンテキストフォークが有効な場面**:
サブエージェントとして呼び出すため、現在のコンテキストをフォークして検証できます。以下のような場面で特に有効です：
- 自分の判断に確信が持てない
- 複数の証拠から導いた結論の妥当性確認
- CLAUDE.mdガイドラインとの整合性チェック
- 動いていた設定を変更しようとしている

**優先すべき検証手段**:
- 単純な確認（ファイル内容、テスト結果）: **直接Readツールや出力確認を使う**
- 論理的妥当性が不明確: logic-validator を使用
- 実装の妥当性確認: codex-review を使用

**使用不要な場面**:
- 単純な情報提供や事実の報告
- ツール結果をそのまま伝える
- ユーザーへの質問や確認

### 応答の取り扱い

- **参考意見として扱う**: logic-validatorの指摘も完璧ではない。最終判断はアシスタント自身が行う
- **即座の修正**: 論理的欠陥が見つかったら、追加検証を実施
- **パターン学習**: 繰り返し指摘される問題は、今後のアクションで回避

### 使用時の注意

- logic-validatorは**思考の代替ではなく補助**
- 自明な場合や時間的制約がある場合は省略可能
- 「検証のための検証」にならないよう注意

## ワークフロー統合

### Planモード完了前の標準フロー

```
1. 実装計画を作成
2. 論理的整合性に不安がある場合: logic-validator で検証
   ├─ OK: 次へ
   └─ NG: 計画を修正 → 再検証
3. 複雑な判断が必要な場合: codex-review で外部視点を取得
4. ExitPlanMode 実行
```

### 実装中の標準フロー

```
1. 証拠収集（ファイル読み取り、テスト実行など）
2. 判断が必要な場面で、論理的妥当性に不安がある場合:
   logic-validator で検証
   ├─ OK: 判断を実行
   └─ NG: 追加証拠収集（Read, Bash等）→ 再評価
3. 単純な確認は直接ツール使用（logic-validator不要）
```

### デバッグフロー（CLAUDE.mdルール準拠）

```
1. エラーメッセージの全文を収集（特に最初のエラー）
2. 根本原因の仮説を立てる（5 Whys）
3. 動作していた設定を変更しようとする場合:
   logic-validator で判断の妥当性を検証
   ├─ OK: 修正実施
   └─ NG: 症状的修正の可能性 → 根本原因を再調査
4. 修正実施
5. 元の設定で再テスト
```

## 関連リソース

- `.claude/agents/logic-validator.md`: エージェント定義
- `CLAUDE.md`: タスク完了プロトコル、デバッグガイドライン
- `/codex-review-cli` skill: 外部視点からのレビュー（実装の妥当性）
- `/codex-review-mcp` skill: 継続的な技術相談

## 使い分け

| スキル | 検証対象 | タイミング |
|--------|----------|-----------|
| logic-validation (このスキル) | 論理的整合性、証拠の有無 | アクション後、主張前（プロアクティブ） |
| codex-review-cli | 実装の妥当性、設計判断 | 複雑な判断時、外部視点が必要なとき |
| codex-review-mcp | アーキテクチャ、ベストプラクティス | 深い議論、継続的レビュー |

**推奨フロー**:
```
1. logic-validation で論理チェック（自己検証）
2. 複雑な判断 → codex-review で外部視点
3. さらに深い議論が必要 → codex-review-mcp
```
