---
name: scope-guard
description: "Analyze task scope and recommend execution strategy (sub-agent, multi-session, or scope cut). Orchestrates existing skills like /decompose, /task-enrich, and /task-handoff."
context: inherit
---

# Scope Guard

スコープ過大なタスクを診断し、実行戦略を提案するオーケストレーター。
既存スキル（/decompose, /task-enrich, /task-handoff）を統制し、タスク完遂までのフローを設計する。

## 使い分け

| タスク規模 | 推奨 |
|-----------|------|
| 小（1-2ステップ、明確） | 不要 -- 直接実装 |
| 中（3-5ステップ、複数戦略あり） | `/approach-check` |
| 大（6+ステップ、設計判断を伴う） | Plan Mode + `/decompose` |
| **過大（コンテキスト枯渇リスク）** | **このスキル** |

## scope-guard の責務

- **担うこと**: スコープ診断、実行戦略の判断、実行プロンプト生成
- **担わないこと**: タスクの実行そのもの（メインエージェントに委譲）

## ワークフロー

### 1. スコープ診断

ユーザーの指示内容を分析する。必要であれば AskUserQuestion で 1-2問の追加質問をする（ファイル探索はしない）。

以下を特定する:
- **影響範囲**: 関係するコンポーネント/モジュール
- **推定規模**: Small / Medium / Large / Very Large
- **課題**: スコープを過大にしている要因（探索と実装の混在、曖昧な終了条件など）

### 2. 仮戦略の提示

3つの戦略から推奨を提示し、ユーザーの承認を得る:

```
## スコープ診断結果

**影響範囲**: [コンポーネント/モジュール名]
**推定規模**: [Small / Medium / Large / Very Large]
**課題**:
  - [課題1]
  - [課題2]

## 推奨戦略: [A / B / C]

**理由**: [この戦略が適切な理由]

### 選択肢

A. **サブエージェント実行**（このセッション内で完結）
   → /decompose で軽量タスク粒度に分解 → 順次実行
   [具体的な分解の方向性を記述]

B. **マルチセッション分割**（複数セッションに跨る）
   → /decompose でセッション単位に分解 → /task-enrich → /task-handoff
   [セッション分割の方向性を記述]

C. **スコープカット**（ユーザーと優先度交渉で縮小）
   [削減候補の提案を記述]
```

AskUserQuestion で戦略の選択を求める。

### 3. 実行プロンプト生成

ユーザーが戦略を選択したら、メインエージェントへの実行指示を生成する。

#### A. サブエージェント実行の場合

```
## 実行プラン

### ステップ 1: タスク分解
/decompose を以下の方針で実行:
- 各タスクがサブエージェント（Task tool）で実行可能な粒度
- [具体的な分割軸・観点]

### ステップ 2: 順次実行
/execute-plan でタスクを順番に実行
```

#### B. マルチセッション分割の場合

```
## 実行プラン

### ステップ 1: タスク分解
/decompose を以下の方針で実行:
- 各タスクが1セッションで完結する粒度
- [具体的な分割軸・観点]

### ステップ 2: タスク品質保証
/task-enrich で各タスクの自己完結性を検証・拡充

### ステップ 3: セッション引き継ぎ
/task-handoff でハンドオフコマンドを生成
```

#### C. スコープカットの場合

```
## スコープ交渉

以下の優先度で分類しました:

**Must（今回実施）**:
- [タスク1]
- [タスク2]

**Should（次回以降）**:
- [タスク3]

**Could（余裕があれば）**:
- [タスク4]

Must のスコープで進めますか？
```

### 4. メインエージェントに返す

生成した実行プランをユーザーに提示する。
ユーザーの後続指示（「進めて」「修正あり」等）に従って続行する。

## 戦略決定の2段階化

scope-guard が提示するのは「仮戦略」（方向性）のみ。

`/decompose` はコードベース探索を含むため、探索結果によって仮戦略と実態がズレる可能性がある。
その場合、メインエージェントが `/decompose` の結果を見て最終戦略を調整する。

## エッジケース

### 再帰的スコープ超過
分解後のサブタスクがまだ大きい場合:
- 再帰は最大2階層まで
- 2階層目でもまだ大きい場合はスコープカットに移行

### 分解前に調査が必要
「分解不可能」に見える場合の多くは、情報不足が原因:
- 探索的タスク → 「調査」と「実装」のセッション分離を提案（戦略B）
- 要件不明確 → ユーザーに要件の明確化を求める（戦略Cの変形）

### 誤検知
- ユーザーが `/scope-guard` 不要と判断 → そのまま続行
- ユーザーが手動で `/scope-guard` を呼ぶ → CLAUDE.mdルールの検知を経ずに直接起動可能

## 連携スキル

| スキル | 役割 | scope-guard との関係 |
|--------|------|---------------------|
| `/decompose` | タスク分解 | scope-guard が粒度を指示 |
| `/task-enrich` | タスク説明の拡充 | マルチセッション経路で使用 |
| `/task-handoff` | セッション引き継ぎ | マルチセッション経路で使用 |
| `/execute-plan` | タスク順次実行 | サブエージェント経路で使用 |
| `/approach-check` | アプローチ確認 | 中規模タスク向け（scope-guard は過大向け） |
