---
name: self-correct-loop
description: "Autonomous implement-build-test-fix loop with configurable max iterations. Shows results only after tests pass or iteration limit is reached. Use for feature implementation where tests already exist."
---

# Self-Correcting Implementation Loop

実装→ビルド→テスト→修正を自律的に繰り返し、テスト通過後に結果を提示する。
テストが既に存在するフィーチャー実装やリファクタリングで使用する。

## 使い分け

| シナリオ | 推奨 |
|---------|------|
| バグ修正（テストがまだない） | `/bugfix`（TDDでテスト先行） |
| 機能実装（テストが既にある or 同時に書く） | **このスキル** |
| 計画済みの複数タスク実装 | `/execute-plan` |

## パラメータ

ユーザーが指定可能（デフォルト値あり）:
- **max_iterations**: 最大ループ回数（デフォルト: 5）
- **build_command**: ビルドコマンド（デフォルト: プロジェクト設定から自動検出）
- **test_command**: テストコマンド（デフォルト: プロジェクト設定から自動検出）

## ワークフロー

### 1. 初期確認

- 実装対象の要件を把握する
- ビルド/テストコマンドを特定する（package.json scripts, Makefile 等）
- 現在のテスト状態を確認する（既存テストが通るか）

### 2. 自律ループ

```
iteration = 0
while iteration < max_iterations:
  iteration++

  # Step 1: 実装
  - 要件に基づいてコードを変更する
  - （初回以降）前回のテスト失敗を分析し修正する

  # Step 2: ビルド
  - ビルドコマンドを実行する
  - 失敗 → エラーを読み、型エラー等を修正して Step 2 をリトライ

  # Step 3: テスト
  - テストコマンドを実行する
  - 全テスト通過 → ループ終了、Step 3へ
  - 失敗 → テスト出力を分析:
    - 期待値と実際の値の差分を確認
    - 自分の実装のどこが期待と異なるか特定
    - 次のイテレーションで修正
```

### 3. 結果報告

**テスト通過の場合**:
- 変更内容のサマリーを提示
- 何イテレーションで成功したか報告
- ユーザーの指示を待つ（コミット等）

**イテレーション上限到達の場合**:
- 以下を報告して停止:
  - 試行した内容と各イテレーションの結果
  - 残存するテスト失敗の内容
  - 根本原因の仮説
  - 推奨する次のアクション

## 制約

- **ループ中はユーザーに報告しない**: 成功またはリミット到達まで自律的に進む
- **既存テストを変更しない**: テストが間違っていると判断した場合はループを停止してユーザーに報告する
- **スコープ外の変更をしない**: テスト通過のために無関係なコードを変更しない
- **プロジェクトのルールに従う**: CLAUDE.md の制約（CSS変数保持等）はループ中も遵守する
