# Plan Validation Checklist

実装計画の品質を評価するための詳細チェックリスト。

## 前提条件

### 必須
- [ ] ExitPlanMode実行済み（Plan Mode終了後にこのスキルを実行）
- [ ] 計画ファイルが保存されている（~/.claude/plans/*.md または .claude/plans/*.md）

### オプション（外部レビューを使う場合）
- [ ] `/codex-review` スキルがインストール済み
- [ ] `/self-review` スキルがインストール済み
- [ ] Codex MCP設定済み（codex-review-mcp使用時）

## 論理的整合性

### ステップの明確性
- [ ] 各ステップの目的が明確に記述されている
- [ ] 「何を」「なぜ」「どのように」が明記されている
- [ ] 曖昧な表現（「適切に」「良い感じに」等）がない

### 依存関係
- [ ] ステップ間の依存関係が正しい順序になっている
- [ ] 前提条件が満たされてから次のステップに進んでいる
- [ ] 循環依存がない

### 検証の完全性
- [ ] 各ステップ後に結果を検証する手順がある
- [ ] 「〜するはず」「〜が動くはず」という仮定ではなく、検証方法が明記されている
- [ ] テスト実行・ビルド確認が含まれている

### エラーハンドリング
- [ ] 各ステップで起こりうる失敗シナリオが考慮されている
- [ ] 失敗時の対処方法が記載されている
- [ ] ロールバック手順がある（必要な場合）

## 完全性

### 必要なファイル操作
- [ ] 変更が必要なファイルがすべてリストアップされている
- [ ] 各ファイルの読み取りステップが含まれている
- [ ] 既存コードの理解ステップが含まれている

### テスト
- [ ] 既存テストの実行が計画されている
- [ ] 新規テストの追加が計画されている（新機能の場合）
- [ ] テストが失敗した場合の対応が記載されている

### エッジケース
- [ ] 想定外の入力値への対処が計画されている
- [ ] 境界条件（空文字列、null、最大値等）が考慮されている
- [ ] 並行処理・競合状態が考慮されている（該当する場合）

### ドキュメント
- [ ] README等のドキュメント更新が含まれている（必要な場合）
- [ ] コメント・JSDocの追加が含まれている（複雑なロジックの場合）
- [ ] CHANGELOG更新が含まれている（該当する場合）

## 実行可能性

### 具体性
- [ ] 各ステップが具体的で実行可能
- [ ] 使用するツール・コマンドが明記されている
- [ ] ファイルパス、関数名、変数名等が具体的に記載されている

### パーミッション
- [ ] ExitPlanModeのallowedPromptsが適切に設定されている
- [ ] 必要な権限が明記されている
- [ ] セキュリティリスクのあるコマンドが適切に制限されている

### 実装順序
- [ ] 段階的に実装できる順序になっている
- [ ] 各ステップ後に動作確認が可能
- [ ] 「一気に全部実装」ではなく、小さく分割されている

## 品質

### セキュリティ
- [ ] ハードコードされたシークレットがない
- [ ] 入力値の検証が計画されている
- [ ] SQLインジェクション、XSS等の脆弱性対策が含まれている
- [ ] 認証・認可の実装が適切（該当する場合）

### パフォーマンス
- [ ] N+1クエリ等のパフォーマンス問題が考慮されている
- [ ] 大量データの処理が適切に計画されている（該当する場合）
- [ ] 不要な再レンダリング・再計算が避けられている

### コーディング規約
- [ ] プロジェクトのコーディング規約に準拠
- [ ] Linter・Formatterの実行が含まれている
- [ ] 型安全性が維持されている（TypeScript等）

### 保守性
- [ ] 既存のアーキテクチャパターンに従っている
- [ ] 過度に複雑な実装になっていない
- [ ] 抽象化のレベルが適切

## デバッグガイドライン準拠（CLAUDE.md）

### エラーメッセージの確認
- [ ] エラーの**最初の部分**を確認する計画になっている
- [ ] `2>&1 | head -50` 等で全文を取得している
- [ ] `| tail` で最後だけ見るアンチパターンを避けている

### 根本原因分析
- [ ] 症状ではなく根本原因を特定する手順がある
- [ ] 5 Whysアプローチが含まれている（複雑なバグの場合）
- [ ] 動作していた設定を変更する前に、なぜ動かなくなったか分析している

### 最近の変更を疑う
- [ ] 「Task Nで動いていた → Task N+1で壊れた」場合、Task N+1のコードを疑っている
- [ ] git diff等で最近の変更を確認するステップがある

### 動作している設定を保護
- [ ] 動作していたビルドスクリプト・設定を変更していない（根拠がない限り）
- [ ] 変更が必要な場合、元の決定がなぜ間違っていたか記載されている

## プロジェクト固有

### アーキテクチャ整合性
- [ ] 既存のディレクトリ構成に従っている
- [ ] 既存の命名規則に従っている
- [ ] 依存関係グラフが単方向（循環依存なし）

### チーム規約
- [ ] PRテンプレートに従った説明が可能
- [ ] レビュアーが理解しやすい粒度
- [ ] ブランチ戦略に従っている

## スコープ管理

### 範囲の明確性
- [ ] 元のタスクの範囲内に収まっている
- [ ] 「ついでに」の改善が含まれていない
- [ ] 追加機能が勝手に盛り込まれていない

### 最小限の変更
- [ ] 必要最小限の変更に絞られている
- [ ] 関係ないコードのリファクタリングが含まれていない
- [ ] 不要なコメント・ドキュメント追加がない

## チェックリスト使用方法

### 計画作成時
1. 計画を書く
2. このチェックリストで自己チェック
3. 不足項目を計画に追加

### レビュー時（validate-planスキル実行時）
1. logic-validator実行
2. このチェックリストで手動確認
3. 外部レビュー（必要な場合）
4. 改善実施

### 優先順位

**必須（Blocking）:**
- 論理的整合性
- 検証の完全性
- エラーハンドリング
- セキュリティ

**推奨（Strongly Recommended）:**
- テスト
- エッジケース
- 実行可能性
- デバッグガイドライン準拠

**任意（Optional）:**
- ドキュメント（小規模変更の場合）
- パフォーマンス（問題が顕在化していない場合）
- チーム規約（個人プロジェクトの場合）

## 改善の判断基準

| チェック結果 | 判断 | アクション |
|------------|------|----------|
| 必須項目に✓なし | 計画不十分 | 計画を修正して再検証 |
| 推奨項目に✓なし | 要検討 | 理由を明確化して判断 |
| 任意項目に✓なし | OK | そのまま進めてよい |

## 関連リソース

- [troubleshooting.md](troubleshooting.md): よくある問題と対処
- `~/.claude/CLAUDE.md`: タスク完了プロトコル、デバッグガイドライン
- `~/.claude/rules/debugging.md`: 詳細なデバッグ手順
