---
name: verify-doc
description: Verify document self-containedness by having a context-free sub-agent explain its understanding. Use after writing specs, handoff docs, or any document that must be understood without conversation context.
context: inherit
---

# Verify Document Comprehensibility

文脈なしのサブエージェントにドキュメントを読ませ、理解を説明させることで、ドキュメントが自己完結的かを検証する。

## 原則

**「すべてを忘れて明日読んでも思い出せるか」をテストする。**

会話の中で暗黙に共有された文脈に依存していないか、第三者が初見で理解できるかを確認する。

## 引数

- **ファイルパス指定** (`/verify-doc path/to/file.md`): 指定ファイルを検証
- **引数なし** (`/verify-doc`): 直近で作成・編集したドキュメントを推定して検証

## 手順

### Step 1: 検証対象の特定

引数でファイルパスが指定されていればそれを使う。
指定がなければ、会話コンテキストから直近に Write/Edit したドキュメントファイル（.md）を特定する。

### Step 2: サブエージェントで理解度テスト

Task ツールで **haiku** モデルの `general-purpose` サブエージェントを起動する。

**重要**: サブエージェントには会話コンテキストを一切渡さない。ファイルパスと評価指示のみ。

```
Task({
  subagent_type: "general-purpose",
  model: "haiku",
  description: "Verify doc comprehensibility",
  prompt: `
以下のファイルを読んで、あなたの理解を説明してください。
このファイルだけを読んで、文脈なしで理解できるかの検証です。

ファイル: <検証対象ファイルパス>

以下の観点で説明してください:

1. **何を解決するものか**（1-2文）
2. **成果物は何か**（箇条書き）
3. **主要な設計判断とその理由**（箇条書き）
4. **全体フローを自分の言葉で説明**（箇条書き）
5. **読んで不明だった点・曖昧に感じた点**（あれば具体的に。なければ「なし」）

日本語で回答してください。簡潔に。
`
})
```

### Step 3: 結果の評価と報告

サブエージェントの回答を以下の基準で評価する:

| 判定 | 基準 |
|------|------|
| ✅ **自己完結** | 観点1-4が正確に理解され、不明点が「なし」 |
| ⚠️ **概ね理解可能** | 大筋は正しいが、一部不明点や誤解がある |
| ❌ **文脈依存** | 重要な要素を誤解、または不明点が多い |

**報告フォーマット**:

```markdown
## 文書検証結果: <ファイル名>

**判定**: ✅ / ⚠️ / ❌

### サブエージェントの理解
[サブエージェントの回答を要約]

### 検出された問題（⚠️/❌ の場合）
- [誤解された箇所とその原因]
- [不明と報告された箇所]

### 改善提案（⚠️/❌ の場合）
- [具体的な追記・修正の提案]
```

### Step 4: 修正の提案（問題がある場合）

⚠️ または ❌ の場合、文書のどこをどう改善すれば自己完結性が高まるかを具体的に提案する。
ユーザーが同意すれば、その場で Edit ツールで修正する。

## 適用場面

| 場面 | 重要度 |
|------|--------|
| 仕様書（spec）の作成後 | 高 — 次セッションで実装する前提 |
| `/task-handoff` 前のタスク記述 | 高 — 別セッションで実行する前提 |
| ADR（設計決定記録）の作成後 | 中 — 長期保存される文書 |
| `/session-memo` で保存したメモ | 低 — 軽量メモなので必須ではない |

## 設計判断

- **haiku モデルを使用**: 理解度テストにはコストの低いモデルで十分。高速かつ低コスト
- **context: inherit**: ファイルパス推定のために会話コンテキストを参照可能にする。ただしサブエージェントには渡さない
- **観点を固定**: 毎回同じ観点で評価することで、結果の一貫性と比較可能性を担保
