/**
 * Color Utilities
 * 
 * Provides consistent terminal colors for Superconnect output:
 * - figmaColor: Figma brand red (#ff6b6b)
 * - codeColor: Code blue (#2f9cf4)
 * - generatedColor: Generated purple (#b779ff)
 * - highlight: White highlight
 */

const chalk = require('chalk');

const figmaColor = (text) => chalk.hex('#ff6b6b')(text);
const codeColor = (text) => chalk.hex('#2f9cf4')(text);
const generatedColor = (text) => chalk.hex('#b779ff')(text);
const highlight = (text) => chalk.whiteBright(text);

module.exports = {
  figmaColor,
  codeColor,
  generatedColor,
  highlight
};
