---
name: digitalocean-teams
description: DigitalOcean Teams and Organizations for billing, access control, roles, and membership. Use when managing team structure, permissions, and organization-wide billing on DigitalOcean.
progressive_disclosure:
  entry_point:
    summary: "DigitalOcean Teams and Organizations for billing, access control, roles, and membership. Use when managing team structure, permissions, and organization-wide billing on DigitalOcean."
    when_to_use: "When working with version control, branches, or pull requests."
    quick_start: "1. Review the core concepts below. 2. Apply patterns to your use case. 3. Follow best practices for implementation."
---
# DigitalOcean Teams Skill

---
progressive_disclosure:
  entry_point:
    summary: "Teams and Organizations on DigitalOcean: membership, roles, permissions, and consolidated billing."
    when_to_use:
      - "When setting up teams or organizations"
      - "When managing roles and access permissions"
      - "When configuring billing and ownership"
    quick_start:
      - "Create a team and invite members"
      - "Assign roles and permissions"
      - "Configure security settings"
      - "Use organizations for consolidated billing"
  token_estimate:
    entry: 90-110
    full: 3200-4300
---

## Overview

Teams manage billing and infrastructure access on DigitalOcean. Organizations group teams for consolidated billing, payment, and invoicing.

## Teams

- Create teams for shared ownership and billing.
- Invite members and assign roles.
- Manage team settings and security.

## Organizations

- Group multiple teams under a single organization.
- Centralize billing, payment, and invoicing.

## Roles and Permissions

- Assign predefined roles for common access levels.
- Use custom roles when teams need tailored permissions.

## Security and Access

- Require secure sign-in and 2FA.
- Configure SSO if needed.
- Review access changes and membership activity.

## Team Management Workflow

- Create team and configure billing owners.
- Invite members and assign roles.
- Enable security policies.
- Review permissions regularly.

## Complementary Skills

When using this skill, consider these related skills (if deployed):

- **digitalocean-overview**: Platform onboarding and tooling.
- **digitalocean-management**: Projects and monitoring visibility.

*Note: Complementary skills are optional. This skill is fully functional without them.*

## Resources

**DigitalOcean Docs**:
- Teams: https://docs.digitalocean.com/platform/teams/
- Team roles: https://docs.digitalocean.com/platform/teams/roles/
- Team settings: https://docs.digitalocean.com/platform/teams/settings/
- Organizations: https://docs.digitalocean.com/platform/organizations/
- Accounts: https://docs.digitalocean.com/platform/accounts/
