---
name: vercel-ai
description: Vercel AI platform guidance covering AI SDK, AI Gateway, Vercel Agent, and MCP. Use when building AI-powered or agentic workloads on Vercel.
progressive_disclosure:
  entry_point:
    summary: "Vercel AI platform guidance covering AI SDK, AI Gateway, Vercel Agent, and MCP. Use when building AI-powered or agentic workloads on Vercel."
    when_to_use: "When working with vercel-ai or related functionality."
    quick_start: "1. Review the core concepts below. 2. Apply patterns to your use case. 3. Follow best practices for implementation."
---
# Vercel AI Skill

---
progressive_disclosure:
  entry_point:
    summary: "Vercel AI platform: AI SDK, AI Gateway, Vercel Agent, agent integrations, and MCP."
    when_to_use:
      - "When building AI-powered apps on Vercel"
      - "When routing model traffic through AI Gateway"
      - "When using Vercel Agent or MCP workflows"
    quick_start:
      - "Choose AI SDK, AI Gateway, or Agent"
      - "Configure models and routing"
      - "Secure keys and environment variables"
      - "Deploy and monitor usage"
  token_estimate:
    entry: 90-110
    full: 3600-4700
---

## Overview

Vercel AI capabilities include SDKs and services for building AI-enabled applications, model routing, and agent workflows.

## AI SDK

- Use the AI SDK to build AI-driven app features.

## AI Gateway

- Route model traffic through AI Gateway.
- Apply usage controls and monitoring.

## Vercel Agent

- Build and operate agentic workflows.
- Connect agent integrations as needed.

## MCP

- Use MCP integrations for AI tooling and workflows.

## Complementary Skills

When using this skill, consider these related skills (if deployed):

- **vercel-functions-runtime**: Functions and Edge execution for AI workloads.
- **vercel-storage-data**: Data stores for embeddings and artifacts.
- **vercel-observability**: Usage monitoring and debugging.

*Note: Complementary skills are optional. This skill is fully functional without them.*

## Resources

**Vercel Docs**:
- AI on Vercel: https://vercel.com/docs/ai
- AI Gateway: https://vercel.com/docs/ai-gateway
- AI SDK: https://vercel.com/docs/ai-sdk
- Vercel Agent: https://vercel.com/docs/agent
- Agent integrations: https://vercel.com/docs/agent-integrations
- MCP: https://vercel.com/docs/mcp
