---
name: vercel-observability
description: Vercel observability for Web Analytics, Speed Insights, logs, tracing, alerts, and observability tooling. Use when monitoring performance or debugging production behavior on Vercel.
progressive_disclosure:
  entry_point:
    summary: "Vercel observability for Web Analytics, Speed Insights, logs, tracing, alerts, and observability tooling. Use when monitoring performance or debugging production behavior on Vercel."
    when_to_use: "When working with vercel-observability or related functionality."
    quick_start: "1. Review the core concepts below. 2. Apply patterns to your use case. 3. Follow best practices for implementation."
---
# Vercel Observability Skill

---
progressive_disclosure:
  entry_point:
    summary: "Vercel observability: analytics, Speed Insights, logs, tracing, alerts, and performance monitoring."
    when_to_use:
      - "When monitoring application performance"
      - "When debugging production issues"
      - "When setting alerts for availability and errors"
    quick_start:
      - "Enable Web Analytics"
      - "Enable Speed Insights"
      - "Review logs and tracing"
      - "Configure alerts"
  token_estimate:
    entry: 90-110
    full: 3600-4700
---

## Overview

Vercel observability covers analytics, performance insights, and debugging tools for production workloads.

## Web Analytics

- Enable analytics for traffic and usage insights.

## Speed Insights

- Measure Core Web Vitals and performance metrics.
- Track real-world performance changes.

## Logs and Tracing

- Use logs for runtime errors and behavior.
- Use tracing for request performance and diagnostics.

## Alerts

- Configure alerts for operational thresholds.

## Complementary Skills

When using this skill, consider these related skills (if deployed):

- **vercel-deployments-builds**: Deployment visibility and rollback.
- **vercel-functions-runtime**: Function logs and runtime debugging.
- **vercel-networking-domains**: CDN and routing performance.

*Note: Complementary skills are optional. This skill is fully functional without them.*

## Resources

**Vercel Docs**:
- Analytics: https://vercel.com/docs/analytics
- Speed Insights: https://vercel.com/docs/speed-insights
- Logs: https://vercel.com/docs/logs
- Tracing: https://vercel.com/docs/tracing
- Alerts: https://vercel.com/docs/alerts
- Observability: https://vercel.com/docs/observability
