---
name: agile-coach
description: Expert agile coaching covering team transformation, agile frameworks, coaching techniques, organizational change, and continuous improvement.
version: 1.0.0
author: borghei
category: project-ops
tags: [agile, coaching, transformation, scrum, kanban]
---

# Agile Coach

Expert-level agile coaching for team and organizational transformation.

## Core Competencies

- Agile transformation
- Team coaching
- Framework implementation
- Organizational design
- Change management
- Facilitation
- Metrics and improvement
- Leadership coaching

## Agile Frameworks

### Framework Comparison

| Aspect | Scrum | Kanban | SAFe | LeSS |
|--------|-------|--------|------|------|
| Roles | SM, PO, Dev | Flexible | Many defined | SM, PO, Dev |
| Cadence | Fixed sprints | Continuous | PI Planning | Sprints |
| Planning | Sprint Planning | On-demand | PI Planning | Sprint Planning |
| Best For | Product dev | Operations | Enterprise | Multi-team |
| Change | End of sprint | Anytime | PI boundaries | Sprint |

### Framework Selection Guide

```
TEAM SIZE & COMPLEXITY MATRIX

                    Simple          Complex
Small (1-2 teams)   Kanban          Scrum
                    XP              Scrumban

Medium (3-8 teams)  Scrum@Scale     SAFe Essential
                    Nexus           LeSS

Large (9+ teams)    SAFe Portfolio  SAFe Full
                    Enterprise      Custom Hybrid
                    Kanban
```

## Team Coaching

### Coaching Stance

```
DIRECTIVE ←────────────────────────────→ NON-DIRECTIVE

Teaching    Advising    Coaching    Mentoring    Facilitating
   │           │           │            │             │
   ▼           ▼           ▼            ▼             ▼
"Do this"  "Consider"  "What do    "In my      "What does
           "this..."    you think?" experience" the team
                                                think?"
```

### Coaching Conversations

**GROW Model:**
```
G - GOAL
├── What do you want to achieve?
├── What would success look like?
└── By when do you want this?

R - REALITY
├── What is happening now?
├── What have you tried?
└── What obstacles exist?

O - OPTIONS
├── What could you do?
├── What else?
├── What if there were no constraints?
└── Which options interest you most?

W - WAY FORWARD
├── What will you do?
├── When will you do it?
├── What support do you need?
└── How will you know you've succeeded?
```

### Team Development Stages

```
TUCKMAN'S MODEL + COACHING APPROACH

FORMING
├── Behavior: Polite, tentative
├── Need: Direction, clarity
└── Coach: Guide, set expectations

STORMING
├── Behavior: Conflict, resistance
├── Need: Support, facilitation
└── Coach: Mediate, normalize

NORMING
├── Behavior: Collaboration emerging
├── Need: Reinforcement
└── Coach: Observe, reinforce

PERFORMING
├── Behavior: High productivity
├── Need: Stretch challenges
└── Coach: Step back, consult

ADJOURNING
├── Behavior: Completion
├── Need: Celebration, closure
└── Coach: Facilitate retrospective
```

## Agile Transformation

### Transformation Roadmap

```markdown
# Agile Transformation Roadmap

## Phase 1: Foundation (Months 1-3)
### Goals
- Establish leadership buy-in
- Create transformation team
- Assess current state

### Activities
- [ ] Executive alignment workshop
- [ ] Current state assessment
- [ ] Pilot team selection
- [ ] Coach onboarding
- [ ] Training program design

### Success Criteria
- Leadership committed
- Pilot teams identified
- Baseline metrics established

## Phase 2: Pilot (Months 4-6)
### Goals
- Launch pilot teams
- Learn and adapt
- Build internal capability

### Activities
- [ ] Pilot team launch
- [ ] Framework training
- [ ] Coaching sessions
- [ ] Retrospectives
- [ ] Success story documentation

### Success Criteria
- Pilot teams functioning
- Initial improvements visible
- Lessons learned captured

## Phase 3: Expand (Months 7-12)
### Goals
- Scale successful patterns
- Build communities
- Embed practices

### Activities
- [ ] Additional team launches
- [ ] Community of practice
- [ ] Coach development
- [ ] Process optimization
- [ ] Tool refinement

### Success Criteria
- Multiple teams agile
- Internal coaches active
- Sustainable practices

## Phase 4: Optimize (Months 13+)
### Goals
- Continuous improvement
- Organizational agility
- Business outcomes

### Activities
- [ ] Portfolio-level agility
- [ ] Cross-team coordination
- [ ] Metrics-driven improvement
- [ ] Innovation enablement

### Success Criteria
- Business agility achieved
- Self-sustaining improvement
```

### Maturity Assessment

```
AGILE MATURITY MODEL

Level 1: Initial
├── Ad-hoc processes
├── Hero-dependent
└── Limited visibility

Level 2: Repeatable
├── Basic Scrum/Kanban
├── Team-level practices
└── Some metrics

Level 3: Defined
├── Consistent practices
├── Cross-team coordination
└── Continuous improvement

Level 4: Managed
├── Quantitative management
├── Predictable outcomes
└── Business alignment

Level 5: Optimizing
├── Innovation culture
├── Market responsiveness
└── Organizational learning
```

### Assessment Questionnaire

| Dimension | Score (1-5) | Evidence |
|-----------|-------------|----------|
| Values & Mindset | | |
| Team Practices | | |
| Technical Excellence | | |
| Product Ownership | | |
| Leadership Support | | |
| Continuous Improvement | | |

## Facilitation Techniques

### Meeting Facilitation

**Retrospective Formats:**

```
FORMAT 1: Start-Stop-Continue
┌─────────────┬─────────────┬─────────────┐
│   START     │    STOP     │  CONTINUE   │
│             │             │             │
│ What should │ What should │ What's      │
│ we begin    │ we stop     │ working     │
│ doing?      │ doing?      │ well?       │
└─────────────┴─────────────┴─────────────┘

FORMAT 2: 4Ls
┌─────────────┬─────────────┐
│   LIKED     │   LEARNED   │
├─────────────┼─────────────┤
│   LACKED    │  LONGED FOR │
└─────────────┴─────────────┘

FORMAT 3: Sailboat
            ☀️ Sun (Goals)
               │
    💨 Wind ←──⛵──→ ⚓ Anchor
   (Helpers)    │    (Impediments)
               🪨 Rocks (Risks)
```

**Workshop Facilitation:**

```
WORKSHOP STRUCTURE

1. OPENING (10%)
├── Welcome, purpose
├── Agenda overview
└── Working agreements

2. DIVERGE (30%)
├── Generate ideas
├── Individual thinking
└── Capture all input

3. EXPLORE (20%)
├── Share perspectives
├── Discuss patterns
└── Deepen understanding

4. CONVERGE (30%)
├── Prioritize
├── Decide
└── Plan actions

5. CLOSE (10%)
├── Summarize outcomes
├── Assign actions
└── Gather feedback
```

### Conflict Resolution

```
CONFLICT RESOLUTION STEPS

1. ACKNOWLEDGE
├── Recognize the conflict exists
├── Create safe space
└── Set ground rules

2. UNDERSTAND
├── Hear all perspectives
├── Identify underlying needs
├── Separate positions from interests

3. EXPLORE
├── Generate options
├── Find common ground
└── Build on shared interests

4. AGREE
├── Define acceptable solution
├── Document agreements
└── Set follow-up plan
```

## Metrics & Measurement

### Agile Metrics Framework

```
OUTCOME METRICS (Business Value)
├── Customer satisfaction
├── Time to market
├── Revenue/value delivered
└── Market responsiveness

PROCESS METRICS (Flow)
├── Lead time
├── Cycle time
├── Throughput
└── Work in progress

QUALITY METRICS (Technical)
├── Defect rate
├── Technical debt
├── Test coverage
└── Deployment frequency

TEAM METRICS (Health)
├── Team happiness
├── Psychological safety
├── Engagement
└── Sustainability
```

### Metric Tracking

```
┌─────────────────────────────────────────────────────────────┐
│                  AGILE TEAM DASHBOARD                        │
├─────────────────────────────────────────────────────────────┤
│  Velocity          Cycle Time      Lead Time     Throughput  │
│  42 pts            3.2 days        8.5 days      12 items    │
│  vs Avg: +5%       vs Avg: -10%    vs Avg: -15%  vs Avg: +8% │
├─────────────────────────────────────────────────────────────┤
│  FLOW METRICS                                                │
│  WIP: 8 items      Blocked: 2      Queue Time: 1.2 days     │
├─────────────────────────────────────────────────────────────┤
│  QUALITY                                                     │
│  Escaped Defects: 3    Tech Debt: 12 items    Coverage: 82% │
├─────────────────────────────────────────────────────────────┤
│  TEAM HEALTH                                                 │
│  Happiness: 4.2/5      Safety: 4.0/5      Engagement: High  │
└─────────────────────────────────────────────────────────────┘
```

## Organizational Change

### Change Management

**ADKAR Model:**
```
A - AWARENESS
├── Why is change needed?
└── What are the risks of not changing?

D - DESIRE
├── What's in it for me?
└── What are the benefits?

K - KNOWLEDGE
├── How do we change?
└── What skills are needed?

A - ABILITY
├── Can we implement?
└── Do we have resources?

R - REINFORCEMENT
├── How do we sustain?
└── What prevents regression?
```

### Stakeholder Management

| Stakeholder | Influence | Interest | Strategy |
|-------------|-----------|----------|----------|
| Executives | High | Variable | Align to business goals |
| Middle Mgmt | High | Medium | Address concerns |
| Teams | Medium | High | Enable success |
| Customers | Medium | High | Show value |

## Community Building

### Community of Practice

```markdown
# Community of Practice Charter

## Purpose
[Why this community exists]

## Scope
- In scope: [Topics]
- Out of scope: [Not covered]

## Membership
- Open to: [Criteria]
- Expected participation: [Level]

## Activities
- Monthly meetups
- Knowledge sharing sessions
- Skill development
- Problem-solving workshops

## Leadership
- Facilitator: [Name]
- Rotating host
- Communication owner

## Success Metrics
- Participation rate
- Knowledge shared
- Problems solved
- Member satisfaction
```

### Knowledge Sharing

**Formats:**
- Lunch & Learn sessions
- Lightning talks
- Pair coaching
- Study groups
- Internal conferences
- Wiki/documentation
- Slack channels

## Reference Materials

- `references/frameworks.md` - Agile framework details
- `references/coaching_techniques.md` - Coaching methods
- `references/facilitation.md` - Meeting facilitation
- `references/transformation.md` - Transformation playbook

## Scripts

```bash
# Maturity assessment scorer
python scripts/maturity_scorer.py --assessment assessment.yaml

# Metrics dashboard generator
python scripts/metrics_dashboard.py --team "Team Alpha"

# Retrospective idea generator
python scripts/retro_format.py --format sailboat

# Transformation tracker
python scripts/transformation_tracker.py --phase pilot
```
