---
name: cmo-advisor
description: Marketing leadership advisor for CMOs on brand strategy, demand generation, marketing operations, growth marketing, and revenue marketing alignment.
version: 1.0.0
author: borghei
category: executive-leadership
tags: [marketing, brand, demand-gen, growth, revenue]
---

# CMO Advisor

Marketing leadership advisory for Chief Marketing Officers.

## Core Competencies

- Brand strategy and positioning
- Demand generation
- Marketing operations
- Growth marketing
- Revenue marketing alignment
- Content strategy
- Marketing technology
- Team building and leadership

## Marketing Strategy Framework

### Strategic Planning Process

**Phase 1: Situation Analysis**
- Market size and dynamics
- Competitive landscape
- Customer segmentation
- Current performance audit

**Phase 2: Strategy Definition**
- Target market prioritization
- Positioning and messaging
- Channel strategy
- Investment allocation

**Phase 3: Execution Planning**
- Campaign calendar
- Content roadmap
- Technology requirements
- Team and budget needs

**Phase 4: Measurement Framework**
- KPI definition
- Attribution model
- Reporting cadence
- Optimization triggers

### Marketing Budget Allocation

**By Function (B2B SaaS Typical):**
- Demand Generation: 35-45%
- Content & Brand: 15-20%
- Marketing Ops & Tech: 15-20%
- Events & Field: 10-15%
- People & Overhead: 15-20%

**By Funnel Stage:**
- Awareness: 20-25%
- Consideration: 30-35%
- Decision: 25-30%
- Retention/Expansion: 15-20%

## Brand Strategy

### Brand Architecture

**Brand Elements:**
1. **Purpose**: Why we exist
2. **Vision**: Where we're going
3. **Mission**: What we do
4. **Values**: How we operate
5. **Personality**: How we communicate
6. **Positioning**: How we're different

### Positioning Statement Template

```
For [target customer]
Who [statement of need or opportunity]
[Product name] is a [product category]
That [statement of key benefit]
Unlike [primary competitive alternative]
Our product [statement of primary differentiation]
```

### Messaging Framework

| Audience | Pain Point | Solution | Proof Point |
|----------|------------|----------|-------------|
| Buyer 1 | [Problem] | [How we help] | [Evidence] |
| Buyer 2 | [Problem] | [How we help] | [Evidence] |
| User 1 | [Problem] | [How we help] | [Evidence] |

## Demand Generation

### Funnel Metrics

**Top of Funnel:**
- Website visitors
- Content engagement
- Social reach
- Brand awareness

**Middle of Funnel:**
- MQLs generated
- Content downloads
- Webinar attendance
- Demo requests

**Bottom of Funnel:**
- SQLs accepted
- Opportunities created
- Pipeline influenced
- Revenue attributed

### Channel Performance Framework

| Channel | CAC | Volume | Quality | Scalability |
|---------|-----|--------|---------|-------------|
| Organic Search | $ | High | Medium | Medium |
| Paid Search | $$ | Medium | High | High |
| Social Organic | $ | Medium | Low | Medium |
| Social Paid | $$ | High | Medium | High |
| Content | $ | High | High | Medium |
| Events | $$$ | Low | High | Low |
| Partnerships | $$ | Medium | High | Medium |

### Campaign Planning Template

```
CAMPAIGN: [Name]
OBJECTIVE: [Specific goal]
AUDIENCE: [Target segment]
CHANNELS: [Distribution channels]
TIMELINE: [Start - End dates]
BUDGET: [Total investment]

KEY MESSAGES:
- Primary: [Main message]
- Secondary: [Supporting points]

SUCCESS METRICS:
- Leads: [Target]
- Pipeline: [Target]
- Cost per lead: [Target]

ASSETS REQUIRED:
- [ ] Landing page
- [ ] Email sequence
- [ ] Ad creative
- [ ] Content pieces
```

## Marketing Operations

### Tech Stack Categories

**Core Platform:**
- Marketing Automation (HubSpot, Marketo, Pardot)
- CRM Integration (Salesforce, HubSpot)
- Analytics (GA4, Mixpanel)

**Content & Creative:**
- CMS (WordPress, Webflow)
- Design (Figma, Canva)
- DAM (Bynder, Brandfolder)

**Advertising:**
- Ad Platforms (Google, LinkedIn, Meta)
- ABM (6sense, Demandbase)
- Retargeting (various)

**Intelligence:**
- Intent Data (Bombora, G2)
- Competitive Intel (Crayon, Klue)
- Attribution (Bizible, Dreamdata)

### Lead Management

**Lead Stages:**
1. Visitor (anonymous)
2. Known (identified)
3. Engaged (active interest)
4. MQL (marketing qualified)
5. SAL (sales accepted)
6. SQL (sales qualified)
7. Opportunity
8. Customer

**Lead Scoring Model:**

| Action | Points |
|--------|--------|
| Website visit | 1 |
| Content download | 5 |
| Email open | 1 |
| Email click | 3 |
| Webinar registration | 10 |
| Webinar attendance | 15 |
| Demo request | 25 |
| Pricing page visit | 10 |

**MQL Threshold**: 50 points

## Content Strategy

### Content Pillars

Define 3-5 content pillars aligned to:
- Target audience pain points
- Product differentiators
- Search opportunity
- Thought leadership goals

### Content Types by Funnel Stage

**Awareness:**
- Blog posts
- Social content
- Podcasts
- Industry reports

**Consideration:**
- Ebooks/guides
- Webinars
- Case studies
- Comparison guides

**Decision:**
- Product demos
- ROI calculators
- Customer testimonials
- Implementation guides

### Editorial Calendar

| Week | Topic | Format | Channel | Owner | Status |
|------|-------|--------|---------|-------|--------|
| 1 | [Topic] | Blog | Organic | [Name] | Draft |
| 2 | [Topic] | Webinar | Email | [Name] | Planning |

## Revenue Marketing Alignment

### SLA Between Marketing and Sales

**Marketing Commits:**
- Deliver X MQLs per month
- MQL to SQL conversion > Y%
- Lead response within Z hours
- Pipeline attribution target

**Sales Commits:**
- Follow up on MQLs within 24 hours
- Provide feedback on lead quality
- Update opportunity stages
- Share customer insights

### Attribution Model

**Multi-Touch Attribution:**
- First Touch: 30%
- Lead Creation: 20%
- Opportunity Creation: 30%
- Closed Won: 20%

**Reporting Cadence:**
- Daily: Campaign performance
- Weekly: Pipeline and conversion
- Monthly: Full funnel analysis
- Quarterly: Channel ROI review

## Team Structure

### Marketing Org by Stage

**Series A (5-10 people):**
- Head of Marketing
- Content/Brand
- Demand Gen
- Marketing Ops

**Series B (10-20 people):**
- CMO
- Director, Brand
- Director, Demand Gen
- Manager, Content
- Manager, Ops
- Individual contributors

**Series C+ (20+ people):**
- CMO
- VP Brand
- VP Demand Gen
- VP Revenue Marketing
- VP Marketing Ops
- Specialized teams

## Common Scenarios

### Scenario: Missed Pipeline Target

When marketing-sourced pipeline falls short:
1. Analyze conversion by stage
2. Identify drop-off points
3. Review lead quality feedback
4. Assess channel performance
5. Adjust tactics for next period
6. Communicate plan to leadership

### Scenario: Rebrand Initiative

When undertaking brand refresh:
1. Define scope and objectives
2. Conduct brand audit
3. Stakeholder research
4. Develop creative concepts
5. Test with target audience
6. Create rollout plan
7. Update all touchpoints
8. Launch and measure

### Scenario: New Market Entry

When expanding to new segment:
1. Market sizing and analysis
2. Competitive research
3. Buyer persona development
4. Messaging adaptation
5. Channel identification
6. Pilot campaign execution
7. Learn and scale

## Reference Materials

- `references/brand_guidelines.md` - Brand standards and usage
- `references/demand_gen_playbook.md` - Campaign execution guide
- `references/content_strategy.md` - Content planning framework
- `references/martech_stack.md` - Technology recommendations

## Scripts

```bash
# Campaign performance analyzer
python scripts/campaign_analyzer.py --campaign Q1-ABM

# Lead scoring calculator
python scripts/lead_scoring.py --leads leads.csv

# Content calendar generator
python scripts/content_calendar.py --pillars topics.yaml

# Attribution reporter
python scripts/attribution.py --period monthly
```
