---
name: customer-success-manager
description: Expert customer success covering onboarding, adoption, retention, expansion, health scoring, and customer advocacy.
version: 1.0.0
author: borghei
category: sales-success
tags: [customer-success, retention, adoption, expansion, nps]
---

# Customer Success Manager

Expert-level customer success for retention and growth.

## Core Competencies

- Customer onboarding
- Product adoption
- Retention strategies
- Expansion revenue
- Health scoring
- Risk management
- Customer advocacy
- Strategic planning

## Customer Lifecycle

```
ONBOARDING → ADOPTION → VALUE REALIZATION → EXPANSION → ADVOCACY

1. Onboarding (0-30 days)
   - Implementation
   - Training
   - Quick wins

2. Adoption (30-90 days)
   - Feature usage
   - Process integration
   - User enablement

3. Value Realization (90+ days)
   - ROI demonstration
   - Business outcomes
   - Success metrics

4. Expansion (ongoing)
   - Upsell opportunities
   - Cross-sell
   - User growth

5. Advocacy (ongoing)
   - References
   - Case studies
   - Referrals
```

## Onboarding

### Onboarding Checklist

```markdown
# Customer Onboarding: [Customer Name]

## Pre-Kickoff
- [ ] Account setup complete
- [ ] Key contacts identified
- [ ] Success criteria defined
- [ ] Implementation timeline agreed
- [ ] Resources allocated

## Week 1: Kickoff
- [ ] Kickoff meeting conducted
- [ ] Goals and milestones confirmed
- [ ] Training schedule set
- [ ] Communication channels established

## Week 2-4: Implementation
- [ ] Technical setup complete
- [ ] Data migration (if applicable)
- [ ] Integrations configured
- [ ] Initial users trained

## Week 4-8: Adoption
- [ ] Power users identified
- [ ] Workflow adoption started
- [ ] Early wins documented
- [ ] Feedback collected

## Handoff (Week 8)
- [ ] Onboarding review meeting
- [ ] Success metrics baseline
- [ ] Ongoing cadence established
- [ ] Escalation paths clear
```

### Success Plan Template

```markdown
# Success Plan: [Customer Name]

## Customer Overview
- Industry: [Industry]
- Company size: [Size]
- Contract value: $[X]
- Renewal date: [Date]

## Business Objectives
1. [Objective 1]: [Success metric]
2. [Objective 2]: [Success metric]
3. [Objective 3]: [Success metric]

## Key Stakeholders
| Name | Role | Engagement Level |
|------|------|------------------|
| [Name] | Executive Sponsor | [H/M/L] |
| [Name] | Day-to-day Contact | [H/M/L] |
| [Name] | End User | [H/M/L] |

## Milestones
| Milestone | Target Date | Status |
|-----------|-------------|--------|
| Go-live | [Date] | [Status] |
| 100 users active | [Date] | [Status] |
| First integration | [Date] | [Status] |

## Risk Factors
- [Risk 1]: [Mitigation]
- [Risk 2]: [Mitigation]

## Expansion Opportunities
- [Opportunity 1]: [Timeline]
- [Opportunity 2]: [Timeline]
```

## Health Scoring

### Health Score Components

```
HEALTH SCORE = (Product × 40%) + (Relationship × 30%) + (Outcomes × 30%)

PRODUCT (40%)
├── Login frequency: [0-10]
├── Feature adoption: [0-10]
├── Active users vs. licensed: [0-10]
└── Support tickets: [0-10]

RELATIONSHIP (30%)
├── Executive engagement: [0-10]
├── Meeting attendance: [0-10]
├── NPS score: [0-10]
└── Response time: [0-10]

OUTCOMES (30%)
├── Goals achieved: [0-10]
├── ROI demonstrated: [0-10]
└── Business impact: [0-10]

OVERALL HEALTH
├── 80-100: Healthy (Green)
├── 60-79: Needs Attention (Yellow)
└── 0-59: At Risk (Red)
```

### Health Dashboard

```
┌─────────────────────────────────────────────────────────────┐
│                 Customer Health - [Customer]                 │
├─────────────────────────────────────────────────────────────┤
│  Overall: 🟢 85          Last Updated: [Date]               │
├─────────────────────────────────────────────────────────────┤
│  Product: 88             │  Relationship: 80                │
│  ├── Logins: 9          │  ├── Exec engagement: 8          │
│  ├── Adoption: 8        │  ├── Meeting attendance: 7       │
│  ├── Active users: 9    │  ├── NPS: 9                      │
│  └── Tickets: 9         │  └── Response time: 8            │
├─────────────────────────────────────────────────────────────┤
│  Outcomes: 85                                                │
│  ├── Goals achieved: 8                                       │
│  ├── ROI demonstrated: 9                                     │
│  └── Business impact: 8                                      │
├─────────────────────────────────────────────────────────────┤
│  Risk Flags: None        │  Expansion: High potential       │
└─────────────────────────────────────────────────────────────┘
```

## Retention Strategies

### Risk Playbooks

**Low Engagement:**
1. Reach out to primary contact
2. Schedule training refresh
3. Share best practices
4. Connect with power users
5. Executive escalation if needed

**Low Adoption:**
1. Analyze usage data
2. Identify blockers
3. Customize training
4. Set adoption goals
5. Weekly check-ins

**Executive Change:**
1. Request introduction
2. Schedule value review
3. Refresh business case
4. Reset success metrics
5. Build new relationships

**Competitor Evaluation:**
1. Understand concerns
2. Demonstrate unique value
3. Involve executive sponsor
4. Offer strategic review
5. Negotiate if needed

### QBR Template

```markdown
# Quarterly Business Review: [Customer Name]

## Partnership Summary
- Customer since: [Date]
- Current ARR: $[X]
- Users: [X] active / [Y] licensed

## Quarter in Review

### Achievements
- [Achievement 1]
- [Achievement 2]

### Metrics
| Metric | Target | Actual | Trend |
|--------|--------|--------|-------|
| [Metric] | [Target] | [Actual] | ↑↓→ |

### Challenges
- [Challenge]: [Resolution]

## Value Delivered
- Time saved: [X] hours
- Cost reduction: $[Y]
- Other impact: [Description]

## Roadmap Preview
- [Upcoming feature 1]
- [Upcoming feature 2]

## Next Quarter Goals
1. [Goal 1]
2. [Goal 2]

## Discussion Items
- [Topic 1]
- [Topic 2]
```

## Expansion

### Expansion Signals

| Signal | Score | Action |
|--------|-------|--------|
| High adoption | +3 | Explore user expansion |
| New department interest | +3 | Schedule discovery |
| Feature requests | +2 | Position premium features |
| Executive engagement | +2 | Propose strategic review |
| Contract renewal | +2 | Bundle expansion |

### Expansion Conversation

```
1. VALUE RECAP
   "Over the past year, you've achieved..."

2. IDENTIFY GAPS
   "I've noticed some teams aren't using..."

3. PROPOSE SOLUTION
   "Based on your goals, I'd recommend..."

4. QUANTIFY IMPACT
   "This could save you X hours / $Y..."

5. NEXT STEPS
   "Would it make sense to schedule a demo?"
```

## Customer Advocacy

### Reference Program

```
TIER 1: Casual Reference
- Phone/video reference calls
- Brief email testimonials
- Review site ratings

TIER 2: Active Advocate
- Written case study
- Speaking at events
- Peer references

TIER 3: Champion
- Advisory board member
- Co-marketing campaigns
- Product roadmap input
```

### Case Study Template

```markdown
# Case Study: [Customer Name]

## Company Profile
- Industry: [Industry]
- Size: [Employees/Revenue]
- Location: [Location]

## Challenge
[What problem were they facing?]

## Solution
[How did our product help?]

## Implementation
[How was it rolled out?]

## Results
- [Metric 1]: [Result]
- [Metric 2]: [Result]
- [Metric 3]: [Result]

## Quote
> "[Customer quote about the impact]"
> — [Name], [Title], [Company]
```

## Reference Materials

- `references/onboarding.md` - Onboarding playbook
- `references/health_scoring.md` - Health score methodology
- `references/retention.md` - Retention strategies
- `references/expansion.md` - Expansion playbook

## Scripts

```bash
# Health score calculator
python scripts/health_score.py --customer "Customer Name"

# QBR generator
python scripts/qbr_generator.py --customer "Customer Name" --quarter Q4

# Risk analyzer
python scripts/risk_analyzer.py --portfolio customers.csv

# Renewal forecaster
python scripts/renewal_forecast.py --period Q1
```
