---
name: hr-business-partner
description: Expert HR business partnership covering talent strategy, organizational development, employee relations, and people analytics.
version: 1.0.0
author: borghei
category: hr-operations
tags: [hr, talent, org-development, employee-relations, people-analytics]
---

# HR Business Partner

Expert-level HR business partnership for organizational success.

## Core Competencies

- Talent strategy
- Organizational development
- Employee relations
- Performance management
- Compensation and benefits
- Workforce planning
- Change management
- People analytics

## Talent Strategy

### Workforce Planning

```markdown
# Workforce Plan: [Department/Function]

## Current State
- Headcount: [X]
- Open roles: [X]
- Attrition rate: [X]%
- Engagement score: [X]

## Future State (12 months)
- Target headcount: [X]
- Growth: [X]%
- Skills gaps: [List]

## Gap Analysis
| Role | Current | Needed | Gap | Action |
|------|---------|--------|-----|--------|
| [Role] | X | Y | Z | Hire/Train |

## Hiring Plan
| Quarter | Roles | Headcount | Budget |
|---------|-------|-----------|--------|
| Q1 | [Roles] | X | $Y |
| Q2 | [Roles] | X | $Y |

## Development Plan
| Skill Gap | Training | Timeline | Employees |
|-----------|----------|----------|-----------|
| [Skill] | [Program] | [Dates] | [Names] |

## Succession Plan
| Critical Role | Incumbent | Ready Now | 1-2 Years |
|---------------|-----------|-----------|-----------|
| [Role] | [Name] | [Name] | [Names] |
```

### Hiring Process

```
1. REQUISITION
   ├── Manager submits req
   ├── HRBP reviews and approves
   └── Finance approves budget

2. SOURCING
   ├── Job posting created
   ├── Sourcing strategy determined
   └── Recruiting begins

3. SCREENING
   ├── Resume review
   ├── Phone screen
   └── Skills assessment

4. INTERVIEWING
   ├── Hiring manager interview
   ├── Team interviews
   ├── Cross-functional interviews
   └── Executive interview (if senior)

5. SELECTION
   ├── Debrief meeting
   ├── Reference checks
   └── Offer approval

6. OFFER
   ├── Offer letter created
   ├── Negotiation (if any)
   └── Offer accepted

7. ONBOARDING
   ├── Pre-boarding prep
   ├── Day 1 orientation
   └── 30-60-90 day plan
```

## Performance Management

### Performance Cycle

```
Q1: Goal Setting
├── Company OKRs cascade
├── Individual goals set
└── Development goals set

Q2: Mid-Year Check-in
├── Progress review
├── Feedback exchange
└── Goal adjustment

Q3: Ongoing Feedback
├── 1:1 meetings
├── Real-time feedback
└── Development tracking

Q4: Year-End Review
├── Self-assessment
├── Manager assessment
├── Calibration
└── Compensation decisions
```

### Performance Review Template

```markdown
# Performance Review: [Employee Name]

## Review Period: [Dates]

## Goal Achievement

### Goal 1: [Goal]
- Target: [What was expected]
- Result: [What was achieved]
- Rating: Exceeds / Meets / Below

### Goal 2: [Goal]
...

## Competency Assessment

| Competency | Rating | Evidence |
|------------|--------|----------|
| [Competency 1] | 1-5 | [Examples] |
| [Competency 2] | 1-5 | [Examples] |

## Strengths
- [Strength 1]
- [Strength 2]

## Development Areas
- [Area 1]
- [Area 2]

## Overall Rating
[Rating with justification]

## Development Plan
| Goal | Action | Timeline | Support Needed |
|------|--------|----------|----------------|
| [Goal] | [Action] | [Date] | [Support] |

## Career Discussion
[Career aspirations and path]

## Manager Comments
[Overall assessment]

## Employee Comments
[Employee response]
```

### Calibration Process

```
1. PRE-CALIBRATION
   ├── Managers submit ratings
   ├── HR compiles data
   └── Identify outliers

2. CALIBRATION MEETING
   ├── Review rating distribution
   ├── Discuss outliers
   ├── Ensure consistency
   └── Document decisions

3. POST-CALIBRATION
   ├── Finalize ratings
   ├── Compensation recommendations
   └── Communication plan
```

## Employee Relations

### Issue Resolution Framework

```
1. LISTEN
   - Hear the concern fully
   - Take notes
   - Show empathy

2. INVESTIGATE
   - Gather facts
   - Interview relevant parties
   - Review documentation

3. ANALYZE
   - Identify root cause
   - Consider policy/legal implications
   - Evaluate options

4. RESOLVE
   - Determine appropriate action
   - Communicate decision
   - Implement resolution

5. FOLLOW UP
   - Check on outcome
   - Prevent recurrence
   - Document lessons
```

### Difficult Conversations

```
SITUATION: [Describe the situation]
BEHAVIOR: [Describe observed behavior]
IMPACT: [Explain the impact]
EXPECTATION: [State what needs to change]
RESULT: [Discuss consequences/support]
```

### Documentation Template

```markdown
# Employee Relations Documentation

## Case Information
- Employee: [Name]
- Manager: [Name]
- HRBP: [Name]
- Date Opened: [Date]
- Date Closed: [Date]

## Issue Summary
[Description of the issue]

## Investigation

### Facts Gathered
- [Fact 1]
- [Fact 2]

### Interviews Conducted
| Person | Date | Key Points |
|--------|------|------------|
| [Name] | [Date] | [Summary] |

### Documents Reviewed
- [Document 1]
- [Document 2]

## Analysis
[Analysis of the situation]

## Resolution
[Action taken]

## Follow-up
| Date | Action | Outcome |
|------|--------|---------|
| [Date] | [Action] | [Outcome] |
```

## People Analytics

### Key Metrics

**Headcount:**
- Total headcount
- Headcount by department
- Contractor ratio

**Attrition:**
- Voluntary turnover rate
- Involuntary turnover rate
- Regrettable turnover rate
- Turnover by tenure

**Hiring:**
- Time to fill
- Cost per hire
- Quality of hire
- Offer acceptance rate

**Engagement:**
- Employee NPS
- Engagement score
- Manager effectiveness
- Intent to stay

**Diversity:**
- Demographic representation
- Promotion rates by group
- Pay equity analysis

### Dashboard Template

```
┌─────────────────────────────────────────────────────────────┐
│                 People Dashboard - [Period]                  │
├─────────────────────────────────────────────────────────────┤
│  Headcount        Attrition           Hiring                │
│  1,234            12.5%               45 open roles         │
│  +5% YoY          -2% vs LY           32 days TTF           │
├─────────────────────────────────────────────────────────────┤
│  Engagement       Diversity           Compensation          │
│  78 eNPS          42% women           98% compa-ratio      │
│  +5 pts           +3% YoY             $145K avg salary      │
├─────────────────────────────────────────────────────────────┤
│  Trends                                                      │
│  [Line chart: Headcount over time]                          │
│  [Bar chart: Turnover by department]                        │
└─────────────────────────────────────────────────────────────┘
```

## Compensation

### Compensation Philosophy

```markdown
# Compensation Philosophy

## Market Positioning
- Target: [50th/75th percentile]
- Comparison group: [Peer companies]

## Pay Components
- Base salary: [X]%
- Variable/Bonus: [X]%
- Equity: [X]%

## Pay Decisions Based On
- Role and level
- Performance
- Market data
- Internal equity

## Review Frequency
- Annual merit cycle
- Promotion adjustments
- Market adjustments as needed
```

### Offer Approval Process

```
1. Recruiter determines initial offer
2. Hiring manager reviews and approves
3. HRBP reviews for equity/budget
4. Finance approves (if above threshold)
5. Offer extended to candidate
```

## Reference Materials

- `references/talent_planning.md` - Workforce planning guide
- `references/performance.md` - Performance management
- `references/employee_relations.md` - ER best practices
- `references/compensation.md` - Comp philosophy and guidelines

## Scripts

```bash
# Workforce planning calculator
python scripts/workforce_plan.py --current headcount.csv --growth 0.2

# Attrition analyzer
python scripts/attrition_analyzer.py --data terminations.csv

# Compensation analyzer
python scripts/comp_analyzer.py --roles roles.csv --market market_data.csv

# Engagement survey analyzer
python scripts/engagement_analyzer.py --survey survey_results.csv
```
