---
name: operations-manager
description: Expert operations management covering process optimization, operational efficiency, resource management, and continuous improvement.
version: 1.0.0
author: borghei
category: hr-operations
tags: [operations, efficiency, process, optimization, management]
---

# Operations Manager

Expert-level operations management for organizational efficiency.

## Core Competencies

- Process optimization
- Resource management
- Workflow design
- Performance management
- Vendor management
- Capacity planning
- Quality assurance
- Cost optimization

## Operations Framework

### Operations Model

```
STRATEGY → PLANNING → EXECUTION → MONITORING → IMPROVEMENT
     │          │           │           │            │
     ▼          ▼           ▼           ▼            ▼
 Define     Resource     Daily       KPIs        Kaizen
 Goals      Allocation   Operations  Dashboards  Projects
 Metrics    Scheduling   Workflow    Reviews     Innovation
 Targets    Budgeting    Support     Audits      Automation
```

### Operations Maturity

```
LEVEL 1: Reactive
├── Ad-hoc processes
├── Hero-dependent
├── Crisis management
└── Limited visibility

LEVEL 2: Managed
├── Documented processes
├── Basic metrics
├── Standard procedures
└── Some automation

LEVEL 3: Defined
├── Consistent processes
├── Performance tracking
├── Cross-functional coordination
└── Continuous improvement

LEVEL 4: Measured
├── Data-driven decisions
├── Predictive analytics
├── Optimized workflows
└── Proactive management

LEVEL 5: Optimized
├── Self-optimizing systems
├── Innovation culture
├── Industry-leading efficiency
└── Strategic competitive advantage
```

## Process Management

### Process Documentation

```markdown
# Process Document: [Process Name]

## Overview
- Process Owner: [Name]
- Department: [Department]
- Frequency: [How often]
- Last Updated: [Date]

## Purpose
[Why this process exists]

## Scope
- Starts: [Trigger/Input]
- Ends: [Outcome/Output]
- In scope: [What's included]
- Out of scope: [What's excluded]

## Process Flow

### Step 1: [Step Name]
- Owner: [Role]
- Input: [What's needed]
- Action: [What to do]
- Output: [Result]
- Time: [Duration]

### Step 2: [Step Name]
...

## Decision Points
| Decision | Criteria | Yes Path | No Path |
|----------|----------|----------|---------|
| [Decision] | [Criteria] | [Step X] | [Step Y] |

## Systems/Tools
- [System 1]: [Purpose]
- [System 2]: [Purpose]

## Metrics
| Metric | Target | Current |
|--------|--------|---------|
| Cycle time | [X] hours | |
| Error rate | <[X]% | |
| Volume | [X]/day | |

## Exceptions
- [Exception 1]: [How to handle]
- [Exception 2]: [How to handle]

## Related Documents
- [Document 1]
- [Document 2]
```

### Process Flowchart

```
START
  │
  ▼
┌──────────────────┐
│ Receive Request  │
└────────┬─────────┘
         │
         ▼
    ┌─────────┐
    │ Valid?  │──No──→ Reject & Notify
    └────┬────┘
         │Yes
         ▼
┌──────────────────┐
│ Process Request  │
└────────┬─────────┘
         │
         ▼
    ┌─────────┐
    │Approved?│──No──→ Escalate
    └────┬────┘
         │Yes
         ▼
┌──────────────────┐
│ Execute Action   │
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Notify Requester │
└────────┬─────────┘
         │
         ▼
       END
```

### Process Improvement

```
LEAN SIX SIGMA: DMAIC

D - DEFINE
├── Problem statement
├── Project scope
├── Voice of customer
└── Project charter

M - MEASURE
├── Current performance
├── Data collection
├── Process mapping
└── Baseline metrics

A - ANALYZE
├── Root cause analysis
├── Data analysis
├── Gap identification
└── Hypothesis testing

I - IMPROVE
├── Solution design
├── Pilot testing
├── Implementation plan
└── Change management

C - CONTROL
├── Control plan
├── Documentation
├── Training
└── Monitoring
```

## Resource Management

### Capacity Planning

```
CAPACITY PLANNING FRAMEWORK

DEMAND ANALYSIS
├── Historical volume
├── Trend analysis
├── Seasonality
├── Growth projections
└── Special events

CAPACITY CALCULATION
├── Available capacity
│   └── FTE × Hours × Productivity
├── Required capacity
│   └── Volume × Time per unit
└── Gap analysis
    └── Required - Available

PLANNING HORIZONS
├── Daily: Staff scheduling
├── Weekly: Workload balancing
├── Monthly: Hiring/temp staff
├── Quarterly: Training/cross-training
└── Annual: Strategic workforce planning
```

### Resource Allocation

```
┌─────────────────────────────────────────────────────────────────┐
│              RESOURCE ALLOCATION - [Week]                        │
├─────────────────────────────────────────────────────────────────┤
│  Team Capacity: 400 hours    Allocated: 380 hours (95%)         │
├─────────────────────────────────────────────────────────────────┤
│  BY PROJECT                                                      │
│  Project A: 120 hrs  [████████████░░░░░░░░]  30%                │
│  Project B: 100 hrs  [██████████░░░░░░░░░░]  25%                │
│  Project C: 80 hrs   [████████░░░░░░░░░░░░]  20%                │
│  BAU Work: 60 hrs    [██████░░░░░░░░░░░░░░]  15%                │
│  Buffer: 20 hrs      [██░░░░░░░░░░░░░░░░░░]  5%                 │
├─────────────────────────────────────────────────────────────────┤
│  BY TEAM MEMBER                                                  │
│  Alice: 40/40 hrs (100%)   Bob: 38/40 hrs (95%)                 │
│  Carol: 42/40 hrs (105%)   Dave: 35/40 hrs (88%)                │
└─────────────────────────────────────────────────────────────────┘
```

### Scheduling

```markdown
# Shift Schedule Template

## Week of: [Date]

| Shift | Mon | Tue | Wed | Thu | Fri | Sat | Sun |
|-------|-----|-----|-----|-----|-----|-----|-----|
| Early (6a-2p) | A,B | A,B | A,C | B,C | A,C | B | A |
| Day (9a-5p) | C,D,E | C,D,E | D,E | A,D,E | B,D,E | C,D | B,C |
| Late (2p-10p) | F,G | F,G | F,G | F,G | F,G | E,F | D,E |
| Night (10p-6a) | H | H | H | H | H | G | F |

## Coverage Requirements
| Time | Min Staff | Optimal |
|------|-----------|---------|
| 6a-9a | 2 | 3 |
| 9a-2p | 4 | 6 |
| 2p-6p | 5 | 7 |
| 6p-10p | 3 | 4 |
| 10p-6a | 1 | 2 |
```

## Performance Management

### Operational Metrics

```
┌─────────────────────────────────────────────────────────────────┐
│              OPERATIONS DASHBOARD                                │
├─────────────────────────────────────────────────────────────────┤
│  Throughput       Cycle Time       Quality          Cost        │
│  1,250/day        4.2 hours        98.5%            $12.40/unit │
│  +8% vs Target    -15% vs LM       +0.5% vs Target  -5% vs LM   │
├─────────────────────────────────────────────────────────────────┤
│  EFFICIENCY METRICS                                              │
│  Utilization: 87%    Productivity: 92%    On-time: 95%         │
├─────────────────────────────────────────────────────────────────┤
│  VOLUME TREND                                                    │
│  [Line chart showing daily/weekly volumes]                      │
├─────────────────────────────────────────────────────────────────┤
│  TEAM PERFORMANCE                                                │
│  Team A: 98% SLA    Team B: 95% SLA    Team C: 97% SLA         │
└─────────────────────────────────────────────────────────────────┘
```

### KPI Framework

| Category | Metric | Formula | Target |
|----------|--------|---------|--------|
| Efficiency | Utilization | Active time / Available time | 85%+ |
| Productivity | Output per FTE | Units / FTE hours | Varies |
| Quality | First-pass yield | Good units / Total | 95%+ |
| Speed | Cycle time | End time - Start time | Varies |
| Cost | Cost per unit | Total cost / Units | Varies |
| Customer | CSAT | Satisfied / Total responses | 90%+ |

### Performance Review

```markdown
# Operations Performance Review

## Period: [Month/Quarter]

## Summary
[Executive summary of performance]

## Key Metrics Performance

| Metric | Target | Actual | Variance | Status |
|--------|--------|--------|----------|--------|
| Throughput | 1,200/day | 1,250 | +4.2% | 🟢 |
| Quality | 98% | 98.5% | +0.5% | 🟢 |
| Cycle Time | 5 hrs | 4.2 hrs | -16% | 🟢 |
| Cost/Unit | $13.00 | $12.40 | -4.6% | 🟢 |
| SLA | 95% | 93% | -2% | 🟡 |

## Wins
- [Achievement 1]
- [Achievement 2]

## Challenges
- [Challenge 1]: [Impact and action]
- [Challenge 2]: [Impact and action]

## Improvement Initiatives

| Initiative | Status | Impact |
|------------|--------|--------|
| [Initiative 1] | In Progress | [Impact] |
| [Initiative 2] | Complete | [Impact] |

## Next Period Focus
- [Priority 1]
- [Priority 2]
```

## Vendor Management

### Vendor Evaluation

```markdown
# Vendor Scorecard: [Vendor Name]

## Overview
- Vendor: [Name]
- Category: [Service/Product]
- Contract Value: $[Amount]
- Contract Period: [Dates]

## Performance Metrics

### Quality (Weight: 30%)
| Metric | Target | Actual | Score |
|--------|--------|--------|-------|
| Defect rate | <1% | 0.5% | 5/5 |
| First-pass acceptance | >95% | 97% | 5/5 |

### Delivery (Weight: 25%)
| Metric | Target | Actual | Score |
|--------|--------|--------|-------|
| On-time delivery | >98% | 96% | 4/5 |
| Lead time | <5 days | 4.5 days | 5/5 |

### Cost (Weight: 20%)
| Metric | Target | Actual | Score |
|--------|--------|--------|-------|
| Price vs market | Within 5% | +2% | 4/5 |
| Invoice accuracy | >99% | 99.5% | 5/5 |

### Service (Weight: 15%)
| Metric | Target | Actual | Score |
|--------|--------|--------|-------|
| Response time | <24 hrs | 18 hrs | 5/5 |
| Issue resolution | <48 hrs | 36 hrs | 5/5 |

### Relationship (Weight: 10%)
| Metric | Target | Actual | Score |
|--------|--------|--------|-------|
| Communication | Good | Excellent | 5/5 |
| Flexibility | Good | Good | 4/5 |

## Overall Score: 4.6/5

## Recommendations
- [Recommendation 1]
- [Recommendation 2]
```

### Contract Management

```
CONTRACT LIFECYCLE

PLANNING
├── Needs assessment
├── Requirements definition
├── Market research
└── Budget approval

PROCUREMENT
├── RFP development
├── Vendor evaluation
├── Negotiation
└── Contract award

EXECUTION
├── Onboarding
├── Service delivery
├── Performance monitoring
└── Issue management

RENEWAL/EXIT
├── Performance review
├── Renewal negotiation
├── Transition planning
└── Contract close-out
```

## Continuous Improvement

### Improvement Framework

```
PDCA CYCLE

PLAN
├── Identify opportunity
├── Analyze current state
├── Set improvement goal
└── Develop action plan

DO
├── Implement on small scale
├── Document observations
├── Collect data
└── Note issues

CHECK
├── Analyze results
├── Compare to goals
├── Identify gaps
└── Root cause analysis

ACT
├── Standardize if successful
├── Scale implementation
├── Document learnings
└── Identify next improvements
```

### Kaizen Events

```markdown
# Kaizen Event: [Topic]

## Event Details
- Date: [Date]
- Duration: [X] days
- Facilitator: [Name]
- Team: [Names]

## Problem Statement
[What problem are we solving?]

## Current State
- Process: [Description]
- Metrics: [Current performance]
- Pain points: [Issues]

## Target State
- Goal: [What we want to achieve]
- Metrics: [Target performance]
- Benefits: [Expected outcomes]

## Root Cause Analysis
[5 Whys or Fishbone results]

## Solutions Implemented
| Solution | Owner | Status |
|----------|-------|--------|
| [Solution 1] | [Name] | Complete |
| [Solution 2] | [Name] | In Progress |

## Results
| Metric | Before | After | Improvement |
|--------|--------|-------|-------------|
| [Metric 1] | [X] | [Y] | [%] |

## Sustainability Plan
- Standard work documented
- Training completed
- Metrics in place
- Review schedule set
```

## Cost Management

### Cost Analysis

```
COST BREAKDOWN STRUCTURE

DIRECT COSTS
├── Labor
│   ├── Wages: $X
│   ├── Benefits: $X
│   └── Overtime: $X
├── Materials
│   ├── Raw materials: $X
│   └── Supplies: $X
└── Equipment
    ├── Depreciation: $X
    └── Maintenance: $X

INDIRECT COSTS
├── Overhead
│   ├── Facilities: $X
│   ├── Utilities: $X
│   └── Insurance: $X
└── Administrative
    ├── Management: $X
    └── Support: $X

TOTAL COST: $X
COST PER UNIT: $X
```

### Budget Management

```
┌─────────────────────────────────────────────────────────────────┐
│              OPERATIONS BUDGET - [Year]                          │
├─────────────────────────────────────────────────────────────────┤
│  Annual Budget: $2.5M    YTD Spend: $1.8M    Remaining: $0.7M  │
├─────────────────────────────────────────────────────────────────┤
│  CATEGORY BREAKDOWN                                              │
│  Labor: $1.5M (60%)      [████████████░░░░░░░░] 70% spent      │
│  Materials: $0.5M (20%)  [██████████░░░░░░░░░░] 68% spent      │
│  Equipment: $0.3M (12%)  [████████████████░░░░] 85% spent      │
│  Other: $0.2M (8%)       [██████████████░░░░░░] 75% spent      │
├─────────────────────────────────────────────────────────────────┤
│  VARIANCE ANALYSIS                                               │
│  On track: Labor, Materials    Over: Equipment (+$15K)         │
│  Under: Other (-$10K)          Net Variance: +$5K (0.2%)       │
└─────────────────────────────────────────────────────────────────┘
```

## Reference Materials

- `references/process_design.md` - Process design principles
- `references/lean_operations.md` - Lean methodology
- `references/vendor_management.md` - Vendor management guide
- `references/cost_optimization.md` - Cost reduction strategies

## Scripts

```bash
# Process analyzer
python scripts/process_analyzer.py --process order_fulfillment

# Capacity planner
python scripts/capacity_planner.py --forecast demand.csv --staff team.csv

# Cost calculator
python scripts/cost_calculator.py --data operations.csv

# Vendor scorecard generator
python scripts/vendor_scorecard.py --vendor "Vendor Name"
```
