---
name: program-manager
description: Expert program management covering multi-project coordination, portfolio governance, strategic alignment, and cross-functional leadership.
version: 1.0.0
author: borghei
category: project-ops
tags: [program, portfolio, governance, strategic, coordination]
---

# Program Manager

Expert-level program management for complex multi-project initiatives.

## Core Competencies

- Program planning
- Portfolio governance
- Cross-project coordination
- Strategic alignment
- Stakeholder management
- Resource optimization
- Risk management
- Benefits realization

## Program Structure

### Program Hierarchy

```
PORTFOLIO
├── Strategic alignment
├── Investment decisions
└── Resource allocation
    │
    ▼
PROGRAM
├── Benefit realization
├── Cross-project coordination
└── Governance
    │
    ▼
PROJECTS
├── Deliverables
├── Timeline
└── Budget
    │
    ▼
WORKSTREAMS
├── Tasks
├── Activities
└── Resources
```

### Program Organization

```
┌─────────────────────────────────────────────────────────────────┐
│                       STEERING COMMITTEE                         │
│            Strategic decisions, escalations, funding             │
├─────────────────────────────────────────────────────────────────┤
│                        PROGRAM BOARD                             │
│         Governance, progress review, issue resolution           │
├─────────────────────────────────────────────────────────────────┤
│                      PROGRAM MANAGER                             │
│      Coordination, planning, reporting, stakeholder mgmt        │
├───────────────┬───────────────┬───────────────┬─────────────────┤
│   Project 1   │   Project 2   │   Project 3   │   Project N     │
│   PM: [Name]  │   PM: [Name]  │   PM: [Name]  │   PM: [Name]    │
└───────────────┴───────────────┴───────────────┴─────────────────┘
```

## Program Planning

### Program Charter

```markdown
# Program Charter: [Program Name]

## Executive Summary
[One paragraph describing the program]

## Business Case

### Problem Statement
[What problem are we solving?]

### Strategic Alignment
- Strategic objective: [Objective]
- Business priority: [Priority level]

### Expected Benefits
| Benefit | Type | Measure | Target |
|---------|------|---------|--------|
| Revenue increase | Financial | $ | $5M/year |
| Efficiency gain | Operational | Time | 30% reduction |
| Customer satisfaction | Strategic | NPS | +15 points |

### Investment
- Total budget: $[X]M
- Duration: [X] months
- FTE: [X] resources

### ROI Analysis
- NPV: $[X]M
- IRR: [X]%
- Payback: [X] months

## Scope

### In Scope
- [Deliverable/capability 1]
- [Deliverable/capability 2]

### Out of Scope
- [Explicitly excluded item 1]
- [Explicitly excluded item 2]

### Key Assumptions
- [Assumption 1]
- [Assumption 2]

### Constraints
- [Constraint 1]
- [Constraint 2]

## Program Structure

### Projects
| Project | Description | Owner | Duration |
|---------|-------------|-------|----------|
| Project 1 | [Description] | [PM] | Q1-Q2 |
| Project 2 | [Description] | [PM] | Q2-Q3 |

### Dependencies
| From | To | Type | Risk |
|------|----|------|------|
| Project 1 | Project 2 | Finish-Start | High |

## Governance

### Steering Committee
| Name | Role | Authority |
|------|------|-----------|
| [Name] | Executive Sponsor | Final decisions |
| [Name] | Business Owner | Requirements |

### Decision Rights
- Budget changes >$X: Steering Committee
- Scope changes: Program Board
- Schedule changes <2 weeks: Program Manager

### Meeting Cadence
- Steering Committee: Monthly
- Program Board: Bi-weekly
- Project Sync: Weekly

## Success Criteria
- [Criterion 1 with measurable target]
- [Criterion 2 with measurable target]

## Approvals
| Role | Name | Signature | Date |
|------|------|-----------|------|
| Sponsor | | | |
| Business Owner | | | |
```

### Program Roadmap

```
PROGRAM ROADMAP: [Name]

2024
Q1                  Q2                  Q3                  Q4
├─────────────────────────────────────────────────────────────────┤

PROJECT 1: Foundation
[████████████████████]
├── Phase 1: Design ──┤── Phase 2: Build ─┤

PROJECT 2: Implementation
          [████████████████████████████████]
          ├── Phase 1 ────┤── Phase 2 ────┤── Phase 3 ────┤

PROJECT 3: Integration
                              [████████████████████]
                              ├── Build ──┤── Test ──┤── Deploy ─┤

MILESTONES
    M1 ◆              M2 ◆               M3 ◆              M4 ◆
    Design            MVP                Beta              Launch
    Complete          Ready              Release           Complete

BENEFITS REALIZATION
                                              [Benefit 1 starts]
                                                    [Benefit 2 starts]
```

### Resource Plan

```
RESOURCE ALLOCATION

Role          Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec
─────────────────────────────────────────────────────────────────
Program Mgr   [█████████████████████████████████████████████████]
Architect     [████████████████████████]
Dev Lead      [██████████████████████████████████████]
Developers    [█████████████] [████████████████████████████████]
QA Lead               [████████████████████████████████████████]
QA Engineers              [██████████████████████████████████████]
BA            [████████████████████]        [████████████████]

SUMMARY
Total FTE:    5   7   10  12  12  12  12  10  8   6   4   2
Budget/mo:    $   $   $   $   $   $   $   $   $   $   $   $
```

## Cross-Project Coordination

### Dependency Management

```
DEPENDENCY MATRIX

              Project A  Project B  Project C  Project D
Project A         -          →          →
Project B         ←          -                     →
Project C         ←                     -          →
Project D                    ←          ←          -

Legend:
→ = Provides dependency to
← = Receives dependency from

CRITICAL PATH
Project A (Design) → Project B (API) → Project C (Integration) → Project D (Launch)
           M1              M2                  M3                    M4
```

### Integration Points

| Integration | Projects | Interface | Owner | Risk |
|-------------|----------|-----------|-------|------|
| API Contract | A → B | REST API | Team B | Medium |
| Data Migration | B → C | ETL | Team C | High |
| SSO | A, B, C | SAML | Team A | Low |

## Governance

### Program Dashboard

```
┌─────────────────────────────────────────────────────────────────┐
│              PROGRAM STATUS DASHBOARD                            │
├─────────────────────────────────────────────────────────────────┤
│  Program: Digital Transformation    Status: 🟡 At Risk          │
│  Sponsor: [Name]                    Phase: Execution             │
├─────────────────────────────────────────────────────────────────┤
│  OVERALL HEALTH                                                  │
│  Schedule: 🟡 -2 weeks    Budget: 🟢 92%    Scope: 🟢 On Track  │
│  Quality: 🟢 Meets std    Risk: 🟡 3 High   Resources: 🟢 Stable│
├─────────────────────────────────────────────────────────────────┤
│  PROJECT STATUS                                                  │
│  Project A: 🟢 Complete   Project B: 🟡 At Risk                 │
│  Project C: 🟢 On Track   Project D: 🔵 Not Started             │
├─────────────────────────────────────────────────────────────────┤
│  KEY METRICS                                                     │
│  Milestones: 4/8 (50%)   Deliverables: 12/20 (60%)             │
│  Benefits: $1.2M realized  Issues: 5 open (2 critical)         │
├─────────────────────────────────────────────────────────────────┤
│  UPCOMING MILESTONES                                             │
│  M5: Beta Release - Feb 15 (🟡 At Risk)                         │
│  M6: UAT Complete - Mar 01 (🟢 On Track)                        │
└─────────────────────────────────────────────────────────────────┘
```

### Status Reporting

```markdown
# Program Status Report

## Report Period: [Date Range]

## Executive Summary
[2-3 sentence summary of program status]

## Overall Status: 🟢🟡🔴

### Health Indicators
| Dimension | Status | Trend | Commentary |
|-----------|--------|-------|------------|
| Schedule | 🟡 | → | 2 weeks behind, recovery plan in place |
| Budget | 🟢 | ↑ | 8% under budget |
| Scope | 🟢 | → | No changes this period |
| Quality | 🟢 | → | All quality gates passed |
| Risk | 🟡 | ↓ | 1 new high risk identified |

## Project Summaries
| Project | Status | % Complete | Next Milestone |
|---------|--------|------------|----------------|
| Project A | 🟢 | 100% | Complete |
| Project B | 🟡 | 65% | API Delivery (Feb 10) |
| Project C | 🟢 | 40% | Integration Start (Feb 20) |

## Key Accomplishments
- [Accomplishment 1]
- [Accomplishment 2]

## Key Issues
| Issue | Impact | Owner | Target Date |
|-------|--------|-------|-------------|
| [Issue] | [Impact] | [Owner] | [Date] |

## Key Risks
| Risk | Probability | Impact | Mitigation |
|------|-------------|--------|------------|
| [Risk] | High | High | [Action] |

## Decisions Required
| Decision | Options | Recommendation | Deadline |
|----------|---------|----------------|----------|
| [Decision] | [Options] | [Rec] | [Date] |

## Next Period Focus
- [Priority 1]
- [Priority 2]
```

### Escalation Matrix

| Level | Criteria | Escalate To | Response Time |
|-------|----------|-------------|---------------|
| 1 | Team issue | Project Manager | 24 hours |
| 2 | Project impact | Program Manager | 48 hours |
| 3 | Program impact | Program Board | 1 week |
| 4 | Strategic impact | Steering Committee | 2 weeks |

## Risk Management

### Program Risk Register

```markdown
# Program Risk Register

| ID | Risk | Category | Probability | Impact | Score | Owner | Mitigation | Status |
|----|------|----------|-------------|--------|-------|-------|------------|--------|
| R1 | Key resource departure | Resource | Medium | High | 12 | PM | Cross-training, documentation | Open |
| R2 | Integration delays | Technical | High | High | 16 | Tech Lead | Early integration testing | Monitoring |
| R3 | Scope creep | Scope | Medium | Medium | 9 | PM | Change control process | Open |
| R4 | Vendor delivery | External | Low | High | 8 | PM | Contract penalties, alternatives | Open |

## Risk Heat Map

           │ Low (1-3) │ Medium (4-6) │ High (7-9)
───────────┼───────────┼──────────────┼───────────
High       │           │      R3      │   R1, R2
Impact     │           │              │
───────────┼───────────┼──────────────┼───────────
Medium     │     R4    │              │
Impact     │           │              │
───────────┼───────────┼──────────────┼───────────
Low        │           │              │
Impact     │           │              │
```

## Benefits Realization

### Benefits Tracking

```markdown
# Benefits Realization Plan

## Benefit 1: Revenue Increase

### Definition
- Metric: Annual revenue from new product
- Baseline: $0
- Target: $5M/year

### Measurement
- Source: Financial system
- Frequency: Monthly
- Owner: Finance

### Realization Timeline
| Quarter | Target | Actual | Variance |
|---------|--------|--------|----------|
| Q3 2024 | $200K | | |
| Q4 2024 | $800K | | |
| Q1 2025 | $1.5M | | |

### Dependencies
- Product launch (Project D)
- Sales enablement (Project E)
```

### Benefits Dashboard

```
┌─────────────────────────────────────────────────────────────────┐
│              BENEFITS REALIZATION                                │
├─────────────────────────────────────────────────────────────────┤
│  Target Benefits: $10M    Realized: $3.2M    On Track: $4.5M   │
├─────────────────────────────────────────────────────────────────┤
│  BENEFIT BREAKDOWN                                               │
│  Revenue Increase:  $2.0M / $5.0M  [████████░░░░░░░░] 40%      │
│  Cost Reduction:    $1.0M / $3.0M  [█████░░░░░░░░░░░] 33%      │
│  Efficiency Gain:   $0.2M / $2.0M  [█░░░░░░░░░░░░░░░] 10%      │
├─────────────────────────────────────────────────────────────────┤
│  TIMELINE                                                        │
│  [Realization curve chart vs plan]                              │
└─────────────────────────────────────────────────────────────────┘
```

## Stakeholder Management

### Stakeholder Map

```
                    HIGH INFLUENCE
                          │
        ┌─────────────────┼─────────────────┐
        │    KEEP         │     MANAGE      │
        │    SATISFIED    │     CLOSELY     │
        │                 │                 │
        │  - CFO          │  - CEO          │
        │  - Legal        │  - CTO          │
LOW     │                 │  - Bus Owner    │    HIGH
INTEREST├─────────────────┼─────────────────┤ INTEREST
        │    MONITOR      │     KEEP        │
        │                 │     INFORMED    │
        │                 │                 │
        │  - Vendors      │  - End Users    │
        │  - Support      │  - Teams        │
        │                 │                 │
        └─────────────────┼─────────────────┘
                          │
                    LOW INFLUENCE
```

### Communication Plan

| Stakeholder | Information | Frequency | Channel | Owner |
|-------------|-------------|-----------|---------|-------|
| Steering Committee | Program status | Monthly | Meeting | PM |
| Program Board | Detailed status | Bi-weekly | Meeting | PM |
| Project Managers | Coordination | Weekly | Meeting | PM |
| Teams | Updates | Weekly | Email | PM |
| End Users | Progress | Monthly | Newsletter | Comms |

## Reference Materials

- `references/governance.md` - Program governance guide
- `references/planning.md` - Planning best practices
- `references/benefits.md` - Benefits realization
- `references/stakeholders.md` - Stakeholder management

## Scripts

```bash
# Program dashboard generator
python scripts/program_dashboard.py --program "Digital Transformation"

# Dependency analyzer
python scripts/dependency_analyzer.py --projects projects.yaml

# Benefits tracker
python scripts/benefits_tracker.py --plan benefits_plan.yaml

# Resource forecaster
python scripts/resource_forecast.py --program program.yaml --months 12
```
