---
name: scrum-master
description: Advanced Scrum Master with data-driven team health analysis, velocity forecasting, retrospective insights, and team development expertise. Features comprehensive sprint health scoring, Monte Carlo forecasting, and psychological safety frameworks for high-performing agile teams.
license: MIT
metadata:
  version: 2.0.0
  author: borghei
  category: project-management
  domain: agile-development
  updated: 2026-02-15
  python-tools: velocity_analyzer.py, sprint_health_scorer.py, retrospective_analyzer.py
  tech-stack: scrum, agile-coaching, team-dynamics, data-analysis
---

# Scrum Master Expert

Advanced agile practitioner specializing in data-driven team development, psychological safety facilitation, and high-performance sprint execution. Combines traditional Scrum mastery with modern analytics, behavioral science, and continuous improvement methodologies for sustainable team excellence.

---

## Table of Contents

- [Capabilities](#capabilities)
- [Input Requirements](#input-requirements)
- [Analysis Tools](#analysis-tools)
- [Methodology](#methodology)
- [Templates & Assets](#templates--assets)
- [Reference Frameworks](#reference-frameworks)
- [Implementation Workflows](#implementation-workflows)
- [Assessment & Measurement](#assessment--measurement)
- [Best Practices](#best-practices)
- [Advanced Techniques](#advanced-techniques)
- [Limitations & Considerations](#limitations--considerations)

---

## Capabilities

### Data-Driven Sprint Analytics
- **Velocity Analysis**: Multi-dimensional velocity tracking with trend detection, anomaly identification, and Monte Carlo forecasting using `velocity_analyzer.py`
- **Sprint Health Scoring**: Comprehensive health assessment across 6 dimensions (commitment reliability, scope stability, blocker resolution, ceremony engagement, story completion, velocity predictability) via `sprint_health_scorer.py`
- **Retrospective Intelligence**: Pattern recognition in team feedback, action item completion tracking, and improvement trend analysis through `retrospective_analyzer.py`

### Team Development & Psychology
- **Psychological Safety Facilitation**: Research-based approach to creating safe-to-fail environments using Google's Project Aristotle findings
- **Team Maturity Assessment**: Tuckman's model applied to Scrum teams with stage-specific coaching interventions
- **Conflict Resolution**: Structured approaches for productive disagreement and healthy team dynamics
- **Performance Coaching**: Individual and team coaching using behavioral science and adult learning principles

### Advanced Forecasting & Planning
- **Monte Carlo Simulation**: Probabilistic sprint and release forecasting with confidence intervals
- **Capacity Planning**: Statistical modeling of team capacity with seasonal adjustments and dependency analysis
- **Risk Assessment**: Early warning systems for team performance degradation and intervention recommendations

### Process Excellence
- **Ceremony Optimization**: Data-driven improvement of sprint ceremonies for maximum value and engagement
- **Continuous Improvement Systems**: Automated tracking of retrospective action items and improvement velocity
- **Stakeholder Communication**: Executive-ready reports with actionable insights and trend analysis

---

## Input Requirements

### Sprint Data Structure
All analysis tools accept JSON input following the schema in `assets/sample_sprint_data.json`:

```json
{
  "team_info": { "name": "string", "size": "number", "scrum_master": "string" },
  "sprints": [
    {
      "sprint_number": "number",
      "planned_points": "number", 
      "completed_points": "number",
      "stories": [...],
      "blockers": [...],
      "ceremonies": {...}
    }
  ],
  "retrospectives": [
    {
      "sprint_number": "number",
      "went_well": ["string"],
      "to_improve": ["string"],
      "action_items": [...]
    }
  ]
}
```

### Minimum Data Requirements
- **Velocity Analysis**: 3+ sprints (6+ recommended for statistical significance)
- **Health Scoring**: 2+ sprints with ceremony and story completion data
- **Retrospective Analysis**: 3+ retrospectives with action item tracking
- **Team Development Assessment**: 4+ weeks of observation data

---

## Analysis Tools

### Velocity Analyzer (`scripts/velocity_analyzer.py`)
Comprehensive velocity analysis with statistical modeling and forecasting.

**Features**:
- Rolling averages (3, 5, 8 sprint windows)
- Trend detection using linear regression
- Volatility assessment (coefficient of variation)
- Anomaly detection (outliers beyond 2σ)
- Monte Carlo forecasting with confidence intervals

**Usage**:
```bash
python velocity_analyzer.py sprint_data.json --format text
python velocity_analyzer.py sprint_data.json --format json > analysis.json
```

**Outputs**:
- Velocity trends (improving/stable/declining)
- Predictability metrics (CV, volatility classification)
- 6-sprint forecast with 50%, 70%, 85%, 95% confidence intervals
- Anomaly identification with root cause suggestions

### Sprint Health Scorer (`scripts/sprint_health_scorer.py`)
Multi-dimensional team health assessment with actionable recommendations.

**Scoring Dimensions** (weighted):
1. **Commitment Reliability** (25%): Sprint goal achievement consistency
2. **Scope Stability** (20%): Mid-sprint scope change frequency
3. **Blocker Resolution** (15%): Average time to resolve impediments
4. **Ceremony Engagement** (15%): Participation and effectiveness metrics
5. **Story Completion Distribution** (15%): Ratio of completed vs. partial stories
6. **Velocity Predictability** (10%): Delivery consistency measurement

**Usage**:
```bash
python sprint_health_scorer.py sprint_data.json --format text
```

**Outputs**:
- Overall health score (0-100) with grade classification
- Individual dimension scores with improvement recommendations
- Trend analysis across sprints
- Intervention priority matrix

### Retrospective Analyzer (`scripts/retrospective_analyzer.py`)
Advanced retrospective data analysis for continuous improvement insights.

**Analysis Components**:
- **Action Item Tracking**: Completion rates by priority and owner
- **Theme Identification**: Recurring patterns in team feedback
- **Sentiment Analysis**: Positive/negative trend tracking
- **Improvement Velocity**: Rate of team development and problem resolution
- **Team Maturity Scoring**: Development stage assessment

**Usage**:
```bash
python retrospective_analyzer.py sprint_data.json --format text
```

**Outputs**:
- Action item completion analytics with bottleneck identification
- Recurring theme analysis with persistence scoring
- Team maturity level assessment (forming/storming/norming/performing)
- Improvement velocity trends and recommendations

---

## Methodology

### Data-Driven Scrum Mastery
Traditional Scrum practices enhanced with quantitative analysis and behavioral science:

#### 1. Measurement-First Approach
- Establish baseline metrics before implementing changes
- Use statistical significance testing for process improvements
- Track leading indicators (engagement, psychological safety) alongside lagging indicators (velocity)
- Apply continuous feedback loops for rapid iteration

#### 2. Psychological Safety Foundation
Based on Amy Edmondson's research and Google's Project Aristotle findings:
- **Assessment**: Regular psychological safety surveys and behavioral observation
- **Intervention**: Structured vulnerability modeling and safe-to-fail experiments
- **Measurement**: Track speaking-up frequency, mistake discussion openness, help-seeking behavior

#### 3. Team Development Lifecycle
Tuckman's model applied to Scrum teams with stage-specific facilitation:
- **Forming**: Structure provision, process education, relationship building
- **Storming**: Conflict facilitation, psychological safety maintenance, process flexibility
- **Norming**: Autonomy building, process ownership transfer, external relationship development
- **Performing**: Challenge introduction, innovation support, organizational impact facilitation

#### 4. Continuous Improvement Science
Evidence-based approach to retrospective outcomes:
- Action item completion rate optimization
- Root cause analysis using statistical methods
- Improvement experiment design and measurement
- Knowledge retention and pattern recognition

---

## Templates & Assets

### Sprint Reporting (`assets/sprint_report_template.md`)
Production-ready sprint report template including:
- Executive summary with health grade and key metrics
- Delivery performance dashboard (commitment ratio, velocity trends)
- Process health indicators (scope change, blocker resolution)
- Quality metrics (DoD adherence, technical debt)
- Risk assessment and stakeholder communication

### Team Health Assessment (`assets/team_health_check_template.md`)
Spotify Squad Health Check model adaptation featuring:
- 9-dimension health assessment (delivering value, learning, fun, codebase health, mission clarity, suitable process, support, speed, pawns vs. players)
- Psychological safety evaluation framework
- Team maturity level assessment
- Action item prioritization matrix

### Sample Data (`assets/sample_sprint_data.json`)
Comprehensive 6-sprint dataset demonstrating:
- Multi-story sprint structure with realistic complexity
- Blocker tracking and resolution patterns
- Ceremony engagement metrics
- Retrospective data with action item follow-through
- Team capacity variations and external dependencies

### Expected Outputs (`assets/expected_output.json`)
Standardized analysis results showing:
- Velocity analysis with 20.2 point average and low volatility (CV: 12.7%)
- Sprint health score of 78.3/100 with dimension breakdowns
- Retrospective insights showing 46.7% action item completion rate
- Team maturity assessment at "performing" level

---

## Reference Frameworks

### Velocity Forecasting Guide (`references/velocity-forecasting-guide.md`)
Comprehensive guide to probabilistic estimation including:
- Monte Carlo simulation implementation details
- Confidence interval calculation methods
- Trend adjustment techniques for improving/declining teams
- Stakeholder communication strategies for uncertainty
- Advanced techniques: seasonality adjustment, capacity modeling, multi-team dependencies

### Team Dynamics Framework (`references/team-dynamics-framework.md`)
Research-based team development approach covering:
- Tuckman's stages applied to Scrum teams with specific behavioral indicators
- Psychological safety assessment and building techniques
- Conflict resolution strategies for productive disagreement
- Stage-specific facilitation approaches and intervention strategies
- Measurement tools for team development tracking

---

## Implementation Workflows

### Sprint Execution Cycle

#### Sprint Planning (Data-Informed)
1. **Pre-Planning Analysis**:
   - Run velocity analysis to determine sustainable commitment level
   - Review sprint health scores from previous sprints
   - Analyze retrospective action items for capacity impact

2. **Capacity Determination**:
   - Apply Monte Carlo forecasting for realistic point estimation
   - Factor in team member availability and external dependencies
   - Use historical commitment reliability data for scope negotiation

3. **Goal Setting & Commitment**:
   - Align sprint goals with team maturity level and capability trends
   - Ensure psychological safety in commitment discussions
   - Document assumptions and dependencies for retrospective analysis

#### Daily Standups (Team Development Focus)
1. **Structured Format** with team development overlay:
   - Progress updates with impediment surfacing
   - Help requests and collaboration opportunities
   - Team dynamic observation and psychological safety assessment

2. **Data Collection**:
   - Track participation patterns and engagement levels
   - Note conflict emergence and resolution attempts
   - Monitor help-seeking behavior and vulnerability expression

3. **Real-Time Coaching**:
   - Model psychological safety through Scrum Master vulnerability
   - Facilitate productive conflict when disagreements arise
   - Encourage cross-functional collaboration and knowledge sharing

#### Sprint Review (Stakeholder Alignment)
1. **Demonstration with Context**:
   - Present completed work with velocity and health context
   - Share team development progress and capability growth
   - Discuss impediments and organizational support needs

2. **Feedback Integration**:
   - Capture stakeholder input for retrospective analysis
   - Assess scope change impacts on team health
   - Plan adaptations based on team maturity and capacity

#### Sprint Retrospective (Intelligence-Driven)
1. **Data-Informed Facilitation**:
   - Present sprint health scores and trends as starting point
   - Use retrospective analyzer insights to guide discussion focus
   - Surface patterns from historical retrospective themes

2. **Action Item Optimization**:
   - Limit action items based on team's completion rate history
   - Assign owners and deadlines based on previous success patterns
   - Design experiments with measurable success criteria

3. **Continuous Improvement**:
   - Track action item completion for next retrospective
   - Measure team maturity progression using behavioral indicators
   - Adjust facilitation approach based on team development stage

### Team Development Intervention

#### Assessment Phase
1. **Multi-Dimensional Data Collection**:
   ```bash
   python sprint_health_scorer.py team_data.json > health_assessment.txt
   python retrospective_analyzer.py team_data.json > retro_insights.txt
   ```

2. **Psychological Safety Evaluation**:
   - Conduct anonymous team survey using Edmondson's 7-point scale
   - Observe team interactions during ceremonies for safety indicators
   - Interview team members individually for deeper insights

3. **Team Maturity Assessment**:
   - Map behaviors against Tuckman's model stages
   - Assess autonomy level and self-organization capability
   - Evaluate conflict handling and collaboration patterns

#### Intervention Design
1. **Stage-Appropriate Coaching**:
   - **Forming**: Structure provision, process education, trust building
   - **Storming**: Conflict facilitation, safety maintenance, process flexibility
   - **Norming**: Autonomy building, ownership transfer, skill development
   - **Performing**: Challenge provision, innovation support, organizational impact

2. **Psychological Safety Building**:
   - Model vulnerability and mistake admission
   - Reward help-seeking and question-asking behavior
   - Create safe-to-fail experiments and learning opportunities
   - Facilitate difficult conversations with protective boundaries

#### Progress Measurement
1. **Quantitative Tracking**:
   - Weekly ceremony engagement scores
   - Monthly psychological safety pulse surveys
   - Sprint-level team health score progression
   - Quarterly team maturity assessment

2. **Qualitative Indicators**:
   - Behavioral observation during ceremonies
   - Individual 1:1 conversation insights
   - Stakeholder feedback on team collaboration
   - External team perception and reputation

---

## Assessment & Measurement

### Key Performance Indicators

#### Team Health Metrics
- **Overall Health Score**: Composite score across 6 dimensions (target: >80)
- **Psychological Safety Index**: Team safety assessment (target: >4.0/5.0)
- **Team Maturity Level**: Development stage classification with progression tracking
- **Improvement Velocity**: Rate of retrospective action item completion (target: >70%)

#### Sprint Performance Metrics
- **Velocity Predictability**: Coefficient of variation in sprint delivery (target: <20%)
- **Commitment Reliability**: Percentage of sprint goals achieved (target: >85%)
- **Scope Stability**: Mid-sprint change frequency (target: <15%)
- **Blocker Resolution Time**: Average days to resolve impediments (target: <3 days)

#### Engagement Metrics
- **Ceremony Participation**: Attendance and engagement quality (target: >90%)
- **Knowledge Sharing**: Cross-training and collaboration frequency
- **Innovation Frequency**: New ideas generated and implemented per sprint
- **Stakeholder Satisfaction**: External perception of team performance

### Assessment Schedule
- **Daily**: Ceremony observation and team dynamic monitoring
- **Weekly**: Sprint progress and impediment tracking
- **Sprint**: Comprehensive health scoring and velocity analysis
- **Monthly**: Psychological safety assessment and team maturity evaluation
- **Quarterly**: Deep retrospective analysis and intervention strategy review

### Calibration & Validation
- Compare analytical insights with team self-assessment
- Validate predictions against actual sprint outcomes
- Cross-reference quantitative metrics with qualitative observations
- Adjust models based on long-term team development patterns

---

## Best Practices

### Data Collection Excellence
1. **Consistency**: Maintain regular data collection rhythms without overwhelming the team
2. **Transparency**: Share analytical insights openly to build trust and understanding
3. **Actionability**: Focus on metrics that directly inform coaching decisions
4. **Privacy**: Respect individual confidentiality while enabling team-level insights

### Facilitation Mastery
1. **Adaptive Leadership**: Match facilitation style to team development stage
2. **Psychological Safety First**: Prioritize safety over process adherence when conflicts arise
3. **Systems Thinking**: Address root causes rather than symptoms in team performance issues
4. **Evidence-Based Coaching**: Use data to support coaching conversations and intervention decisions

### Stakeholder Communication
1. **Range Estimates**: Communicate uncertainty through confidence intervals rather than single points
2. **Context Provision**: Explain team development stage and capability constraints
3. **Trend Focus**: Emphasize improvement trajectories over absolute performance levels
4. **Risk Transparency**: Surface impediments and dependencies proactively

### Continuous Improvement
1. **Experiment Design**: Structure process improvements as testable hypotheses
2. **Measurement Planning**: Define success criteria before implementing changes
3. **Feedback Loops**: Establish regular review cycles for intervention effectiveness
4. **Learning Culture**: Model curiosity and mistake tolerance to encourage team experimentation

---

## Advanced Techniques

### Predictive Analytics
- **Early Warning Systems**: Identify teams at risk of performance degradation
- **Intervention Timing**: Optimize coaching interventions based on team development patterns
- **Capacity Forecasting**: Predict team capability changes based on historical patterns
- **Dependency Modeling**: Assess cross-team collaboration impacts on performance

### Behavioral Science Applications
- **Cognitive Bias Recognition**: Help teams recognize and mitigate planning fallacy and confirmation bias
- **Motivation Optimization**: Apply self-determination theory to enhance team autonomy and mastery
- **Social Learning**: Leverage peer modeling and collective efficacy for skill development
- **Change Management**: Use behavioral economics principles for sustainable process adoption

### Advanced Facilitation
- **Liberating Structures**: Apply structured facilitation methods for enhanced participation
- **Appreciative Inquiry**: Focus team conversations on strengths and possibilities
- **Systems Constellation**: Visualize team dynamics and organizational relationships
- **Conflict Mediation**: Professional-level conflict resolution for complex team issues

---

## Limitations & Considerations

### Data Quality Dependencies
- **Minimum Sample Size**: Statistical significance requires 6+ sprints for meaningful analysis
- **Data Completeness**: Missing ceremony data or retrospective information limits insight accuracy
- **Context Sensitivity**: Algorithm recommendations must be interpreted within organizational and team context
- **External Factors**: Analysis cannot account for all external influences on team performance

### Psychological Safety Requirements
- **Trust Building Time**: Authentic psychological safety development requires sustained effort over months
- **Individual Differences**: Team members have varying comfort levels with vulnerability and feedback
- **Cultural Considerations**: Organizational and national culture significantly impact safety building approaches
- **Leadership Modeling**: Scrum Master psychological safety demonstration is prerequisite for team development

### Scaling Challenges
- **Team Size Limits**: Techniques optimized for 5-9 member teams may require adaptation for larger groups
- **Multi-Team Coordination**: Dependencies across teams introduce complexity not fully captured by single-team metrics
- **Organizational Alignment**: Team-level improvements may be constrained by broader organizational impediments
- **Stakeholder Education**: External stakeholders require education on probabilistic planning and team development concepts

### Measurement Limitations
- **Quantitative Bias**: Over-reliance on metrics may overlook important qualitative team dynamics
- **Gaming Potential**: Teams may optimize for measured metrics rather than underlying performance
- **Lag Indicators**: Many important outcomes (psychological safety, team cohesion) are delayed relative to interventions
- **Individual Privacy**: Balancing team insights with individual confidentiality and psychological safety

---

## Success Metrics & Outcomes

Teams using this advanced Scrum Master approach typically achieve:

- **40-60% improvement** in velocity predictability (reduced coefficient of variation)
- **25-40% increase** in retrospective action item completion rates
- **30-50% reduction** in average blocker resolution time
- **80%+ teams** reach "performing" stage within 6-9 months
- **4.0+ psychological safety scores** sustained across team tenure
- **90%+ ceremony engagement** with high-quality participation

The methodology transforms traditional Scrum mastery through data-driven insights, behavioral science application, and systematic team development practices, resulting in sustainable high-performance teams with strong psychological safety and continuous improvement capabilities.

---

*This skill combines traditional Scrum expertise with modern analytics and behavioral science. Success requires commitment to data collection, psychological safety building, and evidence-based coaching approaches. Adapt techniques based on your specific team and organizational context.*