# Team Health Check - Spotify Squad Model
**Team:** [TEAM_NAME]  
**Assessment Date:** [DATE]  
**Facilitator:** [FACILITATOR_NAME]  
**Participants:** [PARTICIPANT_COUNT] of [TOTAL_TEAM_SIZE] members

---

## Health Check Overview

The Team Health Check is based on Spotify's Squad Health Check model, designed to visualize team health across multiple dimensions. Each dimension is assessed using a simple traffic light system:

- 🟢 **Green (Awesome):** We're doing great! No major concerns.
- 🟡 **Yellow (Some Concerns):** We're doing okay, but there are some things we could improve.  
- 🔴 **Red (Not Good):** This really sucks and we need to do something about it.

### Assessment Method
- Anonymous individual ratings followed by team discussion
- Focus on trends over time rather than absolute scores
- Action-oriented outcomes for improvement areas

---

## Health Dimensions Assessment

### 1. Delivering Value 🎯
*Are we delivering value to our users and stakeholders?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 2. Learning 📚
*Are we learning and growing as individuals and as a team?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 3. Fun 🎉
*Do we enjoy working together and find our work engaging?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 4. Health of Codebase 🏗️
*Is our code healthy, maintainable, and of good quality?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 5. Mission Clarity 🎯
*Do we understand why we exist and what we're supposed to achieve?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 6. Suitable Process ⚙️
*Is our process helping us be effective?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 7. Support 🤝
*Do we get the support we need from management and other teams?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 8. Speed ⚡
*Are we able to deliver quickly without compromising quality?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

### 9. Pawns or Players 👥
*Do we feel like we have control over our work and destiny?*

**Current Status:** [🟢/🟡/🔴]  
**Trend from Last Check:** [⬆️ Improving / ➡️ Stable / ⬇️ Declining]  
**Team Rating:** [X]/5 team members voted Green, [Y]/5 Yellow, [Z]/5 Red

**What's Working Well:**
- [POSITIVE_POINT_1]
- [POSITIVE_POINT_2]

**Areas of Concern:**
- [CONCERN_1]
- [CONCERN_2]

**Suggested Actions:**
- [ACTION_1]
- [ACTION_2]

---

## Overall Health Summary

### Health Score Distribution
- 🟢 **Green Dimensions:** [GREEN_COUNT]/9 ([GREEN_PERCENTAGE]%)
- 🟡 **Yellow Dimensions:** [YELLOW_COUNT]/9 ([YELLOW_PERCENTAGE]%)  
- 🔴 **Red Dimensions:** [RED_COUNT]/9 ([RED_PERCENTAGE]%)

### Overall Health Grade: [EXCELLENT/GOOD/FAIR/POOR]

### Trend Analysis
- **Improving:** [IMPROVING_COUNT] dimensions
- **Stable:** [STABLE_COUNT] dimensions  
- **Declining:** [DECLINING_COUNT] dimensions

### Team Maturity Level
Based on the health check results and team dynamics observed:
**[FORMING/STORMING/NORMING/PERFORMING/ADJOURNING]**

---

## Priority Action Items

### High Priority (Red Dimensions)
1. **[RED_DIMENSION_1]:** [ACTION_DESCRIPTION_1]
   - Owner: [OWNER_1]
   - Timeline: [TIMELINE_1]
   - Success Criteria: [CRITERIA_1]

2. **[RED_DIMENSION_2]:** [ACTION_DESCRIPTION_2]
   - Owner: [OWNER_2]
   - Timeline: [TIMELINE_2]
   - Success Criteria: [CRITERIA_2]

### Medium Priority (Yellow Dimensions)
1. **[YELLOW_DIMENSION_1]:** [ACTION_DESCRIPTION_1]
   - Owner: [OWNER_1]
   - Timeline: [TIMELINE_1]

2. **[YELLOW_DIMENSION_2]:** [ACTION_DESCRIPTION_2]
   - Owner: [OWNER_2]
   - Timeline: [TIMELINE_2]

### Maintain Strengths (Green Dimensions)
1. **[GREEN_DIMENSION_1]:** Continue [STRENGTH_PRACTICE_1]
2. **[GREEN_DIMENSION_2]:** Share [BEST_PRACTICE_1] with other teams

---

## Psychological Safety Assessment

*Separate anonymous assessment of team psychological safety*

### Psychological Safety Indicators
1. **Speaking Up:** Team members feel safe to speak up with ideas, questions, concerns, or mistakes
   - Score: [SCORE_1]/5 ⭐⭐⭐⭐⭐

2. **Risk Taking:** Team members feel safe to take risks and make mistakes
   - Score: [SCORE_2]/5 ⭐⭐⭐⭐⭐

3. **Asking for Help:** Team members feel comfortable asking for help or admitting they don't know something
   - Score: [SCORE_3]/5 ⭐⭐⭐⭐⭐

4. **Discussing Problems:** Difficult topics and problems can be discussed openly
   - Score: [SCORE_4]/5 ⭐⭐⭐⭐⭐

5. **Being Yourself:** Team members don't feel they have to pretend to be someone else
   - Score: [SCORE_5]/5 ⭐⭐⭐⭐⭐

**Overall Psychological Safety Score:** [TOTAL_SCORE]/25

### Psychological Safety Actions
- [PSYCH_SAFETY_ACTION_1]
- [PSYCH_SAFETY_ACTION_2]

---

## Communication & Collaboration Assessment

### Communication Quality
- **Clarity of Communication:** [SCORE]/5 ⭐⭐⭐⭐⭐
- **Frequency of Communication:** [SCORE]/5 ⭐⭐⭐⭐⭐
- **Openness & Transparency:** [SCORE]/5 ⭐⭐⭐⭐⭐

### Collaboration Patterns
- **Cross-functional Collaboration:** [SCORE]/5 ⭐⭐⭐⭐⭐
- **Knowledge Sharing:** [SCORE]/5 ⭐⭐⭐⭐⭐
- **Conflict Resolution:** [SCORE]/5 ⭐⭐⭐⭐⭐

---

## Follow-up Plan

### Next Health Check
**Scheduled Date:** [NEXT_DATE]  
**Frequency:** [MONTHLY/QUARTERLY/BI-ANNUAL]

### Interim Check-ins
- **Sprint Retrospectives:** Continue monitoring health indicators
- **Weekly 1:1s:** Individual pulse checks with team members
- **Monthly Team Lunches:** Informal health and morale assessment

### Success Metrics
We'll know we're improving when we see:
- [SUCCESS_METRIC_1]
- [SUCCESS_METRIC_2]
- [SUCCESS_METRIC_3]

---

## Historical Comparison

### Previous Health Checks
| Date | Green | Yellow | Red | Overall Trend |
|------|-------|--------|-----|---------------|
| [PREV_DATE_1] | [G1] | [Y1] | [R1] | [TREND_1] |
| [PREV_DATE_2] | [G2] | [Y2] | [R2] | [TREND_2] |
| [CURRENT_DATE] | [G3] | [Y3] | [R3] | [TREND_3] |

### Long-term Improvements
- [LONG_TERM_IMPROVEMENT_1]
- [LONG_TERM_IMPROVEMENT_2]

### Persistent Challenges
- [PERSISTENT_CHALLENGE_1]
- [PERSISTENT_CHALLENGE_2]

---

## Team Comments & Feedback

*Anonymous feedback from team members*

### What's the most important thing we should focus on?
- "[FEEDBACK_1]"
- "[FEEDBACK_2]"
- "[FEEDBACK_3]"

### What's our biggest strength as a team?
- "[STRENGTH_1]"
- "[STRENGTH_2]"
- "[STRENGTH_3]"

### If you could change one thing, what would it be?
- "[CHANGE_1]"
- "[CHANGE_2]"
- "[CHANGE_3]"

---

## Action Item Summary

| Priority | Action | Owner | Due Date | Success Criteria | Status |
|----------|---------|-------|----------|------------------|--------|
| High | [ACTION_1] | [OWNER_1] | [DATE_1] | [CRITERIA_1] | [STATUS_1] |
| High | [ACTION_2] | [OWNER_2] | [DATE_2] | [CRITERIA_2] | [STATUS_2] |
| Medium | [ACTION_3] | [OWNER_3] | [DATE_3] | [CRITERIA_3] | [STATUS_3] |
| Medium | [ACTION_4] | [OWNER_4] | [DATE_4] | [CRITERIA_4] | [STATUS_4] |

---

**Assessment completed by:** [FACILITATOR_NAME]  
**Report distribution:** Team Members, Product Owner, Management (summary only)  
**Confidentiality:** Individual responses kept confidential, only aggregate data shared

---
*This health check is based on the Spotify Squad Health Check model. The goal is continuous improvement, not judgment. Use this data to have better conversations about how to work together effectively.*