---

description: Index of reference files for design skill modules.
metadata:
  id: design.ref.index
  version: "1"
  task_types:
    - design
  trigger_phrases:
    - index
    - references
    - references index
    - reference index
  priority: 30
  load_strategy: progressive
  activation_policy: both
  workflow_triggers: []
  route_exclude: true

---


# References Index

Canonical source:
- `config-patterns.json` is the canonical DialKit defaults/schema source for `dialkit.md`.

## References
- `references/design-critique.md` - Systematic critique workflow for screenshots, components, and pages with prioritized opportunities.
- `references/design-guidelines.md` - Frontend visual and design-system guidance for interface layout, hierarchy, and styling direction.
- `references/components-and-motion.md` - Component patterns, animation and motion patterns, and UI behaviors with implementation details.
- `references/tailwindcss-full.md` - Tailwind CSS v4 reference, utility-first classes, and practical responsive styling guidance.
- `references/storyboard-animation.md` - Human-readable, stage-driven animation structure with centralized timing/config constants.
- `references/dialkit.md` - DialKit setup checks, smart defaults, and config-generation patterns for live tuning panels.
- `references/config-patterns.json` - DialKit control schema examples and smart defaults used by the dialkit reference.
