---
name: frontend-components
description: Frontend component design patterns and CSS techniques. Use for implementing UI components like marquees, carousels, modals, tooltips, and other interactive elements. Covers CSS animations, accessibility, and reusable component patterns.
metadata:
  version: "1.0.0"
---

# Frontend Component Design Patterns

Concise index of component patterns and motion guidance. For full recipes and code examples, see `references/components-and-motion.md`.

## Use this skill for
- UI component patterns (marquee, cards, badges, embeds, like buttons)
- Interaction polish (hover/active states, pseudo-elements, hit targets)
- Motion/animation decisions and principles
- Optional sound feedback patterns

## How to use
1) Identify the component or interaction need.
2) Open the reference file and apply the pattern.
3) Ensure accessibility (focus states, reduced motion, readable timing).

## References
- `references/components-and-motion.md`
