---

name: ask-questions-if-underspecified
description: Use when a request has implementation intent (build/fix/refactor/migrate/integrate/plan-to-build) but acceptance criteria, scope, constraints, or safety conditions are unclear. Run this before spec/work-package execution.
metadata:
  id: planning.ref.ask-questions-if-underspecified
  version: "1"
  task_types:
    - clarify
    - plan
  trigger_phrases:
    - ask questions if underspecified
    - references
    - references ask-questions-if-underspecified
  priority: 72
  load_strategy: progressive
  activation_policy: both
  workflow_triggers:
    - implementation_intent_detected_without_constraints
  route_exclude: false

---



# Ask Questions If Underspecified

## Goal

Ask the minimum set of clarifying questions needed to avoid wrong work; do not start implementing until the must-have questions are answered (or the user explicitly approves proceeding with stated assumptions).

## Trigger guidance (quick test)

Use this reference when both conditions are true:
- There is implementation intent now or immediately after planning (for example: build, fix, refactor, migrate, integrate, ship, "plan then implement", "continue execution").
- At least one must-have unknown remains (objective, done criteria, scope, constraints, safety/rollback, or target artifact).

Strong trigger signals:
- Multiple plausible interpretations of "what changes" or "what done means."
- User points to a ticket/work package but does not define which item to execute first or what proof is required.
- Prompt asks for speed ("just do it") while key constraints are missing.

Do not use this reference for pure explanation, research-only requests, or deterministic continuation where the next step and acceptance criteria are already explicit.

## Workflow

### 1) Decide whether the request is underspecified

Treat a request as underspecified if, before committing to an implementation direction, some or all of the following are not clear:
- Define the objective (what should change vs stay the same)
- Define "done" (acceptance criteria, examples, edge cases)
- Define scope (which files/components/users are in/out)
- Define constraints (compatibility, performance, style, deps, time)
- Identify environment (language/runtime versions, OS, build/test runner)
- Clarify safety/reversibility (data migration, rollout/rollback, risk)
- Clarify delivery vehicle when ambiguous (direct patch vs `docs/specs/*` vs work package execution)

If multiple plausible interpretations exist, assume it is underspecified.

### 2) Ask must-have questions first (keep it small)

Ask 1-4 questions in the first pass. Prefer questions that eliminate whole branches of work.

Make questions easy to answer:
- Optimize for scannability (short, numbered questions; avoid paragraphs)
- Offer multiple-choice options when possible
- Suggest reasonable defaults when appropriate (mark them clearly as the default/recommended choice; bold the recommended choice in the list, or if you present options in a code block, put a bold "Recommended" line immediately above the block and also tag defaults inside the block)
- Include a fast-path response (e.g., reply `defaults` to accept all recommended/default choices)
- Include a low-friction "not sure" option when helpful (e.g., "Not sure - use default")
- Separate "Need to know" from "Nice to know" if that reduces friction
- Structure options so the user can respond with compact decisions (e.g., `1b 2a 3c`); restate the chosen options in plain language to confirm

### 3) Pause before acting

Until must-have answers arrive:
- Do not edit files or produce a directionally committed plan that depends on unknowns
- Do perform a clearly labeled, low-risk discovery step only if it does not commit you to a direction (e.g., inspect repo structure, read relevant config files)

If the user explicitly asks you to proceed without answers:
- State your assumptions as a short numbered list
- Ask for confirmation; proceed only after they confirm or correct them

### 4) Confirm interpretation, then proceed

Once you have answers, restate the requirements in 1-3 sentences (including key constraints and what success looks like), then pick an execution mode:
- Multi-step or exploratory implementation: use `skills/planning/references/spec-driven-iterative-builder.md`.
- Work-package execution prompt/path present: use spec-driven workflow in work-package mode and map the first concrete item.
- Single deterministic change: proceed directly with the clarified scope.

### 4b) Workpackage-specific must-haves

For work-package execution prompts, do not proceed until all are confirmed:
- Target item is explicit, or "first non-done from `overview.md`" is accepted.
- Completion criteria include a required proof pointer and validation expectation.
- Edit boundaries (files/directories) are explicit.

If any are missing, ask a compact clarification set before editing.

## Question templates

- "Before I start, I need: (1) ..., (2) ..., (3) .... If you don't care about (2), I will assume ...."
- "Which of these should it be? A) ... B) ... C) ... (pick one)"
- "What would you consider 'done'? For example: ..."
- "Any constraints I must follow (versions, performance, style, deps)? If none, I will target the existing project defaults."
- Use numbered questions with lettered options and a clear reply format

```text
1) Scope?
a) Minimal change (default)
b) Refactor while touching the area
c) Not sure - use default
2) Compatibility target?
a) Current project defaults (default)
b) Also support older versions: <specify>
c) Not sure - use default
3) Workpackage handling?
a) Start from first non-done `WP-*` in `overview.md` (default)
b) Execute explicit target `WP-*` (please specify)
c) Not sure - use default

Reply with: defaults (or 1a 2a 3a)
```

## Anti-patterns

- Don't ask questions you can answer with a quick, low-risk discovery read (e.g., configs, existing patterns, docs).
- Don't ask open-ended questions if a tight multiple-choice or yes/no would eliminate ambiguity faster.
- Don't repeatedly re-ask already answered constraints; confirm once, then proceed.
