---
name: coder
description: Apply Brian Balfour's CODER framework to drive organizational AI adoption. Constraints, Ownership, Directives, Expectations, Rewards.
---

# CODER Framework

Apply **Brian Balfour's CODER Framework** to systematically drive AI adoption across your organization.

## Entry Point

When this skill is invoked, start with:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 CODER FRAMEWORK
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Drive AI adoption across your organization.

- Constraints: Make new behavior easier than old
- Ownership: Assign clear responsibility
- Directives: Create specific, actionable instructions
- Expectations: Set measurable goals
- Rewards: Tie to career progression

What do you want to do?

  1. Diagnose adoption barriers
  2. Create full CODER plan
  3. Focus on specific team

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

## What This Does

Guides you through creating an AI adoption plan using the CODER framework:
- **C**onstraints - Make new behavior easier than old behavior
- **O**wnership - Assign clear responsibility
- **D**irectives - Create specific, actionable instructions
- **E**xpectations - Set measurable goals
- **R**ewards - Tie to career progression

## Usage

```
/coder
```

**Optional parameters:**
- `/coder --diagnose` - Identify your primary adoption barrier
- `/coder --team [team-name]` - Create plan for specific team
- `/coder --export` - Generate implementation doc

## What Happens

1. **Diagnoses your situation:**
   - Company size and structure
   - Current AI adoption level
   - Primary barriers (political, retrofitting, procurement, knowledge, permission)
   - Team composition (catalysts 15-20%, converts 60-70%, anchors 15-20%)

2. **Guides through CODER framework:**
   - Designs 1-2 **constraints** for your context
   - Assigns **ownership** (CEO/functional leaders)
   - Creates 2-3 **directives** per function
   - Sets specific, universal, measurable **expectations**
   - Defines how to tie to **rewards** (performance reviews, leveling)

3. **Generates implementation plan:**
   - Immediate actions
   - 30/60/90 day milestones
   - Metrics to track
   - Common pitfalls to avoid

## The Framework Components

### C - Constraints
Make AI behavior easier than old behavior:
- Time constraints (hackathons, dedicated AI days)
- Process constraints ("I only review work demonstrating AI augmentation")
- Tool constraints (Copilot required, AI in workflows)

### O - Ownership
Assign clear responsibility:
- CEO: Overall cultural shift
- Functional leaders: Team-specific directives
- Clear escalation paths for blockers

### D - Directives
Create specific, actionable instructions (2-3 per team):
- Product: "All features must include AI prototype before design review"
- Engineering: "All code reviews must use GitHub Copilot"
- Design: "Design critiques include AI generation process"

### E - Expectations
Set specific, universal, measurable goals:
- ✓ "100% of PMs prototype features with AI" (not "use AI effectively")
- ✓ "90%+ of code commits show Copilot usage"
- ✓ AI fluency levels: Aware→Exploratory→Proficient→Advanced→Expert

### R - Rewards
Tie to career progression:
- Performance review criteria
- Leveling guide updates
- Promotion requirements

## Common Adoption Barriers

| Barrier | Symptom | Solution Focus |
|---------|---------|----------------|
| Political | Leaders disagree on value | Ownership, CEO mandate |
| Retrofitting | "We can't use AI for X" | Directives, examples |
| Procurement | Tool access blocked | Constraints, budgets |
| Knowledge | Don't know how to use tools | Directives, training |
| Permission | Fear of doing wrong | Expectations, psychological safety |

## Learn More

See the full CODER framework at:
`frameworks/ai-era-practices/organizational-ai-adoption.md`

---

**Framework:** Brian Balfour (Reforge, 2025)
**Best for:** Driving organizational change, AI adoption, behavioral transformation
**Key insight:** Move from value capture (10-15% efficiency) to value creation (new capabilities)
