---
name: pm-frameworks
description: Expert knowledge of proven product management frameworks for discovery, growth, measurement, planning, and AI-era practices.
---

# PM Frameworks Skill

Expert knowledge of proven product management frameworks for discovery, growth, measurement, planning, and AI-era practices.

## When to Invoke

Auto-invoke this skill when users discuss:

- **Discovery**: Feature validation, user research, testing assumptions, "should we build this?", risk assessment
- **Growth**: Acquisition, retention, virality, growth loops, product-led growth, network effects
- **Planning**: Roadmaps, prioritization, now-next-later, LNO framework, scoping projects
- **Measurement**: PMF surveys, metrics, success criteria, measuring product-market fit
- **AI Products**: Evals, fine-tuning vs RAG, prompt engineering, AI unit economics, production AI systems
- **Strategy**: Four fits, market-product fit, competitive positioning, business model
- **Execution**: PRDs, specs, issues vs stories, prototype-first development

## Core Frameworks

### Discovery Frameworks
Located in `/frameworks/discovery/`

**Four Risks (Marty Cagan)**
- Value Risk: Will customers buy/use this?
- Usability Risk: Can users figure it out?
- Feasibility Risk: Can we build it?
- Business Viability Risk: Does it work for the business?

**Continuous Discovery (Teresa Torres)**
- Weekly touchpoints with customers
- Opportunity Solution Trees
- Assumption testing
- Small experiments over big bets

### Growth Frameworks
Located in `/frameworks/growth/`

**Growth Loops (Elena Verna)**
- Viral loops (user invites user)
- Content/SEO loops (content attracts users)
- Network effect loops (more users = more value)
- Paid loops (revenue funds acquisition)

**Four Fits (Brian Balfour)**
- Market-Product Fit
- Product-Channel Fit
- Channel-Model Fit
- Model-Market Fit

**Product-Led Sales**
- Self-serve to sales-assist progression
- Usage-based qualification
- Expansion revenue patterns

### Planning Frameworks
Located in `/frameworks/planning/`

**Now-Next-Later (Janna Bastow)**
- Now: Current sprint, high confidence
- Next: Next 1-3 months, medium confidence
- Later: Future possibilities, low confidence
- Cone of uncertainty principle

**LNO Prioritization (Shreyas Doshi)**
- Leverage: High impact, do these first
- Neutral: Expected work, batch and schedule
- Overhead: Low value, minimize or eliminate

**Scope Projects Down**
- 80/20 principle for features
- Minimum viable scope
- Cut ruthlessly, add back later

### Measurement Frameworks
Located in `/frameworks/measurement/`

**PMF Survey (Rahul Vohra)**
- "How disappointed would you be if you couldn't use this product?"
- Target 40%+ "very disappointed"
- Find your high-expectation customers
- Build for them, ignore the rest

### AI-Era Practices
Located in `/frameworks/ai-era-practices/`

**Prototype-First (Aakash Gupta)**
- Ship prototypes before docs
- Code is the spec
- Iterate faster than you document

**Issues Not Stories (Linear)**
- Describe the problem, not the solution
- Let engineers figure out how
- Direction → Building → Quality phases

**AI Unit Economics**
- Cost per interaction modeling
- Inference costs at scale
- Value vs cost tradeoffs

**Continuous Calibration**
- Agency vs control spectrum
- When to give AI more autonomy
- Testing probabilistic systems

**Organizational AI Adoption (CODER Framework)**
- Culture, Organization, Data, Expertise, Roadmap
- Systematic approach to AI transformation

### AI Technical Frameworks
Located in `/frameworks/ai/`

**Production AI Systems (Chip Huyen)**
- Data quality > model complexity
- Monitoring and observability
- Handling model degradation

**Fine-tuning vs RAG Decision**
- RAG for dynamic data, domain knowledge
- Fine-tuning for style, task specialization
- Cost and maintenance tradeoffs

**AI Evals (Aman Khan)**
- Prompt-level testing
- Task-level testing
- System-level testing
- Regression testing for AI

## How to Apply Frameworks

### Conversationally, Not as Lectures
Don't say: "Let me explain the Four Risks framework..."
Do say: "What evidence do you have that users want this? That's the value risk."

### Ask Questions That Apply Frameworks
- "What's the smallest thing you could test this week?" (Continuous Discovery)
- "Is this Leverage, Neutral, or Overhead work?" (LNO)
- "Can you prototype this before writing the PRD?" (Prototype-First)
- "What's your growth loop here?" (Growth Loops)

### Push Toward Action
- Prototype over document
- Test with users over internal debate
- Small experiments over big bets
- Evidence over opinion

## Thought Leaders

Detailed profiles in `/thought-leaders/`:
- **Marty Cagan** - Discovery, empowered teams, four risks
- **Teresa Torres** - Continuous discovery, opportunity trees
- **Elena Verna** - Growth loops, product-led growth
- **Brian Balfour** - Four fits, growth strategy
- **Chip Huyen** - Production AI, ML engineering
- **Aman Khan** - AI evals, vibe-driven development
- **Janna Bastow** - Now-Next-Later, roadmapping
- **Aakash Gupta** - Prototype-first, visual frameworks
- **Rahul Vohra** - PMF survey, high-expectation customers
- **Ravi Mehta** - Product Strategy Stack

## Integration with Commands

This skill provides background knowledge for:
- `/strategy-session` - Apply frameworks conversationally
- `/four-risks` - Deep dive on risk assessment
- `/growth-loops` - Identify growth mechanisms
- `/four-fits` - Assess market-product alignment
- `/lno-prioritize` - Categorize work by leverage
- `/now-next-later` - Build roadmaps
- `/pmf-survey` - Measure product-market fit
- `/ai-cost-check` - Model AI economics
- `/start-evals` - Design AI evaluation

## Key Principles

1. **Evidence over opinion** - Always ask "what evidence do we have?"
2. **Prototype over document** - Ship something testable
3. **Users over internal debate** - Talk to real customers
4. **Small experiments** - Test assumptions cheaply
5. **Frameworks as tools, not rules** - Apply judgment

---

*This skill surfaces PM frameworks from the `/frameworks/` and `/thought-leaders/` directories.*
