# Framework Index

Quick reference to all PM frameworks in this plugin.

## Discovery
| Framework | Author | File |
|-----------|--------|------|
| Four Risks | Marty Cagan | `/frameworks/discovery/four-risks.md` |
| Continuous Discovery | Teresa Torres | `/frameworks/discovery/continuous-discovery.md` |

## Growth
| Framework | Author | File |
|-----------|--------|------|
| Growth Loops | Elena Verna | `/frameworks/growth/growth-loops.md` |
| Four Fits | Brian Balfour | `/frameworks/growth/four-fits.md` |
| Product-Led Sales | Elena Verna | `/frameworks/growth/product-led-sales.md` |

## Planning
| Framework | Author | File |
|-----------|--------|------|
| Now-Next-Later | Janna Bastow | `/frameworks/planning/now-next-later.md` |
| LNO Prioritization | Shreyas Doshi | `/frameworks/planning/lno-prioritization.md` |
| Scope Projects Down | Multiple | `/frameworks/planning/scope-projects-down.md` |
| Product Operating Model | Marty Cagan | `/frameworks/planning/product-operating-model.md` |
| Prioritize Enablers/Blockers | Multiple | `/frameworks/planning/prioritize-enablers-blockers.md` |
| Frontier of Understanding | Multiple | `/frameworks/planning/frontier-of-understanding.md` |

## Measurement
| Framework | Author | File |
|-----------|--------|------|
| PMF Survey | Rahul Vohra | `/frameworks/measurement/pmf-survey.md` |

## AI-Era Practices
| Framework | Author | File |
|-----------|--------|------|
| Prototype-First | Aakash Gupta | `/frameworks/ai-era-practices/prototype-first.md` |
| Issues Not Stories | Linear | `/frameworks/ai-era-practices/issues-not-stories.md` |
| AI Unit Economics | Multiple | `/frameworks/ai-era-practices/ai-unit-economics.md` |
| Continuous Calibration | Multiple | `/frameworks/ai-era-practices/continuous-calibration.md` |
| Context Engineering | Multiple | `/frameworks/ai-era-practices/context-engineering.md` |
| Organizational AI Adoption | Brian Balfour | `/frameworks/ai-era-practices/organizational-ai-adoption.md` |
| Prompt Engineering for PMs | Aman Khan | `/frameworks/ai-era-practices/prompt-engineering-for-pms.md` |

## AI Technical
| Framework | Author | File |
|-----------|--------|------|
| AI Evals | Aman Khan | `/frameworks/ai/ai-evals.md` |
| PM-Friendly Evals Guide | Aman Khan | `/frameworks/ai/pm-friendly-evals-guide.md` |
| Fine-tuning vs RAG | Chip Huyen | `/frameworks/ai/fine-tuning-vs-rag.md` |
| Production AI Systems | Chip Huyen | `/frameworks/ai/production-ai-systems.md` |

## Thought Leader Profiles
| Leader | Specialty | File |
|--------|-----------|------|
| Marty Cagan | Discovery, Empowered Teams | `/thought-leaders/marty-cagan.md` |
| Teresa Torres | Continuous Discovery | `/thought-leaders/teresa-torres.md` |
| Elena Verna | Growth, PLG | `/thought-leaders/elena-verna.md` |
| Brian Balfour | Four Fits, Strategy | `/thought-leaders/brian-balfour.md` |
| Chip Huyen | ML Engineering | `/thought-leaders/chip-huyen.md` |
| Aman Khan | AI Products | `/thought-leaders/aman-khan.md` |
| Janna Bastow | Roadmapping | `/thought-leaders/janna-bastow.md` |
| Aakash Gupta | Visual Frameworks | `/thought-leaders/aakash-gupta.md` |
| Rahul Vohra | PMF, Superhuman | `/thought-leaders/rahul-vohra.md` |
| Ravi Mehta | Strategy Stack | `/thought-leaders/ravi-mehta.md` |
| Lenny Rachitsky | Product Growth | `/thought-leaders/lenny-rachitsky.md` |
| Linear Method | Issues Not Stories | `/thought-leaders/linear-method.md` |
| Reforge | Growth Frameworks | `/thought-leaders/reforge.md` |
