---
name: spec
description: Write specifications at the right depth for any project. Progressive disclosure from quick Linear issues to full AI feature specs. Embeds Linear Method philosophy (brevity, clarity, momentum) with context engineering for AI features. Use for any spec work - quick tasks, features, or AI products.
---

# Spec - Progressive Disclosure Specification

## Core Philosophy

**Write what's needed. Skip what's not.**

Most specs fail because they're either:
- Too thin (unclear, leads to rework)
- Too thick (nobody reads them, decisions buried in prose)

This skill routes you to the right depth:
- **Quick task?** → Write a clear issue
- **Feature?** → Write a lite PRD
- **AI feature?** → Add context requirements and behavior examples

The templates are already excellent. This skill helps you use them.

---

## Linear Method Principles

These principles guide every level:

1. **Issues, not user stories** - Plain language wins. "Add export button to dashboard" beats "As a user, I want to export data so that I can..."

2. **Scope down** - If it can't be done in 1-3 weeks by 1-3 people, break it down further.

3. **Short specs get read** - Long specs get skipped. Write for clarity, not completeness.

4. **Prototype > documentation** - A working demo + 3 paragraphs beats a 10-page spec.

5. **Make decisions, not descriptions** - Every section should decide something.

**See:** `skills/spec/references/philosophy.md` for the full philosophy.

---

## Entry Point

When this skill is invoked, start with:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 SPEC
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

What are you speccing?

  1. Quick task (hours to days)
     → Clear title + optional description
     → If it fits in one sentence, just write an issue

  2. Feature (1-3 weeks)
     → Problem, solution, success metric, scope
     → Use what's helpful, skip the rest

  3. AI feature (any size)
     → Core AI questions + context requirements + behavior examples
     → Evals are non-negotiable. Model costs early.

  4. Not sure
     → Tell me what you're building, I'll help you decide

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**Parse intent from context:**
- If user says "issue" or mentions a quick task → Level 1
- If user mentions a feature, project, or gives detail → Level 2
- If user mentions AI, ML, LLM, context, prompts → Level 3
- If user provides a Linear issue ID → fetch it, then determine level

**Command-line shortcuts:**
- `/spec --quick` → Skip to Level 1
- `/spec --feature` → Skip to Level 2
- `/spec --ai` → Skip to Level 3
- `/spec LIN-123` → Fetch Linear issue, determine level

---

## Level 1: Quick Task (Linear Issue)

### When to Use
- Task is clear and focused
- Can be done in hours to a few days
- Title alone is almost enough
- No ambiguity about what "done" means

### Template
Use `templates/linear-issue.md` as reference.

### Flow

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 LEVEL 1: Quick Task
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

The goal: A title that makes it obvious what you're doing.
Everything else is optional.
```

**Questions to ask:**

1. **What's the action?** (Add, Fix, Design, Refactor, Remove...)

2. **What's being changed?** (The specific thing)

3. **Where?** (Optional: location in product)

**Good titles:**
- `Add CSV export to dashboard`
- `Fix: Login fails on Safari`
- `Design mobile navigation`
- `Refactor auth middleware`

**Bad titles:**
- `Export feature` (vague)
- `Bug` (what bug?)
- `Updates` (what updates?)

**When to add a description:**
- Context isn't obvious
- Specific requirements exist
- Edge cases need clarification
- Need to link to designs/specs

**When to skip description:**
- Title says it all
- Task is straightforward
- Team already understands context

### Output

Generate a clear issue ready for Linear:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 ISSUE READY
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Title: [Generated title]

Description:
[Optional description if needed]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

What next?

  1. Create in Linear
  2. Edit title/description
  3. Add more context (→ Level 2)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**If Linear MCP available:** Offer to create the issue directly.

---

## Level 2: Feature (Lite PRD)

### When to Use
- Feature needs alignment across team
- Scope is 1-3 weeks
- Need to document problem, solution, success criteria
- More than just "implement X"

### Template
Use `templates/lite-prd.md` as reference.

### Flow

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 LEVEL 2: Feature Spec
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

The goal: Shared understanding. Not completeness.

We'll answer 5 essential questions. Everything else is optional.
```

### The Essentials (Always answer)

**1. What problem are we solving?**
- 2-3 sentences
- Customer pain or opportunity
- Push for specificity

**2. For whom?**
- Specific user segment
- Not "users" - which users?

**3. How do we know this matters?**
- Evidence: research, data, feedback
- Not assumptions - what do you actually know?

**4. What are we building?**
- High-level solution
- Link to prototype if you have one (you should!)

**5. How will we know it worked?**
- 1-2 key metrics with targets
- Not "improve X" - what number?

### Optional Sections

After the essentials, offer relevant optional sections:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 ESSENTIALS COMPLETE
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

That might be all you need. Want to add any of these?

  □ Scope & Decisions (in/out of scope, open questions)
  □ Risks (assumptions, four risks check)
  □ Discovery Insights (research, data)
  □ Technical Notes (estimate, challenges, dependencies)
  □ Launch Notes (rollout strategy, communication)
  □ Timeline (Now/Next/Later)

Skip what doesn't help create shared understanding.
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### Output

Generate the spec in markdown:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 SPEC READY
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

# [Feature Name]

## The Essentials

**What problem:** [2-3 sentences]

**For whom:** [Specific segment]

**Evidence:** [What you know]

**Solution:** [What you're building + prototype link]

**Success:** [Metric with target]

[Optional sections if added]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

What next?

  1. Create Linear project (parent + child issues)
  2. Export markdown
  3. Go deeper (→ Level 4 options)
  4. Start over

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

---

## Level 3: AI Feature

### When to Use
- Building anything with AI/ML/LLM
- Need to define context requirements
- Need behavior examples for evals
- Cost modeling matters

### Templates
Use `templates/ai-product-spec.md` + context requirements table.

### Flow

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 LEVEL 3: AI Feature Spec
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

AI products need more upfront thinking - but not overly complex docs.

We'll cover:
  • Core AI questions (what, quality, testing, cost, failures)
  • Context requirements (what data the AI needs)
  • Behavior examples (what good/bad looks like)

Evals are non-negotiable. Model costs early.
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### Phase 1: Core AI Questions

Walk through these 5 questions (from `templates/ai-product-spec.md`):

**1. What's the AI doing?**
- What problem? What task?
- Push for precision: Not "recommendations" → "3 ranked options with rationale"

**2. How will you know if it's good?**
- What does "good" output look like?
- What's "bad"? What should never happen?

**3. How will you test it?**
- Eval strategy (even simple evals > no evals)
- Test dataset categories: happy path, edge cases, adversarial, boundary

**4. What will it cost?**
- Cost per query/user
- Projected at scale

**5. What happens when it's wrong?**
- User controls
- Fallbacks
- Safety guardrails

### Phase 2: Context Requirements

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 CONTEXT REQUIREMENTS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

90% of AI quality comes from context quality.

What context does the AI need to do its job?
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

Build a context requirements table:

| Data Needed | Source | Availability | Notes |
|-------------|--------|--------------|-------|
| [Entity/signal] | [DB/API/user] | [Always/Sometimes/Never] | [Sensitivity, freshness] |

**See:** `skills/spec/references/context-table.md` for the full format.

**Key questions:**
- For each piece of context: Where does it come from? Is it always available?
- What happens when context is missing? (Fallback behavior)
- Any privacy/sensitivity concerns?

**Flag problems immediately:**
- "Sometimes" availability needs a decision
- "Never" availability is a blocker

### Phase 3: Behavior Examples

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 BEHAVIOR EXAMPLES
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

AI behaves according to examples, not descriptions.

We need 5-10 examples minimum covering:
  • Good responses (what should happen)
  • Bad responses (common failure modes)
  • Reject cases (when AI should refuse/defer)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**Example format:**
```
Scenario: [Brief description]
Input: [What the user provides]
Good: [Desired response]
Bad: [What to avoid]
Reject: [When to refuse - if applicable]
```

**See:** `skills/spec/references/behavior-examples.md` for guidance.

**Coverage to aim for:**
- 2-3 happy path examples
- 2-3 edge cases
- 1-2 adversarial inputs
- 1-2 boundary cases (out of scope)

### Phase 4: Agency Progression Plan

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 AGENCY PROGRESSION
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

AI products earn autonomy. What's your ladder?

| Version | Capability | Control | Agency | What You're Testing |
|---------|------------|---------|--------|---------------------|
| V1      | [describe] | High    | Low    | [what you learn]    |
| V2      | [describe] | Medium  | Medium | [what you learn]    |
| V3      | [describe] | Low     | High   | [what you learn]    |

Which version are you speccing right now? (Usually V1)
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**Key questions:**
- What's the minimum viable agency for V1?
- What must the AI prove before V2?
- What would full autonomy (V3) even look like?

**See:** `skills/spec/references/agency-progression.md` for examples and ladder patterns.

### Phase 5: Control Handoffs

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 CONTROL HANDOFFS
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

How do humans take back control when the AI is wrong?

- Override mechanism: [how users correct/reject AI output]
- Escalation path: [when AI should defer to human]
- Feedback capture: [how corrections feed back into system]
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**Good control handoffs:**
- "AI suggested X. Accept or edit?"
- Clear confidence indicators
- Easy override path
- Corrections improve the system

**Bad control handoffs:**
- AI acts without confirmation
- No way to correct mistakes
- User doesn't know AI made the decision

### Phase 6: Reference Dataset

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 REFERENCE DATASET
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Before building, you need 20-100 examples of expected behavior.
This forces alignment on what "good" looks like.

Where will reference examples come from?
- [ ] Historical data (logs, past interactions)
- [ ] Manual curation (team creates examples)
- [ ] User research (observed behaviors)
- [ ] Synthetic generation (for edge cases)

Target count: [X] examples before V1 launch
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

**Why this matters:** Reference datasets force the team to align on expected behavior before writing prompts. Most AI features fail because teams skip this step.

**Golden dataset = baseline for evals.** Without it, you're testing against vibes.

### Output

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 AI SPEC READY
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

# [Feature Name]

## What's the AI Doing?
[Precise task description]

## Quality Definition
**Good:** [Criteria]
**Bad:** [What to avoid]

## Eval Strategy
[Test approach + dataset categories]

## Cost Model
[Cost per query + projection]

## Failure Handling
[User controls + fallbacks]

## Context Requirements

| Data | Source | Availability | Notes |
|------|--------|--------------|-------|
[Table]

**When context is missing:** [Fallback behavior]

## Behavior Examples

[5-10 examples]

## Agency Progression Plan

| Version | Capability | Control | Agency | What You're Testing |
|---------|------------|---------|--------|---------------------|
| V1 (this spec) | ... | High | Low | ... |
| V2 (future) | ... | Medium | Medium | ... |
| V3 (future) | ... | Low | High | ... |

## Control Handoffs

**Override:** [mechanism]
**Escalation:** [path]
**Feedback:** [capture method]

## Reference Dataset

**Source:** [where examples come from]
**Target:** [X] examples before launch
**Status:** [X/Y collected]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

What next?

  1. Create Linear project
  2. Export markdown
  3. Go deeper (→ Level 4 options)
  4. Run /ai-health-check
  5. Plan agency ladder (/agency-ladder)
  6. Set up post-launch calibration (/calibrate)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

---

## Level 4: Deep Dive (On-Demand)

When user needs more depth, offer these expansions:

```
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
 GO DEEPER
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

Your spec is solid. Need more depth anywhere?

  1. --deep context
     Full 4D Canvas walkthrough (Demand, Data, Discovery, Defense)

  2. --deep examples
     Expand to 15-25 behavior examples

  3. --deep rollout
     Detailed phased rollout with gates

  4. --deep full-prd
     Complete PRD framework (5 stages)

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### --deep context
Invoke the full 4D Context Canvas walkthrough:
- **D1 Demand:** Precise job definition
- **D2 Data:** Full context requirements mapping
- **D3 Discovery:** How to fetch context at runtime
- **D4 Defense:** Pre-checks, post-checks, fallbacks, feedback loops

Reference the archived context-engineering skill for the full framework.

### --deep examples
Expand behavior examples to 15-25:
- 5-7 happy path
- 4-5 edge cases
- 3-4 adversarial
- 3-4 boundary/reject cases

### --deep rollout
Detailed rollout planning:
- Phase 1: Internal/beta (%, duration, criteria)
- Phase 2: Limited rollout (%, gates)
- Phase 3: Full launch (criteria)
- Kill switch: When and how to turn off
- Monitoring: What to track, alert thresholds

### --deep full-prd
Invoke the prd-writer skill for the complete 5-stage PRD framework:
- Planning (Speclet)
- Kickoff
- Solution Review
- Launch Readiness
- Impact Review

---

## Linear Integration

When Linear MCP is available:

### Pulling Context
- `/spec LIN-123` → Fetch issue details, pre-populate what's available
- For parent issues, offer to pull child issues for context

### Creating Output

**Level 1:** Create issue directly via Linear MCP

**Level 2:** Offer to create:
- Parent issue with spec in description
- Child issues for implementation tasks

**Level 3:** Offer to create:
- Parent issue with full spec
- Child issues broken down by phase
- Context requirements in parent description

---

## Integration with Other Commands

**Before /spec:**
- `/four-risks` - Should we build this at all?

**After /spec:**
- `/ai-cost-check` - Model the unit economics
- `/ai-health-check` - Pre-launch validation
- `/ai-debug` - If feature is underperforming
- `/context-check` - Quick quality validation

---

## Attribution

**Linear Method:** Linear team (issues not stories, scope down, momentum)
**Lite PRD:** Aakash Gupta (Product Growth)
**AI Product Spec:** Aakash Gupta (Product Growth)
**Context Engineering:** Aakash Gupta & Miqdad Jaffer (OpenAI) - 4D Context Canvas

---

## Remember

- **Right-size your spec** - Don't write more than needed
- **Prototype first** - A demo + 3 paragraphs > 10-page spec
- **Make decisions** - Every section should decide something
- **Short specs get read** - Long specs get skipped
- **Evals are non-negotiable** - For AI features, define quality upfront
