# Agency Progression Reference

**Purpose:** Guide PMs in planning the v1→v2→v3 agency ladder for AI features.

**Framework Source:** CC/CD (Continuous Calibration/Continuous Development) - Aishwarya Naresh Reganti & Kiriti Badam

---

## The Core Principle

**AI products earn autonomy. They don't start with it.**

Every increase in AI agency means surrendering human control. This tradeoff must be intentional, not accidental.

```
Low Agency ←──────────────────→ High Agency
(Human decides)              (AI decides)

High Control ←──────────────→ Low Control
(Predictable)                (Unpredictable)
```

---

## The Agency Ladder

| Version | Control | Agency | Pattern |
|---------|---------|--------|---------|
| **V1** | High | Low | AI suggests, human decides |
| **V2** | Medium | Medium | AI handles routine, escalates edge cases |
| **V3** | Low | High | AI acts autonomously, human spot-checks |

**Key insight:** You're not ready to give high agency until you've thoroughly tested how the AI behaves at lower autonomy levels.

---

## Example Ladders

### Example 1: AI Customer Support Bot

**V1: Suggestion Mode**
```
Capability: AI drafts responses, human reviews before sending
Control: High (human approves everything)
Agency: Low (AI never acts alone)
Testing: Response quality, tone accuracy, edge case handling
```

**V2: Assisted Mode**
```
Capability: AI handles simple questions automatically, escalates complex ones
Control: Medium (human sets confidence thresholds)
Agency: Medium (AI handles ~60% of tickets)
Testing: Auto-response accuracy, escalation appropriateness
```

**V3: Autonomous Mode**
```
Capability: AI handles most questions end-to-end
Control: Low (human spot-checks sample)
Agency: High (AI handles ~90% of tickets)
Testing: Long-term quality stability, edge case discovery
```

**Promotion criteria V1→V2:**
- Auto-response accuracy >85%
- Customer satisfaction maintained
- No critical errors in 4 weeks

---

### Example 2: AI Code Review Assistant

**V1: Suggestion Mode**
```
Capability: AI analyzes PRs, suggests potential issues
Control: High (developer reviews all suggestions)
Agency: Low (AI never blocks or auto-fixes)
Testing: True positive rate, false positive tolerance
```

**V2: Gated Mode**
```
Capability: AI auto-comments on high-confidence issues, suggests fixes for medium
Control: Medium (confidence thresholds gate actions)
Agency: Medium (AI comments without approval)
Testing: Comment accuracy, developer sentiment
```

**V3: Blocking Mode**
```
Capability: AI blocks PRs with security issues, auto-fixes simple problems
Control: Low (AI makes merge decisions)
Agency: High (AI is a gatekeeper)
Testing: Block accuracy, false block rate, developer trust
```

**Promotion criteria V1→V2:**
- Suggestion accuracy >80%
- Developer action rate >50%
- Zero security issues missed

---

### Example 3: AI Content Writer

**V1: Draft Mode**
```
Capability: AI generates first draft, human edits substantially
Control: High (human rewrites most output)
Agency: Low (AI just provides starting point)
Testing: Draft usefulness, time saved vs blank page
```

**V2: Polish Mode**
```
Capability: AI generates near-final content, human edits lightly
Control: Medium (human adjusts tone/accuracy)
Agency: Medium (AI output is mostly publishable)
Testing: Edit rate, factual accuracy, voice consistency
```

**V3: Publish Mode**
```
Capability: AI generates and publishes with minimal review
Control: Low (human spot-checks sample)
Agency: High (AI drives content pipeline)
Testing: Quality consistency, brand safety, audience engagement
```

---

## Flywheel Table Format

When planning agency progression, fill out this table:

| Version | What You're Testing | What You Learn | What Feeds Next Loop |
|---------|---------------------|----------------|----------------------|
| V1 | [hypothesis] | [expected insights] | [data for V2 decisions] |
| V2 | [hypothesis] | [expected insights] | [data for V3 decisions] |
| V3 | [hypothesis] | [expected insights] | [ongoing calibration] |

**Example:**

| Version | What You're Testing | What You Learn | What Feeds Next Loop |
|---------|---------------------|----------------|----------------------|
| V1 | Can AI identify which clients to call? | Accuracy of signal detection, user trust in suggestions | Override patterns, correction types |
| V2 | Can AI prioritize the call list? | Ranking accuracy, user time saved | Edge cases requiring human judgment |
| V3 | Can AI draft the call script? | Script quality, conversion impact | Full automation viability |

---

## Promotion Criteria Checklist

Before moving from V(n) to V(n+1), verify:

**Quality Metrics:**
- [ ] Accuracy/quality metrics stable for 4+ weeks
- [ ] No new error patterns emerging
- [ ] User corrections decreasing over time

**Safety & Trust:**
- [ ] Confident in all known failure modes
- [ ] Override mechanism working well
- [ ] User feedback positive

**Operational Readiness:**
- [ ] Monitoring in place for new agency level
- [ ] Rollback plan if quality degrades
- [ ] Team aligned on promotion decision

**Documentation:**
- [ ] Error patterns documented
- [ ] Eval dataset expanded with prod learnings
- [ ] Runbook updated for new agency level

---

## Common Mistakes

**Skipping V1 entirely**
- "Let's just ship V3, it's faster"
- Result: Failure modes undiscovered, user trust destroyed

**Promoting too fast**
- "Quality looks good after 1 week"
- Result: Missed edge cases, quality regression

**No clear promotion criteria**
- "We'll know when it's ready"
- Result: Agency creep without validation

**Ignoring user corrections**
- "Users just don't understand the AI"
- Result: Missing the richest signal for improvement

---

## Questions to Ask

**When defining V1:**
- What's the minimum capability that tests our hypothesis?
- How will users override when the AI is wrong?
- What data will we collect to inform V2?

**When considering V2:**
- What did we learn from V1 corrections?
- Are there categories where AI is always right?
- What new risks does increased agency introduce?

**When considering V3:**
- Have we proven reliability across all scenarios?
- What does "spot-check" look like operationally?
- Are users comfortable with high autonomy?

---

## Integration with CC/CD

Agency progression is the **what** of CC/CD. The calibration loop is the **how**.

Use `/agency-ladder` to plan the progression.
Use `/calibrate` post-launch to execute the calibration loop.

---

**Remember:** Start with low agency. Earn autonomy through proven reliability. The ladder is the roadmap.
