# Context Requirements Table

## Purpose

The context requirements table documents what data your AI needs to do its job.

90% of AI quality comes from context quality. Most AI features fail because:
- Nobody mapped what context the model needs
- Nobody figured out how to get that context at runtime
- Nobody designed what happens when context is missing

This table prevents those failures.

---

## The Format

| Data Needed | Source | Availability | Notes |
|-------------|--------|--------------|-------|
| [Entity/signal] | [Where it lives] | [Always/Sometimes/Never] | [Sensitivity, freshness] |

### Column Definitions

**Data Needed**
The specific entity, document, metric, or signal the AI needs.
- Be specific: Not "user data" → "User's last 10 purchases"
- Include structure hints: "JSON array of product IDs"

**Source**
Where this data lives:
- Database (which table/collection)
- API (internal or external)
- User input (what they provide)
- Cache (pre-computed)
- Analytics/logs
- Inferred (from behavior)

**Availability**
How reliably can you get this data?

| Level | Meaning | Action Required |
|-------|---------|-----------------|
| Always | Available 100% of the time | None |
| Sometimes | Depends on user actions or data freshness | Design fallback |
| Never | Must be requested or cannot be assumed | Resolve blocker |

**Notes**
Critical metadata:
- **Sensitivity:** PII, internal-only, restricted, public
- **Freshness:** Real-time, daily, weekly, stale
- **Size:** Token count, truncation needed
- **Permissions:** Who can access

---

## Example Tables

### Email Subject Line Suggestions

| Data Needed | Source | Availability | Notes |
|-------------|--------|--------------|-------|
| Email body (user's draft) | User input | Always | Max 500 chars, truncate |
| User's previous subjects | Database | Sometimes | Last 10, may be empty for new users |
| Industry/domain | User profile | Always | Set at signup |
| Preferred tone | User settings | Sometimes | Default: professional |

**Fallback:** If no history, use industry defaults + general best practices.

---

### AI Code Review

| Data Needed | Source | Availability | Notes |
|-------------|--------|--------------|-------|
| PR diff | GitHub API | Always | Full diff, may be large |
| File context (surrounding code) | GitHub API | Always | +/- 50 lines |
| Repo conventions (.editorconfig, etc.) | Repo files | Sometimes | May not exist |
| Team's past review patterns | Internal DB | Sometimes | Cold start for new repos |
| Language-specific rules | Static config | Always | Pre-loaded |

**Fallback:** If no repo conventions, use language defaults. If no past patterns, rely on general best practices.

---

### Personalized Recommendations

| Data Needed | Source | Availability | Notes |
|-------------|--------|--------------|-------|
| User equity estimate | Internal DB | Always | PII - handle carefully |
| Browsing history (30 days) | Analytics | Always | May hit token limits |
| Stated goals | User input | Sometimes | Only if completed onboarding |
| Local market trends | External API | Always | Daily refresh, public data |
| Purchase history | Internal DB | Always | Last 20 transactions |
| Risk tolerance | User settings | Sometimes | Default: moderate |

**Fallback:** If no stated goals, infer from browsing behavior. If no risk tolerance, use moderate default.

---

## Filling Out the Table

### Step 1: List What the AI Needs

Start with the AI's job (from D1) and ask:
- What must the AI know to do this correctly?
- What would a human expert need to see?

Common categories:
- **User context:** Preferences, history, profile, permissions
- **Domain context:** Entities, relationships, rules, definitions
- **Environment context:** Time, location, recent actions, current state
- **Task context:** The specific input/request

### Step 2: Map Each to a Source

For each piece of context:
- Where does this data actually live?
- Is there an API? A database table? User input?
- Is it real-time or cached?

### Step 3: Assess Availability

Be honest:
- **Always:** You can reliably fetch this 100% of the time
- **Sometimes:** It depends (new users, optional fields, flaky APIs)
- **Never:** Doesn't exist yet, or can't be accessed

**"Sometimes" and "Never" need decisions:**
- What's the fallback when it's missing?
- Is this a blocker? Can we build without it?

### Step 4: Add Critical Notes

For each row:
- Any PII or sensitivity concerns?
- How fresh does it need to be?
- Any size limits (tokens)?
- Who has permission to access?

---

## Fallback Design

**Every "Sometimes" row needs a fallback.**

Good fallback patterns:
- **Use defaults:** "If no preference, assume moderate"
- **Infer from behavior:** "If no stated goal, infer from last 5 actions"
- **Ask the user:** "Required field before AI can proceed"
- **Degrade gracefully:** "Show generic response with caveat"
- **Block generation:** "Cannot proceed without X"

Document fallbacks directly in the table notes or in a separate section:

```markdown
## What happens when context is missing?

| Missing Data | Fallback |
|--------------|----------|
| User preferences | Use segment defaults |
| Recent history | Ask clarifying question |
| Domain entities | Show generic response + caveat |
```

---

## Integration with Spec

Add this section to your AI spec:

```markdown
### Context Requirements

**What context does the AI need?**

| Data | Source | Availability | Notes |
|------|--------|--------------|-------|
| ... | ... | ... | ... |

**What happens when context is missing?**
[Fallback behavior - one sentence per row with "Sometimes" or "Never"]
```

---

## Common Mistakes

### Mistake 1: Too Vague
**Bad:** "User data"
**Good:** "User's last 10 purchases (product ID, price, date)"

### Mistake 2: Assuming Availability
**Bad:** "User preferences" (Always)
**Good:** "User preferences" (Sometimes - only if completed settings)

### Mistake 3: No Fallback
**Bad:** "User goals" (Sometimes) - no fallback defined
**Good:** "User goals" (Sometimes) - infer from browsing if missing

### Mistake 4: Ignoring Sensitivity
**Bad:** "User equity estimate" - no sensitivity note
**Good:** "User equity estimate" - PII, restricted access

---

## Attribution

**Framework:** 4D Context Canvas (D2: Data)
**Authors:** Aakash Gupta & Miqdad Jaffer (OpenAI)
