# Spec Philosophy: The Linear Method

## Core Principle

**Write what's needed. Skip what's not.**

Short specs are more likely to be read. Long specs get skipped.
The goal is shared understanding, not documentation completeness.

---

## Issues, Not User Stories

**Traditional (ceremonial):**
```
As a user, I want to export data,
so that I can analyze it offline.
```

**Modern (clear):**
```
Add CSV export to dashboard
```

Why this matters:
- Plain language is faster to write and read
- User story format is ceremony, not clarity
- Action + what + where = enough

**Test:** Can someone read the title and know what you're doing?

---

## Scope Down

**The rule:** If it can't be done in 1-3 weeks by 1-3 people, break it down.

Why this matters:
- Small batches = faster feedback
- Big projects hide complexity
- Momentum beats perfection

**Signs you need to scope down:**
- "It depends" shows up in discussions
- Timeline stretches beyond 3 weeks
- Multiple teams need to coordinate
- Requirements keep expanding

**How to scope down:**
1. What's the smallest thing that would be useful?
2. What can we cut and ship later?
3. What's the riskiest assumption we should test first?

---

## Prototype > Documentation

**A working demo + 3 paragraphs beats a 10-page spec.**

Why this matters:
- Prototypes surface problems faster than docs
- Seeing > reading > imagining
- AI tools make prototyping fast

**The new flow:**
```
Idea → Quick prototype → Short spec → Refined prototype → Ship
```

**Not:**
```
Idea → Long spec → Long review → Build → Discover problems
```

**If you're spending more time on the spec than prototyping, you're doing it backwards.**

---

## Make Decisions, Not Descriptions

Every section should decide something.

**Bad (describes):**
```
We will test the feature with users to ensure it meets their needs.
```

**Good (decides):**
```
A/B test with 5% of users for 2 weeks. Graduate if retention +10% at p<0.05.
```

**Bad (vague):**
```
Improve user engagement.
```

**Good (measurable):**
```
Increase 7-day retention from 40% to 48%.
```

**Test:** After reading a section, can you tell exactly what to do?

---

## Labels > Long Descriptions

Use labels to add context without writing paragraphs:

**Priority:** `P0` `P1` `P2` `P3`
**Type:** `feature` `bug` `design` `tech-debt`
**Area:** `auth` `dashboard` `api` `mobile` `ai`
**Status:** `blocked` `needs-design` `needs-review`

A well-labeled issue with a clear title often needs no description.

---

## Who Writes the Spec?

**The person doing the work** (when possible):
- Engineers write implementation issues
- Designers write design issues
- PMs write exploratory/research issues

They understand it best. They own it.

---

## When to Add More

**Add a description when:**
- Context isn't obvious
- Specific requirements exist
- Edge cases need clarification
- Need to link designs/specs

**Skip description when:**
- Title says it all
- Task is straightforward
- Team already understands context

**Level up when:**
- Multiple people need alignment
- Stakes are high
- Feature is complex
- Building AI (context requirements matter)

---

## The Hierarchy

```
Issue (hours-days)
  ↓ needs more
Lite PRD (1-3 weeks)
  ↓ needs more
AI Spec (with context requirements)
  ↓ needs more
Full PRD (5-stage process)
```

Start at the top. Only go down when you genuinely need it.

---

## Antipatterns

### User Story Theater
Writing "As a user, I want..." when "Add X to Y" would be clearer.

### PRD in the Issue
10 paragraphs of strategy when you just need to describe a task.
(Put strategy in PRDs, keep issues focused.)

### Vague Titles
"Dashboard improvements" vs "Add loading states to dashboard cards"

### One-and-Done
Writing a spec once and never updating it.
(Specs evolve with the product.)

### Metric Theater
"Improve engagement" vs "Increase 7-day retention from 40% to 48%"

---

## The Spirit of It

**Traditional:** Follow the format exactly.

**Modern:** Communicate clearly so work gets done.

Questions to ask:
1. Can someone read this and know what to do?
2. Did I decide something or just describe something?
3. Is this the shortest version that creates shared understanding?

---

## Attribution

**Source:** Linear Method (Linear team)
**Key influences:**
- "Issues, not user stories"
- "Scope down"
- "Short specs get read"
- Momentum over perfection
