# Validation Checkpoints

各フェーズの完了時に検証するチェックリスト。

## RED Phase

- [ ] 全テストが実装より先に書かれている
- [ ] 全テストが意味のあるエラーメッセージで失敗する
- [ ] 失敗原因が実装不在によるもの（テストのバグではない）
- [ ] 偶発的に成功するテストがない

## GREEN Phase

- [ ] 全テストが成功する
- [ ] テスト要件を超えるコードがない
- [ ] カバレッジが閾値を満たす（thresholds.md 参照）
- [ ] テスト自体を修正して通していない

## REFACTOR Phase

- [ ] リファクタリング後も全テストが成功する
- [ ] コード複雑度が低下している
- [ ] 重複コードが排除されている
- [ ] パフォーマンスが維持/改善されている
- [ ] テストの可読性が向上している

## Success Criteria

サイクル全体の成功基準:

- 100% のコードがテストファーストで書かれている
- 全テストが継続的に成功する
- カバレッジが閾値を超えている
- ユニットテスト実行時間 < 5秒
