# TDD Resources

## 推奨記事

### 日本語記事

1. [【翻訳】テスト駆動開発の定義](https://t-wada.hatenablog.jp/#%E3%82%B9%E3%83%86%E3%83%83%E3%83%972-%E3%81%B2%E3%81%A8%E3%81%A4%E3%83%86%E3%82%B9%E3%83%88%E3%82%92%E6%9B%B8%E3%81%8F)
   - t-wada氏による古典的名著の翻訳
   - TDDの本質を理解するための必読書

2. [保守しやすく変化に強いソフトウェアを支える柱　自動テストとテスト駆動開発、その全体像](https://gihyo.jp/article/2024/01/automated-test-and-tdd)
   - 自動テストとTDDの全体像を体系的に解説

3. [テスト駆動開発（TDD：Test-Driven Development）を学ぶ](https://zenn.dev/camoneart/articles/9ff099c724b421)
   - camoneによる実践的なTDD学習記事

## Kent Beckの三原則

1. まず壊れたテストを書き、
2. それをできるだけ早く動くようにして、
3. その後で必要な改善をする

## よくある間違い

- **テストを後から書く**: TDDではない。テストファーストが必須
- **完璧なコードを最初から書こうとする**: Greenフェーズでは「動く最小限のコード」で良い
- **テストが失敗したままリファクタリング**: 全テスト成功状態でのみリファクタリング
- **大きすぎるステップ**: 1つのテストは1つの小さな機能に集中
