# Interview Phases

5フェーズで段階的に深堀りする。各フェーズの開始時にユーザーに現在のフェーズを明示すること。

## Phase 1: 概要・ゴール（3-5問）

機能の全体像と成功基準を把握する。

**質問の方向性:**

- この機能が解決する根本的な課題は何か（表面的な要望でなく、なぜ必要か）
- ターゲットユーザーは誰で、現在どう回避しているか
- 成功をどう測定するか（具体的なメトリクス）
- 明確にスコープ外とすべきものは何か

**深堀りの例:**

- 「ユーザー認証を追加したい」→「認証が必要な理由は？マルチテナント？課金連動？権限モデルはどの程度複雑？」
- 「ダッシュボードを作りたい」→「誰が、いつ、どんな意思決定のために見る？リアルタイム性は必要？」

## Phase 2: 技術的実装（10-15問）

最も深く掘り下げるフェーズ。表面的な技術選定で終わらず、設計判断の根拠と境界条件まで問う。

**質問の方向性:**

### アーキテクチャ

- コンポーネント間の境界はどこに引くか
- 同期/非同期の境界はどこか
- 既存システムとの統合ポイントは何か

### データ設計

- エンティティ間のリレーションと基数（1:N, N:N）
- インデックス戦略（どのクエリパターンを最適化するか）
- データのライフサイクル（作成→更新→アーカイブ→削除）
- マイグレーション戦略（既存データの扱い）

### API設計

- エンドポイントの粒度（リソース単位 vs ユースケース単位）
- 認証・認可モデル（誰が何にアクセスできるか）
- ページネーション・フィルタリング戦略
- バージョニング方針

### 状態管理・データフロー

- クライアント/サーバー間の状態同期戦略
- キャッシュ戦略（何を、どこで、どのくらいの期間）
- 楽観的更新 vs 悲観的更新

### 外部依存

- サードパーティAPI/サービスとの統合
- 障害時のフォールバック戦略
- レート制限への対応

**深堀りの例:**

- 「DBはPostgreSQLを使う」→「インデックス戦略は？全文検索は必要？パーティショニングの検討は？読み書き比率はどのくらい？」
- 「REST APIを作る」→「バッチ操作は必要？Webhook通知は？冪等性の保証は必要？タイムアウト戦略は？」
- 「Redisでキャッシュする」→「キャッシュ無効化戦略は？キャッシュスタンピード対策は？永続化は必要？」

## Phase 3: UI/UX（5-10問 ※該当する場合）

UI がない機能の場合はスキップ可能。

**質問の方向性:**

- 主要な操作フローのステップ（ハッピーパス）
- 状態遷移図（ローディング、空、エラー、成功の各状態）
- フォームのバリデーションタイミング（リアルタイム vs 送信時）
- レスポンシブ対応の優先ブレイクポイント
- アクセシビリティ要件（キーボード操作、スクリーンリーダー）
- 既存UIとの一貫性をどう保つか

**深堀りの例:**

- 「一覧画面を作る」→「無限スクロール vs ページネーション？ソート・フィルターの組み合わせは？選択操作（一括削除等）は必要？」
- 「フォームを作る」→「途中保存（ドラフト）は必要？入力補助（オートコンプリート等）は？離脱時の確認ダイアログは？」

## Phase 4: エッジケース・非機能要件（5-10問）

正常系を超えた堅牢性に踏み込む。

**質問の方向性:**

### エッジケース

- 同時編集・競合状態への対処
- 大量データ時の挙動（数千件→数百万件でどう変わるか）
- ネットワーク断絶・タイムアウト時のリカバリ
- 不正な入力・悪意のあるリクエストへの防御

### セキュリティ

- 認証・認可の境界（何が公開で何が保護か）
- 入力バリデーション戦略（サーバーサイド必須、クライアントは利便性）
- 機密データの取り扱い（暗号化、マスキング、ログ除外）

### パフォーマンス

- レスポンスタイム目標（P50, P99）
- スループット要件（ピーク時の想定）
- 負荷が集中するボトルネック箇所

### 運用

- ログ・モニタリング戦略
- エラー通知の閾値と通知先
- デプロイ・ロールバック手順

**深堀りの例:**

- 「ユーザーが同時に編集したら？」→「最終書き込み勝利？楽観的ロック？リアルタイム共同編集？コンフリクト解決UIは？」
- 「検索機能を作る」→「100万件時の応答速度目標は？インデックス更新の遅延許容は？ファジー検索・タイポ許容は？」

## Phase 5: トレードオフ・未決定事項（3-5問）

選択の理由と、意図的に後回しにするものを明確にする。

**質問の方向性:**

- 技術選定で迷っている点とその判断基準
- MVP（最小実装）と理想形の境界
- 将来の拡張を見越して今やるべきこと vs 後回しにすべきこと
- 既知のリスクとその緩和策
- この仕様で最も自信がない部分はどこか

**深堀りの例:**

- 「Next.js App Router を使う」→「Pages Router で十分な部分は？SSR/SSG/ISRの使い分けは明確？」
- 「マイクロサービスにする」→「この段階でモノリスの方がシンプルでは？分割の境界は本当にここで正しい？」

## インタビュー完了の判断基準

以下すべてを満たした時にインタビューを終了する:

1. 全5フェーズを一通りカバーした
2. ユーザーが「完了」「十分」と明示した、または追加質問に対して新しい情報が出なくなった
3. Acceptance Criteria を書けるだけの具体性がある
4. 実装タスクを依存関係付きで分割できるだけの情報がある
