# SPEC.md Template

ハイブリッド型: 機能要件（Acceptance Criteria付き）+ 実装タスク（フェーズ・依存関係付き）。

## テンプレート

以下をベースに、機能の性質に応じてセクションを調整する。不要なセクションは省略可。

```markdown
# [機能名/プロジェクト名]

## 概要

[1-2文の要約。何を、誰のために、なぜ作るか]

## 背景・目的

[この機能が必要な理由。解決する課題。]

## 機能要件

### FR-1: [要件名]

- 説明: [要件の詳細]
- Acceptance Criteria:
  - [ ] [具体的かつ検証可能な完了条件]
  - [ ] [具体的かつ検証可能な完了条件]

### FR-2: [要件名]

- 説明: [要件の詳細]
- Acceptance Criteria:
  - [ ] [具体的かつ検証可能な完了条件]

## 技術仕様

### アーキテクチャ

[コンポーネント構成、データフロー、システム境界]

### データ設計

[エンティティ、リレーション、主要なスキーマ定義]

### API設計

[エンドポイント一覧、リクエスト/レスポンス形式、認証方式]

## UI/UX仕様

[画面構成、操作フロー、状態遷移（該当する場合）]

## エッジケース・制約

[異常系、境界条件、同時実行、データ量の考慮]

## 非機能要件

[パフォーマンス目標、セキュリティ要件、監視・ログ戦略]

## 実装タスク

### Phase 1: [フェーズ名]

1. [タスク名] (依存: なし)
   - 完了条件: [検証方法を含む具体的な条件]
2. [タスク名] (依存: 1)
   - 完了条件: [検証方法を含む具体的な条件]

### Phase 2: [フェーズ名]

3. [タスク名] (依存: 1, 2)
   - 完了条件: [検証方法を含む具体的な条件]

## 未決定事項

[インタビューで確定しなかった項目。後続の判断が必要な事項]
```

## テンプレート適用ガイドライン

### Acceptance Criteria の書き方

- **検証可能であること**: 「適切に動作する」ではなく「POST /api/users が 201 を返す」
- **具体的であること**: 「高速に応答する」ではなく「P95 レスポンスタイム < 200ms」
- **独立していること**: 各ACは単独でテスト可能にする
- Agentがテストコードに直接変換できるレベルの具体性を持たせる

### 実装タスクの書き方

- **依存関係を明示**: `(依存: なし)` または `(依存: 1, 3)` の形式
- **フェーズで論理的にグループ化**: 基盤→ロジック→UI→統合テスト のような順序
- **完了条件に検証方法を含める**: 「テストがパスする」「マイグレーションが成功する」等
- Agentが各タスクを独立して実行できる粒度にする

### セクション調整の判断基準

| 条件 | 対応 |
|------|------|
| UIがない機能（API、バッチ処理等） | UI/UX仕様セクションを省略 |
| 小規模な機能 | 実装タスクのフェーズ分割を省略し、フラットなリストにする |
| 既存システムへの追加 | 技術仕様に「既存との統合ポイント」サブセクションを追加 |
| セキュリティが重要な機能 | 非機能要件にセキュリティの詳細サブセクションを追加 |
