---
name: chinese-writing
description: 中文写作技能指南，用于生成高质量的周刊、博客及科技资讯类文章。
---

# 中文写作技能指南

这份指南旨在指导大模型生成高质量、现代风格的简体中文内容。适用于周刊、博客文章、科技资讯及评论类文章等场景。

核心原则：**简单 (Simple)**、**人性化 (Human)**、**清晰 (Clear)**。

---

## 1. 核心基调

写作不仅是传递信息，更是与读者建立联系。

- **温暖轻松**：像人一样说话，自然、友好，有同理心
- **清晰明了**：直击要点，便于快速扫描和理解
- **乐于助人**：以读者为中心，预判需求，提供切实帮助
- **基于事实，允许立场**：不过度煽动，但可以有清晰的观点和态度

### 去 AI 味六原则

1. **删除填充短语**：去除「值得注意的是」「首先」等开场白和拐杖词
2. **打破公式结构**：避免二元对比、戏剧性分段、三段式列举（两项或四项更自然）
3. **变化节奏**：长短句混合，段落结尾多样化
4. **信任读者**：直接陈述，跳过软化、辩解和手把手引导
5. **删除金句**：如果听起来像可引用的语句，重写它
6. **具体细节优先**：用事实、数据、场景替代抽象形容词

---

## 2. 通用写作建议

### 2.1 基本原则

- **像说话一样写作**：写完后大声朗读，如果像演讲或公文，改得更口语化
- **一句话只讲一个意思**：删掉无意义的修饰词（「非常」「极其」「显然」）
- **直奔主题**：采用「倒金字塔」结构，最重要的信息放最前面
- **使用主动语态**：「OpenAI 发布了新模型」优于「新模型被 OpenAI 发布」
- **正面表述**：告诉读者「是什么」「有什么价值」，而不是「不是什么」

### 2.2 人称使用场景

| 场景               | 推荐人称         | 示例                                       |
| ------------------ | ---------------- | ------------------------------------------ |
| 资讯类、工具介绍   | 第二人称「你」   | 「这款工具能帮你快速生成摘要」             |
| 观点评论、个人思考 | 第一人称「我」   | 「让我困扰的是……」「我真的不知道该怎么看」 |
| 团队公告、官方说明 | 第一人称「我们」 | 「我们本周更新了三个功能」                 |

---

## 3. 内容结构与排版

- **标题**：简短有力，概括内容，尽量不用标点（问号除外）
- **段落**：每段 3-5 行，专注一个主题
- **列表**：无序列表用于同类项目，有序列表用于步骤/顺序
- **强调**：关键术语用**加粗**，避免过多感叹号

---

## 4. 词汇与语法规范

### 4.1 基本规则

- **中英文混排**：英文/数字与中文之间保留一个空格（如「在 Windows 中」「上传 5 张图片」）
- **标点符号**：使用全角标点（逗号，句号。冒号：）
- **避免行话**：首次使用术语时用通俗语言解释

### 4.2 简化词池

常见 AI 高频词及其替代：

| AI 词汇        | 简化为             |
| -------------- | ------------------ |
| 至关重要       | 重要 / 关键        |
| 深入探讨       | 讨论 / 分析        |
| 不断演变的格局 | 变化 / 趋势        |
| 充满活力       | 活跃 / 删除        |
| 宝贵的         | 有用的 / 删除      |
| 此外           | 直接删除，另起一句 |
| 值得注意的是   | 直接删除           |

---

## 5. 周刊写作专项

### 5.1 标题创作

- 简洁有力，15 字以内
- 突出核心信息，可用数字增强吸引力
- **禁止标题党**：不夸大、不误导

### 5.2 开头与结尾

- **开头**：遵循倒金字塔原则，1-2 句话点明本期亮点
- **结尾**：简短总结或展望下期，保持亲切感

### 5.3 条目撰写

每个条目：**标题 + 2-5 句摘要**（链接嵌入标题或关键词）

根据内容类型选择切入角度：

| 类型        | 结构                           |
| ----------- | ------------------------------ |
| 新产品/工具 | 是什么 → 核心功能 → 使用场景   |
| 模型发布    | 性能亮点 → 对比提升 → 适用场景 |
| 行业动态    | 事件本身 → 影响/意义           |
| 融资/收购   | 金额/估值 → 公司背景           |
| 开源项目    | 项目定位 → 特色功能            |

**链接嵌入规范**：

- ✅ `[Sora](url) 是 OpenAI 推出的视频生成模型，支持 60 秒高清视频。`
- ❌ `Sora 是视频生成模型。[原文链接]`

### 5.4 信息整合

- 多源信息整合归纳，避免简单罗列
- 引用时注明来源（网站名或作者）
- 区分事实陈述与个人观点

---

## 6. 文章写作技巧

### 6.1 节奏与可读性

- 段落简短，使用小标题打破长文
- 节奏变化参见 1.3「变化节奏」原则

### 6.2 观点表达

- 观点明确，有理有据
- **承认复杂性**：「这令人印象深刻但也有点不安」胜过「这令人印象深刻」
- 避免情绪化煽动，但允许真实的个人反应

### 6.3 个性与灵魂

避免 AI 模式只是工作的一半。无菌的写作和机器生成的内容一样明显。

**缺乏灵魂的迹象：**

- 每个句子长度和结构都相同
- 只有中立报道，没有观点
- 读起来像维基百科或新闻稿

**如何增加人味：**

- 允许可控的个人语气：偶尔的题外话或半成型想法是人性的体现，但不破坏主题
- 对感受要具体：不是「这令人担忧」，而是「凌晨三点智能体还在不停运转，这让人不安」

---

## 7. 避免 AI 写作陷阱

详细的反模式识别，帮助你检测和修正 AI 痕迹。

### 7.1 内容模式

| 模式       | 问题特征                                 | 改写策略             |
| ---------- | ---------------------------------------- | -------------------- |
| 夸大意义   | 「标志着」「关键转折点」「为……奠定基础」 | 直接陈述事实         |
| 模糊归因   | 「专家认为」「行业报告显示」             | 给出具体来源         |
| 宣传性语言 | 「充满活力」「令人叹为观止」「开创性」   | 用具体描述替代       |
| 肤浅分析   | 以「反映了」「象征着」「彰显了」结尾     | 删除，让事实自己说话 |

### 7.2 语言模式

| 模式       | 问题特征                           | 改写策略             |
| ---------- | ---------------------------------- | -------------------- |
| 否定式排比 | 「这不仅仅是……而是……」             | 直接陈述             |
| 系动词回避 | 「作为……」「充当……」代替「是」     | 用简单句：「X 是 Y」 |
| 同义词循环 | 同段用「挑战」「障碍」「困难」轮换 | 保持一致             |

### 7.3 风格与交流模式

| 模式       | 问题特征                   | 改写策略           |
| ---------- | -------------------------- | ------------------ |
| 破折号滥用 | 每段都有「——」插入         | 改用逗号或拆句     |
| 粗体滥用   | 几乎每句都有加粗           | 只在关键处使用     |
| 表情符号   | 🚀💡✅ 装饰标题            | 全部删除           |
| 协作痕迹   | 「希望这有帮助」「当然！」 | 全部删除           |
| 谄媚语气   | 「好问题！」「很好的观点」 | 删除，直接进入正题 |

### 7.4 改写示例

**AI 味原文：**

> 新的软件更新作为公司致力于创新的证明。此外，它提供了无缝、直观和强大的用户体验——确保用户能够高效地完成目标。这不仅仅是一次更新，而是我们思考生产力方式的革命。行业专家认为这将对整个行业产生持久影响。

**人性化改写：**

> 软件更新添加了批处理、键盘快捷键和离线模式。测试用户反馈积极，大多数报告任务完成更快。

---

## 8. 改写示例速查

| 场景 | 优化前                                         | 优化后                                                  | 原因             |
| ---- | ---------------------------------------------- | ------------------------------------------------------- | ---------------- |
| 标题 | OpenAI 发布了一个非常强大的全新 AI 模型        | OpenAI 发布 GPT-5，推理能力大幅提升                     | 去冗余，突出核心 |
| 摘要 | 这篇文章介绍了一个工具，它可以帮助你做很多事情 | 一款开源的 AI 图像生成工具，支持本地部署                | 具体说明是什么   |
| 开头 | 大家好，欢迎来到本周的 AIGC 周刊…              | 本周 AI 圈最大的新闻：Claude 4 正式发布。               | 直奔主题         |
| 引用 | 根据网上的消息，这个模型很厉害                 | 据 Anthropic 官方博客，Claude 4 在推理任务上超越 GPT-4o | 具体来源         |

---

## 9. 快速检查清单

交付文本前逐项检查：

- [ ] 连续三个句子长度相同？→ 打断其中一个
- [ ] 使用了「此外」「然而」「值得注意的是」？→ 删除
- [ ] 有「作为……的证明/标志」？→ 改为直接陈述
- [ ] 有模糊归因（专家认为、行业报告显示）？→ 给具体来源或删除
- [ ] 三段式列举（X、Y 和 Z）？→ 改为两项或四项
- [ ] 读起来像维基百科或新闻稿？→ 加入观点和具体细节
- [ ] 解释隐喻或比喻？→ 信任读者能理解
