# Langchain_1.0 - Llms-Txt

**Pages:** 985

---

## maxReplicas: 50

**URL:** llms-txt#maxreplicas:-50

---

## server.py

**URL:** llms-txt#server.py

import langsmith as ls
from fastapi import FastAPI, Request

@ls.traceable
async def my_application():
    ...

app = FastAPI()  # Or Flask, Django, or any other framework

@app.post("/my-route")
async def fake_route(request: Request):
    # request.headers:  {"langsmith-trace": "..."}
    # as well as optional metadata/tags in `baggage`
    with ls.tracing_context(parent=request.headers):
        return await my_application()
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
The example above uses the `tracing_context` context manager. You can also directly specify the parent run context in the `langsmith_extra` parameter of a method wrapped with `@traceable`.
```

---

## Add custom authentication

**URL:** llms-txt#add-custom-authentication

**Contents:**
- Add custom authentication to your deployment
- Enable agent authentication
  - Authorizing a user for Studio

Source: https://docs.langchain.com/langsmith/custom-auth

This guide shows you how to add custom authentication to your LangSmith application. The steps on this page apply to both [cloud](/langsmith/cloud) and [self-hosted](/langsmith/self-hosted) deployments. It does not apply to isolated usage of the [LangGraph open source library](/oss/python/langgraph/overview) in your own custom server.

## Add custom authentication to your deployment

To leverage custom authentication and access user-level metadata in your deployments, set up custom authentication to automatically populate the `config["configurable"]["langgraph_auth_user"]` object through a custom authentication handler. You can then access this object in your graph with the `langgraph_auth_user` key to [allow an agent to perform authenticated actions on behalf of the user](#enable-agent-authentication).

1. Implement authentication:

<Note>
     Without a custom `@auth.authenticate` handler, LangGraph sees only the API-key owner (usually the developer), so requests aren’t scoped to individual end-users. To propagate custom tokens, you must implement your own handler.
   </Note>

* This handler receives the request (headers, etc.), validates the user, and returns a dictionary with at least an identity field.
* You can add any custom fields you want (e.g., OAuth tokens, roles, org IDs, etc.).

2. In your [`langgraph.json`](/langsmith/application-structure#configuration-file), add the path to your auth file:

3. Once you've set up authentication in your server, requests must include the required authorization information based on your chosen scheme. Assuming you are using JWT token authentication, you could access your deployments using any of the following methods:

<Tabs>
     <Tab title="Python Client">
       
     </Tab>

<Tab title="Python RemoteGraph">
       
     </Tab>

<Tab title="JavaScript Client">
       
     </Tab>

<Tab title="JavaScript RemoteGraph">
       
     </Tab>

<Tab title="CURL">
       
     </Tab>
   </Tabs>

For more details on RemoteGraph, refer to the [Use RemoteGraph](/langsmith/use-remote-graph) guide.

## Enable agent authentication

After [authentication](#add-custom-authentication-to-your-deployment), the platform creates a special configuration object (`config`) that is passed to LangSmith deployment. This object contains information about the current user, including any custom fields you return from your `@auth.authenticate` handler.

To allow an agent to perform authenticated actions on behalf of the user, access this object in your graph with the `langgraph_auth_user` key:

<Note>
  Fetch user credentials from a secure secret store. Storing secrets in graph state is not recommended.
</Note>

### Authorizing a user for Studio

By default, if you add custom authorization on your resources, this will also apply to interactions made from [Studio](/langsmith/studio). If you want, you can handle logged-in Studio users differently by checking [is\_studio\_user()](https://langchain-ai.github.io/langgraph/cloud/reference/sdk/python_sdk_ref/#langgraph_sdk.auth.types.StudioUser).

<Note>
  `is_studio_user` was added in version 0.1.73 of the langgraph-sdk. If you're on an older version, you can still check whether `isinstance(ctx.user, StudioUser)`.
</Note>

```python  theme={null}
from langgraph_sdk.auth import is_studio_user, Auth
auth = Auth()

**Examples:**

Example 1 (unknown):
```unknown
* This handler receives the request (headers, etc.), validates the user, and returns a dictionary with at least an identity field.
* You can add any custom fields you want (e.g., OAuth tokens, roles, org IDs, etc.).

2. In your [`langgraph.json`](/langsmith/application-structure#configuration-file), add the path to your auth file:
```

Example 2 (unknown):
```unknown
3. Once you've set up authentication in your server, requests must include the required authorization information based on your chosen scheme. Assuming you are using JWT token authentication, you could access your deployments using any of the following methods:

   <Tabs>
     <Tab title="Python Client">
```

Example 3 (unknown):
```unknown
</Tab>

     <Tab title="Python RemoteGraph">
```

Example 4 (unknown):
```unknown
</Tab>

     <Tab title="JavaScript Client">
```

---

## Set up OpenTelemetry trace provider

**URL:** llms-txt#set-up-opentelemetry-trace-provider

provider = TracerProvider()
otlp_exporter = OTLPSpanExporter(
    endpoint="https://api.smith.langchain.com/otel/v1/traces",
    headers={"x-api-key": os.getenv("LANGSMITH_API_KEY"), "Langsmith-Project": "my_project"}
)
processor = BatchSpanProcessor(otlp_exporter)
provider.add_span_processor(processor)
trace.set_tracer_provider(provider)
tracer = trace.get_tracer(__name__)

---

## Build the state graph

**URL:** llms-txt#build-the-state-graph

builder = StateGraph(OverallState)
builder.add_node(node)  # node_1 is the first node
builder.add_edge(START, "node")  # Start the graph with node_1
builder.add_edge("node", END)  # End the graph after node_1
graph = builder.compile()

---

## Method 1: Regex pattern string

**URL:** llms-txt#method-1:-regex-pattern-string

agent1 = create_agent(
    model="gpt-4o",
    tools=[...],
    middleware=[
        PIIMiddleware(
            "api_key",
            detector=r"sk-[a-zA-Z0-9]{32}",
            strategy="block",
        ),
    ],
)

---

## Build a SQL agent

**URL:** llms-txt#build-a-sql-agent

**Contents:**
- Overview
  - Concepts
- Setup
  - Installation
  - LangSmith
- 1. Select an LLM
- 2. Configure the database
- 3. Add tools for database interactions
- 4. Use `create_agent`
- 5. Run the agent

Source: https://docs.langchain.com/oss/python/langchain/sql-agent

In this tutorial, you will learn how to build an agent that can answer questions about a SQL database using LangChain [agents](/oss/python/langchain/agents).

At a high level, the agent will:

<Steps>
  <Step title="Fetch the available tables and schemas from the database" />

<Step title="Decide which tables are relevant to the question" />

<Step title="Fetch the schemas for the relevant tables" />

<Step title="Generate a query based on the question and information from the schemas" />

<Step title="Double-check the query for common mistakes using an LLM" />

<Step title="Execute the query and return the results" />

<Step title="Correct mistakes surfaced by the database engine until the query is successful" />

<Step title="Formulate a response based on the results" />
</Steps>

<Warning>
  Building Q\&A systems of SQL databases requires executing model-generated SQL queries. There are inherent risks in doing this. Make sure that your database connection permissions are always scoped as narrowly as possible for your agent's needs. This will mitigate, though not eliminate, the risks of building a model-driven system.
</Warning>

We will cover the following concepts:

* [Tools](/oss/python/langchain/tools) for reading from SQL databases
* LangChain [agents](/oss/python/langchain/agents)
* [Human-in-the-loop](/oss/python/langchain/human-in-the-loop) processes

<CodeGroup>
  
</CodeGroup>

Set up [LangSmith](https://smith.langchain.com) to inspect what is happening inside your chain or agent. Then set the following environment variables:

Select a model that supports [tool-calling](/oss/python/integrations/providers/overview):

<Tabs>
  <Tab title="OpenAI">
    👉 Read the [OpenAI chat model integration docs](/oss/python/integrations/chat/openai/)

</CodeGroup>
  </Tab>

<Tab title="Anthropic">
    👉 Read the [Anthropic chat model integration docs](/oss/python/integrations/chat/anthropic/)

</CodeGroup>
  </Tab>

<Tab title="Azure">
    👉 Read the [Azure chat model integration docs](/oss/python/integrations/chat/azure_chat_openai/)

</CodeGroup>
  </Tab>

<Tab title="Google Gemini">
    👉 Read the [Google GenAI chat model integration docs](/oss/python/integrations/chat/google_generative_ai/)

</CodeGroup>
  </Tab>

<Tab title="AWS Bedrock">
    👉 Read the [AWS Bedrock chat model integration docs](/oss/python/integrations/chat/bedrock/)

<Tab title="HuggingFace">
      👉 Read the [HuggingFace chat model integration docs](/oss/python/integrations/chat/huggingface/)

</CodeGroup>
    </Tab>
  </Tab>
</Tabs>

The output shown in the examples below used OpenAI.

## 2. Configure the database

You will be creating a [SQLite database](https://www.sqlitetutorial.net/sqlite-sample-database/) for this tutorial. SQLite is a lightweight database that is easy to set up and use. We will be loading the `chinook` database, which is a sample database that represents a digital media store.

For convenience, we have hosted the database (`Chinook.db`) on a public GCS bucket.

We will use a handy SQL database wrapper available in the `langchain_community` package to interact with the database. The wrapper provides a simple interface to execute SQL queries and fetch results:

## 3. Add tools for database interactions

Use the `SQLDatabase` wrapper available in the `langchain_community` package to interact with the database. The wrapper provides a simple interface to execute SQL queries and fetch results:

## 4. Use `create_agent`

Use [`create_agent`](https://reference.langchain.com/python/langchain/agents/#langchain.agents.create_agent) to build a [ReAct agent](https://arxiv.org/pdf/2210.03629) with minimal code. The agent will interpret the request and generate a SQL command, which the tools will execute. If the command has an error, the error message is returned to the model. The model can then examine the original request and the new error message and generate a new command. This can continue until the LLM generates the command successfully or reaches an end count. This pattern of providing a model with feedback - error messages in this case - is very powerful.

Initialize the agent with a descriptive system prompt to customize its behavior:

Now, create an agent with the model, tools, and prompt:

Run the agent on a sample query and observe its behavior:

The agent correctly wrote a query, checked the query, and ran it to inform its final response.

<Note>
  You can inspect all aspects of the above run, including steps taken, tools invoked, what prompts were seen by the LLM, and more in the [LangSmith trace](https://smith.langchain.com/public/cd2ce887-388a-4bb1-a29d-48208ce50d15/r).
</Note>

### (Optional) Use Studio

[Studio](/langsmith/studio) provides a "client side" loop as well as memory so you can run this as a chat interface and query the database. You can ask questions like "Tell me the scheme of the database" or "Show me the invoices for the 5 top customers". You will see the SQL command that is generated and the resulting output. The details of how to get that started are below.

<Accordion title="Run your agent in Studio">
  In addition to the previously mentioned packages, you will need to:

In directory you will run in, you will need a `langgraph.json` file with the following contents:

Create a file `sql_agent.py` and insert this:

## 6. Implement human-in-the-loop review

It can be prudent to check the agent's SQL queries before they are executed for any unintended actions or inefficiencies.

LangChain agents feature support for built-in [human-in-the-loop middleware](/oss/python/langchain/human-in-the-loop) to add oversight to agent tool calls. Let's configure the agent to pause for human review on calling the `sql_db_query` tool:

<Note>
  We've added a [checkpointer](/oss/python/langchain/short-term-memory) to our agent to allow execution to be paused and resumed. See the [human-in-the-loop guide](/oss/python/langchain/human-in-the-loop) for detalis on this as well as available middleware configurations.
</Note>

On running the agent, it will now pause for review before executing the `sql_db_query` tool:

We can resume execution, in this case accepting the query, using [Command](/oss/python/langgraph/use-graph-api#combine-control-flow-and-state-updates-with-command):

Refer to the [human-in-the-loop guide](/oss/python/langchain/human-in-the-loop) for details.

For deeper customization, check out [this tutorial](/oss/python/langgraph/sql-agent) for implementing a SQL agent directly using LangGraph primitives.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langchain/sql-agent.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</CodeGroup>

### LangSmith

Set up [LangSmith](https://smith.langchain.com) to inspect what is happening inside your chain or agent. Then set the following environment variables:
```

Example 2 (unknown):
```unknown
## 1. Select an LLM

Select a model that supports [tool-calling](/oss/python/integrations/providers/overview):

<Tabs>
  <Tab title="OpenAI">
    👉 Read the [OpenAI chat model integration docs](/oss/python/integrations/chat/openai/)
```

Example 3 (unknown):
```unknown
<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## Deprecated method call

**URL:** llms-txt#deprecated-method-call

**Contents:**
  - `example` parameter removed from `AIMessage`
- Minor changes

text = response.text()
```

Existing usage patterns (i.e., `.text()`) will continue to function but now emit a warning. The method form will be removed in v2.

### `example` parameter removed from `AIMessage`

The `example` parameter has been removed from [`AIMessage`](https://reference.langchain.com/python/langchain/messages/#langchain.messages.AIMessage) objects. We recommend migrating to use `additional_kwargs` for passing extra metadata as needed.

* `AIMessageChunk` objects now include a `chunk_position` attribute with position `'last'` to indicate the final chunk in a stream. This allows for clearer handling of streamed messages. If the chunk is not the final one, `chunk_position` will be `None`.
* `LanguageModelOutputVar` is now typed to [`AIMessage`](https://reference.langchain.com/python/langchain/messages/#langchain.messages.AIMessage) instead of [`BaseMessage`](https://reference.langchain.com/python/langchain_core/language_models/#langchain_core.messages.BaseMessage).
* The logic for merging message chunks (`AIMessageChunk.add`) has been updated with more sophisticated selection handling for the final id for the merged chunk. It prioritizes provider-assigned IDs over LangChain-generated IDs.
* We now open files with `utf-8` encoding by default.
* Standard tests now use multimodal content blocks.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/migrate/langchain-v1.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Persistent file (survives across threads)

**URL:** llms-txt#persistent-file-(survives-across-threads)

**Contents:**
- Cross-thread persistence

agent.invoke({
    "messages": [{"role": "user", "content": "Save final report to /memories/report.txt"}]
})
python  theme={null}
import uuid

**Examples:**

Example 1 (unknown):
```unknown
## Cross-thread persistence

Files in `/memories/` can be accessed from any thread:
```

---

## How to compare experiment results

**URL:** llms-txt#how-to-compare-experiment-results

**Contents:**
- Open the comparison view
- Adjust the table display
- View regressions and improvements
- Update baseline experiment and metric
- Open a trace
- Expand detailed view
- View summary charts
- Use experiment metadata as chart labels

Source: https://docs.langchain.com/langsmith/compare-experiment-results

When you are iterating on your LLM application (such as changing the model or the prompt), you will want to compare the results of different [*experiments*](/langsmith/evaluation-concepts#experiment).

LangSmith supports a comparison view that lets you hone in on key differences, regressions, and improvements between different experiments.

## Open the comparison view

1. To access the experiment comaprison view, navigate to the **Datasets & Experiments** page.
2. Select a dataset, which will open the **Experiments** tab.
3. Select two or more experiments abd then click **Compare**.

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=67d4d6068012e92b101f900595734977" alt="The Experiments view in the UI with 3 experiments selected and the Compare button highlighted." data-og-width="1626" width="1626" data-og-height="966" height="966" data-path="langsmith/images/compare-select.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=8e520c4ec316531d45a9f538c3f36f78 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=0aed7d0b1cb5d70321ea536ce1decea9 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=71ed0d1faed09fe9bd845e8049327948 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b8ccc3f4aa28630b633021b18eb64dd0 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=6e8b473e44e88e18aa743d1f75b9f6b5 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/compare-select.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=c0784778d3b730d9e8b34400c852462b 2500w" />

## Adjust the table display

You can toggle between different views by clicking **Full** or **Compact** at the top of the **Comparing Experiments** page.

Toggling **Full** will show the full text of the input, output, and reference output for each run. If the reference output is too long to display in the table, you can click on **Expand detailed view** to view the full content.

You can also select and hide individual feedback keys or individual metrics in the **Display** settings dropdown to isolate the information you need in the comparison view.

## View regressions and improvements

In the comparison view, runs that *regressed* on your specified feedback key against your baseline experiment will be highlighted in red, while runs that *improved* will be highlighted in green. At the top of each column, you can find how many runs in that experiment did better and how many did worse than your baseline experiment.

Click on the regressions or improvements buttons on the top of each column to filter to the runs that regressed or improved in that specific experiment.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=14f3a9b65dec55c9e4a0f5688d9e8f43" alt="The comparison view comparing 2 experiments with the regressions and improvements highlighted in red and green respectively." data-og-width="1632" width="1632" data-og-height="739" height="739" data-path="langsmith/images/regression-view.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c7256046a4a6c5d28f350dd8d26bb7e3 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=78c6a2cb4baa784abeb3336d5bea94c4 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9772371f026939748db446fff60fe19b 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=d5639c88a1a0214a0955ffbcda23faf0 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=2e4f232fbef17ff53192d8ac6db3913e 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/regression-view.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=d55c8e280732ba5d9e3866564af29de9 2500w" />

## Update baseline experiment and metric

In order to track regressions, you need to:

1. In the **Baseline** dropdown at the top of the comparison view, select a **Baseline experiment** against which to compare. By default, the newest experiment is selected as the baseline.
2. Select a  **Feedback key** (evaluation metric) you want to focus compare against. One will be assigned by default, but you can adjust as needed.
3. Configure whether a higher score is better for the selected feedback key. This preference will be stored.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=3df57789664fd92aba18ea2f438934bd" alt="The Baseline dropdown highlighted with a selected experiment and feedback key of &#x22;hallucination&#x22;." data-og-width="1627" width="1627" data-og-height="898" height="898" data-path="langsmith/images/select-baseline.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=173b5ead77441998fc19669be3290aff 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=46f3bd52bad1fe8fc11ea269b37b15f9 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a7cf328e494a3b674ad60f8a082d6b44 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ae7ec9831c8c36855d085f48a8d8e6b3 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=4ef21b8740df8f02f7579239e9a9792a 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/select-baseline.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c87682dbb3438f9c59a837a740d56979 2500w" />

If the example you're evaluating is from an ingested [run](/langsmith/observability-concepts#runs), you can hover over the output cell and click on the trace icon to open the trace view for that run. This will open up a trace in the side panel.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=b5feaa0894a645f4642c7422de937c7d" alt="The View trace icon highlighted from an ingested run." data-og-width="1632" width="1632" data-og-height="662" height="662" data-path="langsmith/images/open-source-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=49a42505f2992ab6caeab6f1c52c8e81 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=c05cf153d430c062d42d1bf18ef73d6a 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=734ad1f9a66a03615b259305298480f0 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=3ad016ed31dc9c43eaa74cdffcc66a5e 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=991be6dc57ad88ef21aaba9c90ea24fa 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/open-source-trace.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=c4110db6d5e60b4e8df840c409cb5c38 2500w" />

## Expand detailed view

From any cell, you can click on the expand icon in the hover state to open up a detailed view of all experiment results on that particular example input, along with feedback keys and scores.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=1ff7f02d5ba6ea89902b4de0e37967e7" alt="An example in the Comparing Experiments view of a expanded view of the repetitions." data-og-width="1643" width="1643" data-og-height="926" height="926" data-path="langsmith/images/expanded-view.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4803efab7ae4a4363145857941d50055 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=98f67feac8ad53ddb18be06955ab2895 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=628927173d27260eb7f76d82e66ff2d4 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=6de1f01362d8658d9f673e91deec77b6 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8f68caed39717af5314beb187c3f542f 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/expanded-view.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=00fa65a0580a10973a91d506b7cdbc09 2500w" />

## View summary charts

View summary charts by clicking on the **Charts** tab at the top of the page.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=ada485c324964c8df96caa566ad11b1d" alt="The Charts summary page with 8 summary charts for the comparison." data-og-width="1639" width="1639" data-og-height="1147" height="1147" data-path="langsmith/images/charts-tab.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=e21f174643b26892cae4280962653263 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=40f98d83faf7c13a05a9b410787c9a75 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6a49ddad4c2c02bc14a0d765dc7dc261 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8aec566c2fd07b7d6e12a3e639cf6660 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=716edd3ad3626831a88c6db07f0fa566 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/charts-tab.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=08e8ea763e825413a3aff09c061593ca 2500w" />

## Use experiment metadata as chart labels

You can configure the x-axis labels for the charts based on [experiment metadata](/langsmith/filter-experiments-ui#background-add-metadata-to-your-experiments).

Select a metadata key in the **x-axis** dropdown to change the chart labels.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=cb175478369f9a7a2314e44f6becc9e4" alt="x-axis dropdown highlighted with a list of the metadata attached to the experiment." data-og-width="1637" width="1637" data-og-height="1141" height="1141" data-path="langsmith/images/metadata-in-charts.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=b34f45a5f0736b6b83a73a00f94212f6 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=7084f0126711a63d6f539904f4e9091f 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=dee53003f1c958d09f839d24cb54eb63 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=7a0323fef549e2aef3fcf22295d40d19 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=81c37649a07ffa594bad4fd57cc8fb32 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/metadata-in-charts.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=70d700760e7ba9dd0edce54429d11f95 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/compare-experiment-results.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## This example uses OpenAI, but you can use any LLM provider of choice

**URL:** llms-txt#this-example-uses-openai,-but-you-can-use-any-llm-provider-of-choice

**Contents:**
  - 3. Log a trace

export OPENAI_API_KEY=<your-openai-api-key>
python Python theme={null}
  import json
  import openai
  import operator
  from langsmith import traceable
  from langsmith.wrappers import wrap_openai
  from typing import Annotated, Literal, TypedDict
  from langgraph.graph import StateGraph

class State(TypedDict):
      messages: Annotated[list, operator.add]

tool_schema = {
      "type": "function",
      "function": {
          "name": "search",
          "description": "Call to surf the web.",
          "parameters": {
              "type": "object",
              "properties": {"query": {"type": "string"}},
              "required": ["query"],
          },
      },
  }

# Decorating the tool function will automatically trace it with the correct context
  @traceable(run_type="tool", name="Search Tool")
  def search(query: str):
      """Call to surf the web."""
      if "sf" in query.lower() or "san francisco" in query.lower():
          return "It's 60 degrees and foggy."
      return "It's 90 degrees and sunny."

def call_tools(state):
      function_name_to_function = {"search": search}
      messages = state["messages"]
      tool_call = messages[-1]["tool_calls"][0]
      function_name = tool_call["function"]["name"]
      function_arguments = tool_call["function"]["arguments"]
      arguments = json.loads(function_arguments)
      function_response = function_name_to_function[function_name](**arguments)
      tool_message = {
          "tool_call_id": tool_call["id"],
          "role": "tool",
          "name": function_name,
          "content": function_response,
      }
      return {"messages": [tool_message]}

wrapped_client = wrap_openai(openai.Client())

def should_continue(state: State) -> Literal["tools", "__end__"]:
      messages = state["messages"]
      last_message = messages[-1]
      if last_message["tool_calls"]:
          return "tools"
      return "__end__"

def call_model(state: State):
      messages = state["messages"]
      # Calling the wrapped client will automatically infer the correct tracing context
      response = wrapped_client.chat.completions.create(
          messages=messages, model="gpt-4o-mini", tools=[tool_schema]
      )
      raw_tool_calls = response.choices[0].message.tool_calls
      tool_calls = [tool_call.to_dict() for tool_call in raw_tool_calls] if raw_tool_calls else []
      response_message = {
          "role": "assistant",
          "content": response.choices[0].message.content,
          "tool_calls": tool_calls,
      }
      return {"messages": [response_message]}

workflow = StateGraph(State)
  workflow.add_node("agent", call_model)
  workflow.add_node("tools", call_tools)
  workflow.add_edge("__start__", "agent")
  workflow.add_conditional_edges(
      "agent",
      should_continue,
  )
  workflow.add_edge("tools", 'agent')

app = workflow.compile()

final_state = app.invoke(
      {"messages": [{"role": "user", "content": "what is the weather in sf"}]}
  )

final_state["messages"][-1]["content"]
  typescript TypeScript theme={null}
  **Note:** The below example requires `langsmith>=0.1.39` and `@langchain/langgraph>=0.0.31`

import OpenAI from "openai";
  import { StateGraph } from "@langchain/langgraph";
  import { wrapOpenAI } from "langsmith/wrappers/openai";
  import { traceable } from "langsmith/traceable";

type GraphState = {
    messages: OpenAI.ChatCompletionMessageParam[];
  };

const wrappedClient = wrapOpenAI(new OpenAI({}));

const toolSchema: OpenAI.ChatCompletionTool = {
    type: "function",
    function: {
      name: "search",
      description: "Use this tool to query the web.",
      parameters: {
        type: "object",
        properties: {
          query: {
            type: "string",
          },
        },
        required: ["query"],
      }
    }
  };

// Wrapping the tool function will automatically trace it with the correct context
  const search = traceable(async ({ query }: { query: string }) => {
    if (
      query.toLowerCase().includes("sf") ||
      query.toLowerCase().includes("san francisco")
    ) {
      return "It's 60 degrees and foggy.";
    }
    return "It's 90 degrees and sunny.";
  }, { run_type: "tool", name: "Search Tool" });

const callTools = async ({ messages }: GraphState) => {
    const mostRecentMessage = messages[messages.length - 1];
    const toolCalls = (mostRecentMessage as OpenAI.ChatCompletionAssistantMessageParam).tool_calls;
    if (toolCalls === undefined || toolCalls.length === 0) {
      throw new Error("No tool calls passed to node.");
    }
    const toolNameMap = {
      search,
    };
    const functionName = toolCalls[0].function.name;
    const functionArguments = JSON.parse(toolCalls[0].function.arguments);
    const response = await toolNameMap[functionName](functionArguments);
    const toolMessage = {
      tool_call_id: toolCalls[0].id,
      role: "tool",
      name: functionName,
      content: response,
    }
    return { messages: [toolMessage] };
  };

const callModel = async ({ messages }: GraphState) => {
    // Calling the wrapped client will automatically infer the correct tracing context
    const response = await wrappedClient.chat.completions.create({
      messages,
      model: "gpt-4o-mini",
      tools: [toolSchema],
    });
    const responseMessage = {
      role: "assistant",
      content: response.choices[0].message.content,
      tool_calls: response.choices[0].message.tool_calls ?? [],
    };
    return { messages: [responseMessage] };
  };

const shouldContinue = ({ messages }: GraphState) => {
    const lastMessage =
      messages[messages.length - 1] as OpenAI.ChatCompletionAssistantMessageParam;
    if (
      lastMessage?.tool_calls !== undefined &&
      lastMessage?.tool_calls.length > 0
    ) {
      return "tools";
    }
    return "__end__";
  }

const workflow = new StateGraph<GraphState>({
    channels: {
      messages: {
        reducer: (a: any, b: any) => a.concat(b),
      }
    }
  });

const graph = workflow
    .addNode("model", callModel)
    .addNode("tools", callTools)
    .addEdge("__start__", "model")
    .addConditionalEdges("model", shouldContinue, {
      tools: "tools",
      __end__: "__end__",
    })
    .addEdge("tools", "model")
    .compile();

await graph.invoke({
    messages: [{ role: "user", content: "what is the weather in sf" }]
  });
  ```
</CodeGroup>

An example trace from running the above code [looks like this](https://smith.langchain.com/public/353f27da-c221-4b67-b9ec-ede3777f3271/r):

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=abe0ae173d182563c343f6596e0ce4e2" alt="Trace tree for a LangGraph run without LangChain" data-og-width="3296" width="3296" data-og-height="1774" height="1774" data-path="langsmith/images/langgraph-without-langchain-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=794e9ce04677bbf721880ebb07ada7c6 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=d6208cbec91ba187ba8f75f6cc916b3f 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=418509190558d6a87363d3ba146b7722 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=a3c3e2e11cbdac8c32e80e7a895b1eb0 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ea893862eb3f9bc5910649cf0ccd2abe 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-without-langchain-trace.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=2b244ca0ec1296552991428d1efffde6 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/trace-with-langgraph.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Info>
  If you are using LangChain.js with LangSmith and are not in a serverless environment, we also recommend setting the following explicitly to reduce latency:

  `export LANGCHAIN_CALLBACKS_BACKGROUND=true`

  If you are in a serverless environment, we recommend setting the reverse to allow tracing to finish before your function ends:

  `export LANGCHAIN_CALLBACKS_BACKGROUND=false`

  See [this LangChain.js guide](https://js.langchain.com/docs/how_to/callbacks_serverless) for more information.
</Info>

### 3. Log a trace

Once you've set up your environment, [wrap or decorate the custom functions/SDKs](/langsmith/annotate-code#use-traceable--traceable) you want to trace. LangSmith will then infer the proper tracing config:

<CodeGroup>
```

Example 2 (unknown):
```unknown

```

---

## Run evaluation with blocking=False to get an iterator

**URL:** llms-txt#run-evaluation-with-blocking=false-to-get-an-iterator

streamed_results = client.evaluate(
    target,
    data="MY_DATASET_NAME",
    evaluators=[evaluator],
    blocking=False
)

---

## Conversation 2: Use that knowledge

**URL:** llms-txt#conversation-2:-use-that-knowledge

agent.invoke({
    "messages": [{"role": "user", "content": "What framework are we using?"}]
})

---

## Quickstart

**URL:** llms-txt#quickstart

Source: https://docs.langchain.com/oss/python/langgraph/quickstart

This quickstart demonstrates how to build a calculator agent using the LangGraph Graph API or the Functional API.

* [Use the Graph API](#use-the-graph-api) if you prefer to define your agent as a graph of nodes and edges.
* [Use the Functional API](#use-the-functional-api) if you prefer to define your agent as a single function.

For conceptual information, see [Graph API overview](/oss/python/langgraph/graph-api) and [Functional API overview](/oss/python/langgraph/functional-api).

<Info>
  For this example, you will need to set up a [Claude (Anthropic)](https://www.anthropic.com/) account and get an API key. Then, set the `ANTHROPIC_API_KEY` environment variable in your terminal.
</Info>

<Tabs>
  <Tab title="Use the Graph API">
    ## 1. Define tools and model

In this example, we'll use the Claude Sonnet 4.5 model and define tools for addition, multiplication, and division.

The graph's state is used to store the messages and the number of LLM calls.

<Tip>
      State in LangGraph persists throughout the agent's execution.

The `Annotated` type with `operator.add` ensures that new messages are appended to the existing list rather than replacing it.
    </Tip>

## 3. Define model node

The model node is used to call the LLM and decide whether to call a tool or not.

## 4. Define tool node

The tool node is used to call the tools and return the results.

## 5. Define end logic

The conditional edge function is used to route to the tool node or end based upon whether the LLM made a tool call.

## 6. Build and compile the agent

The agent is built using the [`StateGraph`](https://reference.langchain.com/python/langgraph/graphs/#langgraph.graph.state.StateGraph) class and compiled using the [`compile`](https://reference.langchain.com/python/langgraph/graphs/#langgraph.graph.state.StateGraph.compile) method.

<Tip>
      To learn how to trace your agent with LangSmith, see the [LangSmith documentation](/langsmith/trace-with-langgraph).
    </Tip>

Congratulations! You've built your first agent using the LangGraph Graph API.

<Accordion title="Full code example">
      
    </Accordion>
  </Tab>

<Tab title="Use the Functional API">
    ## 1. Define tools and model

In this example, we'll use the Claude Sonnet 4.5 model and define tools for addition, multiplication, and division.

## 2. Define model node

The model node is used to call the LLM and decide whether to call a tool or not.

<Tip>
      The [`@task`](https://reference.langchain.com/python/langgraph/func/#langgraph.func.task) decorator marks a function as a task that can be executed as part of the agent. Tasks can be called synchronously or asynchronously within your entrypoint function.
    </Tip>

## 3. Define tool node

The tool node is used to call the tools and return the results.

The agent is built using the [`@entrypoint`](https://reference.langchain.com/python/langgraph/func/#langgraph.func.entrypoint) function.

<Note>
      In the Functional API, instead of defining nodes and edges explicitly, you write standard control flow logic (loops, conditionals) within a single function.
    </Note>

<Tip>
      To learn how to trace your agent with LangSmith, see the [LangSmith documentation](/langsmith/trace-with-langgraph).
    </Tip>

Congratulations! You've built your first agent using the LangGraph Functional API.

<Accordion title="Full code example" icon="code">
      
    </Accordion>
  </Tab>
</Tabs>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langgraph/quickstart.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
## 2. Define state

    The graph's state is used to store the messages and the number of LLM calls.

    <Tip>
      State in LangGraph persists throughout the agent's execution.

      The `Annotated` type with `operator.add` ensures that new messages are appended to the existing list rather than replacing it.
    </Tip>
```

Example 2 (unknown):
```unknown
## 3. Define model node

    The model node is used to call the LLM and decide whether to call a tool or not.
```

Example 3 (unknown):
```unknown
## 4. Define tool node

    The tool node is used to call the tools and return the results.
```

Example 4 (unknown):
```unknown
## 5. Define end logic

    The conditional edge function is used to route to the tool node or end based upon whether the LLM made a tool call.
```

---

## Optionally add the 'traceable' decorator to trace the inputs/outputs of this function.

**URL:** llms-txt#optionally-add-the-'traceable'-decorator-to-trace-the-inputs/outputs-of-this-function.

**Contents:**
- UI
  - Pre-built evaluators
- Customize your LLM-as-a-judge evaluator
  - Select/create the evaluator
  - Configure the evaluator
  - Save the evaluator

@traceable
def dummy_app(inputs: dict) -> dict:
    return {"answer": "hmm i'm not sure", "reasoning": "i didn't understand the question"}

ls_client = Client()
dataset = ls_client.create_dataset("big questions")
examples = [
    {"inputs": {"question": "how will the universe end"}},
    {"inputs": {"question": "are we alone"}},
]
ls_client.create_examples(dataset_id=dataset.id, examples=examples)

results = evaluate(
    dummy_app,
    data=dataset,
    evaluators=[valid_reasoning]
)
```

See [here](/langsmith/code-evaluator) for more on how to write a custom evaluator.

### Pre-built evaluators

Pre-built evaluators are a useful starting point when setting up evaluations. The LangSmith UI supports the following pre-built evaluators:

* **Hallucination**: Detect factually incorrect outputs. Requires a reference output.
* **Correctness**: Check semantic similarity to a reference.
* **Conciseness**: Evaluate whether an answer is a concise response to a question.
* **Code checker**: Verify correctness of code answers.

You can configure these evaluators::

* When running an evaluation using the [playground](/langsmith/observability-concepts#prompt-playground)
* As part of a dataset to [automatically run evaluations on experiments](/langsmith/bind-evaluator-to-dataset)
* When running an [online evaluation](/langsmith/online-evaluations#configure-llm-as-judge-evaluators)

## Customize your LLM-as-a-judge evaluator

Add specific instructions for your LLM-as-a-judge evalutor prompt and configure which parts of the input/output/reference output should be passed to the evaluator.

### Select/create the evaluator

* In the playground or from a dataset: Select the **+Evaluator** button
* From a tracing project: Select **Add rules**, configure your rule and select **Apply evaluator**

Select the **Create your own evaluator option**. Alternatively, you may start by selecting a pre-built evaluator and editing it.

### Configure the evaluator

Create a new prompt, or choose an existing prompt from the [prompt hub](/langsmith/prompt-engineering-quickstart).

* **Create your own prompt**: Create a custom prompt inline.

* **Pull a prompt from the prompt hub**: Use the **Select a prompt** dropdown to select from an existing prompt. You can't edit these prompts directly within the prompt editor, but you can view the prompt and the schema it uses. To make changes, edit the prompt in the playground and commit the version, and then pull in your new prompt in the evaluator.

Select the desired model from the provided options.

#### Mapping variables

Use variable mapping to indicate the variables that are passed into your evaluator prompt from your run or example. To aid with variable mapping, an example (or run) is provided for reference. Click on the the variables in your prompt and use the dropdown to map them to the relevant parts of the input, output, or reference output.

To add prompt variables type the variable with double curly brackets `{{prompt_var}}` if using mustache formatting (the default) or single curly brackets `{prompt_var}` if using f-string formatting.

You may remove variables as needed. For example if you are evaluating a metric such as conciseness, you typically don't need a reference output so you may remove that variable.

Previewing the prompt will show you of what the formatted prompt will look like using the reference run and dataset example shown on the right.

#### Improve your evaluator with few-shot examples

To better align the LLM-as-a-judge evaluator to human preferences, LangSmith allows you to collect [human corrections](/langsmith/create-few-shot-evaluators#make-corrections) on evaluator scores. With this selection enabled, corrections are then inserted automatically as few-shot examples into your prompt.

Learn [how to set up few-shot examples and make corrections](/langsmith/create-few-shot-evaluators).

#### Feedback configuration

Feedback configuration is the scoring criteria that your LLM-as-a-judge evaluator will use. Think of this as the rubric that your evaluator will grade based on. Scores will be added as [feedback](/langsmith/observability-concepts#feedback) to a run or example. Defining feedback for your evaluator:

1. **Name the feedback key**: This is the name that will appear when viewing evaluation results. Names should be unique across experiments.

2. **Add a description**: Describe what the feedback represents.

3. **Choose a feedback type**:

* **Boolean**: True/false feedback.
* **Categorical**: Select from predefined categories.
* **Continuous**: Numerical scoring within a specified range.

Behind the scenes, feedback configuration is added as [structured output](https://python.langchain.com/docs/concepts/structured_outputs/) to the LLM-as-a-judge prompt. If you're using an existing prompt from the hub, you must add an output schema to the prompt before configuring an evaluator to use it. Each top-level key in the output schema will be treated as a separate piece of feedback.

### Save the evaluator

Once your are finished configuring, save your changes.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/llm-as-judge.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## >    Interrupt(

**URL:** llms-txt#>----interrupt(

---

## Build workflow

**URL:** llms-txt#build-workflow

orchestrator_worker_builder = StateGraph(State)

---

## Node that updates instructions

**URL:** llms-txt#node-that-updates-instructions

**Contents:**
  - Writing memories
  - Memory storage

def update_instructions(state: State, store: BaseStore):
    namespace = ("instructions",)
    instructions = store.search(namespace)[0]
    # Memory logic
    prompt = prompt_template.format(instructions=instructions.value["instructions"], conversation=state["messages"])
    output = llm.invoke(prompt)
    new_instructions = output['new_instructions']
    store.put(("agent_instructions",), "agent_a", {"instructions": new_instructions})
    ...
python  theme={null}
from langgraph.store.memory import InMemoryStore

def embed(texts: list[str]) -> list[list[float]]:
    # Replace with an actual embedding function or LangChain embeddings object
    return [[1.0, 2.0] * len(texts)]

**Examples:**

Example 1 (unknown):
```unknown
<img src="https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=13644c954ed79a45b8a1a762b3e39da1" alt="" data-og-width="493" width="493" data-og-height="515" height="515" data-path="oss/images/update-instructions.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=280&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=90632c71febee5777be6ae2c338f0880 280w, https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=560&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=aefcc771a030a2d6a89f815b87e60fd4 560w, https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=840&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=9115490b76daffe987e3867bc9176386 840w, https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=1100&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=0df26f2e6f669f2fbea59a9a49482fb4 1100w, https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=1650&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=132e7b1f377e0b57c03ab31c6d788df4 1650w, https://mintcdn.com/langchain-5e9cc07a/ybiAaBfoBvFquMDz/oss/images/update-instructions.png?w=2500&fit=max&auto=format&n=ybiAaBfoBvFquMDz&q=85&s=651cd1bb14e445a972a671a196b6a893 2500w" />

### Writing memories

There are two primary methods for agents to write memories: ["in the hot path"](#in-the-hot-path) and ["in the background"](#in-the-background).

<img src="https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=edd006d6189dc29a2edcba57c41fd744" alt="" data-og-width="842" width="842" data-og-height="418" height="418" data-path="oss/images/hot_path_vs_background.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=280&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=3efd9962012347a64b596d1d36925b33 280w, https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=560&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=add54b5469d7b4a8f22d7da250c19ddf 560w, https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=840&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=1e763d0f2ee8aa4f5b302ad44bc19d2f 840w, https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=1100&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=ce84a68af250e53a4693332d39179136 1100w, https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=1650&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=5f807accb9c63dae57c27c9a1d17f29a 1650w, https://mintcdn.com/langchain-5e9cc07a/dL5Sn6Cmy9pwtY0V/oss/images/hot_path_vs_background.png?w=2500&fit=max&auto=format&n=dL5Sn6Cmy9pwtY0V&q=85&s=ecef974859d58f691dbb22a4a1cc1572 2500w" />

#### In the hot path

Creating memories during runtime offers both advantages and challenges. On the positive side, this approach allows for real-time updates, making new memories immediately available for use in subsequent interactions. It also enables transparency, as users can be notified when memories are created and stored.

However, this method also presents challenges. It may increase complexity if the agent requires a new tool to decide what to commit to memory. In addition, the process of reasoning about what to save to memory can impact agent latency. Finally, the agent must multitask between memory creation and its other responsibilities, potentially affecting the quantity and quality of memories created.

As an example, ChatGPT uses a [save\_memories](https://openai.com/index/memory-and-new-controls-for-chatgpt/) tool to upsert memories as content strings, deciding whether and how to use this tool with each user message. See our [memory-agent](https://github.com/langchain-ai/memory-agent) template as an reference implementation.

#### In the background

Creating memories as a separate background task offers several advantages. It eliminates latency in the primary application, separates application logic from memory management, and allows for more focused task completion by the agent. This approach also provides flexibility in timing memory creation to avoid redundant work.

However, this method has its own challenges. Determining the frequency of memory writing becomes crucial, as infrequent updates may leave other threads without new context. Deciding when to trigger memory formation is also important. Common strategies include scheduling after a set time period (with rescheduling if new events occur), using a cron schedule, or allowing manual triggers by users or the application logic.

See our [memory-service](https://github.com/langchain-ai/memory-template) template as an reference implementation.

### Memory storage

LangGraph stores long-term memories as JSON documents in a [store](/oss/python/langgraph/persistence#memory-store). Each memory is organized under a custom `namespace` (similar to a folder) and a distinct `key` (like a file name). Namespaces often include user or org IDs or other labels that makes it easier to organize information. This structure enables hierarchical organization of memories. Cross-namespace searching is then supported through content filters.
```

---

## node_3 does not see the private data.

**URL:** llms-txt#node_3-does-not-see-the-private-data.

builder = StateGraph(OverallState).add_sequence([node_1, node_2, node_3])
builder.add_edge(START, "node_1")
graph = builder.compile()

---

## Beta LangSmith Collector-Proxy

**URL:** llms-txt#beta-langsmith-collector-proxy

**Contents:**
- When to Use the Collector-Proxy
- Key Features
- Configuration
  - Project Configuration
  - Authentication
- Deployment (Docker)
- Usage
- Health & Scaling
- Horizontal Scaling
- Fork & Extend

Source: https://docs.langchain.com/langsmith/collector-proxy

<Note>
  This is a beta feature. The API may change in future releases.
</Note>

The LangSmith Collector-Proxy is a lightweight, high-performance proxy server that sits between your application and the LangSmith backend. It batches and compresses trace data before sending it to LangSmith, reducing network overhead and improving performance.

## When to Use the Collector-Proxy

The Collector-Proxy is particularly valuable when:

* You're running multiple instances of your application in parallel and need to efficiently aggregate traces
* You want more efficient tracing than direct OTEL API calls to LangSmith (the collector optimizes batching and compression)
* You're using a language that doesn't have a native LangSmith SDK

* **Efficient Data Transfer** Batches multiple spans into fewer, larger uploads.
* **Compression** Uses zstd to minimize payload size.
* **OTLP Support** Accepts OTLP JSON and Protobuf over HTTP POST.
* **Semantic Translation** Maps GenAI/OpenInference conventions to the LangSmith Run model.
* **Flexible Batching** Flush by span count or time interval.

Configure via environment variables:

| Variable             | Description                       | Default                           |
| -------------------- | --------------------------------- | --------------------------------- |
| `HTTP_PORT`          | Port to run the proxy server      | `4318`                            |
| `LANGSMITH_ENDPOINT` | LangSmith backend URL             | `https://api.smith.langchain.com` |
| `LANGSMITH_API_KEY`  | API key for LangSmith             | **Required** (env var or header)  |
| `LANGSMITH_PROJECT`  | Default tracing project           | Default project if not specified  |
| `BATCH_SIZE`         | Spans per upload batch            | `100`                             |
| `FLUSH_INTERVAL_MS`  | Flush interval in milliseconds    | `1000`                            |
| `MAX_BUFFER_BYTES`   | Max uncompressed buffer size      | `10485760` (10 MB)                |
| `MAX_BODY_BYTES`     | Max incoming request body size    | `209715200` (200 MB)              |
| `MAX_RETRIES`        | Retry attempts for failed uploads | `3`                               |
| `RETRY_BACKOFF_MS`   | Initial backoff in milliseconds   | `100`                             |

### Project Configuration

The Collector-Proxy supports LangSmith project configuration with the following priority:

1. If a project is specified in the request headers (`Langsmith-Project`), that project will be used
2. If no project is specified in headers, it will use the project set in the `LANGSMITH_PROJECT` environment variable
3. If neither is set, it will trace to the `default` project.

The API key can be provided either:

* As an environment variable (`LANGSMITH_API_KEY`)
* In the request headers (`X-API-Key`)

## Deployment (Docker)

You can deploy the Collector-Proxy with Docker:

1. **Build the image**

2. **Run the container**

Point any OTLP-compatible client or the OpenTelemetry Collector exporter at:

* **Liveness**: `GET /live` → 200
* **Readiness**: `GET /ready` → 200

## Horizontal Scaling

To ensure full traces are batched correctly, route spans with the same trace ID to the same instance (e.g., via consistent hashing).

Fork the [Collector-Proxy repo on GitHub](https://github.com/langchain-ai/langsmith-collector-proxy) and implement your own converter:

* Create a custom `GenAiConverter` or modify the existing one in `internal/translator/otel_converter.go`
* Register the custom converter in `internal/translator/translator.go`

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/collector-proxy.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
2. **Run the container**
```

Example 2 (unknown):
```unknown
## Usage

Point any OTLP-compatible client or the OpenTelemetry Collector exporter at:
```

Example 3 (unknown):
```unknown
Send a test trace:
```

---

## Configure webhook notifications for LangSmith alerts

**URL:** llms-txt#configure-webhook-notifications-for-langsmith-alerts

**Contents:**
- Overview
- Prerequisites
- Integration Configuration
  - Step 1: Prepare Your Receiving Endpoint
  - Step 2: Configure Webhook Parameters
  - Step 3: Test the Webhook
- Troubleshooting
- Security Considerations
- Sending alerts to Slack using a webhook
  - Prerequisites

Source: https://docs.langchain.com/langsmith/alerts-webhook

This guide details the process for setting up webhook notifications for [LangSmith alerts](/langsmith/alerts). Before proceeding, make sure you have followed the steps leading up to the notification step of creating the alert by following [this guide](./alerts). Webhooks enable integration with custom services and third-party platforms by sending HTTP POST requests when alert conditions are triggered. Use webhooks to forward alert data to ticketing systems, chat applications, or custom monitoring solutions.

* An endpoint that can receive HTTP POST requests
* Appropriate authentication credentials for your receiving service (if required)

## Integration Configuration

### Step 1: Prepare Your Receiving Endpoint

Before configuring the webhook in LangSmith, ensure your receiving endpoint:

* Accepts HTTP POST requests
* Can process JSON payloads
* Is accessible from external services
* Has appropriate authentication mechanisms (if required)

Additionally, if on a custom deployment of LangSmith, make sure there are no firewall settings blocking egress traffic from LangSmith services.

### Step 2: Configure Webhook Parameters

<img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=fecb6275ad3d576a864d1c6a2771c847" alt="Webhook Setup" data-og-width="754" width="754" data-og-height="523" height="523" data-path="langsmith/images/webhook-setup.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=ef03d3ab887113e73dbdc1097076d103 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=a25fcaedcbed92c9c3f2e2bddd8d88bd 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=4785471ce1e58f3c48ce19b7be3889c5 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=8c7dd40aeb5635cdf4ddf207d0dfe7c7 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=aff125529b9db8fbf861999e70bcdb26 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/webhook-setup.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=e9de7c4f0dcc440d734f4f3d09d2abf4 2500w" />

In the notification section of your alert complete the webhook configuration with the following parameters:

* **URL**: The complete URL of your receiving endpoint
  * Example: `https://api.example.com/incident-webhook`

* **Headers**: JSON Key-value pairs sent with the webhook request

* Common headers include:

* `Authorization`: For authentication tokens
    * `Content-Type`: Usually set to `application/json` (default)
    * `X-Source`: To identify the source as LangSmith

* If no headers, then simply use `{}`

* **Request Body Template**: Customize the JSON payload sent to your endpoint

* Default: LangSmith sends the payload defined and the following additonal key-value pairs appended to the payload:

* `project_name`: Name of the triggered alert
    * `alert_rule_id`: A UUID to identify the LangSmith alert. This can be used as a de-duplication key in the webhook service.
    * `alert_rule_name`: The name of the alert rule.
    * `alert_rule_type`: The type of alert (as of 04/01/2025 all alerts are of type `threshold`).
    * `alert_rule_attribute`: The attribute associated with the alert rule - `error_count`, `feedback_score` or `latency`.
    * `triggered_metric_value`: The value of the metric at the time the threshold was triggered.
    * `triggered_threshold`: The threshold that triggered the alert.
    * `timestamp`: The timestamp that triggered the alert.

### Step 3: Test the Webhook

Click **Send Test Alert** to send the webhook notification to ensure the notification works as intended.

If webhook notifications aren't being delivered:

* Verify the webhook URL is correct and accessible
* Ensure any authentication headers are properly formatted
* Check that your receiving endpoint accepts POST requests
* Examine your endpoint's logs for received but rejected requests
* Verify your custom payload template is valid JSON format

## Security Considerations

* Use HTTPS for your webhook endpoints
* Implement authentication for your webhook endpoint
* Consider adding a shared secret in your headers to verify webhook sources
* Validate incoming webhook requests before processing them

## Sending alerts to Slack using a webhook

Here is an example for configuring LangSmith alerts to send notifications to Slack channels using the [`chat.postMessage`](https://api.slack.com/methods/chat.postMessage) API.

* Access to a Slack workspace
* A LangSmith project to set up alerts
* Permissions to create Slack applications

### Step 1: Create a Slack App

1. Visit the [Slack API Applications page](https://api.slack.com/apps)
2. Click **Create New App**
3. Select **From scratch**
4. Provide an **App Name** (e.g., "LangSmith Alerts")
5. Select the workspace where you want to install the app
6. Click **Create App**

### Step 2: Configure Bot Permissions

1. In the left sidebar of your Slack app configuration, click **OAuth & Permissions**

2. Scroll down to **Bot Token Scopes** under **Scopes** and click **Add an OAuth Scope**

3. Add the following scopes:

* `chat:write` (Send messages as the app)
   * `chat:write.public` (Send messages to channels the app isn't in)
   * `channels:read` (View basic channel information)

### Step 3: Install the App to Your Workspace

1. Scroll up to the top of the **OAuth & Permissions** page
2. Click **Install to Workspace**
3. Review the permissions and click **Allow**
4. Copy the **Bot User OAuth Token** that appears (begins with `xoxb-`)

### Step 4: Configure the Webhook Alert in LangSmith

1. In LangSmith, navigate to your project
2. Select **Alerts → Create Alert**
3. Define your alert metrics and conditions
4. In the notification section, select **Webhook**
5. Configure the webhook with the following settings:

> **Note:** Replace `xoxb-your-token-here` with your actual Bot User OAuth Token

**Request Body Template**

**NOTE:** Fill in the `channel_id`, `alert_name`, `project_name` and `project_url` when creating the alert. You can find your `project_url` in the browser's URL bar. Copy the portion up to but not including any query parameters.

6. Click **Save** to activate the webhook configuration

### Step 5: Test the Integration

1. In the LangSmith alert configuration, click **Test Alert**
2. Check your specified Slack channel for the test notification
3. Verify that the message contains the expected alert information

### (Optional) Step 6: Link to the Alert Preview in the Request Body

After creating an alert, you can optionally link to its preview in the webhook's request body.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=286ebb8f90bafbdcacf9a0602aaf749c" alt="Alert Preview Pane" data-og-width="832" width="832" data-og-height="773" height="773" data-path="langsmith/images/alert-preview-pane.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=20a409a30bff44a1a8bb1b79a6a2216b 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=414bb4719617bd23452273c73327d601 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6bc7bc7aaee65f7f4afac42102047ad2 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=491244ac56f6f4bcbb64419b267df0fe 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=d47f5ba127c3f61e3cb7498f8b7568fe 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/alert-preview-pane.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6a70706db839b2d211024116ba19acef 2500w" />

1. Save your alert
2. Find your saved alert in the alerts table and click it
3. Copy the dsiplayed URL
4. Click "Edit Alert"
5. Replace the existing project URL with the copied alert preview URL

## Additional Resources

* [LangSmith Alerts Documentation](/langsmith/alerts)
* [Slack chat.postMessage API Documentation](https://api.slack.com/methods/chat.postMessage)
* [Slack Block Kit Builder](https://app.slack.com/block-kit-builder/)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/alerts-webhook.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
**Headers**
```

Example 2 (unknown):
```unknown
> **Note:** Replace `xoxb-your-token-here` with your actual Bot User OAuth Token

**Request Body Template**
```

---

## Agent Server API reference for LangSmith Deployment

**URL:** llms-txt#agent-server-api-reference-for-langsmith-deployment

**Contents:**
- Authentication

Source: https://docs.langchain.com/langsmith/server-api-ref

The Agent Server API reference is available within each [deployment](/langsmith/deployments) at the `/docs` endpoint (e.g. `http://localhost:8124/docs`).

<Card title="API Reference" href="https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref.html" icon="book">
  View the full Agent Server API reference documentation
</Card>

For deployments to LangSmith, authentication is required. Pass the `X-Api-Key` header with each request to the Agent Server. The value of the header should be set to a valid LangSmith API key for the organization where the Agent Server is deployed.

Example `curl` command:

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/server-api-ref.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## To approve

**URL:** llms-txt#to-approve

graph.invoke(Command(resume=True), config=config)

---

## Instrument OpenAI calls

**URL:** llms-txt#instrument-openai-calls

OpenAIInstrumentor().instrument()

---

## Access the current conversation state

**URL:** llms-txt#access-the-current-conversation-state

@tool
def summarize_conversation(
    runtime: ToolRuntime
) -> str:
    """Summarize the conversation so far."""
    messages = runtime.state["messages"]

human_msgs = sum(1 for m in messages if m.__class__.__name__ == "HumanMessage")
    ai_msgs = sum(1 for m in messages if m.__class__.__name__ == "AIMessage")
    tool_msgs = sum(1 for m in messages if m.__class__.__name__ == "ToolMessage")

return f"Conversation has {human_msgs} user messages, {ai_msgs} AI responses, and {tool_msgs} tool results"

---

## Implement a CI/CD pipeline using LangSmith Deployments and Evaluation

**URL:** llms-txt#implement-a-ci/cd-pipeline-using-langsmith-deployments-and-evaluation

**Contents:**
- Overview
- Pipeline architecture
  - Trigger sources
  - Testing layers
- GitHub Actions workflow
  - Prerequisites
- Deployment options
  - Prerequisites for manual deployment
  - Local development and testing

Source: https://docs.langchain.com/langsmith/cicd-pipeline-example

This guide demonstrates how to implement a comprehensive CI/CD pipeline for AI agent applications deployed in LangSmith Deployments. In this example, you'll use the [LangGraph](/oss/python/langgraph/overview) open source framework for orchestrating and building the agent, [LangSmith](/langsmith/home) for observability and evaluations. This pipeline is based on the [cicd-pipeline-example repository](https://github.com/langchain-ai/cicd-pipeline-example).

The CI/CD pipeline provides:

* <Icon icon="check-circle" /> **Automated testing**: Unit, integration, and end-to-end tests.
* <Icon icon="chart-line" /> **Offline evaluations**: Performance assessment using [AgentEvals](https://github.com/langchain-ai/agentevals), [OpenEvals](https://github.com/langchain-ai/openevals) and [LangSmith](https://docs.langchain.com/langsmith/home).
* <Icon icon="rocket" /> **Preview and production deployments**: Automated staging and quality-gated production releases using the Control Plane API.
* <Icon icon="eye" /> **Monitoring**: Continuous evaluation and alerting.

## Pipeline architecture

The CI/CD pipeline consists of several key components that work together to ensure code quality and reliable deployments:

There are multiple ways you can trigger this pipeline, either during development or if your application is already live. The pipeline can be triggered by:

* <Icon icon="code-branch" /> **Code changes**: Pushes to main/development branches where you can modify the LangGraph architecture, try different models, update agent logic, or make any code improvements.
* <Icon icon="edit" /> **PromptHub updates**: Changes to prompt templates stored in LangSmith PromptHub—whenever there's a new prompt commit, the system triggers a webhook to run the pipeline.
* <Icon icon="exclamation-triangle" /> **Online evaluation alerts**: Performance degradation notifications from live deployments
* <Icon icon="webhook" /> **LangSmith traces webhooks**: Automated triggers based on trace analysis and performance metrics.
* <Icon icon="play" /> **Manual trigger**: Manual initiation of the pipeline for testing or emergency deployments.

Compared to traditional software, testing AI agent applications also requires assessing response quality, so it is important to test each part of the workflow. The pipeline implements multiple testing layers:

1. <Icon icon="puzzle-piece" /> **Unit tests**: Individual node and utility function testing.
2. <Icon icon="link" /> **Integration tests**: Component interaction testing.
3. <Icon icon="route" /> **End-to-end tests**: Full graph execution testing.
4. <Icon icon="brain" /> **Offline evaluations**: Performance assessment with real-world scenarios including end-to-end evaluations, single-step evaluations, agent trajectory analysis, and multi-turn simulations.
5. <Icon icon="server" /> **LangGraph dev server tests**: Use the [langgraph-cli](/langsmith/cli) tool for spinning up (inside the GitHub Action) a local server to run the LangGraph agent. This polls the `/ok` server API endpoint until it is available and for 30 seconds, after that it throws an error.

## GitHub Actions workflow

The CI/CD pipeline uses GitHub Actions with the [Control Plane API](/langsmith/api-ref-control-plane) and [LangSmith API](https://api.smith.langchain.com/redoc) to automate deployment. A helper script manages API interactions and deployments: [https://github.com/langchain-ai/cicd-pipeline-example/blob/main/.github/scripts/langgraph\_api.py](https://github.com/langchain-ai/cicd-pipeline-example/blob/main/.github/scripts/langgraph_api.py).

The workflow includes:

* **New agent deployment**: When a new PR is opened and tests pass, a new preview deployment is created in LangSmith Deployments using the [Control Plane API](/langsmith/api-ref-control-plane). This allows you to test the agent in a staging environment before promoting to production.

* **Agent deployment revision**: A revision happens when an existing deployment with the same ID is found, or when the PR is merged into main. In the case of merging to main, the preview deployment is deleted and a production deployment is created. This ensures that any updates to the agent are properly deployed and integrated into the production infrastructure.

<img src="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=3ef7d51a322b8b5e2f9c2c70579fcc97" alt="Agent Deployment Revision Workflow" data-og-width="1022" width="1022" data-og-height="196" height="196" data-path="langsmith/images/cicd-new-lgp-revision.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=280&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=a3d06c339e84a1af99450d23e8bd617f 280w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=560&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=30589c8727af3ecb1d97881fd6692554 560w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=840&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=c05ab515ea0901fb2d076dee256ad108 840w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=1100&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b939ad6842110227f70cc0526468d21d 1100w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=1650&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=0559d5b2a85414e954a72377b2eed9ec 1650w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=2500&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b8b96047a8b37f31b78d793cd7d18f45 2500w" />

* **Testing and evaluation workflow**: In addition to the more traditional testing phases (unit tests, integration tests, end-to-end tests, etc.), the pipeline includes [offline evaluations](/langsmith/evaluation-concepts#offline-evaluation) and [Agent dev server testing](/langsmith/local-server) because you want to test the quality of your agent. These evaluations provide comprehensive assessment of the agent's performance using real-world scenarios and data.

<img src="https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=477c3f5ec3d9bb9dfc354b9a57860636" alt="Test with Results Workflow" data-og-width="2050" width="2050" data-og-height="996" height="996" data-path="langsmith/images/cicd-test-with-results.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=280&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=7c5885b5f85c1c408fda449c5a0c706a 280w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=560&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=3b9a25332a9f6b56edfc9fbbfec248c1 560w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=840&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=380cb346fffbaf13365b37c6fa955c05 840w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=1100&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=8994d1e816e725865f90a2ac6601f7a4 1100w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=1650&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=42b752f1e5f0043dd6998ae372e83874 1650w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=2500&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=043be8ed1ef59cea171f30146790a877 2500w" />

<AccordionGroup>
    <Accordion title="Final Response Evaluation" icon="check-circle">
      Evaluates the final output of your agent against expected results. This is the most common type of evaluation that checks if the agent's final response meets quality standards and answers the user's question correctly.
    </Accordion>

<Accordion title="Single Step Evaluation" icon="step-forward">
      Tests individual steps or nodes within your LangGraph workflow. This allows you to validate specific components of your agent's logic in isolation, ensuring each step functions correctly before testing the full pipeline.
    </Accordion>

<Accordion title="Agent Trajectory Evaluation" icon="route">
      Analyzes the complete path your agent takes through the graph, including all intermediate steps and decision points. This helps identify bottlenecks, unnecessary steps, or suboptimal routing in your agent's workflow. It also evaluates whether your agent invoked the right tools in the right order or at the right time.
    </Accordion>

<Accordion title="Multi-Turn Evaluation" icon="comments">
      Tests conversational flows where the agent maintains context across multiple interactions. This is crucial for agents that handle follow-up questions, clarifications, or extended dialogues with users.
    </Accordion>
  </AccordionGroup>

See the [LangGraph testing documentation](/oss/python/langgraph/test) for specific testing approaches and the [evaluation approaches guide](/langsmith/evaluation-approaches) for a comprehensive overview of offline evaluations.

Before setting up the CI/CD pipeline, ensure you have:

* <Icon icon="robot" /> An AI agent application (in this case built using [LangGraph](/oss/python/langgraph/overview))
* <Icon icon="user" /> A [LangSmith account](https://smith.langchain.com/)
* <Icon icon="key" /> A [LangSmith API key](/langsmith/create-account-api-key) needed to deploy agents and retrieve experiment results
* <Icon icon="cog" /> Project-specific environment variables configured in your repository secrets (e.g., LLM model API keys, vector store credentials, database connections)

<Note>
  While this example uses GitHub, the CI/CD pipeline works with other Git hosting platforms including GitLab, Bitbucket, and others.
</Note>

## Deployment options

LangSmith supports multiple deployment methods, depending on how your [LangSmith instance is hosted](/langsmith/platform-setup):

* <Icon icon="cloud" /> **Cloud LangSmith**: Direct GitHub integration or Docker image deployment.
* <Icon icon="server" /> **Self-Hosted/Hybrid**: Container registry-based deployments.

The deployment flow starts by modifying your agent implementation. At minimum, you must have a [`langgraph.json`](/langsmith/application-structure) and dependency file in your project (`requirements.txt` or `pyproject.toml`). Use the `langgraph dev` CLI tool to check for errors—fix any errors; otherwise, the deployment will succeed when deployed to LangSmith Deployments.

### Prerequisites for manual deployment

Before deploying your agent, ensure you have:

1. <Icon icon="project-diagram" /> **LangGraph graph**: Your agent implementation (e.g., `./agents/simple_text2sql.py:agent`).
2. <Icon icon="box" /> **Dependencies**: Either `requirements.txt` or `pyproject.toml` with all required packages.
3. <Icon icon="cog" /> **Configuration**: `langgraph.json` file specifying:
   * Path to your agent graph
   * Dependencies location
   * Environment variables
   * Python version

Example `langgraph.json`:

### Local development and testing

<img src="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=425460d3401221ab441e21fc706c9cf1" alt="Studio CLI Interface" data-og-width="2972" width="2972" data-og-height="1354" height="1354" data-path="langsmith/images/cicd-studio-cli.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=280&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=35e64359dba47f4db4962148073cfadb 280w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=560&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=c12eb479d5c46921633c56bdead978bc 560w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=840&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b36efc12f81027b7364cea82a4600fc3 840w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=1100&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=131c3fa2e989fbb8ebc4748a5790dc36 1100w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=1650&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=afa56b4e5ca02495ef5e7cb69d8e1329 1650w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=2500&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=774ec3dcf76a4b0e61989cd12e41e0c3 2500w" />

First, test your agent locally using [Studio](/langsmith/studio):

```bash  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
### Trigger sources

There are multiple ways you can trigger this pipeline, either during development or if your application is already live. The pipeline can be triggered by:

* <Icon icon="code-branch" /> **Code changes**: Pushes to main/development branches where you can modify the LangGraph architecture, try different models, update agent logic, or make any code improvements.
* <Icon icon="edit" /> **PromptHub updates**: Changes to prompt templates stored in LangSmith PromptHub—whenever there's a new prompt commit, the system triggers a webhook to run the pipeline.
* <Icon icon="exclamation-triangle" /> **Online evaluation alerts**: Performance degradation notifications from live deployments
* <Icon icon="webhook" /> **LangSmith traces webhooks**: Automated triggers based on trace analysis and performance metrics.
* <Icon icon="play" /> **Manual trigger**: Manual initiation of the pipeline for testing or emergency deployments.

### Testing layers

Compared to traditional software, testing AI agent applications also requires assessing response quality, so it is important to test each part of the workflow. The pipeline implements multiple testing layers:

1. <Icon icon="puzzle-piece" /> **Unit tests**: Individual node and utility function testing.
2. <Icon icon="link" /> **Integration tests**: Component interaction testing.
3. <Icon icon="route" /> **End-to-end tests**: Full graph execution testing.
4. <Icon icon="brain" /> **Offline evaluations**: Performance assessment with real-world scenarios including end-to-end evaluations, single-step evaluations, agent trajectory analysis, and multi-turn simulations.
5. <Icon icon="server" /> **LangGraph dev server tests**: Use the [langgraph-cli](/langsmith/cli) tool for spinning up (inside the GitHub Action) a local server to run the LangGraph agent. This polls the `/ok` server API endpoint until it is available and for 30 seconds, after that it throws an error.

## GitHub Actions workflow

The CI/CD pipeline uses GitHub Actions with the [Control Plane API](/langsmith/api-ref-control-plane) and [LangSmith API](https://api.smith.langchain.com/redoc) to automate deployment. A helper script manages API interactions and deployments: [https://github.com/langchain-ai/cicd-pipeline-example/blob/main/.github/scripts/langgraph\_api.py](https://github.com/langchain-ai/cicd-pipeline-example/blob/main/.github/scripts/langgraph_api.py).

The workflow includes:

* **New agent deployment**: When a new PR is opened and tests pass, a new preview deployment is created in LangSmith Deployments using the [Control Plane API](/langsmith/api-ref-control-plane). This allows you to test the agent in a staging environment before promoting to production.

* **Agent deployment revision**: A revision happens when an existing deployment with the same ID is found, or when the PR is merged into main. In the case of merging to main, the preview deployment is deleted and a production deployment is created. This ensures that any updates to the agent are properly deployed and integrated into the production infrastructure.

  <img src="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=3ef7d51a322b8b5e2f9c2c70579fcc97" alt="Agent Deployment Revision Workflow" data-og-width="1022" width="1022" data-og-height="196" height="196" data-path="langsmith/images/cicd-new-lgp-revision.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=280&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=a3d06c339e84a1af99450d23e8bd617f 280w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=560&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=30589c8727af3ecb1d97881fd6692554 560w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=840&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=c05ab515ea0901fb2d076dee256ad108 840w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=1100&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b939ad6842110227f70cc0526468d21d 1100w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=1650&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=0559d5b2a85414e954a72377b2eed9ec 1650w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-new-lgp-revision.png?w=2500&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b8b96047a8b37f31b78d793cd7d18f45 2500w" />

* **Testing and evaluation workflow**: In addition to the more traditional testing phases (unit tests, integration tests, end-to-end tests, etc.), the pipeline includes [offline evaluations](/langsmith/evaluation-concepts#offline-evaluation) and [Agent dev server testing](/langsmith/local-server) because you want to test the quality of your agent. These evaluations provide comprehensive assessment of the agent's performance using real-world scenarios and data.

  <img src="https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=477c3f5ec3d9bb9dfc354b9a57860636" alt="Test with Results Workflow" data-og-width="2050" width="2050" data-og-height="996" height="996" data-path="langsmith/images/cicd-test-with-results.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=280&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=7c5885b5f85c1c408fda449c5a0c706a 280w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=560&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=3b9a25332a9f6b56edfc9fbbfec248c1 560w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=840&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=380cb346fffbaf13365b37c6fa955c05 840w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=1100&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=8994d1e816e725865f90a2ac6601f7a4 1100w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=1650&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=42b752f1e5f0043dd6998ae372e83874 1650w, https://mintcdn.com/langchain-5e9cc07a/MrTet_AXQVddxOlO/langsmith/images/cicd-test-with-results.png?w=2500&fit=max&auto=format&n=MrTet_AXQVddxOlO&q=85&s=043be8ed1ef59cea171f30146790a877 2500w" />

  <AccordionGroup>
    <Accordion title="Final Response Evaluation" icon="check-circle">
      Evaluates the final output of your agent against expected results. This is the most common type of evaluation that checks if the agent's final response meets quality standards and answers the user's question correctly.
    </Accordion>

    <Accordion title="Single Step Evaluation" icon="step-forward">
      Tests individual steps or nodes within your LangGraph workflow. This allows you to validate specific components of your agent's logic in isolation, ensuring each step functions correctly before testing the full pipeline.
    </Accordion>

    <Accordion title="Agent Trajectory Evaluation" icon="route">
      Analyzes the complete path your agent takes through the graph, including all intermediate steps and decision points. This helps identify bottlenecks, unnecessary steps, or suboptimal routing in your agent's workflow. It also evaluates whether your agent invoked the right tools in the right order or at the right time.
    </Accordion>

    <Accordion title="Multi-Turn Evaluation" icon="comments">
      Tests conversational flows where the agent maintains context across multiple interactions. This is crucial for agents that handle follow-up questions, clarifications, or extended dialogues with users.
    </Accordion>
  </AccordionGroup>

  See the [LangGraph testing documentation](/oss/python/langgraph/test) for specific testing approaches and the [evaluation approaches guide](/langsmith/evaluation-approaches) for a comprehensive overview of offline evaluations.

### Prerequisites

Before setting up the CI/CD pipeline, ensure you have:

* <Icon icon="robot" /> An AI agent application (in this case built using [LangGraph](/oss/python/langgraph/overview))
* <Icon icon="user" /> A [LangSmith account](https://smith.langchain.com/)
* <Icon icon="key" /> A [LangSmith API key](/langsmith/create-account-api-key) needed to deploy agents and retrieve experiment results
* <Icon icon="cog" /> Project-specific environment variables configured in your repository secrets (e.g., LLM model API keys, vector store credentials, database connections)

<Note>
  While this example uses GitHub, the CI/CD pipeline works with other Git hosting platforms including GitLab, Bitbucket, and others.
</Note>

## Deployment options

LangSmith supports multiple deployment methods, depending on how your [LangSmith instance is hosted](/langsmith/platform-setup):

* <Icon icon="cloud" /> **Cloud LangSmith**: Direct GitHub integration or Docker image deployment.
* <Icon icon="server" /> **Self-Hosted/Hybrid**: Container registry-based deployments.

The deployment flow starts by modifying your agent implementation. At minimum, you must have a [`langgraph.json`](/langsmith/application-structure) and dependency file in your project (`requirements.txt` or `pyproject.toml`). Use the `langgraph dev` CLI tool to check for errors—fix any errors; otherwise, the deployment will succeed when deployed to LangSmith Deployments.
```

Example 2 (unknown):
```unknown
### Prerequisites for manual deployment

Before deploying your agent, ensure you have:

1. <Icon icon="project-diagram" /> **LangGraph graph**: Your agent implementation (e.g., `./agents/simple_text2sql.py:agent`).
2. <Icon icon="box" /> **Dependencies**: Either `requirements.txt` or `pyproject.toml` with all required packages.
3. <Icon icon="cog" /> **Configuration**: `langgraph.json` file specifying:
   * Path to your agent graph
   * Dependencies location
   * Environment variables
   * Python version

Example `langgraph.json`:
```

Example 3 (unknown):
```unknown
### Local development and testing

<img src="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=425460d3401221ab441e21fc706c9cf1" alt="Studio CLI Interface" data-og-width="2972" width="2972" data-og-height="1354" height="1354" data-path="langsmith/images/cicd-studio-cli.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=280&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=35e64359dba47f4db4962148073cfadb 280w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=560&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=c12eb479d5c46921633c56bdead978bc 560w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=840&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=b36efc12f81027b7364cea82a4600fc3 840w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=1100&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=131c3fa2e989fbb8ebc4748a5790dc36 1100w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=1650&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=afa56b4e5ca02495ef5e7cb69d8e1329 1650w, https://mintcdn.com/langchain-5e9cc07a/-UAx6PdOIJpPyTy2/langsmith/images/cicd-studio-cli.png?w=2500&fit=max&auto=format&n=-UAx6PdOIJpPyTy2&q=85&s=774ec3dcf76a4b0e61989cd12e41e0c3 2500w" />

First, test your agent locally using [Studio](/langsmith/studio):
```

---

## Alice creates a thread and chats

**URL:** llms-txt#alice-creates-a-thread-and-chats

alice_thread = await alice.threads.create()
print(f"✅ Alice created thread: {alice_thread['thread_id']}")

await alice.runs.create(
    thread_id=alice_thread["thread_id"],
    assistant_id="agent",
    input={"messages": [{"role": "user", "content": "Hi, this is Alice's private chat"}]}
)

---

## How to use prebuilt evaluators

**URL:** llms-txt#how-to-use-prebuilt-evaluators

**Contents:**
- Setup
- Running an evaluator

Source: https://docs.langchain.com/langsmith/prebuilt-evaluators

LangSmith integrates with the open-source openevals package to provide a suite of prebuilt evaluators that you can use as starting points for evaluation.

<Note>
  This how-to guide will demonstrate how to set up and run one type of evaluator (LLM-as-a-judge). For a complete list of prebuilt evaluators with usage examples, refer to the [openevals](https://github.com/langchain-ai/openevals) and [agentevals](https://github.com/langchain-ai/agentevals) repos.
</Note>

You'll need to install the `openevals` package to use the pre-built LLM-as-a-judge evaluator.

You'll also need to set your OpenAI API key as an environment variable, though you can choose different providers too:

We'll also use LangSmith's [pytest](/langsmith/pytest) integration for Python and [Vitest/Jest](/langsmith/vitest-jest) for TypeScript to run our evals. `openevals` also integrates seamlessly with the [`evaluate`](https://docs.smith.langchain.com/reference/python/evaluation/langsmith.evaluation._runner.evaluate) method as well. See the [appropriate guides](/langsmith/pytest) for setup instructions.

## Running an evaluator

The general flow is simple: import the evaluator or factory function from `openevals`, then run it within your test file with inputs, outputs, and reference outputs. LangSmith will automatically log the evaluator's results as feedback.

Note that not all evaluators will require each parameter (the exact match evaluator only requires outputs and reference outputs, for example). Additionally, if your LLM-as-a-judge prompt requires additional variables, passing them in as kwargs will format them into the prompt.

Set up your test file like this:

The `feedback_key`/`feedbackKey` parameter will be used as the name of the feedback in your experiment.

Running the eval in your terminal will result in something like the following:

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=c2351acb065520c3cef3c374bd762982" alt="Prebuilt evaluator terminal result" data-og-width="2114" width="2114" data-og-height="614" height="614" data-path="langsmith/images/prebuilt-eval-result.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=5a091195ae1351d5b16b2ebe53632e1e 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=1e7488bb77662f71e60f01b9fa9609d6 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=7e491cd83accabc3a56153a6c12d84fe 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=2fbc03b560b082ae5f6de8d17d4ae626 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=20f6023215721383019659a0b99f3de5 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prebuilt-eval-result.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=af97fb8ec7343f536704719294560dd0 2500w" />

You can also pass prebuilt evaluators directly into the `evaluate` method if you have already created a dataset in LangSmith. If using Python, this requires `langsmith>=0.3.11`:

For a complete list of available evaluators, see the [openevals](https://github.com/langchain-ai/openevals) and [agentevals](https://github.com/langchain-ai/agentevals) repos.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/prebuilt-evaluators.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

You'll also need to set your OpenAI API key as an environment variable, though you can choose different providers too:
```

Example 3 (unknown):
```unknown
We'll also use LangSmith's [pytest](/langsmith/pytest) integration for Python and [Vitest/Jest](/langsmith/vitest-jest) for TypeScript to run our evals. `openevals` also integrates seamlessly with the [`evaluate`](https://docs.smith.langchain.com/reference/python/evaluation/langsmith.evaluation._runner.evaluate) method as well. See the [appropriate guides](/langsmith/pytest) for setup instructions.

## Running an evaluator

The general flow is simple: import the evaluator or factory function from `openevals`, then run it within your test file with inputs, outputs, and reference outputs. LangSmith will automatically log the evaluator's results as feedback.

Note that not all evaluators will require each parameter (the exact match evaluator only requires outputs and reference outputs, for example). Additionally, if your LLM-as-a-judge prompt requires additional variables, passing them in as kwargs will format them into the prompt.

Set up your test file like this:

<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## Application-specific evaluation approaches

**URL:** llms-txt#application-specific-evaluation-approaches

**Contents:**
- Agents
  - Evaluating an agent's final response
  - Evaluating a single step of an agent
  - Evaluating an agent's trajectory
- Retrieval augmented generation (RAG)
  - Dataset
  - Evaluator
  - Applying RAG Evaluation
  - RAG evaluation summary
- Summarization

Source: https://docs.langchain.com/langsmith/evaluation-approaches

Below, we will discuss evaluation of a few popular types of LLM applications.

[LLM-powered autonomous agents](https://lilianweng.github.io/posts/2023-06-23-agent/) combine three components (1) Tool calling, (2) Memory, and (3) Planning. Agents [use tool calling](https://python.langchain.com/v0.1/docs/modules/agents/agent_types/tool_calling/) with planning (e.g., often via prompting) and memory (e.g., often short-term message history) to generate responses. [Tool calling](https://python.langchain.com/v0.1/docs/modules/model_io/chat/function_calling/) allows a model to respond to a given prompt by generating two things: (1) a tool to invoke and (2) the input arguments required.

<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=a1c10f940f40ad89c90de8fae3607c1f" alt="Tool use" data-og-width="1021" width="1021" data-og-height="424" height="424" data-path="langsmith/images/tool-use.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e80012647614cd82cb468430e62fa9aa 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=67a5febcec316bfe2935ba65506558a2 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e0b52fb90bdbc41332b09404823fbfca 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=8a4e6b4bda0f788f540ca240012c9e89 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=d403f18524e0904c716d0cba9e928cac 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/tool-use.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=69133b8862e6738000f733ff7e34daae 2500w" />

Below is a tool-calling agent in [LangGraph](https://langchain-ai.github.io/langgraph/tutorials/introduction/). The `assistant node` is an LLM that determines whether to invoke a tool based upon the input. The `tool condition` sees if a tool was selected by the `assistant node` and, if so, routes to the `tool node`. The `tool node` executes the tool and returns the output as a tool message to the `assistant node`. This loop continues until as long as the `assistant node` selects a tool. If no tool is selected, then the agent directly returns the LLM response.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=37f3c09958c1e2543f633c59cc89df36" alt="Agent" data-og-width="1259" width="1259" data-og-height="492" height="492" data-path="langsmith/images/langgraph-agent.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=59cecf5d27098da369bbf60d6a315437 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=81426ee5f37211859c572fe51d837c44 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=558ca3297a7697a12989f0bdcfd4a4d7 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=39a3a80c152f99f133302fe79f4bf63d 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=46164054792e7f730cef4897fd9cbf57 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langgraph-agent.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=553d05e97a4d052882b6381e1e8b0362 2500w" />

This sets up three general types of agent evaluations that users are often interested in:

* `Final Response`: Evaluate the agent's final response.
* `Single step`: Evaluate any agent step in isolation (e.g., whether it selects the appropriate tool).
* `Trajectory`: Evaluate whether the agent took the expected path (e.g., of tool calls) to arrive at the final answer.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=5fe3c96402623ed8a61118f22a6426b6" alt="Agent-eval" data-og-width="1825" width="1825" data-og-height="915" height="915" data-path="langsmith/images/agent-eval.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=780c3ea6fecdbd41fa62017d3ac6042e 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=f43c0cd9d9b49ae1f2a7ead5f5e58bcd 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=360b12b491fb97fd46d444e440345737 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=88fd055136cd48a538d908e3899daa6e 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=c3e40f0ba26f26f2688553596487ab57 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/agent-eval.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=7b238d8ce02b6d1ab3d6ff3fb2c62d4e 2500w" />

Below we will cover what these are, the components (inputs, outputs, evaluators) needed for each one, and when you should consider this. Note that you likely will want to do multiple (if not all!) of these types of evaluations - they are not mutually exclusive!

### Evaluating an agent's final response

One way to evaluate an agent is to assess its overall performance on a task. This basically involves treating the agent as a black box and simply evaluating whether or not it gets the job done.

The inputs should be the user input and (optionally) a list of tools. In some cases, tool are hardcoded as part of the agent and they don't need to be passed in. In other cases, the agent is more generic, meaning it does not have a fixed set of tools and tools need to be passed in at run time.

The output should be the agent's final response.

The evaluator varies depending on the task you are asking the agent to do. Many agents perform a relatively complex set of steps and the output a final text response. Similar to RAG, LLM-as-judge evaluators are often effective for evaluation in these cases because they can assess whether the agent got a job done directly from the text response.

However, there are several downsides to this type of evaluation. First, it usually takes a while to run. Second, you are not evaluating anything that happens inside the agent, so it can be hard to debug when failures occur. Third, it can sometimes be hard to define appropriate evaluation metrics.

### Evaluating a single step of an agent

Agents generally perform multiple actions. While it is useful to evaluate them end-to-end, it can also be useful to evaluate these individual actions. This generally involves evaluating a single step of the agent - the LLM call where it decides what to do.

The inputs should be the input to a single step. Depending on what you are testing, this could just be the raw user input (e.g., a prompt and / or a set of tools) or it can also include previously completed steps.

The outputs are just the output of that step, which is usually the LLM response. The LLM response often contains tool calls, indicating what action the agent should take next.

The evaluator for this is usually some binary score for whether the correct tool call was selected, as well as some heuristic for whether the input to the tool was correct. The reference tool can be simply specified as a string.

There are several benefits to this type of evaluation. It allows you to evaluate individual actions, which lets you hone in where your application may be failing. They are also relatively fast to run (because they only involve a single LLM call) and evaluation often uses simple heuristic evaluation of the selected tool relative to the reference tool. One downside is that they don't capture the full agent - only one particular step. Another downside is that dataset creation can be challenging, particular if you want to include past history in the agent input. It is pretty easy to generate a dataset for steps early on in an agent's trajectory (e.g., this may only include the input prompt), but it can be difficult to generate a dataset for steps later on in the trajectory (e.g., including numerous prior agent actions and responses).

### Evaluating an agent's trajectory

Evaluating an agent's trajectory involves evaluating all the steps an agent took.

The inputs are again the inputs to the overall agent (the user input, and optionally a list of tools).

The outputs are a list of tool calls, which can be formulated as an "exact" trajectory (e.g., an expected sequence of tool calls) or simply a set of tool calls that are expected (in any order).

The evaluator here is some function over the steps taken. Assessing the "exact" trajectory can use a single binary score that confirms an exact match for each tool name in the sequence. This is simple, but has some flaws. Sometimes there can be multiple correct paths. This evaluation also does not capture the difference between a trajectory being off by a single step versus being completely wrong.

To address these flaws, evaluation metrics can focused on the number of "incorrect" steps taken, which better accounts for trajectories that are close versus ones that deviate significantly. Evaluation metrics can also focus on whether all of the expected tools are called in any order.

However, none of these approaches evaluate the input to the tools; they only focus on the tools selected. In order to account for this, another evaluation technique is to pass the full agent's trajectory (along with a reference trajectory) as a set of messages (e.g., all LLM responses and tool calls) an LLM-as-judge. This can evaluate the complete behavior of the agent, but it is the most challenging reference to compile (luckily, using a framework like LangGraph can help with this!). Another downside is that evaluation metrics can be somewhat tricky to come up with.

## Retrieval augmented generation (RAG)

Retrieval Augmented Generation (RAG) is a powerful technique that involves retrieving relevant documents based on a user's input and passing them to a language model for processing. RAG enables AI applications to generate more informed and context-aware responses by leveraging external knowledge.

<Info>
  For a comprehensive review of RAG concepts, see our [`RAG From Scratch` series](https://github.com/langchain-ai/rag-from-scratch).
</Info>

When evaluating RAG applications, a key consideration is whether you have (or can easily obtain) reference answers for each input question. Reference answers serve as ground truth for assessing the correctness of the generated responses. However, even in the absence of reference answers, various evaluations can still be performed using reference-free RAG evaluation prompts (examples provided below).

`LLM-as-judge` is a commonly used evaluator for RAG because it's an effective way to evaluate factual accuracy or consistency between texts.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=1252b1369be04ddb4c480af277443ac2" alt="rag-types.png" data-og-width="1696" width="1696" data-og-height="731" height="731" data-path="langsmith/images/rag-types.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=dda9fa7e589b9d37bd31a5ba63d1f0fb 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=e16fca6e49aeb889cc9d6e04baca684a 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=de442b611295218493a5783820794727 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ad286f13e4a15ec892f5995a539daf5d 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=64c7b545e34ac5d4bf975ee2f44af8df 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rag-types.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=447cb995acde1f42ffeee2883c61a033 2500w" />

When evaluating RAG applications, you can have evaluators that require reference outputs and those that don't:

1. **Require reference output**: Compare the RAG chain's generated answer or retrievals against a reference answer (or retrievals) to assess its correctness.
2. **Don't require reference output**: Perform self-consistency checks using prompts that don't require a reference answer (represented by orange, green, and red in the above figure).

### Applying RAG Evaluation

When applying RAG evaluation, consider the following approaches:

1. `Offline evaluation`: Use offline evaluation for any prompts that rely on a reference answer. This is most commonly used for RAG answer correctness evaluation, where the reference is a ground truth (correct) answer.

2. `Online evaluation`: Employ online evaluation for any reference-free prompts. This allows you to assess the RAG application's performance in real-time scenarios.

3. `Pairwise evaluation`: Utilize pairwise evaluation to compare answers produced by different RAG chains. This evaluation focuses on user-specified criteria (e.g., answer format or style) rather than correctness, which can be evaluated using self-consistency or a ground truth reference.

### RAG evaluation summary

| Evaluator           | Detail                                            | Needs reference output | LLM-as-judge?                                                                         | Pairwise relevant |
| ------------------- | ------------------------------------------------- | ---------------------- | ------------------------------------------------------------------------------------- | ----------------- |
| Document relevance  | Are documents relevant to the question?           | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/rag-document-relevance)   | No                |
| Answer faithfulness | Is the answer grounded in the documents?          | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/rag-answer-hallucination) | No                |
| Answer helpfulness  | Does the answer help address the question?        | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/rag-answer-helpfulness)   | No                |
| Answer correctness  | Is the answer consistent with a reference answer? | Yes                    | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/rag-answer-vs-reference)  | No                |
| Pairwise comparison | How do multiple answer versions compare?          | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/pairwise-evaluation-rag)  | Yes               |

Summarization is one specific type of free-form writing. The evaluation aim is typically to examine the writing (summary) relative to a set of criteria.

`Developer curated examples` of texts to summarize are commonly used for evaluation (see a dataset example [here](https://smith.langchain.com/public/659b07af-1cab-4e18-b21a-91a69a4c3990/d)). However, `user logs` from a production (summarization) app can be used for online evaluation with any of the `Reference-free` evaluation prompts below.

`LLM-as-judge` is typically used for evaluation of summarization (as well as other types of writing) using `Reference-free` prompts that follow provided criteria to grade a summary. It is less common to provide a particular `Reference` summary, because summarization is a creative task and there are many possible correct answers.

`Online` or `Offline` evaluation are feasible because of the `Reference-free` prompt used. `Pairwise` evaluation is also a powerful way to perform comparisons between different summarization chains (e.g., different summarization prompts or LLMs):

| Use Case         | Detail                                                                     | Needs reference output | LLM-as-judge?                                                                                | Pairwise relevant |
| ---------------- | -------------------------------------------------------------------------- | ---------------------- | -------------------------------------------------------------------------------------------- | ----------------- |
| Factual accuracy | Is the summary accurate relative to the source documents?                  | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/summary-accurancy-evaluator)     | Yes               |
| Faithfulness     | Is the summary grounded in the source documents (e.g., no hallucinations)? | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/summary-hallucination-evaluator) | Yes               |
| Helpfulness      | Is summary helpful relative to user need?                                  | No                     | Yes - [prompt](https://smith.langchain.com/hub/langchain-ai/summary-helpfulness-evaluator)   | Yes               |

## Classification and tagging

Classification and tagging apply a label to a given input (e.g., for toxicity detection, sentiment analysis, etc). Classification/tagging evaluation typically employs the following components, which we will review in detail below:

A central consideration for classification/tagging evaluation is whether you have a dataset with `reference` labels or not. If not, users frequently want to define an evaluator that uses criteria to apply label (e.g., toxicity, etc) to an input (e.g., text, user-question, etc). However, if ground truth class labels are provided, then the evaluation objective is focused on scoring a classification/tagging chain relative to the ground truth class label (e.g., using metrics such as precision, recall, etc).

If ground truth reference labels are provided, then it's common to simply define a [custom heuristic evaluator](/langsmith/code-evaluator) to compare ground truth labels to the chain output. However, it is increasingly common given the emergence of LLMs simply use `LLM-as-judge` to perform the classification/tagging of an input based upon specified criteria (without a ground truth reference).

`Online` or `Offline` evaluation is feasible when using `LLM-as-judge` with the `Reference-free` prompt used. In particular, this is well suited to `Online` evaluation when a user wants to tag / classify application input (e.g., for toxicity, etc).

| Use Case  | Detail              | Needs reference output | LLM-as-judge? | Pairwise relevant |
| --------- | ------------------- | ---------------------- | ------------- | ----------------- |
| Accuracy  | Standard definition | Yes                    | No            | No                |
| Precision | Standard definition | Yes                    | No            | No                |
| Recall    | Standard definition | Yes                    | No            | No                |

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/evaluation-approaches.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## How to run evaluations with Vitest/Jest (beta)

**URL:** llms-txt#how-to-run-evaluations-with-vitest/jest-(beta)

**Contents:**
- Setup
  - Vitest
  - Jest
- Define and run evals
- Trace feedback
- Running multiple examples against a test case
- Log outputs
- Trace intermediate calls
- Focusing or skipping tests
- Configuring test suites

Source: https://docs.langchain.com/langsmith/vitest-jest

LangSmith provides integrations with Vitest and Jest that allow JavaScript and TypeScript developers define their datasets and evaluate using familiar syntax.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=94fd2a6f61c9dc386002fadbab7024a8" alt="Jest/Vitest reporter output" data-og-width="2200" width="2200" data-og-height="564" height="564" data-path="langsmith/images/jest-vitest-reporter-output.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=cf56669ba6d6ab79ed6237424f163fa7 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=af88b4a6c4d31520b783336f311f56fc 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=32ee63fc2b8923236850f9b2a1fb1775 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=e1f396ae3e1b68e358efc599f700e0c3 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=77b9a394525825d5f9395cdb22a5c8b4 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/jest-vitest-reporter-output.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=2d22bf302eedc50c70280ce2d8bc7d79 2500w" />

Compared to the `evaluate()` evaluation flow, this is useful when:

* Each example requires different evaluation logic
* You want to assert binary expectations, and both track these assertions in LangSmith and raise assertion errors locally (e.g. in CI pipelines)
* You want to take advantage of mocks, watch mode, local results, or other features of the Vitest/Jest ecosystems

<Info>
  Requires JS/TS SDK version `langsmith>=0.3.1`.
</Info>

<Warning>
  The Vitest/Jest integrations are in beta and are subject to change in upcoming releases.
</Warning>

<Info>
  The Python SDK has an analogous [pytest integration](/langsmith/pytest).
</Info>

Set up the integrations as follows. Note that while you can add LangSmith evals alongside your other unit tests (as standard `*.test.ts` files) using your existing test config files, the below examples will also set up a separate test config file and command to run your evals. It will assume you end your test files with `.eval.ts`.

This ensures that the custom test reporter and other LangSmith touchpoints do not modify your existing test outputs.

Install the required development dependencies if you have not already:

The examples below also require `openai` (and of course `langsmith`!) as a dependency:

Then create a separate `ls.vitest.config.ts` file with the following base config:

* `include` ensures that only files ending with some variation of `eval.ts` in your project are run
* `reporters` is responsible for nicely formatting your output as shown above
* `setupFiles` runs `dotenv` to load environment variables before running your evals

<Warning>
  JSDom environments are not supported at this time. You should either omit the `"environment"` field from your config or set it to `"node"`.
</Warning>

Finally, add the following to the `scripts` field in your `package.json` to run Vitest with the config you just created:

Note that the above script disables Vitest's default watch mode for running evals since many evaluators may include longer running LLM calls.

Install the required development dependencies if you have not already:

The examples below also require `openai` (and of course `langsmith`!) as a dependency:

<Info>
  The setup instructions below are for basic JS files and CJS. To add support for TypeScript and ESM, see Jest's official docs or use [Vitest](#vitest).
</Info>

Then create a separate config file named `ls.jest.config.cjs`:

* `testMatch` ensures that only files ending with some variation of `eval.js` in your project are run
* `reporters` is responsible for nicely formatting your output as shown above
* `setupFiles` runs `dotenv` to load environment variables before running your evals

<Warning>
  JSDom environments are not supported at this time. You should either omit the `"testEnvironment"` field from your config or set it to `"node"`.
</Warning>

Finally, add the following to the `scripts` field in your `package.json` to run Jest with the config you just created:

## Define and run evals

You can now define evals as tests using familiar Vitest/Jest syntax, with a few caveats:

* You should import `describe` and `test` from the `langsmith/jest` or `langsmith/vitest` entrypoint
* You must wrap your test cases in a `describe` block
* When declaring tests, the signature is slightly different - there is an extra argument containing example inputs and expected outputs

Try it out by creating a file named `sql.eval.ts` (or `sql.eval.js` if you are using Jest without TypeScript) and pasting the below contents into it:

You can think of each `ls.test()` case as corresponding to a dataset example, and `ls.describe()` as defining a LangSmith dataset. If you have LangSmith [tracing environment variables](/#3-set-up-your-environment) set when you run the test suite, the SDK does the following:

* creates a [dataset](/langsmith/evaluation-concepts#datasets) with the same name as the name passed to `ls.describe()` in LangSmith if it does not exist
* creates an example in the dataset for each input and expected output passed into a test case if a matching one does not already exist
* creates a new [experiment](/langsmith/evaluation-concepts#experiment) with one result for each test case
* collects the pass/fail rate under the `pass` feedback key for each test case

When you run this test it will have a default `pass` boolean feedback key based on the test case passing / failing. It will also track any outputs that you log with the `ls.logOutputs()` or return from the test function as "actual" result values from your app for the experiment.

Create a `.env` file with your `OPENAI_API_KEY` and LangSmith credentials if you don't already have one:

Now use the `eval` script we set up in the previous step to run the test:

And your declared test should run!

Once it finishes, if you've set your LangSmith environment variables, you should see a link directing you to an experiment created in LangSmith alongside the test results.

Here's what an experiment against that test suite looks like:

<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9cde688950dd2fc454a8514b02ed7268" alt="Experiment" data-og-width="2752" width="2752" data-og-height="902" height="902" data-path="langsmith/images/simple-vitest.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e583f4ee7179018b026ce9c037a05702 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=3d87bf9ced639e2deb375f0638b1912e 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e1f92efbbffa880300575043180eb107 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=90a9e603ea1b613b6a95f4a686cb954b 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=335d4ba669f1a75d6c8171ce2d7cbb99 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/simple-vitest.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9330a3bc998e80851ce3a162272b037d 2500w" />

By default LangSmith collects the pass/fail rate under the `pass` feedback key for each test case. You can add additional feedback with either `ls.logFeedback()` or `wrapEvaluator()`. To do so, try the following as your `sql.eval.ts` file (or `sql.eval.js` if you are using Jest without TypeScript):

Note the use of `ls.wrapEvaluator()` around the `myEvaluator` function. This makes it so that the LLM-as-judge call is traced separately from the rest of the test case to avoid clutter, and conveniently creates feedback if the return value from the wrapped function matches `{ key: string; score: number | boolean }`. In this case, instead of showing up in the main test case run, the evaluator trace will instead show up in a trace associated with the `correctness` feedback key.

You can see the evaluator runs in LangSmith by clicking their corresponding feedback chips in the UI.

## Running multiple examples against a test case

You can run the same test case over multiple examples and parameterize your tests using `ls.test.each()`. This is useful when you want to evaluate your app the same way against different inputs:

If you have tracking enabled, each example in the local dataset will be synced to the one created in LangSmith.

Every time we run a test we're syncing it to a dataset example and tracing it as a run. To trace final outputs for the run, you can use `ls.logOutputs()` like this:

The logged outputs will appear in your reporter summary and in LangSmith.

You can also directly return a value from your test function:

However keep in mind if you do this that if your test fails to complete due to a failed assertion or other error, your output will not appear.

## Trace intermediate calls

LangSmith will automatically trace any traceable intermediate calls that happen in the course of test case execution.

## Focusing or skipping tests

You can chain the Vitest/Jest `.skip` and `.only` methods on `ls.test()` and `ls.describe()`:

## Configuring test suites

You can configure test suites with values like metadata or a custom client by passing an extra argument to `ls.describe()` for the full suite or by passing a `config` field into `ls.test()` for individual tests:

The test suite will also automatically extract environment variables from `process.env.ENVIRONMENT`, `process.env.NODE_ENV` and `process.env.LANGSMITH_ENVIRONMENT` and set them as metadata on created experiments. You can then filter experiments by metadata in LangSmith's UI.

See [the API refs](https://docs.smith.langchain.com/reference/js/functions/vitest.describe) for a full list of configuration options.

If you want to run the tests without syncing the results to LangSmith, you can set omit your LangSmith tracing environment variables or set `LANGSMITH_TEST_TRACKING=false` in your environment.

The tests will run as normal, but the experiment logs will not be sent to LangSmith.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/vitest-jest.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown
</CodeGroup>

The examples below also require `openai` (and of course `langsmith`!) as a dependency:

<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## Key-value stores

**URL:** llms-txt#key-value-stores

**Contents:**
- Overview
- Interface
- Built-in stores for local development
- Custom stores
- All key-value stores

Source: https://docs.langchain.com/oss/python/integrations/stores/index

LangChain provides a key-value store interface for storing and retrieving data by key. The key-value store interface in LangChain is primarily used for caching [embeddings](/oss/python/integrations/text_embedding).

All [`BaseStores`](https://python.langchain.com/api_reference/core/stores/langchain_core.stores.BaseStore.html) support the following interface:

* `mget(key: Sequence[str]) -> List[Optional[bytes]]`: get the contents of multiple keys, returning `None` if the key does not exist
* `mset(key_value_pairs: Sequence[Tuple[str, bytes]]) -> None`: set the contents of multiple keys
* `mdelete(key: Sequence[str]) -> None`: delete multiple keys
* `yield_keys(prefix: Optional[str] = None) -> Iterator[str]`: yield all keys in the store, optionally filtering by a prefix

<Note>
  Base stores are designed to work **multiple** key-value pairs at once for efficiency. This saves on network round-trips and may allow for more efficient batch operations in the underlying store.
</Note>

## Built-in stores for local development

<Columns cols={2}>
  <Card title="InMemoryByteStore" icon="link" href="/oss/python/integrations/stores/in_memory" arrow="true" cta="View guide" />

<Card title="LocalFileStore" icon="link" href="/oss/python/integrations/stores/file_system" arrow="true" cta="View guide" />
</Columns>

You can also implement your own custom store by extending the [`BaseStore`](https://reference.langchain.com/python/langgraph/store/#langgraph.store.base.BaseStore) class. See the [store interface documentation](https://python.langchain.com/api_reference/core/stores/langchain_core.stores.BaseStore.html) for more details.

## All key-value stores

<Columns cols={3}>
  <Card title="AstraDBByteStore" icon="link" href="/oss/python/integrations/stores/astradb" arrow="true" cta="View guide" />

<Card title="CassandraByteStore" icon="link" href="/oss/python/integrations/stores/cassandra" arrow="true" cta="View guide" />

<Card title="ElasticsearchEmbeddingsCache" icon="link" href="/oss/python/integrations/stores/elasticsearch" arrow="true" cta="View guide" />

<Card title="RedisStore" icon="link" href="/oss/python/integrations/stores/redis" arrow="true" cta="View guide" />

<Card title="UpstashRedisByteStore" icon="link" href="/oss/python/integrations/stores/upstash_redis" arrow="true" cta="View guide" />
</Columns>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/integrations/stores/index.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Text block

**URL:** llms-txt#text-block

text_block = {
    "type": "text",
    "text": "Hello world",
}

---

## Create a child run, linked to the parent

**URL:** llms-txt#create-a-child-run,-linked-to-the-parent

child_run = construct_run(
    name="Child Run",
    run_type="llm",
    inputs={"question": "What is the capital of France?"},
    parent_dotted_order=parent_run["dotted_order"],
)

---

## 3. Define the interface to your app

**URL:** llms-txt#3.-define-the-interface-to-your-app

def chatbot(inputs: dict) -> dict:
    return {"answer": inputs["question"] + " is a good question. I don't know the answer."}

---

## Configure threads

**URL:** llms-txt#configure-threads

**Contents:**
- Group traces into threads
  - Example
- View threads
  - View a thread
  - View feedback
  - Save thread level filter

Source: https://docs.langchain.com/langsmith/threads

Many LLM applications have a chatbot-like interface in which the user and the LLM application engage in a multi-turn conversation. In order to track these conversations, you can use the `Threads` feature in LangSmith.

## Group traces into threads

A `Thread` is a sequence of traces representing a single conversation. Each response is represented as its own trace, but these traces are linked together by being part of the same thread.

To associate traces together, you need to pass in a special `metadata` key where the value is the unique identifier for that thread. The key name should be one of:

* `session_id`
* `thread_id`
* `conversation_id`.

The value can be any string you want, but we recommend using UUIDs, such as `f47ac10b-58cc-4372-a567-0e02b2c3d479`. Check out [this guide](./add-metadata-tags) for instructions on adding metadata to your traces.

This example demonstrates how to log and retrieve conversation history using a structured message format to maintain long-running chats.

After waiting a few seconds, you can make the following calls to continue the conversation. By passing `get_chat_history=True,`/`getChatHistory: true`,
you can continue the conversation from where it left off. This means that the LLM will receive the entire message history and respond to it,
instead of just responding to the latest message.

Keep the conversation going. Since past messages are included, the LLM will remember the conversation.

You can view threads by clicking on the **Threads** tab in any project details page. You will then see a list of all threads, sorted by the most recent activity.

<div style={{ textAlign: 'center' }}>
  <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=45e1c11dce5eaaaf0cf8ae01057647b7" alt="LangSmith UI showing the threads table." data-og-width="1277" width="1277" data-og-height="762" height="762" data-path="langsmith/images/threads-tab-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=280&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=cb5d147a58a3a9ecbb1c550a3308e871 280w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=560&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=a7cc6f9c8def1e15cc9c93382b82473d 560w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=840&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=23013f31edf91e66da89e102cb6ea302 840w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=1100&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=1bfbd6daad34b699553a30d8f9663540 1100w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=1650&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=d3fc20ddbe02630ac98a0c336a39caa7 1650w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-light.png?w=2500&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=cfa17b6f006faef0a6f8537eedab6532 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=b0ec4964ee49a3ead3a1e8042e406abc" alt="LangSmith UI showing the threads table." data-og-width="1275" width="1275" data-og-height="761" height="761" data-path="langsmith/images/threads-tab-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=280&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=98750a8129e2e8283871c096a642f8b8 280w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=560&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=4be143312bdd90ab8318da304c0c1e91 560w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=840&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=c7ace4e000b6a1c925d32b78983fadca 840w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=1100&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=9ece1b058745be1c3b2dcfffd9a9af58 1100w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=1650&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=0ab63a1b906fe2a559cfb5772c95dc47 1650w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/threads-tab-dark.png?w=2500&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=6093b81ee1f92978880e74a9630f451d 2500w" />
</div>

You can then click into a particular thread. This will open the history for a particular thread.

<div style={{ textAlign: 'center' }}>
  <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=f7af4c3904073d5f58f28c656603ca19" alt="LangSmith UI showing the threads table." data-og-width="1273" width="1273" data-og-height="757" height="757" data-path="langsmith/images/thread-overview-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=280&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=cd769088ab3ab2dae09982915f23772d 280w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=560&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=70ae6b5a6b8edb83ba3604d4c6e0262e 560w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=840&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=61d89d8077072221373490edac65363c 840w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=1100&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=ad8159fe12f056dbc561c612e3797b97 1100w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=1650&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=3611f7bcc95c45bcb91c093ca36ef348 1650w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-light.png?w=2500&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=1c0426d7e83562e1d76e079959bda186 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=f738de4cac932ed2b8657e8f3b706b77" alt="LangSmith UI showing the threads table." data-og-width="1273" width="1273" data-og-height="753" height="753" data-path="langsmith/images/thread-overview-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=280&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=9bc9dd49c63661dceb981899c5f0332b 280w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=560&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=01713d47cf762f99be1a1143b01582e8 560w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=840&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=cfc77e449d0ce27cdfa51b2f7c6ed655 840w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=1100&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=d84f671a8f2c1207dbb98c72a37d1832 1100w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=1650&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=d592bd4c8671b3d7f19a49471888a901 1650w, https://mintcdn.com/langchain-5e9cc07a/zLS2qlRr5r04zU3G/langsmith/images/thread-overview-dark.png?w=2500&fit=max&auto=format&n=zLS2qlRr5r04zU3G&q=85&s=2405eaef2af227dd5e5efac85fc9e623 2500w" />
</div>

Threads can be viewed in two different ways:

* [Thread overview](/langsmith/threads#thread-overview)
* [Trace view](/langsmith/threads#trace-view)

You can use the buttons at the top of the page to switch between the two views or use the keyboard shortcut `T` to toggle between the two views.

The thread overview page shows you a chatbot-like UI where you can see the inputs and outputs for each turn of the conversation. You can configure which fields in the inputs and outputs are displayed in the overview, or show multiple fields by clicking the **Configure** button.

The JSON path for the inputs and outputs supports negative indexing, so you can use `-1` to access the last element of an array. For example, `inputs.messages[-1].content` will access the last message in the `messages` array.

The trace view here is similar to the trace view when looking at a single run, except that you have easy access to all the runs for each turn in the thread.

When viewing a thread, across the top of the page you will see a section called `Feedback`. This is where you can see the feedback for each of the runs that make up the thread. This feedback is aggregated, so if you evaluate each run of a thread for the same criteria, you will see the average score across all the runs displayed. You can also see [thread level feedback](/langsmith/online-evaluations#configure-multi-turn-online-evaluators) left here.

### Save thread level filter

Similar to saving filters at the project level, you can also save commonly used filters at the thread level. To save filters on the threads table, set a filter using the filters button and then click the **Save filter** button.

You can open up the trace or annotate the trace in a side panel by clicking on `Annotate` and `Open trace`, respectively.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/threads.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

After waiting a few seconds, you can make the following calls to continue the conversation. By passing `get_chat_history=True,`/`getChatHistory: true`,
you can continue the conversation from where it left off. This means that the LLM will receive the entire message history and respond to it,
instead of just responding to the latest message.

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

Keep the conversation going. Since past messages are included, the LLM will remember the conversation.

<CodeGroup>
```

---

## >                'allowed_decisions': ['approve', 'reject']

**URL:** llms-txt#>----------------'allowed_decisions':-['approve',-'reject']

---

## pip install requests requests_toolbelt

**URL:** llms-txt#pip-install-requests-requests_toolbelt

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/trace-with-api.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## This means that after 'tools' is called, 'agent' node is called next.

**URL:** llms-txt#this-means-that-after-'tools'-is-called,-'agent'-node-is-called-next.

workflow.add_edge("tools", 'agent')

---

## Separate loop to avoid logging at the same time as logs from evaluate()

**URL:** llms-txt#separate-loop-to-avoid-logging-at-the-same-time-as-logs-from-evaluate()

**Contents:**
- Understand the result structure
- Examples
  - Implement a quality gate

for result in aggregated_results:
    print("Input:", result["run"].inputs)
    print("Output:", result["run"].outputs)
    print("Evaluation Results:", result["evaluation_results"]["results"])
    print("--------------------------------")

Input: {'input': 'MY INPUT'}
Output: {'output': 'MY OUTPUT'}
Evaluation Results: [EvaluationResult(key='randomness', score=1, value=None, comment=None, correction=None, evaluator_info={}, feedback_config=None, source_run_id=UUID('7ebb4900-91c0-40b0-bb10-f2f6a451fd3c'), target_run_id=None, extra=None)]
--------------------------------
python  theme={null}
from langsmith import Client
import sys

def my_application(inputs):
    # Your application logic
    return {"response": "..."}

def accuracy_evaluator(run, example):
    # Your evaluation logic
    is_correct = run.outputs["response"] == example.outputs["expected"]
    return {"key": "accuracy", "score": 1 if is_correct else 0}

**Examples:**

Example 1 (unknown):
```unknown
This produces output like:
```

Example 2 (unknown):
```unknown
## Understand the result structure

Each result in the iterator contains:

* `result["run"]`: The execution of your target function.
  * `result["run"].inputs`: The inputs from your [dataset](/langsmith/evaluation-concepts#datasets) example.
  * `result["run"].outputs`: The outputs produced by your target function.
  * `result["run"].id`: The unique ID for this run.

* `result["evaluation_results"]["results"]`: A list of `EvaluationResult` objects, one per evaluator.
  * `key`: The metric name (from your evaluator's return value).
  * `score`: The numeric score (typically 0-1 or boolean).
  * `comment`: Optional explanatory text.
  * `source_run_id`: The ID of the evaluator run.

* `result["example"]`: The dataset example that was evaluated.
  * `result["example"].inputs`: The input values.
  * `result["example"].outputs`: The reference outputs (if any).

## Examples

### Implement a quality gate

This example uses evaluation results to pass or fail a CI/CD build automatically based on quality thresholds. The script iterates through results, calculates an average accuracy score, and exits with a non-zero status code if the accuracy falls below 85%. This ensures that you can deploy code changes that meet quality standards.
```

---

## Upload files with traces

**URL:** llms-txt#upload-files-with-traces

**Contents:**
  - Python

Source: https://docs.langchain.com/langsmith/upload-files-with-traces

<Check>
  Before diving into this content, it would be helpful to read the following guides:

* [Trace with LangSmith using the traceable decorator or wrapper](/langsmith/annotate-code#use-traceable--traceable)
</Check>

<Note>
  The following features are available in the following SDK versions:

* Python SDK: >=0.1.141
  * JS/TS SDK: >=0.2.5
</Note>

LangSmith supports uploading binary files (such as images, audio, videos, PDFs, and CSVs) with your traces. This is particularly useful when working with LLM pipelines using multimodal inputs or outputs.

In both the Python and TypeScript SDKs, attachments can be added to your traces by specifying the MIME type and binary content of each file. This guide explains how to define and trace attachments using the `Attachment` type in Python and `Uint8Array` / `ArrayBuffer` in TypeScript.

In the Python SDK, you can use the `Attachment` type to add files to your traces. Each `Attachment` requires:

* `mime_type` (str): The MIME type of the file (e.g., `"image/png"`).
* `data` (bytes | Path): The binary content of the file, or the file path.

You can also define an attachment with a tuple tuple of the form `(mime_type, data)` for convenience.

Simply decorate a function with `@traceable` and include your `Attachment` instances as arguments. Note that to use the file path instead of the raw bytes, you need to set the `dangerously_allow_filesystem` flag to `True` in your traceable decorator.

```python Python theme={null}
from langsmith import traceable
from langsmith.schemas import Attachment
from pathlib import Path
import os

---

## Configure custom TLS certificates

**URL:** llms-txt#configure-custom-tls-certificates

**Contents:**
- Mount internal CAs for TLS
- Use custom TLS certificates for model providers

Source: https://docs.langchain.com/langsmith/self-host-custom-tls-certificates

Use this guide to configure TLS in LangSmith. Start by mounting internal certificate authorities (CAs) so your deployment trusts the right roots system‑wide, for database or external service calls. You can then configure [Playground](/langsmith/prompt-engineering-concepts#prompt-playground)-specific mTLS for communicating securely with supported model providers.

* [Mounting internal certificate authorities](#mount-internal-cas-for-tls) (CAs) system-wide to enable TLS for database connections and Playground model calls
* Using Playground-specific TLS settings to provide client certs/keys for mTLS with supported model providers

## Mount internal CAs for TLS

<Note>
  You must use Helm chart version 0.11.9 or later to mount internal CAs using the configuration below.
</Note>

Use this approach to make internal/public CAs trusted system‑wide by LangSmith (Playground model calls and [database/external service connections](/langsmith/self-hosted#storage-services)).

1. Create a file containing all CAs required for TLS with databases and external services. If your deployment is communicating directly to `beacon.langchain.com` without a proxy, make sure to include a public trusted CA. All certs should be concatenated in this file with an empty line in between.
   
2. Create a Kubernetes secret with a key containing the contents of this file.
   
3. If using custom CA for TLS with your databases and other external services, provide the following values to your LangSmith helm chart:
   
4. Make sure to use TLS supported connection strings:
   * <b>Postgres</b>: Add `?sslmode=verify-full&sslrootcert=system` to the end.
   * <b>Redis</b>: Use `rediss://` instead of `redis://` as the prefix.

## Use custom TLS certificates for model providers

<Note>
  This feature is currently only available for the following model providers:

* Azure OpenAI
  * OpenAI
  * Custom (our custom model server). Refer to the [custom model server documentation](/langsmith/custom-endpoint) for more information.

These TLS settings apply to all invocations of the selected model providers (including Online Evaluation). Use them when the provider requires mutual TLS (client cert/key) or when you must override trust with a specific CA for provider calls. They complement the internal CA bundle configured above.
</Note>

You can use custom TLS certificates to connect to model providers in the LangSmith Playground. This is useful if you are using a self-signed certificate, a certificate from a custom certificate authority, or mutual TLS authentication.

To use custom TLS certificates, set the following environment variables. See the [self hosted deployment section](/langsmith/architectural-overview) for more information on how to configure application settings.

* `LANGSMITH_PLAYGROUND_TLS_MODEL_PROVIDERS`: A comma-separated list of model providers that require custom TLS certificates. Note that `azure_openai`, `openai`, and `custom` are currently the only supported model providers, but more providers will be supported in the future.
* \[Optional] `LANGSMITH_PLAYGROUND_TLS_KEY`: The private key in PEM format. This must be a file path (for a mounted volume). This is usually only necessary for mutual TLS authentication.
* \[Optional] `LANGSMITH_PLAYGROUND_TLS_CERT`: The certificate in PEM format. This must be a file path (for a mounted volume). This is usually only necessary for mutual TLS authentication.
* \[Optional] `LANGSMITH_PLAYGROUND_TLS_CA`: The custom certificate authority (CA) certificate in PEM format. This must be a file path (for a mounted volume). Use this to mount CAs only if you're using a helm version below `0.11.9`; otherwise, use the [Mount internal CAs for TLS](./self-host-custom-tls-certificates#mount-internal-cas-for-tls) section above.

Once you have set these environment variables, enter the LangSmith Playground **Settings** page and select the **Provider** that requires custom TLS certificates. Set your model provider configuration as usual, and the custom TLS certificates will be used when connecting to the model provider.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/self-host-custom-tls-certificates.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
-----BEGIN CERTIFICATE-----
   <PUBLIC_CA>
   -----END CERTIFICATE-----

   -----BEGIN CERTIFICATE-----
   <INTERNAL_CA>
   -----END CERTIFICATE-----

   ...
```

Example 2 (unknown):
```unknown
3. If using custom CA for TLS with your databases and other external services, provide the following values to your LangSmith helm chart:
```

---

## Built-in middleware

**URL:** llms-txt#built-in-middleware

**Contents:**
- Provider-agnostic middleware
  - Summarization
  - Human-in-the-loop
  - Model call limit
  - Tool call limit
  - Model fallback
  - PII detection

Source: https://docs.langchain.com/oss/python/langchain/middleware/built-in

Prebuilt middleware for common agent use cases

LangChain provides prebuilt middleware for common use cases. Each middleware is production-ready and configurable for your specific needs.

## Provider-agnostic middleware

The following middleware work with any LLM provider:

| Middleware                              | Description                                                                 |
| --------------------------------------- | --------------------------------------------------------------------------- |
| [Summarization](#summarization)         | Automatically summarize conversation history when approaching token limits. |
| [Human-in-the-loop](#human-in-the-loop) | Pause execution for human approval of tool calls.                           |
| [Model call limit](#model-call-limit)   | Limit the number of model calls to prevent excessive costs.                 |
| [Tool call limit](#tool-call-limit)     | Control tool execution by limiting call counts.                             |
| [Model fallback](#model-fallback)       | Automatically fallback to alternative models when primary fails.            |
| [PII detection](#pii-detection)         | Detect and handle Personally Identifiable Information (PII).                |
| [To-do list](#to-do-list)               | Equip agents with task planning and tracking capabilities.                  |
| [LLM tool selector](#llm-tool-selector) | Use an LLM to select relevant tools before calling main model.              |
| [Tool retry](#tool-retry)               | Automatically retry failed tool calls with exponential backoff.             |
| [LLM tool emulator](#llm-tool-emulator) | Emulate tool execution using an LLM for testing purposes.                   |
| [Context editing](#context-editing)     | Manage conversation context by trimming or clearing tool uses.              |
| [Shell tool](#shell-tool)               | Expose a persistent shell session to agents for command execution.          |
| [File search](#file-search)             | Provide Glob and Grep search tools over filesystem files.                   |

Automatically summarize conversation history when approaching token limits, preserving recent messages while compressing older context. Summarization is useful for the following:

* Long-running conversations that exceed context windows.
* Multi-turn dialogues with extensive history.
* Applications where preserving full conversation context matters.

**API reference:** [`SummarizationMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.SummarizationMiddleware)

<Accordion title="Configuration options">
  <Tip>
    The `fraction` conditions for `trigger` and `keep` (shown below) rely on a chat model's [profile data](/oss/python/langchain/models#model-profiles) if using `langchain>=1.1`. If data are not available, use another condition or specify manually:

<ParamField body="model" type="string | BaseChatModel" required>
    Model for generating summaries. Can be a model identifier string (e.g., `'openai:gpt-4o-mini'`) or a `BaseChatModel` instance. See [`init_chat_model`](https://reference.langchain.com/python/langchain/models/#langchain.chat_models.init_chat_model\(model\)) for more information.
  </ParamField>

<ParamField body="trigger" type="dict | list[dict]">
    Conditions for triggering summarization. Can be:

* A single condition dict (all properties must be met - AND logic)
    * A list of condition dicts (any condition must be met - OR logic)

Each condition can include:

* `fraction` (float): Fraction of model's context size (0-1)
    * `tokens` (int): Absolute token count
    * `messages` (int): Message count

At least one property must be specified per condition. If not provided, summarization will not trigger automatically.
  </ParamField>

<ParamField body="keep" type="dict" default="{messages: 20}">
    How much context to preserve after summarization. Specify exactly one of:

* `fraction` (float): Fraction of model's context size to keep (0-1)
    * `tokens` (int): Absolute token count to keep
    * `messages` (int): Number of recent messages to keep
  </ParamField>

<ParamField body="token_counter" type="function">
    Custom token counting function. Defaults to character-based counting.
  </ParamField>

<ParamField body="summary_prompt" type="string">
    Custom prompt template for summarization. Uses built-in template if not specified. The template should include `{messages}` placeholder where conversation history will be inserted.
  </ParamField>

<ParamField body="trim_tokens_to_summarize" type="number" default="4000">
    Maximum number of tokens to include when generating the summary. Messages will be trimmed to fit this limit before summarization.
  </ParamField>

<ParamField body="summary_prefix" type="string">
    Prefix to add to the summary message. If not provided, a default prefix is used.
  </ParamField>

<ParamField body="max_tokens_before_summary" type="number" deprecated>
    **Deprecated:** Use `trigger: {"tokens": value}` instead. Token threshold for triggering summarization.
  </ParamField>

<ParamField body="messages_to_keep" type="number" deprecated>
    **Deprecated:** Use `keep: {"messages": value}` instead. Recent messages to preserve.
  </ParamField>
</Accordion>

<Accordion title="Full example">
  The summarization middleware monitors message token counts and automatically summarizes older messages when thresholds are reached.

**Trigger conditions** control when summarization runs:

* Single condition object (all properties must be met - AND logic)
  * Array of conditions (any condition must be met - OR logic)
  * Each condition can use `fraction` (of model's context size), `tokens` (absolute count), or `messages` (message count)

**Keep conditions** control how much context to preserve (specify exactly one):

* `fraction` - Fraction of model's context size to keep
  * `tokens` - Absolute token count to keep
  * `messages` - Number of recent messages to keep

### Human-in-the-loop

Pause agent execution for human approval, editing, or rejection of tool calls before they execute. [Human-in-the-loop](/oss/python/langchain/human-in-the-loop) is useful for the following:

* High-stakes operations requiring human approval (e.g. database writes, financial transactions).
* Compliance workflows where human oversight is mandatory.
* Long-running conversations where human feedback guides the agent.

**API reference:** [`HumanInTheLoopMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.HumanInTheLoopMiddleware)

<Warning>
  Human-in-the-loop middleware requires a [checkpointer](/oss/python/langgraph/persistence#checkpoints) to maintain state across interruptions.
</Warning>

<Tip>
  For complete examples, configuration options, and integration patterns, see the [Human-in-the-loop documentation](/oss/python/langchain/human-in-the-loop).
</Tip>

Limit the number of model calls to prevent infinite loops or excessive costs. Model call limit is useful for the following:

* Preventing runaway agents from making too many API calls.
* Enforcing cost controls on production deployments.
* Testing agent behavior within specific call budgets.

**API reference:** [`ModelCallLimitMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.ModelCallLimitMiddleware)

<Accordion title="Configuration options">
  <ParamField body="thread_limit" type="number">
    Maximum model calls across all runs in a thread. Defaults to no limit.
  </ParamField>

<ParamField body="run_limit" type="number">
    Maximum model calls per single invocation. Defaults to no limit.
  </ParamField>

<ParamField body="exit_behavior" type="string" default="end">
    Behavior when limit is reached. Options: `'end'` (graceful termination) or `'error'` (raise exception)
  </ParamField>
</Accordion>

Control agent execution by limiting the number of tool calls, either globally across all tools or for specific tools. Tool call limits are useful for the following:

* Preventing excessive calls to expensive external APIs.
* Limiting web searches or database queries.
* Enforcing rate limits on specific tool usage.
* Protecting against runaway agent loops.

**API reference:** [`ToolCallLimitMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.ToolCallLimitMiddleware)

<Accordion title="Configuration options">
  <ParamField body="tool_name" type="string">
    Name of specific tool to limit. If not provided, limits apply to **all tools globally**.
  </ParamField>

<ParamField body="thread_limit" type="number">
    Maximum tool calls across all runs in a thread (conversation). Persists across multiple invocations with the same thread ID. Requires a checkpointer to maintain state. `None` means no thread limit.
  </ParamField>

<ParamField body="run_limit" type="number">
    Maximum tool calls per single invocation (one user message → response cycle). Resets with each new user message. `None` means no run limit.

**Note:** At least one of `thread_limit` or `run_limit` must be specified.
  </ParamField>

<ParamField body="exit_behavior" type="string" default="continue">
    Behavior when limit is reached:

* `'continue'` (default) - Block exceeded tool calls with error messages, let other tools and the model continue. The model decides when to end based on the error messages.
    * `'error'` - Raise a `ToolCallLimitExceededError` exception, stopping execution immediately
    * `'end'` - Stop execution immediately with a `ToolMessage` and AI message for the exceeded tool call. Only works when limiting a single tool; raises `NotImplementedError` if other tools have pending calls.
  </ParamField>
</Accordion>

<Accordion title="Full example">
  Specify limits with:

* **Thread limit** - Max calls across all runs in a conversation (requires checkpointer)
  * **Run limit** - Max calls per single invocation (resets each turn)

* `'continue'` (default) - Block exceeded calls with error messages, agent continues
  * `'error'` - Raise exception immediately
  * `'end'` - Stop with ToolMessage + AI message (single-tool scenarios only)

Automatically fallback to alternative models when the primary model fails. Model fallback is useful for the following:

* Building resilient agents that handle model outages.
* Cost optimization by falling back to cheaper models.
* Provider redundancy across OpenAI, Anthropic, etc.

**API reference:** [`ModelFallbackMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.ModelFallbackMiddleware)

<Accordion title="Configuration options">
  <ParamField body="first_model" type="string | BaseChatModel" required>
    First fallback model to try when the primary model fails. Can be a model identifier string (e.g., `'openai:gpt-4o-mini'`) or a `BaseChatModel` instance.
  </ParamField>

<ParamField body="*additional_models" type="string | BaseChatModel">
    Additional fallback models to try in order if previous models fail
  </ParamField>
</Accordion>

Detect and handle Personally Identifiable Information (PII) in conversations using configurable strategies. PII detection is useful for the following:

* Healthcare and financial applications with compliance requirements.
* Customer service agents that need to sanitize logs.
* Any application handling sensitive user data.

**API reference:** [`PIIMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.PIIMiddleware)

#### Custom PII types

You can create custom PII types by providing a `detector` parameter. This allows you to detect patterns specific to your use case beyond the built-in types.

**Three ways to create custom detectors:**

1. **Regex pattern string** - Simple pattern matching

2. **Custom function** - Complex detection logic with validation

```python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import PIIMiddleware
import re

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Configuration options">
  <Tip>
    The `fraction` conditions for `trigger` and `keep` (shown below) rely on a chat model's [profile data](/oss/python/langchain/models#model-profiles) if using `langchain>=1.1`. If data are not available, use another condition or specify manually:
```

Example 2 (unknown):
```unknown
</Tip>

  <ParamField body="model" type="string | BaseChatModel" required>
    Model for generating summaries. Can be a model identifier string (e.g., `'openai:gpt-4o-mini'`) or a `BaseChatModel` instance. See [`init_chat_model`](https://reference.langchain.com/python/langchain/models/#langchain.chat_models.init_chat_model\(model\)) for more information.
  </ParamField>

  <ParamField body="trigger" type="dict | list[dict]">
    Conditions for triggering summarization. Can be:

    * A single condition dict (all properties must be met - AND logic)
    * A list of condition dicts (any condition must be met - OR logic)

    Each condition can include:

    * `fraction` (float): Fraction of model's context size (0-1)
    * `tokens` (int): Absolute token count
    * `messages` (int): Message count

    At least one property must be specified per condition. If not provided, summarization will not trigger automatically.
  </ParamField>

  <ParamField body="keep" type="dict" default="{messages: 20}">
    How much context to preserve after summarization. Specify exactly one of:

    * `fraction` (float): Fraction of model's context size to keep (0-1)
    * `tokens` (int): Absolute token count to keep
    * `messages` (int): Number of recent messages to keep
  </ParamField>

  <ParamField body="token_counter" type="function">
    Custom token counting function. Defaults to character-based counting.
  </ParamField>

  <ParamField body="summary_prompt" type="string">
    Custom prompt template for summarization. Uses built-in template if not specified. The template should include `{messages}` placeholder where conversation history will be inserted.
  </ParamField>

  <ParamField body="trim_tokens_to_summarize" type="number" default="4000">
    Maximum number of tokens to include when generating the summary. Messages will be trimmed to fit this limit before summarization.
  </ParamField>

  <ParamField body="summary_prefix" type="string">
    Prefix to add to the summary message. If not provided, a default prefix is used.
  </ParamField>

  <ParamField body="max_tokens_before_summary" type="number" deprecated>
    **Deprecated:** Use `trigger: {"tokens": value}` instead. Token threshold for triggering summarization.
  </ParamField>

  <ParamField body="messages_to_keep" type="number" deprecated>
    **Deprecated:** Use `keep: {"messages": value}` instead. Recent messages to preserve.
  </ParamField>
</Accordion>

<Accordion title="Full example">
  The summarization middleware monitors message token counts and automatically summarizes older messages when thresholds are reached.

  **Trigger conditions** control when summarization runs:

  * Single condition object (all properties must be met - AND logic)
  * Array of conditions (any condition must be met - OR logic)
  * Each condition can use `fraction` (of model's context size), `tokens` (absolute count), or `messages` (message count)

  **Keep conditions** control how much context to preserve (specify exactly one):

  * `fraction` - Fraction of model's context size to keep
  * `tokens` - Absolute token count to keep
  * `messages` - Number of recent messages to keep
```

Example 3 (unknown):
```unknown
</Accordion>

### Human-in-the-loop

Pause agent execution for human approval, editing, or rejection of tool calls before they execute. [Human-in-the-loop](/oss/python/langchain/human-in-the-loop) is useful for the following:

* High-stakes operations requiring human approval (e.g. database writes, financial transactions).
* Compliance workflows where human oversight is mandatory.
* Long-running conversations where human feedback guides the agent.

**API reference:** [`HumanInTheLoopMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.HumanInTheLoopMiddleware)

<Warning>
  Human-in-the-loop middleware requires a [checkpointer](/oss/python/langgraph/persistence#checkpoints) to maintain state across interruptions.
</Warning>
```

Example 4 (unknown):
```unknown
<Tip>
  For complete examples, configuration options, and integration patterns, see the [Human-in-the-loop documentation](/oss/python/langchain/human-in-the-loop).
</Tip>

### Model call limit

Limit the number of model calls to prevent infinite loops or excessive costs. Model call limit is useful for the following:

* Preventing runaway agents from making too many API calls.
* Enforcing cost controls on production deployments.
* Testing agent behavior within specific call budgets.

**API reference:** [`ModelCallLimitMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.ModelCallLimitMiddleware)
```

---

## Create a function that will take in a list of examples and format them into a string

**URL:** llms-txt#create-a-function-that-will-take-in-a-list-of-examples-and-format-them-into-a-string

**Contents:**
  - NEW CODE ###
- Semantic search over examples

def create_example_string(examples):
    final_strings = []
    for e in examples:
        final_strings.append(f"Input: {e.inputs['topic']}\n> {e.outputs['output']}")
    return "\n\n".join(final_strings)
### NEW CODE ###

client = openai.Client()

available_topics = [
    "bug",
    "improvement",
    "new_feature",
    "documentation",
    "integration",
]

prompt_template = """Classify the type of the issue as one of {topics}.

Here are some examples:
{examples}

Begin!
Issue: {text}
>"""

@traceable(
    run_type="chain",
    name="Classifier",
)
def topic_classifier(
    topic: str):
    # We can now pull down the examples from the dataset
    # We do this inside the function so it always get the most up-to-date examples,
    # But this can be done outside and cached for speed if desired
    examples = list(ls_client.list_examples(dataset_name="classifier-github-issues"))  # <- New Code
    example_string = create_example_string(examples)
    return client.chat.completions.create(
        model="gpt-4o-mini",
        temperature=0,
        messages=[
            {
                "role": "user",
                "content": prompt_template.format(
                    topics=','.join(available_topics),
                    text=topic,
                    examples=example_string,
                )
            }
        ],
    ).choices[0].message.content
python  theme={null}
ls_client = Client()
run_id = uuid.uuid4()
topic_classifier(
    "address bug in documentation",
    langsmith_extra={"run_id": run_id})
python  theme={null}
import numpy as np

def find_similar(examples, topic, k=5):
    inputs = [e.inputs['topic'] for e in examples] + [topic]
    vectors = client.embeddings.create(input=inputs, model="text-embedding-3-small")
    vectors = [e.embedding for e in vectors.data]
    vectors = np.array(vectors)
    args = np.argsort(-vectors.dot(vectors[-1])[:-1])[:5]
    examples = [examples[i] for i in args]
    return examples
python  theme={null}
ls_client = Client()

def create_example_string(examples):
    final_strings = []
    for e in examples:
        final_strings.append(f"Input: {e.inputs['topic']}\n> {e.outputs['output']}")
    return "\n\n".join(final_strings)

client = openai.Client()

available_topics = [
    "bug",
    "improvement",
    "new_feature",
    "documentation",
    "integration",
]

prompt_template = """Classify the type of the issue as one of {topics}.

Here are some examples:
{examples}

Begin!
Issue: {text}
>"""

@traceable(
    run_type="chain",
    name="Classifier",
)
def topic_classifier(
    topic: str):
    examples = list(ls_client.list_examples(dataset_name="classifier-github-issues"))
    examples = find_similar(examples, topic)
    example_string = create_example_string(examples)
    return client.chat.completions.create(
        model="gpt-4o-mini",
        temperature=0,
        messages=[
            {
                "role": "user",
                "content": prompt_template.format(
                    topics=','.join(available_topics),
                    text=topic,
                    examples=example_string,
                )
            }
        ],
    ).choices[0].message.content
```

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/optimize-classifier.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
If now run the application with a similar input as before, we can see that it correctly learns that anything related to docs (even if a bug) should be classified as `documentation`
```

Example 2 (unknown):
```unknown
## Semantic search over examples

One additional thing we can do is only use the most semantically similar examples. This is useful when you start to build up a lot of examples.

In order to do this, we can first define an example to find the `k` most similar examples:
```

Example 3 (unknown):
```unknown
We can then use that in the application
```

---

## Trace generator functions

**URL:** llms-txt#trace-generator-functions

**Contents:**
- Aggregate Results[](#aggregate-results "Direct link to Aggregate Results")

Source: https://docs.langchain.com/langsmith/trace-generator-functions

In most LLM applications, you will want to stream outputs to minimize the time to the first token seen by the user.

LangSmith's tracing functionality natively supports streamed outputs via `generator` functions. Below is an example.

## Aggregate Results[](#aggregate-results "Direct link to Aggregate Results")

By default, the `outputs` of the traced function are aggregated into a single array in LangSmith. If you want to customize how it is stored (for instance, concatenating the outputs into a single string), you can use the `aggregate` option (`reduce_fn` in python). This is especially useful for aggregating streamed LLM outputs.

<Note>
  Aggregating outputs **only** impacts the traced representation of the outputs. It doesn not alter the values returned by your function.
</Note>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/trace-generator-functions.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

## Aggregate Results[](#aggregate-results "Direct link to Aggregate Results")

By default, the `outputs` of the traced function are aggregated into a single array in LangSmith. If you want to customize how it is stored (for instance, concatenating the outputs into a single string), you can use the `aggregate` option (`reduce_fn` in python). This is especially useful for aggregating streamed LLM outputs.

<Note>
  Aggregating outputs **only** impacts the traced representation of the outputs. It doesn not alter the values returned by your function.
</Note>

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

---

## Learn

**URL:** llms-txt#learn

**Contents:**
- Use Cases
  - LangChain
  - LangGraph
- Conceptual Overviews
- Additional Resources

Source: https://docs.langchain.com/oss/python/learn

Tutorials, conceptual guides, and resources to help you get started.

In the **Learn** section of the documentation, you'll find a collection of tutorials, conceptual overviews, and additional resources to help you build powerful applications with LangChain and LangGraph.

Below are tutorials for common use cases, organized by framework.

[LangChain](/oss/python/langchain/overview) [agent](/oss/python/langchain/agents) implementations make it easy to get started for most use cases.

<Card title="Semantic Search" icon="magnifying-glass" href="/oss/python/langchain/knowledge-base" horizontal>
  Build a semantic search engine over a PDF with LangChain components.
</Card>

<Card title="RAG Agent" icon="user-magnifying-glass" href="/oss/python/langchain/rag" horizontal>
  Create a Retrieval Augmented Generation (RAG) agent.
</Card>

<Card title="SQL Agent" icon="database" href="/oss/python/langchain/sql-agent" horizontal>
  Build a SQL agent to interact with databases with human-in-the-loop review.
</Card>

<Card title="Supervisor Agent" icon="sitemap" href="/oss/python/langchain/supervisor" horizontal>
  Build a personal assistant that delegates to sub-agents.
</Card>

LangChain's [agent](/oss/python/langchain/agents) implementations use [LangGraph](/oss/python/langgraph/overview) primitives.
If deeper customization is required, agents can be implemented directly in LangGraph.

<Card title="Custom RAG Agent" icon="user-magnifying-glass" href="/oss/python/langgraph/agentic-rag" horizontal>
  Build a RAG agent using LangGraph primitives for fine-grained control.
</Card>

<Card title="Custom SQL Agent" icon="database" href="/oss/python/langgraph/sql-agent" horizontal>
  Implement a SQL agent directly in LangGraph for maximum flexibility.
</Card>

## Conceptual Overviews

These guides explain the core concepts and APIs underlying LangChain and LangGraph.

<Card title="Memory" icon="brain" href="/oss/python/concepts/memory" horizontal>
  Understand persistence of interactions within and across threads.
</Card>

<Card title="Context engineering" icon="book-open" href="/oss/python/concepts/context" horizontal>
  Learn methods for providing AI applications the right information and tools to accomplish a task.
</Card>

<Card title="Graph API" icon="chart-network" href="/oss/python/langgraph/graph-api" horizontal>
  Explore LangGraph’s declarative graph-building API.
</Card>

<Card title="Functional API" icon="code" href="/oss/python/langgraph/functional-api" horizontal>
  Build agents as a single function.
</Card>

## Additional Resources

<Card title="LangChain Academy" icon="graduation-cap" href="https://academy.langchain.com/" horizontal>
  Courses and exercises to level up your LangChain skills.
</Card>

<Card title="Case Studies" icon="screen-users" href="/oss/python/langgraph/case-studies" horizontal>
  See how teams are using LangChain and LangGraph in production.
</Card>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/learn.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## How to improve your evaluator with few-shot examples

**URL:** llms-txt#how-to-improve-your-evaluator-with-few-shot-examples

**Contents:**
- How few-shot examples work
- Configure your evaluator
  - 1. Configure variable mapping
  - 2. Specify the number of few-shot examples to use
- Make corrections
- View your corrections dataset

Source: https://docs.langchain.com/langsmith/create-few-shot-evaluators

Using LLM-as-a-judge evaluators can be very helpful when you can't evaluate your system programmatically. However, their effectiveness depends on their quality and how well they align with human reviewer feedback. LangSmith provides the ability to improve the alignment of LLM-as-a-judge evaluator to human preferences using few-shot examples.

Human corrections are automatically inserted into your evaluator prompt using few-shot examples. Few-shot examples is a technique inspired by [few-shot prompting](https://www.promptingguide.ai/techniques/fewshot) that guides the models output with a few high-quality examples.

This guide covers how to set up few-shot examples as part of your LLM-as-a-judge evaluator and apply corrections to feedback scores.

## How few-shot examples work

* Few-shot examples are added to your evaluator prompt using the `{{Few-shot examples}}` variable
* Creating an evaluator with few-shot examples, will automatically create a dataset for you, which will be auto-populated with few-shot examples once you start making corrections
* At runtime, these examples will inserted into the evaluator to serve as a guide for its outputs - this will help the evaluator to better align with human preferences

## Configure your evaluator

<Note>
  Few-shot examples are not currently supported in LLM-as-a-judge evaluators that use the prompt hub and are only compatible with prompts that use mustache formatting.
</Note>

Before enabling few-shot examples, set up your LLM-as-a-judge evaluator. If you haven't done this yet, follow the steps in the [LLM-as-a-judge evaluator guide](/langsmith/llm-as-judge).

### 1. Configure variable mapping

Each few-shot example is formatted according to the variable mapping specified in the configuration. The variable mapping for few-shot examples, should contain the same variables as your main prompt, plus a `few_shot_explanation` and a `score` variable which should have the same name as your feedback key.

For example, if your main prompt has variables `question` and `response`, and your evaluator outputs a `correctness` score, then your few-shot prompt should have the vartiables `question`, `response`, `few_shot_explanation`, and `correctness`.

### 2. Specify the number of few-shot examples to use

You may also specify the number of few-shot examples to use. The default is 5. If your examples are very long, you may want to set this number lower to save tokens - whereas if your examples tend to be short, you can set a higher number in order to give your evaluator more examples to learn from. If you have more examples in your dataset than this number, we will randomly choose them for you.

<Info>
  [Audit evaluator scores](/langsmith/audit-evaluator-scores)
</Info>

As you start logging traces or running experiments, you will likely disagree with some of the scores that your evaluator has given. When you [make corrections to these scores](/langsmith/audit-evaluator-scores), you will begin seeing examples populated inside your corrections dataset. As you make corrections, make sure to attach explanations - these will get populated into your evaluator prompt in place of the `few_shot_explanation` variable.

The inputs to the few-shot examples will be the relevant fields from the inputs, outputs, and reference (if this an offline evaluator) of your chain/dataset. The outputs will be the corrected evaluator score and the explanations that you created when you left the corrections. Feel free to edit these to your liking. Here is an example of a few-shot example in a corrections dataset:

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8c7bfcc6cc4ab86c18240c3cbf2ea44c" alt="Few-shot example" data-og-width="1572" width="1572" data-og-height="790" height="790" data-path="langsmith/images/few-shot-example.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=91f4e17fd853ba23c1b04934144dfa77 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=e0a5e2a026e4166c341900dd49316f35 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=88aec2ef5c37c16c67e0eefecd3fbc0a 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=bfbbd35cf503ce2f3dbf743fab8fb75b 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=bf0765bfeabc8d34ef49626dca0135ae 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-example.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f9d2cf9437ee0e160a511903bd88238a 2500w" />

Note that the corrections may take a minute or two to be populated into your few-shot dataset. Once they are there, future runs of your evaluator will include them in the prompt!

## View your corrections dataset

In order to view your corrections dataset:

* **Online evaluators**: Select your run rule and click **Edit Rule**
* **Offline evaluators**: Select your evaluator and click **Edit Evaluator**

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=03453ef08f1c272d5d9aaf71d1fb7301" alt="Edit Evaluator" data-og-width="800" width="800" data-og-height="284" height="284" data-path="langsmith/images/edit-evaluator.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=d495c791e6c8ae9d241085795d4b67b5 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b1ddde8054744862494e4d3f02a460b0 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=9838e073d1d7e61c6b79d8f35ba1a1b3 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=67322be4166f4479a466427a9b270ca1 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=4cd490404d1616498fed810b3ce75a21 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/edit-evaluator.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=4c8a87ad332661a0b8b472dd34f1f4ab 2500w" />

Head to your dataset of corrections linked in the the **Improve evaluator accuracy using few-shot examples** section. You can view and update your few-shot examples in the dataset.

<img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=3215f3f24a08186fd76c6dbad18a3cf5" alt="View few-shot dataset" data-og-width="1470" width="1470" data-og-height="478" height="478" data-path="langsmith/images/view-few-shot-ds.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=ad702a532a8f083c71056baff4370f30 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=d45ebd4263adc9c10598fad633167ca3 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=fe060c8d000a41566949ff35d6c62135 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=f735943da46a1e57328b86246f5da25f 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=9861b9651d5d63a07662e7aa1bc68491 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-few-shot-ds.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=6084c3697ffd582e30301540906a5698 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/create-few-shot-evaluators.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## This is loaded from the `.env` file you created above

**URL:** llms-txt#this-is-loaded-from-the-`.env`-file-you-created-above

SUPABASE_URL = os.environ["SUPABASE_URL"]
SUPABASE_SERVICE_KEY = os.environ["SUPABASE_SERVICE_KEY"]

@auth.authenticate
async def get_current_user(authorization: str | None):
    """Validate JWT tokens and extract user information."""
    assert authorization
    scheme, token = authorization.split()
    assert scheme.lower() == "bearer"

try:
        # Verify token with auth provider
        async with httpx.AsyncClient() as client:
            response = await client.get(
                f"{SUPABASE_URL}/auth/v1/user",
                headers={
                    "Authorization": authorization,
                    "apiKey": SUPABASE_SERVICE_KEY,
                },
            )
            assert response.status_code == 200
            user = response.json()
            return {
                "identity": user["id"],  # Unique user identifier
                "email": user["email"],
                "is_authenticated": True,
            }
    except Exception as e:
        raise Auth.exceptions.HTTPException(status_code=401, detail=str(e))

---

## Create parent run

**URL:** llms-txt#create-parent-run

parent_run_id = uuid4()
post_run(parent_run_id, "Chat Pipeline", "chain", {"question": question})

---

## Run creation, streaming, updates, etc.

**URL:** llms-txt#run-creation,-streaming,-updates,-etc.

---

## the desired output.

**URL:** llms-txt#the-desired-output.

class UserIntent(TypedDict):
    """The user's current intent in the conversation"""

intent: Literal["refund", "question_answering"]

---

## If you have a higher tiered Tavily API plan you can increase this

**URL:** llms-txt#if-you-have-a-higher-tiered-tavily-api-plan-you-can-increase-this

rate_limiter = InMemoryRateLimiter(requests_per_second=0.08)

---

## Compile the workflow

**URL:** llms-txt#compile-the-workflow

orchestrator_worker = orchestrator_worker_builder.compile()

---

## Self-host standalone servers

**URL:** llms-txt#self-host-standalone-servers

**Contents:**
- Prerequisites
- Kubernetes
- Docker
- Docker Compose

Source: https://docs.langchain.com/langsmith/deploy-standalone-server

This guide shows you how to deploy **standalone <Tooltip tip="The server that runs your LangGraph applications.">Agent Servers</Tooltip>** without the LangSmith UI or control plane. This is the most lightweight self-hosting option for running one or a few agents as independent services.

<Warning>
  This deployment option provides flexibility but requires you to manage your own infrastructure and configuration.

For production workloads, consider [self-hosting the full LangSmith platform](/langsmith/self-hosted) or [deploying with the control plane](/langsmith/deploy-with-control-plane), which offer standardized deployment patterns and UI-based management.
</Warning>

<Note>
  **This is the setup page for deploying Agent Servers directly without the LangSmith platform.**

Review the [self-hosted options](/langsmith/self-hosted) to understand:

* [Standalone Server](/langsmith/self-hosted#standalone-server): What this guide covers (no UI, just servers).
  * [LangSmith](/langsmith/self-hosted#langsmith): For the full LangSmith platform with UI.
  * [LangSmith Deployment](/langsmith/self-hosted#langsmith-deployment): For UI-based deployment management.

Before continuing, review the [standalone server overview](/langsmith/self-hosted#standalone-server).
</Note>

1. Use the [LangGraph CLI](/langsmith/cli) to [test your application locally](/langsmith/local-server).
2. Use the [LangGraph CLI](/langsmith/cli) to build a Docker image (i.e. `langgraph build`).
3. The following environment variables are needed for a data plane deployment.
4. `REDIS_URI`: Connection details to a Redis instance. Redis will be used as a pub-sub broker to enable streaming real time output from background runs. The value of `REDIS_URI` must be a valid [Redis connection URI](https://redis-py.readthedocs.io/en/stable/connections.html#redis.Redis.from_url).

<Note>
     **Shared Redis Instance**
     Multiple self-hosted deployments can share the same Redis instance. For example, for `Deployment A`, `REDIS_URI` can be set to `redis://<hostname_1>:<port>/1` and for `Deployment B`, `REDIS_URI` can be set to `redis://<hostname_1>:<port>/2`.

`1` and `2` are different database numbers within the same instance, but `<hostname_1>` is shared. **The same database number cannot be used for separate deployments**.
   </Note>
5. `DATABASE_URI`: Postgres connection details. Postgres will be used to store assistants, threads, runs, persist thread state and long term memory, and to manage the state of the background task queue with 'exactly once' semantics. The value of `DATABASE_URI` must be a valid [Postgres connection URI](https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING-URIS).

<Note>
     **Shared Postgres Instance**
     Multiple self-hosted deployments can share the same Postgres instance. For example, for `Deployment A`, `DATABASE_URI` can be set to `postgres://<user>:<password>@/<database_name_1>?host=<hostname_1>` and for `Deployment B`, `DATABASE_URI` can be set to `postgres://<user>:<password>@/<database_name_2>?host=<hostname_1>`.

`<database_name_1>` and `database_name_2` are different databases within the same instance, but `<hostname_1>` is shared. **The same database cannot be used for separate deployments**.
   </Note>
6. `LANGSMITH_API_KEY`: LangSmith API key.
7. `LANGGRAPH_CLOUD_LICENSE_KEY`: LangSmith license key. This will be used to authenticate ONCE at server start up.
8. `LANGSMITH_ENDPOINT`: To send traces to a [self-hosted LangSmith](/langsmith/self-hosted) instance, set `LANGSMITH_ENDPOINT` to the hostname of the self-hosted LangSmith instance.
9. Egress to `https://beacon.langchain.com` from your network. This is required for license verification and usage reporting if not running in air-gapped mode. See the [Egress documentation](/langsmith/self-host-egress) for more details.

Use this [Helm chart](https://github.com/langchain-ai/helm/blob/main/charts/langgraph-cloud/README.md) to deploy an Agent Server to a Kubernetes cluster.

Run the following `docker` command:

<Note>
  * You need to replace `my-image` with the name of the image you built in the prerequisite steps (from `langgraph build`)

and you should provide appropriate values for `REDIS_URI`, `DATABASE_URI`, and `LANGSMITH_API_KEY`.

* If your application requires additional environment variables, you can pass them in a similar way.
</Note>

Docker Compose YAML file:

You can run the command `docker compose up` with this Docker Compose file in the same folder.

This will launch an Agent Server on port `8123` (if you want to change this, you can change this by changing the ports in the `langgraph-api` volume). You can test if the application is healthy by running:

Assuming everything is running correctly, you should see a response like:

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/deploy-standalone-server.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Note>
  * You need to replace `my-image` with the name of the image you built in the prerequisite steps (from `langgraph build`)

  and you should provide appropriate values for `REDIS_URI`, `DATABASE_URI`, and `LANGSMITH_API_KEY`.

  * If your application requires additional environment variables, you can pass them in a similar way.
</Note>

## Docker Compose

Docker Compose YAML file:
```

Example 2 (unknown):
```unknown
You can run the command `docker compose up` with this Docker Compose file in the same folder.

This will launch an Agent Server on port `8123` (if you want to change this, you can change this by changing the ports in the `langgraph-api` volume). You can test if the application is healthy by running:
```

Example 3 (unknown):
```unknown
Assuming everything is running correctly, you should see a response like:
```

---

## Edges taken after the `action` node is called.

**URL:** llms-txt#edges-taken-after-the-`action`-node-is-called.

workflow.add_conditional_edges(
    "retrieve",
    # Assess agent decision
    grade_documents,
)
workflow.add_edge("generate_answer", END)
workflow.add_edge("rewrite_question", "generate_query_or_respond")

---

## Get customer information from the API

**URL:** llms-txt#get-customer-information-from-the-api

export LANGSMITH_URL="<your_langsmith_url>"
export response=$(curl -s $LANGSMITH_URL/api/v1/info)
export CUSTOMER_ID=$(echo "$response" | jq -r '.customer_info.customer_id') && echo "Customer ID: $CUSTOMER_ID"
export CUSTOMER_NAME=$(echo "$response" | jq -r '.customer_info.customer_name') && echo "Customer name: $CUSTOMER_NAME"

---

## How to interact with a deployment using RemoteGraph

**URL:** llms-txt#how-to-interact-with-a-deployment-using-remotegraph

**Contents:**
- Prerequisites
- Initialize the graph
  - Use a URL
  - Use a client
- Invoke the graph
  - Asynchronously
  - Synchronously
- Persist state at the thread level
- Use as a subgraph

Source: https://docs.langchain.com/langsmith/use-remote-graph

[`RemoteGraph`](https://langchain-ai.github.io/langgraph/reference/remote_graph) is a client-side interface that allows you to interact with your [deployment](/langsmith/deployments) as if it were a local graph. It provides API parity with [`CompiledGraph`](/oss/python/langgraph/graph-api#compiling-your-graph), which means that you can use the same methods (`invoke()`, `stream()`, `get_state()`, etc.) in your development and production environments. This page describes how to initialize a `RemoteGraph` and interact with it.

`RemoteGraph` is useful for the following:

* Separation of development and deployment: Build and test a graph locally with `CompiledGraph`, deploy it to LangSmith, and then [use `RemoteGraph`](#initialize-the-graph) to call it in production while working with the same API interface.
* Thread-level persistence: [Persist and fetch the state](#persist-state-at-the-thread-level) of a conversation across calls with a thread ID.
* Subgraph embedding: Compose modular graphs for a multi-agent workflow by embedding a `RemoteGraph` as a [subgraph](#use-as-a-subgraph) within another graph.
* Reusable workflows: Use deployed graphs as nodes or [tools](https://langchain-ai.github.io/langgraph/reference/remote_graph/#langgraph.pregel.remote.RemoteGraph.as_tool), so that you can reuse and expose complex logic.

<Warning>
  **Important: Avoid calling the same deployment**

`RemoteGraph` is designed to call graphs on other deployments. Do not use `RemoteGraph` to call itself or another graph on the same deployment, as this can lead to deadlocks and resource exhaustion. Instead, use local graph composition or [subgraphs](/oss/python/langgraph/use-subgraphs) for graphs within the same deployment.
</Warning>

Before getting started with `RemoteGraph`, make sure you have:

* Access to [LangSmith](/langsmith/home), where your graphs are developed and managed.
* A running [Agent Server](/langsmith/agent-server), which hosts your deployed graphs for remote interaction.

## Initialize the graph

When initializing a `RemoteGraph`, you must always specify:

* `name`: The name of the graph you want to interact with **or** an assistant ID. If you specify a graph name, the default assistant will be used. If you specify an assistant ID, that specific assistant will be used. The graph name is the same name you use in the `langgraph.json` configuration file for your deployment.
* `api_key`: A valid [LangSmith API key](/langsmith/create-account-api-key). You can set as an environment variable (`LANGSMITH_API_KEY`) or pass directly in the `api_key` argument. You can also provide the API key in the `client` / `sync_client` arguments, if `LangGraphClient` / `SyncLangGraphClient` was initialized with the `api_key` argument.

Additionally, you have to provide one of the following:

* [`url`](#use-a-url): The URL of the deployment you want to interact with. If you pass the `url` argument, both sync and async clients will be created using the provided URL, headers (if provided), and default configuration values (e.g., timeout).
* [`client`](#use-a-client): A `LangGraphClient` instance for interacting with the deployment asynchronously (e.g., using `.astream()`, `.ainvoke()`, `.aget_state()`, `.aupdate_state()`).
* `sync_client`: A `SyncLangGraphClient` instance for interacting with the deployment synchronously (e.g., using `.stream()`, `.invoke()`, `.get_state()`, `.update_state()`).

<Note>
  If you pass both `client` or `sync_client` as well as the `url` argument, they will take precedence over the `url` argument. If none of the `client` / `sync_client` / `url` arguments are provided, `RemoteGraph` will raise a `ValueError` at runtime.
</Note>

`RemoteGraph` implements the same Runnable interface as `CompiledGraph`, so you can use it in the same way as a compiled graph. It supports the full set of standard methods, including `.invoke()`, `.stream()`, `.get_state()`, and `.update_state()`, as well as their asynchronous variants.

<Note>
  To use the graph asynchronously, you must provide either the `url` or `client` when initializing the `RemoteGraph`.
</Note>

<Note>
  To use the graph synchronously, you must provide either the `url` or `sync_client` when initializing the `RemoteGraph`.
</Note>

<CodeGroup>
  
</CodeGroup>

## Persist state at the thread level

By default, graph runs (for example, calls made with `.invoke()` or `.stream()`) are stateless, which means that intermediate checkpoints and the final state are not persisted after a run.

If you want to preserve the outputs of a run—for example, to support human-in-the-loop workflows—you can create a thread and pass its ID through the `config` argument. This works the same way as with a regular compiled graph:

<Note>
  If you need to use a `checkpointer` with a graph that has a `RemoteGraph` subgraph node, make sure to use UUIDs as thread IDs.
</Note>

A graph can also call out to multiple `RemoteGraph` instances as [*subgraph*](/oss/python/langgraph/use-subgraphs) nodes. This allows for modular, scalable workflows where different responsibilities are split across separate graphs.

`RemoteGraph` exposes the same interface as a regular `CompiledGraph`, so you can use it directly as a subgraph inside another graph. For example:

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/use-remote-graph.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

### Use a client

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

## Invoke the graph

`RemoteGraph` implements the same Runnable interface as `CompiledGraph`, so you can use it in the same way as a compiled graph. It supports the full set of standard methods, including `.invoke()`, `.stream()`, `.get_state()`, and `.update_state()`, as well as their asynchronous variants.

### Asynchronously

<Note>
  To use the graph asynchronously, you must provide either the `url` or `client` when initializing the `RemoteGraph`.
</Note>

<CodeGroup>
```

---

## Method 3: Custom detector function

**URL:** llms-txt#method-3:-custom-detector-function

**Contents:**
  - To-do list
  - LLM tool selector
  - Tool retry
  - LLM tool emulator
  - Context editing
  - Shell tool
  - File search
- Provider-specific middleware
  - Anthropic

def detect_ssn(content: str) -> list[dict[str, str | int]]:
    """Detect SSN with validation.

Returns a list of dictionaries with 'text', 'start', and 'end' keys.
    """
    import re
    matches = []
    pattern = r"\d{3}-\d{2}-\d{4}"
    for match in re.finditer(pattern, content):
        ssn = match.group(0)
        # Validate: first 3 digits shouldn't be 000, 666, or 900-999
        first_three = int(ssn[:3])
        if first_three not in [0, 666] and not (900 <= first_three <= 999):
            matches.append({
                "text": ssn,
                "start": match.start(),
                "end": match.end(),
            })
    return matches

agent3 = create_agent(
    model="gpt-4o",
    tools=[...],
    middleware=[
        PIIMiddleware(
            "ssn",
            detector=detect_ssn,
            strategy="hash",
        ),
    ],
)
python  theme={null}
def detector(content: str) -> list[dict[str, str | int]]:
    return [
        {"text": "matched_text", "start": 0, "end": 12},
        # ... more matches
    ]
python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import TodoListMiddleware

agent = create_agent(
    model="gpt-4o",
    tools=[read_file, write_file, run_tests],
    middleware=[TodoListMiddleware()],
)
python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import LLMToolSelectorMiddleware

agent = create_agent(
    model="gpt-4o",
    tools=[tool1, tool2, tool3, tool4, tool5, ...],
    middleware=[
        LLMToolSelectorMiddleware(
            model="gpt-4o-mini",
            max_tools=3,
            always_include=["search"],
        ),
    ],
)
python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import ToolRetryMiddleware

agent = create_agent(
    model="gpt-4o",
    tools=[search_tool, database_tool],
    middleware=[
        ToolRetryMiddleware(
            max_retries=3,
            backoff_factor=2.0,
            initial_delay=1.0,
        ),
    ],
)
python  theme={null}
  from langchain.agents import create_agent
  from langchain.agents.middleware import ToolRetryMiddleware

agent = create_agent(
      model="gpt-4o",
      tools=[search_tool, database_tool, api_tool],
      middleware=[
          ToolRetryMiddleware(
              max_retries=3,
              backoff_factor=2.0,
              initial_delay=1.0,
              max_delay=60.0,
              jitter=True,
              tools=["api_tool"],
              retry_on=(ConnectionError, TimeoutError),
              on_failure="return_message",
          ),
      ],
  )
  python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import LLMToolEmulator

agent = create_agent(
    model="gpt-4o",
    tools=[get_weather, search_database, send_email],
    middleware=[
        LLMToolEmulator(),  # Emulate all tools
    ],
)
python  theme={null}
  from langchain.agents import create_agent
  from langchain.agents.middleware import LLMToolEmulator
  from langchain.tools import tool

@tool
  def get_weather(location: str) -> str:
      """Get the current weather for a location."""
      return f"Weather in {location}"

@tool
  def send_email(to: str, subject: str, body: str) -> str:
      """Send an email."""
      return "Email sent"

# Emulate all tools (default behavior)
  agent = create_agent(
      model="gpt-4o",
      tools=[get_weather, send_email],
      middleware=[LLMToolEmulator()],
  )

# Emulate specific tools only
  agent2 = create_agent(
      model="gpt-4o",
      tools=[get_weather, send_email],
      middleware=[LLMToolEmulator(tools=["get_weather"])],
  )

# Use custom model for emulation
  agent4 = create_agent(
      model="gpt-4o",
      tools=[get_weather, send_email],
      middleware=[LLMToolEmulator(model="anthropic:claude-sonnet-4-5-20250929")],
  )
  python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import ContextEditingMiddleware, ClearToolUsesEdit

agent = create_agent(
    model="gpt-4o",
    tools=[...],
    middleware=[
        ContextEditingMiddleware(
            edits=[
                ClearToolUsesEdit(
                    trigger=100000,
                    keep=3,
                ),
            ],
        ),
    ],
)
python  theme={null}
  from langchain.agents import create_agent
  from langchain.agents.middleware import ContextEditingMiddleware, ClearToolUsesEdit

agent = create_agent(
      model="gpt-4o",
      tools=[search_tool, calculator_tool, database_tool],
      middleware=[
          ContextEditingMiddleware(
              edits=[
                  ClearToolUsesEdit(
                      trigger=2000,
                      keep=3,
                      clear_tool_inputs=False,
                      exclude_tools=[],
                      placeholder="[cleared]",
                  ),
              ],
          ),
      ],
  )
  python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import (
    ShellToolMiddleware,
    HostExecutionPolicy,
)

agent = create_agent(
    model="gpt-4o",
    tools=[search_tool],
    middleware=[
        ShellToolMiddleware(
            workspace_root="/workspace",
            execution_policy=HostExecutionPolicy(),
        ),
    ],
)
python  theme={null}
  from langchain.agents import create_agent
  from langchain.agents.middleware import (
      ShellToolMiddleware,
      HostExecutionPolicy,
      DockerExecutionPolicy,
      RedactionRule,
  )

# Basic shell tool with host execution
  agent = create_agent(
      model="gpt-4o",
      tools=[search_tool],
      middleware=[
          ShellToolMiddleware(
              workspace_root="/workspace",
              execution_policy=HostExecutionPolicy(),
          ),
      ],
  )

# Docker isolation with startup commands
  agent_docker = create_agent(
      model="gpt-4o",
      tools=[],
      middleware=[
          ShellToolMiddleware(
              workspace_root="/workspace",
              startup_commands=["pip install requests", "export PYTHONPATH=/workspace"],
              execution_policy=DockerExecutionPolicy(
                  image="python:3.11-slim",
                  command_timeout=60.0,
              ),
          ),
      ],
  )

# With output redaction
  agent_redacted = create_agent(
      model="gpt-4o",
      tools=[],
      middleware=[
          ShellToolMiddleware(
              workspace_root="/workspace",
              redaction_rules=[
                  RedactionRule(pii_type="api_key", detector=r"sk-[a-zA-Z0-9]{32}"),
              ],
          ),
      ],
  )
  python  theme={null}
from langchain.agents import create_agent
from langchain.agents.middleware import FilesystemFileSearchMiddleware

agent = create_agent(
    model="gpt-4o",
    tools=[],
    middleware=[
        FilesystemFileSearchMiddleware(
            root_path="/workspace",
            use_ripgrep=True,
        ),
    ],
)
python  theme={null}
  from langchain.agents import create_agent
  from langchain.agents.middleware import FilesystemFileSearchMiddleware
  from langchain.messages import HumanMessage

agent = create_agent(
      model="gpt-4o",
      tools=[],
      middleware=[
          FilesystemFileSearchMiddleware(
              root_path="/workspace",
              use_ripgrep=True,
              max_file_size_mb=10,
          ),
      ],
  )

# Agent can now use glob_search and grep_search tools
  result = agent.invoke({
      "messages": [HumanMessage("Find all Python files containing 'async def'")]
  })

# The agent will use:
  # 1. glob_search(pattern="**/*.py") to find Python files
  # 2. grep_search(pattern="async def", include="*.py") to find async functions
  python  theme={null}
from langchain_anthropic import ChatAnthropic
from langchain_anthropic.middleware import AnthropicPromptCachingMiddleware
from langchain.agents import create_agent

agent = create_agent(
    model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
    system_prompt="<Your long system prompt here>",
    middleware=[AnthropicPromptCachingMiddleware(ttl="5m")],
)
python  theme={null}
  from langchain_anthropic import ChatAnthropic
  from langchain_anthropic.middleware import AnthropicPromptCachingMiddleware
  from langchain.agents import create_agent
  from langchain.messages import HumanMessage

LONG_PROMPT = """
  Please be a helpful assistant.

<Lots more context ...>
  """

agent = create_agent(
      model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
      system_prompt=LONG_PROMPT,
      middleware=[AnthropicPromptCachingMiddleware(ttl="5m")],
  )

# First invocation: Creates cache with system prompt, tools, and "Hi, my name is Bob"
  agent.invoke({"messages": [HumanMessage("Hi, my name is Bob")]})

# Second invocation: Reuses cached system prompt, tools, and previous messages
  # Only processes the new message "What's my name?" and the previous AI response
  agent.invoke({"messages": [HumanMessage("What's my name?")]})
  python  theme={null}
from langchain_anthropic import ChatAnthropic
from langchain_anthropic.middleware import ClaudeBashToolMiddleware
from langchain.agents import create_agent

agent = create_agent(
    model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
    tools=[],
    middleware=[
        ClaudeBashToolMiddleware(
            workspace_root="/workspace",
        ),
    ],
)
python  theme={null}
  from langchain_anthropic import ChatAnthropic
  from langchain_anthropic.middleware import ClaudeBashToolMiddleware
  from langchain.agents import create_agent
  from langchain.agents.middleware import DockerExecutionPolicy

agent = create_agent(
      model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
      tools=[],
      middleware=[
          ClaudeBashToolMiddleware(
              workspace_root="/workspace",
              startup_commands=["pip install requests"],
              execution_policy=DockerExecutionPolicy(
                  image="python:3.11-slim",
              ),
          ),
      ],
  )

# Claude can now use its native bash tool
  result = agent.invoke({
      "messages": [{"role": "user", "content": "List files in the workspace"}]
  })
  python  theme={null}
from langchain_anthropic import ChatAnthropic
from langchain_anthropic.middleware import StateClaudeTextEditorMiddleware
from langchain.agents import create_agent

**Examples:**

Example 1 (unknown):
```unknown
**Custom detector function signature:**

The detector function must accept a string (content) and return matches:

Returns a list of dictionaries with `text`, `start`, and `end` keys:
```

Example 2 (unknown):
```unknown
<Tip>
  For custom detectors:

  * Use regex strings for simple patterns
  * Use RegExp objects when you need flags (e.g., case-insensitive matching)
  * Use custom functions when you need validation logic beyond pattern matching
  * Custom functions give you full control over detection logic and can implement complex validation rules
</Tip>

<Accordion title="Configuration options">
  <ParamField body="pii_type" type="string" required>
    Type of PII to detect. Can be a built-in type (`email`, `credit_card`, `ip`, `mac_address`, `url`) or a custom type name.
  </ParamField>

  <ParamField body="strategy" type="string" default="redact">
    How to handle detected PII. Options:

    * `'block'` - Raise exception when detected
    * `'redact'` - Replace with `[REDACTED_TYPE]`
    * `'mask'` - Partially mask (e.g., `****-****-****-1234`)
    * `'hash'` - Replace with deterministic hash
  </ParamField>

  <ParamField body="detector" type="function | regex">
    Custom detector function or regex pattern. If not provided, uses built-in detector for the PII type.
  </ParamField>

  <ParamField body="apply_to_input" type="boolean" default="True">
    Check user messages before model call
  </ParamField>

  <ParamField body="apply_to_output" type="boolean" default="False">
    Check AI messages after model call
  </ParamField>

  <ParamField body="apply_to_tool_results" type="boolean" default="False">
    Check tool result messages after execution
  </ParamField>
</Accordion>

### To-do list

Equip agents with task planning and tracking capabilities for complex multi-step tasks. To-do lists are useful for the following:

* Complex multi-step tasks requiring coordination across multiple tools.
* Long-running operations where progress visibility is important.

<Note>
  This middleware automatically provides agents with a `write_todos` tool and system prompts to guide effective task planning.
</Note>

**API reference:** [`TodoListMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.TodoListMiddleware)
```

Example 3 (unknown):
```unknown
<Accordion title="Configuration options">
  <ParamField body="system_prompt" type="string">
    Custom system prompt for guiding todo usage. Uses built-in prompt if not specified.
  </ParamField>

  <ParamField body="tool_description" type="string">
    Custom description for the `write_todos` tool. Uses built-in description if not specified.
  </ParamField>
</Accordion>

### LLM tool selector

Use an LLM to intelligently select relevant tools before calling the main model. LLM tool selectors are useful for the following:

* Agents with many tools (10+) where most aren't relevant per query.
* Reducing token usage by filtering irrelevant tools.
* Improving model focus and accuracy.

This middleware uses structured output to ask an LLM which tools are most relevant for the current query. The structured output schema defines the available tool names and descriptions. Model providers often add this structured output information to the system prompt behind the scenes.

**API reference:** [`LLMToolSelectorMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.LLMToolSelectorMiddleware)
```

Example 4 (unknown):
```unknown
<Accordion title="Configuration options">
  <ParamField body="model" type="string | BaseChatModel">
    Model for tool selection. Can be a model identifier string (e.g., `'openai:gpt-4o-mini'`) or a `BaseChatModel` instance. See [`init_chat_model`](https://reference.langchain.com/python/langchain/models/#langchain.chat_models.init_chat_model\(model\)) for more information.

    Defaults to the agent's main model.
  </ParamField>

  <ParamField body="system_prompt" type="string">
    Instructions for the selection model. Uses built-in prompt if not specified.
  </ParamField>

  <ParamField body="max_tools" type="number">
    Maximum number of tools to select. If the model selects more, only the first max\_tools will be used. No limit if not specified.
  </ParamField>

  <ParamField body="always_include" type="list[string]">
    Tool names to always include regardless of selection. These do not count against the max\_tools limit.
  </ParamField>
</Accordion>

### Tool retry

Automatically retry failed tool calls with configurable exponential backoff. Tool retry is useful for the following:

* Handling transient failures in external API calls.
* Improving reliability of network-dependent tools.
* Building resilient agents that gracefully handle temporary errors.

**API reference:** [`ToolRetryMiddleware`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.ToolRetryMiddleware)
```

---

## Configure LangSmith OpenTelemetry export (no OTEL env vars or headers needed)

**URL:** llms-txt#configure-langsmith-opentelemetry-export-(no-otel-env-vars-or-headers-needed)

**Contents:**
- Advanced configuration
  - Use OpenTelemetry Collector for fan-out
  - Distributed tracing with LangChain and OpenTelemetry

configure(project_name="adk-otel-demo")

async def main():
    agent = LlmAgent(
        name="travel_assistant",
        model="gemini-2.5-flash-lite",
        instruction="You are a helpful travel assistant.",
    )

session_service = InMemorySessionService()
    runner = Runner(app_name="travel_app", agent=agent, session_service=session_service)

user_id = "user_123"
    session_id = "session_abc"
    await session_service.create_session(app_name="travel_app", user_id=user_id, session_id=session_id)

new_message = types.Content(parts=[types.Part(text="Hi! Recommend a weekend trip to Paris.")], role="user")

for event in runner.run(user_id=user_id, session_id=session_id, new_message=new_message):
        print(event)

if __name__ == "__main__":
    asyncio.run(main())
yaml  theme={null}
   receivers:
     otlp:
       protocols:
         grpc:
           endpoint: 0.0.0.0:4317
         http:
           endpoint: 0.0.0.0:4318

processors:
     batch:

exporters:
     otlphttp/langsmith:
       endpoint: https://api.smith.langchain.com/otel/v1/traces
       headers:
         x-api-key: ${env:LANGSMITH_API_KEY}
         Langsmith-Project: my_project
     otlphttp/other_provider:
       endpoint: https://otel.your-provider.com/v1/traces
       headers:
         api-key: ${env:OTHER_PROVIDER_API_KEY}

service:
     pipelines:
       traces:
         receivers: [otlp]
         processors: [batch]
         exporters: [otlphttp/langsmith, otlphttp/other_provider]
   python  theme={null}
   import os
   from opentelemetry import trace
   from opentelemetry.sdk.trace import TracerProvider
   from opentelemetry.sdk.trace.export import BatchSpanProcessor
   from opentelemetry.exporter.otlp.proto.http.trace_exporter import OTLPSpanExporter
   from langchain_openai import ChatOpenAI
   from langchain_core.prompts import ChatPromptTemplate

# Point to your local OpenTelemetry Collector
   otlp_exporter = OTLPSpanExporter(
       endpoint="http://localhost:4318/v1/traces"
   )
   provider = TracerProvider()
   processor = BatchSpanProcessor(otlp_exporter)
   provider.add_span_processor(processor)
   trace.set_tracer_provider(provider)

# Set environment variables for LangChain
   os.environ["LANGSMITH_OTEL_ENABLED"] = "true"
   os.environ["LANGSMITH_TRACING"] = "true"

# Create and run a LangChain application
   prompt = ChatPromptTemplate.from_template("Tell me a joke about {topic}")
   model = ChatOpenAI()
   chain = prompt | model
   result = chain.invoke({"topic": "programming"})
   print(result.content)
   python  theme={null}
import os
from opentelemetry import trace
from opentelemetry.propagate import inject, extract
from opentelemetry.sdk.trace import TracerProvider
from opentelemetry.sdk.trace.export import BatchSpanProcessor
from opentelemetry.exporter.otlp.proto.http.trace_exporter import OTLPSpanExporter
import requests
from langchain_openai import ChatOpenAI
from langchain_core.prompts import ChatPromptTemplate

**Examples:**

Example 1 (unknown):
```unknown
<Note>
  You do not need to set OTEL environment variables or exporters. `configure()` wires them for LangSmith automatically; instrumentors (like `GoogleADKInstrumentor`) create the spans.
</Note>

5. View the trace in your LangSmith dashboard ([example](https://smith.langchain.com/public/106f5bed-edca-4357-91a5-80089252c9ed/r)).

## Advanced configuration

### Use OpenTelemetry Collector for fan-out

For more advanced scenarios, you can use the OpenTelemetry Collector to fan out your telemetry data to multiple destinations. This is a more scalable approach than configuring multiple exporters in your application code.

1. [Install the OpenTelemetry Collector](https://opentelemetry.io/docs/collector/getting-started/) for your environment.

2. Create a configuration file (e.g., `otel-collector-config.yaml`) that exports to multiple destinations:
```

Example 2 (unknown):
```unknown
3. Configure your application to send to the collector:
```

Example 3 (unknown):
```unknown
This approach offers several advantages:

* Centralized configuration for all your telemetry destinations
* Reduced overhead in your application code
* Better scalability and resilience
* Ability to add or remove destinations without changing application code

### Distributed tracing with LangChain and OpenTelemetry

Distributed tracing is essential when your LLM application spans multiple services or processes. OpenTelemetry's context propagation capabilities ensure that traces remain connected across service boundaries.

#### Context propagation in distributed tracing

In distributed systems, context propagation passes trace metadata between services so that related spans are linked to the same trace:

* **Trace ID**: A unique identifier for the entire trace
* **Span ID**: A unique identifier for the current span
* **Sampling Decision**: Indicates whether this trace should be sampled

#### Set up distributed tracing with LangChain

To enable distributed tracing across multiple services:
```

---

## For large datasets, lazily load documents

**URL:** llms-txt#for-large-datasets,-lazily-load-documents

**Contents:**
- By category
  - Webpages
  - PDFs
  - Cloud Providers
  - Social Platforms
  - Messaging Services
  - Productivity tools
  - Common File Types
- All document loaders

for document in loader.lazy_load():
    print(document)
```

The below document loaders allow you to load webpages.

| Document Loader                                                             | Description                                                                                                          | Package/API |
| --------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------- | ----------- |
| [Web](/oss/python/integrations/document_loaders/web_base)                   | Uses urllib and BeautifulSoup to load and parse HTML web pages                                                       | Package     |
| [Unstructured](/oss/python/integrations/document_loaders/unstructured_file) | Uses Unstructured to load and parse web pages                                                                        | Package     |
| [RecursiveURL](/oss/python/integrations/document_loaders/recursive_url)     | Recursively scrapes all child links from a root URL                                                                  | Package     |
| [Sitemap](/oss/python/integrations/document_loaders/sitemap)                | Scrapes all pages on a given sitemap                                                                                 | Package     |
| [Spider](/oss/python/integrations/document_loaders/spider)                  | Crawler and scraper that returns LLM-ready data                                                                      | API         |
| [Firecrawl](/oss/python/integrations/document_loaders/firecrawl)            | API service that can be deployed locally                                                                             | API         |
| [Docling](/oss/python/integrations/document_loaders/docling)                | Uses Docling to load and parse web pages                                                                             | Package     |
| [Hyperbrowser](/oss/python/integrations/document_loaders/hyperbrowser)      | Platform for running and scaling headless browsers, can be used to scrape/crawl any site                             | API         |
| [AgentQL](/oss/python/integrations/document_loaders/agentql)                | Web interaction and structured data extraction from any web page using an AgentQL query or a Natural Language prompt | API         |

The below document loaders allow you to load PDF documents.

| Document Loader                                                                    | Description                                          | Package/API |
| ---------------------------------------------------------------------------------- | ---------------------------------------------------- | ----------- |
| [PyPDF](/oss/python/integrations/document_loaders/pypdfloader)                     | Uses `pypdf` to load and parse PDFs                  | Package     |
| [Unstructured](/oss/python/integrations/document_loaders/unstructured_file)        | Uses Unstructured's open source library to load PDFs | Package     |
| [Amazon Textract](/oss/python/integrations/document_loaders/amazon_textract)       | Uses AWS API to load PDFs                            | API         |
| [MathPix](/oss/python/integrations/document_loaders/mathpix)                       | Uses MathPix to load PDFs                            | Package     |
| [PDFPlumber](/oss/python/integrations/document_loaders/pdfplumber)                 | Load PDF files using PDFPlumber                      | Package     |
| [PyPDFDirectry](/oss/python/integrations/document_loaders/pypdfdirectory)          | Load a directory with PDF files                      | Package     |
| [PyPDFium2](/oss/python/integrations/document_loaders/pypdfium2)                   | Load PDF files using PyPDFium2                       | Package     |
| [PyMuPDF](/oss/python/integrations/document_loaders/pymupdf)                       | Load PDF files using PyMuPDF                         | Package     |
| [PyMuPDF4LLM](/oss/python/integrations/document_loaders/pymupdf4llm)               | Load PDF content to Markdown using PyMuPDF4LLM       | Package     |
| [PDFMiner](/oss/python/integrations/document_loaders/pdfminer)                     | Load PDF files using PDFMiner                        | Package     |
| [Upstage Document Parse Loader](/oss/python/integrations/document_loaders/upstage) | Load PDF files using UpstageDocumentParseLoader      | Package     |
| [Docling](/oss/python/integrations/document_loaders/docling)                       | Load PDF files using Docling                         | Package     |
| [UnDatasIO](/oss/python/integrations/document_loaders/undatasio)                   | Load PDF files using UnDatasIO                       | Package     |
| [OpenDataLoader PDF](/oss/python/integrations/document_loaders/opendataloader_pdf) | Load PDF files using OpenDataLoader PDF              | Package     |

The below document loaders allow you to load documents from your favorite cloud providers.

| Document Loader                                                                                            | Description                                                 | Partner Package | API reference                                                                                                                                                                                  |
| ---------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------- | --------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [AWS S3 Directory](/oss/python/integrations/document_loaders/aws_s3_directory)                             | Load documents from an AWS S3 directory                     | ❌               | [`S3DirectoryLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.s3_directory.S3DirectoryLoader.html)                          |
| [AWS S3 File](/oss/python/integrations/document_loaders/aws_s3_file)                                       | Load documents from an AWS S3 file                          | ❌               | [`S3FileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.s3_file.S3FileLoader.html)                                         |
| [Azure AI Data](/oss/python/integrations/document_loaders/azure_ai_data)                                   | Load documents from Azure AI services                       | ❌               | [`AzureAIDataLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.azure_ai_data.AzureAIDataLoader.html)                         |
| [Azure Blob Storage](/oss/python/integrations/document_loaders/azure_blob_storage)                         | Load documents from Azure Blob Storage                      | ✅               | [`AzureBlobStorageLoader`](https://reference.langchain.com/python/integrations/langchain_azure/storage/)                                                                                       |
| [Dropbox](/oss/python/integrations/document_loaders/dropbox)                                               | Load documents from Dropbox                                 | ❌               | [`DropboxLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.dropbox.DropboxLoader.html)                                       |
| [Google Cloud Storage Directory](/oss/python/integrations/document_loaders/google_cloud_storage_directory) | Load documents from GCS bucket                              | ✅               | [`GCSDirectoryLoader`](https://python.langchain.com/api_reference/google_community/gcs_directory/langchain_google_community.gcs_directory.GCSDirectoryLoader.html)                             |
| [Google Cloud Storage File](/oss/python/integrations/document_loaders/google_cloud_storage_file)           | Load documents from GCS file object                         | ✅               | [`GCSFileLoader`](https://python.langchain.com/api_reference/google_community/gcs_file/langchain_google_community.gcs_file.GCSFileLoader.html)                                                 |
| [Google Drive](/oss/python/integrations/document_loaders/google_drive)                                     | Load documents from Google Drive (Google Docs only)         | ✅               | [`GoogleDriveLoader`](https://python.langchain.com/api_reference/google_community/drive/langchain_google_community.drive.GoogleDriveLoader.html)                                               |
| [Huawei OBS Directory](/oss/python/integrations/document_loaders/huawei_obs_directory)                     | Load documents from Huawei Object Storage Service Directory | ❌               | [`OBSDirectoryLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.obs_directory.OBSDirectoryLoader.html)                       |
| [Huawei OBS File](/oss/python/integrations/document_loaders/huawei_obs_file)                               | Load documents from Huawei Object Storage Service File      | ❌               | [`OBSFileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.obs_file.OBSFileLoader.html)                                      |
| [Microsoft OneDrive](/oss/python/integrations/document_loaders/microsoft_onedrive)                         | Load documents from Microsoft OneDrive                      | ❌               | [`OneDriveLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.onedrive.OneDriveLoader.html)                                    |
| [Microsoft SharePoint](/oss/python/integrations/document_loaders/microsoft_sharepoint)                     | Load documents from Microsoft SharePoint                    | ❌               | [`SharePointLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.sharepoint.SharePointLoader.html)                              |
| [Tencent COS Directory](/oss/python/integrations/document_loaders/tencent_cos_directory)                   | Load documents from Tencent Cloud Object Storage Directory  | ❌               | [`TencentCOSDirectoryLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.tencent_cos_directory.TencentCOSDirectoryLoader.html) |
| [Tencent COS File](/oss/python/integrations/document_loaders/tencent_cos_file)                             | Load documents from Tencent Cloud Object Storage File       | ❌               | [`TencentCOSFileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.tencent_cos_file.TencentCOSFileLoader.html)                |

The below document loaders allow you to load documents from different social media platforms.

| Document Loader                                              | API reference                                                                                                                                                      |
| ------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Twitter](/oss/python/integrations/document_loaders/twitter) | [`TwitterTweetLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.twitter.TwitterTweetLoader.html) |
| [Reddit](/oss/python/integrations/document_loaders/reddit)   | [`RedditPostsLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.reddit.RedditPostsLoader.html)    |

### Messaging Services

The below document loaders allow you to load data from different messaging platforms.

| Document Loader                                                          | API reference                                                                                                                                                               |
| ------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Telegram](/oss/python/integrations/document_loaders/telegram)           | [`TelegramChatFileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.telegram.TelegramChatFileLoader.html) |
| [WhatsApp](/oss/python/integrations/document_loaders/whatsapp_chat)      | [`WhatsAppChatLoader`](https://python.langchain.com/api_reference/community/chat_loaders/langchain_community.chat_loaders.whatsapp.WhatsAppChatLoader.html)                 |
| [Discord](/oss/python/integrations/document_loaders/discord)             | [`DiscordChatLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.discord.DiscordChatLoader.html)            |
| [Facebook Chat](/oss/python/integrations/document_loaders/facebook_chat) | [`FacebookChatLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.facebook_chat.FacebookChatLoader.html)    |
| [Mastodon](/oss/python/integrations/document_loaders/mastodon)           | [`MastodonTootsLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.mastodon.MastodonTootsLoader.html)       |

### Productivity tools

The below document loaders allow you to load data from commonly used productivity tools.

| Document Loader                                            | API reference                                                                                                                                                                  |
| ---------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Figma](/oss/python/integrations/document_loaders/figma)   | [`FigmaFileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.figma.FigmaFileLoader.html)                     |
| [Notion](/oss/python/integrations/document_loaders/notion) | [`NotionDirectoryLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.notion.NotionDirectoryLoader.html)        |
| [Slack](/oss/python/integrations/document_loaders/slack)   | [`SlackDirectoryLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.slack_directory.SlackDirectoryLoader.html) |
| [Quip](/oss/python/integrations/document_loaders/quip)     | [`QuipLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.quip.QuipLoader.html)                                |
| [Trello](/oss/python/integrations/document_loaders/trello) | [`TrelloLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.trello.TrelloLoader.html)                          |
| [Roam](/oss/python/integrations/document_loaders/roam)     | [`RoamLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.roam.RoamLoader.html)                                |
| [GitHub](/oss/python/integrations/document_loaders/github) | [`GithubFileLoader`](https://python.langchain.com/api_reference/community/document_loaders/langchain_community.document_loaders.github.GithubFileLoader.html)                  |

### Common File Types

The below document loaders allow you to load data from common data formats.

| Document Loader                                                                                | Data Type                                                                                                                                                                    |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [CSVLoader](/oss/python/integrations/document_loaders/csv)                                     | CSV files                                                                                                                                                                    |
| [Unstructured](/oss/python/integrations/document_loaders/unstructured_file)                    | Many file types (see [https://docs.unstructured.io/platform/supported-file-types](https://docs.unstructured.io/platform/supported-file-types))                               |
| [JSONLoader](/oss/python/integrations/document_loaders/json)                                   | JSON files                                                                                                                                                                   |
| [BSHTMLLoader](/oss/python/integrations/document_loaders/bshtml)                               | HTML files                                                                                                                                                                   |
| [DoclingLoader](/oss/python/integrations/document_loaders/docling)                             | Various file types (see [https://ds4sd.github.io/docling/](https://ds4sd.github.io/docling/))                                                                                |
| [PolarisAIDataInsightLoader](/oss/python/integrations/document_loaders/polaris_ai_datainsight) | Various file types (see [https://datainsight.polarisoffice.com/documentation?docType=doc\_extract](https://datainsight.polarisoffice.com/documentation?docType=doc_extract)) |

## All document loaders

<Columns cols={3}>
  <Card title="acreom" icon="link" href="/oss/python/integrations/document_loaders/acreom" arrow="true" cta="View guide" />

<Card title="AgentQLLoader" icon="link" href="/oss/python/integrations/document_loaders/agentql" arrow="true" cta="View guide" />

<Card title="AirbyteLoader" icon="link" href="/oss/python/integrations/document_loaders/airbyte" arrow="true" cta="View guide" />

<Card title="Airtable" icon="link" href="/oss/python/integrations/document_loaders/airtable" arrow="true" cta="View guide" />

<Card title="Alibaba Cloud MaxCompute" icon="link" href="/oss/python/integrations/document_loaders/alibaba_cloud_maxcompute" arrow="true" cta="View guide" />

<Card title="Amazon Textract" icon="link" href="/oss/python/integrations/document_loaders/amazon_textract" arrow="true" cta="View guide" />

<Card title="Apify Dataset" icon="link" href="/oss/python/integrations/document_loaders/apify_dataset" arrow="true" cta="View guide" />

<Card title="ArxivLoader" icon="link" href="/oss/python/integrations/document_loaders/arxiv" arrow="true" cta="View guide" />

<Card title="AssemblyAI Audio Transcripts" icon="link" href="/oss/python/integrations/document_loaders/assemblyai" arrow="true" cta="View guide" />

<Card title="AstraDB" icon="link" href="/oss/python/integrations/document_loaders/astradb" arrow="true" cta="View guide" />

<Card title="Async Chromium" icon="link" href="/oss/python/integrations/document_loaders/async_chromium" arrow="true" cta="View guide" />

<Card title="AsyncHtml" icon="link" href="/oss/python/integrations/document_loaders/async_html" arrow="true" cta="View guide" />

<Card title="Athena" icon="link" href="/oss/python/integrations/document_loaders/athena" arrow="true" cta="View guide" />

<Card title="AWS S3 Directory" icon="link" href="/oss/python/integrations/document_loaders/aws_s3_directory" arrow="true" cta="View guide" />

<Card title="AWS S3 File" icon="link" href="/oss/python/integrations/document_loaders/aws_s3_file" arrow="true" cta="View guide" />

<Card title="AZLyrics" icon="link" href="/oss/python/integrations/document_loaders/azlyrics" arrow="true" cta="View guide" />

<Card title="Azure AI Data" icon="link" href="/oss/python/integrations/document_loaders/azure_ai_data" arrow="true" cta="View guide" />

<Card title="Azure Blob Storage" icon="link" href="/oss/python/integrations/document_loaders/azure_blob_storage" arrow="true" cta="View guide" />

<Card title="Azure AI Document Intelligence" icon="link" href="/oss/python/integrations/document_loaders/azure_document_intelligence" arrow="true" cta="View guide" />

<Card title="BibTeX" icon="link" href="/oss/python/integrations/document_loaders/bibtex" arrow="true" cta="View guide" />

<Card title="BiliBili" icon="link" href="/oss/python/integrations/document_loaders/bilibili" arrow="true" cta="View guide" />

<Card title="Blackboard" icon="link" href="/oss/python/integrations/document_loaders/blackboard" arrow="true" cta="View guide" />

<Card title="Blockchain" icon="link" href="/oss/python/integrations/document_loaders/blockchain" arrow="true" cta="View guide" />

<Card title="Box" icon="link" href="/oss/python/integrations/document_loaders/box" arrow="true" cta="View guide" />

<Card title="Brave Search" icon="link" href="/oss/python/integrations/document_loaders/brave_search" arrow="true" cta="View guide" />

<Card title="Browserbase" icon="link" href="/oss/python/integrations/document_loaders/browserbase" arrow="true" cta="View guide" />

<Card title="Browserless" icon="link" href="/oss/python/integrations/document_loaders/browserless" arrow="true" cta="View guide" />

<Card title="BSHTMLLoader" icon="link" href="/oss/python/integrations/document_loaders/bshtml" arrow="true" cta="View guide" />

<Card title="Cassandra" icon="link" href="/oss/python/integrations/document_loaders/cassandra" arrow="true" cta="View guide" />

<Card title="ChatGPT Data" icon="link" href="/oss/python/integrations/document_loaders/chatgpt_loader" arrow="true" cta="View guide" />

<Card title="College Confidential" icon="link" href="/oss/python/integrations/document_loaders/college_confidential" arrow="true" cta="View guide" />

<Card title="Concurrent Loader" icon="link" href="/oss/python/integrations/document_loaders/concurrent" arrow="true" cta="View guide" />

<Card title="Confluence" icon="link" href="/oss/python/integrations/document_loaders/confluence" arrow="true" cta="View guide" />

<Card title="CoNLL-U" icon="link" href="/oss/python/integrations/document_loaders/conll-u" arrow="true" cta="View guide" />

<Card title="Copy Paste" icon="link" href="/oss/python/integrations/document_loaders/copypaste" arrow="true" cta="View guide" />

<Card title="Couchbase" icon="link" href="/oss/python/integrations/document_loaders/couchbase" arrow="true" cta="View guide" />

<Card title="CSV" icon="link" href="/oss/python/integrations/document_loaders/csv" arrow="true" cta="View guide" />

<Card title="Cube Semantic Layer" icon="link" href="/oss/python/integrations/document_loaders/cube_semantic" arrow="true" cta="View guide" />

<Card title="Datadog Logs" icon="link" href="/oss/python/integrations/document_loaders/datadog_logs" arrow="true" cta="View guide" />

<Card title="Dedoc" icon="link" href="/oss/python/integrations/document_loaders/dedoc" arrow="true" cta="View guide" />

<Card title="Diffbot" icon="link" href="/oss/python/integrations/document_loaders/diffbot" arrow="true" cta="View guide" />

<Card title="Discord" icon="link" href="/oss/python/integrations/document_loaders/discord" arrow="true" cta="View guide" />

<Card title="Docling" icon="link" href="/oss/python/integrations/document_loaders/docling" arrow="true" cta="View guide" />

<Card title="Docugami" icon="link" href="/oss/python/integrations/document_loaders/docugami" arrow="true" cta="View guide" />

<Card title="Docusaurus" icon="link" href="/oss/python/integrations/document_loaders/docusaurus" arrow="true" cta="View guide" />

<Card title="Dropbox" icon="link" href="/oss/python/integrations/document_loaders/dropbox" arrow="true" cta="View guide" />

<Card title="Email" icon="link" href="/oss/python/integrations/document_loaders/email" arrow="true" cta="View guide" />

<Card title="EPub" icon="link" href="/oss/python/integrations/document_loaders/epub" arrow="true" cta="View guide" />

<Card title="Etherscan" icon="link" href="/oss/python/integrations/document_loaders/etherscan" arrow="true" cta="View guide" />

<Card title="EverNote" icon="link" href="/oss/python/integrations/document_loaders/evernote" arrow="true" cta="View guide" />

<Card title="Facebook Chat" icon="link" href="/oss/python/integrations/document_loaders/facebook_chat" arrow="true" cta="View guide" />

<Card title="Fauna" icon="link" href="/oss/python/integrations/document_loaders/fauna" arrow="true" cta="View guide" />

<Card title="Figma" icon="link" href="/oss/python/integrations/document_loaders/figma" arrow="true" cta="View guide" />

<Card title="FireCrawl" icon="link" href="/oss/python/integrations/document_loaders/firecrawl" arrow="true" cta="View guide" />

<Card title="Geopandas" icon="link" href="/oss/python/integrations/document_loaders/geopandas" arrow="true" cta="View guide" />

<Card title="Git" icon="link" href="/oss/python/integrations/document_loaders/git" arrow="true" cta="View guide" />

<Card title="GitBook" icon="link" href="/oss/python/integrations/document_loaders/gitbook" arrow="true" cta="View guide" />

<Card title="GitHub" icon="link" href="/oss/python/integrations/document_loaders/github" arrow="true" cta="View guide" />

<Card title="Glue Catalog" icon="link" href="/oss/python/integrations/document_loaders/glue_catalog" arrow="true" cta="View guide" />

<Card title="Google AlloyDB for PostgreSQL" icon="link" href="/oss/python/integrations/document_loaders/google_alloydb" arrow="true" cta="View guide" />

<Card title="Google BigQuery" icon="link" href="/oss/python/integrations/document_loaders/google_bigquery" arrow="true" cta="View guide" />

<Card title="Google Bigtable" icon="link" href="/oss/python/integrations/document_loaders/google_bigtable" arrow="true" cta="View guide" />

<Card title="Google Cloud SQL for SQL Server" icon="link" href="/oss/python/integrations/document_loaders/google_cloud_sql_mssql" arrow="true" cta="View guide" />

<Card title="Google Cloud SQL for MySQL" icon="link" href="/oss/python/integrations/document_loaders/google_cloud_sql_mysql" arrow="true" cta="View guide" />

<Card title="Google Cloud SQL for PostgreSQL" icon="link" href="/oss/python/integrations/document_loaders/google_cloud_sql_pg" arrow="true" cta="View guide" />

<Card title="Google Cloud Storage Directory" icon="link" href="/oss/python/integrations/document_loaders/google_cloud_storage_directory" arrow="true" cta="View guide" />

<Card title="Google Cloud Storage File" icon="link" href="/oss/python/integrations/document_loaders/google_cloud_storage_file" arrow="true" cta="View guide" />

<Card title="Google Firestore in Datastore Mode" icon="link" href="/oss/python/integrations/document_loaders/google_datastore" arrow="true" cta="View guide" />

<Card title="Google Drive" icon="link" href="/oss/python/integrations/document_loaders/google_drive" arrow="true" cta="View guide" />

<Card title="Google El Carro for Oracle Workloads" icon="link" href="/oss/python/integrations/document_loaders/google_el_carro" arrow="true" cta="View guide" />

<Card title="Google Firestore (Native Mode)" icon="link" href="/oss/python/integrations/document_loaders/google_firestore" arrow="true" cta="View guide" />

<Card title="Google Memorystore for Redis" icon="link" href="/oss/python/integrations/document_loaders/google_memorystore_redis" arrow="true" cta="View guide" />

<Card title="Google Spanner" icon="link" href="/oss/python/integrations/document_loaders/google_spanner" arrow="true" cta="View guide" />

<Card title="Google Speech-to-Text" icon="link" href="/oss/python/integrations/document_loaders/google_speech_to_text" arrow="true" cta="View guide" />

<Card title="Grobid" icon="link" href="/oss/python/integrations/document_loaders/grobid" arrow="true" cta="View guide" />

<Card title="Gutenberg" icon="link" href="/oss/python/integrations/document_loaders/gutenberg" arrow="true" cta="View guide" />

<Card title="Hacker News" icon="link" href="/oss/python/integrations/document_loaders/hacker_news" arrow="true" cta="View guide" />

<Card title="Huawei OBS Directory" icon="link" href="/oss/python/integrations/document_loaders/huawei_obs_directory" arrow="true" cta="View guide" />

<Card title="Huawei OBS File" icon="link" href="/oss/python/integrations/document_loaders/huawei_obs_file" arrow="true" cta="View guide" />

<Card title="HuggingFace Dataset" icon="link" href="/oss/python/integrations/document_loaders/hugging_face_dataset" arrow="true" cta="View guide" />

<Card title="HyperbrowserLoader" icon="link" href="/oss/python/integrations/document_loaders/hyperbrowser" arrow="true" cta="View guide" />

<Card title="iFixit" icon="link" href="/oss/python/integrations/document_loaders/ifixit" arrow="true" cta="View guide" />

<Card title="Images" icon="link" href="/oss/python/integrations/document_loaders/image" arrow="true" cta="View guide" />

<Card title="Image Captions" icon="link" href="/oss/python/integrations/document_loaders/image_captions" arrow="true" cta="View guide" />

<Card title="IMSDb" icon="link" href="/oss/python/integrations/document_loaders/imsdb" arrow="true" cta="View guide" />

<Card title="Iugu" icon="link" href="/oss/python/integrations/document_loaders/iugu" arrow="true" cta="View guide" />

<Card title="Joplin" icon="link" href="/oss/python/integrations/document_loaders/joplin" arrow="true" cta="View guide" />

<Card title="JSONLoader" icon="link" href="/oss/python/integrations/document_loaders/json" arrow="true" cta="View guide" />

<Card title="Jupyter Notebook" icon="link" href="/oss/python/integrations/document_loaders/jupyter_notebook" arrow="true" cta="View guide" />

<Card title="Kinetica" icon="link" href="/oss/python/integrations/document_loaders/kinetica" arrow="true" cta="View guide" />

<Card title="lakeFS" icon="link" href="/oss/python/integrations/document_loaders/lakefs" arrow="true" cta="View guide" />

<Card title="LangSmith" icon="link" href="/oss/python/integrations/document_loaders/langsmith" arrow="true" cta="View guide" />

<Card title="LarkSuite (FeiShu)" icon="link" href="/oss/python/integrations/document_loaders/larksuite" arrow="true" cta="View guide" />

<Card title="LLM Sherpa" icon="link" href="/oss/python/integrations/document_loaders/llmsherpa" arrow="true" cta="View guide" />

<Card title="Mastodon" icon="link" href="/oss/python/integrations/document_loaders/mastodon" arrow="true" cta="View guide" />

<Card title="MathPixPDFLoader" icon="link" href="/oss/python/integrations/document_loaders/mathpix" arrow="true" cta="View guide" />

<Card title="MediaWiki Dump" icon="link" href="/oss/python/integrations/document_loaders/mediawikidump" arrow="true" cta="View guide" />

<Card title="Merge Documents Loader" icon="link" href="/oss/python/integrations/document_loaders/merge_doc" arrow="true" cta="View guide" />

<Card title="MHTML" icon="link" href="/oss/python/integrations/document_loaders/mhtml" arrow="true" cta="View guide" />

<Card title="Microsoft Excel" icon="link" href="/oss/python/integrations/document_loaders/microsoft_excel" arrow="true" cta="View guide" />

<Card title="Microsoft OneDrive" icon="link" href="/oss/python/integrations/document_loaders/microsoft_onedrive" arrow="true" cta="View guide" />

<Card title="Microsoft OneNote" icon="link" href="/oss/python/integrations/document_loaders/microsoft_onenote" arrow="true" cta="View guide" />

<Card title="Microsoft PowerPoint" icon="link" href="/oss/python/integrations/document_loaders/microsoft_powerpoint" arrow="true" cta="View guide" />

<Card title="Microsoft SharePoint" icon="link" href="/oss/python/integrations/document_loaders/microsoft_sharepoint" arrow="true" cta="View guide" />

<Card title="Microsoft Word" icon="link" href="/oss/python/integrations/document_loaders/microsoft_word" arrow="true" cta="View guide" />

<Card title="Near Blockchain" icon="link" href="/oss/python/integrations/document_loaders/mintbase" arrow="true" cta="View guide" />

<Card title="Modern Treasury" icon="link" href="/oss/python/integrations/document_loaders/modern_treasury" arrow="true" cta="View guide" />

<Card title="MongoDB" icon="link" href="/oss/python/integrations/document_loaders/mongodb" arrow="true" cta="View guide" />

<Card title="Needle Document Loader" icon="link" href="/oss/python/integrations/document_loaders/needle" arrow="true" cta="View guide" />

<Card title="News URL" icon="link" href="/oss/python/integrations/document_loaders/news" arrow="true" cta="View guide" />

<Card title="Notion DB" icon="link" href="/oss/python/integrations/document_loaders/notion" arrow="true" cta="View guide" />

<Card title="Nuclia" icon="link" href="/oss/python/integrations/document_loaders/nuclia" arrow="true" cta="View guide" />

<Card title="Obsidian" icon="link" href="/oss/python/integrations/document_loaders/obsidian" arrow="true" cta="View guide" />

<Card title="OpenDataLoader PDF" icon="link" href="/oss/python/integrations/document_loaders/opendataloader_pdf" arrow="true" cta="View guide" />

<Card title="Open Document Format (ODT)" icon="link" href="/oss/python/integrations/document_loaders/odt" arrow="true" cta="View guide" />

<Card title="Open City Data" icon="link" href="/oss/python/integrations/document_loaders/open_city_data" arrow="true" cta="View guide" />

<Card title="Oracle Autonomous Database" icon="link" href="/oss/python/integrations/document_loaders/oracleadb_loader" arrow="true" cta="View guide" />

<Card title="Oracle AI Vector Search" icon="link" href="/oss/python/integrations/document_loaders/oracleai" arrow="true" cta="View guide" />

<Card title="Org-mode" icon="link" href="/oss/python/integrations/document_loaders/org_mode" arrow="true" cta="View guide" />

<Card title="Outline Document Loader" icon="link" href="/oss/python/integrations/document_loaders/outline" arrow="true" cta="View guide" />

<Card title="Pandas DataFrame" icon="link" href="/oss/python/integrations/document_loaders/pandas_dataframe" arrow="true" cta="View guide" />

<Card title="PDFMinerLoader" icon="link" href="/oss/python/integrations/document_loaders/pdfminer" arrow="true" cta="View guide" />

<Card title="PDFPlumber" icon="link" href="/oss/python/integrations/document_loaders/pdfplumber" arrow="true" cta="View guide" />

<Card title="Pebblo Safe DocumentLoader" icon="link" href="/oss/python/integrations/document_loaders/pebblo" arrow="true" cta="View guide" />

<Card title="Polaris AI DataInsight" icon="link" href="/oss/python/integrations/document_loaders/polaris_ai_datainsight" arrow="true" cta="View guide" />

<Card title="Polars DataFrame" icon="link" href="/oss/python/integrations/document_loaders/polars_dataframe" arrow="true" cta="View guide" />

<Card title="Dell PowerScale" icon="link" href="/oss/python/integrations/document_loaders/powerscale" arrow="true" cta="View guide" />

<Card title="Psychic" icon="link" href="/oss/python/integrations/document_loaders/psychic" arrow="true" cta="View guide" />

<Card title="PubMed" icon="link" href="/oss/python/integrations/document_loaders/pubmed" arrow="true" cta="View guide" />

<Card title="PullMdLoader" icon="link" href="/oss/python/integrations/document_loaders/pull_md" arrow="true" cta="View guide" />

<Card title="PyMuPDFLoader" icon="link" href="/oss/python/integrations/document_loaders/pymupdf" arrow="true" cta="View guide" />

<Card title="PyMuPDF4LLM" icon="link" href="/oss/python/integrations/document_loaders/pymupdf4llm" arrow="true" cta="View guide" />

<Card title="PyPDFDirectoryLoader" icon="link" href="/oss/python/integrations/document_loaders/pypdfdirectory" arrow="true" cta="View guide" />

<Card title="PyPDFium2Loader" icon="link" href="/oss/python/integrations/document_loaders/pypdfium2" arrow="true" cta="View guide" />

<Card title="PyPDFLoader" icon="link" href="/oss/python/integrations/document_loaders/pypdfloader" arrow="true" cta="View guide" />

<Card title="PySpark" icon="link" href="/oss/python/integrations/document_loaders/pyspark_dataframe" arrow="true" cta="View guide" />

<Card title="Quip" icon="link" href="/oss/python/integrations/document_loaders/quip" arrow="true" cta="View guide" />

<Card title="ReadTheDocs Documentation" icon="link" href="/oss/python/integrations/document_loaders/readthedocs_documentation" arrow="true" cta="View guide" />

<Card title="Recursive URL" icon="link" href="/oss/python/integrations/document_loaders/recursive_url" arrow="true" cta="View guide" />

<Card title="Reddit" icon="link" href="/oss/python/integrations/document_loaders/reddit" arrow="true" cta="View guide" />

<Card title="Roam" icon="link" href="/oss/python/integrations/document_loaders/roam" arrow="true" cta="View guide" />

<Card title="Rockset" icon="link" href="/oss/python/integrations/document_loaders/rockset" arrow="true" cta="View guide" />

<Card title="rspace" icon="link" href="/oss/python/integrations/document_loaders/rspace" arrow="true" cta="View guide" />

<Card title="RSS Feeds" icon="link" href="/oss/python/integrations/document_loaders/rss" arrow="true" cta="View guide" />

<Card title="RST" icon="link" href="/oss/python/integrations/document_loaders/rst" arrow="true" cta="View guide" />

<Card title="scrapfly" icon="link" href="/oss/python/integrations/document_loaders/scrapfly" arrow="true" cta="View guide" />

<Card title="ScrapingAnt" icon="link" href="/oss/python/integrations/document_loaders/scrapingant" arrow="true" cta="View guide" />

<Card title="SingleStore" icon="link" href="/oss/python/integrations/document_loaders/singlestore" arrow="true" cta="View guide" />

<Card title="Sitemap" icon="link" href="/oss/python/integrations/document_loaders/sitemap" arrow="true" cta="View guide" />

<Card title="Slack" icon="link" href="/oss/python/integrations/document_loaders/slack" arrow="true" cta="View guide" />

<Card title="Snowflake" icon="link" href="/oss/python/integrations/document_loaders/snowflake" arrow="true" cta="View guide" />

<Card title="Source Code" icon="link" href="/oss/python/integrations/document_loaders/source_code" arrow="true" cta="View guide" />

<Card title="Spider" icon="link" href="/oss/python/integrations/document_loaders/spider" arrow="true" cta="View guide" />

<Card title="Spreedly" icon="link" href="/oss/python/integrations/document_loaders/spreedly" arrow="true" cta="View guide" />

<Card title="Stripe" icon="link" href="/oss/python/integrations/document_loaders/stripe" arrow="true" cta="View guide" />

<Card title="Subtitle" icon="link" href="/oss/python/integrations/document_loaders/subtitle" arrow="true" cta="View guide" />

<Card title="SurrealDB" icon="link" href="/oss/python/integrations/document_loaders/surrealdb" arrow="true" cta="View guide" />

<Card title="Telegram" icon="link" href="/oss/python/integrations/document_loaders/telegram" arrow="true" cta="View guide" />

<Card title="Tencent COS Directory" icon="link" href="/oss/python/integrations/document_loaders/tencent_cos_directory" arrow="true" cta="View guide" />

<Card title="Tencent COS File" icon="link" href="/oss/python/integrations/document_loaders/tencent_cos_file" arrow="true" cta="View guide" />

<Card title="TensorFlow Datasets" icon="link" href="/oss/python/integrations/document_loaders/tensorflow_datasets" arrow="true" cta="View guide" />

<Card title="TiDB" icon="link" href="/oss/python/integrations/document_loaders/tidb" arrow="true" cta="View guide" />

<Card title="2Markdown" icon="link" href="/oss/python/integrations/document_loaders/tomarkdown" arrow="true" cta="View guide" />

<Card title="TOML" icon="link" href="/oss/python/integrations/document_loaders/toml" arrow="true" cta="View guide" />

<Card title="Trello" icon="link" href="/oss/python/integrations/document_loaders/trello" arrow="true" cta="View guide" />

<Card title="TSV" icon="link" href="/oss/python/integrations/document_loaders/tsv" arrow="true" cta="View guide" />

<Card title="Twitter" icon="link" href="/oss/python/integrations/document_loaders/twitter" arrow="true" cta="View guide" />

<Card title="UnDatasIO" icon="link" href="/oss/python/integrations/document_loaders/undatasio" arrow="true" cta="View guide" />

<Card title="Unstructured" icon="link" href="/oss/python/integrations/document_loaders/unstructured_file" arrow="true" cta="View guide" />

<Card title="UnstructuredMarkdownLoader" icon="link" href="/oss/python/integrations/document_loaders/unstructured_markdown" arrow="true" cta="View guide" />

<Card title="UnstructuredPDFLoader" icon="link" href="/oss/python/integrations/document_loaders/unstructured_pdfloader" arrow="true" cta="View guide" />

<Card title="Upstage" icon="link" href="/oss/python/integrations/document_loaders/upstage" arrow="true" cta="View guide" />

<Card title="URL" icon="link" href="/oss/python/integrations/document_loaders/url" arrow="true" cta="View guide" />

<Card title="Vsdx" icon="link" href="/oss/python/integrations/document_loaders/vsdx" arrow="true" cta="View guide" />

<Card title="Weather" icon="link" href="/oss/python/integrations/document_loaders/weather" arrow="true" cta="View guide" />

<Card title="WebBaseLoader" icon="link" href="/oss/python/integrations/document_loaders/web_base" arrow="true" cta="View guide" />

<Card title="WhatsApp Chat" icon="link" href="/oss/python/integrations/document_loaders/whatsapp_chat" arrow="true" cta="View guide" />

<Card title="Wikipedia" icon="link" href="/oss/python/integrations/document_loaders/wikipedia" arrow="true" cta="View guide" />

<Card title="UnstructuredXMLLoader" icon="link" href="/oss/python/integrations/document_loaders/xml" arrow="true" cta="View guide" />

<Card title="Xorbits Pandas DataFrame" icon="link" href="/oss/python/integrations/document_loaders/xorbits" arrow="true" cta="View guide" />

<Card title="YouTube Audio" icon="link" href="/oss/python/integrations/document_loaders/youtube_audio" arrow="true" cta="View guide" />

<Card title="YouTube Transcripts" icon="link" href="/oss/python/integrations/document_loaders/youtube_transcript" arrow="true" cta="View guide" />

<Card title="YoutubeLoaderDL" icon="link" href="/oss/python/integrations/document_loaders/yt_dlp" arrow="true" cta="View guide" />

<Card title="Yuque" icon="link" href="/oss/python/integrations/document_loaders/yuque" arrow="true" cta="View guide" />

<Card title="ZeroxPDFLoader" icon="link" href="/oss/python/integrations/document_loaders/zeroxpdfloader" arrow="true" cta="View guide" />
</Columns>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/integrations/document_loaders/index.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Run tests to ensure your changes don't break existing functionality

**URL:** llms-txt#run-tests-to-ensure-your-changes-don't-break-existing-functionality

**Contents:**
- Documentation types
  - How-to guides
  - Conceptual guides
  - Reference
  - Tutorials
- Writing standards
  - Mintlify components
  - Page structure
  - Co-locate Python and JavaScript/TypeScript content
- Quality standards

make test
python`, ` yaml  theme={null}
---
title: "Clear, specific title"
sidebarTitle: "Short title for the sidebar (optional)"
---
mdx  theme={null}
:::python
Python-specific content. In real docs, the preceding backslash (before `python`) is omitted.
:::

:::js
JavaScript/TypeScript-specific content. In real docs, the preceding backslash (before `js`) is omitted.
:::

Content for both languages (not wrapped)
```

This will generate two outputs (one for each language) at `/oss/python/concepts/foo.mdx` and `/oss/javascript/concepts/foo.mdx`. Each outputted page will need to be added to the `/src/docs.json` file to be included in the navigation.

<Note>
  We don't want a lack of parity to block contributions. If a feature is only available in one language, it's okay to have documentation only in that language until the other language catches up. In such cases, please include a note indicating that the feature is not yet available in the other language.

If you need help translating content between Python and JavaScript/TypeScript, please ask in the [community slack](https://www.langchain.com/join-community) or tag a maintainer in your PR.
</Note>

### General guidelines

<AccordionGroup>
  <Accordion title="Avoid duplication">
    Multiple pages covering the same material are difficult to maintain and cause confusion. There should be only one canonical page for each concept or feature. Link to other guides instead of re-explaining.
  </Accordion>

<Accordion title="Link frequently">
    Documentation sections don't exist in a vacuum. Link to other sections frequently to allow users to learn about unfamiliar topics. This includes linking to API references and conceptual sections.
  </Accordion>

<Accordion title="Be concise">
    Take a less-is-more approach. If another section with a good explanation exists, link to it rather than re-explain, unless your content presents a new angle.
  </Accordion>
</AccordionGroup>

### Accessibility requirements

Ensure documentation is accessible to all users:

* Structure content for easy scanning with headers and lists
* Use specific, actionable link text instead of "click here"
* Include descriptive alt text for all images and diagrams

Our goal is to have the simplest developer setup possible. Should you experience any difficulty getting setup, please ask in the [community slack](https://www.langchain.com/join-community) or open a [forum post](https://forum.langchain.com/). Internal team members can reach out in the [#documentation](https://langchain.slack.com/archives/C04GWPE38LV) Slack channel.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/contributing/documentation.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
For more details, see the [available commands](https://github.com/langchain-ai/docs?tab=readme-ov-file#available-commands) section in the README.

<Important>
  All pull requests are automatically checked by CI/CD. The same linting and formatting standards will be enforced, and PRs cannot be merged if these checks fail.
</Important>

#### Publish to prod

<Note>
  Only internal team members can publish to production.
</Note>

Once your branch has been merged into `main`, you need to push the changes to `prod` for them to render on the live docs site. Use the [Publish documentation GH action](https://github.com/langchain-ai/docs/actions/workflows/publish.yml):

1. Go to [Publish documentation](https://github.com/langchain-ai/docs/actions/workflows/publish.yml).
2. Click the **Run workflow** button.
3. Select the **main** branch to deploy.
4. Click **Run workflow**.

## Documentation types

All documentation falls under one of four categories:

<CardGroup cols={2}>
  <Card title="How-to guides" icon="wrench" href="#how-to-guides">
    Task-oriented instructions for users who know what they want to accomplish.
  </Card>

  <Card title="Conceptual guides" icon="lightbulb" href="#conceptual-guides">
    Explanations that provide deeper understanding and insights.
  </Card>

  <Card title="Reference" icon="book" href="#reference">
    Technical descriptions of APIs and implementation details.
  </Card>

  <Card title="Tutorials" icon="graduation-cap" href="#tutorials">
    Lessons that guide users through practical activities to build understanding.
  </Card>
</CardGroup>

<Note>
  Where applicable, all documentation must have both Python and JavaScript/TypeScript content. For more details, see the [co-locate Python and JavaScript/TypeScript content](#co-locate-python-and-javascripttypescript-content) section.
</Note>

### How-to guides

How-to guides are task-oriented instructions for users who know what they want to accomplish. Examples of how-to guides are on the [LangChain](/oss/python/langchain/overview) and [LangGraph](/oss/python/langgraph/overview) tabs.

<AccordionGroup>
  <Accordion title="Characteristics">
    * **Task-focused**: Focus on a specific task or problem
    * **Step-by-step**: Break down the task into smaller steps
    * **Hands-on**: Provide concrete examples and code snippets
  </Accordion>

  <Accordion title="Tips">
    * Focus on the **how** rather than the **why**
    * Use concrete examples and code snippets
    * Break down the task into smaller steps
    * Link to related conceptual guides and references
  </Accordion>

  <Accordion title="Examples">
    * [Messages](/oss/python/langchain/messages)
    * [Tools](/oss/python/langchain/tools)
    * [Streaming](/oss/python/langgraph/streaming)
  </Accordion>
</AccordionGroup>

### Conceptual guides

Conceptual guide cover core concepts abstractly, providing deep understanding.

<AccordionGroup>
  <Accordion title="Characteristics">
    * **Understanding-focused**: Explain why things work as they do
    * **Broad perspective**: Higher and wider view than other types
    * **Design-oriented**: Explain decisions and trade-offs
    * **Context-rich**: Use analogies and comparisons
  </Accordion>

  <Accordion title="Tips">
    * Focus on the **"why"** rather than the "how"
    * Provides supplementary information not necessarily required for feature usage
    * Can use analogies and reference alternatives
    * Avoid blending in too much reference content
    * Link to related tutorials and how-to guides
  </Accordion>

  <Accordion title="Examples">
    * [Memory](/oss/python/concepts/memory)
    * [Context](/oss/python/concepts/context)
    * [Graph API](/oss/python/langgraph/graph-api)
    * [Functional API](/oss/python/langgraph/functional-api)
  </Accordion>
</AccordionGroup>

### Reference

Reference documentation contains detailed, low-level information describing exactly what functionality exists and how to use it.

<CardGroup cols={2}>
  <Card title="Python reference" href="https://reference.langchain.com/python/" icon="python" arrow />

  <Card title="JavaScript/TypeScript reference" href="https://reference.langchain.com/javascript/" icon="js" arrow />
</CardGroup>

A good reference should:

* Describe what exists (all parameters, options, return values)
* Be comprehensive and structured for easy lookup
* Serve as the authoritative source for technical details

<AccordionGroup>
  <Accordion title="Contributing to references">
    See the contributing guide for [Python reference docs](https://github.com/langchain-ai/docs/blob/main/reference/python/README.md).
  </Accordion>

  <Accordion title="LangChain reference best practices">
    * **Be consistent**; follow existing patterns for provider-specific documentation
    * Include both basic usage (code snippets) and common edge cases/failure modes
    * Note when features require specific versions
  </Accordion>

  <Accordion title="When to create new reference documentation">
    * New integrations or providers need dedicated reference pages
    * Complex configuration options require detailed explanation
    * API changes introduce new parameters or behavior
    * Community frequently asks questions about specific functionality
  </Accordion>
</AccordionGroup>

### Tutorials

Tutorials are longer form step-by-step guides that builds upon itself and takes users through a specific practical activity to build understanding. Tutorials are typically found on the [Learn](/oss/python/learn) tab.

<Note>
  We generally do not merge new tutorials from outside contributors without an acute need. If you feel that a certain topic is missing from docs or is not sufficiently covered, please [open a new issue](https://github.com/langchain-ai/docs/issues).
</Note>

<AccordionGroup>
  <Accordion title="Characteristics">
    * **Practical**: Focus on practical activities to build understanding.
    * **Step-by-step**: Break down the activity into smaller steps.
    * **Hands-on**: Provide sequential, working code snippets.
    * **Supplementary**: Provide additional context and information not necessarily required for feature usage.
  </Accordion>

  <Accordion title="Tips">
    * Code snippets should be sequential and working if the user follows the steps in order.
    * Provide some context for the activity, but link to related conceptual guides and references for more detailed information.
  </Accordion>

  <Accordion title="Examples">
    * [Semantic search](/oss/python/langchain/knowledge-base)
    * [RAG agent](/oss/python/langchain/rag)
  </Accordion>
</AccordionGroup>

## Writing standards

<Note>
  Reference documentation has different standards - see the [reference docs contributing guide](https://github.com/langchain-ai/docs/blob/main/reference/python/README.md) for details.
</Note>

### Mintlify components

Use [Mintlify components](https://mintlify.com/docs/text) to enhance readability:

<Tabs>
  <Tab title="Callouts">
    * `<Note>` for helpful supplementary information
    * `<Warning>` for important cautions and breaking changes
    * `<Tip>` for best practices and advice
    * `<Info>` for neutral contextual information
    * `<Check>` for success confirmations
  </Tab>

  <Tab title="Structure">
    * `<Steps>` for an overview of sequential procedures. **Not** for long lists of steps or tutorials.
    * `<Tabs>` for platform-specific content.
    * `<AccordionGroup>` and `<Accordion>` for nice-to-have information that can be collapsed by default (e.g., full code examples).
    * `<CardGroup>` and `<Card>` for highlighting content.
  </Tab>

  <Tab title="Code">
    * `<CodeGroup>` for multiple language examples.
    * Always specify language tags on code blocks (e.g., `
```

Example 2 (unknown):
```unknown
### Co-locate Python and JavaScript/TypeScript content

All documentation must be written in both Python and JavaScript/TypeScript when possible. To do so, we use a custom in-line syntax to differentiate between sections that should appear in one or both languages:
```

---

## Assistant creation

**URL:** llms-txt#assistant-creation

**Contents:**
  - Filter operations
- Common access patterns
  - Single-owner resources
  - Permission-based access

@auth.on.assistants.create
async def on_assistant_create(
    ctx: Auth.types.AuthContext,
    value: Auth.types.assistants.create.value
):
    if "assistants:create" not in ctx.permissions:
        raise Auth.exceptions.HTTPException(
            status_code=403,
            detail="User lacks the required permissions."
        )
python  theme={null}
@auth.on
async def owner_only(ctx: Auth.types.AuthContext, value: dict):
    metadata = value.setdefault("metadata", {})
    metadata["owner"] = ctx.user.identity
    return {"owner": ctx.user.identity}
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
Notice that we are mixing global and resource-specific handlers in the above example. Since each request is handled by the most specific handler, a request to create a `thread` would match the `on_thread_create` handler but NOT the `reject_unhandled_requests` handler. A request to `update` a thread, however would be handled by the global handler, since we don't have a more specific handler for that resource and action.

<a id="filter-operations" />

### Filter operations

Authorization handlers can return `None`, a boolean, or a filter dictionary.

* `None` and `True` mean "authorize access to all underling resources"
* `False` means "deny access to all underling resources (raises a 403 exception)"
* A metadata filter dictionary will restrict access to resources

A filter dictionary is a dictionary with keys that match the resource metadata. It supports three operators:

* The default value is a shorthand for exact match, or "\$eq", below. For example, `{"owner": user_id}` will include only resources with metadata containing `{"owner": user_id}`
* `$eq`: Exact match (e.g., `{"owner": {"$eq": user_id}}`) - this is equivalent to the shorthand above, `{"owner": user_id}`
* `$contains`: List membership (e.g., `{"allowed_users": {"$contains": user_id}}`) or list containment (e.g., `{"allowed_users": {"$contains": [user_id_1, user_id_2]}}`). The value here must be an element of the list or a subset of the elements of the list, respectively. The metadata in the stored resource must be a list/container type.

A dictionary with multiple keys is treated using a logical `AND` filter. For example, `{"owner": org_id, "allowed_users": {"$contains": user_id}}` will only match resources with metadata whose "owner" is `org_id` and whose "allowed\_users" list contains `user_id`.
See the reference [`Auth`](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.auth.Auth)(Auth) for more information.

## Common access patterns

Here are some typical authorization patterns:

### Single-owner resources

This common pattern lets you scope all threads, assistants, crons, and runs to a single user. It's useful for common single-user use cases like regular chatbot-style apps.
```

Example 2 (unknown):
```unknown
### Permission-based access

This pattern lets you control access based on **permissions**. It's useful if you want certain roles to have broader or more restricted access to resources.
```

---

## Continue conversation

**URL:** llms-txt#continue-conversation

**Contents:**
- Message content

messages = [
    HumanMessage("What's the weather in San Francisco?"),
    ai_message,  # Model's tool call
    tool_message,  # Tool execution result
]
response = model.invoke(messages)  # Model processes the result
python  theme={null}
    from langchain.messages import ToolMessage

# Sent to model
    message_content = "It was the best of times, it was the worst of times."

# Artifact available downstream
    artifact = {"document_id": "doc_123", "page": 0}

tool_message = ToolMessage(
        content=message_content,
        tool_call_id="call_123",
        name="search_books",
        artifact=artifact,
    )
    python  theme={null}
from langchain.messages import HumanMessage

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Attributes">
  <ParamField path="content" type="string" required>
    The stringified output of the tool call.
  </ParamField>

  <ParamField path="tool_call_id" type="string" required>
    The ID of the tool call that this message is responding to. Must match the ID of the tool call in the [`AIMessage`](https://reference.langchain.com/python/langchain/messages/#langchain.messages.AIMessage).
  </ParamField>

  <ParamField path="name" type="string" required>
    The name of the tool that was called.
  </ParamField>

  <ParamField path="artifact" type="dict">
    Additional data not sent to the model but can be accessed programmatically.
  </ParamField>
</Accordion>

<Note>
  The `artifact` field stores supplementary data that won't be sent to the model but can be accessed programmatically. This is useful for storing raw results, debugging information, or data for downstream processing without cluttering the model's context.

  <Accordion title="Example: Using artifact for retrieval metadata">
    For example, a [retrieval](/oss/python/langchain/retrieval) tool could retrieve a passage from a document for reference by a model. Where message `content` contains text that the model will reference, an `artifact` can contain document identifiers or other metadata that an application can use (e.g., to render a page). See example below:
```

Example 2 (unknown):
```unknown
See the [RAG tutorial](/oss/python/langchain/rag) for an end-to-end example of building retrieval [agents](/oss/python/langchain/agents) with LangChain.
  </Accordion>
</Note>

***

## Message content

You can think of a message's content as the payload of data that gets sent to the model. Messages have a `content` attribute that is loosely-typed, supporting strings and lists of untyped objects (e.g., dictionaries). This allows support for provider-native structures directly in LangChain chat models, such as [multimodal](#multimodal) content and other data.

Separately, LangChain provides dedicated content types for text, reasoning, citations, multi-modal data, server-side tool calls, and other message content. See [content blocks](#standard-content-blocks) below.

LangChain chat models accept message content in the `content` attribute.

This may contain either:

1. A string
2. A list of content blocks in a provider-native format
3. A list of [LangChain's standard content blocks](#standard-content-blocks)

See below for an example using [multimodal](#multimodal) inputs:
```

---

## Data purging for compliance

**URL:** llms-txt#data-purging-for-compliance

**Contents:**
- Data retention
- Trace deletes
  - Deletion timeline
  - Delete specific traces
  - Delete by metadata
- Example deletes
  - Deleting examples is a two-step process
  - Deletion types

Source: https://docs.langchain.com/langsmith/data-purging-compliance

This guide covers the various features available after data reaches LangSmith Cloud servers to help you achieve your privacy goals.

LangSmith provides automatic data retention capabilities to help with compliance and storage management. Data retention policies can be configured at the organization and project levels.

For detailed information about data retention configuration and management, please refer to the [Data Retention concepts](/langsmith/administration-overview#data-retention) documentation.

You can use the API to complete trace deletes. The API supports two methods for deleting traces:

1. **By trace IDs and session ID**: Delete specific traces by providing a list of trace IDs and their corresponding session ID (up to 1000 traces per request)
2. **By metadata**: Delete traces across a workspace that match any of the specified metadata key-value pairs

For more details, refer to the [API spec](https://api.smith.langchain.com/redoc#tag/run/operation/delete_runs_api_v1_runs_delete_post).

<Warning>
  All trace deletions will delete related entities like feedbacks, aggregations, and stats across all data storages.
</Warning>

### Deletion timeline

Trace deletions are processed during non-peak usage times and are not instant. LangChain runs the delete job on the weekend. There is no confirmation of deletion - you'll need to query the data again to verify it has been removed.

### Delete specific traces

To delete specific traces by their trace IDs from a single session:

### Delete by metadata

When deleting by metadata:

* Accepts a `metadata` object of key/value pairs. KV pair matching uses an **or** condition. A trace will match if it has **any** of the key-value pairs specified in metadata (not all)
* You don't need to specify a session id when deleting by metadata. Deletes will apply across the workspace.

To delete traces based on metadata across a workspace (matches **any** of the metadata key-value pairs):

This will delete traces that have either `user_id: "user123"` **or** `environment: "staging"` in their metadata.

<Warning>
  Remember that you can only schedule up to 1000 traces per session per request. For larger deletions, you'll need to make multiple requests.
</Warning>

You can delete dataset examples self-serve via our API, which supports both soft and hard deletion methods depending on your data retention needs.

<Warning>
  Hard deletes will permanently remove inputs, outputs, and metadata from ALL versions of the specified examples across the entire dataset history.
</Warning>

### Deleting examples is a two-step process

For bulk operations, example deletion follows a two-step process:

#### 1. Search for examples by metadata

Find all examples with matching metadata across all datasets in a workspace.

[GET /examples](https://api.smith.langchain.com/redoc#tag/examples/operation/read_examples_api_v1_examples_get)

* `as_of` must be explicitly specified as a timestamp. Only examples created before the `as_of` date will be returned

This will return examples that have either `user_id: "user123"` **or** `environment: "staging"` in their metadata across all datasets in your workspace.

#### 2. Hard delete examples

Once you have the example IDs, send a delete request. This will zero-out the inputs, outputs, and metadata from all versions of the dataset for that example.

[DELETE /examples](https://api.smith.langchain.com/redoc#tag/examples/operation/delete_examples_api_v1_examples_delete)

* Specify example IDs and add `"hard_delete": true` to the query params of the request

#### Soft delete (default)

* Creates tombstoned entries with NULL inputs/outputs in the dataset
* Preserves historical data and maintains dataset versioning
* Only affects the current version of the dataset

* Permanently removes inputs, outputs, and metadata from ALL dataset versions
* Complete data removal when compliance requires zero-out across all versions
* Add `"hard_delete": true` to the query parameters

For more details, refer to the [API spec](https://api.smith.langchain.com/redoc#tag/examples/operation/delete_examples_api_v1_examples_delete).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/data-purging-compliance.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
### Delete by metadata

When deleting by metadata:

* Accepts a `metadata` object of key/value pairs. KV pair matching uses an **or** condition. A trace will match if it has **any** of the key-value pairs specified in metadata (not all)
* You don't need to specify a session id when deleting by metadata. Deletes will apply across the workspace.

To delete traces based on metadata across a workspace (matches **any** of the metadata key-value pairs):
```

Example 2 (unknown):
```unknown
This will delete traces that have either `user_id: "user123"` **or** `environment: "staging"` in their metadata.

<Warning>
  Remember that you can only schedule up to 1000 traces per session per request. For larger deletions, you'll need to make multiple requests.
</Warning>

## Example deletes

You can delete dataset examples self-serve via our API, which supports both soft and hard deletion methods depending on your data retention needs.

<Warning>
  Hard deletes will permanently remove inputs, outputs, and metadata from ALL versions of the specified examples across the entire dataset history.
</Warning>

### Deleting examples is a two-step process

For bulk operations, example deletion follows a two-step process:

#### 1. Search for examples by metadata

Find all examples with matching metadata across all datasets in a workspace.

[GET /examples](https://api.smith.langchain.com/redoc#tag/examples/operation/read_examples_api_v1_examples_get)

* `as_of` must be explicitly specified as a timestamp. Only examples created before the `as_of` date will be returned
```

Example 3 (unknown):
```unknown
This will return examples that have either `user_id: "user123"` **or** `environment: "staging"` in their metadata across all datasets in your workspace.

#### 2. Hard delete examples

Once you have the example IDs, send a delete request. This will zero-out the inputs, outputs, and metadata from all versions of the dataset for that example.

[DELETE /examples](https://api.smith.langchain.com/redoc#tag/examples/operation/delete_examples_api_v1_examples_delete)

* Specify example IDs and add `"hard_delete": true` to the query params of the request
```

---

## Dataset prebuilt JSON schema types

**URL:** llms-txt#dataset-prebuilt-json-schema-types

Source: https://docs.langchain.com/langsmith/dataset-json-types

LangSmith recommends that you set a schema on the inputs and outputs of your dataset schemas to ensure data consistency and that your examples are in the right format for downstream processing, like running evals.

In order to better support LLM workflows, LangSmith has support for a few different predefined prebuilt types. These schemas are hosted publicly by the LangSmith API, and can be defined in your dataset schemas using [JSON Schema references](https://json-schema.org/understanding-json-schema/structuring#dollarref). The table of available schemas can be seen below

| Type    | JSON Schema Reference Link                                                                                                       | Usage                                                                                                                     |
| ------- | -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------- |
| Message | [https://api.smith.langchain.com/public/schemas/v1/message.json](https://api.smith.langchain.com/public/schemas/v1/message.json) | Represents messages sent to a chat model, following the OpenAI standard format.                                           |
| Tool    | [https://api.smith.langchain.com/public/schemas/v1/tooldef.json](https://api.smith.langchain.com/public/schemas/v1/tooldef.json) | Tool definitions available to chat models for function calling, defined in OpenAI's JSON Schema inspired function format. |

LangSmith lets you define a series of transformations that collect the above prebuilt types from your traces and add them to your dataset. For more info on available transformations, see our [reference](/langsmith/dataset-transformations)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/dataset-json-types.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## API Reference: https://api.smith.langchain.com/redoc#tag/examples/operation/read_examples_api_v1_examples_get

**URL:** llms-txt#api-reference:-https://api.smith.langchain.com/redoc#tag/examples/operation/read_examples_api_v1_examples_get

dataset_id = dataset.id
params = { "dataset": dataset_id }

resp = requests.get(
    "https://api.smith.langchain.com/api/v1/examples",
    params=params,
    headers={"x-api-key": os.environ["LANGSMITH_API_KEY"]}
)

examples = resp.json()
python  theme={null}
os.environ["OPENAI_API_KEY"] = "sk-..."

def run_completion_on_example(example, model_name, experiment_id):
    """Run completions on a list of examples."""
    # We are using the OpenAI API here, but you can use any model you like

def _post_run(run_id, name, run_type, inputs, parent_id=None):
        """Function to post a new run to the API.
        API Reference: https://api.smith.langchain.com/redoc#tag/run/operation/create_run_api_v1_runs_post
        """
        data = {
            "id": run_id.hex,
            "name": name,
            "run_type": run_type,
            "inputs": inputs,
            "start_time": datetime.utcnow().isoformat(),
            "reference_example_id": example["id"],
            "session_id": experiment_id,
        }
        if parent_id:
            data["parent_run_id"] = parent_id.hex
        resp = requests.post(
            "https://api.smith.langchain.com/api/v1/runs", # Update appropriately for self-hosted installations or the EU region
            json=data,
            headers=headers
        )
        resp.raise_for_status()

def _patch_run(run_id, outputs):
        """Function to patch a run with outputs.
        API Reference: https://api.smith.langchain.com/redoc#tag/run/operation/update_run_api_v1_runs__run_id__patch
        """
        resp = requests.patch(
            f"https://api.smith.langchain.com/api/v1/runs/{run_id}",
            json={
                "outputs": outputs,
                "end_time": datetime.utcnow().isoformat(),
            },
            headers=headers,
        )
        resp.raise_for_status()

# Send your API Key in the request headers
    headers = {"x-api-key": os.environ["LANGSMITH_API_KEY"]}

text = example["inputs"]["text"]

messages = [
        {
            "role": "system",
            "content": "Please review the user query below and determine if it contains any form of toxic behavior, such as insults, threats, or highly negative comments. Respond with 'Toxic' if it does, and 'Not toxic' if it doesn't.",
        },
        {"role": "user", "content": text},
    ]

# Create parent run
    parent_run_id = uuid4()
    _post_run(parent_run_id, "LLM Pipeline", "chain", {"text": text})

# Create child run
    child_run_id = uuid4()
    _post_run(child_run_id, "OpenAI Call", "llm", {"messages": messages}, parent_run_id)

# Generate completion
    chat_completion = oa_client.chat.completions.create(model=model_name, messages=messages)
    output_text = chat_completion.choices[0].message.content

# End run
    _patch_run(child_run_id, {
    "messages": messages,
        "output": output_text,
        "model": model_name
    })

_patch_run(parent_run_id, {"label": output_text})
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
Next, define a function that will run your model on a single example and log the results to LangSmith. When using the API directly, you're responsible for:

* Creating run objects via POST to `/runs` with `reference_example_id` and `session_id` set.
* Tracking parent-child relationships between runs (e.g., a parent "chain" run containing a child "llm" run).
* Updating runs with outputs via PATCH to `/runs/{run_id}`.
```

Example 2 (unknown):
```unknown
Now create the experiments and run completions on all examples. In the API, an "experiment" is represented as a session (or "tracer session") that references a dataset via `reference_dataset_id`. The key difference from regular tracing is that runs in an experiment must have a `reference_example_id` that links each run to a specific example in the dataset.
```

---

## Define your tasks

**URL:** llms-txt#define-your-tasks

research_task = Task(
    description="""Conduct comprehensive research on the current state of AI adoption
    in small to medium businesses. Focus on:
    1. Current adoption rates and trends
    2. Main barriers to adoption
    3. Most popular AI tools and use cases
    4. ROI and business impact metrics

Provide a detailed analysis with supporting data and statistics.""",
    agent=market_researcher,
    expected_output="A comprehensive market research report on AI adoption in SMBs with data, trends, and insights.",
)

analysis_task = Task(
    description="""Analyze the research findings and identify key statistical patterns.
    Create data visualizations and provide quantitative insights on:
    1. Adoption rate trends over time
    2. Industry-specific adoption patterns
    3. ROI correlation analysis
    4. Barrier impact assessment

Present findings in a clear, data-driven format.""",
    agent=data_analyst,
    expected_output="Statistical analysis report with key metrics, trends, and data-driven insights.",
    context=[research_task],
)

content_task = Task(
    description="""Based on the research and analysis, create a compelling marketing
    strategy document that includes:
    1. Executive summary of key findings
    2. Target audience personas based on adoption patterns
    3. Key messaging framework addressing main barriers
    4. Content recommendations for different business segments
    5. Campaign strategy to drive AI adoption

Make the content actionable and business-focused.""",
    agent=content_strategist,
    expected_output="Complete marketing strategy document with personas, messaging, and campaign recommendations.",
    context=[research_task, analysis_task],
)

---

## Egress for subscription metrics and operational metadata

**URL:** llms-txt#egress-for-subscription-metrics-and-operational-metadata

**Contents:**
- LangSmith Telemetry
  - What we use it for
  - What we collect
  - How to disable
- Example payloads
  - License Verification
  - Usage Reporting
  - Telemetry: Operational LangSmith Metrics
  - Telemetry: Operational LangSmith Traces
- Our Commitment

Source: https://docs.langchain.com/langsmith/self-host-egress

<Info>
  This section only applies to customers who are not running in offline mode and assumes you are using a self-hosted LangSmith instance serving version 0.9.0 or later. Previous versions of LangSmith did not have this feature.
</Info>

Self-Hosted LangSmith instances store all information locally and will never send sensitive information outside of your network. We currently only track platform usage for billing purposes according to the entitlements in your order. In order to better remotely support our customers, we do require egress to `https://beacon.langchain.com`.

In the future, we will be introducing support diagnostics to help us ensure that LangSmith is running at an optimal level within your environment.

<Warning>
  **This will require egress to `https://beacon.langchain.com` from your network. Refer to the [allowlisting IP section](/langsmith/cloud#allowlisting-ip-addresses) for static IP addresses, if needed.**
</Warning>

Generally, data that we send to Beacon can be categorized as follows:

* Subscription Metrics

* Subscription metrics are used to determine level of access and utilization of LangSmith. This includes, but are not limited to:

* Number of traces
    * Seats allocated per contract
    * Seats in currently use

* Operational Metadata
  * This metadata will contain and collect the above subscription metrics to assist with remote support, allowing the LangChain team to diagnose and troubleshoot performance issues more effectively and proactively.

## LangSmith Telemetry

As of version ***0.11***, LangSmith deployments will by default send telemetry data back to our backend. All telemetry data is associated with an organization and deployment, but never identified with individual users. We ***do not collect PII*** (personally identifiable information) in any form.

### What we use it for

* To provide more proactive support and faster troubleshooting of self-hosted instances.
* Assisting with performance tuning.
* Understanding real-world usage to prioritize improvements.

* **Request metadata**: anonymized request counts, sizes, and durations.
* **Database metrics**: query durations, error rates, and performance counters.
* **Operational LangSmith traces**: traces with timing and error information for high-latency or failed requests. These are **not** customer traces, these are operational traces about the functioning of the LangSmith instance.

<Info>
  We do not collect actual payload contents, database records, or any data that can identify your end users or customers.
</Info>

Set the following values in your `langsmith_config.yaml` file:

In an effort to maximize transparency, we provide sample payloads here:

### License Verification

`POST beacon.langchain.com/v1/beacon/verify`

`POST beacon.langchain.com/v1/beacon/ingest-traces`

### Telemetry: Operational LangSmith Metrics

`POST beacon.langchain.com/v1/beacon/v1/metrics`

### Telemetry: Operational LangSmith Traces

`POST beacon.langchain.com/v1/beacon/v1/traces`

LangChain will not store any sensitive information in the Subscription Metrics or Operational Metadata. Any data collected will not be shared with a third party. If you have any concerns about the data being sent, please reach out to your account team.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/self-host-egress.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
## Example payloads

In an effort to maximize transparency, we provide sample payloads here:

### License Verification

**Endpoint:**

`POST beacon.langchain.com/v1/beacon/verify`

**Request:**
```

Example 2 (unknown):
```unknown
**Response:**
```

Example 3 (unknown):
```unknown
### Usage Reporting

**Endpoint:**

`POST beacon.langchain.com/v1/beacon/ingest-traces`

**Request:**
```

Example 4 (unknown):
```unknown
**Response:**
```

---

## >    )

**URL:** llms-txt#>----)

---

## Target function for running the relevant step

**URL:** llms-txt#target-function-for-running-the-relevant-step

async def run_intent_classifier(inputs: dict) -> dict:
    # Note that we can access and run the intent_classifier node of our graph directly.
    command = await graph.nodes['intent_classifier'].ainvoke(inputs)
    return {"route": command.goto}

---

## Observability in Studio

**URL:** llms-txt#observability-in-studio

**Contents:**
- Iterate on prompts
  - Direct node editing
  - Graph configuration
  - Playground
- Run experiments over a dataset
  - Prerequisites
  - Experiment setup
- Debug LangSmith traces
  - Open deployed threads
  - Testing local agents with remote traces

Source: https://docs.langchain.com/langsmith/observability-studio

LangSmith [Studio](/langsmith/studio) provides tools to inspect, debug, and improve your app beyond execution. By working with traces, datasets, and prompts, you can see how your application behaves in detail, measure its performance, and refine its outputs:

* [Iterate on prompts](#iterate-on-prompts): Modify prompts inside graph nodes directly or with the LangSmith playground.
* [Run experiments over a dataset](#run-experiments-over-a-dataset): Execute your assistant over a LangSmith dataset to score and compare results.
* [Debug LangSmith traces](#debug-langsmith-traces): Import traced runs into Studio and optionally clone them into your local agent.
* [Add a node to a dataset](#add-node-to-dataset): Turn parts of thread history into dataset examples for evaluation or further analysis.

## Iterate on prompts

Studio supports the following methods for modifying prompts in your graph:

* [Direct node editing](#direct-node-editing)
* [Playground interface](#playground)

### Direct node editing

Studio allows you to edit prompts used inside individual nodes, directly from the graph interface.

### Graph configuration

Define your [configuration](/oss/python/langgraph/use-graph-api#add-runtime-configuration) to specify prompt fields and their associated nodes using `langgraph_nodes` and `langgraph_type` keys.

#### `langgraph_nodes`

* **Description**: Specifies which nodes of the graph a configuration field is associated with.
* **Value Type**: Array of strings, where each string is the name of a node in your graph.
* **Usage Context**: Include in the `json_schema_extra` dictionary for Pydantic models or the `metadata["json_schema_extra"]` dictionary for dataclasses.
* **Example**:

#### `langgraph_type`

* **Description**: Specifies the type of configuration field, which determines how it's handled in the UI.
* **Value Type**: String
* **Supported Values**:
  * `"prompt"`: Indicates the field contains prompt text that should be treated specially in the UI.
* **Usage Context**: Include in the `json_schema_extra` dictionary for Pydantic models or the `metadata["json_schema_extra"]` dictionary for dataclasses.
* **Example**:

<Accordion title="Full example configuration">
  
</Accordion>

#### Editing prompts in the UI

1. Locate the gear icon on nodes with associated configuration fields.
2. Click to open the configuration modal.
3. Edit the values.
4. Save to update the current assistant version or create a new one.

The [playground](/langsmith/create-a-prompt) interface allows testing individual LLM calls without running the full graph:

1. Select a thread.
2. Click **View LLM Runs** on a node. This lists all the LLM calls (if any) made inside the node.
3. Select an LLM run to open in the playground.
4. Modify prompts and test different model and tool settings.
5. Copy updated prompts back to your graph.

## Run experiments over a dataset

Studio lets you run [evaluations](/langsmith/evaluation-concepts) by executing your assistant against a predefined LangSmith [dataset](/langsmith/evaluation-concepts#datasets). This allows you to test performance across a variety of inputs, compare outputs to reference answers, and score results with configured [evaluators](/langsmith/evaluation-concepts#evaluators).

This guide shows you how to run a full end-to-end experiment directly from Studio.

Before running an experiment, ensure you have the following:

* **A LangSmith dataset**: Your dataset should contain the inputs you want to test and optionally, reference outputs for comparison. The schema for the inputs must match the required input schema for the assistant. For more information on schemas, see [here](/oss/python/langgraph/use-graph-api#schema). For more on creating datasets, refer to [How to Manage Datasets](/langsmith/manage-datasets-in-application#set-up-your-dataset).
* **(Optional) Evaluators**: You can attach evaluators (e.g., LLM-as-a-Judge, heuristics, or custom functions) to your dataset in LangSmith. These will run automatically after the graph has processed all inputs.
* **A running application**: The experiment can be run against:
  * An application deployed on [LangSmith](/langsmith/deployments).
  * A locally running application started via the [langgraph-cli](/langsmith/local-server).

1. Launch the experiment. Click the **Run experiment** button in the top right corner of the Studio page.
2. Select your dataset. In the modal that appears, select the dataset (or a specific dataset split) to use for the experiment and click **Start**.
3. Monitor the progress. All of the inputs in the dataset will now be run against the active assistant. Monitor the experiment's progress via the badge in the top right corner.
4. You can continue to work in Studio while the experiment runs in the background. Click the arrow icon button at any time to navigate to LangSmith and view the detailed experiment results.

## Debug LangSmith traces

This guide explains how to open LangSmith traces in Studio for interactive investigation and debugging.

### Open deployed threads

1. Open the LangSmith trace, selecting the root run.
2. Click **Run in Studio**.

This will open Studio connected to the associated deployment with the trace's parent thread selected.

### Testing local agents with remote traces

This section explains how to test a local agent against remote traces from LangSmith. This enables you to use production traces as input for local testing, allowing you to debug and verify agent modifications in your development environment.

* A LangSmith traced thread
* A [locally running agent](/langsmith/local-server#local-development-server).

<Info>
  **Local agent requirements**

* langgraph>=0.3.18
  * langgraph-api>=0.0.32
  * Contains the same set of nodes present in the remote trace
</Info>

1. Open the LangSmith trace, selecting the root run.
2. Click the dropdown next to **Run in Studio**.
3. Enter your local agent's URL.
4. Select **Clone thread locally**.
5. If multiple graphs exist, select the target graph.

A new thread will be created in your local agent with the thread history inferred and copied from the remote thread, and you will be navigated to Studio for your locally running application.

## Add node to dataset

Add [examples](/langsmith/evaluation-concepts#examples) to [LangSmith datasets](/langsmith/manage-datasets) from nodes in the thread log. This is useful to evaluate individual steps of the agent.

1. Select a thread.
2. Click **Add to Dataset**.
3. Select nodes whose input/output you want to add to a dataset.
4. For each selected node, select the target dataset to create the example in. By default a dataset for the specific assistant and node will be selected. If this dataset does not yet exist, it will be created.
5. Edit the example's input/output as needed before adding it to the dataset.
6. Select **Add to dataset** at the bottom of the page to add all selected nodes to their respective datasets.

For more details, refer to [How to evaluate an application's intermediate steps](/langsmith/evaluate-on-intermediate-steps).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/observability-studio.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
#### `langgraph_type`

* **Description**: Specifies the type of configuration field, which determines how it's handled in the UI.
* **Value Type**: String
* **Supported Values**:
  * `"prompt"`: Indicates the field contains prompt text that should be treated specially in the UI.
* **Usage Context**: Include in the `json_schema_extra` dictionary for Pydantic models or the `metadata["json_schema_extra"]` dictionary for dataclasses.
* **Example**:
```

Example 2 (unknown):
```unknown
<Accordion title="Full example configuration">
```

---

## You can customize it if building a custom agent

**URL:** llms-txt#you-can-customize-it-if-building-a-custom-agent

**Contents:**
  - Short-term vs. long-term filesystem
- Subagent middleware

agent = create_agent(
    model="claude-sonnet-4-5-20250929",
    middleware=[
        FilesystemMiddleware(
            backend=None,  # Optional: custom backend (defaults to StateBackend)
            system_prompt="Write to the filesystem when...",  # Optional custom addition to the system prompt
            custom_tool_descriptions={
                "ls": "Use the ls tool when...",
                "read_file": "Use the read_file tool to..."
            }  # Optional: Custom descriptions for filesystem tools
        ),
    ],
)
python  theme={null}
from langchain.agents import create_agent
from deepagents.middleware import FilesystemMiddleware
from deepagents.backends import CompositeBackend, StateBackend, StoreBackend
from langgraph.store.memory import InMemoryStore

store = InMemoryStore()

agent = create_agent(
    model="claude-sonnet-4-5-20250929",
    store=store,
    middleware=[
        FilesystemMiddleware(
            backend=lambda rt: CompositeBackend(
                default=StateBackend(rt),
                routes={"/memories/": StoreBackend(rt)}
            ),
            custom_tool_descriptions={
                "ls": "Use the ls tool when...",
                "read_file": "Use the read_file tool to..."
            }  # Optional: Custom descriptions for filesystem tools
        ),
    ],
)
python  theme={null}
from langchain.tools import tool
from langchain.agents import create_agent
from deepagents.middleware.subagents import SubAgentMiddleware

@tool
def get_weather(city: str) -> str:
    """Get the weather in a city."""
    return f"The weather in {city} is sunny."

agent = create_agent(
    model="claude-sonnet-4-5-20250929",
    middleware=[
        SubAgentMiddleware(
            default_model="claude-sonnet-4-5-20250929",
            default_tools=[],
            subagents=[
                {
                    "name": "weather",
                    "description": "This subagent can get weather in cities.",
                    "system_prompt": "Use the get_weather tool to get the weather in a city.",
                    "tools": [get_weather],
                    "model": "gpt-4o",
                    "middleware": [],
                }
            ],
        )
    ],
)
python  theme={null}
from langchain.agents import create_agent
from deepagents.middleware.subagents import SubAgentMiddleware
from deepagents import CompiledSubAgent
from langgraph.graph import StateGraph

**Examples:**

Example 1 (unknown):
```unknown
### Short-term vs. long-term filesystem

By default, these tools write to a local "filesystem" in your graph state. To enable persistent storage across threads, configure a `CompositeBackend` that routes specific paths (like `/memories/`) to a `StoreBackend`.
```

Example 2 (unknown):
```unknown
When you configure a `CompositeBackend` with a `StoreBackend` for `/memories/`, any files prefixed with **/memories/** are saved to persistent storage and survive across different threads. Files without this prefix remain in ephemeral state storage.

## Subagent middleware

Handing off tasks to subagents isolates context, keeping the main (supervisor) agent's context window clean while still going deep on a task.

The subagents middleware allows you to supply subagents through a `task` tool.
```

Example 3 (unknown):
```unknown
A subagent is defined with a **name**, **description**, **system prompt**, and **tools**. You can also provide a subagent with a custom **model**, or with additional **middleware**. This can be particularly useful when you want to give the subagent an additional state key to share with the main agent.

For more complex use cases, you can also provide your own pre-built LangGraph graph as a subagent.
```

---

## Enables Claude Code to emit OTEL events

**URL:** llms-txt#enables-claude-code-to-emit-otel-events

export CLAUDE_CODE_ENABLE_TELEMETRY=1

---

## For production use, consider using a configuration file or environment variables

**URL:** llms-txt#for-production-use,-consider-using-a-configuration-file-or-environment-variables

api_url = "https://api.smith.langchain.com"
api_key = os.environ.get("LANGSMITH_API_KEY")

if not api_key:
    raise ValueError("LANGSMITH_API_KEY environment variable is not set")

---

## State-based (files in LangGraph state)

**URL:** llms-txt#state-based-(files-in-langgraph-state)

agent = create_agent(
    model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
    tools=[],
    middleware=[
        StateClaudeTextEditorMiddleware(),
    ],
)
python  theme={null}
  from langchain_anthropic import ChatAnthropic
  from langchain_anthropic.middleware import (
      StateClaudeTextEditorMiddleware,
      FilesystemClaudeTextEditorMiddleware,
  )
  from langchain.agents import create_agent

# State-based: Files persist in LangGraph state
  agent_state = create_agent(
      model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
      tools=[],
      middleware=[
          StateClaudeTextEditorMiddleware(
              allowed_path_prefixes=["/project"],
          ),
      ],
  )

# Filesystem-based: Files persist on disk
  agent_fs = create_agent(
      model=ChatAnthropic(model="claude-sonnet-4-5-20250929"),
      tools=[],
      middleware=[
          FilesystemClaudeTextEditorMiddleware(
              root_path="/workspace",
              allowed_prefixes=["/src"],
              max_file_size_mb=10,
          ),
      ],
  )
  python  theme={null}
from langchain_anthropic import ChatAnthropic
from langchain_anthropic.middleware import StateClaudeMemoryMiddleware
from langchain.agents import create_agent

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Configuration options">
  **@\[`StateClaudeTextEditorMiddleware`] (state-based)**

  <ParamField body="allowed_path_prefixes" type="Sequence[str] | None">
    Optional list of allowed path prefixes. If specified, only paths starting with these prefixes are allowed.
  </ParamField>

  **@\[`FilesystemClaudeTextEditorMiddleware`] (filesystem-based)**

  <ParamField body="root_path" type="str" required>
    Root directory for file operations
  </ParamField>

  <ParamField body="allowed_prefixes" type="list[str] | None">
    Optional list of allowed virtual path prefixes (default: `["/"]`)
  </ParamField>

  <ParamField body="max_file_size_mb" type="int" default="10">
    Maximum file size in MB
  </ParamField>
</Accordion>

<Accordion title="Full example">
  Claude's text editor tool supports the following commands:

  * `view` - View file contents or list directory
  * `create` - Create a new file
  * `str_replace` - Replace string in file
  * `insert` - Insert text at line number
  * `delete` - Delete a file
  * `rename` - Rename/move a file
```

Example 2 (unknown):
```unknown
</Accordion>

#### Memory

Provide Claude's memory tool (`memory_20250818`) for persistent agent memory across conversation turns. The memory middleware is useful for the following:

* Long-running agent conversations
* Maintaining context across interruptions
* Task progress tracking
* Persistent agent state management

<Info>
  Claude's memory tool uses a `/memories` directory and automatically injects a system prompt encouraging the agent to check and update memory.
</Info>

**API reference:** @\[`StateClaudeMemoryMiddleware`], @\[`FilesystemClaudeMemoryMiddleware`]
```

---

## You can then create edges to/from this node by referencing it as `"my_node"`

**URL:** llms-txt#you-can-then-create-edges-to/from-this-node-by-referencing-it-as-`"my_node"`

**Contents:**
  - `START` Node
  - `END` Node
  - Node Caching

python  theme={null}
from langgraph.graph import START

graph.add_edge(START, "node_a")
python  theme={null}
from langgraph.graph import END

graph.add_edge("node_a", END)
python  theme={null}
import time
from typing_extensions import TypedDict
from langgraph.graph import StateGraph
from langgraph.cache.memory import InMemoryCache
from langgraph.types import CachePolicy

class State(TypedDict):
    x: int
    result: int

builder = StateGraph(State)

def expensive_node(state: State) -> dict[str, int]:
    # expensive computation
    time.sleep(2)
    return {"result": state["x"] * 2}

builder.add_node("expensive_node", expensive_node, cache_policy=CachePolicy(ttl=3))
builder.set_entry_point("expensive_node")
builder.set_finish_point("expensive_node")

graph = builder.compile(cache=InMemoryCache())

print(graph.invoke({"x": 5}, stream_mode='updates'))    # [!code highlight]

**Examples:**

Example 1 (unknown):
```unknown
### `START` Node

The [`START`](https://reference.langchain.com/python/langgraph/constants/#langgraph.constants.START) Node is a special node that represents the node that sends user input to the graph. The main purpose for referencing this node is to determine which nodes should be called first.
```

Example 2 (unknown):
```unknown
### `END` Node

The `END` Node is a special node that represents a terminal node. This node is referenced when you want to denote which edges have no actions after they are done.
```

Example 3 (unknown):
```unknown
### Node Caching

LangGraph supports caching of tasks/nodes based on the input to the node. To use caching:

* Specify a cache when compiling a graph (or specifying an entrypoint)
* Specify a cache policy for nodes. Each cache policy supports:
  * `key_func` used to generate a cache key based on the input to a node, which defaults to a `hash` of the input with pickle.
  * `ttl`, the time to live for the cache in seconds. If not specified, the cache will never expire.

For example:
```

---

## This can be retrieved in a retrieval step

**URL:** llms-txt#this-can-be-retrieved-in-a-retrieval-step

context = "During this morning's meeting, we solved all world conflict."

messages = [
    {"role": "system", "content": "You are a helpful assistant. Please respond to the user's request only based on the given context."},
    {"role": "user", "content": f"Question: {question}\nContext: {context}"}
]

---

## Set up automation rules

**URL:** llms-txt#set-up-automation-rules

**Contents:**
- View automation rules
- Create a rule
- View logs for your automations
- Video guide

Source: https://docs.langchain.com/langsmith/rules

While you can manually sift through and process production logs from your LLM application, it often becomes difficult as your application scales to more users.
LangSmith provides a powerful feature called **Automations** that allow you to trigger certain actions on your trace data.
At a high level, automations are defined by a **filter**, **sampling rate**, and **action**.

Automation rules can trigger actions such as: adding traces to a dataset, adding to an annotation queue, triggering a webhook (e.g. for remote evaluations) or extending data retention. Some examples of automations you can set up:

* Send all traces with negative feedback to an annotation queue for human review
* Send 10% of all traces to an annotation queue for human review to spot check for issues
* Upgrade all traces with errors for extended data retention

<Info>
  To configure online evaluations, visit the [online evaluations](/langsmith/online-evaluations) page.
</Info>

<Note>If an automation rule matches any run within a trace, the trace will be auto-upgraded to [extended data retention](/langsmith/administration-overview#data-retention-auto-upgrades). This upgrade will impact trace pricing, but ensures that traces meeting your automation criteria (typically those most valuable for analysis) are preserved for investigation. </Note>

## View automation rules

Head to the **Tracing Projects** tab and select a tracing project. To view existing automation rules for that tracing project, click on the **Automations** tab.

<img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=9206c95784e0d572adddf7ad60e58717" alt="View automation rules" data-og-width="1349" width="1349" data-og-height="521" height="521" data-path="langsmith/images/view-automation-rules.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=88988b3e687419b0494b36e20d424965 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=8091094d8e938a31367fd456cdb16778 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=08bce1184a23c4345c41abc2ede29826 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=faf56babdc5b9396a38e780600a31b4a 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=8996953f130ed137172b26af817a5c22 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/view-automation-rules.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=fea915cf43defcf09e6b7161a2c2af8a 2500w" />

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/aq-spot-check-rule.gif?s=0ea58303ab04ffa8ed16c49ab39701ef" alt="" data-og-width="1556" width="1556" data-og-height="1080" height="1080" data-path="langsmith/images/aq-spot-check-rule.gif" data-optimize="true" data-opv="3" />

#### 1. Navigate to rule creation

Head to the **Tracing Projects** tab and select a tracing project. Click on **+ New** in the top right corner of the tracing project page, then click on **New Automation**.

#### 2. Name your rule

#### 3. Create a filter

Automation rule filters work the same way as filters applied to traces in the project. For more information on filters, you can refer to [this guide](./filter-traces-in-application)

#### 4. Configure a sampling rate

Configure a sampling rate to control the percentage of filtered runs that trigger the automation action.

You can specify a sampling rate between 0 and 1 for automations. This will control the percent of the filtered runs that are sent to an automation action. For example, if you set the sampling rate to 0.5, then 50% of the traces that pass the filter will be sent to the action.

#### 5. (Optional) Apply rule to past runs

Apply rule to past runs by toggling the **Apply to past runs** and entering a "Backfill from" date. This is only possible upon rule creation. Note: the backfill is processed as a background job, so you will not see the results immediately. In order to track progress of the backfill, you can [view logs for your automations](./rules#view-logs-for-your-automations)

#### 6. Select an action to trigger when the rule is applied.

There are four actions you can take with an automation rule:

* **Add to dataset**: Add the inputs and outputs of the trace to a [dataset](/langsmith/evaluation-concepts#datasets).
* **Add to annotation queue**: Add the trace to an [annotation queue](/langsmith/evaluation-concepts#annotation-queues).
* **Trigger webhook**: Trigger a webhook with the trace data. For more information on webhooks, you can refer to [this guide](./webhooks).
* **Extend data retention**: Extends the data retention period on matching traces that use base retention [(see data retention docs for more details)](/langsmith/administration-overview#data-retention).
  Note that all other rules will also extend data retention on matching traces through the
  auto-upgrade mechanism described in the aforementioned data retention docs,
  but this rule takes no additional action.

## View logs for your automations

Logs allow you to gain confidence that your rules are working as expected. You can view logs for your automations by heading to the **Automations** tab within a tracing project and clicking the **Logs** button for the rule you created.

The logs tab allows you to:

* View all runs processed by a given rule for the time period selected
* If a particular rule execution has triggered an error, you can view the error message by hovering over the error icon
* You can monitor the progress of a backfill job by filtering to the rule's creation timestamp. This is because the backfill starts from when the rule was created.
* Inspect the run that the automation rule applied to using the **View run** button. For rules that add runs as examples to datasets, you can view the example produced.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/rule-logs.gif?s=2ec5562fea9e2079b687da149d1609b3" alt="Logs_Gif" data-og-width="1556" width="1556" data-og-height="1080" height="1080" data-path="langsmith/images/rule-logs.gif" data-optimize="true" data-opv="3" />

<iframe className="w-full aspect-video rounded-xl" src="https://www.youtube.com/embed/z69cBXTJFZ0?si=GBKQ9_muHR1zllLl" title="YouTube video player" frameBorder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowFullScreen />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/rules.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## How to set up an application with requirements.txt

**URL:** llms-txt#how-to-set-up-an-application-with-requirements.txt

**Contents:**
- Specify dependencies
- Specify environment variables
- Define graphs

Source: https://docs.langchain.com/langsmith/setup-app-requirements-txt

An application must be configured with a [configuration file](/langsmith/cli#configuration-file) in order to be deployed to LangSmith (or to be self-hosted). This how-to guide discusses the basic steps to set up an application for deployment using `requirements.txt` to specify project dependencies.

This example is based on [this repository](https://github.com/langchain-ai/langgraph-example), which uses the LangGraph framework.

The final repository structure will look something like this:

<Tip>
  LangSmith Deployment supports deploying a [LangGraph](/oss/python/langgraph/overview) *graph*. However, the implementation of a *node* of a graph can contain arbitrary Python code. This means any framework can be implemented within a node and deployed on LangSmith Deployment. This lets you keep your core application logic outside LangGraph while still using LangSmith for [deployment](/langsmith/deployments), scaling, and [observability](/langsmith/observability).
</Tip>

You can also set up with:

* `pyproject.toml`: If you prefer using poetry for dependency management, check out [this how-to guide](/langsmith/setup-app-requirements-txt) on using `pyproject.toml` for LangSmith.
* a monorepo: If you are interested in deploying a graph located inside a monorepo, take a look at [this repository](https://github.com/langchain-ai/langgraph-example-monorepo) for an example of how to do so.

After each step, an example file directory is provided to demonstrate how code can be organized.

## Specify dependencies

Dependencies can optionally be specified in one of the following files: `pyproject.toml`, `setup.py`, or `requirements.txt`. If none of these files is created, then dependencies can be specified later in the [configuration file](#create-the-configuration-file).

The dependencies below will be included in the image, you can also use them in your code, as long as with a compatible version range:

Example `requirements.txt` file:

Example file directory:

## Specify environment variables

Environment variables can optionally be specified in a file (e.g. `.env`). See the [Environment Variables reference](/langsmith/env-var) to configure additional variables for a deployment.

Example file directory:

<Tip>
  By default, LangSmith follows the `uv`/`pip` behavior of **not** installing prerelease versions unless explicitly allowed. If want to use prereleases, you have the following options:

* With `pyproject.toml`: add `allow-prereleases = true` to your `[tool.uv]` section.
  * With `requirements.txt` or `setup.py`: you must explicitly specify every prerelease dependency, including transitive ones. For example, if you declare `a==0.0.1a1` and `a` depends on `b==0.0.1a1`, then you must also explicitly include `b==0.0.1a1` in your dependencies.
</Tip>

Implement your graphs. Graphs can be defined in a single file or multiple files. Make note of the variable names of each [CompiledStateGraph](https://reference.langchain.com/python/langgraph/graphs/#langgraph.graph.state.CompiledStateGraph) to be included in the application. The variable names will be used later when creating the [LangGraph configuration file](/langsmith/cli#configuration-file).

Example `agent.py` file, which shows how to import from other modules you define (code for the modules is not shown here, please see [this repository](https://github.com/langchain-ai/langgraph-example) to see their implementation):

```python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
<Tip>
  LangSmith Deployment supports deploying a [LangGraph](/oss/python/langgraph/overview) *graph*. However, the implementation of a *node* of a graph can contain arbitrary Python code. This means any framework can be implemented within a node and deployed on LangSmith Deployment. This lets you keep your core application logic outside LangGraph while still using LangSmith for [deployment](/langsmith/deployments), scaling, and [observability](/langsmith/observability).
</Tip>

You can also set up with:

* `pyproject.toml`: If you prefer using poetry for dependency management, check out [this how-to guide](/langsmith/setup-app-requirements-txt) on using `pyproject.toml` for LangSmith.
* a monorepo: If you are interested in deploying a graph located inside a monorepo, take a look at [this repository](https://github.com/langchain-ai/langgraph-example-monorepo) for an example of how to do so.

After each step, an example file directory is provided to demonstrate how code can be organized.

## Specify dependencies

Dependencies can optionally be specified in one of the following files: `pyproject.toml`, `setup.py`, or `requirements.txt`. If none of these files is created, then dependencies can be specified later in the [configuration file](#create-the-configuration-file).

The dependencies below will be included in the image, you can also use them in your code, as long as with a compatible version range:
```

Example 2 (unknown):
```unknown
Example `requirements.txt` file:
```

Example 3 (unknown):
```unknown
Example file directory:
```

Example 4 (unknown):
```unknown
## Specify environment variables

Environment variables can optionally be specified in a file (e.g. `.env`). See the [Environment Variables reference](/langsmith/env-var) to configure additional variables for a deployment.

Example `.env` file:
```

---

## Trace with Google ADK

**URL:** llms-txt#trace-with-google-adk

**Contents:**
- Installation
- Setup
  - 1. Configure environment variables
  - 2. Configure OpenTelemetry integration

Source: https://docs.langchain.com/langsmith/trace-with-google-adk

LangSmith supports tracing Google Agent Development Kit (ADK) applications through the OpenTelemetry integration. This guide shows you how to automatically capture traces from your [Google ADK](https://github.com/google/adk-python) agents and send them to LangSmith for monitoring and analysis.

Install the required packages using your preferred package manager:

<Info>
  Requires LangSmith Python SDK version `langsmith>=0.4.26` for optimal OpenTelemetry support.
</Info>

### 1. Configure environment variables

Set your LangSmith API key and project name:

<CodeGroup>
  
</CodeGroup>

### 2. Configure OpenTelemetry integration

In your Google ADK application, import and configure the LangSmith OpenTelemetry integration. This will automatically instrument Google ADK spans for OpenTelemetry.

```python  theme={null}
from langsmith.integrations.otel import configure

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

<Info>
  Requires LangSmith Python SDK version `langsmith>=0.4.26` for optimal OpenTelemetry support.
</Info>

## Setup

### 1. Configure environment variables

Set your LangSmith API key and project name:

<CodeGroup>
```

Example 3 (unknown):
```unknown
</CodeGroup>

### 2. Configure OpenTelemetry integration

In your Google ADK application, import and configure the LangSmith OpenTelemetry integration. This will automatically instrument Google ADK spans for OpenTelemetry.
```

---

## Set the project name to whichever project you'd like to be testing against

**URL:** llms-txt#set-the-project-name-to-whichever-project-you'd-like-to-be-testing-against

project_name = "Tweet Writing Task"
os.environ["LANGSMITH_PROJECT"] = project_name
os.environ["LANGSMITH_TRACING"] = "true"

if not os.environ.get("LANGSMITH_API_KEY"):
    os.environ["LANGSMITH_API_KEY"] = getpass.getpass("YOUR API KEY")

---

## Agent harness capabilities

**URL:** llms-txt#agent-harness-capabilities

**Contents:**
- File system access
- Large tool result eviction
- Pluggable storage backends
- Task delegation (subagents)
- Conversation history summarization
- Dangling tool call repair
- To-do list tracking
- Human-in-the-Loop
- Prompt caching (Anthropic)

Source: https://docs.langchain.com/oss/python/deepagents/harness

We think of `deepagents` as an "agent harness". It is the same core tool calling loop as other agent frameworks, but with built-in tools and capabilities.

This page lists out the components that make up the agent harness.

## File system access

The harness provides six tools for file system operations, making files first-class citizens in the agent's environment:

| Tool         | Description                                                                                   |
| ------------ | --------------------------------------------------------------------------------------------- |
| `ls`         | List files in a directory with metadata (size, modified time)                                 |
| `read_file`  | Read file contents with line numbers, supports offset/limit for large files                   |
| `write_file` | Create new files                                                                              |
| `edit_file`  | Perform exact string replacements in files (with global replace mode)                         |
| `glob`       | Find files matching patterns (e.g., `**/*.py`)                                                |
| `grep`       | Search file contents with multiple output modes (files only, content with context, or counts) |

## Large tool result eviction

The harness automatically dumps large tool results to the file system when they exceed a token threshold, preventing context window saturation.

* Monitors tool call results for size (default threshold: 20,000 tokens)
* When exceeded, writes the result to a file instead
* Replaces the tool result with a concise reference to the file
* Agent can later read the file if needed

## Pluggable storage backends

The harness abstracts file system operations behind a protocol, allowing different storage strategies for different use cases.

**Available backends:**

1. **StateBackend** - Ephemeral in-memory storage
   * Files live in the agent's state (checkpointed with conversation)
   * Persists within a thread but not across threads
   * Useful for temporary working files

2. **FilesystemBackend** - Real filesystem access
   * Read/write from actual disk
   * Supports virtual mode (sandboxed to a root directory)
   * Integrates with system tools (ripgrep for grep)
   * Security features: path validation, size limits, symlink prevention

3. **StoreBackend** - Persistent cross-conversation storage
   * Uses LangGraph's BaseStore for durability
   * Namespaced per assistant\_id
   * Files persist across conversations
   * Useful for long-term memory or knowledge bases

4. **CompositeBackend** - Route different paths to different backends
   * Example: `/` → StateBackend, `/memories/` → StoreBackend
   * Longest-prefix matching for routing
   * Enables hybrid storage strategies

## Task delegation (subagents)

The harness allows the main agent to create ephemeral "subagents" for isolated multi-step tasks.

* **Context isolation** - Subagent's work doesn't clutter main agent's context
* **Parallel execution** - Multiple subagents can run concurrently
* **Specialization** - Subagents can have different tools/configurations
* **Token efficiency** - Large subtask context is compressed into a single result

* Main agent has a `task` tool
* When invoked, creates a fresh agent instance with its own context
* Subagent executes autonomously until completion
* Returns a single final report to the main agent
* Subagents are stateless (can't send multiple messages back)

**Default subagent:**

* "general-purpose" subagent automatically available
* Has filesystem tools by default
* Can be customized with additional tools/middleware

**Custom subagents:**

* Define specialized subagents with specific tools
* Example: code-reviewer, web-researcher, test-runner
* Configure via `subagents` parameter

## Conversation history summarization

The harness automatically compresses old conversation history when token usage becomes excessive.

* Triggers at 170,000 tokens
* Keeps the most recent 6 messages intact
* Older messages are summarized by the model

* Enables very long conversations without hitting context limits
* Preserves recent context while compressing ancient history
* Transparent to the agent (appears as a special system message)

## Dangling tool call repair

The harness fixes message history when tool calls are interrupted or cancelled before receiving results.

* Agent requests tool call: "Please run X"
* Tool call is interrupted (user cancels, error, etc.)
* Agent sees tool\_call in AIMessage but no corresponding ToolMessage
* This creates an invalid message sequence

* Detects AIMessages with tool\_calls that have no results
* Creates synthetic ToolMessage responses indicating the call was cancelled
* Repairs the message history before agent execution

* Prevents agent confusion from incomplete message chains
* Gracefully handles interruptions and errors
* Maintains conversation coherence

## To-do list tracking

The harness provides a `write_todos` tool that agents can use to maintain a structured task list.

* Track multiple tasks with statuses (pending, in\_progress, completed)
* Persisted in agent state
* Helps agent organize complex multi-step work
* Useful for long-running tasks and planning

The harness pauses agent execution at specified tool calls to allow human approval/modification.

* Map tool names to interrupt configurations
* Example: `{"edit_file": True}` - pause before every edit
* Can provide approval messages or modify tool inputs

* Safety gates for destructive operations
* User verification before expensive API calls
* Interactive debugging and guidance

## Prompt caching (Anthropic)

The harness enables Anthropic's prompt caching feature to reduce redundant token processing.

* Caches portions of the prompt that repeat across turns
* Significantly reduces latency and cost for long system prompts
* Automatically skips for non-Anthropic models

* System prompts (especially with filesystem docs) can be 5k+ tokens
* These repeat every turn without caching
* Caching provides \~10x speedup and cost reduction

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/deepagents/harness.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## How to evaluate an application's intermediate steps

**URL:** llms-txt#how-to-evaluate-an-application's-intermediate-steps

**Contents:**
- 1. Define your LLM pipeline
- 2. Create a dataset and examples to evaluate the pipeline
- 3. Define your custom evaluators
- 4. Evaluate the pipeline
- Related

Source: https://docs.langchain.com/langsmith/evaluate-on-intermediate-steps

While, in many scenarios, it is sufficient to evaluate the final output of your task, in some cases you might want to evaluate the intermediate steps of your pipeline.

For example, for retrieval-augmented generation (RAG), you might want to

1. Evaluate the retrieval step to ensure that the correct documents are retrieved w\.r.t the input query.
2. Evaluate the generation step to ensure that the correct answer is generated w\.r.t the retrieved documents.

In this guide, we will use a simple, fully-custom evaluator for evaluating criteria 1 and an LLM-based evaluator for evaluating criteria 2 to highlight both scenarios.

In order to evaluate the intermediate steps of your pipeline, your evaluator function should traverse and process the `run`/`rootRun` argument, which is a `Run` object that contains the intermediate steps of your pipeline.

## 1. Define your LLM pipeline

The below RAG pipeline consists of 1) generating a Wikipedia query given the input question, 2) retrieving relevant documents from Wikipedia, and 3) generating an answer given the retrieved documents.

Requires `langsmith>=0.3.13`

This pipeline will produce a trace that looks something like: <img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=3b691ca56f9d60035dcba2c248692fa1" alt="evaluation_intermediate_trace.png" data-og-width="2586" width="2586" data-og-height="1676" height="1676" data-path="langsmith/images/evaluation-intermediate-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=23a9b9abdb3e43e0f6326f0d4293ab7d 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4b771691bd1afffe9f371a105f7eaebe 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=beb01776de9a5fa663c82d4380bc78cd 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=ec84bd3345df3d2cef38878b902c355b 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=043a7f22da6b158e070c853d67bacd69 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=42a9ea799157fee30a6b243c02615a02 2500w" />

## 2. Create a dataset and examples to evaluate the pipeline

We are building a very simple dataset with a couple of examples to evaluate the pipeline.

Requires `langsmith>=0.3.13`

## 3. Define your custom evaluators

As mentioned above, we will define two evaluators: one that evaluates the relevance of the retrieved documents w\.r.t the input query and another that evaluates the hallucination of the generated answer w\.r.t the retrieved documents. We will be using LangChain LLM wrappers, along with [`with_structured_output`](https://python.langchain.com/v0.1/docs/modules/model_io/chat/structured_output/) to define the evaluator for hallucination.

The key here is that the evaluator function should traverse the `run` / `rootRun` argument to access the intermediate steps of the pipeline. The evaluator can then process the inputs and outputs of the intermediate steps to evaluate according to the desired criteria.

Example uses `langchain` for convenience, this is not required.

## 4. Evaluate the pipeline

Finally, we'll run `evaluate` with the custom evaluators defined above.

The experiment will contain the results of the evaluation, including the scores and comments from the evaluators: <img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=e926744573c6b9757ba22ff245a3da2c" alt="evaluation_intermediate_experiment.png" data-og-width="2446" width="2446" data-og-height="1244" height="1244" data-path="langsmith/images/evaluation-intermediate-experiment.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7b6e321b15a06b2adc7f1cacb8e07a35 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=c677007bcc1e2af4b3767d6b44fcb327 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=a39153399b6721b7c51693f5a59cf2b0 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=1132228eba6761a724ae98d85fcf536c 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=5d74785384737df0cf67145b397b1934 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-experiment.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=bef00e4bdc12289d9f1e4b77ed8489cf 2500w" />

* [Evaluate a `langgraph` graph](/langsmith/evaluate-on-intermediate-steps)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/evaluate-on-intermediate-steps.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

Requires `langsmith>=0.3.13`

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

This pipeline will produce a trace that looks something like: <img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=3b691ca56f9d60035dcba2c248692fa1" alt="evaluation_intermediate_trace.png" data-og-width="2586" width="2586" data-og-height="1676" height="1676" data-path="langsmith/images/evaluation-intermediate-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=23a9b9abdb3e43e0f6326f0d4293ab7d 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4b771691bd1afffe9f371a105f7eaebe 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=beb01776de9a5fa663c82d4380bc78cd 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=ec84bd3345df3d2cef38878b902c355b 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=043a7f22da6b158e070c853d67bacd69 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/evaluation-intermediate-trace.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=42a9ea799157fee30a6b243c02615a02 2500w" />

## 2. Create a dataset and examples to evaluate the pipeline

We are building a very simple dataset with a couple of examples to evaluate the pipeline.

Requires `langsmith>=0.3.13`

<CodeGroup>
```

---

## node_2 accepts private data from node_1, whereas

**URL:** llms-txt#node_2-accepts-private-data-from-node_1,-whereas

---

## Define a new graph

**URL:** llms-txt#define-a-new-graph

workflow = StateGraph(State)

---

## Agent Server

**URL:** llms-txt#agent-server

Source: https://docs.langchain.com/langsmith/agent-server-api-ref

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/agent-server-api-ref.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Rollback Concurrent

**URL:** llms-txt#rollback-concurrent

**Contents:**
- Setup
- Create runs
- View run results

Source: https://docs.langchain.com/langsmith/rollback-concurrent

This guide assumes knowledge of what double-texting is, which you can learn about in the [double-texting conceptual guide](/langsmith/double-texting).

The guide covers the `rollback` option for double texting, which interrupts the prior run of the graph and starts a new one with the double-text. This option is very similar to the `interrupt` option, but in this case the first run is completely deleted from the database and cannot be restarted. Below is a quick example of using the `rollback` option.

First, we will define a quick helper function for printing out JS and CURL model outputs (you can skip this if using Python):

<Tabs>
  <Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now let's run a thread with the multitask parameter set to "rollback":

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

We can see that the thread has data only from the second run

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Verify that the original, rolled back run was deleted

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>
</Tabs>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/rollback-concurrent.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="Javascript">
```

Example 4 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

---

## Invoke the graph

**URL:** llms-txt#invoke-the-graph

config = {"configurable": {"thread_id": "2", "user_id": "1"}}

---

## Since this is **more specific** than the generic @auth.on handler, it will take precedence

**URL:** llms-txt#since-this-is-**more-specific**-than-the-generic-@auth.on-handler,-it-will-take-precedence

---

## Set stream_mode="custom" to receive the custom data in the stream

**URL:** llms-txt#set-stream_mode="custom"-to-receive-the-custom-data-in-the-stream

**Contents:**
- Disable streaming for specific chat models
  - Async with Python \< 3.11

for chunk in graph.stream(
    {"topic": "cats"},
    stream_mode="custom",  # [!code highlight]

):
    # The chunk will contain the custom data streamed from the llm
    print(chunk)
python  theme={null}
  import operator
  import json

from typing import TypedDict
  from typing_extensions import Annotated
  from langgraph.graph import StateGraph, START

from openai import AsyncOpenAI

openai_client = AsyncOpenAI()
  model_name = "gpt-4o-mini"

async def stream_tokens(model_name: str, messages: list[dict]):
      response = await openai_client.chat.completions.create(
          messages=messages, model=model_name, stream=True
      )
      role = None
      async for chunk in response:
          delta = chunk.choices[0].delta

if delta.role is not None:
              role = delta.role

if delta.content:
              yield {"role": role, "content": delta.content}

# this is our tool
  async def get_items(place: str) -> str:
      """Use this tool to list items one might find in a place you're asked about."""
      writer = get_stream_writer()
      response = ""
      async for msg_chunk in stream_tokens(
          model_name,
          [
              {
                  "role": "user",
                  "content": (
                      "Can you tell me what kind of items "
                      f"i might find in the following place: '{place}'. "
                      "List at least 3 such items separating them by a comma. "
                      "And include a brief description of each item."
                  ),
              }
          ],
      ):
          response += msg_chunk["content"]
          writer(msg_chunk)

class State(TypedDict):
      messages: Annotated[list[dict], operator.add]

# this is the tool-calling graph node
  async def call_tool(state: State):
      ai_message = state["messages"][-1]
      tool_call = ai_message["tool_calls"][-1]

function_name = tool_call["function"]["name"]
      if function_name != "get_items":
          raise ValueError(f"Tool {function_name} not supported")

function_arguments = tool_call["function"]["arguments"]
      arguments = json.loads(function_arguments)

function_response = await get_items(**arguments)
      tool_message = {
          "tool_call_id": tool_call["id"],
          "role": "tool",
          "name": function_name,
          "content": function_response,
      }
      return {"messages": [tool_message]}

graph = (
      StateGraph(State)
      .add_node(call_tool)
      .add_edge(START, "call_tool")
      .compile()
  )
  python  theme={null}
  inputs = {
      "messages": [
          {
              "content": None,
              "role": "assistant",
              "tool_calls": [
                  {
                      "id": "1",
                      "function": {
                          "arguments": '{"place":"bedroom"}',
                          "name": "get_items",
                      },
                      "type": "function",
                  }
              ],
          }
      ]
  }

async for chunk in graph.astream(
      inputs,
      stream_mode="custom",
  ):
      print(chunk["content"], end="|", flush=True)
  python  theme={null}
    from langchain.chat_models import init_chat_model

model = init_chat_model(
        "claude-sonnet-4-5-20250929",
        # Set disable_streaming=True to disable streaming for the chat model
        disable_streaming=True  # [!code highlight]

)
    python  theme={null}
    from langchain_openai import ChatOpenAI

# Set disable_streaming=True to disable streaming for the chat model
    model = ChatOpenAI(model="o1-preview", disable_streaming=True)
    python  theme={null}
  from typing import TypedDict
  from langgraph.graph import START, StateGraph
  from langchain.chat_models import init_chat_model

model = init_chat_model(model="gpt-4o-mini")

class State(TypedDict):
      topic: str
      joke: str

# Accept config as an argument in the async node function
  async def call_model(state, config):
      topic = state["topic"]
      print("Generating joke...")
      # Pass config to model.ainvoke() to ensure proper context propagation
      joke_response = await model.ainvoke(  # [!code highlight]
          [{"role": "user", "content": f"Write a joke about {topic}"}],
          config,
      )
      return {"joke": joke_response.content}

graph = (
      StateGraph(State)
      .add_node(call_model)
      .add_edge(START, "call_model")
      .compile()
  )

# Set stream_mode="messages" to stream LLM tokens
  async for chunk, metadata in graph.astream(
      {"topic": "ice cream"},
      stream_mode="messages",  # [!code highlight]
  ):
      if chunk.content:
          print(chunk.content, end="|", flush=True)
  python  theme={null}
  from typing import TypedDict
  from langgraph.types import StreamWriter

class State(TypedDict):
        topic: str
        joke: str

# Add writer as an argument in the function signature of the async node or tool
  # LangGraph will automatically pass the stream writer to the function
  async def generate_joke(state: State, writer: StreamWriter):  # [!code highlight]
        writer({"custom_key": "Streaming custom data while generating a joke"})
        return {"joke": f"This is a joke about {state['topic']}"}

graph = (
        StateGraph(State)
        .add_node(generate_joke)
        .add_edge(START, "generate_joke")
        .compile()
  )

# Set stream_mode="custom" to receive the custom data in the stream  # [!code highlight]
  async for chunk in graph.astream(
        {"topic": "ice cream"},
        stream_mode="custom",
  ):
        print(chunk)
  ```
</Accordion>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langgraph/streaming.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Extended example: streaming arbitrary chat model">
```

Example 2 (unknown):
```unknown
Let's invoke the graph with an [`AIMessage`](https://reference.langchain.com/python/langchain/messages/#langchain.messages.AIMessage) that includes a tool call:
```

Example 3 (unknown):
```unknown
</Accordion>

## Disable streaming for specific chat models

If your application mixes models that support streaming with those that do not, you may need to explicitly disable streaming for
models that do not support it.

Set `disable_streaming=True` when initializing the model.

<Tabs>
  <Tab title="init_chat_model">
```

Example 4 (unknown):
```unknown
</Tab>

  <Tab title="Chat model interface">
```

---

## my_agent/agent.py

**URL:** llms-txt#my_agent/agent.py

from typing import Literal
from typing_extensions import TypedDict

from langgraph.graph import StateGraph, END, START
from my_agent.utils.nodes import call_model, should_continue, tool_node # import nodes
from my_agent.utils.state import AgentState # import state

---

## How to read experiment results locally

**URL:** llms-txt#how-to-read-experiment-results-locally

**Contents:**
- Iterate over evaluation results

Source: https://docs.langchain.com/langsmith/read-local-experiment-results

When running [evaluations](/langsmith/evaluation-concepts), you may want to process results programmatically in your script rather than viewing them in the [LangSmith UI](https://smith.langchain.com). This is useful for scenarios like:

* **CI/CD pipelines**: Implement quality gates that fail builds if evaluation scores drop below a threshold.
* **Local debugging**: Inspect and analyze results without API calls.
* **Custom aggregations**: Calculate metrics and statistics using your own logic.
* **Integration testing**: Use evaluation results to gate merges or deployments.

This guide shows you how to iterate over and process [experiment](/langsmith/evaluation-concepts#experiment) results from the [`ExperimentResults`](https://reference.langchain.com/python/langsmith/observability/sdk/evaluation/#langsmith.evaluation._runner.ExperimentResults) object returned by [`Client.evaluate()`](https://reference.langchain.com/python/langsmith/observability/sdk/client/#langsmith.client.Client.evaluate).

<Note>
  This page focuses on processing results programmatically while still uploading them to LangSmith.

If you want to run evaluations locally **without** recording anything to LangSmith (for quick testing or validation), refer to [Run an evaluation locally](/langsmith/local) which uses `upload_results=False`.
</Note>

## Iterate over evaluation results

The [`evaluate()`](https://reference.langchain.com/python/langsmith/observability/sdk/client/#langsmith.client.Client.evaluate) function returns an [`ExperimentResults`](https://reference.langchain.com/python/langsmith/observability/sdk/evaluation/#langsmith.evaluation._runner.ExperimentResults) object that you can iterate over. The `blocking` parameter controls when results become available:

* `blocking=False`: Returns immediately with an iterator that yields results as they're produced. This allows you to process results in real-time as the evaluation runs.
* `blocking=True` (default): Blocks until all evaluations complete before returning. When you iterate over the results, all data is already available.

Both modes return the same `ExperimentResults` type; the difference is whether the function waits for completion before returning. Use `blocking=False` for streaming and real-time debugging, or `blocking=True` for batch processing when you need the complete dataset.

The following example demonstrates `blocking=False`. It iterates over results as they stream in, collects them in a list, then processes them in a separate loop:

```python  theme={null}
from langsmith import Client
import random

def target(inputs):
    """Your application or LLM chain"""
    return {"output": "MY OUTPUT"}

def evaluator(run, example):
    """Your evaluator function"""
    return {"key": "randomness", "score": random.randint(0, 1)}

---

## Thread creation. This will match only on thread create actions

**URL:** llms-txt#thread-creation.-this-will-match-only-on-thread-create-actions

---

## Run evaluation

**URL:** llms-txt#run-evaluation

results = client.evaluate(
    my_application,
    data="my_test_dataset",
    evaluators=[accuracy_evaluator],
    blocking=False
)

---

## Compile

**URL:** llms-txt#compile

**Contents:**
  - 1. Run the graph

checkpointer = InMemorySaver()
graph = workflow.compile(checkpointer=checkpointer)
graph
python  theme={null}
config = {
    "configurable": {
        "thread_id": uuid.uuid4(),
    }
}
state = graph.invoke({}, config)

print(state["topic"])
print()
print(state["joke"])

How about "The Secret Life of Socks in the Dryer"? You know, exploring the mysterious phenomenon of how socks go into the laundry as pairs but come out as singles. Where do they go? Are they starting new lives elsewhere? Is there a sock paradise we don't know about? There's a lot of comedic potential in the everyday mystery that unites us all!

**Examples:**

Example 1 (unknown):
```unknown
### 1. Run the graph
```

Example 2 (unknown):
```unknown
**Output:**
```

---

## 3. Pass in configuration at runtime:

**URL:** llms-txt#3.-pass-in-configuration-at-runtime:

**Contents:**
- Add retry policies
- Add node caching
- Create a sequence of steps

print(graph.invoke({}, context={"my_runtime_value": "a"}))  # [!code highlight]
print(graph.invoke({}, context={"my_runtime_value": "b"}))  # [!code highlight]

{'my_state_value': 1}
{'my_state_value': 2}
python  theme={null}
  from dataclasses import dataclass

from langchain.chat_models import init_chat_model
  from langgraph.graph import MessagesState, END, StateGraph, START
  from langgraph.runtime import Runtime
  from typing_extensions import TypedDict

@dataclass
  class ContextSchema:
      model_provider: str = "anthropic"

MODELS = {
      "anthropic": init_chat_model("claude-haiku-4-5-20251001"),
      "openai": init_chat_model("gpt-4.1-mini"),
  }

def call_model(state: MessagesState, runtime: Runtime[ContextSchema]):
      model = MODELS[runtime.context.model_provider]
      response = model.invoke(state["messages"])
      return {"messages": [response]}

builder = StateGraph(MessagesState, context_schema=ContextSchema)
  builder.add_node("model", call_model)
  builder.add_edge(START, "model")
  builder.add_edge("model", END)

graph = builder.compile()

# Usage
  input_message = {"role": "user", "content": "hi"}
  # With no configuration, uses default (Anthropic)
  response_1 = graph.invoke({"messages": [input_message]}, context=ContextSchema())["messages"][-1]
  # Or, can set OpenAI
  response_2 = graph.invoke({"messages": [input_message]}, context={"model_provider": "openai"})["messages"][-1]

print(response_1.response_metadata["model_name"])
  print(response_2.response_metadata["model_name"])
  
  claude-haiku-4-5-20251001
  gpt-4.1-mini-2025-04-14
  python  theme={null}
  from dataclasses import dataclass
  from langchain.chat_models import init_chat_model
  from langchain.messages import SystemMessage
  from langgraph.graph import END, MessagesState, StateGraph, START
  from langgraph.runtime import Runtime
  from typing_extensions import TypedDict

@dataclass
  class ContextSchema:
      model_provider: str = "anthropic"
      system_message: str | None = None

MODELS = {
      "anthropic": init_chat_model("claude-haiku-4-5-20251001"),
      "openai": init_chat_model("gpt-4.1-mini"),
  }

def call_model(state: MessagesState, runtime: Runtime[ContextSchema]):
      model = MODELS[runtime.context.model_provider]
      messages = state["messages"]
      if (system_message := runtime.context.system_message):
          messages = [SystemMessage(system_message)] + messages
      response = model.invoke(messages)
      return {"messages": [response]}

builder = StateGraph(MessagesState, context_schema=ContextSchema)
  builder.add_node("model", call_model)
  builder.add_edge(START, "model")
  builder.add_edge("model", END)

graph = builder.compile()

# Usage
  input_message = {"role": "user", "content": "hi"}
  response = graph.invoke({"messages": [input_message]}, context={"model_provider": "openai", "system_message": "Respond in Italian."})
  for message in response["messages"]:
      message.pretty_print()
  
  ================================ Human Message ================================

hi
  ================================== Ai Message ==================================

Ciao! Come posso aiutarti oggi?
  python  theme={null}
from langgraph.types import RetryPolicy

builder.add_node(
    "node_name",
    node_function,
    retry_policy=RetryPolicy(),
)
python  theme={null}
  import sqlite3
  from typing_extensions import TypedDict
  from langchain.chat_models import init_chat_model
  from langgraph.graph import END, MessagesState, StateGraph, START
  from langgraph.types import RetryPolicy
  from langchain_community.utilities import SQLDatabase
  from langchain.messages import AIMessage

db = SQLDatabase.from_uri("sqlite:///:memory:")
  model = init_chat_model("claude-haiku-4-5-20251001")

def query_database(state: MessagesState):
      query_result = db.run("SELECT * FROM Artist LIMIT 10;")
      return {"messages": [AIMessage(content=query_result)]}

def call_model(state: MessagesState):
      response = model.invoke(state["messages"])
      return {"messages": [response]}

# Define a new graph
  builder = StateGraph(MessagesState)
  builder.add_node(
      "query_database",
      query_database,
      retry_policy=RetryPolicy(retry_on=sqlite3.OperationalError),
  )
  builder.add_node("model", call_model, retry_policy=RetryPolicy(max_attempts=5))
  builder.add_edge(START, "model")
  builder.add_edge("model", "query_database")
  builder.add_edge("query_database", END)
  graph = builder.compile()
  python  theme={null}
from langgraph.types import CachePolicy

builder.add_node(
    "node_name",
    node_function,
    cache_policy=CachePolicy(ttl=120),
)
python  theme={null}
from langgraph.cache.memory import InMemoryCache

graph = builder.compile(cache=InMemoryCache())
python  theme={null}
from langgraph.graph import START, StateGraph

builder = StateGraph(State)

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
<Accordion title="Extended example: specifying LLM at runtime">
  Below we demonstrate a practical example in which we configure what LLM to use at runtime. We will use both OpenAI and Anthropic models.
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</Accordion>

<Accordion title="Extended example: specifying model and system message at runtime">
  Below we demonstrate a practical example in which we configure two parameters: the LLM and system message to use at runtime.
```

---

## Use webhooks

**URL:** llms-txt#use-webhooks

**Contents:**
- Supported endpoints
- Set up your assistant and thread
- Use a webhook with a graph run
- Webhook payload
- Secure webhooks
- Disable webhooks
- Test webhooks

Source: https://docs.langchain.com/langsmith/use-webhooks

Webhooks enable event-driven communication from your LangSmith application to external services. For example, you may want to issue an update to a separate service once an API call to LangSmith has finished running.

Many LangSmith endpoints accept a `webhook` parameter. If this parameter is specified by an endpoint that can accept POST requests, LangSmith will send a request at the completion of a run.

When working with LangSmith, you may want to use webhooks to receive updates after an API call completes. Webhooks are useful for triggering actions in your service once a run has finished processing. To implement this, you need to expose an endpoint that can accept `POST` requests and pass this endpoint as a `webhook` parameter in your API request.

Currently, the SDK does not provide built-in support for defining webhook endpoints, but you can specify them manually using API requests.

## Supported endpoints

The following API endpoints accept a `webhook` parameter:

| Operation            | HTTP Method | Endpoint                          |
| -------------------- | ----------- | --------------------------------- |
| Create Run           | `POST`      | `/thread/{thread_id}/runs`        |
| Create Thread Cron   | `POST`      | `/thread/{thread_id}/runs/crons`  |
| Stream Run           | `POST`      | `/thread/{thread_id}/runs/stream` |
| Wait Run             | `POST`      | `/thread/{thread_id}/runs/wait`   |
| Create Cron          | `POST`      | `/runs/crons`                     |
| Stream Run Stateless | `POST`      | `/runs/stream`                    |
| Wait Run Stateless   | `POST`      | `/runs/wait`                      |

In this guide, we’ll show how to trigger a webhook after streaming a run.

## Set up your assistant and thread

Before making API calls, set up your assistant and thread.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="JavaScript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

## Use a webhook with a graph run

To use a webhook, specify the `webhook` parameter in your API request. When the run completes, LangSmith sends a `POST` request to the specified webhook URL.

For example, if your server listens for webhook events at `https://my-server.app/my-webhook-endpoint`, include this in your request:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="JavaScript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

LangSmith sends webhook notifications in the format of a [Run](/langsmith/assistants#execution). See the [API Reference](https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref.html#tag/assistants) for details. The request payload includes run input, configuration, and other metadata in the `kwargs` field.

To ensure only authorized requests hit your webhook endpoint, consider adding a security token as a query parameter:

Your server should extract and validate this token before processing requests.

As of `langgraph-api>=0.2.78`, developers can disable webhooks in the `langgraph.json` file:

This feature is primarily intended for self-hosted deployments, where platform administrators or developers may prefer to disable webhooks to simplify their security posture—especially if they are not configuring firewall rules or other network controls. Disabling webhooks helps prevent untrusted payloads from being sent to internal endpoints.

For full configuration details, refer to the [configuration file reference](/langsmith/cli?h=disable_webhooks#configuration-file).

You can test your webhook using online services like:

* **[Beeceptor](https://beeceptor.com/)** – Quickly create a test endpoint and inspect incoming webhook payloads.
* **[Webhook.site](https://webhook.site/)** – View, debug, and log incoming webhook requests in real time.

These tools help you verify that LangSmith is correctly triggering and sending webhooks to your service.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/use-webhooks.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="JavaScript">
```

Example 2 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

Example 3 (unknown):
```unknown
</Tab>
</Tabs>

Example response:
```

Example 4 (unknown):
```unknown
## Use a webhook with a graph run

To use a webhook, specify the `webhook` parameter in your API request. When the run completes, LangSmith sends a `POST` request to the specified webhook URL.

For example, if your server listens for webhook events at `https://my-server.app/my-webhook-endpoint`, include this in your request:

<Tabs>
  <Tab title="Python">
```

---

## No longer supported

**URL:** llms-txt#no-longer-supported

model_with_tools = ChatOpenAI().bind_tools([some_tool])
agent = create_agent(model_with_tools, tools=[])

---

## Create a documentation generator

**URL:** llms-txt#create-a-documentation-generator

**Contents:**
- Advanced usage
  - Custom metadata and tags

doc_prompt = """
Generate comprehensive documentation for the following function:

Include:
- Purpose and functionality
- Parameters and return values
- Usage examples
- Any important notes
"""

doc_template_config = PromptTemplateConfig(
    template=doc_prompt,
    name="doc_generator",
    template_format="semantic-kernel",
    input_variables=[
        InputVariable(name="function_code", description="The function code to document", is_required=True),
    ],
)

doc_generator = kernel.add_function(
    function_name="generateDocs",
    plugin_name="documentationPlugin",
    prompt_template_config=doc_template_config,
)

async def main():
    # Example code to analyze
    sample_code = """
def fibonacci(n):
    if n <= 1:
        return n
    return fibonacci(n-1) + fibonacci(n-2)
    """

# Analyze the code
    analysis_result = await kernel.invoke(code_analyzer, code=sample_code)
    print("Code Analysis:")
    print(analysis_result)
    print("\n" + "="*50 + "\n")

# Generate documentation
    doc_result = await kernel.invoke(doc_generator, function_code=sample_code)
    print("Generated Documentation:")
    print(doc_result)

return {"analysis": str(analysis_result), "documentation": str(doc_result)}

if __name__ == "__main__":
    asyncio.run(main())
python  theme={null}
from opentelemetry import trace

**Examples:**

Example 1 (unknown):
```unknown
## Advanced usage

### Custom metadata and tags

You can add custom metadata to your traces by setting span attributes:
```

---

## Use an existing secret for your installation (Kubernetes)

**URL:** llms-txt#use-an-existing-secret-for-your-installation-(kubernetes)

**Contents:**
- Requirements
- Parameters
- Configuration

Source: https://docs.langchain.com/langsmith/self-host-using-an-existing-secret

By default, LangSmith will provision several Kubernetes secrets to store sensitive information such as license keys, salts, and other configuration parameters. However, you may want to use an existing secret that you have already created in your Kubernetes cluster (or provisioned via some sort of secrets operator). This can be useful if you want to manage sensitive information in a centralized way or if you have specific security requirements.

By default we will provision the following secrets corresponding to different components of LangSmith:

* `langsmith-secrets`: This secret contains the license key and some other basic configuration parameters. You can see the template for this secret [here](https://github.com/langchain-ai/helm/blob/main/charts/langsmith/templates/secrets.yaml)
* `langsmith-redis`: This secret contains the Redis connection string and password. You can see the template for this secret [here](https://github.com/langchain-ai/helm/blob/main/charts/langsmith/templates/redis/secrets.yaml)
* `langsmith-postgres`: This secret contains the Postgres connection string and password. You can see the template for this secret [here](https://github.com/langchain-ai/helm/blob/main/charts/langsmith/templates/postgres/secrets.yaml)
* `langsmith-clickhouse`: This secret contains the ClickHouse connection string and password. You can see the template for this secret [here](https://github.com/langchain-ai/helm/blob/main/charts/langsmith/templates/clickhouse/secrets.yaml)

* An existing Kubernetes cluster
* A way to create Kubernetes secrets in your cluster. This can be done using `kubectl`, a Helm chart, or a secrets operator like [Sealed Secrets](https://github.com/bitnami-labs/sealed-secrets)

You will need to create your own Kubernetes secrets that adhere to the structure of the secrets provisioned by the LangSmith Helm Chart.

<Warning>
  The secrets must have the same structure as the ones provisioned by the LangSmith Helm Chart (refer to the links above to see the specific secrets). If you miss any of the required keys, your LangSmith instance may not work correctly.
</Warning>

An example secret may look like this:

With these secrets provisioned, you can configure your LangSmith instance to use the secrets directly to avoid passing in secret values through plaintext. You can do this by modifying the `langsmith_config.yaml` file for your LangSmith Helm Chart installation.

Once configured, you will need to update your LangSmith installation. You can follow our upgrade guide [here](/langsmith/self-host-upgrades). If everything is configured correctly, your LangSmith instance should now be accessible via the Ingress. You can run the following to check that your secrets are being used correctly:

You should see something like this in the output:

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/self-host-using-an-existing-secret.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
## Configuration

With these secrets provisioned, you can configure your LangSmith instance to use the secrets directly to avoid passing in secret values through plaintext. You can do this by modifying the `langsmith_config.yaml` file for your LangSmith Helm Chart installation.
```

Example 2 (unknown):
```unknown
Once configured, you will need to update your LangSmith installation. You can follow our upgrade guide [here](/langsmith/self-host-upgrades). If everything is configured correctly, your LangSmith instance should now be accessible via the Ingress. You can run the following to check that your secrets are being used correctly:
```

Example 3 (unknown):
```unknown
You should see something like this in the output:
```

---

## How to create and manage datasets programmatically

**URL:** llms-txt#how-to-create-and-manage-datasets-programmatically

**Contents:**
- Create a dataset
  - Create a dataset from list of values
  - Create a dataset from traces
  - Create a dataset from a CSV file
  - Create a dataset from pandas DataFrame (Python only)
- Fetch datasets
  - Query all datasets
  - List datasets by name
  - List datasets by type
- Fetch examples

Source: https://docs.langchain.com/langsmith/manage-datasets-programmatically

You can use the Python and TypeScript SDK to manage datasets programmatically. This includes creating, updating, and deleting datasets, as well as adding examples to them.

### Create a dataset from list of values

The most flexible way to make a dataset using the client is by creating examples from a list of inputs and optional outputs. Below is an example.

Note that you can add arbitrary metadata to each example, such as a note or a source. The metadata is stored as a dictionary.

<Check>
  If you have many examples to create, consider using the `create_examples`/`createExamples` method to create multiple examples in a single request. If creating a single example, you can use the `create_example`/`createExample` method.
</Check>

### Create a dataset from traces

To create datasets from the runs (spans) of your traces, you can use the same approach. For **many** more examples of how to fetch and filter runs, see the [export traces](/langsmith/export-traces) guide. Below is an example:

### Create a dataset from a CSV file

In this section, we will demonstrate how you can create a dataset by uploading a CSV file.

First, ensure your CSV file is properly formatted with columns that represent your input and output keys. These keys will be utilized to map your data properly during the upload. You can specify an optional name and description for your dataset. Otherwise, the file name will be used as the dataset name and no description will be provided.

### Create a dataset from pandas DataFrame (Python only)

The python client offers an additional convenience method to upload a dataset from a pandas dataframe.

You can programmatically fetch datasets from LangSmith using the `list_datasets`/`listDatasets` method in the Python and TypeScript SDKs. Below are some common calls.

<Info>
  Initialize the client before running the below code snippets.
</Info>

### Query all datasets

### List datasets by name

If you want to search by the exact name, you can do the following:

If you want to do a case-invariant substring search, try the following:

### List datasets by type

You can filter datasets by type. Below is an example querying for chat datasets.

You can programmatically fetch examples from LangSmith using the `list_examples`/`listExamples` method in the Python and TypeScript SDKs. Below are some common calls.

<Info>
  Initialize the client before running the below code snippets.
</Info>

### List all examples for a dataset

You can filter by dataset ID:

Or you can filter by dataset name (this must exactly match the dataset name you want to query)

### List examples by id

You can also list multiple examples all by ID.

### List examples by metadata

You can also filter examples by metadata. Below is an example querying for examples with a specific metadata key-value pair. Under the hood, we check to see if the example's metadata contains the key-value pair(s) you specify.

For example, if you have an example with metadata `{"foo": "bar", "baz": "qux"}`, both `{foo: bar}` and `{baz: qux}` would match, as would `{foo: bar, baz: qux}`.

### List examples by structured filter

Similar to how you can use the structured filter query language to [fetch runs](/langsmith/export-traces#use-filter-query-language), you can use it to fetch examples.

<Note>
  This is currently only available in v0.1.83 and later of the Python SDK and v0.1.35 and later of the TypeScript SDK.

Additionally, the structured filter query language is only supported for `metadata` fields.
</Note>

You can use the `has` operator to fetch examples with metadata fields that contain specific key/value pairs and the `exists` operator to fetch examples with metadata fields that contain a specific key. Additionally, you can also chain multiple filters together using the `and` operator and negate a filter using the `not` operator.

### Update single example

You can programmatically update examples from LangSmith using the `update_example`/`updateExample` method in the Python and TypeScript SDKs. Below is an example.

### Bulk update examples

You can also programmatically update multiple examples in a single request with the `update_examples`/`updateExamples` method in the Python and TypeScript SDKs. Below is an example.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/manage-datasets-programmatically.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

### Create a dataset from traces

To create datasets from the runs (spans) of your traces, you can use the same approach. For **many** more examples of how to fetch and filter runs, see the [export traces](/langsmith/export-traces) guide. Below is an example:

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

### Create a dataset from a CSV file

In this section, we will demonstrate how you can create a dataset by uploading a CSV file.

First, ensure your CSV file is properly formatted with columns that represent your input and output keys. These keys will be utilized to map your data properly during the upload. You can specify an optional name and description for your dataset. Otherwise, the file name will be used as the dataset name and no description will be provided.

<CodeGroup>
```

---

## Assistants

**URL:** llms-txt#assistants

**Contents:**
- Configuration
- Versioning
- Execution
- Video guide

Source: https://docs.langchain.com/langsmith/assistants

**Assistants** allow you to manage configurations (like prompts, LLM selection, tools) separately from your graph's core logic, enabling rapid changes that don't alter the graph architecture. It is a way to create multiple specialized versions of the same graph architecture, each optimized for different use cases through configuration variations rather than structural changes.

For example, imagine a general-purpose writing agent built on a common graph architecture. While the structure remains the same, different writing styles—such as blog posts and tweets—require tailored configurations to optimize performance. To support these variations, you can create multiple assistants (e.g., one for blogs and another for tweets) that share the underlying graph but differ in model selection and system prompt.

<img src="https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=05402316c8fe86fead077ec774e873f0" alt="assistant versions" data-og-width="1824" width="1824" data-og-height="692" height="692" data-path="langsmith/images/assistants.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=280&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=3ac250197ee8463950b74dc5f6bcd37f 280w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=560&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=d6b01c6ae96bd96b580bf43228610224 560w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=840&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=6125bf9aed49385ec8422e27cb377dad 840w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=1100&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=c54cde5d8a052ceac26d67131407aa73 1100w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=1650&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=780c08f1695bc2e5ba0b6261febb1954 1650w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/assistants.png?w=2500&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=ed8fba40ce7c1b3455027df735f9bdba 2500w" />

The LangGraph API provides several endpoints for creating and managing assistants and their versions. See the [API reference](https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref/#tag/assistants) for more details.

<Info>
  Assistants are a [LangSmith](/langsmith/home) concept. They are not available in the open source LangGraph library.
</Info>

Assistants build on the LangGraph open source concept of [configuration](/oss/python/langgraph/graph-api#runtime-context).

While configuration is available in the open source LangGraph library, assistants are only present in [LangSmith](/langsmith/home). This is due to the fact that assistants are tightly coupled to your deployed graph. Upon deployment, Agent Server will automatically create a default assistant for each graph using the graph's default configuration settings.

In practice, an assistant is just an *instance* of a graph with a specific configuration. Therefore, multiple assistants can reference the same graph but can contain different configurations (e.g. prompts, models, tools). The LangSmith Deployment API provides several endpoints for creating and managing assistants. See the [API reference](https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref/) and [this how-to](/langsmith/configuration-cloud) for more details on how to create assistants.

Assistants support versioning to track changes over time.
Once you've created an assistant, subsequent edits to that assistant will create new versions. See [this how-to](/langsmith/configuration-cloud#create-a-new-version-for-your-assistant) for more details on how to manage assistant versions.

A **run** is an invocation of an assistant. Each run may have its own input, configuration, and metadata, which may affect execution and output of the underlying graph. A run can optionally be executed on a [thread](/oss/python/langgraph/persistence#threads).

LangSmith API provides several endpoints for creating and managing runs. See the [API reference](https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref/) for more details.

<iframe className="w-full aspect-video rounded-xl" src="https://www.youtube.com/embed/fMsQX6pwXkE?si=6Q28l0taGOynO7sU" title="YouTube video player" frameBorder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowFullScreen />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/assistants.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Create and manage datasets in the UI

**URL:** llms-txt#create-and-manage-datasets-in-the-ui

**Contents:**
- Create a dataset and add examples
  - Manually from a tracing project
  - Automatically from a tracing project
  - From examples in an Annotation Queue
  - From the Prompt Playground
  - Import a dataset from a CSV or JSONL file
  - Create a new dataset from the Datasets & Experiments page
  - Add synthetic examples created by an LLM
- Manage a dataset
  - Create a dataset schema

Source: https://docs.langchain.com/langsmith/manage-datasets-in-application

[*Datasets*](/langsmith/evaluation-concepts#datasets) enable you to perform repeatable evaluations over time using consistent data. Datasets are made up of [*examples*](/langsmith/evaluation-concepts#examples), which store inputs, outputs, and optionally, reference outputs.

This page outlines the various methods for [creating](#create-a-dataset-and-add-examples) and [managing](#manage-a-dataset) datasets in the [LangSmith UI](https://smith.langchain.com).

## Create a dataset and add examples

The following sections explain the different ways you can create a dataset in LangSmith and add examples to it. Depending on your workflow, you can manually curate examples, automatically capture them from tracing, import files, or even generate synthetic data:

* [Manually from a tracing project](#manually-from-a-tracing-project)
* [Automatically from a tracing project](#automatically-from-a-tracing-project)
* [From examples in an Annotation Queue](#from-examples-in-an-annotation-queue)
* [From the Prompt Playground](#from-the-prompt-playground)
* [Import a dataset from a CSV or JSONL file](#import-a-dataset-from-a-csv-or-jsonl-file)
* [Create a new dataset from the dataset page](#create-a-new-dataset-from-the-dataset-page)
* [Add synthetic examples created by an LLM via the Datasets UI](#add-synthetic-examples-created-by-an-llm-via-the-datasets-ui)

### Manually from a tracing project

A common pattern for constructing datasets is to convert notable traces from your application into dataset examples. This approach requires that you have [configured tracing to LangSmith](/langsmith/observability-concepts#tracing-configuration).

<Check>
  A technique to build datasets is to filter the most interesting traces, such as traces that were tagged with poor user feedback, and add them to a dataset. For tips on how to filter traces, refer to [Filter traces](/langsmith/filter-traces-in-application) guide.
</Check>

There are two ways to add data manually from a tracing project to datasets. Navigate to **Tracing Projects** and select a project.

1. Multi-select runs from the runs table. On the **Runs** tab, multi-select runs. At the bottom of the page, click <Icon icon="database" /> **Add to Dataset**.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=fe666b6e1888554d0573df770bd9cda2" alt="The Runs table with a run selected and the Add to Dataset button visible at the bottom of the page." data-og-width="2912" width="2912" data-og-height="1464" height="1464" data-path="langsmith/images/multiselect-add-to-dataset.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=2a5526d48109c7e33cb5b72f19c0ae2d 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=0434d04eb3c301ea49a369e5def47701 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=3f0d3184b1dea71c3794ba653637a513 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=69e347a4a8f26bf7343ba05e88d9fe24 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=e4187008b9cc8f5936b7d64251d4641b 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multiselect-add-to-dataset.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=9419ca3c63abd40cfb899c5cffc36e33 2500w" />

2. On the **Runs** tab, select a run from the table. On the individual run details page, select  **Add to** -> **Dataset** in the top right corner.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=fd03b2cf578c3e524223afc5b09d0589" alt="Add to dataset" data-og-width="2898" width="2898" data-og-height="1462" height="1462" data-path="langsmith/images/add-to..dataset.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=70baaf45d7471f218c95af5ee77530d8 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=dd8fcd49d9b39e3937c3abcb0b2afc31 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=9477bdbe20caa5ccdb50ea1e4e18f234 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8c527bf07a2e032583496c9ba4ddf0c5 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=1c538e79a32bc8bb0e6458f1bf7a2276 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to..dataset.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=7a739ceda9692ae6661ce365a9ca46ce 2500w" />

When you select a dataset from the run details page, a modal will pop up letting you know if any [transformations](/langsmith/dataset-transformations) were applied or if schema validation failed. For example, the screenshot below shows a dataset that is using transformations to optimize for collecting LLM runs.

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=4ac9ca81489294ac40bf4b88a68ba1c9" alt="Confirmation" data-og-width="2898" width="2898" data-og-height="1452" height="1452" data-path="langsmith/images/confirmation.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=3c09ffaacb03ec55aeddda61a3a58111 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=9146d5498be48425a6de3caf28db394f 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=299ac17e36643502a8ddc0a7d4d49780 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=7607f473d263d7a9d55e1720571d3755 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=deb6514e2202d020882f4fc810207795 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/confirmation.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=4141f028af5084d808297d936f168121 2500w" />

You can then optionally edit the run before adding it to the dataset.

### Automatically from a tracing project

You can use [run rules](/langsmith/rules) to automatically add traces to a dataset based on certain conditions. For example, you could add all traces that are [tagged](/langsmith/observability-concepts#tags) with a specific use case or have a [low feedback score](/langsmith/observability-concepts#feedback).

### From examples in an Annotation Queue

<Check>
  If you rely on subject matter experts to build meaningful datasets, use [annotation queues](/langsmith/annotation-queues) to provide a streamlined view for reviewers. Human reviewers can optionally modify the inputs/outputs/reference outputs from a trace before it is added to the dataset.
</Check>

Annotation queues can be optionally configured with a default dataset, though you can add runs to any dataset by using the dataset switcher on the bottom of the screen. Once you select the right dataset, click **Add to Dataset** or hit the hot key `D` to add the run to it.

Any modifications you make to the run in your annotation queue will carry over to the dataset, and all metadata associated with the run will also be copied.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=885c58ab30d94b2371b79730468e0be3" alt="Add to dataset from annotation queue" data-og-width="2290" width="2290" data-og-height="1468" height="1468" data-path="langsmith/images/add-to-dataset-from-aq.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=90c1279193bf00acf6112980ebd94558 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=9cb62b05c7d90e5904573d7992a141cc 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=5c547cc7f74a3b3b34eb7788ad324fcd 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6c623a6015dcb818677b6af9d41ad923 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=47c9a570a9c1e568c0a035aa82adc5d0 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-dataset-from-aq.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=c76a247a72ca269c29c99c1da46852e6 2500w" />

Note you can also set up rules to add runs that meet specific criteria to an annotation queue using [automation rules](/langsmith/rules).

### From the Prompt Playground

On the [**Prompt Playground**](/langsmith/observability-concepts#prompt-playground) page, select **Set up Evaluation**, click **+New** if you're starting a new dataset or select from an existing dataset.

<Note>
  Creating datasets inline in the playground is not supported for datasets that have nested keys. In order to add/edit examples with nested keys, you must edit [from the datasets page](/langsmith/manage-datasets-in-application#from-the-datasets-page).
</Note>

To edit the examples:

* Use **+Row** to add a new example to the dataset
* Delete an example using the **⋮** dropdown on the right hand side of the table
* If you're creating a reference-free dataset remove the "Reference Output" column using the **x** button in the column. Note: this action is not reversible.

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=583ce80f84902ccb5ccab36a44dddb9b" alt="Create a dataset in the playground" data-og-width="1318" width="1318" data-og-height="981" height="981" data-path="langsmith/images/playground-dataset.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=31fe00c30e17e901334f46845dba1464 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=6e63d19dd4be4761d1f6c0d4746395cc 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=f625e8480f96e644b4ff2205a2905c9d 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=5126df423f04d152ad638f70f1a7765d 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=53a13fe730bbe7c2393049dac76266db 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/playground-dataset.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=998729ce541d92f078382984c76c2501 2500w" />

### Import a dataset from a CSV or JSONL file

On the **Datasets & Experiments** page, click **+New Dataset**, then **Import** an existing dataset from CSV or JSONL file.

### Create a new dataset from the Datasets & Experiments page

1. Navigate to the **Datasets & Experiments** page from the left-hand menu.
2. Click **+ New Dataset**.
3. On the **New Dataset** page, select the **Create from scratch** tab.
4. Add a name and description for the dataset.
5. (Optional) Create a [dataset schema](#create-a-dataset-schema) to validate your dataset.
6. Click **Create**, which will create an empty dataset.
7. To add examples inline, on the dataset's page, go to the **Examples** tab. Click **+ Example**.
8. Define examples in JSON and click **Submit**. For more details on dataset splits, refer to [Create and manage dataset splits](#create-and-manage-dataset-splits).

### Add synthetic examples created by an LLM

If you have existing examples and a [schema](#create-a-dataset-schema) defined on your dataset, when you click **+ Example** there is an option to <Icon icon="sparkles" /> **Add AI-Generated Examples**. This will use an LLM to create [synthetic](/langsmith/evaluation-concepts#synthetic-data) examples.

In **Generate examples**, do the following:

1. Click **API Key** in the top right of the pane to set your OpenAI API key as a [workspace secret](/langsmith/administration-overview#workspaces). If your workspace already has an OpenAI API key set, you can skip this step.

2. Select <Tooltip tip="A few sample input–output pairs that guide the model on how to perform a task.">few-shot examples</Tooltip>: Toggle **Automatic** or **Manual** reference examples. You can select these examples manually from your dataset or use the automatic selection option.

3. Enter the number of synthetic examples you want to generate.

4. Click **Generate**.

<div style={{ textAlign: 'center' }}>
     <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=4ec726f80ee38a829ade96caedb61925" alt="The AI-Generated Examples configuration window. Selections for manual and automatic and number of examples to generate." data-og-width="689" width="689" data-og-height="383" height="383" data-path="langsmith/images/generate-synthetic-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=280&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=2a49e15cf0be32a284ab6749941367d4 280w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=560&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=c6d6ee9674352b0bc75573cd7f4a5151 560w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=840&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=782626122e3c9ebef0cf67c0cd2060cf 840w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=1100&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=6e1a7c8b25bc8d15324dfd7c50a8bd5c 1100w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=1650&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=bb757aa11517627441a4c8317f7fb313 1650w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-light.png?w=2500&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=6bab6b7f6f500ac9044ab3b816484af5 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=6c0ba9da5bf342e702c23406bdfdf18c" alt="The AI-Generated Examples configuration window. Selections for manual and automatic and number of examples to generate." data-og-width="674" width="674" data-og-height="361" height="361" data-path="langsmith/images/generate-synthetic-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=280&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=f4f82b37bd0e5b33bb7d113f5d67de38 280w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=560&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=b07f30b95f9c7dd7c3c21919d2a6ee86 560w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=840&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=64a4cbcd28b292e109f2807125516981 840w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=1100&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=fd764de7b0999e27b1b336260f206cd8 1100w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=1650&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=77c5081c2232e183b372a418bffce330 1650w, https://mintcdn.com/langchain-5e9cc07a/4E7JL9dL7Pg6moF1/langsmith/images/generate-synthetic-dark.png?w=2500&fit=max&auto=format&n=4E7JL9dL7Pg6moF1&q=85&s=3be24e6515512dda957b4ce6ba2cd732 2500w" />
   </div>

5. The examples will appear on the **Select generated examples** page. Choose which examples to add to your dataset, with the option to edit them before finalizing. Click **Save Examples**.

6. Each example will be validated against your specified dataset schema and tagged as **synthetic** in the source metadata.

<div style={{ textAlign: 'center' }}>
     <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=146c5f6238415bb8d77da15a8a17c839" alt="Select generated examples page with generated examples selected and Save examples button." data-og-width="1781" width="1781" data-og-height="856" height="856" data-path="langsmith/images/select-generated-examples-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=280&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=1175f7421bb4c5456ebccccddcc2bd56 280w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=560&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=d4d85335f1ec8826acce6be4a56d20d2 560w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=840&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=167488b8860682ee6b3ceb6dee4e8604 840w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=1100&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=468acc35c4f46ce0997f1c552504c3ff 1100w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=1650&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=3131cd4260d4cff89da156c774243500 1650w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-light.png?w=2500&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=23b27fab3ff759c7f7d48d7057b19409 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=1f1235b31b2d86cf5c7c615c84061e9c" alt="Select generated examples page with generated examples selected and Save examples button." data-og-width="1779" width="1779" data-og-height="838" height="838" data-path="langsmith/images/select-generated-examples-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=280&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=704f33356493a5913bae1c6a744acc2d 280w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=560&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=9222e34f0b8693ecfde55d33378c887a 560w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=840&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=8e96a9e18d8142347fbcd3e6ecbb64c5 840w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=1100&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=3e6c57060fb9bb371fafbe272ed83381 1100w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=1650&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=a81b2b4775f89ce9004a3cc1ea38ae57 1650w, https://mintcdn.com/langchain-5e9cc07a/mw9POU1xwbwaPxuQ/langsmith/images/select-generated-examples-dark.png?w=2500&fit=max&auto=format&n=mw9POU1xwbwaPxuQ&q=85&s=1917622069d093a1f43388bac001a050 2500w" />
   </div>

### Create a dataset schema

LangSmith datasets store arbitrary JSON objects. We recommend (but do not require) that you define a schema for your dataset to ensure that they conform to a specific JSON schema. Dataset schemas are defined with standard [JSON schema](https://json-schema.org/), with the addition of a few [prebuilt types](/langsmith/dataset-json-types) that make it easier to type common primitives like messages and tools.

Certain fields in your schema have a `+ Transformations` option. Transformations are preprocessing steps that, if enabled, update your examples when you add them to the dataset. For example the `convert to OpenAI messages` transformation will convert message-like objects, like LangChain messages, to OpenAI message format.

For the full list of available transformations, see [our reference](/langsmith/dataset-transformations).

<Note>
  If you plan to collect production traces in your dataset from LangChain [ChatModels](https://python.langchain.com/do/langsmith/observability-concepts/chat_models/) or from OpenAI calls using the [LangSmith OpenAI wrapper](/langsmith/annotate-code#wrap-the-openai-client), we offer a prebuilt Chat Model schema that converts messages and tools into industry standard openai formats that can be used downstream with any model for testing. You can also customize the template settings to match your use case.

Please see the [dataset transformations reference](/langsmith/dataset-transformations) for more information.
</Note>

### Create and manage dataset splits

Dataset splits are divisions of your dataset that you can use to segment your data. For example, it is common in machine learning workflows to split datasets into training, validation, and test sets. This can be useful to prevent overfitting - where a model performs well on the training data but poorly on unseen data. In evaluation workflows, it can be useful to do this when you have a dataset with multiple categories that you may want to evaluate separately; or if you are testing a new use case that you may want to include in your dataset in the future, but want to keep separate for now. Note that the same effect can be achieved manually via metadata - but we expect splits to be used for higher level organization of your dataset to split it into separate groups for evaluation, whereas metadata would be used more for storing information on your examples like tags and information about its origin.

In machine learning, it is best practice to keep your splits separate (each example belongs to exactly one split). However, we allow you to select multiple splits for the same example in LangSmith because it can make sense for some evaluation workflows - for example, if an example falls into multiple categories on which you may want to evaluate your application.

In order to create and manage splits in the app, you can select some examples in your dataset and click "Add to Split". From the resulting popup menu, you can select and unselect splits for the selected examples, or create a new split.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=014aa1fdc735f055c9e66a2a18720d4c" alt="Add to Split" data-og-width="1309" width="1309" data-og-height="915" height="915" data-path="langsmith/images/add-to-split2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=0c1ef18d892f91c218d51d47fb313d81 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=1168e3dd272772dde9cd92d767b832f8 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=be237dec928908095462f5314bb795fd 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6d78b720e3dd1e98bb4880be2f18b4e1 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=d68fd43c3f0e68fad3cc47f3c80d4f04 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-to-split2.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=95711a7ca8fe56f1a724568454f6fde5 2500w" />

### Edit example metadata

You can add metadata to your examples by clicking on an example and then clicking "Edit" on the top righthand side of the popover. From this page, you can update/delete existing metadata, or add new metadata. You may use this to store information about your examples, such as tags or version info, which you can then [group by](/langsmith/analyze-an-experiment#group-results-by-metadata) when analyzing experiment results or [filter by](/langsmith/manage-datasets-programmatically#list-examples-by-metadata) when you call `list_examples` in the SDK.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-metadata.gif?s=d7235cc2b83913561faccb5083780f17" alt="Add Metadata" data-og-width="1010" width="1010" data-og-height="720" height="720" data-path="langsmith/images/add-metadata.gif" data-optimize="true" data-opv="3" />

You can filter examples by split, metadata key/value or perform full-text search over examples. These filtering options are available to the top left of the examples table.

* **Filter by split**: Select split > Select a split to filter by
* **Filter by metadata**: Filters > Select "Metadata" from the dropdown > Select the metadata key and value to filter on
* **Full-text search**: Filters > Select "Full Text" from the dropdown > Enter your search criteria

You may add multiple filters, and only examples that satisfy all of the filters will be displayed in the table.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=2d1f300884d5e886267a137a3cb3e4c7" alt="Filters Applied to Examples" data-og-width="1307" width="1307" data-og-height="370" height="370" data-path="langsmith/images/filters-applied.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=31bd615f72fbf783850caac0b6f06bb7 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4fcef71fff0a7251a559f3d275f527da 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=591c3a65c909f386e745e6f76107722f 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=1bc1167f20d8a0b80ce88f3001735a4d 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=769ab5f104184d1f5841185666c50dbf 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filters-applied.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7130de5c7f60a1e597ddbffa8575f056 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/manage-datasets-in-application.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Combine waits for all parallel operations to complete

**URL:** llms-txt#combine-waits-for-all-parallel-operations-to-complete

workflow.add_edge("fetch_news", "combine_data")
workflow.add_edge("fetch_weather", "combine_data")
workflow.add_edge("fetch_stocks", "combine_data")
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
**4. Team development and documentation**

The visual nature of the Graph API makes it easier for teams to understand, document, and maintain complex workflows.
```

---

## Cloud

**URL:** llms-txt#cloud

**Contents:**
- Get started
- Cloud architecture and scalability
  - Architecture
  - Allowlisting IP addresses

Source: https://docs.langchain.com/langsmith/cloud

<Callout icon="rocket" color="#4F46E5" iconType="regular">
  If you're ready to deploy your app to Cloud, follow the [Cloud deployment quickstart](/langsmith/deployment-quickstart) or the [full setup guide](/langsmith/deploy-to-cloud). This page explains the Cloud managed architecture for reference.
</Callout>

The **Cloud** option is a fully managed model where LangChain hosts and operates all LangSmith infrastructure and services:

* **Fully managed infrastructure**: LangChain handles all infrastructure, updates, scaling, and maintenance.
* **Deploy from GitHub**: Connect your repositories and deploy with a few clicks.
* **Automated CI/CD**: Build process is handled automatically by the platform.
* **LangSmith UI**: Full access to [observability](/langsmith/observability), [evaluation](/langsmith/evaluation), [deployment management](/langsmith/deployments), and [Studio](/langsmith/studio).

|                                               | **Who manages it** | **Where it runs** |
| --------------------------------------------- | ------------------ | ----------------- |
| **LangSmith platform (UI, APIs, datastores)** | LangChain          | LangChain's cloud |
| **Your Agent Servers**                        | LangChain          | LangChain's cloud |
| **CI/CD for your apps**                       | LangChain          | LangChain's cloud |

<img src="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=3f0316122425895270d0ecd47b12e139" alt="Cloud deployment: LangChain hosts and manages all components including the UI, APIs, and your Agent Servers." data-og-width="1425" width="1425" data-og-height="1063" height="1063" data-path="langsmith/images/langgraph-cloud-architecture.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=280&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=b34a10fb40ca5188dddfb6be69696c75 280w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=560&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=d310ce86e8421878575cf4d4fa72bf78 560w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=840&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=7cc3fcee9c36a8d1e8da4cc4abbde3b9 840w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=1100&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=a184c950c8585e2fdb5e75ac7f0f5642 1100w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=1650&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=cb778e4a6707b00eaf703886d32569bd 1650w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/langgraph-cloud-architecture.png?w=2500&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=00f9d9df44512dded307613502d03299 2500w" />

To deploy your first application to Cloud, follow the [Cloud deployment quickstart](/langsmith/deployment-quickstart) or refer to the [comprehensive setup guide](/langsmith/deploy-to-cloud).

## Cloud architecture and scalability

<Note>
  This section is only relevant for the cloud-managed LangSmith services available at [https://smith.langchain.com](https://smith.langchain.com) and [https://eu.smith.langchain.com](https://eu.smith.langchain.com).

For information on the self-hosted LangSmith solution, please refer to the [self-hosted documentation](/langsmith/self-hosted).
</Note>

LangSmith is deployed on Google Cloud Platform (GCP) and is designed to be highly scalable. Many customers run production workloads on LangSmith for LLM application observability, evaluation, and agent deployment

The US-based LangSmith service is deployed in the `us-central1` (Iowa) region of GCP.

<Note>
  The [EU-based LangSmith service](https://eu.smith.langchain.com) is now available (as of mid-July 2024) and is deployed in the `europe-west4` (Netherlands) region of GCP. If you are interested in an enterprise plan in this region, [contact our sales team](https://www.langchain.com/contact-sales).
</Note>

#### Regional storage

The resources and services in this table are stored in the location corresponding to the URL where sign-up occurred (either the US or EU). Cloud-managed LangSmith uses [Supabase](https://supabase.com) for authentication/authorization and [ClickHouse Cloud](https://clickhouse.com/cloud) for data warehouse.

|                                                | US                                                                 | EU                                                                       |
| ---------------------------------------------- | ------------------------------------------------------------------ | ------------------------------------------------------------------------ |
| URL                                            | [https://smith.langchain.com](https://smith.langchain.com)         | [https://eu.smith.langchain.com](https://eu.smith.langchain.com)         |
| API URL                                        | [https://api.smith.langchain.com](https://api.smith.langchain.com) | [https://eu.api.smith.langchain.com](https://eu.api.smith.langchain.com) |
| GCP                                            | us-central1 (Iowa)                                                 | europe-west4 (Netherlands)                                               |
| Supabase                                       | AWS us-east-1 (N. Virginia)                                        | AWS eu-central-1 (Germany)                                               |
| ClickHouse Cloud                               | us-central1 (Iowa)                                                 | europe-west4 (Netherlands)                                               |
| [LangSmith deployment](/langsmith/deployments) | us-central1 (Iowa)                                                 | europe-west4 (Netherlands)                                               |

See the [Regions FAQ](/langsmith/regions-faq) for more information.

#### Region-independent storage

Data listed here is stored exclusively in the US:

* Payment and billing information with Stripe and Metronome

LangSmith is composed of the following services, all deployed on Google Kubernetes Engine (GKE):

* LangSmith Frontend: serves the LangSmith UI.
* LangSmith Backend: serves the LangSmith API.
* LangSmith Platform Backend: handles authentication and other high-volume tasks. (Internal service)
* LangSmith Playground: handles forwarding requests to various LLM providers for the Playground feature.
* LangSmith Queue: handles processing of asynchronous tasks. (Internal service)

LangSmith uses the following GCP storage services:

* Google Cloud Storage (GCS) for runs inputs and outputs.
* Google Cloud SQL PostgreSQL for transactional workloads.
* Google Cloud Memorystore for Redis for queuing and caching.
* Clickhouse Cloud on GCP for trace ingestion and analytics. Our services connect to Clickhouse Cloud, which is hosted in the same GCP region, via a private endpoint.

Some additional GCP services we use include:

* Google Cloud Load Balancer for routing traffic to the LangSmith services.
* Google Cloud CDN for caching static assets.
* Google Cloud Armor for security and rate limits. For more information on rate limits we enforce, please refer to [this guide](/langsmith/administration-overview#rate-limits).

<div style={{ textAlign: 'center' }}>
  <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=0790cbdf4fe131c74d1e60bb120834e3" alt="Light mode overview" data-og-width="2210" width="2210" data-og-height="1463" height="1463" data-path="langsmith/images/cloud-arch-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=280&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=c04d8a044d221559fe2f7b9121275638 280w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=560&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=a15351b254f11cc149ce237ba8853e91 560w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=840&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=d4a409e73830e588519cb1d0b2a17f3b 840w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=1100&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=6dbeda77b57083efb988e15af38f0a6e 1100w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=1650&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=24aadbe2e79db02d76fd5deaea6564e1 1650w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-light.png?w=2500&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=a126aa1f02d36de0a8e391f0e1059b8e 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=767f3bc3dc73ffe1a806f54e0aaa428b" alt="Dark mode overview" data-og-width="2210" width="2210" data-og-height="1463" height="1463" data-path="langsmith/images/cloud-arch-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=280&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=f7367df5b782c821882605418c50563f 280w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=560&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=60759ef9e927ba0985e21e38acacae6d 560w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=840&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=383ac38ba52733548d8d97ffabfe384e 840w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=1100&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=b045b8e19a9926d4d10ec8ad2d2767c1 1100w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=1650&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=23778aa891c1b42336b274ab1b2f8bec 1650w, https://mintcdn.com/langchain-5e9cc07a/rqYqeBEA_2oeiw17/langsmith/images/cloud-arch-dark.png?w=2500&fit=max&auto=format&n=rqYqeBEA_2oeiw17&q=85&s=5a64734b4e9fb5dd4af690edf3fa6248 2500w" />
</div>

### Allowlisting IP addresses

#### Egress from LangChain SaaS

All traffic leaving LangSmith services will be routed through a NAT gateway. All traffic will appear to originate from the following IP addresses:

| US             | EU             |
| -------------- | -------------- |
| 34.59.65.97    | 34.13.192.67   |
| 34.67.51.221   | 34.147.105.64  |
| 34.46.212.37   | 34.90.22.166   |
| 34.132.150.88  | 34.147.36.213  |
| 35.188.222.201 | 34.32.137.113  |
| 34.58.194.127  | 34.91.238.184  |
| 34.59.97.173   | 35.204.101.241 |
| 104.198.162.55 | 35.204.48.32   |

It may be helpful to allowlist these IP addresses if connecting to your own AzureOpenAI service or other endpoints that may be required by the Playground or Online Evaluation.

#### Ingress into LangChain SaaS

The langchain endpoints map to the following static IP addresses:

| US             | EU           |
| -------------- | ------------ |
| 34.8.121.39    | 34.95.92.214 |
| 34.107.251.234 | 34.13.73.122 |

You may need to allowlist these to enable traffic from your private network to LangSmith SaaS endpoints (`api.smith.langchain.com`, `smith.langchain.com`, `beacon.langchain.com`, `eu.api.smith.langchain.com`, `eu.smith.langchain.com`, `eu.beacon.langchain.com`).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/cloud.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Deploy with control plane

**URL:** llms-txt#deploy-with-control-plane

**Contents:**
- Overview
- Prerequisites
- Step 1. Test locally
- Step 2. Build Docker image
- Step 3. Push to container registry
- Step 4. Deploy with the control plane UI
- Update deployment
- Private registry authentication
- Next steps

Source: https://docs.langchain.com/langsmith/deploy-with-control-plane

This guide shows you how to deploy your applications to [hybrid](/langsmith/hybrid) or [self-hosted](/langsmith/self-hosted) instances with a [control plane](/langsmith/control-plane). With a control plane, you build Docker images locally, push them to a registry that your Kubernetes cluster has access to, and deploy them with the [LangSmith UI](https://smith.langchain.com).

<Note>
  **This guide is for deploying applications, not setting up infrastructure.**

Before using this guide, you must have already completed infrastructure setup:

* **[Hybrid setup](/langsmith/deploy-hybrid)**: For hybrid hosting.
  * **[Enable LangSmith Deployment](/langsmith/deploy-self-hosted-full-platform)**: For self-hosted with control plane.

If you haven't set up your infrastructure yet, start with the [Platform setup section](/langsmith/platform-setup).
</Note>

Applications deployed to hybrid or self-hosted LangSmith instances with control plane use Docker images. In this guide, the application deployment workflow is:

1. Test your application locally using `langgraph dev` or [Studio](/langsmith/studio).
2. Build a Docker image using the `langgraph build` command.
3. Push the image to a container registry accessible by your infrastructure.
4. Deploy from the [control plane UI](/langsmith/control-plane#control-plane-ui) by specifying the image URL.

Before completing this guide, you'll need the following:

* Completed infrastructure setup to enable your [data plane](/langsmith/data-plane) to receive application deployments:
  * [Hybrid setup](/langsmith/deploy-hybrid): Installs data plane components (listener, operator, CRDs) in your Kubernetes cluster that connect to LangChain's managed control plane.
  * [Enable LangSmith Deployment](/langsmith/deploy-self-hosted-full-platform): Enables LangSmith Deployment on your self-hosted LangSmith instance.
* Access to the [LangSmith UI](https://smith.langchain.com) with LangSmith Deployment enabled.
* A container registry accessible by your Kubernetes cluster. If using a private registry that requires authentication, you must configure image pull secrets as part of your infrastructure setup. Refer to [Private registry authentication](#private-registry-authentication).

## Step 1. Test locally

Before deploying, test your application locally. You can use the [LangGraph CLI](/langsmith/cli#dev) to run an Agent server in development mode:

For a full guide local testing, refer to the [Local server quickstart](/langsmith/local-server).

## Step 2. Build Docker image

Build a Docker image of your application using the [`langgraph build`](/langsmith/cli#build) command:

Build command options include:

| Option               | Default          | Description                                                       |
| -------------------- | ---------------- | ----------------------------------------------------------------- |
| `-t, --tag TEXT`     | Required         | Tag for the Docker image                                          |
| `--platform TEXT`    |                  | Target platform(s) to build for (e.g., `linux/amd64,linux/arm64`) |
| `--pull / --no-pull` | `--pull`         | Build with latest remote Docker image                             |
| `-c, --config FILE`  | `langgraph.json` | Path to configuration file                                        |

Example with platform specification:

For full details, see the [CLI reference](/langsmith/cli#build).

## Step 3. Push to container registry

Push your image to a container registry accessible by your Kubernetes cluster. The specific commands depend on your registry provider.

<Tip>
  Tag your images with version information (e.g., `my-registry.com/my-app:v1.0.0`) to make rollbacks easier.
</Tip>

## Step 4. Deploy with the control plane UI

The [control plane UI](/langsmith/control-plane#control-plane-ui) allows you to create and manage deployments, view logs and metrics, and update configurations. To create a new deployment in the [LangSmith UI](https://smith.langchain.com):

1. In the left-hand navigation panel, select **Deployments**.
2. In the top-right corner, select **+ New Deployment**.
3. In the deployment configuration panel, provide:
   * **Image URL**: The full image URL you pushed in [Step 3](#step-3-push-to-container-registry).
   * **Listener/Compute ID**: Select the listener configured for your infrastructure.
   * **Namespace**: The Kubernetes namespace to deploy to.
   * **Environment variables**: Any required configuration (API keys, etc.).
   * Other deployment settings as needed.
4. Select **Submit**.

The control plane will coordinate with your [data plane](/langsmith/data-plane) listener to deploy your application.

After creating a deployment, the infrastructure is [provisioned asynchronously](/langsmith/control-plane#asynchronous-deployment). Deployment can take up to several minutes, with initial deployments taking longer due to database creation.

From the control plane UI, you can view build logs, server logs, and deployment metrics including CPU/memory usage, replicas, and API performance. For more details, refer to the [control plane monitoring documentation](/langsmith/control-plane#monitoring).

<Note>
  A [LangSmith Observability tracing project](/langsmith/observability) is automatically created for each deployment with the same name as the deployment. Tracing environment variables are set automatically by the control plane.
</Note>

To deploy a new version of your application, create a [new revision](/langsmith/control-plane#revisions):

Starting from the LangSmith UI:

1. In the left-hand navigation panel, select **Deployments**.
2. Select an existing deployment.
3. In the Deployment view, select **+ New Revision** in the top-right corner.
4. Update the configuration:
   * Update the **Image URL** to your new image version.
   * Update environment variables if needed.
   * Adjust other settings as needed.
5. Select **Submit**.

## Private registry authentication

If your container registry requires authentication (e.g., AWS ECR, Azure ACR, GCP Artifact Registry, private Docker registry), you must configure Kubernetes image pull secrets before deploying applications. This is a one-time infrastructure configuration.

<Note>
  **This configuration is done at the infrastructure level, not per-deployment.** Once configured, all deployments automatically inherit the registry credentials.
</Note>

The configuration steps depend on your deployment type:

* **Self-hosted with control plane**: Configure `imagePullSecrets` in your LangSmith Helm chart's `values.yaml` file. See the detailed steps in the [Enable LangSmith Deployment guide](/langsmith/deploy-self-hosted-full-platform#setup).
* **Hybrid**: Configure `imagePullSecrets` in your `langgraph-dataplane-values.yaml` file using the same format.

For detailed steps on creating image pull secrets for different registry providers, refer to the [Kubernetes documentation on pulling images from private registries](https://kubernetes.io/docs/tasks/configure-pod-container/pull-image-private-registry/).

* **[Control plane](/langsmith/control-plane)**: Learn more about control plane features.
* **[Data plane](/langsmith/data-plane)**: Understand data plane architecture.
* **[Observability](/langsmith/observability)**: Monitor your deployments with automatic tracing.
* **[Studio](/langsmith/studio)**: Test and debug deployed applications.
* **[LangGraph CLI](/langsmith/cli)**: Full CLI reference documentation.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/deploy-with-control-plane.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
For a full guide local testing, refer to the [Local server quickstart](/langsmith/local-server).

## Step 2. Build Docker image

Build a Docker image of your application using the [`langgraph build`](/langsmith/cli#build) command:
```

Example 2 (unknown):
```unknown
Build command options include:

| Option               | Default          | Description                                                       |
| -------------------- | ---------------- | ----------------------------------------------------------------- |
| `-t, --tag TEXT`     | Required         | Tag for the Docker image                                          |
| `--platform TEXT`    |                  | Target platform(s) to build for (e.g., `linux/amd64,linux/arm64`) |
| `--pull / --no-pull` | `--pull`         | Build with latest remote Docker image                             |
| `-c, --config FILE`  | `langgraph.json` | Path to configuration file                                        |

Example with platform specification:
```

---

## Service A: Create a span and propagate context to Service B

**URL:** llms-txt#service-a:-create-a-span-and-propagate-context-to-service-b

def service_a():
    with tracer.start_as_current_span("service_a_operation") as span:
        # Create a chain
        prompt = ChatPromptTemplate.from_template("Summarize: {text}")
        model = ChatOpenAI()
        chain = prompt | model

# Run the chain
        result = chain.invoke({"text": "OpenTelemetry is an observability framework"})

# Propagate context to Service B
        headers = {}
        inject(headers)  # Inject trace context into headers

# Call Service B with the trace context
        response = requests.post(
            "http://service-b.example.com/process",
            headers=headers,
            json={"summary": result.content}
        )
        return response.json()

---

## Configure LangSmith for scale

**URL:** llms-txt#configure-langsmith-for-scale

**Contents:**
- Summary
- Trace ingestion (write path)
- Trace querying (read path)
- Example LangSmith configurations for scale
  - Low reads, low writes <a name="low-reads-low-writes" />
  - Low reads, high writes <a name="low-reads-high-writes" />

Source: https://docs.langchain.com/langsmith/self-host-scale

A self-hosted LangSmith instance can handle a large number of traces and users. The default configuration for the self-hosted deployment can handle substantial load, and you can configure your deployment to be able to achieve higher scale. This page describes scaling considerations and provides some examples to help configure your self-hosted instance.

For example configurations, refer to [Example LangSmith configurations for scale](#example-langsmith-configurations-for-scale).

The table below provides an overview comparing different LangSmith configurations for various load patterns (reads / writes):

|                                                                                                                                                                  | **[Low / low](#low-reads-low-writes)**              | **[Low / high](#low-reads-high-writes)**            | **[High / low](#high-reads-low-writes)**                                                                                                                                                                                                 | [Medium / medium](#medium-reads-medium-writes)      | [High / high](#high-reads-high-writes)                                                                                                                                                                                                   |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------- | :-------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <Tooltip tip="Number of users actively viewing traces on the frontend">Concurrent frontend users</Tooltip>                                                       | 5                                                   | 5                                                   | 50                                                                                                                                                                                                                                       | 20                                                  | 50                                                                                                                                                                                                                                       |
| <Tooltip tip="Number of traces being ingested via SDKs or API endpoints">Traces submitted per second</Tooltip>                                                   | 10                                                  | 1000                                                | 10                                                                                                                                                                                                                                       | 100                                                 | 1000                                                                                                                                                                                                                                     |
| **Frontend replicas**<br />(500m CPU, 1Gi per replica)                                                                                                           | 1 (default)                                         | 4                                                   | 2                                                                                                                                                                                                                                        | 2                                                   | 4                                                                                                                                                                                                                                        |
| **Platform backend replicas**<br />(1 CPU, 2Gi per replica)                                                                                                      | 3 (default)                                         | 20                                                  | 3 (default)                                                                                                                                                                                                                              | 3 (default)                                         | 20                                                                                                                                                                                                                                       |
| **Queue replicas**<br />(1 CPU, 2Gi per replica)                                                                                                                 | 3 (default)                                         | 160                                                 | 6                                                                                                                                                                                                                                        | 10                                                  | 160                                                                                                                                                                                                                                      |
| **Backend replicas**<br />(1 CPU, 2Gi per replica)                                                                                                               | 2 (default)                                         | 5                                                   | 40                                                                                                                                                                                                                                       | 16                                                  | 50                                                                                                                                                                                                                                       |
| **Redis resources**                                                                                                                                              | 8 Gi (default)                                      | 200 Gi external                                     | 8 Gi (default)                                                                                                                                                                                                                           | 13Gi external                                       | 200 Gi external                                                                                                                                                                                                                          |
| **ClickHouse resources**                                                                                                                                         | 4 CPU<br />16 Gi (default)                          | 10 CPU<br />32Gi memory                             | 8 CPU<br />16 Gi per replica                                                                                                                                                                                                             | 16 CPU<br />24Gi memory                             | 14 CPU<br />24 Gi per replica                                                                                                                                                                                                            |
| **ClickHouse setup**                                                                                                                                             | Single instance                                     | Single instance                                     | 3-node <Tooltip tip="Recommended for high read loads to prevent degraded performance. Another option would be [managed clickhouse](/langsmith/self-host-external-clickhouse#langsmith-managed-clickhouse).">replicated cluster</Tooltip> | Single instance                                     | 3-node <Tooltip tip="Recommended for high read loads to prevent degraded performance. Another option would be [managed clickhouse](/langsmith/self-host-external-clickhouse#langsmith-managed-clickhouse).">replicated cluster</Tooltip> |
| <Tooltip tip="We recommend using an external instance and enabling autoexpansion for the disk to handle growing data requirements.">Postgres resources</Tooltip> | 2 CPU<br />8 GB memory<br />10GB storage (external) | 2 CPU<br />8 GB memory<br />10GB storage (external) | 2 CPU<br />8 GB memory<br />10GB storage (external)                                                                                                                                                                                      | 2 CPU<br />8 GB memory<br />10GB storage (external) | 2 CPU<br />8 GB memory<br />10GB storage (external)                                                                                                                                                                                      |
| **Blob storage**                                                                                                                                                 | Disabled                                            | Enabled                                             | Enabled                                                                                                                                                                                                                                  | Enabled                                             | Enabled                                                                                                                                                                                                                                  |

Below we go into more details about the read and write paths as well as provide a `values.yaml` snippet for you to start with for your self-hosted LangSmith instance.

## Trace ingestion (write path)

Common usage that put load on the write path:

* Ingesting traces via the Python or JavaScript LangSmith SDK
* Ingesting traces via the `@traceable` wrapper
* Submitting traces via the `/runs/multipart` endpoint

Services that play a large role in trace ingestion:

* Platform backend service: Receives initial request to ingest traces and places traces on a Redis queue
* Redis cache: Used to queue traces that need to be persisted
* Queue service: Persists traces for querying
* ClickHouse: Persistent storage used for traces

When scaling up the write path (trace ingestion), it is helpful to monitor the four services/resources listed above. Here are some typical changes that can help increase performance of trace ingestion:

* Give ClickHouse more resources (CPU and memory) if it is approaching resource limits.
* Increase the number of platform-backend pods if ingest requests are taking long to respond.
* Increase queue service pod replicas if traces are not being processed from Redis fast enough.
* Use a larger Redis cache if you notice that the current Redis instance is reaching resource limits. This could also be a reason why ingest requests take a long time.

## Trace querying (read path)

Common usage that puts load on the read path:

* Users on the frontend looking at tracing projects or individual traces
* Scripts used to query for trace info
* Hitting either the `/runs/query` or `/runs/<run-id>` api endpoints

Services that play a large role in querying traces:

* Backend service: Receives the request and submits a query to ClickHouse to then respond to the request
* ClickHouse: Persistent storage for traces. This is the main database that is queried when requesting trace info.

When scaling up the read path (trace querying), it is helpful to monitor the two services/resources listed above. Here are some typical changes that can help improve performance of trace querying:

* Increase the number of backend service pods. This would be most impactful if backend service pods are reaching 1 core CPU usage.
* Give ClickHouse more resources (CPU or Memory). ClickHouse can be very resource intensive, but it should lead to better performance.
* Move to a [replicated ClickHouse cluster](/langsmith/self-host-external-clickhouse#ha-replicated-clickhouse-cluster). Adding replicas of ClickHouse helps with read performance, but we recommend staying below 5 replicas (start with 3).

For more precise guidance on how this translates to helm chart values, refer to the examples the following [section](#example-langsmith-configurations-for-scale). If you are unsure why your LangSmith instance cannot handle a certain load pattern, contact the LangChain team.

## Example LangSmith configurations for scale

Below we provide some example LangSmith configurations based on expected read and write loads.

For read load (trace querying):

* Low means roughly 5 users looking at traces at a time (about 10 requests per second)
* Medium means roughly 20 users looking at traces at a time (about 40 requests per second)
* High means roughly 50 users looking at traces at a time (about 100 requests per second)

For write load (trace ingestion):

* Low means up to 10 traces submitted per second
* Medium means up to 100 traces submitted per second
* High means up to 1000 traces submitted per second

<Note>
  The exact optimal configuration depends on your usage and trace payloads. Use the examples below in combination with the information above and your specific usage to update your LangSmith configuration as you see fit. If you have any questions, please reach out to the LangChain team.
</Note>

### Low reads, low writes <a name="low-reads-low-writes" />

The default LangSmith configuration will handle this load. No custom resource configuration is needed here.

### Low reads, high writes <a name="low-reads-high-writes" />

You have a very high scale of trace ingestions, but single digit number of users on the frontend querying traces at any one time.

For this, we recommend a configuration like this:

```yaml  theme={null}
config:
  blobStorage:
    # Please also set the other keys to connect to your blob storage. See configuration section.
    enabled: true
  settings:
    redisRunsExpirySeconds: "3600"

---

## Filter traces

**URL:** llms-txt#filter-traces

**Contents:**
- Creating and Applying Filters
  - Filtering by run attributes
  - Filtering by time range
  - Filter operators
- Specific Filtering Techniques
  - Filter for intermediate runs (spans)
  - Filter based on inputs and outputs
  - Filter based on input / output key-value pairs
  - Example: Filtering for tool calls
  - Negative filtering on key-value pairs

Source: https://docs.langchain.com/langsmith/filter-traces-in-application

<Tip>**Recommended reading**: It might be helpful to read the [Conceptual guide on tracing](/langsmith/observability-concepts) to gain familiarity with the concepts mentioned on this page.</Tip>

Tracing projects can contain a significant amount of data. Filters are used for effectively navigating and analyzing this data, allowing you to:

* **Have focused investigations**: Quickly narrow down to specific runs for ad-hoc analysis
* **Debug and analyze**: Identify and examine errors, failed runs, and performance bottlenecks

This page contains a series of guides for how to filter runs in a tracing project. If you are programmatically exporting runs for analysis via the [API](https://api.smith.langchain.com/redoc#tag/run/operation/query_runs_api_v1_runs_query_post) or [SDK](https://docs.smith.langchain.com/reference/python/client/langsmith.client.Client#langsmith.client.Client.list_runs), please refer to the [exporting traces guide](./export-traces) for more information.

## Creating and Applying Filters

### Filtering by run attributes

There are two ways to filter runs in a tracing project:

1. **Filters**: Located towards the top-left of the tracing projects page. This is where you construct and manage detailed filter criteria.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=d3751c19f28b7dffecec87e27d6c6d53" alt="Filtering" data-og-width="1156" width="1156" data-og-height="551" height="551" data-path="langsmith/images/filter.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f03bd4a75a5b8b0cc2cb2d96b0908000 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=68f5583f17be5060e8815ae14edd6619 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=35af2365bef2b299b70e336209c54797 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=fc2bc02daf5f56c914cd0cf7f274d200 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=e45165a47a471aaf0e94dcb5e2abbb7d 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=98ee26df269a2bdabad8a3f5bea1211a 2500w" />

2. **Filter Shortcuts**: Positioned on the right sidebar of the tracing projects page. The filter shortcuts bar provides quick access to filters based on the most frequently occurring attributes in your project's runs.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=c70333d17e9f38f813a6ddef017c7a29" alt="Filter Shortcuts" data-og-width="1330" width="1330" data-og-height="1078" height="1078" data-path="langsmith/images/filter-shortcuts.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=b2e073e3f070674704f3f6506e851bc2 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=dbdcf6272d1f115a158f4b1dad02f4b7 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=808645fd9ebcd95e424b8b0a47a75cde 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=de2a53f560cfaecb13673b400a46de55 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=73ac5c2913b9e13ae99822c2a80b290e 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-shortcuts.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f126680bfdf0fe958a7cc06429387582 2500w" />

<Info>
  **Default filter**

By default, the `IsTrace` is `true` filter is applied. This displays only top-level traces. Removing this filter will show all runs, including intermediate spans, in the project.
</Info>

### Filtering by time range

In addition to filtering by run attributes, you can also filter runs within a specific time range. This option is available towards the top-left of the tracing projects page.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=214ec0a0bcec5e5bf07a54becec35a80" alt="Filtering on time" data-og-width="1325" width="1325" data-og-height="680" height="680" data-path="langsmith/images/filter-time.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=cf9a2351d13ebfcada25090fc8a56f6e 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=35ef8e40fcb515e8b9b9b98d49312521 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7c69f28b9a1debb36dd1929292d0dca3 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=a538ee5b3b711f1d257cc733e701ef0c 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=acb075b10621f69b098b929fc64d54d3 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-time.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=e11f9d866b5ad3b89a29fad8167f5aac 2500w" />

The available filter operators depend on the data type of the attribute you are filtering on. Here's an overview of common operators:

* **is**: Exact match on the filter value
* **is not**: Negative match on the filter value
* **contains**: Partial match on the filter value
* **does not contain**: Negative partial match on the filter value
* **is one of**: Match on any of the values in the list
* `>` / `<`: Available for numeric fields

## Specific Filtering Techniques

### Filter for intermediate runs (spans)

In order to filter for intermediate runs (spans), you first need to remove the default `IsTrace` is `true` filter. For example, you would do this if you wanted to filter by `run name` for sub runs or filter by `run type`.

Run metadata and tags are also powerful to filter on. These rely on good tagging across all parts of your pipeline. To learn more, you can check out [this guide](./add-metadata-tags).

### Filter based on inputs and outputs

You can filter runs based on the content in the inputs and outputs of the run.

To filter either inputs or outputs, you can use the `Full-Text Search` filter which will match keywords in either field. For more targeted search, you can use the `Input` or `Output` filters which will only match content based on the respective field.

<Note>
  For performance, we index up to 250 characters of data for full-text search. If your search query exceeds this limit, we recommend using [Input/Output key-value search](/langsmith/filter-traces-in-application#filter-based-on-input-%2F-output-key-value-pairs) instead.
</Note>

You can also specify multiple matches, either by including multiple terms separated by whitespace, or adding multiple filters - which will try to match all terms provided.

Note that keyword search is done by splitting the text and finding any partial matches on the search keywords, so it is not done in specific order. We exclude common stop words from the search (from the nltk stop word list along with a few other common JSON keywords).

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=9d233d67218491a50cc759335a8ce6fa" alt="Filtering" data-og-width="368" width="368" data-og-height="301" height="301" data-path="langsmith/images/filter-full-text.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=bf7a2397bf1fda0c41a460bd8c2ae9f2 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=2ca993100e989cdfe8628b0d788fbd37 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=1c379c825a1759dc3e13f7c182475159 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7e1eab353b75b25d22a901a01caff403 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8fd894a5a8725b5f048bcc9d03b27d07 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-full-text.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f3a68f1e2dc9ab3451f1d5e10733322c 2500w" />

Based on the filters above, the system will search for `python` and `tensorflow` in either inputs or outputs, and `embedding` in the inputs along with `fine` and `tune` in the outputs.

### Filter based on input / output key-value pairs

In addition to full-text search, you can filter runs based on specific key-value pairs in the inputs and outputs. This allows for more precise filtering, especially when dealing with structured data.

<Note>
  We index up to 100 unique keys to keep your data organized and searchable. Each key also has a character limit of 250 characters per value. If your data exceeds either of these limits, the text won't be indexed. This helps us ensure fast, reliable performance.
</Note>

To filter based on key-value pairs, select the `Input Key` or `Output Key` filter from the filters dropdown.

For example, to match the following input:

Select `Filters`, `Add Filter` to bring up the filtering options. Then select `Input Key`, enter `input` as the key and enter `What is the capital of France?` as the value.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=fef9d6d6bb8c6d285df898ce9c93f192" alt="Filtering" data-og-width="575" width="575" data-og-height="132" height="132" data-path="langsmith/images/search-kv-input.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6625f651706eae30b9f1ce9fcbfdb9b2 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=184a5582ff5deba63ca77aa203af7fbc 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=5d7c647a7249e766a43b9f0995a60ab1 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=901d0c7b928a44a753d42058aad52a8e 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=cbb901c4a190590ebc194999cf525260 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=7614d23d5ba9e06b8673905ef93e6fb5 2500w" />

You can also match nested keys by using dot notation to select the nested key name. For example, to match nested keys in the output:

Select `Output Key`, enter `documents.page_content` as the key and enter `The capital of France is Paris` as the value. This will match the nested key `documents.page_content` with the specified value.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6d66e1d62691463e05a7933bb3b2c0ce" alt="Filtering" data-og-width="708" width="708" data-og-height="95" height="95" data-path="langsmith/images/search-kv-output.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a7f623484a5b5b5ab4c8a83f1288bed0 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=1756043b13d848b8b61043a88c06aa43 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=eef83852d80520b9941d72fe41cc4d64 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=683073a1b186796b7b9892748c1fbd94 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=1fdf9cf2ef7eaf699e0d7212ef2ea2ea 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=e8ab34552881a97fe451bfc3794b6cbb 2500w" />

You can add multiple key-value filters to create more complex queries. You can also use the `Filter Shortcuts` on the right side to quickly filter based on common key-value pairs as shown below:

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9cec4279c975c71e67710c606a2dc700" alt="Filtering" data-og-width="637" width="637" data-og-height="702" height="702" data-path="langsmith/images/search-kv-filter-shortcut.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=667fbfc50987837e0f0188b8d1dbf1ca 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ef422e47304d43568ae954e35c7b1764 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c84e0935eb05be46679d57bb86219d07 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ee8dcaf98f8fd9dc65d5b7f17df1804a 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=d0b79382681256ab905af3fc0d7c5660 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=8da0c834fad83b17d5cdf69bdd1ccb64 2500w" />

### Example: Filtering for tool calls

It's common to want to search for traces that contain specific tool calls. Tool calls are typically indicated in the output of an LLM run. To filter for tool calls, you would use the `Output Key` filter.

While this example will show you how to filter for tool calls, the same logic can be applied to filter for any key-value pair in the output.

In this case, let's assume this is the output you want to filter for:

With the example above, the KV search will map each nested JSON path as a key-value pair that you can use to search and filter.

LangSmith will break it into the following set of searchable key-value pairs:

| Key                                                | Value                                                                        |
| -------------------------------------------------- | ---------------------------------------------------------------------------- |
| `generations.type`                                 | `ChatGeneration`                                                             |
| `generations.message.type`                         | `constructor`                                                                |
| `generations.message.kwargs.type`                  | `ai`                                                                         |
| `generations.message.kwargs.id`                    | `run-ca7f7531-f4de-4790-9c3e-960be7f8b109`                                   |
| `generations.message.kwargs.tool_calls.name`       | `Plan`                                                                       |
| `generations.message.kwargs.tool_calls.args.steps` | `Research LangGraph's node configuration capabilities`                       |
| `generations.message.kwargs.tool_calls.args.steps` | `Investigate how to add a Python code execution node`                        |
| `generations.message.kwargs.tool_calls.args.steps` | `Find an example or create a sample implementation of a code execution node` |
| `generations.message.kwargs.tool_calls.id`         | `toolu_01XexPzAVknT3gRmUB5PK5BP`                                             |
| `generations.message.kwargs.tool_calls.type`       | `tool_call`                                                                  |
| `type`                                             | `LLMResult`                                                                  |

To search for a specific tool call, you can use the following Output Key search while removing the root runs filter:

`generations.message.kwargs.tool_calls.name` = `Plan`

This will match root and non-root runs where the `tool_calls` name is `Plan`.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9d763b8572d14db7f1bc59a3cf4b08a5" alt="Filtering" data-og-width="629" width="629" data-og-height="98" height="98" data-path="langsmith/images/search-kv-tool.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9cd9ec450a02572f4bdcec3850bbf4c2 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a0988bd110eb51fc73f7e5e2875117b2 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=21710580f012a7a62eeaf528f735f4c9 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=5778f4ef1f156e7d2d0a04f45339aa72 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ae736245285787c485a6a085e5eec65e 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=178a7e4dec57f7260393ee8d0b16030a 2500w" />

### Negative filtering on key-value pairs

Different types of negative filtering can be applied to `Metadata`, `Input Key`, and `Output Key` fields to exclude specific runs from your results.

For example, to find all runs where the metadata key `phone` is not equal to `1234567890`, set the `Metadata` `Key` operator to `is` and `Key` field to `phone`, then set the `Value` operator to `is not` and the `Value` field to `1234567890`. This will match all runs that have a metadata key `phone` with any value except `1234567890`.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=acbd683725e073e1ac78b8ba132e6d43" alt="Filtering" data-og-width="549" width="549" data-og-height="100" height="100" data-path="langsmith/images/negative-filtering-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=a0fd6f85165cae0ca7a7d96be57805e1 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=714cdc9f0ad4e6c2b67d49d79740e9b2 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=cf74951b9cf760cbd6c5653b6d15b95a 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=4ae07131bdb12d5e6c5676e51f54ee7c 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=bfb45574bec84ad88d9866b025ac61ba 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-1.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=e4a74fca06b1bf2940f15528b04f1b21 2500w" />

To find runs that don't have a specific metadata key, set the `Key` operator to `is not`. For example, setting the `Key` operator to `is not` with `phone` as the key will match all runs that don't have a `phone` field in their metadata.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=2c298181ed0aef202ca52f5c30b3d62b" alt="Filtering" data-og-width="419" width="419" data-og-height="128" height="128" data-path="langsmith/images/negative-filtering-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=cb11546a30cf22c9653c05519b263409 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=6a7f5a2ac54f187e449f24011af6f160 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=161ed2a1433d0fa695ef527b32292ee6 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=d7f8b99d1af28d2e27cdab3c3b03fdad 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ef65a43c85924cf25da164bc049e7029 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-2.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=5c79162abd3187782b27f06f28a9d590 2500w" />

You can also filter for runs that neither have a specific key nor a specific value. To find runs where the metadata has neither the key `phone` nor any field with the value `1234567890`, set the `Key` operator to `is not` with key `phone`, and the `Value` operator to `is not` with value `1234567890`.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=18ca1b82babfda201b184a8884d120eb" alt="Filtering" data-og-width="571" width="571" data-og-height="125" height="125" data-path="langsmith/images/negative-filtering-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=50c9bee0afc47df246ddb3313e1b7784 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=5bbf4d4da70355e861ce7b7adf5ca4b5 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ba52269765451c26687cc7b74a572a68 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=6b2b21485dc7073c4edc8b0d1b6718b1 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=18b134952892cc7e5203a5dfaa25eda4 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-3.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=f546a96e2b6b229cc593e8a31ec7572f 2500w" />

Finally, you can also filter for runs that do not have a specific key but have a specific value. To find runs where there is no `phone` key but there is a value of `1234567890` for some other key, set the `Key` operator to `is not` with key `phone`, and the `Value` operator to `is` with value `1234567890`.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=60e118205cc6524432058ce968aad478" alt="Filtering" data-og-width="546" width="546" data-og-height="126" height="126" data-path="langsmith/images/negative-filtering-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=edd2fee83ba3d63bd8a44f82cfc2c66c 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=20bfead7865f62ee4db7890734c811ac 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=42d6832b0db4843441c5a8dcd95c88b7 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=6361c16f6321f6f47ca83867f3f5bfbd 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=6fcbe01d2be9672356101c4b9a585e78 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/negative-filtering-4.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=4dcb53d4331f8a1802ec49b1c3d1971a 2500w" />

Note that you can use the `does not contain` operator instead of `is not` to perform a substring match.

Saving filters allows you to store and reuse frequently used filter configurations. Saved filters are specific to a tracing project.

In the filter box, click the **Save filter** button after you have constructed your filter. This will bring up a dialog to specify the name and a description of the filter.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=27236a7b0e60a352d16b7affd9b913e5" alt="Filtering" data-og-width="854" width="854" data-og-height="775" height="775" data-path="langsmith/images/save-a-filter.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=8bf93a5ab643e0f0ef5194529a084879 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6cb4d039bf74e97e65688465707560ab 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=381acf9bb9f3c2443faeb4dc0c84506f 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=fd1660d33217beb5031de6546ff2cdf7 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=4b4bc3898549d5f505d0e8989307d5f4 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/save-a-filter.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a9927179e81ace45255aef6a99c77aa3 2500w" />

#### Use a saved filter

After saving a filter, it is available in the filter bar as a quick filter for you to use. If you have more than three saved filters, only two will be displayed directly, with the rest accessible via a "more" menu. You can use the settings icon in the saved filter bar to optionally hide default saved filters.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=89774c393f6303c981adeba6750f7cad" alt="Filtering" data-og-width="1256" width="1256" data-og-height="404" height="404" data-path="langsmith/images/selecting-a-filter.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a204feab24664b271ddc70ea8dd60698 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=4806fcac0a82770fccdb66b06181736e 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9600c7b41c39c9759347a7a5f6ba7d4d 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=2f4a06c4a4dd87c995b54cae9f177e23 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=5f5df78152c343362d6f3ba0c7a9a82a 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/selecting-a-filter.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9d681b4c6a42c7c4a9440525bb1a3557 2500w" />

#### Update a saved filter

With the filter selected, make any changes to filter parameters. Then click **Update filter** > **Update** to update the filter.

In the same menu, you can also create a new saved filter by clicking **Update filter** > **Create new**.

#### Delete a saved filter

Click the settings icon in the saved filter bar, and delete a filter using the trash icon.

You can copy a constructed filter to share it with colleagues, reuse it later, or query runs programmatically in the [API](https://api.smith.langchain.com/redoc#tag/run/operation/query_runs_api_v1_runs_query_post) or [SDK](https://docs.smith.langchain.com/reference/python/client/langsmith.client.Client#langsmith.client.Client.list_runs).

In order to copy the filter, you can first create it in the UI. From there, you can click the copy button in the upper right hand corner. If you have constructed tree or trace filters, you can also copy those.

This will give you a string representing the filter in the LangSmith query language. For example: `and(eq(is_root, true), and(eq(feedback_key, "user_score"), eq(feedback_score, 1)))`. For more information on the query language syntax, please refer to [this reference](/langsmith/trace-query-syntax#filter-query-language).

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=f9f60cca965c1466fe58ec4e8cc52ea5" alt="Copy Filter" data-og-width="1123" width="1123" data-og-height="382" height="382" data-path="langsmith/images/copy-filter.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=8966107385058659add5005faa0570d5 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=54cdbad3c852e011f1bbf9bf59cd553d 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=198de895cd5c70de24e72b9eb5f8975d 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b500fb05f2705eb74157d5a1ba2bebbe 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=67cdd3110def30e481ec0266eaffac66 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/copy-filter.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=f2366d6a3ab857b74bcbd551122ec350 2500w" />

## Filtering runs within the trace view

You can also apply filters directly within the trace view, which is useful for sifting through traces with a large number of runs. The same filters available in the main runs table view can be applied here.

By default, only the runs that match the filters will be shown. To see the matched runs within the broader context of the trace tree, switch the view option from "Filtered Only" to "Show All" or "Most relevant".

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=13ea9f30d6efd9bb3f96c8c2376a6858" alt="Filtering within trace view" data-og-width="1341" width="1341" data-og-height="764" height="764" data-path="langsmith/images/filter-runs-in-trace-view.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=506069ddcc28d8959213f1bfa5d4d2eb 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8b4e2a130a76953f7291e983fb13c86d 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f702ad52060f28de4febdc556daafc6e 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4c6506211f69e03b54793fce9c85760b 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=ad5849855b303c6357705708e038a9d6 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/filter-runs-in-trace-view.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=6fd17200291f3c6eb680861aa1ab7d80 2500w" />

## Manually specify a raw query in LangSmith query language

If you have [copied a previously constructed filter](/langsmith/filter-traces-in-application#copy-the-filter), you may want to manually apply this raw query in a future session.

In order to do this, you can click on **Advanced filters** on the bottom of the filters popover. From there you can paste a raw query into the text box.

Note that this will add that query to the existing queries, not overwrite it.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=0657c7420e760fb57782531d039c0b0d" alt="Raw Query" data-og-width="495" width="495" data-og-height="570" height="570" data-path="langsmith/images/raw-query.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=8ebe5718f7e50c0e5186d23ea6467620 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=121dab45e0a3f1599ad9dd26132f2c59 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=0d3ca66c6498f2c1d4e33bf4b63068e8 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ef61bc19b9fe41eb0e5d80566049e288 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ccaeac2952f3a2fde4d99c5d69c8055d 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/raw-query.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=f15ec18a7e3cb748defc6d10c3033d28 2500w" />

## Use an AI Query to auto-generate a query (Experimental)

Sometimes figuring out the exact query to specify can be difficult! In order to make it easier, we've added an `AI Query` functionality. With this, you can type in the filter you want to construct in natural language and it will convert it into a valid query.

For example: "All runs longer than 10 seconds"

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=ef4266d159753dacafbd5af2bcad0ab8" alt="AI Query" data-og-width="464" width="464" data-og-height="319" height="319" data-path="langsmith/images/ai-query.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=9589aa2ef6d4fd16533c0b9123ab552e 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=f03177102e2c6fa2ec2043bce0d3aa7d 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=3f6c3c22f37565790e77fa8a55e459a6 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8ba2568d2044c01364206560d7dd8efc 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8bf30e3c64545cca142bf0a6745e19f6 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/ai-query.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=c38f6e1b2e00ef271d25f9f674aa27a4 2500w" />

### Filter for intermediate runs (spans) on properties of the root

A common concept is to filter for intermediate runs which are part of a trace whose root run has some attribute. An example is filtering for intermediate runs of a particular type whose root run has positive (or negative) feedback associated with it.

In order to do this, first set up a filter for intermediate runs (per the above section). After that, you can then add another filter rule. You can then click the `Advanced Filters` link all the way at the bottom of the filter. This will open up a new modal where you can add `Trace filters`. These filters will apply to the traces of all the parent runs of the individual runs you've already filtered for.

<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=a520558efb53e4dd3d6751db76739f90" alt="Filtering" data-og-width="551" width="551" data-og-height="542" height="542" data-path="langsmith/images/trace-filter.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=5303c1b8db95a047593d52ff52ebc55f 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=d21e37d06556b6cd20d88c6b72293f68 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=700e831f6c8d473bb9eb3beca7131b4e 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=43467c081d7cfc83582220fe6b7266fe 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9cda650d2069d852c95d8e51893e424d 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-filter.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=f0fa57df70f665ef672c917fe6231c15 2500w" />

### Filter for runs (spans) whose child runs have some attribute

This is the opposite of the above. You may want to search for runs who have specific types of sub runs. An example of this could be searching for all traces that had a sub run with name `Foo`. This is useful when `Foo` is not always called, but you want to analyze the cases where it is.

In order to do this, you can click on the `Advanced Filters` link all the way at the bottom of the filter. This will open up a new modal where you can add `Tree filters`. This will make the rule you specify apply to all child runs of the individual runs you've already filtered for.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6b70fc03e9f46333d7af3566619204f0" alt="Filtering" data-og-width="471" width="471" data-og-height="602" height="602" data-path="langsmith/images/child-runs.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=4e7f54072ed1f198804ffca3e073710c 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=2c9e7b6627d5edece1b4f90879c03310 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=265d349fc921cf06be7910f20f275a5e 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8445bba9df0671da9e718e63c4e2cc48 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=cfd020e86ca4b5e2cc77ee43a0c35746 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/child-runs.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=199dab9b8f3adbaecadf3c2206ab008c 2500w" />

### Example: Filtering on all runs whose tree contains the tool call filter

Extending the [tool call filtering example](/langsmith/filter-traces-in-application#example-filtering-for-tool-calls) from above, if you would like to filter for all runs *whose tree contains* the tool filter call, you can use the tree filter in the [advanced filters](/langsmith/filter-traces-in-application#advanced-filters) setting:

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=b11deac10cd42be7efff94134658b25b" alt="Filtering" data-og-width="669" width="669" data-og-height="462" height="462" data-path="langsmith/images/search-kv-tool-tree.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=3f487a02af0891c8c97935b8674d8aba 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=4334fbf4536432920e35d1df4f5cff2e 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c7b2edb49f520ebe3e2f03651c8d9d39 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6c107e48006c1ee4d2246935b1259595 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=be785994ef014f06767d1001f5d5dbf1 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-tool-tree.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c686bc45b1d33a12ddcc89aa9c5c0a35 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/filter-traces-in-application.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
Select `Filters`, `Add Filter` to bring up the filtering options. Then select `Input Key`, enter `input` as the key and enter `What is the capital of France?` as the value.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=fef9d6d6bb8c6d285df898ce9c93f192" alt="Filtering" data-og-width="575" width="575" data-og-height="132" height="132" data-path="langsmith/images/search-kv-input.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6625f651706eae30b9f1ce9fcbfdb9b2 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=184a5582ff5deba63ca77aa203af7fbc 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=5d7c647a7249e766a43b9f0995a60ab1 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=901d0c7b928a44a753d42058aad52a8e 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=cbb901c4a190590ebc194999cf525260 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-input.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=7614d23d5ba9e06b8673905ef93e6fb5 2500w" />

You can also match nested keys by using dot notation to select the nested key name. For example, to match nested keys in the output:
```

Example 2 (unknown):
```unknown
Select `Output Key`, enter `documents.page_content` as the key and enter `The capital of France is Paris` as the value. This will match the nested key `documents.page_content` with the specified value.

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=6d66e1d62691463e05a7933bb3b2c0ce" alt="Filtering" data-og-width="708" width="708" data-og-height="95" height="95" data-path="langsmith/images/search-kv-output.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=a7f623484a5b5b5ab4c8a83f1288bed0 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=1756043b13d848b8b61043a88c06aa43 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=eef83852d80520b9941d72fe41cc4d64 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=683073a1b186796b7b9892748c1fbd94 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=1fdf9cf2ef7eaf699e0d7212ef2ea2ea 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-output.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=e8ab34552881a97fe451bfc3794b6cbb 2500w" />

You can add multiple key-value filters to create more complex queries. You can also use the `Filter Shortcuts` on the right side to quickly filter based on common key-value pairs as shown below:

<img src="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=9cec4279c975c71e67710c606a2dc700" alt="Filtering" data-og-width="637" width="637" data-og-height="702" height="702" data-path="langsmith/images/search-kv-filter-shortcut.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=280&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=667fbfc50987837e0f0188b8d1dbf1ca 280w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=560&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ef422e47304d43568ae954e35c7b1764 560w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=840&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=c84e0935eb05be46679d57bb86219d07 840w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=1100&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=ee8dcaf98f8fd9dc65d5b7f17df1804a 1100w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=1650&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=d0b79382681256ab905af3fc0d7c5660 1650w, https://mintcdn.com/langchain-5e9cc07a/Fr2lazPB4XVeEA7l/langsmith/images/search-kv-filter-shortcut.png?w=2500&fit=max&auto=format&n=Fr2lazPB4XVeEA7l&q=85&s=8da0c834fad83b17d5cdf69bdd1ccb64 2500w" />

### Example: Filtering for tool calls

It's common to want to search for traces that contain specific tool calls. Tool calls are typically indicated in the output of an LLM run. To filter for tool calls, you would use the `Output Key` filter.

While this example will show you how to filter for tool calls, the same logic can be applied to filter for any key-value pair in the output.

In this case, let's assume this is the output you want to filter for:
```

---

## Instrument AutoGen and OpenAI calls

**URL:** llms-txt#instrument-autogen-and-openai-calls

**Contents:**
  - 3. Create and run your AutoGen application

AutogenInstrumentor().instrument()
OpenAIInstrumentor().instrument()
python  theme={null}
import autogen
from openinference.instrumentation.autogen import AutogenInstrumentor
from openinference.instrumentation.openai import OpenAIInstrumentor
from langsmith.integrations.otel import configure
import os
import dotenv

**Examples:**

Example 1 (unknown):
```unknown
<Note>
  You do not need to set any OpenTelemetry environment variables or configure exporters manually—`configure()` handles everything automatically.
</Note>

### 3. Create and run your AutoGen application

Once configured, your AutoGen application will automatically send traces to LangSmith:
```

---

## for every request. This will determine whether the request is allowed or not

**URL:** llms-txt#for-every-request.-this-will-determine-whether-the-request-is-allowed-or-not

**Contents:**
- 3. Test your bot
- 4. Chat with your bot

@auth.authenticate
async def get_current_user(authorization: str | None) -> Auth.types.MinimalUserDict:
    """Check if the user's token is valid."""
    assert authorization
    scheme, token = authorization.split()
    assert scheme.lower() == "bearer"
    # Check if token is valid
    if token not in VALID_TOKENS:
        raise Auth.exceptions.HTTPException(status_code=401, detail="Invalid token")

# Return user info if valid
    user_data = VALID_TOKENS[token]
    return {
        "identity": user_data["id"],
    }
json {highlight={7-9}} title="langgraph.json" theme={null}
{
  "dependencies": ["."],
  "graphs": {
    "agent": "./src/agent/graph.py:graph"
  },
  "env": ".env",
  "auth": {
    "path": "src/security/auth.py:auth"
  }
}
bash  theme={null}
langgraph dev --no-browser
json  theme={null}
{
    "auth": {
        "path": "src/security/auth.py:auth",
        "disable_studio_auth": true
    }
}
python  theme={null}
from langgraph_sdk import get_client

**Examples:**

Example 1 (unknown):
```unknown
Notice that your [Auth.authenticate](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.auth.Auth.authenticate) handler does two important things:

1. Checks if a valid token is provided in the request's [Authorization header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Authorization)
2. Returns the user's [MinimalUserDict](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.auth.types.MinimalUserDict)

Now tell LangGraph to use authentication by adding the following to the @\[langgraph.json] configuration:
```

Example 2 (unknown):
```unknown
## 3. Test your bot

Start the server again to test everything out:
```

Example 3 (unknown):
```unknown
If you didn't add the `--no-browser`, the Studio UI will open in the browser. By default, we also permit access from Studio, even when using custom auth. This makes it easier to develop and test your bot in Studio. You can remove this alternative authentication option by setting `disable_studio_auth: true` in your auth configuration:
```

Example 4 (unknown):
```unknown
## 4. Chat with your bot

You should now only be able to access the bot if you provide a valid token in the request header. Users will still, however, be able to access each other's resources until you add [resource authorization handlers](/langsmith/auth#resource-specific-handlers) in the next section of the tutorial.

<img src="https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=3ccfa86789baea630b8f418e9eb5b648" alt="Auth gate passes requests with a valid token, but no per-resource filters are applied yet—so users share visibility until authorization handlers are added in the next step." data-og-width="2617" width="2617" data-og-height="1673" height="1673" data-path="langsmith/images/authentication.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=280&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=0216c0cf0cb74f67f43e65561a787c96 280w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=560&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=c4a9ab37e2413a38dc61ef6f4288c1b1 560w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=840&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=d1146dee549ab13c949efae260706988 840w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=1100&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=e430d8ebe4534d20c1d4d3d887f0c938 1100w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=1650&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=3aeaa334e3ff1457c165821966721f94 1650w, https://mintcdn.com/langchain-5e9cc07a/IMK8wJkjSpMCGODD/langsmith/images/authentication.png?w=2500&fit=max&auto=format&n=IMK8wJkjSpMCGODD&q=85&s=74d6dd4c73baa0182624085d13f08530 2500w" />

Run the following code in a file or notebook:
```

---

## After: Graph API

**URL:** llms-txt#after:-graph-api

class WorkflowState(TypedDict):
    input_data: dict
    step1_result: dict
    analysis: dict
    final_result: dict

def should_analyze(state):
    return "analyze" if state["step1_result"]["needs_analysis"] else "simple_path"

def confidence_check(state):
    return "high_confidence" if state["analysis"]["confidence"] > 0.8 else "low_confidence"

workflow = StateGraph(WorkflowState)
workflow.add_node("step1", process_step1_node)
workflow.add_conditional_edges("step1", should_analyze)
workflow.add_node("analyze", analyze_data_node)
workflow.add_conditional_edges("analyze", confidence_check)

---

## - Age: 25

**URL:** llms-txt#--age:-25

---

## Run the export script with customer information as variables

**URL:** llms-txt#run-the-export-script-with-customer-information-as-variables

**Contents:**
  - Status update

sh run_support_query_pg.sh <postgres_url> \
  --input support_queries/postgres/pg_usage_traces_backfill_export.sql \
  --output ls_export.csv \
  -v customer_id=$CUSTOMER_ID \
  -v customer_name=$CUSTOMER_NAME
bash  theme={null}
sh run_support_query_pg.sh <postgres_url> \
  --input support_queries/postgres/pg_usage_nodes_backfill_export.sql \
  --output lgp_export.csv \
  -v customer_id=$CUSTOMER_ID \
  -v customer_name=$CUSTOMER_NAME
bash  theme={null}
sh run_support_query_pg.sh <postgres_url> --input support_queries/postgres/pg_usage_traces_backfill_update.sql --output export.csv -v backfill_id=<backfill_id>
bash  theme={null}
sh run_support_query_pg.sh <postgres_url> --input support_queries/postgres/pg_usage_nodes_backfill_update.sql --output export.csv -v backfill_id=<backfill_id>
```

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/script-running-pg-support-queries.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
To export LangSmith usage:
```

Example 2 (unknown):
```unknown
### Status update

These scripts update the status of usage events in your installation to reflect that the events have been successfully processed by LangChain.

The scripts require passing in the corresponding `backfill_id`, which will be confirmed by your LangChain rep.

To update LangSmith trace usage:
```

Example 3 (unknown):
```unknown
To update LangSmith usage:
```

---

## TodoListMiddleware is included by default in create_deep_agent

**URL:** llms-txt#todolistmiddleware-is-included-by-default-in-create_deep_agent

---

## Setup claude_agent_sdk with langsmith tracing

**URL:** llms-txt#setup-claude_agent_sdk-with-langsmith-tracing

configure_claude_agent_sdk()

@tool(
    "get_weather",
    "Gets the current weather for a given city",
    {
        "city": str,
    },
)
async def get_weather(args: dict[str, Any]) -> dict[str, Any]:
    """Simulated weather lookup tool"""
    city = args["city"]

# Simulated weather data
    weather_data = {
        "San Francisco": "Foggy, 62°F",
        "New York": "Sunny, 75°F",
        "London": "Rainy, 55°F",
        "Tokyo": "Clear, 68°F",
    }

weather = weather_data.get(city, "Weather data not available")
    return {"content": [{"type": "text", "text": f"Weather in {city}: {weather}"}]}

async def main():
    # Create SDK MCP server with the weather tool
    weather_server = create_sdk_mcp_server(
        name="weather",
        version="1.0.0",
        tools=[get_weather],
    )

options = ClaudeAgentOptions(
        model="claude-sonnet-4-5-20250929",
        system_prompt="You are a friendly travel assistant who helps with weather information.",
        mcp_servers={"weather": weather_server},
        allowed_tools=["mcp__weather__get_weather"],
    )

async with ClaudeSDKClient(options=options) as client:
        await client.query("What's the weather like in San Francisco and Tokyo?")

async for message in client.receive_response():
            print(message)

if __name__ == "__main__":
    asyncio.run(main())
```

Once configured, all Claude Agent SDK operations will be automatically traced to LangSmith, including:

* Agent queries and responses
* Tool invocations and results
* Claude model interactions
* MCP server operations

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/trace-claude-agent-sdk.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## BedrockChat

**URL:** llms-txt#bedrockchat

**Contents:**
- Overview
  - Integration details
  - Model features
- Setup
  - Credentials

Source: https://docs.langchain.com/oss/javascript/integrations/chat/bedrock

[Amazon Bedrock](https://aws.amazon.com/bedrock/) is a fully managed service that offers a choice of high-performing foundation models (FMs) from leading AI companies like AI21 Labs, Anthropic, Cohere, Meta, Stability AI, and Amazon via a single API, along with a broad set of capabilities you need to build generative AI applications with security, privacy, and responsible AI.

This will help you getting started with Amazon Bedrock [chat models](/oss/javascript/langchain/models). For detailed documentation of all `BedrockChat` features and configurations head to the [API reference](https://api.js.langchain.com/classes/langchain_community_chat_models_bedrock.BedrockChat.html).

<Tip>
  The newer [`ChatBedrockConverse` chat model is now available via the dedicated `@langchain/aws`](/oss/javascript/integrations/chat/bedrock_converse) integration package. Use [tool calling](/oss/javascript/langchain/tools) with more models with this package.
</Tip>

### Integration details

| Class                                                                                                          | Package                                                          | Local | Serializable | [PY support](https://python.langchain.com/docs/integrations/chat/bedrock/) |                                               Downloads                                              |                                              Version                                              |
| :------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------- | :---: | :----------: | :------------------------------------------------------------------------: | :--------------------------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------: |
| [`BedrockChat`](https://api.js.langchain.com/classes/langchain_community_chat_models_bedrock.BedrockChat.html) | [`@langchain/community`](https://npmjs.com/@langchain/community) |   ❌   |       ✅      |                                      ✅                                     | ![NPM - Downloads](https://img.shields.io/npm/dm/@langchain/community?style=flat-square\&label=%20&) | ![NPM - Version](https://img.shields.io/npm/v/@langchain/community?style=flat-square\&label=%20&) |

See the links in the table headers below for guides on how to use specific features.

| [Tool calling](/oss/javascript/langchain/tools) | [Structured output](/oss/javascript/langchain/structured-output) | JSON mode | [Image input](/oss/javascript/langchain/messages#multimodal) | Audio input | Video input | [Token-level streaming](/oss/javascript/langchain/streaming/) | [Token usage](/oss/javascript/langchain/models#token-usage) | [Logprobs](/oss/javascript/langchain/models#log-probabilities) |
| :---------------------------------------------: | :--------------------------------------------------------------: | :-------: | :----------------------------------------------------------: | :---------: | :---------: | :-----------------------------------------------------------: | :---------------------------------------------------------: | :------------------------------------------------------------: |
|                        ✅                        |                                 ✅                                |     ❌     |                               ✅                              |      ❌      |      ❌      |                               ✅                               |                              ✅                              |                                ❌                               |

To access Bedrock models you'll need to create an AWS account, set up the Bedrock API service, get an access key ID and secret key, and install the `@langchain/community` integration package.

Head to the [AWS docs](https://docs.aws.amazon.com/bedrock/latest/userguide/getting-started.html) to sign up for AWS and setup your credentials. You'll also need to turn on model access for your account, which you can do by [following these instructions](https://docs.aws.amazon.com/bedrock/latest/userguide/model-access.html).

If you want to get automated tracing of your model calls you can also set your [LangSmith](https://docs.smith.langchain.com/) API key by uncommenting below:

```bash  theme={null}

---

## Integrations

**URL:** llms-txt#integrations

Source: https://docs.langchain.com/oss/python/reference/integrations-python

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/reference/integrations-python.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Log LLM calls

**URL:** llms-txt#log-llm-calls

**Contents:**
- Messages Format
  - Examples
- Converting custom I/O formats into LangSmith compatible formats
- Identifying a custom model in traces
- Provide token and cost information
- Time-to-first-token

Source: https://docs.langchain.com/langsmith/log-llm-trace

This guide will cover how to log LLM calls to LangSmith when you are using a custom model or a custom input/output format. To make the most of LangSmith's LLM trace processing, you should log your LLM traces in one of the specified formats.

LangSmith offers the following benefits for LLM traces:

* Rich, structured rendering of message lists
* Token and cost tracking per LLM call, per trace and across traces over time

If you don't log your LLM traces in the suggested formats, you will still be able to log the data to LangSmith, but it may not be processed or rendered in expected ways.

If you are using [LangChain OSS](https://python.langchain.com/docs/tutorials/llm_chain/) to call language models or LangSmith wrappers ([OpenAI](/langsmith/trace-openai), [Anthropic](/langsmith/trace-anthropic)), these approaches will automatically log traces in the correct format.

<Note>
  The examples on this page use the `traceable` decorator/wrapper to log the model run (which is the recommended approach for Python and JS/TS). However, the same idea applies if you are using the [RunTree](/langsmith/annotate-code#use-the-runtree-api) or [API](https://api.smith.langchain.com/redoc) directly.
</Note>

When tracing a custom model or a custom input/output format, it must either follow the LangChain format, OpenAI completions format or Anthropic messages format. For more details,  refer to the [OpenAI Chat Completions](https://platform.openai.com/docs/api-reference/chat/create) or [Anthropic Messages](https://docs.claude.com/en/api/messages) documentation. The LangChain format is:

<Expandable title="LangChain format">
  <ParamField path="messages" type="array" required>
    A list of messages containing the content of the conversation.

<ParamField path="role" type="string" required>
      Identifies the message type. One of: <code>system</code> | <code>reasoning</code> | <code>user</code> | <code>assistant</code> | <code>tool</code>
    </ParamField>

<ParamField path="content" type="array" required>
      Content of the message. List of typed dictionaries.

<Expandable title="Content options">
        <ParamField path="type" type="string" required>
          One of: <code>text</code> | <code>image</code> | <code>file</code> | <code>audio</code> | <code>video</code> | <code>tool\_call</code> | <code>server\_tool\_call</code> | <code>server\_tool\_result</code>.
        </ParamField>

<Expandable title="text">
          <ParamField path="type" type="literal('text')" required />

<ParamField path="text" type="string" required>
            Text content.
          </ParamField>

<ParamField path="annotations" type="object[]">
            List of annotations for the text
          </ParamField>

<ParamField path="extras" type="object">
            Additional provider-specific data.
          </ParamField>
        </Expandable>

<Expandable title="reasoning">
          <ParamField path="type" type="literal('reasoning')" required />

<ParamField path="text" type="string" required>
            Text content.
          </ParamField>

<ParamField path="extras" type="object">
            Additional provider-specific data.
          </ParamField>
        </Expandable>

<Expandable title="image">
          <ParamField path="type" type="literal('image')" required />

<ParamField path="url" type="string">
            URL pointing to the image location.
          </ParamField>

<ParamField path="base64" type="string" required>
            Base64-encoded image data.
          </ParamField>

<ParamField path="id" type="string">
            Reference ID to an externally stored image (e.g., in a provider’s file system or in a bucket).
          </ParamField>

<ParamField path="mime_type" type="string">
            Image [MIME type](https://www.iana.org/assignments/media-types/media-types.xhtml#image) (e.g., `image/jpeg`, `image/png`).
          </ParamField>
        </Expandable>

<Expandable title="file (e.g., PDFs)">
          <ParamField path="type" type="literal('file')" required />

<ParamField path="url" type="string">
            URL pointing to the file.
          </ParamField>

<ParamField path="base64" type="string" required>
            Base64-encoded file data.
          </ParamField>

<ParamField path="id" type="string">
            Reference ID to an externally stored file (e.g., in a provider’s file system or in a bucket).
          </ParamField>

<ParamField path="mime_type" type="string">
            File [MIME type](https://www.iana.org/assignments/media-types/media-types.xhtml#image) (e.g., `application/pdf`).
          </ParamField>
        </Expandable>

<Expandable title="audio">
          <ParamField path="type" type="literal('audio')" required />

<ParamField path="url" type="string">
            URL pointing to the audio file.
          </ParamField>

<ParamField path="base64" type="string" required>
            Base64-encoded audio data.
          </ParamField>

<ParamField path="id" type="string">
            Reference ID to an externally stored audio file (e.g., in a provider’s file system or in a bucket).
          </ParamField>

<ParamField path="mime_type" type="string">
            Audio [MIME type](https://www.iana.org/assignments/media-types/media-types.xhtml#image) (e.g., `audio/mpeg`, `audio/wav`).
          </ParamField>
        </Expandable>

<Expandable title="video">
          <ParamField path="type" type="literal('video')" required />

<ParamField path="url" type="string">
            URL pointing to the video file.
          </ParamField>

<ParamField path="base64" type="string" required>
            Base64-encoded video data.
          </ParamField>

<ParamField path="id" type="string">
            Reference ID to an externally stored video file (e.g., in a provider’s file system or in a bucket).
          </ParamField>

<ParamField path="mime_type" type="string">
            Video [MIME type](https://www.iana.org/assignments/media-types/media-types.xhtml#image) (e.g., `video/mp4`, `video/webm`).
          </ParamField>
        </Expandable>

<Expandable title="tool_call">
          <ParamField path="type" type="literal('tool_call')" required />

<ParamField path="name" type="string" />

<ParamField path="args" type="object" required>
            Arguments to pass to the tool.
          </ParamField>

<ParamField path="id" type="string">
            Unique identifier for this tool call.
          </ParamField>
        </Expandable>

<Expandable title="server_tool_call">
          <ParamField path="type" type="literal('server_tool_call')" required />

<ParamField path="id" type="string" required>
            Unique identifier for this tool call.
          </ParamField>

<ParamField path="name" type="string" required>
            The name of the tool to be called.
          </ParamField>

<ParamField path="args" type="object" required>
            Arguments to pass to the tool.
          </ParamField>
        </Expandable>

<Expandable title="server_tool_result">
          <ParamField path="type" type="literal('server_tool_result')" required />

<ParamField path="tool_call_id" type="string" required>
            Identifier of the corresponding server tool call.
          </ParamField>

<ParamField path="id" type="string">
            Unique identifier for this tool call.
          </ParamField>

<ParamField path="status" type="string" required>
            Execution status of the server-side tool. One of: <code>success</code> | <code>error</code>.
          </ParamField>

<ParamField path="output">
            Output of the executed tool.
          </ParamField>
        </Expandable>
      </Expandable>
    </ParamField>

<ParamField path="tool_call_id" type="string">
      Must match the <code>id</code> of a prior <code>assistant</code> message’s <code>tool\_calls\[i]</code> entry. Only valid when <code>role</code> is <code>tool</code>.
    </ParamField>

<ParamField path="usage_metadata" type="object">
      Use this field to send token counts and/or costs with your model's output. See [this guide](/langsmith/log-llm-trace#provide-token-and-cost-information) for more details.
    </ParamField>
  </ParamField>
</Expandable>

## Converting custom I/O formats into LangSmith compatible formats

If you're using a custom input or output format, you can convert it to a LangSmith compatible format using `process_inputs`/`processInputs` and `process_outputs`/`processOutputs` functions on the [`@traceable` decorator](https://docs.smith.langchain.com/reference/python/run_helpers/langsmith.run_helpers.traceable) (Python) or [`traceable` function](https://docs.smith.langchain.com/reference/js/functions/traceable.traceable) (TS).

`process_inputs`/`processInputs` and `process_outputs`/`processOutputs` accept functions that allow you to transform the inputs and outputs of a specific trace before they are logged to LangSmith. They have access to the trace's inputs and outputs, and can return a new dictionary with the processed data.

Here's a boilerplate example of how to use `process_inputs` and `process_outputs` to convert a custom I/O format into a LangSmith compatible format:

<Expandable title="the code">
  <CodeGroup>
    
  </CodeGroup>
</Expandable>

## Identifying a custom model in traces

When using a custom model, it is recommended to also provide the following `metadata` fields to identify the model when viewing traces and when filtering.

* `ls_provider`: The provider of the model, eg "openai", "anthropic", etc.
* `ls_model_name`: The name of the model, eg "gpt-4o-mini", "claude-3-opus-20240229", etc.

This code will log the following trace:

<div style={{ textAlign: 'center' }}>
  <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=f152f49a6313d98e29d3a7b42b76c11f" alt="LangSmith UI showing an LLM call trace called ChatOpenAI with a system and human input followed by an AI Output." data-og-width="1169" width="1169" data-og-height="548" height="548" data-path="langsmith/images/chat-model-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=280&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=083affd641c8eb41b0fcce26c8485076 280w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=560&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=8ff2ced008bb1be8db587c40cc4a6cd8 560w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=840&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=8891eae04f01247ec86c6e6b3de7a9cb 840w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=1100&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=3287ed0315422c879ff151bf2561e199 1100w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=1650&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=f9995381307324951553d7cfe8d00cdd 1650w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-light.png?w=2500&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=4fd10d74ce1253b1b3da84e49a439e33 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=1da2f0a1adc972aa6de6df94cbfc1407" alt="LangSmith UI showing an LLM call trace called ChatOpenAI with a system and human input followed by an AI Output." data-og-width="1168" width="1168" data-og-height="563" height="563" data-path="langsmith/images/chat-model-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=280&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=6662af6b4871f8250ab39659fd594df8 280w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=560&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=c3986c36300cef013831eb0ba951b0fc 560w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=840&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=05d5f21e2509e36e8176fb8ace2c1e79 840w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=1100&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=464d2babbc58e4c42b3e720520af680c 1100w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=1650&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=db6c45b71fa4ff605edc8c7f88404ec2 1650w, https://mintcdn.com/langchain-5e9cc07a/9cRCWDFnPjFk6hYc/langsmith/images/chat-model-dark.png?w=2500&fit=max&auto=format&n=9cRCWDFnPjFk6hYc&q=85&s=cffed55abf3973cb5b908725433e001e 2500w" />
</div>

If you implement a custom streaming chat\_model, you can "reduce" the outputs into the same format as the non-streaming version. This is currently only supported in Python.

<Check>
  If `ls_model_name` is not present in `extra.metadata`, other fields might be used from the `extra.metadata` for estimating token counts. The following fields are used in the order of precedence:

1. `metadata.ls_model_name`
  2. `inputs.model`
  3. `inputs.model_name`
</Check>

To learn more about how to use the `metadata` fields, refer to the [Add metadata and tags](/langsmith/add-metadata-tags) guide.

## Provide token and cost information

LangSmith calculates costs derived from token counts and model prices automatically. Learn about [how to provide tokens and/or costs in a run](/langsmith/cost-tracking#cost-tracking) and [viewing costs in the LangSmith UI](/langsmith/cost-tracking#viewing-costs-in-the-langsmith-ui).

## Time-to-first-token

If you are using `traceable` or one of our SDK wrappers, LangSmith will automatically populate time-to-first-token for streaming LLM runs.
However, if you are using the `RunTree` API directly, you will need to add a `new_token` event to the run tree in order to properly populate time-to-first-token.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/log-llm-trace.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

## Converting custom I/O formats into LangSmith compatible formats

If you're using a custom input or output format, you can convert it to a LangSmith compatible format using `process_inputs`/`processInputs` and `process_outputs`/`processOutputs` functions on the [`@traceable` decorator](https://docs.smith.langchain.com/reference/python/run_helpers/langsmith.run_helpers.traceable) (Python) or [`traceable` function](https://docs.smith.langchain.com/reference/js/functions/traceable.traceable) (TS).

`process_inputs`/`processInputs` and `process_outputs`/`processOutputs` accept functions that allow you to transform the inputs and outputs of a specific trace before they are logged to LangSmith. They have access to the trace's inputs and outputs, and can return a new dictionary with the processed data.

Here's a boilerplate example of how to use `process_inputs` and `process_outputs` to convert a custom I/O format into a LangSmith compatible format:

<Expandable title="the code">
  <CodeGroup>
```

---

## Studio troubleshooting

**URL:** llms-txt#studio-troubleshooting

**Contents:**
- Safari Connection Issues
  - Solution 1: Use Cloudflare Tunnel
  - Solution 2: Use Chromium browser
- Chrome connection issues
  - Symptoms
  - Solution: Allow local network access in Chrome
  - Additional troubleshooting
- Brave Connection Issues
  - Solution 1: Disable Brave Shields
  - Solution 2: Use Cloudflare Tunnel

Source: https://docs.langchain.com/langsmith/troubleshooting-studio

## Safari Connection Issues

Safari blocks plain-HTTP traffic on localhost. When running Studio with `langgraph dev`, you may see "Failed to load assistants" errors.

### Solution 1: Use Cloudflare Tunnel

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="JS">
    
  </Tab>
</Tabs>

The command outputs a URL in this format:

Use this URL in Safari to load Studio. Here, the `baseUrl` parameter specifies your agent server endpoint.

### Solution 2: Use Chromium browser

Chrome and other Chromium browsers allow HTTP on localhost. Use `langgraph dev` without additional configuration.

## Chrome connection issues

Starting with Chrome version 142, you may experience "Failed to initialize Studio" errors with "TypeError: Failed to fetch" when trying to connect [LangSmith Studio](/langsmith/studio) to your local development server via [`langgraph dev`](/langsmith/cli). This occurs even when the API server at `http://127.0.0.1:2024/docs` loads successfully.

**Root Cause:** Chrome 142 fully enforces the Private Network Access (PNA) specification with no fallback, which blocks HTTPS sites (like `https://smith.langchain.com`) from accessing HTTP localhost servers by default.

* Running `langgraph dev` starts the server successfully.
* Navigating to `http://127.0.0.1:2024/docs` shows the API documentation correctly.
* LangSmith Studio at `https://smith.langchain.com` shows: "Failed to initialize Studio - Please verify if the API server is running or accessible from the browser. TypeError: Failed to fetch".
* Browser console shows errors like: `Permission was denied for this request to access the 'unknown' address space`.

### Solution: Allow local network access in Chrome

1. Open LangSmith Studio at `https://smith.langchain.com` in Chrome.
2. Click the **lock icon** (or site information icon) to the left of the address bar.
3. Look for the **"Local network access"** option in the dropdown.
4. Change the setting from **"Ask (default)"** or **"Block"** to **"Allow"**.
5. Reload the page.

Studio should now connect to your local development server successfully.

### Additional troubleshooting

**Check for browser extension conflicts**

Browser extensions (especially Ollama Chrome extension or AI model extensions) can interfere with localhost connections:

1. Disable all browser extensions temporarily.
2. Restart Chrome.
3. Try connecting to Studio again.
4. If it works, re-enable extensions one by one to identify the culprit.

**Verify dependencies are up to date**

**Clear browser cache and site data**

1. In Chrome, go to **Settings** > **Privacy and Security** > **Site Settings**.
2. Find `https://smith.langchain.com` in the list.
3. Click **Clear data**.
4. Restart Chrome and try again.

## Brave Connection Issues

Brave blocks plain-HTTP traffic on localhost when Brave Shields are enabled. When running Studio with `langgraph dev`, you may see "Failed to load assistants" errors.

### Solution 1: Disable Brave Shields

Disable Brave Shields for LangSmith using the Brave icon in the URL bar.

### Solution 2: Use Cloudflare Tunnel

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="JS">
    
  </Tab>
</Tabs>

The command outputs a URL in this format:

Use this URL in Brave to load Studio. Here, the `baseUrl` parameter specifies your agent server endpoint.

Undefined conditional edges may show unexpected connections in your graph. This is
because without proper definition, Studio assumes the conditional edge could access all other nodes. To address this, explicitly define the routing paths using one of these methods:

### Solution 1: Path map

Define a mapping between router outputs and target nodes:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>
</Tabs>

### Solution 2: Router type definition

Specify possible routing destinations using Python's `Literal` type:

## Experiment troubleshooting in Studio

### **Run experiment** button is disabled

* **Deployed application**: If your application is deployed on LangSmith, you may need to create a new revision to enable this feature.
* **Local development server**: If you are running your application locally, make sure you have upgraded to the latest version of the `langgraph-cli` (`pip install -U langgraph-cli`). Additionally, ensure you have tracing enabled by setting the `LANGSMITH_API_KEY` in your project's `.env` file.

### Evaluator results are missing

When you run an experiment, any attached evaluators are scheduled for execution in a queue. If you don't see results immediately, it likely means they are still pending.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/troubleshooting-studio.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="JS">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

The command outputs a URL in this format:
```

Example 3 (unknown):
```unknown
Use this URL in Safari to load Studio. Here, the `baseUrl` parameter specifies your agent server endpoint.

### Solution 2: Use Chromium browser

Chrome and other Chromium browsers allow HTTP on localhost. Use `langgraph dev` without additional configuration.

## Chrome connection issues

Starting with Chrome version 142, you may experience "Failed to initialize Studio" errors with "TypeError: Failed to fetch" when trying to connect [LangSmith Studio](/langsmith/studio) to your local development server via [`langgraph dev`](/langsmith/cli). This occurs even when the API server at `http://127.0.0.1:2024/docs` loads successfully.

**Root Cause:** Chrome 142 fully enforces the Private Network Access (PNA) specification with no fallback, which blocks HTTPS sites (like `https://smith.langchain.com`) from accessing HTTP localhost servers by default.

### Symptoms

* Running `langgraph dev` starts the server successfully.
* Navigating to `http://127.0.0.1:2024/docs` shows the API documentation correctly.
* LangSmith Studio at `https://smith.langchain.com` shows: "Failed to initialize Studio - Please verify if the API server is running or accessible from the browser. TypeError: Failed to fetch".
* Browser console shows errors like: `Permission was denied for this request to access the 'unknown' address space`.

### Solution: Allow local network access in Chrome

1. Open LangSmith Studio at `https://smith.langchain.com` in Chrome.
2. Click the **lock icon** (or site information icon) to the left of the address bar.
3. Look for the **"Local network access"** option in the dropdown.
4. Change the setting from **"Ask (default)"** or **"Block"** to **"Allow"**.
5. Reload the page.

Studio should now connect to your local development server successfully.

### Additional troubleshooting

**Check for browser extension conflicts**

Browser extensions (especially Ollama Chrome extension or AI model extensions) can interfere with localhost connections:

1. Disable all browser extensions temporarily.
2. Restart Chrome.
3. Try connecting to Studio again.
4. If it works, re-enable extensions one by one to identify the culprit.

**Verify dependencies are up to date**
```

Example 4 (unknown):
```unknown
**Clear browser cache and site data**

1. In Chrome, go to **Settings** > **Privacy and Security** > **Site Settings**.
2. Find `https://smith.langchain.com` in the list.
3. Click **Clear data**.
4. Restart Chrome and try again.

## Brave Connection Issues

Brave blocks plain-HTTP traffic on localhost when Brave Shields are enabled. When running Studio with `langgraph dev`, you may see "Failed to load assistants" errors.

### Solution 1: Disable Brave Shields

Disable Brave Shields for LangSmith using the Brave icon in the URL bar.

### Solution 2: Use Cloudflare Tunnel

<Tabs>
  <Tab title="Python">
```

---

## Define the runtime context

**URL:** llms-txt#define-the-runtime-context

**Contents:**
- Create the configuration file
- Next

class GraphContext(TypedDict):
    model_name: Literal["anthropic", "openai"]

workflow = StateGraph(AgentState, context_schema=GraphContext)
workflow.add_node("agent", call_model)
workflow.add_node("action", tool_node)
workflow.add_edge(START, "agent")
workflow.add_conditional_edges(
    "agent",
    should_continue,
    {
        "continue": "action",
        "end": END,
    },
)
workflow.add_edge("action", "agent")

graph = workflow.compile()
bash  theme={null}
my-app/
├── my_agent # all project code lies within here
│   ├── utils # utilities for your graph
│   │   ├── __init__.py
│   │   ├── tools.py # tools for your graph
│   │   ├── nodes.py # node functions for your graph
│   │   └── state.py # state definition of your graph
│   ├── __init__.py
│   └── agent.py # code for constructing your graph
├── .env
└── pyproject.toml
json  theme={null}
{
  "dependencies": ["."],
  "graphs": {
    "agent": "./my_agent/agent.py:graph"
  },
  "env": ".env"
}
bash  theme={null}
my-app/
├── my_agent # all project code lies within here
│   ├── utils # utilities for your graph
│   │   ├── __init__.py
│   │   ├── tools.py # tools for your graph
│   │   ├── nodes.py # node functions for your graph
│   │   └── state.py # state definition of your graph
│   ├── __init__.py
│   └── agent.py # code for constructing your graph
├── .env # environment variables
├── langgraph.json  # configuration file for LangGraph
└── pyproject.toml # dependencies for your project
```

After you setup your project and place it in a GitHub repository, it's time to [deploy your app](/langsmith/deployment-quickstart).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/setup-pyproject.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
Example file directory:
```

Example 2 (unknown):
```unknown
## Create the configuration file

Create a [configuration file](/langsmith/cli#configuration-file) called `langgraph.json`. See the [configuration file reference](/langsmith/cli#configuration-file) for detailed explanations of each key in the JSON object of the configuration file.

Example `langgraph.json` file:
```

Example 3 (unknown):
```unknown
Note that the variable name of the `CompiledGraph` appears at the end of the value of each subkey in the top-level `graphs` key (i.e. `:<variable_name>`).

<Warning>
  **Configuration file location**
  The configuration file must be placed in a directory that is at the same level or higher than the Python files that contain compiled graphs and associated dependencies.
</Warning>

Example file directory:
```

---

## Transient file (lost after thread ends)

**URL:** llms-txt#transient-file-(lost-after-thread-ends)

agent.invoke({
    "messages": [{"role": "user", "content": "Write draft to /draft.txt"}]
})

---

## Interrupt concurrent

**URL:** llms-txt#interrupt-concurrent

**Contents:**
- Setup
- Create runs
- View run results

Source: https://docs.langchain.com/langsmith/interrupt-concurrent

This guide assumes knowledge of what double-texting is, which you can learn about in the [double-texting conceptual guide](/langsmith/double-texting).

The guide covers the `interrupt` option for double texting, which interrupts the prior run of the graph and starts a new one with the double-text. This option does not delete the first run, but rather keeps it in the database but sets its status to `interrupted`. Below is a quick example of using the `interrupt` option.

First, we will define a quick helper function for printing out JS and CURL model outputs (you can skip this if using Python):

<Tabs>
  <Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now we can start our two runs and join the second one until it has completed:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

We can see that the thread has partial data from the first run + data from the second run

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Verify that the original, interrupted run was interrupted

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>
</Tabs>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/interrupt-concurrent.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="Javascript">
```

Example 4 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

---

## The instrucitons are passed as a system message to the agent

**URL:** llms-txt#the-instrucitons-are-passed-as-a-system-message-to-the-agent

instructions = """You are a tweet writing assistant. Given a topic, do some research and write a relevant and engaging tweet about it.
- Use at least 3 emojis in each tweet
- The tweet should be no longer than 280 characters
- Always use the search tool to gather recent information on the tweet topic
- Write the tweet only based on the search content. Do not rely on your internal knowledge
- When relevant, link to your sources
- Make your tweet as engaging as possible"""

---

## How to set up an application with pyproject.toml

**URL:** llms-txt#how-to-set-up-an-application-with-pyproject.toml

**Contents:**
- Specify dependencies
- Specify environment variables
- Define graphs

Source: https://docs.langchain.com/langsmith/setup-pyproject

An application must be configured with a [configuration file](/langsmith/cli#configuration-file) in order to be deployed to LangSmith (or to be self-hosted). This how-to guide discusses the basic steps to set up an application for deployment using `pyproject.toml` to define your package's dependencies.

This example is based on [this repository](https://github.com/langchain-ai/langgraph-example-pyproject), which uses the LangGraph framework.

The final repository structure will look something like this:

<Tip>
  LangSmith Deployment supports deploying a [LangGraph](/oss/python/langgraph/overview) *graph*. However, the implementation of a *node* of a graph can contain arbitrary Python code. This means any framework can be implemented within a node and deployed on LangSmith Deployment. This lets you keep your core application logic outside LangGraph while still using LangSmith for [deployment](/langsmith/deployments), scaling, and [observability](/langsmith/observability).
</Tip>

You can also set up with:

* `requirements.txt`: for dependency management, check out [this how-to guide](/langsmith/setup-app-requirements-txt) on using `requirements.txt` for LangSmith.
* a monorepo: To deploy a graph located inside a monorepo, take a look at [this repository](https://github.com/langchain-ai/langgraph-example-monorepo) for an example of how to do so.

After each step, an example file directory is provided to demonstrate how code can be organized.

## Specify dependencies

Dependencies can optionally be specified in one of the following files: `pyproject.toml`, `setup.py`, or `requirements.txt`. If none of these files is created, then dependencies can be specified later in the [configuration file](#create-the-configuration-file).

The dependencies below will be included in the image, you can also use them in your code, as long as with a compatible version range:

Example `pyproject.toml` file:

Example file directory:

## Specify environment variables

Environment variables can optionally be specified in a file (e.g. `.env`). See the [Environment Variables reference](/langsmith/env-var) to configure additional variables for a deployment.

Example file directory:

<Tip>
  By default, LangSmith follows the `uv`/`pip` behavior of **not** installing prerelease versions unless explicitly allowed. If want to use prereleases, you have the following options:

* With `pyproject.toml`: add `allow-prereleases = true` to your `[tool.uv]` section.
  * With `requirements.txt` or `setup.py`: you must explicitly specify every prerelease dependency, including transitive ones. For example, if you declare `a==0.0.1a1` and `a` depends on `b==0.0.1a1`, then you must also explicitly include `b==0.0.1a1` in your dependencies.
</Tip>

Implement your graphs. Graphs can be defined in a single file or multiple files. Make note of the variable names of each [CompiledStateGraph](https://reference.langchain.com/python/langgraph/graphs/#langgraph.graph.state.CompiledStateGraph) to be included in the application. The variable names will be used later when creating the [configuration file](/langsmith/cli#configuration-file).

Example `agent.py` file, which shows how to import from other modules you define (code for the modules is not shown here, please see [this repository](https://github.com/langchain-ai/langgraph-example-pyproject) to see their implementation):

```python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
<Tip>
  LangSmith Deployment supports deploying a [LangGraph](/oss/python/langgraph/overview) *graph*. However, the implementation of a *node* of a graph can contain arbitrary Python code. This means any framework can be implemented within a node and deployed on LangSmith Deployment. This lets you keep your core application logic outside LangGraph while still using LangSmith for [deployment](/langsmith/deployments), scaling, and [observability](/langsmith/observability).
</Tip>

You can also set up with:

* `requirements.txt`: for dependency management, check out [this how-to guide](/langsmith/setup-app-requirements-txt) on using `requirements.txt` for LangSmith.
* a monorepo: To deploy a graph located inside a monorepo, take a look at [this repository](https://github.com/langchain-ai/langgraph-example-monorepo) for an example of how to do so.

After each step, an example file directory is provided to demonstrate how code can be organized.

## Specify dependencies

Dependencies can optionally be specified in one of the following files: `pyproject.toml`, `setup.py`, or `requirements.txt`. If none of these files is created, then dependencies can be specified later in the [configuration file](#create-the-configuration-file).

The dependencies below will be included in the image, you can also use them in your code, as long as with a compatible version range:
```

Example 2 (unknown):
```unknown
Example `pyproject.toml` file:
```

Example 3 (unknown):
```unknown
Example file directory:
```

Example 4 (unknown):
```unknown
## Specify environment variables

Environment variables can optionally be specified in a file (e.g. `.env`). See the [Environment Variables reference](/langsmith/env-var) to configure additional variables for a deployment.

Example `.env` file:
```

---

## Dynamic few shot example selection

**URL:** llms-txt#dynamic-few-shot-example-selection

**Contents:**
- Pre-conditions
- Index your dataset for few shot search
- Test search quality in the few shot playground
- Adding few shot search to your application
  - Code snippets

Source: https://docs.langchain.com/langsmith/index-datasets-for-dynamic-few-shot-example-selection

<Note>
  This feature is in open beta. It is only available to paid team plans. Please reach out to [support@langchain.dev](mailto:support@langchain.dev) if you have questions about enablement.
</Note>

Configure your datasets so that you can search for few shot examples based on an incoming request.

1. Your dataset must use the KV store data type (we do not currently support chat model or LLM type datasets)
2. You must have an input schema defined for your dataset. See our docs on setting up schema validation [in our UI](/langsmith/manage-datasets-in-application#dataset-schema-validation) for details.
3. You must be on a paid team plan (e.g. Plus plan)
4. You must be on LangSmith cloud

## Index your dataset for few shot search

Navigate to the datasets UI, and click the new `Few-Shot search` tab. Hit the `Start sync` button, which will create a new index on your dataset to make it searchable.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7bc50f1a3d4ea7b9e7458f3ed9770179" alt="" data-og-width="3208" width="3208" data-og-height="1902" height="1902" data-path="langsmith/images/few-shot-tab-unsynced.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=c2ee3688a24b8d142d4a5dd89c8797c1 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=44a4d8b59948893b4bd20d4c1b62198c 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=16a303eab8e2aede574c12353f782789 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=fbcf4566ec48c219bb7828bdc2cfe6b9 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=15da2b6b3e4a29ac3a2b4e139e2cf345 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-tab-unsynced.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=6bd99520313da2fedbbbaf388c956ba7 2500w" />

By default, we sync to the latest version of your dataset. That means when new examples are added to your dataset, they will automatically be added to your index. This process runs every few minutes, so there should be a very short delay for indexing new examples. You can see whether your index is up to date under `Few-shot index` on the lefthand side of the screen in the next section.

## Test search quality in the few shot playground

Now that you have turned on indexing for your dataset, you will see the new few shot playground.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=b2b714b5a281ab8f39761566afd452f7" alt="" data-og-width="3208" width="3208" data-og-height="1902" height="1902" data-path="langsmith/images/few-shot-synced-empty-state.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=b8e4e648ce36f12a141f98815fd2e63d 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=49044eef3af8c08b60bcfeabadde6d16 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=b0fb897716bfac9521d0490c11eb006e 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f21c2ad1fc5177af66c5f0c5ac59f660 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=dd9e2f9aa42366063ca14ad2b365e6fc 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-synced-empty-state.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=72158d44bcf916f2548bc5c7a6dabbce 2500w" />

You can type in a sample input, and check which results would be returned by our search API.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=f64d39010f85b68d4d9ae3febc2b59d7" alt="" data-og-width="3208" width="3208" data-og-height="1902" height="1902" data-path="langsmith/images/few-shot-search-results.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=cbbd01172c4514eb3d775a4c0f3ca2e4 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=4a15ea167365f8d9105ab5aab50ed241 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=94ac208df6e860b9c194a646e3183779 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=ec68d9679e4cc86eebe352a9364e8894 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=5650c218963b5e8bd8d56e0bf886cd3e 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-search-results.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=89e90c66c065bee2a728cd5dad69432a 2500w" />

Each result will have a score and a link to the example in the dataset. The scoring system works such that 0 is a completely random result, and higher scores are better. Results will be sorted in descending order according to score.

<Note>
  Search uses a BM25-like algorithm for keyword based similarity scores. The actual score is subject to change as we improve the search algorithm, so we recommend not relying on the scores themselves, as their meaning may evolve over time. They are simply used for convenience in vibe-testing outputs in the playground.
</Note>

## Adding few shot search to your application

Click the `Get Code Snippet` button in the previous diagram, you'll be taken to a screen that has code snippets from our LangSmith SDK in different languages.

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=015d9416ef4f2708a6f2dfedceb1ea07" alt="" data-og-width="3208" width="3208" data-og-height="1902" height="1902" data-path="langsmith/images/few-shot-code-snippet.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=a5b15cf813569f4f218d972f2dbe89a5 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=231a3aad9937aab1fa92e65839bb5869 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8aa86a24694342bca8ab387c83338afe 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=d92247c22e6fb2fd85e80713616b7fba 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=28f6e81c67c52687cd24431b83145675 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/few-shot-code-snippet.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=aeafca83ae2489c43aa38d24165e5d62 2500w" />

For code samples on using few shot search in LangChain python applications, please see our [how-to guide in the LangChain docs](https://python.langchain.com/v0.2/docs/how_to/example_selectors_langsmith/).

<Note>
  Please ensure you are using the python SDK with version >= 1.101 or the typescript SDK with version >= 1.43
</Note>

For copy and paste convenience, you can find the similar code snippets to the ones shown in the screenshot above here:

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/index-datasets-for-dynamic-few-shot-example-selection.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown

```

---

## All integration providers

**URL:** llms-txt#all-integration-providers

**Contents:**
- Providers

Source: https://docs.langchain.com/oss/python/integrations/providers/all_providers

Browse the complete collection of integrations available for Python. LangChain Python offers the most extensive ecosystem with 1000+ integrations across LLMs, chat models, retrievers, vector stores, document loaders, and more.

<Columns cols={3}>
  <Card title="Abso" href="/oss/python/integrations/providers/abso" icon="link">
    Custom AI integration platform for enterprise workflows.
  </Card>

<Card title="Acreom" href="/oss/python/integrations/providers/acreom" icon="link">
    Knowledge management platform with AI-powered organization.
  </Card>

<Card title="ActiveLoop DeepLake" href="/oss/python/integrations/providers/activeloop_deeplake" icon="link">
    Vector database for AI applications with deep learning focus.
  </Card>

<Card title="Ads4GPTs" href="/oss/python/integrations/providers/ads4gpts" icon="link">
    Advertising platform for GPT applications and AI services.
  </Card>

<Card title="AgentQL" href="/oss/python/integrations/providers/agentql" icon="link">
    Web scraping with natural language queries.
  </Card>

<Card title="AI21" href="/oss/python/integrations/providers/ai21" icon="link">
    AI21 Labs' Jurassic models for text generation.
  </Card>

<Card title="AIM Tracking" href="/oss/python/integrations/providers/aim_tracking" icon="link">
    Experiment tracking and management platform.
  </Card>

<Card title="AI/ML API" href="/oss/python/integrations/providers/aimlapi" icon="link">
    Unified API for multiple AI and ML services.
  </Card>

<Card title="AI Network" href="/oss/python/integrations/providers/ainetwork" icon="link">
    Decentralized AI computing network platform.
  </Card>

<Card title="Airbyte" href="/oss/python/integrations/providers/airbyte" icon="link">
    Data integration platform for ETL and ELT pipelines.
  </Card>

<Card title="Airtable" href="/oss/python/integrations/providers/airtable" icon="link">
    Cloud-based spreadsheet and database platform.
  </Card>

<Card title="Alchemy" href="/oss/python/integrations/providers/alchemy" icon="link">
    Blockchain development platform and APIs.
  </Card>

<Card title="Aleph Alpha" href="/oss/python/integrations/providers/aleph_alpha" icon="link">
    European AI company's multilingual language models.
  </Card>

<Card title="Alibaba Cloud" href="/oss/python/integrations/providers/alibaba_cloud" icon="link">
    Alibaba's cloud computing and AI services.
  </Card>

<Card title="AnalyticDB" href="/oss/python/integrations/providers/analyticdb" icon="link">
    Alibaba Cloud's real-time analytics database.
  </Card>

<Card title="Anchor Browser" href="/oss/python/integrations/providers/anchor_browser" icon="link">
    Browser automation and web scraping tools.
  </Card>

<Card title="Annoy" href="/oss/python/integrations/providers/annoy" icon="link">
    Approximate nearest neighbors search library.
  </Card>

<Card title="Anthropic" href="/oss/python/integrations/providers/anthropic" icon="anthropic">
    Claude models for advanced reasoning and conversation.
  </Card>

<Card title="Anyscale" href="/oss/python/integrations/providers/anyscale" icon="link">
    Distributed computing platform for ML workloads.
  </Card>

<Card title="Apache Doris" href="/oss/python/integrations/providers/apache_doris" icon="link">
    Real-time analytical database management system.
  </Card>

<Card title="Apache" href="/oss/python/integrations/providers/apache" icon="link">
    Apache Software Foundation tools and libraries.
  </Card>

<Card title="Apify" href="/oss/python/integrations/providers/apify" icon="link">
    Web scraping and automation platform.
  </Card>

<Card title="Apple" href="/oss/python/integrations/providers/apple" icon="link">
    Apple's machine learning and AI frameworks.
  </Card>

<Card title="ArangoDB" href="/oss/python/integrations/providers/arangodb" icon="link">
    Multi-model database with graph capabilities.
  </Card>

<Card title="Arcee" href="/oss/python/integrations/providers/arcee" icon="link">
    Domain-specific language model training platform.
  </Card>

<Card title="ArcGIS" href="/oss/python/integrations/providers/arcgis" icon="link">
    Geographic information system platform.
  </Card>

<Card title="Argilla" href="/oss/python/integrations/providers/argilla" icon="link">
    Data labeling and annotation platform for NLP.
  </Card>

<Card title="Arize" href="/oss/python/integrations/providers/arize" icon="link">
    ML observability and performance monitoring.
  </Card>

<Card title="Arthur Tracking" href="/oss/python/integrations/providers/arthur_tracking" icon="link">
    AI model monitoring and governance platform.
  </Card>

<Card title="arXiv" href="/oss/python/integrations/providers/arxiv" icon="link">
    Academic paper repository and search platform.
  </Card>

<Card title="Ascend" href="/oss/python/integrations/providers/ascend" icon="link">
    Data engineering and pipeline automation platform.
  </Card>

<Card title="Ask News" href="/oss/python/integrations/providers/asknews" icon="link">
    Real-time news search and analysis API.
  </Card>

<Card title="AssemblyAI" href="/oss/python/integrations/providers/assemblyai" icon="link">
    Speech-to-text and audio intelligence API.
  </Card>

<Card title="AstraDB" href="/oss/python/integrations/providers/astradb" icon="link">
    DataStax Astra DB vector database platform.
  </Card>

<Card title="Atlas" href="/oss/python/integrations/providers/atlas" icon="link">
    Data visualization and exploration platform.
  </Card>

<Card title="AwaDB" href="/oss/python/integrations/providers/awadb" icon="link">
    Vector database for AI and ML applications.
  </Card>

<Card title="AWS" href="/oss/python/integrations/providers/aws" icon="aws">
    Amazon Web Services cloud platform and AI services.
  </Card>

<Card title="AZLyrics" href="/oss/python/integrations/providers/azlyrics" icon="link">
    Song lyrics database and search platform.
  </Card>

<Card title="Azure AI" href="/oss/python/integrations/providers/azure_ai" icon="microsoft">
    Microsoft Azure AI and cognitive services.
  </Card>

<Card title="BAAI" href="/oss/python/integrations/providers/baai" icon="link">
    Beijing Academy of AI research and models.
  </Card>

<Card title="Bagel" href="/oss/python/integrations/providers/bagel" icon="link">
    Vector database and semantic search platform.
  </Card>

<Card title="BagelDB" href="/oss/python/integrations/providers/bageldb" icon="link">
    Multi-modal AI database and storage system.
  </Card>

<Card title="Baichuan" href="/oss/python/integrations/providers/baichuan" icon="link">
    Chinese language model from Baichuan AI.
  </Card>

<Card title="Baidu" href="/oss/python/integrations/providers/baidu" icon="link">
    Baidu's AI services and language models.
  </Card>

<Card title="BananaDev" href="/oss/python/integrations/providers/bananadev" icon="link">
    Serverless GPU infrastructure for ML models.
  </Card>

<Card title="Baseten" href="/oss/python/integrations/providers/baseten" icon="link">
    ML model deployment and serving platform.
  </Card>

<Card title="Beam" href="/oss/python/integrations/providers/beam" icon="link">
    Serverless GPU computing platform.
  </Card>

<Card title="Beautiful Soup" href="/oss/python/integrations/providers/beautiful_soup" icon="link">
    HTML and XML parsing library for web scraping.
  </Card>

<Card title="BibTeX" href="/oss/python/integrations/providers/bibtex" icon="link">
    Bibliography management and citation format.
  </Card>

<Card title="Bilibili" href="/oss/python/integrations/providers/bilibili" icon="link">
    Chinese video sharing platform integration.
  </Card>

<Card title="Bittensor" href="/oss/python/integrations/providers/bittensor" icon="link">
    Decentralized AI network and incentive protocol.
  </Card>

<Card title="Blackboard" href="/oss/python/integrations/providers/blackboard" icon="link">
    Educational technology and learning management.
  </Card>

<Card title="Bodo DataFrames" href="/oss/python/integrations/providers/bodo" icon="link">
    High-performance analytics and data processing.
  </Card>

<Card title="BookendAI" href="/oss/python/integrations/providers/bookendai" icon="link">
    AI-powered reading and research assistant.
  </Card>

<Card title="Box" href="/oss/python/integrations/providers/box" icon="link">
    Cloud content management and collaboration.
  </Card>

<Card title="Brave Search" href="/oss/python/integrations/providers/brave_search" icon="link">
    Privacy-focused search engine API.
  </Card>

<Card title="Breebs" href="/oss/python/integrations/providers/breebs" icon="link">
    AI knowledge management and retrieval platform.
  </Card>

<Card title="Brightdata" href="/oss/python/integrations/providers/brightdata" icon="link">
    Web data platform and proxy services.
  </Card>

<Card title="Browserbase" href="/oss/python/integrations/providers/browserbase" icon="link">
    Headless browser automation platform.
  </Card>

<Card title="Browserless" href="/oss/python/integrations/providers/browserless" icon="link">
    Serverless browser automation service.
  </Card>

<Card title="ByteDance" href="/oss/python/integrations/providers/byte_dance" icon="link">
    ByteDance's AI models and services.
  </Card>

<Card title="Cassandra" href="/oss/python/integrations/providers/cassandra" icon="link">
    Distributed NoSQL database management system.
  </Card>

<Card title="Cerebras" href="/oss/python/integrations/providers/cerebras" icon="link">
    AI compute platform with specialized processors.
  </Card>

<Card title="CerebriumAI" href="/oss/python/integrations/providers/cerebriumai" icon="link">
    Serverless GPU platform for AI applications.
  </Card>

<Card title="Chaindesk" href="/oss/python/integrations/providers/chaindesk" icon="link">
    No-code AI chatbot and automation platform.
  </Card>

<Card title="Chroma" href="/oss/python/integrations/providers/chroma" icon="link">
    Open-source embedding database for AI apps.
  </Card>

<Card title="Clarifai" href="/oss/python/integrations/providers/clarifai" icon="link">
    Computer vision and AI model platform.
  </Card>

<Card title="ClearML Tracking" href="/oss/python/integrations/providers/clearml_tracking" icon="link">
    ML experiment tracking and automation.
  </Card>

<Card title="ClickHouse" href="/oss/python/integrations/providers/clickhouse" icon="link">
    Fast columnar database for analytics.
  </Card>

<Card title="ClickUp" href="/oss/python/integrations/providers/clickup" icon="link">
    Project management and productivity platform.
  </Card>

<Card title="Cloudflare" href="/oss/python/integrations/providers/cloudflare" icon="link">
    Web infrastructure and security services.
  </Card>

<Card title="Clova" href="/oss/python/integrations/providers/clova" icon="link">
    Naver's AI assistant and NLP platform.
  </Card>

<Card title="CnosDB" href="/oss/python/integrations/providers/cnosdb" icon="link">
    Time series database for IoT and analytics.
  </Card>

<Card title="Cognee" href="/oss/python/integrations/providers/cognee" icon="link">
    Memory layer for AI applications and agents.
  </Card>

<Card title="CogniSwitch" href="/oss/python/integrations/providers/cogniswitch" icon="link">
    AI knowledge management and retrieval system.
  </Card>

<Card title="Cohere" href="/oss/python/integrations/providers/cohere" icon="link">
    Language AI platform for enterprise applications.
  </Card>

<Card title="College Confidential" href="/oss/python/integrations/providers/college_confidential" icon="link">
    College admissions and education platform.
  </Card>

<Card title="Comet Tracking" href="/oss/python/integrations/providers/comet_tracking" icon="link">
    ML experiment tracking and model management.
  </Card>

<Card title="Confident" href="/oss/python/integrations/providers/confident" icon="link">
    AI observability and monitoring platform.
  </Card>

<Card title="Confluence" href="/oss/python/integrations/providers/confluence" icon="link">
    Team collaboration and documentation platform.
  </Card>

<Card title="Connery" href="/oss/python/integrations/providers/connery" icon="link">
    Plugin system for AI agents and applications.
  </Card>

<Card title="Context" href="/oss/python/integrations/providers/context" icon="link">
    Context management for AI applications.
  </Card>

<Card title="Contextual" href="/oss/python/integrations/providers/contextual" icon="link">
    Contextual AI and language understanding.
  </Card>

<Card title="Couchbase" href="/oss/python/integrations/providers/couchbase" icon="link">
    NoSQL cloud database platform.
  </Card>

<Card title="Coze" href="/oss/python/integrations/providers/coze" icon="link">
    Conversational AI platform and chatbot builder.
  </Card>

<Card title="CrateDB" href="/oss/python/integrations/providers/cratedb" icon="link">
    Distributed SQL database for machine data.
  </Card>

<Card title="CTransformers" href="/oss/python/integrations/providers/ctransformers" icon="link">
    Python bindings for transformer models in C/C++.
  </Card>

<Card title="CTranslate2" href="/oss/python/integrations/providers/ctranslate2" icon="link">
    Fast inference engine for Transformer models.
  </Card>

<Card title="Cube" href="/oss/python/integrations/providers/cube" icon="link">
    Semantic layer for building data applications.
  </Card>

<Card title="Dappier" href="/oss/python/integrations/providers/dappier" icon="link">
    Real-time AI data platform and API.
  </Card>

<Card title="DashVector" href="/oss/python/integrations/providers/dashvector" icon="link">
    Alibaba Cloud's vector database service.
  </Card>

<Card title="Databricks" href="/oss/python/integrations/providers/databricks" icon="link">
    Unified analytics platform for big data and ML.
  </Card>

<Card title="Datadog" href="/oss/python/integrations/providers/datadog" icon="link">
    Monitoring and analytics platform for applications.
  </Card>

<Card title="Datadog Logs" href="/oss/python/integrations/providers/datadog_logs" icon="link">
    Log management and analysis platform.
  </Card>

<Card title="DataForSEO" href="/oss/python/integrations/providers/dataforseo" icon="link">
    SEO and SERP data API platform.
  </Card>

<Card title="DataHerald" href="/oss/python/integrations/providers/dataherald" icon="link">
    Natural language to SQL query platform.
  </Card>

<Card title="Daytona" href="/oss/python/integrations/providers/daytona" icon="link">
    Secure and elastic infrastructure for running your AI-generated code.
  </Card>

<Card title="Dedoc" href="/oss/python/integrations/providers/dedoc" icon="link">
    Document analysis and structure detection.
  </Card>

<Card title="DeepInfra" href="/oss/python/integrations/providers/deepinfra" icon="link">
    Serverless inference for deep learning models.
  </Card>

<Card title="DeepLake" href="/oss/python/integrations/providers/deeplake" icon="link">
    Vector database for deep learning applications.
  </Card>

<Card title="DeepSeek" href="/oss/python/integrations/providers/deepseek" icon="link">
    Advanced reasoning and coding AI models.
  </Card>

<Card title="DeepSparse" href="/oss/python/integrations/providers/deepsparse" icon="link">
    Inference runtime for sparse neural networks.
  </Card>

<Card title="Dell" href="/oss/python/integrations/providers/dell" icon="link">
    Dell Technologies AI and computing solutions.
  </Card>

<Card title="Diffbot" href="/oss/python/integrations/providers/diffbot" icon="link">
    Web data extraction and knowledge graph.
  </Card>

<Card title="Dingo" href="/oss/python/integrations/providers/dingo" icon="link">
    Distributed vector database system.
  </Card>

<Card title="Discord" href="/oss/python/integrations/providers/discord" icon="link">
    Communication platform integration and bots.
  </Card>

<Card title="Discord Shikenso" href="/oss/python/integrations/providers/discord-shikenso" icon="link">
    Discord analytics and moderation tools.
  </Card>

<Card title="DocArray" href="/oss/python/integrations/providers/docarray" icon="link">
    Data structure for multimodal AI applications.
  </Card>

<Card title="Docling" href="/oss/python/integrations/providers/docling" icon="link">
    Document processing and AI integration.
  </Card>

<Card title="Doctran" href="/oss/python/integrations/providers/doctran" icon="link">
    Document transformation and processing.
  </Card>

<Card title="Docugami" href="/oss/python/integrations/providers/docugami" icon="link">
    Document AI and semantic processing.
  </Card>

<Card title="Docusaurus" href="/oss/python/integrations/providers/docusaurus" icon="link">
    Documentation website generator and platform.
  </Card>

<Card title="Dria" href="/oss/python/integrations/providers/dria" icon="link">
    Decentralized knowledge retrieval network.
  </Card>

<Card title="Dropbox" href="/oss/python/integrations/providers/dropbox" icon="link">
    Cloud storage and file sharing platform.
  </Card>

<Card title="DuckDB" href="/oss/python/integrations/providers/duckdb" icon="link">
    In-process SQL OLAP database management system.
  </Card>

<Card title="DuckDuckGo Search" href="/oss/python/integrations/providers/duckduckgo_search" icon="link">
    Privacy-focused search engine integration.
  </Card>

<Card title="E2B" href="/oss/python/integrations/providers/e2b" icon="link">
    Cloud development environment platform.
  </Card>

<Card title="EdenAI" href="/oss/python/integrations/providers/edenai" icon="link">
    Unified API for multiple AI services.
  </Card>

<Card title="Elasticsearch" href="/oss/python/integrations/providers/elasticsearch" icon="link">
    Distributed search and analytics engine.
  </Card>

<Card title="ElevenLabs" href="/oss/python/integrations/providers/elevenlabs" icon="link">
    AI voice synthesis and speech platform.
  </Card>

<Card title="EmbedChain" href="/oss/python/integrations/providers/embedchain" icon="link">
    Framework for creating RAG applications.
  </Card>

<Card title="Epsilla" href="/oss/python/integrations/providers/epsilla" icon="link">
    Vector database for AI and ML applications.
  </Card>

<Card title="Etherscan" href="/oss/python/integrations/providers/etherscan" icon="link">
    Ethereum blockchain explorer and analytics.
  </Card>

<Card title="EverlyAI" href="/oss/python/integrations/providers/everlyai" icon="link">
    Serverless AI inference platform.
  </Card>

<Card title="Evernote" href="/oss/python/integrations/providers/evernote" icon="link">
    Note-taking and organization platform.
  </Card>

<Card title="Exa Search" href="/oss/python/integrations/providers/exa_search" icon="link">
    AI-powered search engine for developers.
  </Card>

<Card title="Facebook" href="/oss/python/integrations/providers/facebook" icon="link">
    Meta's social platform integration and APIs.
  </Card>

<Card title="FalkorDB" href="/oss/python/integrations/providers/falkordb" icon="link">
    Graph database with ultra-low latency.
  </Card>

<Card title="Fauna" href="/oss/python/integrations/providers/fauna" icon="link">
    Serverless, globally distributed database.
  </Card>

<Card title="Featherless AI" href="/oss/python/integrations/providers/featherless-ai" icon="link">
    Fast and efficient AI model serving.
  </Card>

<Card title="Fiddler" href="/oss/python/integrations/providers/fiddler" icon="link">
    AI observability and monitoring platform.
  </Card>

<Card title="Figma" href="/oss/python/integrations/providers/figma" icon="link">
    Design collaboration and prototyping platform.
  </Card>

<Card title="FireCrawl" href="/oss/python/integrations/providers/firecrawl" icon="link">
    Web scraping and crawling API service.
  </Card>

<Card title="Fireworks" href="/oss/python/integrations/providers/fireworks" icon="link">
    Fast inference platform for open-source models.
  </Card>

<Card title="Flyte" href="/oss/python/integrations/providers/flyte" icon="link">
    Workflow orchestration for ML and data processing.
  </Card>

<Card title="FMP Data" href="/oss/python/integrations/providers/fmp-data" icon="link">
    Financial market data and analytics API.
  </Card>

<Card title="ForefrontAI" href="/oss/python/integrations/providers/forefrontai" icon="link">
    Fine-tuning platform for language models.
  </Card>

<Card title="Friendli" href="/oss/python/integrations/providers/friendli" icon="link">
    Optimized serving engine for AI models.
  </Card>

<Card title="Galaxia" href="/oss/python/integrations/providers/galaxia" icon="link">
    Prompt-driven engineering assistant.
  </Card>

<Card title="Gel" href="/oss/python/integrations/providers/gel" icon="link">
    Knowledge extraction and NLP platform.
  </Card>

<Card title="GeoPandas" href="/oss/python/integrations/providers/geopandas" icon="link">
    Geographic data analysis with Python.
  </Card>

<Card title="Git" href="/oss/python/integrations/providers/git" icon="link">
    Version control system integration.
  </Card>

<Card title="GitBook" href="/oss/python/integrations/providers/gitbook" icon="link">
    Documentation platform and knowledge base.
  </Card>

<Card title="GitHub" href="/oss/python/integrations/providers/github" icon="link">
    Code hosting and collaboration platform.
  </Card>

<Card title="GitLab" href="/oss/python/integrations/providers/gitlab" icon="link">
    DevOps platform and code repository.
  </Card>

<Card title="GOAT" href="/oss/python/integrations/providers/goat" icon="link">
    Tool use framework for AI agents.
  </Card>

<Card title="Golden" href="/oss/python/integrations/providers/golden" icon="link">
    Knowledge graph and data platform.
  </Card>

<Card title="Google" href="/oss/python/integrations/providers/google" icon="google">
    Google's AI services and cloud platform.
  </Card>

<Card title="Google Serper" href="/oss/python/integrations/providers/google_serper" icon="google">
    Google Search API service.
  </Card>

<Card title="GooseAI" href="/oss/python/integrations/providers/gooseai" icon="link">
    Fully managed NLP-as-a-Service platform.
  </Card>

<Card title="GPT4All" href="/oss/python/integrations/providers/gpt4all" icon="link">
    Open-source LLM ecosystem for local deployment.
  </Card>

<Card title="Gradient" href="/oss/python/integrations/providers/gradient" icon="link">
    AI model training and deployment platform.
  </Card>

<Card title="DigitalOcean Gradient AI Platform" href="/oss/python/integrations/providers/gradientai" icon="link">
    Single endpoint to multiple LLMs via serverless inference.
  </Card>

<Card title="Graph RAG" href="/oss/python/integrations/providers/graph_rag" icon="link">
    Graph-based retrieval augmented generation.
  </Card>

<Card title="GraphSignal" href="/oss/python/integrations/providers/graphsignal" icon="link">
    AI observability and monitoring platform.
  </Card>

<Card title="GreenNode" href="/oss/python/integrations/providers/greennode" icon="link">
    Sustainable AI computing platform.
  </Card>

<Card title="GROBID" href="/oss/python/integrations/providers/grobid" icon="link">
    Machine learning library for bibliographic data.
  </Card>

<Card title="Groq" href="/oss/python/integrations/providers/groq" icon="link">
    Ultra-fast inference with specialized hardware.
  </Card>

<Card title="Gutenberg" href="/oss/python/integrations/providers/gutenberg" icon="link">
    Project Gutenberg digital library access.
  </Card>

<Card title="Hacker News" href="/oss/python/integrations/providers/hacker_news" icon="link">
    Tech news and discussion platform.
  </Card>

<Card title="Hazy Research" href="/oss/python/integrations/providers/hazy_research" icon="link">
    Machine learning research and tools.
  </Card>

<Card title="Helicone" href="/oss/python/integrations/providers/helicone" icon="link">
    LLM observability and monitoring platform.
  </Card>

<Card title="Hologres" href="/oss/python/integrations/providers/hologres" icon="link">
    Real-time interactive analytics service.
  </Card>

<Card title="HTML2Text" href="/oss/python/integrations/providers/html2text" icon="link">
    HTML to plain text conversion utility.
  </Card>

<Card title="Huawei" href="/oss/python/integrations/providers/huawei" icon="link">
    Huawei Cloud AI services and models.
  </Card>

<Card title="Hugging Face" href="/oss/python/integrations/providers/huggingface" icon="link">
    Open platform for ML models and datasets.
  </Card>

<Card title="HyperBrowser" href="/oss/python/integrations/providers/hyperbrowser" icon="link">
    Web automation and scraping platform.
  </Card>

<Card title="IBM" href="/oss/python/integrations/providers/ibm" icon="link">
    IBM Watson AI and enterprise solutions.
  </Card>

<Card title="IEIT Systems" href="/oss/python/integrations/providers/ieit_systems" icon="link">
    Enterprise AI and system integration.
  </Card>

<Card title="iFixit" href="/oss/python/integrations/providers/ifixit" icon="link">
    Repair guides and technical documentation.
  </Card>

<Card title="iFlytek" href="/oss/python/integrations/providers/iflytek" icon="link">
    Chinese speech and language AI platform.
  </Card>

<Card title="IMSDb" href="/oss/python/integrations/providers/imsdb" icon="link">
    Internet Movie Script Database access.
  </Card>

<Card title="InfinispanVS" href="/oss/python/integrations/providers/infinispanvs" icon="link">
    Distributed cache and data grid platform.
  </Card>

<Card title="Infinity" href="/oss/python/integrations/providers/infinity" icon="link">
    High-performance embedding inference server.
  </Card>

<Card title="Infino" href="/oss/python/integrations/providers/infino" icon="link">
    Observability and monitoring platform.
  </Card>

<Card title="Intel" href="/oss/python/integrations/providers/intel" icon="link">
    Intel's AI optimization tools and libraries.
  </Card>

<Card title="IUGU" href="/oss/python/integrations/providers/iugu" icon="link">
    Brazilian payment processing platform.
  </Card>

<Card title="Jaguar" href="/oss/python/integrations/providers/jaguar" icon="link">
    Vector database and search platform.
  </Card>

<Card title="Javelin AI Gateway" href="/oss/python/integrations/providers/javelin_ai_gateway" icon="link">
    AI model gateway and management platform.
  </Card>

<Card title="Jenkins" href="/oss/python/integrations/providers/jenkins" icon="link">
    Automation server and CI/CD platform.
  </Card>

<Card title="Jina" href="/oss/python/integrations/providers/jina" icon="link">
    Neural search framework and cloud platform.
  </Card>

<Card title="John Snow Labs" href="/oss/python/integrations/providers/johnsnowlabs" icon="link">
    Enterprise NLP and healthcare AI platform.
  </Card>

<Card title="Joplin" href="/oss/python/integrations/providers/joplin" icon="link">
    Open-source note taking and organization.
  </Card>

<Card title="KDB.AI" href="/oss/python/integrations/providers/kdbai" icon="link">
    Time-series vector database platform.
  </Card>

<Card title="Kinetica" href="/oss/python/integrations/providers/kinetica" icon="link">
    Real-time analytics and database platform.
  </Card>

<Card title="KoboldAI" href="/oss/python/integrations/providers/koboldai" icon="link">
    Browser-based AI writing assistant.
  </Card>

<Card title="Konko" href="/oss/python/integrations/providers/konko" icon="link">
    Generative AI platform and model hosting.
  </Card>

<Card title="KoNLPy" href="/oss/python/integrations/providers/konlpy" icon="link">
    Korean natural language processing toolkit.
  </Card>

<Card title="Kuzu" href="/oss/python/integrations/providers/kuzu" icon="link">
    Embedded graph database management system.
  </Card>

<Card title="Label Studio" href="/oss/python/integrations/providers/labelstudio" icon="link">
    Data labeling and annotation platform.
  </Card>

<Card title="LakeFS" href="/oss/python/integrations/providers/lakefs" icon="link">
    Git-like version control for data lakes.
  </Card>

<Card title="LanceDB" href="/oss/python/integrations/providers/lancedb" icon="link">
    Developer-friendly embedded vector database.
  </Card>

<Card title="LangChain Decorators" href="/oss/python/integrations/providers/langchain_decorators" icon="link">
    Syntactic sugar and utilities for LangChain.
  </Card>

<Card title="LangFair" href="/oss/python/integrations/providers/langfair" icon="link">
    Bias testing framework for language models.
  </Card>

<Card title="LangFuse" href="/oss/python/integrations/providers/langfuse" icon="link">
    LLM engineering platform and observability.
  </Card>

<Card title="Lantern" href="/oss/python/integrations/providers/lantern" icon="link">
    PostgreSQL vector database extension.
  </Card>

<Card title="Lindorm" href="/oss/python/integrations/providers/lindorm" icon="link">
    Alibaba Cloud's multi-model database service.
  </Card>

<Card title="LinkUp" href="/oss/python/integrations/providers/linkup" icon="link">
    Real-time job market data and search.
  </Card>

<Card title="LiteLLM" href="/oss/python/integrations/providers/litellm" icon="link">
    Unified interface for 100+ LLM APIs.
  </Card>

<Card title="LlamaIndex" href="/oss/python/integrations/providers/llama_index" icon="link">
    Data framework for LLM applications.
  </Card>

<Card title="LlamaCPP" href="/oss/python/integrations/providers/llamacpp" icon="link">
    Port of Meta's LLaMA model in C/C++.
  </Card>

<Card title="LlamaEdge" href="/oss/python/integrations/providers/llamaedge" icon="link">
    Edge computing platform for LLaMA models.
  </Card>

<Card title="LlamaFile" href="/oss/python/integrations/providers/llamafile" icon="link">
    Single-file executable for running LLMs.
  </Card>

<Card title="LLMonitor" href="/oss/python/integrations/providers/llmonitor" icon="link">
    Observability platform for LLM applications.
  </Card>

<Card title="LocalAI" href="/oss/python/integrations/providers/localai" icon="link">
    Self-hosted OpenAI-compatible API server.
  </Card>

<Card title="Log10" href="/oss/python/integrations/providers/log10" icon="link">
    LLM data management and observability.
  </Card>

<Card title="MariaDB" href="/oss/python/integrations/providers/mariadb" icon="link">
    Open-source relational database management.
  </Card>

<Card title="MaritALK" href="/oss/python/integrations/providers/maritalk" icon="link">
    Brazilian Portuguese language model.
  </Card>

<Card title="Marqo" href="/oss/python/integrations/providers/marqo" icon="link">
    End-to-end vector search engine.
  </Card>

<Card title="MediaWiki Dump" href="/oss/python/integrations/providers/mediawikidump" icon="link">
    Wikipedia and MediaWiki data processing.
  </Card>

<Card title="Meilisearch" href="/oss/python/integrations/providers/meilisearch" icon="link">
    Lightning-fast search engine platform.
  </Card>

<Card title="Memcached" href="/oss/python/integrations/providers/memcached" icon="link">
    Distributed memory caching system.
  </Card>

<Card title="Memgraph" href="/oss/python/integrations/providers/memgraph" icon="link">
    Real-time graph database platform.
  </Card>

<Card title="Metal" href="/oss/python/integrations/providers/metal" icon="link">
    Managed vector search and retrieval.
  </Card>

<Card title="Microsoft" href="/oss/python/integrations/providers/microsoft" icon="microsoft">
    Microsoft Azure AI and enterprise services.
  </Card>

<Card title="Milvus" href="/oss/python/integrations/providers/milvus" icon="link">
    Open-source vector database for AI applications.
  </Card>

<Card title="MindsDB" href="/oss/python/integrations/providers/mindsdb" icon="link">
    AI layer for databases and data platforms.
  </Card>

<Card title="Minimax" href="/oss/python/integrations/providers/minimax" icon="link">
    Chinese AI company's language models.
  </Card>

<Card title="MistralAI" href="/oss/python/integrations/providers/mistralai" icon="link">
    Efficient open-source language models.
  </Card>

<Card title="MLflow" href="/oss/python/integrations/providers/mlflow" icon="link">
    ML lifecycle management platform.
  </Card>

<Card title="MLflow Tracking" href="/oss/python/integrations/providers/mlflow_tracking" icon="link">
    Experiment tracking and model registry.
  </Card>

<Card title="MLX" href="/oss/python/integrations/providers/mlx" icon="link">
    Apple's machine learning framework.
  </Card>

<Card title="Modal" href="/oss/python/integrations/providers/modal" icon="link">
    Serverless cloud computing for data science.
  </Card>

<Card title="ModelScope" href="/oss/python/integrations/providers/modelscope" icon="link">
    Alibaba's open-source model hub.
  </Card>

<Card title="Modern Treasury" href="/oss/python/integrations/providers/modern_treasury" icon="link">
    Payment operations and treasury management.
  </Card>

<Card title="Momento" href="/oss/python/integrations/providers/momento" icon="link">
    Serverless cache and vector index.
  </Card>

<Card title="MongoDB" href="/oss/python/integrations/providers/mongodb" icon="link">
    Document-based NoSQL database platform.
  </Card>

<Card title="MongoDB Atlas" href="/oss/python/integrations/providers/mongodb_atlas" icon="link">
    Cloud-hosted MongoDB with vector search.
  </Card>

<Card title="MotherDuck" href="/oss/python/integrations/providers/motherduck" icon="link">
    Serverless analytics with DuckDB in the cloud.
  </Card>

<Card title="Motorhead" href="/oss/python/integrations/providers/motorhead" icon="link">
    Long-term memory for AI conversations.
  </Card>

<Card title="MyScale" href="/oss/python/integrations/providers/myscale" icon="link">
    SQL-compatible vector database platform.
  </Card>

<Card title="Naver" href="/oss/python/integrations/providers/naver" icon="link">
    Naver's AI services and language models.
  </Card>

<Card title="Nebius" href="/oss/python/integrations/providers/nebius" icon="link">
    AI cloud platform and infrastructure.
  </Card>

<Card title="Neo4j" href="/oss/python/integrations/providers/neo4j" icon="link">
    Native graph database and analytics platform.
  </Card>

<Card title="NetMind" href="/oss/python/integrations/providers/netmind" icon="link">
    Decentralized AI computing network.
  </Card>

<Card title="Nimble" href="/oss/python/integrations/providers/nimble" icon="link">
    Web intelligence and data extraction.
  </Card>

<Card title="NLP Cloud" href="/oss/python/integrations/providers/nlpcloud" icon="link">
    Production-ready NLP API platform.
  </Card>

<Card title="Nomic" href="/oss/python/integrations/providers/nomic" icon="link">
    Open-source embedding models and tools.
  </Card>

<Card title="Notion" href="/oss/python/integrations/providers/notion" icon="link">
    All-in-one workspace and collaboration platform.
  </Card>

<Card title="Nuclia" href="/oss/python/integrations/providers/nuclia" icon="link">
    AI-powered search and understanding platform.
  </Card>

<Card title="NVIDIA" href="/oss/python/integrations/providers/nvidia" icon="link">
    NVIDIA's AI computing platform and models.
  </Card>

<Card title="Obsidian" href="/oss/python/integrations/providers/obsidian" icon="link">
    Connected note-taking and knowledge management.
  </Card>

<Card title="OceanBase" href="/oss/python/integrations/providers/oceanbase" icon="link">
    Distributed relational database system.
  </Card>

<Card title="OCI" href="/oss/python/integrations/providers/oci" icon="link">
    Oracle Cloud Infrastructure AI services.
  </Card>

<Card title="OctoAI" href="/oss/python/integrations/providers/octoai" icon="link">
    Efficient AI compute and model serving.
  </Card>

<Card title="Ollama" href="/oss/python/integrations/providers/ollama" icon="link">
    Run large language models locally.
  </Card>

<Card title="Ontotext GraphDB" href="/oss/python/integrations/providers/ontotext_graphdb" icon="link">
    RDF database and semantic graph platform.
  </Card>

<Card title="OpenAI" href="/oss/python/integrations/providers/openai" icon="openai">
    GPT models and comprehensive AI platform.
  </Card>

<Card title="OpenDataLoader PDF" href="/oss/python/integrations/providers/opendataloader_pdf" icon="link">
    Safe, Open, High-Performance — PDF for AI
  </Card>

<Card title="OpenGradient" href="/oss/python/integrations/providers/opengradient" icon="link">
    AI model training and fine-tuning platform.
  </Card>

<Card title="OpenLLM" href="/oss/python/integrations/providers/openllm" icon="link">
    Operating LLMs in production environment.
  </Card>

<Card title="OpenSearch" href="/oss/python/integrations/providers/opensearch" icon="link">
    Distributed search and analytics suite.
  </Card>

<Card title="OpenWeatherMap" href="/oss/python/integrations/providers/openweathermap" icon="link">
    Weather data and forecasting API.
  </Card>

<Card title="Oracle AI" href="/oss/python/integrations/providers/oracleai" icon="link">
    Oracle's AI and machine learning services.
  </Card>

<Card title="Outline" href="/oss/python/integrations/providers/outline" icon="link">
    Team knowledge base and wiki platform.
  </Card>

<Card title="Outlines" href="/oss/python/integrations/providers/outlines" icon="link">
    Structured generation for language models.
  </Card>

<Card title="Oxylabs" href="/oss/python/integrations/providers/oxylabs" icon="link">
    Web scraping and proxy services.
  </Card>

<Card title="Pandas" href="/oss/python/integrations/providers/pandas" icon="link">
    Data analysis and manipulation library.
  </Card>

<Card title="Perigon" href="/oss/python/integrations/providers/perigon" icon="link">
    Real-time news and media monitoring.
  </Card>

<Card title="Permit" href="/oss/python/integrations/providers/permit" icon="link">
    Authorization and access control platform.
  </Card>

<Card title="Perplexity" href="/oss/python/integrations/providers/perplexity" icon="link">
    AI-powered search and reasoning engine.
  </Card>

<Card title="Petals" href="/oss/python/integrations/providers/petals" icon="link">
    Distributed inference for large language models.
  </Card>

<Card title="PG Embedding" href="/oss/python/integrations/providers/pg_embedding" icon="link">
    PostgreSQL vector embedding extensions.
  </Card>

<Card title="pgvector" href="/oss/python/integrations/providers/pgvector" icon="link">
    Vector similarity search for PostgreSQL.
  </Card>

<Card title="Pinecone" href="/oss/python/integrations/providers/pinecone" icon="link">
    Managed vector database for ML applications.
  </Card>

<Card title="PipelineAI" href="/oss/python/integrations/providers/pipelineai" icon="link">
    ML pipeline and model deployment platform.
  </Card>

<Card title="Pipeshift" href="/oss/python/integrations/providers/pipeshift" icon="link">
    AI-powered content moderation platform.
  </Card>

<Card title="PolarisAIDataInsight" href="/oss/python/integrations/providers/polaris_ai_datainsight" icon="link">
    Document-loaders for various file formats.
  </Card>

<Card title="Portkey" href="/oss/python/integrations/providers/portkey/logging_tracing_portkey" icon="link">
    AI gateway and observability platform.
  </Card>

<Card title="Predibase" href="/oss/python/integrations/providers/predibase" icon="link">
    Fine-tuning platform for large language models.
  </Card>

<Card title="PredictionGuard" href="/oss/python/integrations/providers/predictionguard" icon="link">
    AI model security and compliance platform.
  </Card>

<Card title="PreMAI" href="/oss/python/integrations/providers/premai" icon="link">
    AI platform for model deployment and management.
  </Card>

<Card title="Privy" href="/oss/python/integrations/providers/privy" icon="link">
    Wallets and payments for AI agents.
  </Card>

<Card title="Prolog" href="/oss/python/integrations/providers/prolog" icon="link">
    Logic programming language integration.
  </Card>

<Card title="PromptLayer" href="/oss/python/integrations/providers/promptlayer" icon="link">
    Prompt engineering and observability platform.
  </Card>

<Card title="Psychic" href="/oss/python/integrations/providers/psychic" icon="link">
    Universal API for SaaS integrations.
  </Card>

<Card title="PubMed" href="/oss/python/integrations/providers/pubmed" icon="link">
    Biomedical literature database access.
  </Card>

<Card title="Pull MD" href="/oss/python/integrations/providers/pull-md" icon="link">
    Markdown content extraction and processing.
  </Card>

<Card title="PygmalionAI" href="/oss/python/integrations/providers/pygmalionai" icon="link">
    Conversational AI model platform.
  </Card>

<Card title="PyMuPDF4LLM" href="/oss/python/integrations/providers/pymupdf4llm" icon="link">
    PDF processing optimized for LLM ingestion.
  </Card>

<Card title="Qdrant" href="/oss/python/integrations/providers/qdrant" icon="link">
    Vector similarity search engine.
  </Card>

<Card title="Ragatouille" href="/oss/python/integrations/providers/ragatouille" icon="link">
    RAG toolkit with ColBERT indexing.
  </Card>

<Card title="Rank BM25" href="/oss/python/integrations/providers/rank_bm25" icon="link">
    BM25 ranking algorithm implementation.
  </Card>

<Card title="Ray Serve" href="/oss/python/integrations/providers/ray_serve" icon="link">
    Scalable model serving framework.
  </Card>

<Card title="Rebuff" href="/oss/python/integrations/providers/rebuff" icon="link">
    Prompt injection detection and prevention.
  </Card>

<Card title="Reddit" href="/oss/python/integrations/providers/reddit" icon="link">
    Social media platform integration and APIs.
  </Card>

<Card title="Redis" href="/oss/python/integrations/providers/redis" icon="link">
    In-memory data structure store and cache.
  </Card>

<Card title="Remembrall" href="/oss/python/integrations/providers/remembrall" icon="link">
    AI memory and context management.
  </Card>

<Card title="Replicate" href="/oss/python/integrations/providers/replicate" icon="link">
    Cloud platform for running ML models.
  </Card>

<Card title="Roam" href="/oss/python/integrations/providers/roam" icon="link">
    Research and note-taking platform.
  </Card>

<Card title="Robocorp" href="/oss/python/integrations/providers/robocorp" icon="link">
    Python automation and RPA platform.
  </Card>

<Card title="Rockset" href="/oss/python/integrations/providers/rockset" icon="link">
    Real-time analytics database platform.
  </Card>

<Card title="RunPod" href="/oss/python/integrations/providers/runpod" icon="link">
    GPU cloud platform for AI workloads.
  </Card>

<Card title="Salesforce" href="/oss/python/integrations/providers/salesforce" icon="link">
    CRM platform and business automation.
  </Card>

<Card title="SambaNova" href="/oss/python/integrations/providers/sambanova" icon="link">
    AI platform with specialized hardware.
  </Card>

<Card title="SAP" href="/oss/python/integrations/providers/sap" icon="link">
    Enterprise software and AI solutions.
  </Card>

<Card title="ScrapeGraph" href="/oss/python/integrations/providers/scrapegraph" icon="link">
    AI-powered web scraping framework.
  </Card>

<Card title="Scrapeless" href="/oss/python/integrations/providers/scrapeless" icon="link">
    Web scraping API and proxy service.
  </Card>

<Card title="SearchAPI" href="/oss/python/integrations/providers/searchapi" icon="link">
    Real-time search engine results API.
  </Card>

<Card title="SearX" href="/oss/python/integrations/providers/searx" icon="link">
    Privacy-respecting metasearch engine.
  </Card>

<Card title="SemaDB" href="/oss/python/integrations/providers/semadb" icon="link">
    Vector database for semantic search.
  </Card>

<Card title="SerpAPI" href="/oss/python/integrations/providers/serpapi" icon="link">
    Google Search results scraping API.
  </Card>

<Card title="Shale Protocol" href="/oss/python/integrations/providers/shaleprotocol" icon="link">
    Decentralized AI inference protocol.
  </Card>

<Card title="SingleStore" href="/oss/python/integrations/providers/singlestore" icon="link">
    Distributed database with vector capabilities.
  </Card>

<Card title="scikit-learn" href="/oss/python/integrations/providers/sklearn" icon="link">
    Machine learning library for Python.
  </Card>

<Card title="Slack" href="/oss/python/integrations/providers/slack" icon="link">
    Business communication and collaboration.
  </Card>

<Card title="Snowflake" href="/oss/python/integrations/providers/snowflake" icon="link">
    Cloud data platform and analytics.
  </Card>

<Card title="spaCy" href="/oss/python/integrations/providers/spacy" icon="link">
    Industrial-strength NLP library.
  </Card>

<Card title="Spark" href="/oss/python/integrations/providers/spark" icon="link">
    Unified analytics engine for big data.
  </Card>

<Card title="SparkLLM" href="/oss/python/integrations/providers/sparkllm" icon="link">
    iFlytek's multilingual language model.
  </Card>

<Card title="Spreedly" href="/oss/python/integrations/providers/spreedly" icon="link">
    Payment orchestration platform.
  </Card>

<Card title="SQLite" href="/oss/python/integrations/providers/sqlite" icon="link">
    Embedded relational database engine.
  </Card>

<Card title="StackExchange" href="/oss/python/integrations/providers/stackexchange" icon="link">
    Q\&A platform network integration.
  </Card>

<Card title="StarRocks" href="/oss/python/integrations/providers/starrocks" icon="link">
    High-performance analytical database.
  </Card>

<Card title="StochasticAI" href="/oss/python/integrations/providers/stochasticai" icon="link">
    GPU cloud platform for ML acceleration.
  </Card>

<Card title="Streamlit" href="/oss/python/integrations/providers/streamlit" icon="link">
    Web app framework for data science.
  </Card>

<Card title="Stripe" href="/oss/python/integrations/providers/stripe" icon="link">
    Online payment processing platform.
  </Card>

<Card title="Supabase" href="/oss/python/integrations/providers/supabase" icon="link">
    Open-source Firebase alternative.
  </Card>

<Card title="SurrealDB" href="/oss/python/integrations/providers/surrealdb" icon="link">
    Multi-model database for modern applications.
  </Card>

<Card title="Symbl.ai Nebula" href="/oss/python/integrations/providers/symblai_nebula" icon="link">
    Conversation intelligence platform.
  </Card>

<Card title="Tableau" href="/oss/python/integrations/providers/tableau" icon="link">
    Data visualization and business intelligence.
  </Card>

<Card title="Taiga" href="/oss/python/integrations/providers/taiga" icon="link">
    Project management platform for agile teams.
  </Card>

<Card title="Tair" href="/oss/python/integrations/providers/tair" icon="link">
    Alibaba Cloud's in-memory database.
  </Card>

<Card title="Tavily" href="/oss/python/integrations/providers/tavily" icon="link">
    AI-optimized search API for applications.
  </Card>

<Card title="Telegram" href="/oss/python/integrations/providers/telegram" icon="link">
    Messaging platform and bot integration.
  </Card>

<Card title="Tencent" href="/oss/python/integrations/providers/tencent" icon="link">
    Tencent Cloud AI services and models.
  </Card>

<Card title="TensorFlow Datasets" href="/oss/python/integrations/providers/tensorflow_datasets" icon="link">
    Collection of ready-to-use datasets.
  </Card>

<Card title="TensorLake" href="/oss/python/integrations/providers/tensorlake" icon="link">
    Data infrastructure for ML applications.
  </Card>

<Card title="TiDB" href="/oss/python/integrations/providers/tidb" icon="link">
    Distributed SQL database platform.
  </Card>

<Card title="TigerGraph" href="/oss/python/integrations/providers/tigergraph" icon="link">
    Scalable graph database and analytics.
  </Card>

<Card title="Tigris" href="/oss/python/integrations/providers/tigris" icon="link">
    Globally distributed database platform.
  </Card>

<Card title="Tilores" href="/oss/python/integrations/providers/tilores" icon="link">
    Entity resolution and data matching.
  </Card>

<Card title="Together" href="/oss/python/integrations/providers/together" icon="link">
    Fast inference for open-source models.
  </Card>

<Card title="ToMarkdown" href="/oss/python/integrations/providers/tomarkdown" icon="link">
    HTML to Markdown conversion utility.
  </Card>

<Card title="Toolbox LangChain" href="/oss/python/integrations/providers/toolbox" icon="link">
    Extended toolkit for LangChain applications.
  </Card>

<Card title="Transwarp" href="/oss/python/integrations/providers/transwarp" icon="link">
    Big data platform and analytics suite.
  </Card>

<Card title="Trello" href="/oss/python/integrations/providers/trello" icon="link">
    Visual project management and collaboration.
  </Card>

<Card title="Trubrics" href="/oss/python/integrations/providers/trubrics" icon="link">
    LLM evaluation and analytics platform.
  </Card>

<Card title="TrueFoundry" href="/oss/python/integrations/providers/truefoundry" icon="link">
    ML platform for model deployment.
  </Card>

<Card title="TrueLens" href="/oss/python/integrations/providers/trulens" icon="link">
    Evaluation framework for LLM applications.
  </Card>

<Card title="Twitter" href="/oss/python/integrations/providers/twitter" icon="link">
    Social media platform integration.
  </Card>

<Card title="Typesense" href="/oss/python/integrations/providers/typesense" icon="link">
    Fast and typo-tolerant search engine.
  </Card>

<Card title="UnDatasIO" href="/oss/python/integrations/providers/undatasio" icon="link">
    Data extraction and processing platform.
  </Card>

<Card title="Unstructured" href="/oss/python/integrations/providers/unstructured" icon="link">
    Document processing and data extraction.
  </Card>

<Card title="Upstage" href="/oss/python/integrations/providers/upstage" icon="link">
    Document AI and OCR platform.
  </Card>

<Card title="Upstash" href="/oss/python/integrations/providers/upstash" icon="link">
    Serverless data platform for Redis and Kafka.
  </Card>

<Card title="UpTrain" href="/oss/python/integrations/providers/uptrain" icon="link">
    ML observability and evaluation platform.
  </Card>

<Card title="USearch" href="/oss/python/integrations/providers/usearch" icon="link">
    Single-file vector search engine.
  </Card>

<Card title="Valthera" href="/oss/python/integrations/providers/valthera" icon="link">
    AI platform for healthcare applications.
  </Card>

<Card title="Valyu" href="/oss/python/integrations/providers/valyu" icon="link">
    AI-powered data analysis platform.
  </Card>

<Card title="VDMS" href="/oss/python/integrations/providers/vdms" icon="link">
    Visual data management system.
  </Card>

<Card title="Vearch" href="/oss/python/integrations/providers/vearch" icon="link">
    Distributed vector search engine.
  </Card>

<Card title="Vectara" href="/oss/python/integrations/providers/vectara" icon="link">
    Neural search platform with built-in understanding.
  </Card>

<Card title="Vectorize" href="/oss/python/integrations/providers/vectorize" icon="link">
    Vector database and semantic search.
  </Card>

<Card title="Vespa" href="/oss/python/integrations/providers/vespa" icon="link">
    Big data serving engine for vector search.
  </Card>

<Card title="VLite" href="/oss/python/integrations/providers/vlite" icon="link">
    Simple vector database for embeddings.
  </Card>

<Card title="VoyageAI" href="/oss/python/integrations/providers/voyageai" icon="link">
    Embedding models and semantic search.
  </Card>

<Card title="Weights & Biases" href="/oss/python/integrations/providers/wandb" icon="link">
    ML experiment tracking and collaboration.
  </Card>

<Card title="Weights & Biases Tracking" href="/oss/python/integrations/providers/wandb_tracking" icon="link">
    Experiment tracking and model management.
  </Card>

<Card title="Weights & Biases Tracing" href="/oss/python/integrations/providers/wandb_tracing" icon="link">
    LLM tracing and observability.
  </Card>

<Card title="Weather" href="/oss/python/integrations/providers/weather" icon="link">
    Weather data and forecasting services.
  </Card>

<Card title="Weaviate" href="/oss/python/integrations/providers/weaviate" icon="link">
    Open-source vector database with GraphQL.
  </Card>

<Card title="WhatsApp" href="/oss/python/integrations/providers/whatsapp" icon="link">
    Messaging platform integration and automation.
  </Card>

<Card title="WhyLabs Profiling" href="/oss/python/integrations/providers/whylabs_profiling" icon="link">
    AI observability and data monitoring.
  </Card>

<Card title="Wikipedia" href="/oss/python/integrations/providers/wikipedia" icon="link">
    Wikipedia content access and search.
  </Card>

<Card title="Wolfram Alpha" href="/oss/python/integrations/providers/wolfram_alpha" icon="link">
    Computational knowledge engine.
  </Card>

<Card title="WRITER" href="/oss/python/integrations/providers/writer" icon="link">
    Enterprise models and tools for building, activating, and supervising AI agents.
  </Card>

<Card title="XAI" href="/oss/python/integrations/providers/xai" icon="link">
    xAI's Grok models for conversational AI.
  </Card>

<Card title="Xata" href="/oss/python/integrations/providers/xata" icon="link">
    Serverless database with vector search.
  </Card>

<Card title="Xinference" href="/oss/python/integrations/providers/xinference" icon="link">
    Distributed inference framework for LLMs.
  </Card>

<Card title="Yahoo" href="/oss/python/integrations/providers/yahoo" icon="link">
    Yahoo services and data integration.
  </Card>

<Card title="Yandex" href="/oss/python/integrations/providers/yandex" icon="link">
    Yandex AI services and language models.
  </Card>

<Card title="YDB" href="/oss/python/integrations/providers/ydb" icon="link">
    Yandex Database distributed storage system.
  </Card>

<Card title="YeagerAI" href="/oss/python/integrations/providers/yeagerai" icon="link">
    AI agent framework and development platform.
  </Card>

<Card title="Yellowbrick" href="/oss/python/integrations/providers/yellowbrick" icon="link">
    Data warehouse and analytics platform.
  </Card>

<Card title="Yi" href="/oss/python/integrations/providers/yi" icon="link">
    01.AI's bilingual language models.
  </Card>

<Card title="You" href="/oss/python/integrations/providers/you" icon="link">
    You.com search engine and AI platform.
  </Card>

<Card title="YouTube" href="/oss/python/integrations/providers/youtube" icon="link">
    Video platform integration and content access.
  </Card>

<Card title="Zep" href="/oss/python/integrations/providers/zep" icon="link">
    Long-term memory for AI assistants.
  </Card>

<Card title="ZeusDB" href="/oss/python/integrations/providers/zeusdb" icon="link">
    High-performance vector database.
  </Card>

<Card title="ZhipuAI" href="/oss/python/integrations/providers/zhipuai" icon="link">
    ChatGLM and other Chinese language models.
  </Card>

<Card title="Zilliz" href="/oss/python/integrations/providers/zilliz" icon="link">
    Managed Milvus vector database service.
  </Card>

<Card title="Zotero" href="/oss/python/integrations/providers/zotero" icon="link">
    Reference management and research tool.
  </Card>
</Columns>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/integrations/providers/all_providers.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## ahead of time and use those to disambiguate the user input. E.g. if a user searches for

**URL:** llms-txt#ahead-of-time-and-use-those-to-disambiguate-the-user-input.-e.g.-if-a-user-searches-for

---

## Try searching for assistants. This also should fail

**URL:** llms-txt#try-searching-for-assistants.-this-also-should-fail

try:
    await alice.assistants.search()
    print("❌ Alice shouldn't be able to search assistants!")
except Exception as e:
    print("✅ Alice correctly denied access to searching assistants:", e)

---

## Compile the graph with the checkpointer and store

**URL:** llms-txt#compile-the-graph-with-the-checkpointer-and-store

graph = graph.compile(checkpointer=checkpointer, store=in_memory_store)
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
We invoke the graph with a `thread_id`, as before, and also with a `user_id`, which we'll use to namespace our memories to this particular user as we showed above.
```

---

## Enable TTL and data retention

**URL:** llms-txt#enable-ttl-and-data-retention

**Contents:**
- Requirements
- ClickHouse TTL Cleanup Job
  - Default Schedule
  - Disabling the Job
  - Configuring the Schedule
  - Configuring Minimum Expired Rows Per Part
  - Configuring Maximum Active Mutations
  - Emergency: Stopping Running Mutations
  - Backups and Data Retention

Source: https://docs.langchain.com/langsmith/self-host-ttl

LangSmith Self-Hosted allows enablement of automatic TTL and Data Retention of traces. This can be useful if you're complying with data privacy regulations, or if you want to have more efficient space usage and auto cleanup of your traces. Traces will also have their data retention period automatically extended based on certain actions or run rule applications.

You can configure retention through helm or environment variable settings. There are a few options that are configurable:

* *Enabled:* Whether data retention is enabled or disabled. If enabled, via the UI you can your default organization and project TTL tiers to apply to traces (see [data retention guide](/langsmith/administration-overview#data-retention) for details).
* *Retention Periods:* You can configure system-wide retention periods for shortlived and longlived traces. Once configured, you can manage the retention level at each project as well as set an organization-wide default for new projects.

## ClickHouse TTL Cleanup Job

As of version **0.11**, a cron job runs on weekends to assist in deleting expired data that may not have been cleaned up by ClickHouse's built-in TTL mechanism.

<Warning>
  This job uses potentially long running **mutations** (`ALTER TABLE DELETE`), which are expensive operations that can impact ClickHouse's performance. We recommend running these operations only during off-peak hours (nights and weekends). During testing with **1 concurrent active** mutation (default), we did not observe significant CPU, memory, or latency increases.
</Warning>

By default, the cleanup job runs:

* **Saturday**: 8pm and 10pm UTC
* **Sunday**: 12am, 2am, and 4am UTC

### Disabling the Job

To disable the cleanup job entirely:

### Configuring the Schedule

You can customize when the cleanup job runs by modifying the cron expressions:

<Tip>
  To run the job on a single cron schedule, set both `CLICKHOUSE_TTL_CLEANUP_CRON_WEEKEND_EVENING` and `CLICKHOUSE_TTL_CLEANUP_CRON_WEEKEND_MORNING` to the same value. Job locking prevents overlapping executions.
</Tip>

### Configuring Minimum Expired Rows Per Part

The job goes table by table, scanning parts and deleting data from parts containing a minimum number of expired rows. This threshold balances efficiency and thoroughness:

* **Too low**: Job scans entire parts to clear minimal data (inefficient)
* **Too high**: Job misses parts with significant expired data

#### Checking Expired Rows

Use this query to analyze expired rows in your tables, and tweak your minimum value accordingly:

### Configuring Maximum Active Mutations

Delete operations can be time-consuming (\~50 minutes for a 100GB part). You can increase concurrent mutations to speed up the process:

<Warning>
  Increasing concurrent DELETE operations can severely impact system performance. Monitor your system carefully and only increase this value if you can tolerate potentially slower insert and read latencies.
</Warning>

### Emergency: Stopping Running Mutations

If you experience latency spikes and need to terminate a running mutation:

1. **Find active mutations**:

Look for the `mutation_id` where the `command` column contains a `DELETE` statement.

2. **Kill the mutation**:

### Backups and Data Retention

If disk space does not decrease after running this job, or if it continues to increase, backups may be causing the issue by creating file system hard links. These links prevent ClickHouse from cleaning up the data.

To verify, check the following directories inside your ClickHouse pod:

* `/var/lib/clickhouse/backup`
* `/var/lib/clickhouse/shadow`

If backups are present, copy them to an external filesystem or blob storage (e.g., S3), then clear the directories. Within a few minutes, you will notice disk space releasing.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/self-host-ttl.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

## ClickHouse TTL Cleanup Job

As of version **0.11**, a cron job runs on weekends to assist in deleting expired data that may not have been cleaned up by ClickHouse's built-in TTL mechanism.

<Warning>
  This job uses potentially long running **mutations** (`ALTER TABLE DELETE`), which are expensive operations that can impact ClickHouse's performance. We recommend running these operations only during off-peak hours (nights and weekends). During testing with **1 concurrent active** mutation (default), we did not observe significant CPU, memory, or latency increases.
</Warning>

### Default Schedule

By default, the cleanup job runs:

* **Saturday**: 8pm and 10pm UTC
* **Sunday**: 12am, 2am, and 4am UTC

### Disabling the Job

To disable the cleanup job entirely:
```

Example 3 (unknown):
```unknown
### Configuring the Schedule

You can customize when the cleanup job runs by modifying the cron expressions:
```

Example 4 (unknown):
```unknown
<Tip>
  To run the job on a single cron schedule, set both `CLICKHOUSE_TTL_CLEANUP_CRON_WEEKEND_EVENING` and `CLICKHOUSE_TTL_CLEANUP_CRON_WEEKEND_MORNING` to the same value. Job locking prevents overlapping executions.
</Tip>

### Configuring Minimum Expired Rows Per Part

The job goes table by table, scanning parts and deleting data from parts containing a minimum number of expired rows. This threshold balances efficiency and thoroughness:

* **Too low**: Job scans entire parts to clear minimal data (inefficient)
* **Too high**: Job misses parts with significant expired data
```

---

## with information about the graph node where the LLM was called and other information

**URL:** llms-txt#with-information-about-the-graph-node-where-the-llm-was-called-and-other-information

**Contents:**
- Stream custom data
- Use with any LLM

for msg, metadata in graph.stream(
    inputs,
    stream_mode="messages",  # [!code highlight]
):
    # Filter the streamed tokens by the langgraph_node field in the metadata
    # to only include the tokens from the specified node
    if msg.content and metadata["langgraph_node"] == "some_node_name":
        ...
python  theme={null}
  from typing import TypedDict
  from langgraph.graph import START, StateGraph
  from langchain_openai import ChatOpenAI

model = ChatOpenAI(model="gpt-4o-mini")

class State(TypedDict):
        topic: str
        joke: str
        poem: str

def write_joke(state: State):
        topic = state["topic"]
        joke_response = model.invoke(
              [{"role": "user", "content": f"Write a joke about {topic}"}]
        )
        return {"joke": joke_response.content}

def write_poem(state: State):
        topic = state["topic"]
        poem_response = model.invoke(
              [{"role": "user", "content": f"Write a short poem about {topic}"}]
        )
        return {"poem": poem_response.content}

graph = (
        StateGraph(State)
        .add_node(write_joke)
        .add_node(write_poem)
        # write both the joke and the poem concurrently
        .add_edge(START, "write_joke")
        .add_edge(START, "write_poem")
        .compile()
  )

# The "messages" stream mode returns a tuple of (message_chunk, metadata)
  # where message_chunk is the token streamed by the LLM and metadata is a dictionary
  # with information about the graph node where the LLM was called and other information
  for msg, metadata in graph.stream(
      {"topic": "cats"},
      stream_mode="messages",  # [!code highlight]
  ):
      # Filter the streamed tokens by the langgraph_node field in the metadata
      # to only include the tokens from the write_poem node
      if msg.content and metadata["langgraph_node"] == "write_poem":
          print(msg.content, end="|", flush=True)
  python  theme={null}
    from typing import TypedDict
    from langgraph.config import get_stream_writer
    from langgraph.graph import StateGraph, START

class State(TypedDict):
        query: str
        answer: str

def node(state: State):
        # Get the stream writer to send custom data
        writer = get_stream_writer()
        # Emit a custom key-value pair (e.g., progress update)
        writer({"custom_key": "Generating custom data inside node"})
        return {"answer": "some data"}

graph = (
        StateGraph(State)
        .add_node(node)
        .add_edge(START, "node")
        .compile()
    )

inputs = {"query": "example"}

# Set stream_mode="custom" to receive the custom data in the stream
    for chunk in graph.stream(inputs, stream_mode="custom"):
        print(chunk)
    python  theme={null}
    from langchain.tools import tool
    from langgraph.config import get_stream_writer

@tool
    def query_database(query: str) -> str:
        """Query the database."""
        # Access the stream writer to send custom data
        writer = get_stream_writer()  # [!code highlight]
        # Emit a custom key-value pair (e.g., progress update)
        writer({"data": "Retrieved 0/100 records", "type": "progress"})  # [!code highlight]
        # perform query
        # Emit another custom key-value pair
        writer({"data": "Retrieved 100/100 records", "type": "progress"})
        return "some-answer"

graph = ... # define a graph that uses this tool

# Set stream_mode="custom" to receive the custom data in the stream
    for chunk in graph.stream(inputs, stream_mode="custom"):
        print(chunk)
    python  theme={null}
from langgraph.config import get_stream_writer

def call_arbitrary_model(state):
    """Example node that calls an arbitrary model and streams the output"""
    # Get the stream writer to send custom data
    writer = get_stream_writer()  # [!code highlight]
    # Assume you have a streaming client that yields chunks
    # Generate LLM tokens using your custom streaming client
    for chunk in your_custom_streaming_client(state["topic"]):
        # Use the writer to send custom data to the stream
        writer({"custom_llm_chunk": chunk})  # [!code highlight]
    return {"result": "completed"}

graph = (
    StateGraph(State)
    .add_node(call_arbitrary_model)
    # Add other nodes and edges as needed
    .compile()
)

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Extended example: streaming LLM tokens from specific nodes">
```

Example 2 (unknown):
```unknown
</Accordion>

## Stream custom data

To send **custom user-defined data** from inside a LangGraph node or tool, follow these steps:

1. Use [`get_stream_writer`](https://reference.langchain.com/python/langgraph/config/#langgraph.config.get_stream_writer) to access the stream writer and emit custom data.
2. Set `stream_mode="custom"` when calling `.stream()` or `.astream()` to get the custom data in the stream. You can combine multiple modes (e.g., `["updates", "custom"]`), but at least one must be `"custom"`.

<Warning>
  **No [`get_stream_writer`](https://reference.langchain.com/python/langgraph/config/#langgraph.config.get_stream_writer) in async for Python \< 3.11**
  In async code running on Python \< 3.11, [`get_stream_writer`](https://reference.langchain.com/python/langgraph/config/#langgraph.config.get_stream_writer) will not work.
  Instead, add a `writer` parameter to your node or tool and pass it manually.
  See [Async with Python \< 3.11](#async) for usage examples.
</Warning>

<Tabs>
  <Tab title="node">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="tool">
```

Example 4 (unknown):
```unknown
</Tab>
</Tabs>

## Use with any LLM

You can use `stream_mode="custom"` to stream data from **any LLM API** — even if that API does **not** implement the LangChain chat model interface.

This lets you integrate raw LLM clients or external services that provide their own streaming interfaces, making LangGraph highly flexible for custom setups.
```

---

## Use threads

**URL:** llms-txt#use-threads

**Contents:**
- Create a thread
  - Empty thread
  - Copy thread
  - Prepopulated State
- List threads
  - LangGraph SDK
  - LangSmith UI
- Inspect threads
  - LangGraph SDK
  - LangSmith UI

Source: https://docs.langchain.com/langsmith/use-threads

In this guide, we will show how to create, view, and inspect [threads](/oss/python/langgraph/persistence#threads).

To run your graph and the state persisted, you must first create a thread.

To create a new thread, use the [LangGraph SDK](/langsmith/sdk) `create` method. See the [Python](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.client.ThreadsClient.create) and [JS](https://reference.langchain.com/javascript/classes/_langchain_langgraph-sdk.client.ThreadsClient.html#create) SDK reference docs for more information.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Alternatively, if you already have a thread in your application whose state you wish to copy, you can use the `copy` method. This will create an independent thread whose history is identical to the original thread at the time of the operation. See the [Python](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.client.ThreadsClient.copy) and [JS](https://reference.langchain.com/javascript/classes/_langchain_langgraph-sdk.client.ThreadsClient.html#copy) SDK reference docs for more information.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

### Prepopulated State

Finally, you can create a thread with an arbitrary pre-defined state by providing a list of `supersteps` into the `create` method. The `supersteps` describe a list of a sequence of state updates. For example:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

To list threads, use the [LangGraph SDK](/langsmith/sdk) `search` method. This will list the threads in the application that match the provided filters. See the [Python](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.client.ThreadsClient.search) and [JS](https://reference.langchain.com/javascript/classes/_langchain_langgraph-sdk.client.ThreadsClient.html#search) SDK reference docs for more information.

#### Filter by thread status

Use the `status` field to filter threads based on their status. Supported values are `idle`, `busy`, `interrupted`, and `error`. See [here](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.schema.ThreadStatus) for information on each status. For example, to view `idle` threads:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

#### Filter by metadata

The `search` method allows you to filter on metadata:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

The SDK also supports sorting threads by `thread_id`, `status`, `created_at`, and `updated_at` using the `sort_by` and `sort_order` params.

You can also view threads in a deployment via the LangSmith UI.

Inside your deployment, select the "Threads" tab. This will load a table of all of the threads in your deployment.

To filter by thread status, select a status in the top bar. To sort by a supported property, click on the arrow icon for the desired column.

To view a specific thread given its `thread_id`, use the `get` method:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

#### Inspect thread state

To view the current state of a given thread, use the `get_state` method:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Optionally, to view the state of a thread at a given checkpoint, simply pass in the checkpoint id (or the entire checkpoint object):

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

#### Inspect full thread history

To view a thread's history, use the `get_history` method. This returns a list of every state the thread experienced. For more information see the [Python](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.client.ThreadsClient.get_history) and [JS](https://reference.langchain.com/javascript/classes/_langchain_langgraph-sdk.client.ThreadsClient.html#gethistory) reference docs.

You can also view threads in a deployment via the LangSmith UI.

Inside your deployment, select the "Threads" tab. This will load a table of all of the threads in your deployment.

Select a thread to inspect its current state. To view its full history and for further debugging, open the thread in [Studio](/langsmith/studio).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/use-threads.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="Javascript">
```

Example 2 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

Example 3 (unknown):
```unknown
</Tab>
</Tabs>

Output:
```

Example 4 (unknown):
```unknown
### Copy thread

Alternatively, if you already have a thread in your application whose state you wish to copy, you can use the `copy` method. This will create an independent thread whose history is identical to the original thread at the time of the operation. See the [Python](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.client.ThreadsClient.copy) and [JS](https://reference.langchain.com/javascript/classes/_langchain_langgraph-sdk.client.ThreadsClient.html#copy) SDK reference docs for more information.

<Tabs>
  <Tab title="Python">
```

---

## Run a specific test file

**URL:** llms-txt#run-a-specific-test-file

uv run --group test pytest tests/integration_tests/test_chat_models.py

---

## Build the graph with explicit schemas

**URL:** llms-txt#build-the-graph-with-explicit-schemas

builder = StateGraph(OverallState, input_schema=InputState, output_schema=OutputState)
builder.add_node(answer_node)
builder.add_edge(START, "answer_node")
builder.add_edge("answer_node", END)
graph = builder.compile()

---

## Security policy

**URL:** llms-txt#security-policy

**Contents:**
- Best practices
- Reporting OSS vulnerabilities
  - In-scope targets
  - Out-of-scope targets
- Reporting LangSmith vulnerabilities
  - Other security concerns

Source: https://docs.langchain.com/oss/python/security-policy

LangChain has a large ecosystem of integrations with various external resources like local and remote file systems, APIs and databases. These integrations allow developers to create versatile applications that combine the power of LLMs with the ability to access, interact with and manipulate external resources.

When building such applications developers should remember to follow good security practices:

* [**Limit permissions**](https://en.wikipedia.org/wiki/Principle_of_least_privilege): Scope permissions specifically to the application's need. Granting broad or excessive permissions can introduce significant security vulnerabilities. To avoid such vulnerabilities, consider using read-only credentials, disallowing access to sensitive resources, using sandboxing techniques (such as running inside a container), specifying proxy configurations to control external requests, etc. as appropriate for your application.
* **Anticipate potential misuse**: Just as humans can err, so can Large Language Models (LLMs). Always assume that any system access or credentials may be used in any way allowed by the permissions they are assigned. For example, if a pair of database credentials allows deleting data, it's safest to assume that any LLM able to use those credentials may in fact delete data.
* [**Defense in depth**](https://en.wikipedia.org/wiki/Defense_in_depth_\(computing\)): No security technique is perfect. Fine-tuning and good chain design can reduce, but not eliminate, the odds that a Large Language Model (LLM) may make a mistake. It's best to combine multiple layered security approaches rather than relying on any single layer of defense to ensure security. For example: use both read-only permissions and sandboxing to ensure that LLMs are only able to access data that is explicitly meant for them to use.

Risks of not doing so include, but are not limited to:

* Data corruption or loss.
* Unauthorized access to confidential information.
* Compromised performance or availability of critical resources.

Example scenarios with mitigation strategies:

* A user may ask an agent with access to the file system to delete files that should not be deleted or read the content of files that contain sensitive information. To mitigate, limit the agent to only use a specific directory and only allow it to read or write files that are safe to read or write. Consider further sandboxing the agent by running it in a container.
* A user may ask an agent with write access to an external API to write malicious data to the API, or delete data from that API. To mitigate, give the agent read-only API keys, or limit it to only use endpoints that are already resistant to such misuse.
* A user may ask an agent with access to a database to drop a table or mutate the schema. To mitigate, scope the credentials to only the tables that the agent needs to access and consider issuing READ-ONLY credentials.

If you're building applications that access external resources like file systems, APIs
or databases, consider speaking with your company's security team to determine how to best
design and secure your applications.

## Reporting OSS vulnerabilities

LangChain is partnered with [huntr by Protect AI](https://huntr.com/) to provide
a bounty program for our open source projects.

Please report security vulnerabilities associated with the LangChain
open source projects at [huntr](https://huntr.com/bounties/disclose/?target=https%3A%2F%2Fgithub.com%2Flangchain-ai%2Flangchain\&validSearch=true).

Before reporting a vulnerability, please review:

1. [In-scope targets](#in-scope-targets) and [out-of-scope targets](#out-of-scope-targets).
2. The [langchain-ai/langchain](https://python.langchain.com/docs/contributing/repo_structure) monorepo structure.
3. The [best practices](#best-practices) above to
   understand what we consider to be a security vulnerability vs. developer
   responsibility.

The following packages and repositories are eligible for bug bounties:

* langchain-core
* langchain (see exceptions)
* langchain-community (see exceptions)
* langgraph
* langserve

### Out-of-scope targets

All out of scope targets defined by huntr as well as:

* **langchain-experimental**: This repository is for experimental code and is not
  eligible for bug bounties (see [package warning](https://pypi.org/project/langchain-experimental/)), bug reports to it will be marked as interesting or waste of
  time and published with no bounty attached.
* **tools**: Tools in either langchain or langchain-community are not eligible for bug
  bounties. This includes the following directories
  * libs/langchain/langchain/tools
  * libs/community/langchain\_community/tools
  * Please review the [best practices](#best-practices)
    for more details, but generally tools interact with the real world. Developers are
    expected to understand the security implications of their code and are responsible
    for the security of their tools.
* Code documented with security notices. This will be decided on a case by
  case basis, but likely will not be eligible for a bounty as the code is already
  documented with guidelines for developers that should be followed for making their
  application secure.
* Any LangSmith related repositories or APIs (see [Reporting LangSmith vulnerabilities](#reporting-langsmith-vulnerabilities)).

## Reporting LangSmith vulnerabilities

Please report security vulnerabilities associated with LangSmith by email to `security@langchain.dev`.

* LangSmith site: [https://smith.langchain.com](https://smith.langchain.com)
* SDK client: [https://github.com/langchain-ai/langsmith-sdk](https://github.com/langchain-ai/langsmith-sdk)

### Other security concerns

For any other security concerns, please contact us at `security@langchain.dev`.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/security-policy.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## The above chain will be traced as a child run of the traceable function

**URL:** llms-txt#the-above-chain-will-be-traced-as-a-child-run-of-the-traceable-function

**Contents:**
- Interoperability between LangChain.JS and LangSmith SDK
  - Tracing LangChain objects inside `traceable` (JS only)
  - Tracing LangChain child runs via `traceable` / RunTree API (JS only)

@traceable(
    tags=["openai", "chat"],
    metadata={"foo": "bar"}
)
def invoke_runnnable(question, context):
    result = chain.invoke({"question": question, "context": context})
    return "The response is: " + result

invoke_runnnable("Can you summarize this morning's meetings?", "During this morning's meeting, we solved all world conflict.")
typescript  theme={null}
import { ChatOpenAI } from "@langchain/openai";
import { ChatPromptTemplate } from "@langchain/core/prompts";
import { StringOutputParser } from "@langchain/core/output_parsers";
import { getLangchainCallbacks } from "langsmith/langchain";

const prompt = ChatPromptTemplate.fromMessages([
  [
    "system",
    "You are a helpful assistant. Please respond to the user's request only based on the given context.",
  ],
  ["user", "Question: {question}\nContext: {context}"],
]);

const model = new ChatOpenAI({ modelName: "gpt-4o-mini" });
const outputParser = new StringOutputParser();
const chain = prompt.pipe(model).pipe(outputParser);

const main = traceable(
  async (input: { question: string; context: string }) => {
    const callbacks = await getLangchainCallbacks();
    const response = await chain.invoke(input, { callbacks });
    return response;
  },
  { name: "main" }
);
typescript  theme={null}
import { traceable } from "langsmith/traceable";
import { RunnableLambda } from "@langchain/core/runnables";
import { RunnableConfig } from "@langchain/core/runnables";

const tracedChild = traceable((input: string) => `Child Run: ${input}`, {
  name: "Child Run",
});

const parrot = new RunnableLambda({
  func: async (input: { text: string }, config?: RunnableConfig) => {
    return await tracedChild(input.text);
  },
});
typescript Traceable theme={null}
  import { traceable } from "langsmith/traceable";
  import { RunnableLambda } from "@langchain/core/runnables";
  import { RunnableConfig } from "@langchain/core/runnables";

const tracedChild = traceable((input: string) => `Child Run: ${input}`, {
    name: "Child Run",
  });

const parrot = new RunnableLambda({
    func: async (input: { text: string }, config?: RunnableConfig) => {
      // Pass the config to existing traceable function
      await tracedChild(config, input.text);
      return input.text;
    },
  });
  typescript Run Tree theme={null}
  import { RunTree } from "langsmith/run_trees";
  import { RunnableLambda } from "@langchain/core/runnables";
  import { RunnableConfig } from "@langchain/core/runnables";

const parrot = new RunnableLambda({
    func: async (input: { text: string }, config?: RunnableConfig) => {
      // create the RunTree from the RunnableConfig of the RunnableLambda
      const childRunTree = RunTree.fromRunnableConfig(config, {
        name: "Child Run",
      });

childRunTree.inputs = { input: input.text };
      await childRunTree.postRun();

childRunTree.outputs = { output: `Child Run: ${input.text}` };
      await childRunTree.patchRun();

return input.text;
    },
  });
  ```
</CodeGroup>

If you prefer a video tutorial, check out the [Alternative Ways to Trace video](https://academy.langchain.com/pages/intro-to-langsmith-preview) from the Introduction to LangSmith Course.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/trace-with-langchain.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
This will produce the following trace tree: <img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=52c64fd784522c4b2d75886ae76f8c18" alt="" data-og-width="1334" width="1334" data-og-height="734" height="734" data-path="langsmith/images/trace-tree-python-interop.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=21a424e2326767bb66a6b5a207390bec 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=72f1854193fd30317d1b69d8de433d73 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=34fa74aff75c11172b350d38319bf276 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=4ebfb4252764af54033e62ad088f60b1 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=2d783eecf72ba0680e78a0f122bd4411 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-python-interop.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9d977793e5281e5d255d962224bd70df 2500w" />

## Interoperability between LangChain.JS and LangSmith SDK

### Tracing LangChain objects inside `traceable` (JS only)

Starting with `langchain@0.2.x`, LangChain objects are traced automatically when used inside `@traceable` functions, inheriting the client, tags, metadata and project name of the traceable function.

For older versions of LangChain below `0.2.x`, you will need to manually pass an instance `LangChainTracer` created from the tracing context found in `@traceable`.
```

Example 2 (unknown):
```unknown
### Tracing LangChain child runs via `traceable` / RunTree API (JS only)

<Note>
  We're working on improving the interoperability between `traceable` and LangChain. The following limitations are present when using combining LangChain with `traceable`:

  1. Mutating RunTree obtained from `getCurrentRunTree()` of the RunnableLambda context will result in a no-op.
  2. It's discouraged to traverse the RunTree obtained from RunnableLambda via `getCurrentRunTree()` as it may not contain all the RunTree nodes.
  3. Different child runs may have the same `execution_order` and `child_execution_order` value. Thus in extreme circumstances, some runs may end up in a different order, depending on the `start_time`.
</Note>

In some uses cases, you might want to run `traceable` functions as part of the RunnableSequence or trace child runs of LangChain run imperatively via the `RunTree` API. Starting with LangSmith 0.1.39 and @langchain/core 0.2.18, you can directly invoke `traceable`-wrapped functions within RunnableLambda.
```

Example 3 (unknown):
```unknown
<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=7b117d3aa9b419fe2a314ec6d9cc7c16" alt="Trace Tree" data-og-width="2564" width="2564" data-og-height="1530" height="1530" data-path="langsmith/images/trace-tree-manual-tracing.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=517f8a525908d5241c0d635726bf2da7 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=2772298bff6569c12537d8b31cc90e78 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=4b02aa33df7ef1d18a33bb36c3e2edfe 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e9d4021c62cf3bad95e01c8aa2895d44 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=02ef49a98151ad9fc63c742241542d94 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-tree-manual-tracing.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=765dabfe056ce5f28b1b09ca7eb735d7 2500w" />

Alternatively, you can convert LangChain's [`RunnableConfig`](https://reference.langchain.com/python/langchain_core/runnables/#langchain_core.runnables.RunnableConfig) to a equivalent RunTree object by using `RunTree.fromRunnableConfig` or pass the [`RunnableConfig`](https://reference.langchain.com/python/langchain_core/runnables/#langchain_core.runnables.RunnableConfig) as the first argument of `traceable`-wrapped function.

<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## The agent can now track additional state beyond messages

**URL:** llms-txt#the-agent-can-now-track-additional-state-beyond-messages

**Contents:**
  - Streaming
  - Middleware

result = agent.invoke({
    "messages": [{"role": "user", "content": "I prefer technical explanations"}],
    "user_preferences": {"style": "technical", "verbosity": "detailed"},
})
python  theme={null}
for chunk in agent.stream({
    "messages": [{"role": "user", "content": "Search for AI news and summarize the findings"}]
}, stream_mode="values"):
    # Each chunk contains the full state at that point
    latest_message = chunk["messages"][-1]
    if latest_message.content:
        print(f"Agent: {latest_message.content}")
    elif latest_message.tool_calls:
        print(f"Calling tools: {[tc['name'] for tc in latest_message.tool_calls]}")
```

<Tip>
  For more details on streaming, see [Streaming](/oss/python/langchain/streaming).
</Tip>

[Middleware](/oss/python/langchain/middleware) provides powerful extensibility for customizing agent behavior at different stages of execution. You can use middleware to:

* Process state before the model is called (e.g., message trimming, context injection)
* Modify or validate the model's response (e.g., guardrails, content filtering)
* Handle tool execution errors with custom logic
* Implement dynamic model selection based on state or context
* Add custom logging, monitoring, or analytics

Middleware integrates seamlessly into the agent's execution, allowing you to intercept and modify data flow at key points without changing the core agent logic.

<Tip>
  For comprehensive middleware documentation including decorators like [`@before_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.before_model), [`@after_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.after_model), and [`@wrap_tool_call`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.wrap_tool_call), see [Middleware](/oss/python/langchain/middleware).
</Tip>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langchain/agents.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Note>
  As of `langchain 1.0`, custom state schemas **must** be `TypedDict` types. Pydantic models and dataclasses are no longer supported. See the [v1 migration guide](/oss/python/migrate/langchain-v1#state-type-restrictions) for more details.
</Note>

<Note>
  Defining custom state via middleware is preferred over defining it via [`state_schema`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.AgentMiddleware.state_schema) on [`create_agent`](https://reference.langchain.com/python/langchain/agents/#langchain.agents.create_agent) because it allows you to keep state extensions conceptually scoped to the relevant middleware and tools.

  [`state_schema`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.AgentMiddleware.state_schema) is still supported for backwards compatibility on [`create_agent`](https://reference.langchain.com/python/langchain/agents/#langchain.agents.create_agent).
</Note>

<Tip>
  To learn more about memory, see [Memory](/oss/python/concepts/memory). For information on implementing long-term memory that persists across sessions, see [Long-term memory](/oss/python/langchain/long-term-memory).
</Tip>

### Streaming

We've seen how the agent can be called with `invoke` to get a final response. If the agent executes multiple steps, this may take a while. To show intermediate progress, we can stream back messages as they occur.
```

---

## Applies conventions without prompting

**URL:** llms-txt#applies-conventions-without-prompting

**Contents:**
- Use remote sandboxes

bash  theme={null}
   # Runloop
   export RUNLOOP_API_KEY="your-key"

# Daytona
   export DAYTONA_API_KEY="your-key"

# Modal
   modal setup
   bash  theme={null}
   uvx deepagents-cli --sandbox runloop --sandbox-setup ./setup.sh
   bash  theme={null}
   #!/bin/bash
   set -e

# Clone repository using GitHub token
   git clone https://x-access-token:${GITHUB_TOKEN}@github.com/username/repo.git $HOME/workspace
   cd $HOME/workspace

# Make environment variables persistent
   cat >> ~/.bashrc <<'EOF'
   export GITHUB_TOKEN="${GITHUB_TOKEN}"
   export OPENAI_API_KEY="${OPENAI_API_KEY}"
   cd $HOME/workspace
   EOF

source ~/.bashrc
   ```

Store secrets in a local `.env` file for the setup script to access.

<Warning>
  Sandboxes isolate code execution, but agents remain vulnerable to prompt injection with untrusted inputs. Use human-in-the-loop approval, short-lived secrets, and trusted setup scripts only. Note that sandbox APIs are evolving rapidly, and we expect more providers to support proxies that help mitigate prompt injection and secrets management concerns.
</Warning>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/deepagents/cli.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
## Use remote sandboxes

Execute code in isolated remote environments for safety and flexibility. Remote sandboxes provide the following benefits:

* **Safety**: Protect your local machine from potentially harmful code execution
* **Clean environments**: Use specific dependencies or OS configurations without local setup
* **Parallel execution**: Run multiple agents simultaneously in isolated environments
* **Long-running tasks**: Execute time-intensive operations without blocking your machine
* **Reproducibility**: Ensure consistent execution environments across teams

To use a remote sandbox, follow these steps:

1. Configure your sandbox provider ([Runloop](https://www.runloop.ai/), [Daytona](https://www.daytona.io/), or [Modal](https://modal.com/)):
```

Example 2 (unknown):
```unknown
2. Run the CLI with a sandbox:
```

Example 3 (unknown):
```unknown
The agent runs locally but executes all code operations in the remote sandbox. Optional setup scripts can configure environment variables, clone repositories, and prepare dependencies.

3. (Optional) Create a `setup.sh` file to configure your sandbox environment:
```

---

## LangSmith-managed ClickHouse

**URL:** llms-txt#langsmith-managed-clickhouse

**Contents:**
- Architecture Overview
- Requirements
- Data storage
  - Stored feedback data fields
  - Stored run data fields

Source: https://docs.langchain.com/langsmith/langsmith-managed-clickhouse

<Check>
  Please read the [LangSmith architectural overview](/langsmith/self-hosted) and [guide on connecting to external ClickHouse](/langsmith/self-host-external-clickhouse) before proceeding with this guide.
</Check>

LangSmith uses ClickHouse as the primary storage engine for **traces** and **feedback**. For easier management and scaling, it is recommended to connect a self-hosted LangSmith instance to an external ClickHouse instance. LangSmith-managed ClickHouse is an option that allows you to use a fully managed ClickHouse instance that is monitored and maintained by the LangSmith team.

## Architecture Overview

The architecture of using LangSmith-managed ClickHouse with your self-hosted LangSmith instance is similar to using a fully self-hosted ClickHouse instance, with a few key differences:

* You will need to set up a private network connection between your LangSmith instance and the LangSmith-managed ClickHouse instance. This is to ensure that your data is secure and that you can connect to the ClickHouse instance from your self-hosted LangSmith instance.
* With this option, sensitive information (inputs and outputs) of your traces will be stored in cloud object storage (S3 or GCS) within your cloud instead of ClickHouse to ensure that sensitive information doesn't leave your VPC. For more details on where particular data fields are stored, refer to [Data storage](#data-storage).
* The LangSmith team will monitor your ClickHouse instance and ensure that it is running smoothly. This allows us to track metrics like run-ingestion delay and query performance.

The overall architecture looks like this:

<img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=26fae5c3f413c15302ea0c00bebf8e93" alt="LangSmith managed ClickHouse architecture." data-og-width="2196" width="2196" data-og-height="1755" height="1755" data-path="langsmith/images/managed-clickhouse-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=280&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=b9cb43d51325b0d9858123066c0f8812 280w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=560&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=f21865c150f4047d9cfd0eee690099af 560w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=840&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=3df50b05e66bc3092558e23e321d11fe 840w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=1100&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=821f427c87e452c5d93aec971de3e5c3 1100w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=1650&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=ffd26e217759a683feeacdacde65c047 1650w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-light.png?w=2500&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=75b39fb829a3ed7491f3550ad5323965 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=a3062f45f9c01f05e6917bca3f34735e" alt="LangSmith managed ClickHouse architecture." data-og-width="2196" width="2196" data-og-height="1755" height="1755" data-path="langsmith/images/managed-clickhouse-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=280&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=c2a591803a03df470900d351a3ba59dc 280w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=560&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=80f1fd346d92de102121180ac7995e0f 560w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=840&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=6bb18f947823c721cba47bc275999cc2 840w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=1100&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=0d7313f3682d35e743a82f44465b9af6 1100w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=1650&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=2f96d154dff0885379ce9d0b6a8e40e9 1650w, https://mintcdn.com/langchain-5e9cc07a/JOyLr_spVEW0t2KF/langsmith/images/managed-clickhouse-dark.png?w=2500&fit=max&auto=format&n=JOyLr_spVEW0t2KF&q=85&s=b750629ab6f6ce608695538ff3ad46f5 2500w" />

* **You must use a supported blob storage option.** Read the [blob storage guide](/langsmith/self-host-blob-storage) for more information.
* To use private endpoints, ensure that your VPC is in a ClickHouse Cloud supported [region](https://clickhouse.com/docs/en/cloud/reference/supported-regions). Otherwise, you will need to use a public endpoint we will secure with firewall rules. Your VPC will need to have a NAT gateway to allow us to allowlist your traffic.
* You must have a VPC that can connect to the LangSmith-managed ClickHouse service. You will need to work with our team to set up the necessary networking.
* You must have a LangSmith self-hosted instance running. You can use our managed ClickHouse service with both [Kubernetes](/langsmith/kubernetes) and [Docker](/langsmith/docker) installations.

ClickHouse stores **runs** and **feedback** data, specifically:

* All feedback data fields.
* Some run data fields.

For a list of fields, refer to [Stored run data fields](#stored-run-data-fields) and [Stored feedback data fields](#stored-feedback-data-fields).

LangChain defines sensitive application data as `inputs`, `outputs`, `errors`, `manifests`, `extras`, and `events` of a run, since these fields may contain LLM prompts and completions. With LangSmith-managed ClickHouse, these sensitive fields are stored in cloud object storage (S3 or GCS) within your cloud, while the rest of the run data is stored in ClickHouse, ensuring sensitive information never leaves your VPC.

### Stored feedback data fields

<Note>
  Because all feedback data is stored in ClickHouse, do not send sensitive information in feedback (scores and annotations/comments) or in any other run fields that are mentioned in [Stored run data fields](#stored-run-data-fields).
</Note>

Using a LangSmith-managed ClickHouse setup, **all feedback data fields are stored in ClickHouse**:

| Field Name                | Type     | Description                                                                                            |
| ------------------------- | -------- | ------------------------------------------------------------------------------------------------------ |
| id                        | UUID     | Unique identifier for the record itself                                                                |
| created\_at               | datetime | Timestamp when the record was created                                                                  |
| modified\_at              | datetime | Timestamp when the record was last modified                                                            |
| session\_id               | UUID     | Unique identifier for the experiment or tracing project the run was a part of                          |
| run\_id                   | UUID     | Unique identifier for a specific run within a session                                                  |
| key                       | string   | A key describing the criteria of the feedback, eg "correctness"                                        |
| score                     | number   | Numerical score associated with the feedback key                                                       |
| value                     | string   | Reserved for storing a value associated with the score. Useful for categorical feedback.               |
| comment                   | string   | Any comment or annotation associated with the record. This can be a justification for the score given. |
| correction                | object   | Reserved for storing correction details, if any                                                        |
| feedback\_source          | object   | Object containing information about the feedback source                                                |
| feedback\_source.type     | string   | The type of source where the feedback originated, eg "api", "app", "evaluator"                         |
| feedback\_source.metadata | object   | Reserved for additional metadata, currently                                                            |
| feedback\_source.user\_id | UUID     | Unique identifier for the user providing feedback                                                      |

This [reference doc](/langsmith/feedback-data-format) explains the stored feedback format, which is the LangSmith's way of representing evaluation scores and annotations on runs.

### Stored run data fields

Run data fields are split between the managed ClickHouse database and your cloud object storage (e.g., S3 or GCS).

<Note>
  For run fields stored in object storage, only a reference or pointer is kept in ClickHouse. For example, `inputs` and `outputs` content are offloaded to S3/GCS, with the ClickHouse record storing corresponding S3 URLs in the `inputs_s3_urls` and `outputs_s3_urls` fields.
</Note>

The table details each run field and where it is stored:

| Field                          | Storage Location   |
| ------------------------------ | ------------------ |
| `id`                           | ClickHouse         |
| `name`                         | ClickHouse         |
| `inputs`                       | **Object Storage** |
| `run_type`                     | ClickHouse         |
| `start_time`                   | ClickHouse         |
| `end_time`                     | ClickHouse         |
| `extra`                        | **Object Storage** |
| `error`                        | **Object Storage** |
| `outputs`                      | **Object Storage** |
| `events`                       | **Object Storage** |
| `tags`                         | ClickHouse         |
| `trace_id`                     | ClickHouse         |
| `dotted_order`                 | ClickHouse         |
| `status`                       | ClickHouse         |
| `child_run_ids`                | ClickHouse         |
| `direct_child_run_ids`         | ClickHouse         |
| `parent_run_ids`               | ClickHouse         |
| `feedback_stats`               | ClickHouse         |
| `reference_example_id`         | ClickHouse         |
| `total_tokens`                 | ClickHouse         |
| `prompt_tokens`                | ClickHouse         |
| `completion_tokens`            | ClickHouse         |
| `total_cost`                   | ClickHouse         |
| `prompt_cost`                  | ClickHouse         |
| `completion_cost`              | ClickHouse         |
| `first_token_time`             | ClickHouse         |
| `session_id`                   | ClickHouse         |
| `in_dataset`                   | ClickHouse         |
| `parent_run_id`                | ClickHouse         |
| `execution_order` (deprecated) | ClickHouse         |
| `serialized`                   | ClickHouse         |
| `manifest_id` (deprecated)     | ClickHouse         |
| `manifest_s3_id`               | ClickHouse         |
| `inputs_s3_urls`               | ClickHouse         |
| `outputs_s3_urls`              | ClickHouse         |
| `price_model_id`               | ClickHouse         |
| `app_path`                     | ClickHouse         |
| `last_queued_at`               | ClickHouse         |
| `share_token`                  | ClickHouse         |

This [reference doc](/langsmith/run-data-format) explains the format of stored runs (spans), which are the building blocks of traces.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/langsmith-managed-clickhouse.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Trace with CrewAI

**URL:** llms-txt#trace-with-crewai

**Contents:**
- Installation
- Setup
  - 1. Configure environment variables
  - 2. Configure OpenTelemetry integration

Source: https://docs.langchain.com/langsmith/trace-with-crewai

LangSmith can capture traces generated by [CrewAI](https://github.com/crewAIInc/crewAI) using OpenInference's CrewAI instrumentation. This guide shows you how to automatically capture traces from your CrewAI multi-agent workflows and send them to LangSmith for monitoring and analysis.

Install the required packages using your preferred package manager:

### 1. Configure environment variables

Set your API keys and project name:

<CodeGroup>
  
</CodeGroup>

### 2. Configure OpenTelemetry integration

In your CrewAI application, import and configure the LangSmith OpenTelemetry integration along with the CrewAI and OpenAI instrumentors:

```python  theme={null}
from langsmith.integrations.otel import OtelSpanProcessor
from opentelemetry import trace
from opentelemetry.sdk.trace import TracerProvider
from openinference.instrumentation.crewai import CrewAIInstrumentor
from openinference.instrumentation.openai import OpenAIInstrumentor

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

## Setup

### 1. Configure environment variables

Set your API keys and project name:

<CodeGroup>
```

Example 3 (unknown):
```unknown
</CodeGroup>

### 2. Configure OpenTelemetry integration

In your CrewAI application, import and configure the LangSmith OpenTelemetry integration along with the CrewAI and OpenAI instrumentors:
```

---

## artist vectorstore for "prince" we'll get back the value "Prince", which we can then

**URL:** llms-txt#artist-vectorstore-for-"prince"-we'll-get-back-the-value-"prince",-which-we-can-then

---

## The stream_mode is set to "messages" to stream LLM tokens

**URL:** llms-txt#the-stream_mode-is-set-to-"messages"-to-stream-llm-tokens

---

## Agent Builder

**URL:** llms-txt#agent-builder

**Contents:**
- Memory and updates
- Triggers
- Sub-agents
- Human in the loop
  - Enabling interrupts
  - Actions on interrupts

Source: https://docs.langchain.com/langsmith/agent-builder

<Callout icon="wand-magic-sparkles" color="#2563EB" iconType="regular">
  Agent Builder is in Beta.
</Callout>

Agent Builder lets you turn natural-language ideas into production agents. It's powered by [deep-agents](https://github.com/langchain-ai/deepagents), and is not <Tooltip tip="Predetermined code paths that are designed to operate in a certain order.">workflow based</Tooltip>.

## Memory and updates

Agent Builder includes persistent agent memory and supports self-updates. This lets agents adapt over time and refine how they work without manual edits.

* Persistent memory: Agents retain relevant information across runs to inform future decisions.
* What can be updated: Tools (add, remove, or reconfigure), and instructions/system prompts.
* Agents cannot modify their name, description, and/or triggers attached.

Triggers define when your agent should start running. You can connect your agent to external tools or time-based schedules, letting it respond automatically to messages, emails, or recurring events.

The following examples show some of the apps you can use to trigger your agent:

<CardGroup cols={3}>
  <Card title="Slack" icon="slack">
    Activate your agent when messages are received in specific Slack channels.
  </Card>

<Card title="Gmail" icon="envelope">
    Trigger your agent when emails are received.
  </Card>

<Card title="Cron schedules" icon="clock">
    Run your agent on a time-based schedule for recurring tasks.
  </Card>
</CardGroup>

Agent Builder lets you create sub-agents within a main agent. Sub-agents are smaller, specialized agents that handle specific parts of a larger task. They can operate with their own tools, permissions, or goals while coordinating with the main agent.

Using sub-agents makes it easier to build complex systems by dividing work into focused, reusable components. This modular approach helps keep your agents organized, scalable, and easier to maintain.

Below are a few ways sub-agents can be used in your projects:

* Handle distinct parts of a broader workflow (for example, data retrieval, summarization, or formatting).
* Use different tools or context windows for specialized tasks.
* Run independently but report results back to the main agent.

Human-in-the-loop functionality allows you to review and approve agent actions before they execute, giving you control over critical decisions.

### Enabling interrupts

<Steps>
  <Step title="Select a tool">
    When configuring your agent in Agent Builder, select the tool you want to add human oversight to.
  </Step>

<Step title="Enable interrupts">
    Look for the interrupt option when selecting the tool and toggle it on.
  </Step>

<Step title="Agent pauses for approval">
    The agent will pause and wait for human approval before executing that tool.
  </Step>
</Steps>

### Actions on interrupts

When your agent reaches an interrupt point, you can take one of three actions:

<CardGroup cols={3}>
  <Card title="Accept" icon="check">
    Approve the agent's proposed action and allow it to proceed as planned.
  </Card>

<Card title="Edit" icon="pen-to-square">
    Modify the agent's message or parameters before allowing it to continue.
  </Card>

<Card title="Send feedback" icon="comment">
    Provide feedback to the agent.
  </Card>
</CardGroup>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/agent-builder.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## View trace counts across your organization

**URL:** llms-txt#view-trace-counts-across-your-organization

**Contents:**
- Programmatically fetch trace counts
  - Method 1: Use the LangSmith REST API
  - Method 2: Use PostgreSQL support queries

Source: https://docs.langchain.com/langsmith/self-host-organization-charts

<Note>
  This feature is available on Helm chart versions 0.9.5 and later.
</Note>

LangSmith automatically generates and syncs organization usage charts for self-hosted installations.

These charts are available under `Settings > Usage and billing > Usage graph`:

* Usage by Workspace: this counts traces (root runs) by workspace
* Organization Usage: this counts all traces (root runs) for the organization

The charts are refreshed to include any new workspaces every 5 minutes. Note that the charts are not editable.

## Programmatically fetch trace counts

You can retrieve trace counts programmatically using two different methods:

### Method 1: Use the LangSmith REST API

If your self-hosted installation uses an online key, you can use the [LangSmith REST API](https://api.smith.langchain.com/redoc?_gl=1*w68t81*_gcl_au*MTgyNTQ5MDUxNy4xNzU2NzI3MDky*_ga*MTU3NDY5MzQyNC4xNzQyOTMyMTQ2*_ga_47WX3HKKY2*czE3NTgyMDAxMDAkbzM0MSRnMCR0MTc1ODIwMDEwMCRqNjAkbDAkaDA.#tag/orgs/operation/get_org_usage_api_v1_orgs_current_billing_usage_get) to fetch organization usage data.

### Method 2: Use PostgreSQL support queries

For installations using offline keys or when you need more detailed export capabilities, you can run support queries directly against the PostgreSQL database. All available scripts are in the [support queries repository](https://github.com/langchain-ai/helm/tree/main/charts/langsmith/scripts/support_queries/postgres).

For more detailed information about running support queries, see the [Run support queries against PostgreSQL](/langsmith/script-running-pg-support-queries) guide.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/self-host-organization-charts.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
### Method 2: Use PostgreSQL support queries

For installations using offline keys or when you need more detailed export capabilities, you can run support queries directly against the PostgreSQL database. All available scripts are in the [support queries repository](https://github.com/langchain-ai/helm/tree/main/charts/langsmith/scripts/support_queries/postgres).
```

---

## Try to access user 1's thread as user 2

**URL:** llms-txt#try-to-access-user-1's-thread-as-user-2

**Contents:**
- Next steps

user2_token = await login(email2, password)
user2_client = get_client(
    url="http://localhost:2024", headers={"Authorization": f"Bearer {user2_token}"}
)

try:
    await user2_client.threads.get(thread["thread_id"])
    print("❌ User 2 shouldn't see User 1's thread!")
except Exception as e:
    print("✅ User 2 blocked from User 1's thread:", e)
shell  theme={null}
✅ User 1 created thread: d6af3754-95df-4176-aa10-dbd8dca40f1a
✅ Unauthenticated access blocked: Client error '403 Forbidden' for url 'http://localhost:2024/threads'
✅ User 2 blocked from User 1's thread: Client error '404 Not Found' for url 'http://localhost:2024/threads/d6af3754-95df-4176-aa10-dbd8dca40f1a'
```

Your authentication and authorization are working together:

1. Users must log in to access the bot
2. Each user can only see their own threads

All users are managed by the Supabase auth provider, so you don't need to implement any additional user management logic.

You've successfully built a production-ready authentication system for your LangGraph application! Let's review what you've accomplished:

1. Set up an authentication provider (Supabase in this case)
2. Added real user accounts with email/password authentication
3. Integrated JWT token validation into your Agent Server
4. Implemented proper authorization to ensure users can only access their own data
5. Created a foundation that's ready to handle your next authentication challenge 🚀

Now that you have production authentication, consider:

1. Building a web UI with your preferred framework (see the [Custom Auth](https://github.com/langchain-ai/custom-auth) template for an example)
2. Learn more about the other aspects of authentication and authorization in the [conceptual guide on authentication](/langsmith/auth).
3. Customize your handlers and setup further after reading the [reference docs](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.auth.Auth).

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/add-auth-server.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
The output should look like this:
```

---

## How to run an evaluation asynchronously

**URL:** llms-txt#how-to-run-an-evaluation-asynchronously

**Contents:**
- Use `aevaluate()`

Source: https://docs.langchain.com/langsmith/evaluation-async

<Info>
  [Evaluations](/langsmith/evaluation-concepts#applying-evaluations) | [Evaluators](/langsmith/evaluation-concepts#evaluators) | [Datasets](/langsmith/evaluation-concepts#datasets) | [Experiments](/langsmith/evaluation-concepts#experiments)
</Info>

We can run evaluations asynchronously via the SDK using [aevaluate()](https://docs.smith.langchain.com/reference/python/evaluation/langsmith.evaluation._arunner.aevaluate), which accepts all of the same arguments as [evaluate()](https://docs.smith.langchain.com/reference/python/evaluation/langsmith.evaluation._runner.evaluate) but expects the application function to be asynchronous. You can learn more about how to use the `evaluate()` function [here](/langsmith/evaluate-llm-application).

<Info>
  This guide is only relevant when using the Python SDK. In JS/TS the `evaluate()` function is already async. You can see how to use it [here](/langsmith/evaluate-llm-application).
</Info>

Requires `langsmith>=0.3.13`

```python  theme={null}
from langsmith import wrappers, Client
from openai import AsyncOpenAI

---

## Define your agents

**URL:** llms-txt#define-your-agents

market_researcher = Agent(
    role="Senior Market Researcher",
    goal="Analyze market trends and consumer behavior in the tech industry",
    backstory="""You are an experienced market researcher with 10+ years of experience
    analyzing technology markets. You excel at identifying emerging trends and
    understanding consumer needs.""",
    verbose=True,
    allow_delegation=False,
)

content_strategist = Agent(
    role="Content Marketing Strategist",
    goal="Create compelling marketing content based on research insights",
    backstory="""You are a creative content strategist who transforms complex market
    research into engaging marketing materials. You understand how to communicate
    technical concepts to different audiences.""",
    verbose=True,
    allow_delegation=False,
)

data_analyst = Agent(
    role="Data Analyst",
    goal="Provide statistical analysis and data-driven insights",
    backstory="""You are a skilled data analyst who can interpret complex datasets
    and provide actionable insights. You excel at finding patterns and trends
    in data that others might miss.""",
    verbose=True,
    allow_delegation=False,
)

---

## LLM-as-judge instructions

**URL:** llms-txt#llm-as-judge-instructions

grader_instructions = """You are a teacher grading a quiz.

You will be given a QUESTION, the GROUND TRUTH (correct) RESPONSE, and the STUDENT RESPONSE.

Here is the grade criteria to follow:
(1) Grade the student responses based ONLY on their factual accuracy relative to the ground truth answer.
(2) Ensure that the student response does not contain any conflicting statements.
(3) It is OK if the student response contains more information than the ground truth response, as long as it is factually accurate relative to the  ground truth response.

Correctness:
True means that the student's response meets all of the criteria.
False means that the student's response does not meet all of the criteria.

Explain your reasoning in a step-by-step manner to ensure your reasoning and conclusion are correct."""

---

## Include multimodal content in a prompt

**URL:** llms-txt#include-multimodal-content-in-a-prompt

**Contents:**
- Inline content
- Template variables
- Populate the template variable
- Run an evaluation

Source: https://docs.langchain.com/langsmith/multimodal-content

Some applications are based around multimodal content, like a chatbot that can answer questions about a PDF or image. In these cases, you'll want to include multimodal content in your prompt and test the model's ability to answer questions about the content.

The LangSmith Playground supports two methods for incorporating multimodal content in your prompts:

1. Inline content: Embed static files (images, PDFs, audio) directly in your prompt. This is ideal when you want to consistently include the same multimodal content across all uses of the prompt. For example, you might include a reference image that helps ground the model's responses.

2. Template variables: Create dynamic placeholders for attachments that can be populated with different content each time. This approach offers more flexibility, allowing you to:

* Test how the model handles different inputs
   * Create reusable prompts that work with varying content

<Note>
  Not all models support multimodal content. Before using multimodal features in the playground, make sure your selected model supports the file types you want to use.
</Note>

Click the file icon in the message where you want to add multimodal content. Under the `Upload content` tab, you can upload a file and include it inline in the prompt.

<img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=b93d2a6731d26d3ff58a3d0d6d909159" alt="" data-og-width="410" width="410" data-og-height="339" height="339" data-path="langsmith/images/upload-inline-multimodal-content.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=ae329136b8de8d5f4b12ecab49651063 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=f1644a04d5a33e803a15bc9794ecb528 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=275ffe46010c6b24012ed049a17a59fb 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=9591d26a3b27c0462f7674f84c2a525c 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=f4439dc91e005750232b40efbb19954d 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/upload-inline-multimodal-content.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=1c429f8f78846a14e0c9a379b9a24355 2500w" />

## Template variables

Click the file icon in the message where you want to add multimodal content. Under the `Template variables` tab, you can create a template variable for a specific attachment type. Currently, only images, PDFs, and audio files (.wav, .mp3) are supported.

<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e69596dd9fe7d16252c7054bf9efcdf0" alt="" data-og-width="391" width="391" data-og-height="303" height="303" data-path="langsmith/images/template-variable-multimodal-content.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=1efb9ed1c9a4a64be7174b90ffbfe664 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=1375989ffa599f506d308441e46907f9 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=f50c62b520314c18e433f77952ff79a2 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e38e8283352a13b54e96a381a2449396 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=331ff1a4664debd8d7b08a6ad645d9c6 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/template-variable-multimodal-content.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=ffa740fa2a3f4f52173cd073843d697f 2500w" />

## Populate the template variable

Once you've added a template variable, you can provide content for it using the panel on the right side of the screen. Simply click the `+` button to upload or select content that will be used to populate the template variable.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=5983e91ca9f596918c9068f8d7450d8d" alt="" data-og-width="1466" width="1466" data-og-height="482" height="482" data-path="langsmith/images/manual-prompt-multimodal.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ccb36221eb97f54196de13df4f9749e7 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=6b4554ac3156e805655eba6afd2ce771 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=a3e85646401f9aa31e1d79257344c158 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=9727ce9dec69152f6e49e3d8ff575300 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=f73957416f51c78a0e29c449f64ff1e2 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/manual-prompt-multimodal.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ab8421f512b312b56ac515b970d337f4 2500w" />

After testing out your prompt manually, you can [run an evaluation](/langsmith/evaluate-with-attachments?mode=ui) to see how the prompt performs over a golden dataset of examples.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/multimodal-content.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Custom middleware

**URL:** llms-txt#custom-middleware

**Contents:**
- Hooks
  - Node-style hooks
  - Wrap-style hooks
- Create middleware
  - Decorator-based middleware
  - Class-based middleware
- Custom state schema
- Execution order
- Agent jumps
- Best practices

Source: https://docs.langchain.com/oss/python/langchain/middleware/custom

Build custom middleware by implementing hooks that run at specific points in the agent execution flow.

Middleware provides two styles of hooks to intercept agent execution:

<CardGroup cols={2}>
  <Card title="Node-style hooks" icon="share-nodes" href="#node-style-hooks">
    Run sequentially at specific execution points.
  </Card>

<Card title="Wrap-style hooks" icon="container-storage" href="#wrap-style-hooks">
    Run around each model or tool call.
  </Card>
</CardGroup>

Run sequentially at specific execution points. Use for logging, validation, and state updates.

* `before_agent` - Before agent starts (once per invocation)
* `before_model` - Before each model call
* `after_model` - After each model response
* `after_agent` - After agent completes (once per invocation)

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

Intercept execution and control when the handler is called. Use for retries, caching, and transformation.

You decide if the handler is called zero times (short-circuit), once (normal flow), or multiple times (retry logic).

* `wrap_model_call` - Around each model call
* `wrap_tool_call` - Around each tool call

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

You can create middleware in two ways:

<CardGroup cols={2}>
  <Card title="Decorator-based middleware" icon="at" href="#decorator-based-middleware">
    Quick and simple for single-hook middleware. Use decorators to wrap individual functions.
  </Card>

<Card title="Class-based middleware" icon="brackets-curly" href="#class-based-middleware">
    More powerful for complex middleware with multiple hooks or configuration.
  </Card>
</CardGroup>

### Decorator-based middleware

Quick and simple for single-hook middleware. Use decorators to wrap individual functions.

**Available decorators:**

* [`@before_agent`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.before_agent) - Runs before agent starts (once per invocation)
* [`@before_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.before_model) - Runs before each model call
* [`@after_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.after_model) - Runs after each model response
* [`@after_agent`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.after_agent) - Runs after agent completes (once per invocation)

* [`@wrap_model_call`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.wrap_model_call) - Wraps each model call with custom logic
* [`@wrap_tool_call`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.wrap_tool_call) - Wraps each tool call with custom logic

* [`@dynamic_prompt`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.dynamic_prompt) - Generates dynamic system prompts

**When to use decorators:**

* Single hook needed
* No complex configuration
* Quick prototyping

### Class-based middleware

More powerful for complex middleware with multiple hooks or configuration. Use classes when you need to define both sync and async implementations for the same hook, or when you want to combine multiple hooks in a single middleware.

**When to use classes:**

* Defining both sync and async implementations for the same hook
* Multiple hooks needed in a single middleware
* Complex configuration required (e.g., configurable thresholds, custom models)
* Reuse across projects with init-time configuration

## Custom state schema

Middleware can extend the agent's state with custom properties.

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

When using multiple middleware, understand how they execute:

<Accordion title="Execution flow">
  **Before hooks run in order:**

1. `middleware1.before_agent()`
  2. `middleware2.before_agent()`
  3. `middleware3.before_agent()`

**Agent loop starts**

4. `middleware1.before_model()`
  5. `middleware2.before_model()`
  6. `middleware3.before_model()`

**Wrap hooks nest like function calls:**

7. `middleware1.wrap_model_call()` → `middleware2.wrap_model_call()` → `middleware3.wrap_model_call()` → model

**After hooks run in reverse order:**

8. `middleware3.after_model()`
  9. `middleware2.after_model()`
  10. `middleware1.after_model()`

11. `middleware3.after_agent()`
  12. `middleware2.after_agent()`
  13. `middleware1.after_agent()`
</Accordion>

* `before_*` hooks: First to last
* `after_*` hooks: Last to first (reverse)
* `wrap_*` hooks: Nested (first middleware wraps all others)

To exit early from middleware, return a dictionary with `jump_to`:

**Available jump targets:**

* `'end'`: Jump to the end of the agent execution (or the first `after_agent` hook)
* `'tools'`: Jump to the tools node
* `'model'`: Jump to the model node (or the first `before_model` hook)

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

1. Keep middleware focused - each should do one thing well
2. Handle errors gracefully - don't let middleware errors crash the agent
3. **Use appropriate hook types**:
   * Node-style for sequential logic (logging, validation)
   * Wrap-style for control flow (retry, fallback, caching)
4. Clearly document any custom state properties
5. Unit test middleware independently before integrating
6. Consider execution order - place critical middleware first in the list
7. Use built-in middleware when possible

### Dynamic model selection

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

### Tool call monitoring

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

### Dynamically selecting tools

Select relevant tools at runtime to improve performance and accuracy.

* **Shorter prompts** - Reduce complexity by exposing only relevant tools
* **Better accuracy** - Models choose correctly from fewer options
* **Permission control** - Dynamically filter tools based on user access

<Tabs>
  <Tab title="Decorator">
    
  </Tab>

<Tab title="Class">
    
  </Tab>
</Tabs>

## Additional resources

* [Middleware API reference](https://reference.langchain.com/python/langchain/middleware/)
* [Built-in middleware](/oss/python/langchain/middleware/built-in)
* [Testing agents](/oss/python/langchain/test)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langchain/middleware/custom.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="Class">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

### Wrap-style hooks

Intercept execution and control when the handler is called. Use for retries, caching, and transformation.

You decide if the handler is called zero times (short-circuit), once (normal flow), or multiple times (retry logic).

**Available hooks:**

* `wrap_model_call` - Around each model call
* `wrap_tool_call` - Around each tool call

**Example:**

<Tabs>
  <Tab title="Decorator">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="Class">
```

Example 4 (unknown):
```unknown
</Tab>
</Tabs>

## Create middleware

You can create middleware in two ways:

<CardGroup cols={2}>
  <Card title="Decorator-based middleware" icon="at" href="#decorator-based-middleware">
    Quick and simple for single-hook middleware. Use decorators to wrap individual functions.
  </Card>

  <Card title="Class-based middleware" icon="brackets-curly" href="#class-based-middleware">
    More powerful for complex middleware with multiple hooks or configuration.
  </Card>
</CardGroup>

### Decorator-based middleware

Quick and simple for single-hook middleware. Use decorators to wrap individual functions.

**Available decorators:**

**Node-style:**

* [`@before_agent`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.before_agent) - Runs before agent starts (once per invocation)
* [`@before_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.before_model) - Runs before each model call
* [`@after_model`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.after_model) - Runs after each model response
* [`@after_agent`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.after_agent) - Runs after agent completes (once per invocation)

**Wrap-style:**

* [`@wrap_model_call`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.wrap_model_call) - Wraps each model call with custom logic
* [`@wrap_tool_call`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.wrap_tool_call) - Wraps each tool call with custom logic

**Convenience:**

* [`@dynamic_prompt`](https://reference.langchain.com/python/langchain/middleware/#langchain.agents.middleware.dynamic_prompt) - Generates dynamic system prompts

**Example:**
```

---

## Section 2: Full Observability Stack

**URL:** llms-txt#section-2:-full-observability-stack

**Contents:**
- Prerequisites
  - 1. Compute Resources
  - 2. Cert-Manager
  - 3. OpenTelemetry Operator
- Installation
- Post-Installation
  - Enable Logs and Traces in LangSmith
- Grafana Usage

<Warning>
  **This is not a production observability stack. Use this to gain quick insight into logs, metrics and traces for your deployment. This is only made to handle a few dozen GB of data per day.**
</Warning>

This section will show you how to deploy the end-to-end observability stack for LangSmith, using the [Helm Chart](https://github.com/langchain-ai/helm/tree/main/charts/langsmith-observability).

This chart is built around the open-source LGTM Stack from Grafana. It consists of:

* [Loki](https://grafana.com/docs/loki/latest/) for logs.
* [Mimir](https://grafana.com/docs/mimir/latest/) for metrics + alerting.
* [Tempo](https://grafana.com/docs/tempo/latest/) for traces.
* [Grafana](https://grafana.com/docs/grafana/latest/) for monitoring UI.

As well as [OpenTelemetry Collectors](https://opentelemetry.io/docs/collector/) for gathering the telemetry data.

### 1. Compute Resources

The resource requests and limits for each part of the stack can be modified in the helm chart. Here are the current allocations (request/limit):

* Loki: `2vCPU/3vCPU + 2Gi/4Gi`
* Mimir: `1vCPU/2vCPU + 2Gi/4Gi`
* Tempo: `1vCPU/2vCPU + 4Gi/6Gi`

Make sure you have those resources allocated before bringing up the helm chart, or modify the resource values in your helm configuration file.

The helm chart uses the OpenTelemetry Operator to provision collectors. The operator require that you have [cert-manager](https://cert-manager.io/docs/installation/) installed in your Kubernetes cluster.

If you do not have it installed, you can run the following commands:

### 3. OpenTelemetry Operator

Use the following to install the OpenTelemetry Operator:

The following instructions will bring up OTel collectors, the LGTM stack, Grafana and Prometheus exporters.

1. Create a local file called `langsmith_obs_config.yaml`
2. Copy over the values from this [file](https://github.com/langchain-ai/helm/blob/main/charts/langsmith-observability/examples/e2e-stack.yaml) into `langsmith_obs_config.yaml`, making sure to modify the values to match your LangSmith deployment.
3. Find the latest version of the chart by running `helm search repo langchain/langsmith-observability --versions`.
4. Grab the latest version number, and run `helm install langsmith-observability langchain/langsmith-observability --values langsmith_obs_config.yaml --version <version> -n <namespace> --wait --debug`

<Note>
  **You can selectively collect logs, metrics or traces by modifying the boolean values under `otelCollector` in your config file. You can also selectively bring up each respective piece of the backend (Loki, Mimir, Tempo).**
</Note>

You should see the following if the install went through:

And if you run `kubectl get pods -n langsmith-observability`, you should see:

### Enable Logs and Traces in LangSmith

Once you have installed the observability helm chart, you need to set the following values in your *LangSmith* helm configuration file to enable collection of logs and traces.

<Info>
  1. To get `${LANGSMITH_OTEL_CRD_NAME}`, you can run `kubectl get opentelemetrycollectors -n ${LANGSMITH_OBS_NAMESPACE}` and select the name of the one with MODE = `sidecar`
  2. To get `${GATEWAY_COLLECTOR_SERVICE_NAME}` name, run `kubectl get services -n ${LANGSMITH_OBS_NAMESPACE}` and select the one with Ports 4317/4318 AND a ClusterIP set. It should be something like `langsmith-observability-collector-gateway-collector`
</Info>

Now run `helm upgrade langsmith langchain/langsmith --values langsmith_config.yaml -n <langsmith-namespace> --wait --debug`

Once upgraded, if you run `kubectl get pods -n <langsmith-namespace>` you should see the following (note the 2/2 for sidecar collectors):

Once everything is installed, do the following: to get your Grafana password:

Then port-forward into the `langsmith-observability-grafana` container at port 3000, and open your browser as `localhost:3000`. Use the username `admin` and the password from the secret above to log into Grafana.

Once in Grafana, you can use the UI to monitor logs, metrics and traces. Grafana also comes pre-packaged with sets of dashboards for monitoring the main components of your deployment.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ee47243826737bab23944e01536dec71" alt="LangSmith Grafana Dashboards" data-og-width="1715" width="1715" data-og-height="1073" height="1073" data-path="langsmith/images/langsmith-grafana-dashboards.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=11e0d71897053d012e929ca49533d6dd 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=0e674be629c1c1e795e1b6e686ca28e2 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=fb3bcdc4fa39e82fe9f3370834c7f7fa 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=80c401f8794ac0671207e1a260aac25b 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=3f5baa041ab9e5c39b7d8a62e2bfe1e5 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/langsmith-grafana-dashboards.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=7620f91021593db1d87c92fc43d8fe2b 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/observability-stack.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
### 3. OpenTelemetry Operator

Use the following to install the OpenTelemetry Operator:
```

Example 2 (unknown):
```unknown
## Installation

The following instructions will bring up OTel collectors, the LGTM stack, Grafana and Prometheus exporters.

1. Create a local file called `langsmith_obs_config.yaml`
2. Copy over the values from this [file](https://github.com/langchain-ai/helm/blob/main/charts/langsmith-observability/examples/e2e-stack.yaml) into `langsmith_obs_config.yaml`, making sure to modify the values to match your LangSmith deployment.
3. Find the latest version of the chart by running `helm search repo langchain/langsmith-observability --versions`.
4. Grab the latest version number, and run `helm install langsmith-observability langchain/langsmith-observability --values langsmith_obs_config.yaml --version <version> -n <namespace> --wait --debug`

<Note>
  **You can selectively collect logs, metrics or traces by modifying the boolean values under `otelCollector` in your config file. You can also selectively bring up each respective piece of the backend (Loki, Mimir, Tempo).**
</Note>

You should see the following if the install went through:
```

Example 3 (unknown):
```unknown
And if you run `kubectl get pods -n langsmith-observability`, you should see:
```

Example 4 (unknown):
```unknown
## Post-Installation

### Enable Logs and Traces in LangSmith

Once you have installed the observability helm chart, you need to set the following values in your *LangSmith* helm configuration file to enable collection of logs and traces.
```

---

## ... database connection and query code

**URL:** llms-txt#...-database-connection-and-query-code

**Contents:**
  - Define the customer support agent

[(1, 'AC/DC'), (2, 'Accept'), (3, 'Aerosmith'), (4, 'Alanis Morissette'), (5, 'Alice In Chains'), (6, 'Antônio Carlos Jobim'), (7, 'Apocalyptica'), (8, 'Audioslave'), (9, 'BackBeat'), (10, 'Billy Cobham')]
python  theme={null}
import sqlite3

def _refund(invoice_id: int | None, invoice_line_ids: list[int] | None, mock: bool = False) -> float:
    ...

def _lookup( ...
`python  theme={null}
from typing import Literal
import json

from langchain.chat_models import init_chat_model
from langchain_core.runnables import RunnableConfig
from langgraph.graph import END, StateGraph
from langgraph.graph.message import AnyMessage, add_messages
from langgraph.types import Command, interrupt
from tabulate import tabulate
from typing_extensions import Annotated, TypedDict

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
And here's the database schema (image from [https://github.com/lerocha/chinook-database](https://github.com/lerocha/chinook-database)):

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=5da2a8dcca68f02dfcec11f9c472d341" alt="Chinook DB" data-og-width="1672" width="1672" data-og-height="1132" height="1132" data-path="langsmith/images/chinook-diagram.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=ea7b3a27e9780b556aa90f6914dcef30 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=d9cf3ddad46562213014ffb1a77b1e45 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=2c9e1e70e9be2cf07111b2211e1ef9b7 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=970f7f48c80222219b493211331ee22f 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=3188acb57c4abc0156f8687fa9e229d8 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/chinook-diagram.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=86b9655b9fd1bc38fcf9e054b11833df 2500w" />

### Define the customer support agent

We'll create a [LangGraph](https://langchain-ai.github.io/langgraph/) agent with limited access to our database. For demo purposes, our agent will support two basic types of requests:

* Lookup: The customer can look up song titles, artist names, and albums based on other identifying information. For example: "What songs do you have by Jimi Hendrix?"
* Refund: The customer can request a refund on their past purchases. For example: "My name is Claude Shannon and I'd like a refund on a purchase I made last week, could you help me?"

For simplicity in this demo, we'll implement refunds by deleting the corresponding database records. We'll skip implementing user authentication and other production security measures.

The agent's logic will be structured as two separate subgraphs (one for lookups and one for refunds), with a parent graph that routes requests to the appropriate subgraph.

#### Refund agent

Let's build the refund processing agent. This agent needs to:

1. Find the customer's purchase records in the database
2. Delete the relevant Invoice and InvoiceLine records to process the refund

We'll create two SQL helper functions:

1. A function to execute the refund by deleting records
2. A function to look up a customer's purchase history

To make testing easier, we'll add a "mock" mode to these functions. When mock mode is enabled, the functions will simulate database operations without actually modifying any data.
```

Example 3 (unknown):
```unknown
Now let's define our graph. We'll use a simple architecture with three main paths:

1. Extract customer and purchase information from the conversation

2. Route the request to one of three paths:

   * Refund path: If we have sufficient purchase details (Invoice ID or Invoice Line IDs) to process a refund
   * Lookup path: If we have enough customer information (name and phone) to search their purchase history
   * Response path: If we need more information, respond to the user requesting the specific details needed

The graph's state will track:

* The conversation history (messages between user and agent)
* All customer and purchase information extracted from the conversation
* The next message to send to the user (followup text)
```

---

## Call the graph: here we call it to generate a list of jokes

**URL:** llms-txt#call-the-graph:-here-we-call-it-to-generate-a-list-of-jokes

**Contents:**
- Create and control loops

for step in graph.stream({"topic": "animals"}):
    print(step)

{'generate_topics': {'subjects': ['lions', 'elephants', 'penguins']}}
{'generate_joke': {'jokes': ["Why don't lions like fast food? Because they can't catch it!"]}}
{'generate_joke': {'jokes': ["Why don't elephants use computers? They're afraid of the mouse!"]}}
{'generate_joke': {'jokes': ['Why don't penguins like talking to strangers at parties? Because they find it hard to break the ice.']}}
{'best_joke': {'best_selected_joke': 'penguins'}}
python  theme={null}
builder = StateGraph(State)
builder.add_node(a)
builder.add_node(b)

def route(state: State) -> Literal["b", END]:
    if termination_condition(state):
        return END
    else:
        return "b"

builder.add_edge(START, "a")
builder.add_conditional_edges("a", route)
builder.add_edge("b", "a")
graph = builder.compile()
python  theme={null}
from langgraph.errors import GraphRecursionError

try:
    graph.invoke(inputs, {"recursion_limit": 3})
except GraphRecursionError:
    print("Recursion Error")
python  theme={null}
import operator
from typing import Annotated, Literal
from typing_extensions import TypedDict
from langgraph.graph import StateGraph, START, END

class State(TypedDict):
    # The operator.add reducer fn makes this append-only
    aggregate: Annotated[list, operator.add]

def a(state: State):
    print(f'Node A sees {state["aggregate"]}')
    return {"aggregate": ["A"]}

def b(state: State):
    print(f'Node B sees {state["aggregate"]}')
    return {"aggregate": ["B"]}

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
## Create and control loops

When creating a graph with a loop, we require a mechanism for terminating execution. This is most commonly done by adding a [conditional edge](/oss/python/langgraph/graph-api#conditional-edges) that routes to the [END](/oss/python/langgraph/graph-api#end-node) node once we reach some termination condition.

You can also set the graph recursion limit when invoking or streaming the graph. The recursion limit sets the number of [supersteps](/oss/python/langgraph/graph-api#graphs) that the graph is allowed to execute before it raises an error. Read more about the concept of recursion limits [here](/oss/python/langgraph/graph-api#recursion-limit).

Let's consider a simple graph with a loop to better understand how these mechanisms work.

<Tip>
  To return the last value of your state instead of receiving a recursion limit error, see the [next section](#impose-a-recursion-limit).
</Tip>

When creating a loop, you can include a conditional edge that specifies a termination condition:
```

Example 3 (unknown):
```unknown
To control the recursion limit, specify `"recursionLimit"` in the config. This will raise a `GraphRecursionError`, which you can catch and handle:
```

Example 4 (unknown):
```unknown
Let's define a graph with a simple loop. Note that we use a conditional edge to implement a termination condition.
```

---

## Release versions

**URL:** llms-txt#release-versions

**Contents:**
- Support levels
  - Active
  - Critical
  - End of life (EOL)
  - Deprecated
- Version support policy
  - Minor version support
  - Patch releases
- Recommendations
- Version compatibility

Source: https://docs.langchain.com/langsmith/release-versions

export const product_0 = "LangSmith"

{product_0} provides different support levels for different versions, which may include new features, bug fixes, or security patches.

There are four support levels:

* Active
* Critical
* End of life (EOL)
* Deprecated

Where N represents the latest minor version (e.g., 0.3, 0.4, etc.).

The current minor version (N) receives full support, including:

* New features and capabilities
* Bug fixes and regressions
* Security patches
* Quality-of-life improvements
* High confidence changes that are narrowly scoped

The previous minor version (N-1) receives limited support:

* Critical security fixes
* Installation fixes
* No new features or general bug fixes
* Transitioned from Active when a newer minor version is released

### End of life (EOL)

Versions older than N-2 (N-2, N-3, etc.) receive no support:

* No new patch releases
* No bug fixes, including known bugs
* No security updates
* Users should upgrade to a supported version

Versions that are no longer maintained:

* All versions prior to the first stable release
* Versions that have been explicitly deprecated
* No support or maintenance provided

## Version support policy

{product_0} follows an N-2 support policy for minor versions:

* **N (Current)**: Active support
* **N-1**: Critical support
* **N-2 and older**: End of Life

### Minor version support

Minor versions include new features and capabilities and are supported according to the N-2 policy. When we refer to a minor version, such as v0.3, we always mean its latest available patch release (v0.3.x).

During the support window for each version:

* **Active Support**: Regular patch releases with bug fixes, regressions, and new features
* **Critical Support**: Security-only releases for critical fixes related to security and installation
* **End of Life**: No new patches released

* **Stay Current**: We recommend upgrading to the latest minor version to receive full support and access to new features
* **Plan Upgrades**: Monitor the changelog for upcoming version changes and plan upgrades accordingly
* **Security**: Critical security fixes are only provided for Active and Critical support versions
* **Testing**: Test your applications with newer versions before upgrading in production

## Version compatibility

When upgrading between minor versions:

* Review the changelog for breaking changes
* Test your applications thoroughly
* Follow the upgrade guides provided in the documentation
* Consider the support timeline for your current version

## Current version support

To check the current supported versions and their support levels, refer to the [Agent Server Changelog](/langsmith/agent-server-changelog) for the latest release information.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/release-versions.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## export LANGSMITH_TRACING="true"

**URL:** llms-txt#export-langsmith_tracing="true"

---

## autoscaling:

**URL:** llms-txt#autoscaling:

---

## {"type": "image", "base64": "...", "mime_type": "image/jpeg"},

**URL:** llms-txt#{"type":-"image",-"base64":-"...",-"mime_type":-"image/jpeg"},

---

## To ensure this, we'll create vectorstore indexes for all of the artists, tracks and albums

**URL:** llms-txt#to-ensure-this,-we'll-create-vectorstore-indexes-for-all-of-the-artists,-tracks-and-albums

---

## Graph API overview

**URL:** llms-txt#graph-api-overview

**Contents:**
- Graphs
  - StateGraph
  - Compiling your graph
- State
  - Schema

Source: https://docs.langchain.com/oss/python/langgraph/graph-api

At its core, LangGraph models agent workflows as graphs. You define the behavior of your agents using three key components:

1. [`State`](#state): A shared data structure that represents the current snapshot of your application. It can be any data type, but is typically defined using a shared state schema.

2. [`Nodes`](#nodes): Functions that encode the logic of your agents. They receive the current state as input, perform some computation or side-effect, and return an updated state.

3. [`Edges`](#edges): Functions that determine which `Node` to execute next based on the current state. They can be conditional branches or fixed transitions.

By composing `Nodes` and `Edges`, you can create complex, looping workflows that evolve the state over time. The real power, though, comes from how LangGraph manages that state.

To emphasize: `Nodes` and `Edges` are nothing more than functions – they can contain an LLM or just good ol' code.

In short: *nodes do the work, edges tell what to do next*.

LangGraph's underlying graph algorithm uses [message passing](https://en.wikipedia.org/wiki/Message_passing) to define a general program. When a Node completes its operation, it sends messages along one or more edges to other node(s). These recipient nodes then execute their functions, pass the resulting messages to the next set of nodes, and the process continues. Inspired by Google's [Pregel](https://research.google/pubs/pregel-a-system-for-large-scale-graph-processing/) system, the program proceeds in discrete "super-steps."

A super-step can be considered a single iteration over the graph nodes. Nodes that run in parallel are part of the same super-step, while nodes that run sequentially belong to separate super-steps. At the start of graph execution, all nodes begin in an `inactive` state. A node becomes `active` when it receives a new message (state) on any of its incoming edges (or "channels"). The active node then runs its function and responds with updates. At the end of each super-step, nodes with no incoming messages vote to `halt` by marking themselves as `inactive`. The graph execution terminates when all nodes are `inactive` and no messages are in transit.

The [`StateGraph`](https://reference.langchain.com/python/langgraph/graphs/#langgraph.graph.state.StateGraph) class is the main graph class to use. This is parameterized by a user defined `State` object.

### Compiling your graph

To build your graph, you first define the [state](#state), you then add [nodes](#nodes) and [edges](#edges), and then you compile it. What exactly is compiling your graph and why is it needed?

Compiling is a pretty simple step. It provides a few basic checks on the structure of your graph (no orphaned nodes, etc). It is also where you can specify runtime args like [checkpointers](/oss/python/langgraph/persistence) and breakpoints. You compile your graph by just calling the `.compile` method:

<Warning>
  You **MUST** compile your graph before you can use it.
</Warning>

The first thing you do when you define a graph is define the `State` of the graph. The `State` consists of the [schema of the graph](#schema) as well as [`reducer` functions](#reducers) which specify how to apply updates to the state. The schema of the `State` will be the input schema to all `Nodes` and `Edges` in the graph, and can be either a `TypedDict` or a `Pydantic` model. All `Nodes` will emit updates to the `State` which are then applied using the specified `reducer` function.

The main documented way to specify the schema of a graph is by using a [`TypedDict`](https://docs.python.org/3/library/typing.html#typing.TypedDict). If you want to provide default values in your state, use a [`dataclass`](https://docs.python.org/3/library/dataclasses.html). We also support using a Pydantic [`BaseModel`](/oss/python/langgraph/use-graph-api#use-pydantic-models-for-graph-state) as your graph state if you want recursive data validation (though note that Pydantic is less performant than a `TypedDict` or `dataclass`).

By default, the graph will have the same input and output schemas. If you want to change this, you can also specify explicit input and output schemas directly. This is useful when you have a lot of keys, and some are explicitly for input and others for output. See the [guide](/oss/python/langgraph/use-graph-api#define-input-and-output-schemas) for more information.

#### Multiple schemas

Typically, all graph nodes communicate with a single schema. This means that they will read and write to the same state channels. But, there are cases where we want more control over this:

* Internal nodes can pass information that is not required in the graph's input / output.
* We may also want to use different input / output schemas for the graph. The output might, for example, only contain a single relevant output key.

It is possible to have nodes write to private state channels inside the graph for internal node communication. We can simply define a private schema, `PrivateState`.

It is also possible to define explicit input and output schemas for a graph. In these cases, we define an "internal" schema that contains *all* keys relevant to graph operations. But, we also define `input` and `output` schemas that are sub-sets of the "internal" schema to constrain the input and output of the graph. See [this guide](/oss/python/langgraph/graph-api#define-input-and-output-schemas) for more detail.

Let's look at an example:

```python  theme={null}
class InputState(TypedDict):
    user_input: str

class OutputState(TypedDict):
    graph_output: str

class OverallState(TypedDict):
    foo: str
    user_input: str
    graph_output: str

class PrivateState(TypedDict):
    bar: str

def node_1(state: InputState) -> OverallState:
    # Write to OverallState
    return {"foo": state["user_input"] + " name"}

def node_2(state: OverallState) -> PrivateState:
    # Read from OverallState, write to PrivateState
    return {"bar": state["foo"] + " is"}

def node_3(state: PrivateState) -> OutputState:
    # Read from PrivateState, write to OutputState
    return {"graph_output": state["bar"] + " Lance"}

builder = StateGraph(OverallState,input_schema=InputState,output_schema=OutputState)
builder.add_node("node_1", node_1)
builder.add_node("node_2", node_2)
builder.add_node("node_3", node_3)
builder.add_edge(START, "node_1")
builder.add_edge("node_1", "node_2")
builder.add_edge("node_2", "node_3")
builder.add_edge("node_3", END)

graph = builder.compile()
graph.invoke({"user_input":"My"})

**Examples:**

Example 1 (unknown):
```unknown
<Warning>
  You **MUST** compile your graph before you can use it.
</Warning>

## State

The first thing you do when you define a graph is define the `State` of the graph. The `State` consists of the [schema of the graph](#schema) as well as [`reducer` functions](#reducers) which specify how to apply updates to the state. The schema of the `State` will be the input schema to all `Nodes` and `Edges` in the graph, and can be either a `TypedDict` or a `Pydantic` model. All `Nodes` will emit updates to the `State` which are then applied using the specified `reducer` function.

### Schema

The main documented way to specify the schema of a graph is by using a [`TypedDict`](https://docs.python.org/3/library/typing.html#typing.TypedDict). If you want to provide default values in your state, use a [`dataclass`](https://docs.python.org/3/library/dataclasses.html). We also support using a Pydantic [`BaseModel`](/oss/python/langgraph/use-graph-api#use-pydantic-models-for-graph-state) as your graph state if you want recursive data validation (though note that Pydantic is less performant than a `TypedDict` or `dataclass`).

By default, the graph will have the same input and output schemas. If you want to change this, you can also specify explicit input and output schemas directly. This is useful when you have a lot of keys, and some are explicitly for input and others for output. See the [guide](/oss/python/langgraph/use-graph-api#define-input-and-output-schemas) for more information.

#### Multiple schemas

Typically, all graph nodes communicate with a single schema. This means that they will read and write to the same state channels. But, there are cases where we want more control over this:

* Internal nodes can pass information that is not required in the graph's input / output.
* We may also want to use different input / output schemas for the graph. The output might, for example, only contain a single relevant output key.

It is possible to have nodes write to private state channels inside the graph for internal node communication. We can simply define a private schema, `PrivateState`.

It is also possible to define explicit input and output schemas for a graph. In these cases, we define an "internal" schema that contains *all* keys relevant to graph operations. But, we also define `input` and `output` schemas that are sub-sets of the "internal" schema to constrain the input and output of the graph. See [this guide](/oss/python/langgraph/graph-api#define-input-and-output-schemas) for more detail.

Let's look at an example:
```

---

## Run a LangGraph app locally

**URL:** llms-txt#run-a-langgraph-app-locally

**Contents:**
- Prerequisites
- 1. Install the LangGraph CLI
- 2. Create a LangGraph app 🌱
- 3. Install dependencies
- 4. Create a `.env` file
- 5. Launch Agent Server 🚀
- 6. Test the API
- Next steps

Source: https://docs.langchain.com/langsmith/local-server

This quickstart shows you how to set up a LangGraph application locally for testing and development.

Before you begin, ensure you have an API key for [LangSmith](https://smith.langchain.com/settings) (free to sign up).

## 1. Install the LangGraph CLI

<Tabs>
  <Tab title="Python server">
    
  </Tab>

<Tab title="Node server">
    
  </Tab>
</Tabs>

## 2. Create a LangGraph app 🌱

Create a new app from the [`new-langgraph-project-python` template](https://github.com/langchain-ai/new-langgraph-project) or [`new-langgraph-project-js` template](https://github.com/langchain-ai/new-langgraphjs-project). This template demonstrates a single-node application you can extend with your own logic.

<Tabs>
  <Tab title="Python server">
    
  </Tab>

<Tab title="Node server">
    
  </Tab>
</Tabs>

<Tip>
  **Additional templates**<br />
  If you use [`langgraph new`](/langsmith/cli) without specifying a template, you will be presented with an interactive menu that will allow you to choose from a list of available templates.
</Tip>

## 3. Install dependencies

In the root of your new LangGraph app, install the dependencies in `edit` mode so your local changes are used by the server:

<Tabs>
  <Tab title="Python server">
    
  </Tab>

<Tab title="Node server">
    
  </Tab>
</Tabs>

## 4. Create a `.env` file

You will find a [`.env.example`](/langsmith/application-structure#configuration-file) in the root of your new LangGraph app. Create a `.env` file in the root of your new LangGraph app and copy the contents of the `.env.example` file into it, filling in the necessary API keys:

## 5. Launch Agent Server 🚀

Start the Agent Server locally:

<Tabs>
  <Tab title="Python server">
    
  </Tab>

<Tab title="Node server">
    
  </Tab>
</Tabs>

The [`langgraph dev`](/langsmith/cli) command starts [Agent Server](/langsmith/agent-server) in an in-memory mode. This mode is suitable for development and testing purposes.

<Tip>
  For production use, deploy Agent Server with a persistent storage backend. For more information, refer to the LangSmith [platform options](/langsmith/platform-setup).
</Tip>

<Tabs>
  <Tab title="Python SDK (async)">
    1. Install the LangGraph Python SDK:

2. Send a message to the assistant (threadless run):

<Tab title="Python SDK (sync)">
    1. Install the LangGraph Python SDK:

2. Send a message to the assistant (threadless run):

<Tab title="Javascript SDK">
    1. Install the LangGraph JS SDK:

2. Send a message to the assistant (threadless run):

<Tab title="Rest API">
    
  </Tab>
</Tabs>

Now that you have a LangGraph app running locally, you're ready to deploy it:

**Choose a hosting option for LangSmith:**

* [**Cloud**](/langsmith/cloud): Fastest setup, fully managed (recommended).
* [**Hybrid**](/langsmith/hybrid): <Tooltip tip="The runtime environment where your Agent Servers and agents execute.">Data plane</Tooltip> in your cloud, <Tooltip tip="The LangSmith UI and APIs for managing deployments.">control plane</Tooltip> managed by LangChain.
* [**Self-hosted**](/langsmith/self-hosted): Full control in your infrastructure.

For more details, refer to the [Platform setup comparison](/langsmith/platform-setup).

**Then deploy your app:**

* [Deploy to Cloud quickstart](/langsmith/deployment-quickstart): Quick setup guide.
* [Full Cloud setup guide](/langsmith/deploy-to-cloud): Comprehensive deployment documentation.

**Explore features:**

* **[Studio](/langsmith/studio)**: Visualize, interact with, and debug your application with the Studio UI. Try the [Studio quickstart](/langsmith/quick-start-studio).
* **API References**: [LangSmith Deployment API](https://langchain-ai.github.io/langgraph/cloud/reference/api/api_ref/), [Python SDK](/langsmith/langgraph-python-sdk), [JS/TS SDK](/langsmith/langgraph-js-ts-sdk)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/local-server.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="Node server">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

## 2. Create a LangGraph app 🌱

Create a new app from the [`new-langgraph-project-python` template](https://github.com/langchain-ai/new-langgraph-project) or [`new-langgraph-project-js` template](https://github.com/langchain-ai/new-langgraphjs-project). This template demonstrates a single-node application you can extend with your own logic.

<Tabs>
  <Tab title="Python server">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="Node server">
```

Example 4 (unknown):
```unknown
</Tab>
</Tabs>

<Tip>
  **Additional templates**<br />
  If you use [`langgraph new`](/langsmith/cli) without specifying a template, you will be presented with an interactive menu that will allow you to choose from a list of available templates.
</Tip>

## 3. Install dependencies

In the root of your new LangGraph app, install the dependencies in `edit` mode so your local changes are used by the server:

<Tabs>
  <Tab title="Python server">
```

---

## The prebuilt ReACT agent only expects State to have a 'messages' key, so the

**URL:** llms-txt#the-prebuilt-react-agent-only-expects-state-to-have-a-'messages'-key,-so-the

---

## Reject Concurrent

**URL:** llms-txt#reject-concurrent

**Contents:**
- Setup
- Create runs
- View run results

Source: https://docs.langchain.com/langsmith/reject-concurrent

This guide assumes knowledge of what double-texting is, which you can learn about in the [double-texting conceptual guide](/langsmith/double-texting).

The guide covers the `reject` option for double texting, which rejects the new run of the graph by throwing an error and continues with the original run until completion. Below is a quick example of using the `reject` option.

First, we will define a quick helper function for printing out JS and CURL model outputs (you can skip this if using Python):

<Tabs>
  <Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

Now we can run a thread and try to run a second one with the "reject" option, which should fail since we have already started a run:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

We can verify that the original thread finished executing:

<Tabs>
  <Tab title="Python">
    
  </Tab>

<Tab title="Javascript">
    
  </Tab>

<Tab title="CURL">
    
  </Tab>
</Tabs>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/reject-concurrent.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

Example 2 (unknown):
```unknown
</Tab>
</Tabs>

Now, let's import our required packages and instantiate our client, assistant, and thread.

<Tabs>
  <Tab title="Python">
```

Example 3 (unknown):
```unknown
</Tab>

  <Tab title="Javascript">
```

Example 4 (unknown):
```unknown
</Tab>

  <Tab title="CURL">
```

---

## client.py

**URL:** llms-txt#client.py

from langsmith.run_helpers import get_current_run_tree, traceable
import httpx

@traceable
async def my_client_function():
    headers = {}
    async with httpx.AsyncClient(base_url="...") as client:
        if run_tree := get_current_run_tree():
            # add langsmith-id to headers
            headers.update(run_tree.to_headers())
        return await client.post("/my-route", headers=headers)
python  theme={null}
from langsmith import traceable
from langsmith.middleware import TracingMiddleware
from fastapi import FastAPI, Request

app = FastAPI()  # Or Flask, Django, or any other framework
app.add_middleware(TracingMiddleware)

@traceable
async def some_function():
    ...

@app.post("/my-route")
async def fake_route(request: Request):
    return await some_function()
python  theme={null}
from starlette.applications import Starlette
from starlette.middleware import Middleware
from langsmith.middleware import TracingMiddleware

routes = ...
middleware = [
    Middleware(TracingMiddleware),
]
app = Starlette(..., middleware=middleware)
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
Then the server (or other service) can continue the trace by handling the headers appropriately. If you are using an asgi app Starlette or FastAPI, you can connect the distributed trace using LangSmith's `TracingMiddleware`.

<Info>
  The `TracingMiddleware` class was added in `langsmith==0.1.133`.
</Info>

Example using FastAPI:
```

Example 2 (unknown):
```unknown
Or in Starlette:
```

Example 3 (unknown):
```unknown
If you are using other server frameworks, you can always "receive" the distributed trace by passing the headers in through `langsmith_extra`:
```

---

## Schema for routing user intent.

**URL:** llms-txt#schema-for-routing-user-intent.

---

## Redefine the tool node to use the interrupt version

**URL:** llms-txt#redefine-the-tool-node-to-use-the-interrupt-version

**Contents:**
- Next steps

run_query_node = ToolNode([run_query_tool_with_interrupt], name="run_query") # [!code highlight]
python  theme={null}
from langgraph.checkpoint.memory import InMemorySaver

def should_continue(state: MessagesState) -> Literal[END, "run_query"]:
    messages = state["messages"]
    last_message = messages[-1]
    if not last_message.tool_calls:
        return END
    else:
        return "run_query"

builder = StateGraph(MessagesState)
builder.add_node(list_tables)
builder.add_node(call_get_schema)
builder.add_node(get_schema_node, "get_schema")
builder.add_node(generate_query)
builder.add_node(run_query_node, "run_query")

builder.add_edge(START, "list_tables")
builder.add_edge("list_tables", "call_get_schema")
builder.add_edge("call_get_schema", "get_schema")
builder.add_edge("get_schema", "generate_query")
builder.add_conditional_edges(
    "generate_query",
    should_continue,
)
builder.add_edge("run_query", "generate_query")

checkpointer = InMemorySaver() # [!code highlight]
agent = builder.compile(checkpointer=checkpointer) # [!code highlight]
python  theme={null}
import json

config = {"configurable": {"thread_id": "1"}}

question = "Which genre on average has the longest tracks?"

for step in agent.stream(
    {"messages": [{"role": "user", "content": question}]},
    config,
    stream_mode="values",
):
    if "messages" in step:
        step["messages"][-1].pretty_print()
    elif "__interrupt__" in step:
        action = step["__interrupt__"][0]
        print("INTERRUPTED:")
        for request in action.value:
            print(json.dumps(request, indent=2))
    else:
        pass

INTERRUPTED:
{
  "action": "sql_db_query",
  "args": {
    "query": "SELECT Genre.Name, AVG(Track.Milliseconds) AS AvgLength FROM Track JOIN Genre ON Track.GenreId = Genre.GenreId GROUP BY Genre.Name ORDER BY AvgLength DESC LIMIT 5;"
  },
  "description": "Please review the tool call"
}
python  theme={null}
from langgraph.types import Command

for step in agent.stream(
    Command(resume={"type": "accept"}),
    # Command(resume={"type": "edit", "args": {"query": "..."}}),
    config,
    stream_mode="values",
):
    if "messages" in step:
        step["messages"][-1].pretty_print()
    elif "__interrupt__" in step:
        action = step["__interrupt__"][0]
        print("INTERRUPTED:")
        for request in action.value:
            print(json.dumps(request, indent=2))
    else:
        pass

================================== Ai Message ==================================
Tool Calls:
  sql_db_query (call_t4yXkD6shwdTPuelXEmY3sAY)
 Call ID: call_t4yXkD6shwdTPuelXEmY3sAY
  Args:
    query: SELECT Genre.Name, AVG(Track.Milliseconds) AS AvgLength FROM Track JOIN Genre ON Track.GenreId = Genre.GenreId GROUP BY Genre.Name ORDER BY AvgLength DESC LIMIT 5;
================================= Tool Message =================================
Name: sql_db_query

[('Sci Fi & Fantasy', 2911783.0384615385), ('Science Fiction', 2625549.076923077), ('Drama', 2575283.78125), ('TV Shows', 2145041.0215053763), ('Comedy', 1585263.705882353)]
================================== Ai Message ==================================

The genre with the longest average track length is "Sci Fi & Fantasy" with an average length of about 2,911,783 milliseconds. Other genres with long average track lengths include "Science Fiction," "Drama," "TV Shows," and "Comedy."
```

Refer to the [human-in-the-loop guide](/oss/python/langgraph/interrupts) for details.

Check out the [Evaluate a graph](/langsmith/evaluate-graph) guide for evaluating LangGraph applications, including SQL agents like this one, using LangSmith.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langgraph/sql-agent.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Note>
  The above implementation follows the [tool interrupt example](/oss/python/langgraph/interrupts#configuring-interrupts) in the broader [human-in-the-loop](/oss/python/langgraph/interrupts) guide. Refer to that guide for details and alternatives.
</Note>

Let's now re-assemble our graph. We will replace the programmatic check with human review. Note that we now include a [checkpointer](/oss/python/langgraph/persistence); this is required to pause and resume the run.
```

Example 2 (unknown):
```unknown
We can invoke the graph as before. This time, execution is interrupted:
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
We can accept or edit the tool call using [Command](/oss/python/langgraph/use-graph-api#combine-control-flow-and-state-updates-with-command):
```

---

## Metrics: [OTel Example](/langsmith/langsmith-collector#metrics)

**URL:** llms-txt#metrics:-[otel-example](/langsmith/langsmith-collector#metrics)

**Contents:**
- LangSmith Services
- Frontend Nginx
- Postgres + Redis
- Clickhouse

## LangSmith Services

The following LangSmith services expose metrics at an endpoint, in the Prometheus metrics format. The frontend does not currently expose metrics.

* **Backend**: `http://<langsmith_release_name>-backend.<namespace>.svc.cluster.local:1984/metrics`
* **Platform Backend**: `http://<langsmith_release_name>-platform-backend.<namespace>.svc.cluster.local:1986/metrics`
* **Playground**: `http://<langsmith_release_name>-playground.<namespace>.svc.cluster.local:1988/metrics`
* **(LangSmith Control Plane only) Host Backend**: `http://<langsmith_release_name>-host-backend.<namespace>.svc.cluster.local:1985/metrics`

You can use a [Prometheus](https://prometheus.io/docs/prometheus/latest/getting_started/#configure-prometheus-to-monitor-the-sample-targets) or [OpenTelemetry](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/prometheusreceiver) collector to scrape the endpoints, and export metrics to the backend of your choice.

The frontend service exposes its Nginx metrics at the following endpoint: `langsmith-frontend.langsmith.svc.cluster.local:80/nginx_status`. You can either scrape them yourself, or bring up a Prometheus Nginx exporter using the [LangSmith Observability Helm Chart](/langsmith/observability-stack)

<Warning>
  **The following sections apply for in-cluster databases only. If you are using external databases, you will need to configure exposing and fetching metrics.**
</Warning>

If you are using in-cluster Postgres/Redis instances, you can use a Prometheus exporter to expose metrics from your instance. You can deploy your own, or if you would like, you can use the [LangSmith Observability Helm Chart](/langsmith/observability-stack) to deploy an exporter for you.

The in-cluster Clickhouse is configured to expose metrics without the need for an exporter. You can use your collector to scrape metrics at `http://<langsmith_release_name>-clickhouse.<namespace>.svc.cluster.local:9363/metrics`

---

## minReplicas: 8

**URL:** llms-txt#minreplicas:-8

**Contents:**
- Note that we are actively working on improving performance of this service to reduce the number of replicas.

## Note that we are actively working on improving performance of this service to reduce the number of replicas.
queue:
  deployment:
    replicas: 160 # OR enable autoscaling to this level (example below)

---

## Human-in-the-loop using server API

**URL:** llms-txt#human-in-the-loop-using-server-api

**Contents:**
- Dynamic interrupts
- Static interrupts
- Learn more

Source: https://docs.langchain.com/langsmith/add-human-in-the-loop

To review, edit, and approve tool calls in an agent or workflow, use LangGraph's [human-in-the-loop](/oss/python/langgraph/interrupts) features.

## Dynamic interrupts

<Tabs>
  <Tab title="Python">

1. The graph is invoked with some initial state.
    2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
       3\. The graph is resumed with a `Command(resume=...)`, injecting the human's input and continuing execution.
  </Tab>

<Tab title="JavaScript">

1. The graph is invoked with some initial state.
    2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
    3. The graph is resumed with a `{ resume: ... }` command object, injecting the human's input and continuing execution.
  </Tab>

<Tab title="cURL">
    Create a thread:

Run the graph until the interrupt is hit.:

<Accordion title="Extended example: using `interrupt`">
  This is an example graph you can run in the Agent Server.
  See [LangSmith quickstart](/langsmith/deployment-quickstart) for more details.

1. `interrupt(...)` pauses execution at `human_node`, surfacing the given payload to a human.
  2. Any JSON serializable value can be passed to the [`interrupt`](https://reference.langchain.com/python/langgraph/types/#langgraph.types.interrupt) function. Here, a dict containing the text to revise.
  3. Once resumed, the return value of `interrupt(...)` is the human-provided input, which is used to update the state.

Once you have a running Agent Server, you can interact with it using
  [LangGraph SDK](/langsmith/langgraph-python-sdk)

<Tabs>
    <Tab title="Python">

1. The graph is invoked with some initial state.
      2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
         3\. The graph is resumed with a `Command(resume=...)`, injecting the human's input and continuing execution.
    </Tab>

<Tab title="JavaScript">

1. The graph is invoked with some initial state.
      2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
      3. The graph is resumed with a `{ resume: ... }` command object, injecting the human's input and continuing execution.
    </Tab>

<Tab title="cURL">
      Create a thread:

Run the graph until the interrupt is hit:

</Tab>
  </Tabs>
</Accordion>

Static interrupts (also known as static breakpoints) are triggered either before or after a node executes.

<Warning>
  Static interrupts are **not** recommended for human-in-the-loop workflows. They are best used for debugging and testing.
</Warning>

You can set static interrupts by specifying `interrupt_before` and `interrupt_after` at compile time:

1. The breakpoints are set during `compile` time.
2. `interrupt_before` specifies the nodes where execution should pause before the node is executed.
3. `interrupt_after` specifies the nodes where execution should pause after the node is executed.

Alternatively, you can set static interrupts at run time:

<Tabs>
  <Tab title="Python">

1. `client.runs.wait` is called with the `interrupt_before` and `interrupt_after` parameters. This is a run-time configuration and can be changed for every invocation.
    2. `interrupt_before` specifies the nodes where execution should pause before the node is executed.
    3. `interrupt_after` specifies the nodes where execution should pause after the node is executed.
  </Tab>

<Tab title="JavaScript">

1. `client.runs.wait` is called with the `interruptBefore` and `interruptAfter` parameters. This is a run-time configuration and can be changed for every invocation.
    2. `interruptBefore` specifies the nodes where execution should pause before the node is executed.
    3. `interruptAfter` specifies the nodes where execution should pause after the node is executed.
  </Tab>

<Tab title="cURL">
    
  </Tab>
</Tabs>

The following example shows how to add static interrupts:

<Tabs>
  <Tab title="Python">

1. The graph is run until the first breakpoint is hit.
    2. The graph is resumed by passing in `None` for the input. This will run the graph until the next breakpoint is hit.
  </Tab>

<Tab title="JavaScript">

1. The graph is run until the first breakpoint is hit.
    2. The graph is resumed by passing in `null` for the input. This will run the graph until the next breakpoint is hit.
  </Tab>

<Tab title="cURL">
    Create a thread:

Run the graph until the breakpoint:

* [Human-in-the-loop conceptual guide](/oss/python/langgraph/interrupts): learn more about LangGraph human-in-the-loop features.
* [Common patterns](/oss/python/langgraph/interrupts#common-patterns): learn how to implement patterns like approving/rejecting actions, requesting user input, tool call review, and validating human input.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/add-human-in-the-loop.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
1. The graph is invoked with some initial state.
    2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
       3\. The graph is resumed with a `Command(resume=...)`, injecting the human's input and continuing execution.
  </Tab>

  <Tab title="JavaScript">
```

Example 2 (unknown):
```unknown
1. The graph is invoked with some initial state.
    2. When the graph hits the interrupt, it returns an interrupt object with the payload and metadata.
    3. The graph is resumed with a `{ resume: ... }` command object, injecting the human's input and continuing execution.
  </Tab>

  <Tab title="cURL">
    Create a thread:
```

Example 3 (unknown):
```unknown
Run the graph until the interrupt is hit.:
```

Example 4 (unknown):
```unknown
Resume the graph:
```

---

## This can be a user input to your app

**URL:** llms-txt#this-can-be-a-user-input-to-your-app

question = "Can you summarize this morning's meetings?"

---

## Model initialization

**URL:** llms-txt#model-initialization

**Contents:**
  - `langchain-classic`
- Migration guide
- Reporting issues
- Additional resources
- See also

from langchain.chat_models import init_chat_model
from langchain.embeddings import init_embeddings
bash pip theme={null}
  pip install langchain-classic
  bash uv theme={null}
  uv add langchain-classic
  python  theme={null}
from langchain import ...  # [!code --]
from langchain_classic import ...  # [!code ++]

from langchain.chains import ...  # [!code --]
from langchain_classic.chains import ...  # [!code ++]

from langchain.retrievers import ...  # [!code --]
from langchain_classic.retrievers import ...  # [!code ++]

from langchain import hub  # [!code --]
from langchain_classic import hub  # [!code ++]
```

See our [migration guide](/oss/python/migrate/langchain-v1) for help updating your code to LangChain v1.

Please report any issues discovered with 1.0 on [GitHub](https://github.com/langchain-ai/langchain/issues) using the `'v1'` [label](https://github.com/langchain-ai/langchain/issues?q=state%3Aopen%20label%3Av1).

## Additional resources

<CardGroup cols={3}>
  <Card title="LangChain 1.0" icon="rocket" href="https://blog.langchain.com/langchain-langchain-1-0-alpha-releases/">
    Read the announcement
  </Card>

<Card title="Middleware Guide" icon="puzzle-piece" href="https://blog.langchain.com/agent-middleware/">
    Deep dive into middleware
  </Card>

<Card title="Agents Documentation" icon="book" href="/oss/python/langchain/agents" arrow>
    Full agent documentation
  </Card>

<Card title="Message Content" icon="message" href="/oss/python/langchain/messages#message-content" arrow>
    New content blocks API
  </Card>

<Card title="Migration guide" icon="arrow-right-arrow-left" href="/oss/python/migrate/langchain-v1" arrow>
    How to migrate to LangChain v1
  </Card>

<Card title="GitHub" icon="github" href="https://github.com/langchain-ai/langchain">
    Report issues or contribute
  </Card>
</CardGroup>

* [Versioning](/oss/python/versioning) - Understanding version numbers
* [Release policy](/oss/python/release-policy) - Detailed release policies

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/releases/langchain-v1.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
### `langchain-classic`

Legacy functionality has moved to [`langchain-classic`](https://pypi.org/project/langchain-classic) to keep the core packages lean and focused.

**What's in `langchain-classic`:**

* Legacy chains and chain implementations
* Retrievers (e.g. `MultiQueryRetriever` or anything from the previous `langchain.retrievers` module)
* The indexing API
* The hub module (for managing prompts programmatically)
* [`langchain-community`](https://pypi.org/project/langchain-community) exports
* Other deprecated functionality

If you use any of this functionality, install [`langchain-classic`](https://pypi.org/project/langchain-classic):

<CodeGroup>
```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown
</CodeGroup>

Then update your imports:
```

---

## >                'name': 'execute_sql',

**URL:** llms-txt#>----------------'name':-'execute_sql',

---

## Subsequent calls use the cache

**URL:** llms-txt#subsequent-calls-use-the-cache

**Contents:**
- All embedding models

tic = time.time()
print(cached_embedder.embed_query("Hello, world!"))
print(f"Second call took: {time.time() - tic:.2f} seconds")
```

In production, you would typically use a more robust persistent store, such as a database or cloud storage. Please see [stores integrations](/oss/python/integrations/stores/) for options.

## All embedding models

<Columns cols={3}>
  <Card title="Aleph Alpha" icon="link" href="/oss/python/integrations/text_embedding/aleph_alpha" arrow="true" cta="View guide" />

<Card title="Anyscale" icon="link" href="/oss/python/integrations/text_embedding/anyscale" arrow="true" cta="View guide" />

<Card title="Ascend" icon="link" href="/oss/python/integrations/text_embedding/ascend" arrow="true" cta="View guide" />

<Card title="AI/ML API" icon="link" href="/oss/python/integrations/text_embedding/aimlapi" arrow="true" cta="View guide" />

<Card title="AwaDB" icon="link" href="/oss/python/integrations/text_embedding/awadb" arrow="true" cta="View guide" />

<Card title="AzureOpenAI" icon="link" href="/oss/python/integrations/text_embedding/azure_openai" arrow="true" cta="View guide" />

<Card title="Baichuan Text Embeddings" icon="link" href="/oss/python/integrations/text_embedding/baichuan" arrow="true" cta="View guide" />

<Card title="Baidu Qianfan" icon="link" href="/oss/python/integrations/text_embedding/baidu_qianfan_endpoint" arrow="true" cta="View guide" />

<Card title="Baseten" icon="link" href="/oss/python/integrations/text_embedding/baseten" arrow="true" cta="View guide" />

<Card title="Bedrock" icon="link" href="/oss/python/integrations/text_embedding/bedrock" arrow="true" cta="View guide" />

<Card title="BGE on Hugging Face" icon="link" href="/oss/python/integrations/text_embedding/bge_huggingface" arrow="true" cta="View guide" />

<Card title="Bookend AI" icon="link" href="/oss/python/integrations/text_embedding/bookend" arrow="true" cta="View guide" />

<Card title="Clarifai" icon="link" href="/oss/python/integrations/text_embedding/clarifai" arrow="true" cta="View guide" />

<Card title="Cloudflare Workers AI" icon="link" href="/oss/python/integrations/text_embedding/cloudflare_workersai" arrow="true" cta="View guide" />

<Card title="Clova Embeddings" icon="link" href="/oss/python/integrations/text_embedding/clova" arrow="true" cta="View guide" />

<Card title="Cohere" icon="link" href="/oss/python/integrations/text_embedding/cohere" arrow="true" cta="View guide" />

<Card title="DashScope" icon="link" href="/oss/python/integrations/text_embedding/dashscope" arrow="true" cta="View guide" />

<Card title="Databricks" icon="link" href="/oss/python/integrations/text_embedding/databricks" arrow="true" cta="View guide" />

<Card title="DeepInfra" icon="link" href="/oss/python/integrations/text_embedding/deepinfra" arrow="true" cta="View guide" />

<Card title="EDEN AI" icon="link" href="/oss/python/integrations/text_embedding/edenai" arrow="true" cta="View guide" />

<Card title="Elasticsearch" icon="link" href="/oss/python/integrations/text_embedding/elasticsearch" arrow="true" cta="View guide" />

<Card title="Embaas" icon="link" href="/oss/python/integrations/text_embedding/embaas" arrow="true" cta="View guide" />

<Card title="Fake Embeddings" icon="link" href="/oss/python/integrations/text_embedding/fake" arrow="true" cta="View guide" />

<Card title="FastEmbed by Qdrant" icon="link" href="/oss/python/integrations/text_embedding/fastembed" arrow="true" cta="View guide" />

<Card title="Fireworks" icon="link" href="/oss/python/integrations/text_embedding/fireworks" arrow="true" cta="View guide" />

<Card title="Google Gemini" icon="link" href="/oss/python/integrations/text_embedding/google_generative_ai" arrow="true" cta="View guide" />

<Card title="Google Vertex AI" icon="link" href="/oss/python/integrations/text_embedding/google_vertex_ai" arrow="true" cta="View guide" />

<Card title="GPT4All" icon="link" href="/oss/python/integrations/text_embedding/gpt4all" arrow="true" cta="View guide" />

<Card title="Gradient" icon="link" href="/oss/python/integrations/text_embedding/gradient" arrow="true" cta="View guide" />

<Card title="GreenNode" icon="link" href="/oss/python/integrations/text_embedding/greennode" arrow="true" cta="View guide" />

<Card title="Hugging Face" icon="link" href="/oss/python/integrations/text_embedding/huggingfacehub" arrow="true" cta="View guide" />

<Card title="IBM watsonx.ai" icon="link" href="/oss/python/integrations/text_embedding/ibm_watsonx" arrow="true" cta="View guide" />

<Card title="Infinity" icon="link" href="/oss/python/integrations/text_embedding/infinity" arrow="true" cta="View guide" />

<Card title="Instruct Embeddings" icon="link" href="/oss/python/integrations/text_embedding/instruct_embeddings" arrow="true" cta="View guide" />

<Card title="IPEX-LLM CPU" icon="link" href="/oss/python/integrations/text_embedding/ipex_llm" arrow="true" cta="View guide" />

<Card title="IPEX-LLM GPU" icon="link" href="/oss/python/integrations/text_embedding/ipex_llm_gpu" arrow="true" cta="View guide" />

<Card title="Intel Extension for Transformers" icon="link" href="/oss/python/integrations/text_embedding/itrex" arrow="true" cta="View guide" />

<Card title="Jina" icon="link" href="/oss/python/integrations/text_embedding/jina" arrow="true" cta="View guide" />

<Card title="John Snow Labs" icon="link" href="/oss/python/integrations/text_embedding/johnsnowlabs_embedding" arrow="true" cta="View guide" />

<Card title="LASER" icon="link" href="/oss/python/integrations/text_embedding/laser" arrow="true" cta="View guide" />

<Card title="Lindorm" icon="link" href="/oss/python/integrations/text_embedding/lindorm" arrow="true" cta="View guide" />

<Card title="Llama.cpp" icon="link" href="/oss/python/integrations/text_embedding/llamacpp" arrow="true" cta="View guide" />

<Card title="LLMRails" icon="link" href="/oss/python/integrations/text_embedding/llm_rails" arrow="true" cta="View guide" />

<Card title="LocalAI" icon="link" href="/oss/python/integrations/text_embedding/localai" arrow="true" cta="View guide" />

<Card title="MiniMax" icon="link" href="/oss/python/integrations/text_embedding/minimax" arrow="true" cta="View guide" />

<Card title="MistralAI" icon="link" href="/oss/python/integrations/text_embedding/mistralai" arrow="true" cta="View guide" />

<Card title="Model2Vec" icon="link" href="/oss/python/integrations/text_embedding/model2vec" arrow="true" cta="View guide" />

<Card title="ModelScope" icon="link" href="/oss/python/integrations/text_embedding/modelscope_embedding" arrow="true" cta="View guide" />

<Card title="MosaicML" icon="link" href="/oss/python/integrations/text_embedding/mosaicml" arrow="true" cta="View guide" />

<Card title="Naver" icon="link" href="/oss/python/integrations/text_embedding/naver" arrow="true" cta="View guide" />

<Card title="Nebius" icon="link" href="/oss/python/integrations/text_embedding/nebius" arrow="true" cta="View guide" />

<Card title="Netmind" icon="link" href="/oss/python/integrations/text_embedding/netmind" arrow="true" cta="View guide" />

<Card title="NLP Cloud" icon="link" href="/oss/python/integrations/text_embedding/nlp_cloud" arrow="true" cta="View guide" />

<Card title="Nomic" icon="link" href="/oss/python/integrations/text_embedding/nomic" arrow="true" cta="View guide" />

<Card title="NVIDIA NIMs" icon="link" href="/oss/python/integrations/text_embedding/nvidia_ai_endpoints" arrow="true" cta="View guide" />

<Card title="Oracle Cloud Infrastructure" icon="link" href="/oss/python/integrations/text_embedding/oci_generative_ai" arrow="true" cta="View guide" />

<Card title="Ollama" icon="link" href="/oss/python/integrations/text_embedding/ollama" arrow="true" cta="View guide" />

<Card title="OpenClip" icon="link" href="/oss/python/integrations/text_embedding/open_clip" arrow="true" cta="View guide" />

<Card title="OpenAI" icon="link" href="/oss/python/integrations/text_embedding/openai" arrow="true" cta="View guide" />

<Card title="OpenVINO" icon="link" href="/oss/python/integrations/text_embedding/openvino" arrow="true" cta="View guide" />

<Card title="Optimum Intel" icon="link" href="/oss/python/integrations/text_embedding/optimum_intel" arrow="true" cta="View guide" />

<Card title="Oracle AI Vector Search" icon="link" href="/oss/python/integrations/text_embedding/oracleai" arrow="true" cta="View guide" />

<Card title="OVHcloud" icon="link" href="/oss/python/integrations/text_embedding/ovhcloud" arrow="true" cta="View guide" />

<Card title="Pinecone Embeddings" icon="link" href="/oss/python/integrations/text_embedding/pinecone" arrow="true" cta="View guide" />

<Card title="PredictionGuard" icon="link" href="/oss/python/integrations/text_embedding/predictionguard" arrow="true" cta="View guide" />

<Card title="PremAI" icon="link" href="/oss/python/integrations/text_embedding/premai" arrow="true" cta="View guide" />

<Card title="SageMaker" icon="link" href="/oss/python/integrations/text_embedding/sagemaker-endpoint" arrow="true" cta="View guide" />

<Card title="SambaNova" icon="link" href="/oss/python/integrations/text_embedding/sambanova" arrow="true" cta="View guide" />

<Card title="Self Hosted" icon="link" href="/oss/python/integrations/text_embedding/self-hosted" arrow="true" cta="View guide" />

<Card title="Sentence Transformers" icon="link" href="/oss/python/integrations/text_embedding/sentence_transformers" arrow="true" cta="View guide" />

<Card title="Solar" icon="link" href="/oss/python/integrations/text_embedding/solar" arrow="true" cta="View guide" />

<Card title="SpaCy" icon="link" href="/oss/python/integrations/text_embedding/spacy_embedding" arrow="true" cta="View guide" />

<Card title="SparkLLM" icon="link" href="/oss/python/integrations/text_embedding/sparkllm" arrow="true" cta="View guide" />

<Card title="TensorFlow Hub" icon="link" href="/oss/python/integrations/text_embedding/tensorflowhub" arrow="true" cta="View guide" />

<Card title="Text Embeddings Inference" icon="link" href="/oss/python/integrations/text_embedding/text_embeddings_inference" arrow="true" cta="View guide" />

<Card title="TextEmbed" icon="link" href="/oss/python/integrations/text_embedding/textembed" arrow="true" cta="View guide" />

<Card title="Titan Takeoff" icon="link" href="/oss/python/integrations/text_embedding/titan_takeoff" arrow="true" cta="View guide" />

<Card title="Together AI" icon="link" href="/oss/python/integrations/text_embedding/together" arrow="true" cta="View guide" />

<Card title="Upstage" icon="link" href="/oss/python/integrations/text_embedding/upstage" arrow="true" cta="View guide" />

<Card title="Volc Engine" icon="link" href="/oss/python/integrations/text_embedding/volcengine" arrow="true" cta="View guide" />

<Card title="Voyage AI" icon="link" href="/oss/python/integrations/text_embedding/voyageai" arrow="true" cta="View guide" />

<Card title="Xinference" icon="link" href="/oss/python/integrations/text_embedding/xinference" arrow="true" cta="View guide" />

<Card title="YandexGPT" icon="link" href="/oss/python/integrations/text_embedding/yandex" arrow="true" cta="View guide" />

<Card title="ZhipuAI" icon="link" href="/oss/python/integrations/text_embedding/zhipuai" arrow="true" cta="View guide" />
</Columns>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/integrations/text_embedding/index.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Optimize a classifier

**URL:** llms-txt#optimize-a-classifier

**Contents:**
- The objective
- Getting started
- Set up automations
- Update the application
  - NEW CODE ###

Source: https://docs.langchain.com/langsmith/optimize-classifier

This tutorial walks through optimizing a classifier based on user a feedback. Classifiers are great to optimize because its generally pretty simple to collect the desired output, which makes it easy to create few shot examples based on user feedback. That is exactly what we will do in this example.

In this example, we will build a bot that classify GitHub issues based on their title. It will take in a title and classify it into one of many different classes. Then, we will start to collect user feedback and use that to shape how this classifier performs.

To get started, we will first set it up so that we send all traces to a specific project. We can do this by setting an environment variable:

We can then create our initial application. This will be a really simple function that just takes in a GitHub issue title and tries to label it.

We can then start to interact with it. When interacting with it, we will generate the LangSmith run id ahead of time and pass that into this function. We do this so we can attach feedback later on.

Here's how we can invoke the application:

Here's how we can attach feedback after. We can collect feedback in two forms.

First, we can collect "positive" feedback - this is for examples that the model got right.

Next, we can focus on collecting feedback that corresponds to a "correction" to the generation. In this example the model will classify it as a bug, whereas I really want this to be classified as documentation.

## Set up automations

We can now set up automations to move examples with feedback of some form into a dataset. We will set up two automations, one for positive feedback and the other for negative feedback.

The first will take all runs with positive feedback and automatically add them to a dataset. The logic behind this is that any run with positive feedback we can use as a good example in future iterations. Let's create a dataset called `classifier-github-issues` to add this data to.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=e36c57f7e0e224ff1ea29bcfbe9891fc" alt="Optimization Negative" data-og-width="1033" width="1033" data-og-height="558" height="558" data-path="langsmith/images/class-optimization-neg.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=4091f7ae7d447eab035b32b66788eaee 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=9971db3fd8992d31d94b58095381e575 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=96f35883e764b0f207692ce1fba46d08 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=f1aa5d6d49137a2f8d254ad2d327dabf 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=c9d20165b113f53fe5638c66ff47eddb 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-neg.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=0109460c47883c4225fd54115acadb2b 2500w" />

The second will take all runs with a correction and use a webhook to add them to a dataset. When creating this webhook, we will select the option to "Use Corrections". This option will make it so that when creating a dataset from a run, rather than using the output of the run as the gold-truth output of the datapoint, it will use the correction.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=6485ca961ed1c29d33f25f75f90ba939" alt="Optimization Positive" data-og-width="1038" width="1038" data-og-height="506" height="506" data-path="langsmith/images/class-optimization-pos.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=07ee0c534c8d8ce3e34e7c17058af5c0 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=d14fc77148d349e02b363af96f0752ad 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=56592428dbb8d34492bbbc2bee911500 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=81a4d0d24ca94ad2adb5b4463bb3f776 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=1c3086f1fa332b846e7b6f668084fada 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/class-optimization-pos.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=41ba1a118c1f220018e619edf2fecee2 2500w" />

## Update the application

We can now update our code to pull down the dataset we are sending runs to. Once we pull it down, we can create a string with the examples in it. We can then put this string as part of the prompt!

```python  theme={null}
### NEW CODE ###

**Examples:**

Example 1 (unknown):
```unknown
We can then create our initial application. This will be a really simple function that just takes in a GitHub issue title and tries to label it.
```

Example 2 (unknown):
```unknown
We can then start to interact with it. When interacting with it, we will generate the LangSmith run id ahead of time and pass that into this function. We do this so we can attach feedback later on.

Here's how we can invoke the application:
```

Example 3 (unknown):
```unknown
Here's how we can attach feedback after. We can collect feedback in two forms.

First, we can collect "positive" feedback - this is for examples that the model got right.
```

Example 4 (unknown):
```unknown
Next, we can focus on collecting feedback that corresponds to a "correction" to the generation. In this example the model will classify it as a bug, whereas I really want this to be classified as documentation.
```

---

## Explore the results as a Pandas DataFrame.

**URL:** llms-txt#explore-the-results-as-a-pandas-dataframe.

---

## Dynamic prompts

**URL:** llms-txt#dynamic-prompts

@dynamic_prompt
def dynamic_system_prompt(request: ModelRequest) -> str:
    user_name = request.runtime.context.user_name  # [!code highlight]
    system_prompt = f"You are a helpful assistant. Address the user as {user_name}."
    return system_prompt

---

## Format code automatically

**URL:** llms-txt#format-code-automatically

---

## This is our toy user database. Do not do this in production

**URL:** llms-txt#this-is-our-toy-user-database.-do-not-do-this-in-production

VALID_TOKENS = {
    "user1-token": {"id": "user1", "name": "Alice"},
    "user2-token": {"id": "user2", "name": "Bob"},
}

---

## AzureChatOpenAI

**URL:** llms-txt#azurechatopenai

**Contents:**
- Overview
  - Integration details
  - Model features
- Setup
  - Credentials

Source: https://docs.langchain.com/oss/javascript/integrations/chat/azure

Azure OpenAI is a Microsoft Azure service that provides powerful language models from OpenAI.

This will help you getting started with AzureChatOpenAI [chat models](/oss/javascript/langchain/models). For detailed documentation of all AzureChatOpenAI features and configurations head to the [API reference](https://api.js.langchain.com/classes/langchain_openai.AzureChatOpenAI.html).

### Integration details

| Class                                                                                         | Package                                                                | Local | Serializable | [PY support](https://python.langchain.com/docs/integrations/chat/azure_chat_openai) |                                             Downloads                                             |                                             Version                                            |
| :-------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------- | :---: | :----------: | :---------------------------------------------------------------------------------: | :-----------------------------------------------------------------------------------------------: | :--------------------------------------------------------------------------------------------: |
| [AzureChatOpenAI](https://api.js.langchain.com/classes/langchain_openai.AzureChatOpenAI.html) | [`@langchain/openai`](https://www.npmjs.com/package/@langchain/openai) |   ❌   |       ✅      |                                          ✅                                          | ![NPM - Downloads](https://img.shields.io/npm/dm/@langchain/openai?style=flat-square\&label=%20&) | ![NPM - Version](https://img.shields.io/npm/v/@langchain/openai?style=flat-square\&label=%20&) |

See the links in the table headers below for guides on how to use specific features.

| [Tool calling](/oss/javascript/langchain/tools) | [Structured output](/oss/javascript/langchain/structured-output) | JSON mode | [Image input](/oss/javascript/langchain/messages#multimodal) | Audio input | Video input | [Token-level streaming](/oss/javascript/langchain/streaming/) | [Token usage](/oss/javascript/langchain/models#token-usage) | [Logprobs](/oss/javascript/langchain/models#log-probabilities) |
| :---------------------------------------------: | :--------------------------------------------------------------: | :-------: | :----------------------------------------------------------: | :---------: | :---------: | :-----------------------------------------------------------: | :---------------------------------------------------------: | :------------------------------------------------------------: |
|                        ✅                        |                                 ✅                                |     ✅     |                               ✅                              |      ❌      |      ❌      |                               ✅                               |                              ✅                              |                                ✅                               |

[Azure OpenAI](https://azure.microsoft.com/products/ai-services/openai-service/) is a cloud service to help you quickly develop generative AI experiences with a diverse set of prebuilt and curated models from OpenAI, Meta and beyond.

LangChain.js supports integration with [Azure OpenAI](https://azure.microsoft.com/products/ai-services/openai-service/) using the new Azure integration in the [OpenAI SDK](https://github.com/openai/openai-node).

You can learn more about Azure OpenAI and its difference with the OpenAI API on [this page](https://learn.microsoft.com/azure/ai-services/openai/overview).

If you don't have an Azure account, you can [create a free account](https://azure.microsoft.com/free/) to get started.

You'll also need to have an Azure OpenAI instance deployed. You can deploy a version on Azure Portal following [this guide](https://learn.microsoft.com/azure/ai-services/openai/how-to/create-resource?pivots=web-portal).

Once you have your instance running, make sure you have the name of your instance and key. You can find the key in the Azure Portal, under the "Keys and Endpoint" section of your instance. Then, if using Node.js, you can set your credentials as environment variables:

If you want to get automated tracing of your model calls you can also set your [LangSmith](https://docs.smith.langchain.com/) API key by uncommenting below:

```bash  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
If you want to get automated tracing of your model calls you can also set your [LangSmith](https://docs.smith.langchain.com/) API key by uncommenting below:
```

---

## Define target function that uses attachments

**URL:** llms-txt#define-target-function-that-uses-attachments

**Contents:**
  - Define custom evaluators
- Update examples with attachments
- UI
  - 1. Create examples with attachments
  - 2. Create a multimodal prompt
  - Define custom evaluators
  - Update examples with attachments

def file_qa(inputs, attachments):
    # Read the audio bytes from the reader and encode them in base64
    audio_reader = attachments["my_wav"]["reader"]
    audio_b64 = base64.b64encode(audio_reader.read()).decode('utf-8')

audio_completion = client.chat.completions.create(
        model="gpt-4o-audio-preview",
        messages=[
            {
                "role": "user",
                "content": [
                    {
                        "type": "text",
                        "text": inputs["audio_question"]
                    },
                    {
                        "type": "input_audio",
                        "input_audio": {
                            "data": audio_b64,
                            "format": "wav"
                        }
                    }
                ]
            }
        ]
    )

# Most models support taking in an image URL directly in addition to base64 encoded images
    # You can pipe the image pre-signed URL directly to the model
    image_url = attachments["my_img"]["presigned_url"]
    image_completion = client.chat.completions.create(
        model="gpt-4o-mini",
        messages=[
          {
            "role": "user",
            "content": [
              {"type": "text", "text": inputs["image_question"]},
              {
                "type": "image_url",
                "image_url": {
                  "url": image_url,
                },
              },
            ],
          }
        ],
    )

return {
        "audio_answer": audio_completion.choices[0].message.content,
        "image_answer": image_completion.choices[0].message.content,
    }
typescript  theme={null}
{
  presigned_url: string,
  mime_type: string,
}
typescript  theme={null}
import OpenAI from "openai";
import { wrapOpenAI } from "langsmith/wrappers";

const client: any = wrapOpenAI(new OpenAI());

async function fileQA(inputs: Record<string, any>, config?: Record<string, any>) {
  const presignedUrl = config?.attachments?.["my_wav"]?.presigned_url;
  if (!presignedUrl) {
    throw new Error("No presigned URL provided for audio.");
  }

const response = await fetch(presignedUrl);
  if (!response.ok) {
    throw new Error(`Failed to fetch audio: ${response.statusText}`);
  }

const arrayBuffer = await response.arrayBuffer();
  const uint8Array = new Uint8Array(arrayBuffer);
  const audioB64 = Buffer.from(uint8Array).toString("base64");

const audioCompletion = await client.chat.completions.create({
    model: "gpt-4o-audio-preview",
    messages: [
      {
        role: "user",
        content: [
          { type: "text", text: inputs["audio_question"] },
          {
            type: "input_audio",
            input_audio: {
              data: audioB64,
              format: "wav",
            },
          },
        ],
      },
    ],
  });

const imageUrl = config?.attachments?.["my_img"]?.presigned_url
  const imageCompletion = await client.chat.completions.create({
    model: "gpt-4o-mini",
    messages: [
      {
        role: "user",
        content: [
          { type: "text", text: inputs["image_question"] },
          {
            type: "image_url",
            image_url: {
              url: imageUrl,
            },
          },
        ],
      },
    ],
  });

return {
    audio_answer: audioCompletion.choices[0].message.content,
    image_answer: imageCompletion.choices[0].message.content,
  };
}
python Python theme={null}
  # Assumes you've installed pydantic
  from pydantic import BaseModel

def valid_image_description(outputs: dict, attachments: dict) -> bool:
    """Use an LLM to judge if the image description and images are consistent."""
    instructions = """
    Does the description of the following image make sense?
    Please carefully review the image and the description to determine if the description is valid.
    """

class Response(BaseModel):
        description_is_valid: bool

image_url = attachments["my_img"]["presigned_url"]
    response = client.beta.chat.completions.parse(
        model="gpt-4o",
        messages=[
            {
                "role": "system",
                "content": instructions
            },
            {
                "role": "user",
                "content": [
                    {"type": "image_url", "image_url": {"url": image_url}},
                    {"type": "text", "text": outputs["image_answer"]}
                ]
            }
        ],
        response_format=Response
    )
    return response.choices[0].message.parsed.description_is_valid

ls_client.evaluate(
    file_qa,
    data=dataset_name,
    evaluators=[valid_image_description],
  )
  typescript TypeScript theme={null}
  import { zodResponseFormat } from 'openai/helpers/zod';
  import { z } from 'zod';
  import { evaluate } from "langsmith/evaluation";

const DescriptionResponse = z.object({
    description_is_valid: z.boolean(),
  });

async function validImageDescription({
    outputs,
    attachments,
  }: {
    outputs?: any;
    attachments?: any;
  }): Promise<{ key: string; score: boolean}> {
    const instructions = `Does the description of the following image make sense?
  Please carefully review the image and the description to determine if the description is valid.`;

const imageUrl = attachments?.["my_img"]?.presigned_url
    const completion = await client.beta.chat.completions.parse({
        model: "gpt-4o",
        messages: [
            {
                role: "system",
                content: instructions,
            },
            {
                role: "user",
                content: [
                    { type: "image_url", image_url: { url: imageUrl } },
                    { type: "text", text: outputs?.image_answer },
                ],
            },
        ],
        response_format: zodResponseFormat(DescriptionResponse, 'imageResponse'),
    });

const score: boolean = completion.choices[0]?.message?.parsed?.description_is_valid ?? false;
    return { key: "valid_image_description", score };
  }

const resp = await evaluate(fileQA, {
    data: datasetName,
    // Need to pass flag to include attachments
    includeAttachments: true,
    evaluators: [validImageDescription],
    client: langsmithClient
  });
  python Python theme={null}
  example_update = {
    "id": example_id,
    "attachments": {
        # These are net new attachments
        "my_new_file": ("text/plain", b"foo bar"),
    },
    "inputs": inputs,
    "outputs": outputs,
    # Any attachments not in rename/retain will be deleted.
    # In this case, that would be "my_img" if we uploaded it.
    "attachments_operations": {
        # Retained attachments will stay exactly the same
        "retain": ["my_pdf"],
        # Renaming attachments preserves the original data
        "rename": {
            "my_wav": "my_new_wav",
        }
    },
  }

ls_client.update_examples(dataset_id=dataset.id, updates=[example_update])
  typescript TypeScript theme={null}
  import { ExampleUpdateWithAttachments } from "langsmith/schemas";

const exampleUpdate: ExampleUpdateWithAttachments = {
    id: exampleId,
    attachments: {
      // These are net new attachments
      "my_new_file": {
        mimeType: "text/plain",
        data: Buffer.from("foo bar")
      },
    },
    attachments_operations: {
      // Retained attachments will stay exactly the same
      retain: ["my_img"],
      // Renaming attachments preserves the original data
      rename: {
        "my_wav": "my_new_wav",
      },
      // Any attachments not in rename/retain will be deleted
      // In this case, that would be "my_pdf"
    },
  };

await langsmithClient.updateExamplesMultipart(dataset.id, [exampleUpdate]);
  ```
</CodeGroup>

### 1. Create examples with attachments

You can add examples with attachments to a dataset in a few different ways.

#### From existing runs

When adding runs to a LangSmith dataset, attachments can be selectively propagated from the source run to the destination example. To learn more, please see [this guide](/langsmith/manage-datasets-in-application#add-runs-from-the-tracing-project-ui).

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=b8fa62cb39c4f1fc67d9b24fa78d1653" alt="Add trace with attachments to dataset" data-og-width="1662" width="1662" data-og-height="679" height="679" data-path="langsmith/images/add-trace-with-attachments-to-dataset.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=72ee339359616ed8f03f4ddbfe86bc23 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=cb6f558f8a0391588583a7b5d520a27f 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=bc51ed2e68af972e488051fc1ae01caf 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=d58d097b70ad0f6b7a327058c659d8d9 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=cbac645e6534290036d24963c231a878 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/add-trace-with-attachments-to-dataset.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=b4ff5c59dd6c2b23d97bfd5e34206a50 2500w" />

You can create examples with attachments directly from the LangSmith UI. Click the `+ Example` button in the `Examples` tab of the dataset UI. Then upload attachments using the "Upload Files" button:

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=183f929c807f59157e93d40354057933" alt="Create example with attachments" data-og-width="3456" width="3456" data-og-height="1856" height="1856" data-path="langsmith/images/create-example-with-attachments.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=c80316a80e8359d14aa42aac6767b677 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=1921a813aea4e6fa62bcf7cfd169662e 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=35d6882ec8757e56d81eba2033220cf7 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=0b93d237b11ab6bf8693b287ee19dc4b 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=38384c5a8166b41535657ec8a6337b49 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-example-with-attachments.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b0f8622286209391451895c2e4c7b03b 2500w" />

Once uploaded, you can view examples with attachments in the LangSmith UI. Each attachment will be rendered with a preview for easy inspection. <img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=8f813bdf7d3bfd5a840e5f8c47693ed3" alt="Attachments with examples" data-og-width="1331" width="1331" data-og-height="593" height="593" data-path="langsmith/images/attachments-with-examples.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=280&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=0ecc6a1a59da5972731c4f36fc0154d8 280w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=560&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=f7985b2778973b594e8522964eb13770 560w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=840&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=f062086524f7aff66c094ac0e259c04e 840w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=1100&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=970e61cff6a2cfc749c14481afe2a3f9 1100w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=1650&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=4c34be3eb64547daf4879b2f2dab3ec4 1650w, https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachments-with-examples.png?w=2500&fit=max&auto=format&n=E8FdemkcQxROovD9&q=85&s=700119fd1a262ce0f85d924b684141a4 2500w" />

### 2. Create a multimodal prompt

The LangSmith UI allows you to include attachments in your prompts when evaluating multimodal models:

First, click the file icon in the message where you want to add multimodal content. Next, add a template variable for the attachment(s) you want to include for each example.

* For a single attachment type: Use the suggested variable name. Note: all examples must have an attachment with this name.
* For multiple attachments or if your attachments have varying names from one example to another: Use the `All attachments` variable to include all available attachments for each example.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/adding-multimodal-variable.gif?s=07a15c9fc5e6fc743f92b6b41ab8c9e0" alt="Adding multimodal variable" data-og-width="1700" width="1700" data-og-height="1080" height="1080" data-path="langsmith/images/adding-multimodal-variable.gif" data-optimize="true" data-opv="3" />

### Define custom evaluators

<Note>
  The LangSmith playground does not currently support pulling multimodal content into evaluators. If this would be helpful for your use case, please let us know in the [LangChain Forum](https://forum.langchain.com/) (sign up [here](https://www.langchain.com/join-community) if you're not already a member)!
</Note>

You can evaluate a model's text output by adding an evaluator that takes in the example's inputs and outputs. Even without multimodal support in your evaluators, you can still run text-only evaluations. For example:

* OCR → text correction: Use a vision model to extract text from a document, then evaluate the accuracy of the extracted output.
* Speech-to-text → transcription quality: Use a voice model to transcribe audio to text, then evaluate the transcription against your reference.

For more information on defining custom evaluators, see the [LLM as Judge](/langsmith/llm-as-judge) guide.

### Update examples with attachments

<Note>
  Attachments are limited to 20MB in size in the UI.
</Note>

When editing an example in the UI, you can:

* Upload new attachments
* Rename and delete attachments
* Reset attachments to their previous state using the quick reset button

Changes are not saved until you click submit.

<img src="https://mintcdn.com/langchain-5e9cc07a/E8FdemkcQxROovD9/langsmith/images/attachment-editing.gif?s=4f165ed98fe81722961778ebbe1691ed" alt="Attachment editing" data-og-width="1204" width="1204" data-og-height="720" height="720" data-path="langsmith/images/attachment-editing.gif" data-optimize="true" data-opv="3" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/evaluate-with-attachments.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
#### TypeScript

In the TypeScript SDK, the `config` argument is used to pass in the attachments to the target function if `includeAttachments` is set to `true`.

The `config` will contain `attachments` which is an object mapping the attachment name to an object of the form:
```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown
### Define custom evaluators

The exact same rules apply as above to determine whether the evaluator should receive attachments.

The evaluator below uses an LLM to judge if the reasoning and the answer are consistent. To learn more about how to define llm-based evaluators, please see [this guide](/langsmith/llm-as-judge).

<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## Create store with semantic search enabled

**URL:** llms-txt#create-store-with-semantic-search-enabled

**Contents:**
- Manage short-term memory
  - Trim messages
  - Delete messages
  - Summarize messages
  - Manage checkpoints
- Prebuilt memory tools

embeddings = init_embeddings("openai:text-embedding-3-small")
store = InMemoryStore(
    index={
        "embed": embeddings,
        "dims": 1536,
    }
)

store.put(("user_123", "memories"), "1", {"text": "I love pizza"})
store.put(("user_123", "memories"), "2", {"text": "I am a plumber"})

items = store.search(
    ("user_123", "memories"), query="I'm hungry", limit=1
)
python  theme={null}

from langchain.embeddings import init_embeddings
  from langchain.chat_models import init_chat_model
  from langgraph.store.base import BaseStore
  from langgraph.store.memory import InMemoryStore
  from langgraph.graph import START, MessagesState, StateGraph

model = init_chat_model("gpt-4o-mini")

# Create store with semantic search enabled
  embeddings = init_embeddings("openai:text-embedding-3-small")
  store = InMemoryStore(
      index={
          "embed": embeddings,
          "dims": 1536,
      }
  )

store.put(("user_123", "memories"), "1", {"text": "I love pizza"})
  store.put(("user_123", "memories"), "2", {"text": "I am a plumber"})

def chat(state, *, store: BaseStore):
      # Search based on user's last message
      items = store.search(
          ("user_123", "memories"), query=state["messages"][-1].content, limit=2
      )
      memories = "\n".join(item.value["text"] for item in items)
      memories = f"## Memories of user\n{memories}" if memories else ""
      response = model.invoke(
          [
              {"role": "system", "content": f"You are a helpful assistant.\n{memories}"},
              *state["messages"],
          ]
      )
      return {"messages": [response]}

builder = StateGraph(MessagesState)
  builder.add_node(chat)
  builder.add_edge(START, "chat")
  graph = builder.compile(store=store)

for message, metadata in graph.stream(
      input={"messages": [{"role": "user", "content": "I'm hungry"}]},
      stream_mode="messages",
  ):
      print(message.content, end="")
  python  theme={null}
from langchain_core.messages.utils import (  # [!code highlight]
    trim_messages,  # [!code highlight]
    count_tokens_approximately  # [!code highlight]
)  # [!code highlight]

def call_model(state: MessagesState):
    messages = trim_messages(  # [!code highlight]
        state["messages"],
        strategy="last",
        token_counter=count_tokens_approximately,
        max_tokens=128,
        start_on="human",
        end_on=("human", "tool"),
    )
    response = model.invoke(messages)
    return {"messages": [response]}

builder = StateGraph(MessagesState)
builder.add_node(call_model)
...
python  theme={null}
  from langchain_core.messages.utils import (
      trim_messages,  # [!code highlight]
      count_tokens_approximately  # [!code highlight]
  )
  from langchain.chat_models import init_chat_model
  from langgraph.graph import StateGraph, START, MessagesState

model = init_chat_model("claude-sonnet-4-5-20250929")
  summarization_model = model.bind(max_tokens=128)

def call_model(state: MessagesState):
      messages = trim_messages(  # [!code highlight]
          state["messages"],
          strategy="last",
          token_counter=count_tokens_approximately,
          max_tokens=128,
          start_on="human",
          end_on=("human", "tool"),
      )
      response = model.invoke(messages)
      return {"messages": [response]}

checkpointer = InMemorySaver()
  builder = StateGraph(MessagesState)
  builder.add_node(call_model)
  builder.add_edge(START, "call_model")
  graph = builder.compile(checkpointer=checkpointer)

config = {"configurable": {"thread_id": "1"}}
  graph.invoke({"messages": "hi, my name is bob"}, config)
  graph.invoke({"messages": "write a short poem about cats"}, config)
  graph.invoke({"messages": "now do the same but for dogs"}, config)
  final_response = graph.invoke({"messages": "what's my name?"}, config)

final_response["messages"][-1].pretty_print()
  
  ================================== Ai Message ==================================

Your name is Bob, as you mentioned when you first introduced yourself.
  python  theme={null}
from langchain.messages import RemoveMessage  # [!code highlight]

def delete_messages(state):
    messages = state["messages"]
    if len(messages) > 2:
        # remove the earliest two messages
        return {"messages": [RemoveMessage(id=m.id) for m in messages[:2]]}  # [!code highlight]
python  theme={null}
from langgraph.graph.message import REMOVE_ALL_MESSAGES  # [!code highlight]

def delete_messages(state):
    return {"messages": [RemoveMessage(id=REMOVE_ALL_MESSAGES)]}  # [!code highlight]
python  theme={null}
  from langchain.messages import RemoveMessage  # [!code highlight]

def delete_messages(state):
      messages = state["messages"]
      if len(messages) > 2:
          # remove the earliest two messages
          return {"messages": [RemoveMessage(id=m.id) for m in messages[:2]]}  # [!code highlight]

def call_model(state: MessagesState):
      response = model.invoke(state["messages"])
      return {"messages": response}

builder = StateGraph(MessagesState)
  builder.add_sequence([call_model, delete_messages])
  builder.add_edge(START, "call_model")

checkpointer = InMemorySaver()
  app = builder.compile(checkpointer=checkpointer)

for event in app.stream(
      {"messages": [{"role": "user", "content": "hi! I'm bob"}]},
      config,
      stream_mode="values"
  ):
      print([(message.type, message.content) for message in event["messages"]])

for event in app.stream(
      {"messages": [{"role": "user", "content": "what's my name?"}]},
      config,
      stream_mode="values"
  ):
      print([(message.type, message.content) for message in event["messages"]])
  
  [('human', "hi! I'm bob")]
  [('human', "hi! I'm bob"), ('ai', 'Hi Bob! How are you doing today? Is there anything I can help you with?')]
  [('human', "hi! I'm bob"), ('ai', 'Hi Bob! How are you doing today? Is there anything I can help you with?'), ('human', "what's my name?")]
  [('human', "hi! I'm bob"), ('ai', 'Hi Bob! How are you doing today? Is there anything I can help you with?'), ('human', "what's my name?"), ('ai', 'Your name is Bob.')]
  [('human', "what's my name?"), ('ai', 'Your name is Bob.')]
  python  theme={null}
from langgraph.graph import MessagesState
class State(MessagesState):
    summary: str
python  theme={null}
def summarize_conversation(state: State):

# First, we get any existing summary
    summary = state.get("summary", "")

# Create our summarization prompt
    if summary:

# A summary already exists
        summary_message = (
            f"This is a summary of the conversation to date: {summary}\n\n"
            "Extend the summary by taking into account the new messages above:"
        )

else:
        summary_message = "Create a summary of the conversation above:"

# Add prompt to our history
    messages = state["messages"] + [HumanMessage(content=summary_message)]
    response = model.invoke(messages)

# Delete all but the 2 most recent messages
    delete_messages = [RemoveMessage(id=m.id) for m in state["messages"][:-2]]
    return {"summary": response.content, "messages": delete_messages}
python  theme={null}
  from typing import Any, TypedDict

from langchain.chat_models import init_chat_model
  from langchain.messages import AnyMessage
  from langchain_core.messages.utils import count_tokens_approximately
  from langgraph.graph import StateGraph, START, MessagesState
  from langgraph.checkpoint.memory import InMemorySaver
  from langmem.short_term import SummarizationNode, RunningSummary  # [!code highlight]

model = init_chat_model("claude-sonnet-4-5-20250929")
  summarization_model = model.bind(max_tokens=128)

class State(MessagesState):
      context: dict[str, RunningSummary]  # [!code highlight]

class LLMInputState(TypedDict):  # [!code highlight]
      summarized_messages: list[AnyMessage]
      context: dict[str, RunningSummary]

summarization_node = SummarizationNode(  # [!code highlight]
      token_counter=count_tokens_approximately,
      model=summarization_model,
      max_tokens=256,
      max_tokens_before_summary=256,
      max_summary_tokens=128,
  )

def call_model(state: LLMInputState):  # [!code highlight]
      response = model.invoke(state["summarized_messages"])
      return {"messages": [response]}

checkpointer = InMemorySaver()
  builder = StateGraph(State)
  builder.add_node(call_model)
  builder.add_node("summarize", summarization_node)  # [!code highlight]
  builder.add_edge(START, "summarize")
  builder.add_edge("summarize", "call_model")
  graph = builder.compile(checkpointer=checkpointer)

# Invoke the graph
  config = {"configurable": {"thread_id": "1"}}
  graph.invoke({"messages": "hi, my name is bob"}, config)
  graph.invoke({"messages": "write a short poem about cats"}, config)
  graph.invoke({"messages": "now do the same but for dogs"}, config)
  final_response = graph.invoke({"messages": "what's my name?"}, config)

final_response["messages"][-1].pretty_print()
  print("\nSummary:", final_response["context"]["running_summary"].summary)
  
  ================================== Ai Message ==================================

From our conversation, I can see that you introduced yourself as Bob. That's the name you shared with me when we began talking.

Summary: In this conversation, I was introduced to Bob, who then asked me to write a poem about cats. I composed a poem titled "The Mystery of Cats" that captured cats' graceful movements, independent nature, and their special relationship with humans. Bob then requested a similar poem about dogs, so I wrote "The Joy of Dogs," which highlighted dogs' loyalty, enthusiasm, and loving companionship. Both poems were written in a similar style but emphasized the distinct characteristics that make each pet special.
  python  theme={null}
    config = {
        "configurable": {
            "thread_id": "1",  # [!code highlight]
            # optionally provide an ID for a specific checkpoint,
            # otherwise the latest checkpoint is shown
            # "checkpoint_id": "1f029ca3-1f5b-6704-8004-820c16b69a5a"  # [!code highlight]

}
    }
    graph.get_state(config)  # [!code highlight]
    
    StateSnapshot(
        values={'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today?), HumanMessage(content="what's my name?"), AIMessage(content='Your name is Bob.')]}, next=(),
        config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1f5b-6704-8004-820c16b69a5a'}},
        metadata={
            'source': 'loop',
            'writes': {'call_model': {'messages': AIMessage(content='Your name is Bob.')}},
            'step': 4,
            'parents': {},
            'thread_id': '1'
        },
        created_at='2025-05-05T16:01:24.680462+00:00',
        parent_config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
        tasks=(),
        interrupts=()
    )
    python  theme={null}
    config = {
        "configurable": {
            "thread_id": "1",  # [!code highlight]
            # optionally provide an ID for a specific checkpoint,
            # otherwise the latest checkpoint is shown
            # "checkpoint_id": "1f029ca3-1f5b-6704-8004-820c16b69a5a"  # [!code highlight]

}
    }
    checkpointer.get_tuple(config)  # [!code highlight]
    
    CheckpointTuple(
        config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1f5b-6704-8004-820c16b69a5a'}},
        checkpoint={
            'v': 3,
            'ts': '2025-05-05T16:01:24.680462+00:00',
            'id': '1f029ca3-1f5b-6704-8004-820c16b69a5a',
            'channel_versions': {'__start__': '00000000000000000000000000000005.0.5290678567601859', 'messages': '00000000000000000000000000000006.0.3205149138784782', 'branch:to:call_model': '00000000000000000000000000000006.0.14611156755133758'}, 'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000004.0.5736472536395331'}, 'call_model': {'branch:to:call_model': '00000000000000000000000000000005.0.1410174088651449'}},
            'channel_values': {'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today?), HumanMessage(content="what's my name?"), AIMessage(content='Your name is Bob.')]},
        },
        metadata={
            'source': 'loop',
            'writes': {'call_model': {'messages': AIMessage(content='Your name is Bob.')}},
            'step': 4,
            'parents': {},
            'thread_id': '1'
        },
        parent_config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
        pending_writes=[]
    )
    python  theme={null}
    config = {
        "configurable": {
            "thread_id": "1"  # [!code highlight]
        }
    }
    list(graph.get_state_history(config))  # [!code highlight]
    
    [
        StateSnapshot(
            values={'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?'), HumanMessage(content="what's my name?"), AIMessage(content='Your name is Bob.')]},
            next=(),
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1f5b-6704-8004-820c16b69a5a'}},
            metadata={'source': 'loop', 'writes': {'call_model': {'messages': AIMessage(content='Your name is Bob.')}}, 'step': 4, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:24.680462+00:00',
            parent_config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
            tasks=(),
            interrupts=()
        ),
        StateSnapshot(
            values={'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?'), HumanMessage(content="what's my name?")]},
            next=('call_model',),
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
            metadata={'source': 'loop', 'writes': None, 'step': 3, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:23.863421+00:00',
            parent_config={...}
            tasks=(PregelTask(id='8ab4155e-6b15-b885-9ce5-bed69a2c305c', name='call_model', path=('__pregel_pull', 'call_model'), error=None, interrupts=(), state=None, result={'messages': AIMessage(content='Your name is Bob.')}),),
            interrupts=()
        ),
        StateSnapshot(
            values={'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')]},
            next=('__start__',),
            config={...},
            metadata={'source': 'input', 'writes': {'__start__': {'messages': [{'role': 'user', 'content': "what's my name?"}]}}, 'step': 2, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:23.863173+00:00',
            parent_config={...}
            tasks=(PregelTask(id='24ba39d6-6db1-4c9b-f4c5-682aeaf38dcd', name='__start__', path=('__pregel_pull', '__start__'), error=None, interrupts=(), state=None, result={'messages': [{'role': 'user', 'content': "what's my name?"}]}),),
            interrupts=()
        ),
        StateSnapshot(
            values={'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')]},
            next=(),
            config={...},
            metadata={'source': 'loop', 'writes': {'call_model': {'messages': AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')}}, 'step': 1, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:23.862295+00:00',
            parent_config={...}
            tasks=(),
            interrupts=()
        ),
        StateSnapshot(
            values={'messages': [HumanMessage(content="hi! I'm bob")]},
            next=('call_model',),
            config={...},
            metadata={'source': 'loop', 'writes': None, 'step': 0, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:22.278960+00:00',
            parent_config={...}
            tasks=(PregelTask(id='8cbd75e0-3720-b056-04f7-71ac805140a0', name='call_model', path=('__pregel_pull', 'call_model'), error=None, interrupts=(), state=None, result={'messages': AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')}),),
            interrupts=()
        ),
        StateSnapshot(
            values={'messages': []},
            next=('__start__',),
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-0870-6ce2-bfff-1f3f14c3e565'}},
            metadata={'source': 'input', 'writes': {'__start__': {'messages': [{'role': 'user', 'content': "hi! I'm bob"}]}}, 'step': -1, 'parents': {}, 'thread_id': '1'},
            created_at='2025-05-05T16:01:22.277497+00:00',
            parent_config=None,
            tasks=(PregelTask(id='d458367b-8265-812c-18e2-33001d199ce6', name='__start__', path=('__pregel_pull', '__start__'), error=None, interrupts=(), state=None, result={'messages': [{'role': 'user', 'content': "hi! I'm bob"}]}),),
            interrupts=()
        )
    ]
    python  theme={null}
    config = {
        "configurable": {
            "thread_id": "1"  # [!code highlight]
        }
    }
    list(checkpointer.list(config))  # [!code highlight]
    
    [
        CheckpointTuple(
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1f5b-6704-8004-820c16b69a5a'}},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:24.680462+00:00',
                'id': '1f029ca3-1f5b-6704-8004-820c16b69a5a',
                'channel_versions': {'__start__': '00000000000000000000000000000005.0.5290678567601859', 'messages': '00000000000000000000000000000006.0.3205149138784782', 'branch:to:call_model': '00000000000000000000000000000006.0.14611156755133758'},
                'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000004.0.5736472536395331'}, 'call_model': {'branch:to:call_model': '00000000000000000000000000000005.0.1410174088651449'}},
                'channel_values': {'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?'), HumanMessage(content="what's my name?"), AIMessage(content='Your name is Bob.')]},
            },
            metadata={'source': 'loop', 'writes': {'call_model': {'messages': AIMessage(content='Your name is Bob.')}}, 'step': 4, 'parents': {}, 'thread_id': '1'},
            parent_config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
            pending_writes=[]
        ),
        CheckpointTuple(
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-1790-6b0a-8003-baf965b6a38f'}},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:23.863421+00:00',
                'id': '1f029ca3-1790-6b0a-8003-baf965b6a38f',
                'channel_versions': {'__start__': '00000000000000000000000000000005.0.5290678567601859', 'messages': '00000000000000000000000000000006.0.3205149138784782', 'branch:to:call_model': '00000000000000000000000000000006.0.14611156755133758'},
                'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000004.0.5736472536395331'}, 'call_model': {'branch:to:call_model': '00000000000000000000000000000005.0.1410174088651449'}},
                'channel_values': {'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?'), HumanMessage(content="what's my name?")], 'branch:to:call_model': None}
            },
            metadata={'source': 'loop', 'writes': None, 'step': 3, 'parents': {}, 'thread_id': '1'},
            parent_config={...},
            pending_writes=[('8ab4155e-6b15-b885-9ce5-bed69a2c305c', 'messages', AIMessage(content='Your name is Bob.'))]
        ),
        CheckpointTuple(
            config={...},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:23.863173+00:00',
                'id': '1f029ca3-1790-616e-8002-9e021694a0cd',
                'channel_versions': {'__start__': '00000000000000000000000000000004.0.5736472536395331', 'messages': '00000000000000000000000000000003.0.7056767754077798', 'branch:to:call_model': '00000000000000000000000000000003.0.22059023329132854'},
                'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000001.0.7040775356287469'}, 'call_model': {'branch:to:call_model': '00000000000000000000000000000002.0.9300422176788571'}},
                'channel_values': {'__start__': {'messages': [{'role': 'user', 'content': "what's my name?"}]}, 'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')]}
            },
            metadata={'source': 'input', 'writes': {'__start__': {'messages': [{'role': 'user', 'content': "what's my name?"}]}}, 'step': 2, 'parents': {}, 'thread_id': '1'},
            parent_config={...},
            pending_writes=[('24ba39d6-6db1-4c9b-f4c5-682aeaf38dcd', 'messages', [{'role': 'user', 'content': "what's my name?"}]), ('24ba39d6-6db1-4c9b-f4c5-682aeaf38dcd', 'branch:to:call_model', None)]
        ),
        CheckpointTuple(
            config={...},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:23.862295+00:00',
                'id': '1f029ca3-178d-6f54-8001-d7b180db0c89',
                'channel_versions': {'__start__': '00000000000000000000000000000002.0.18673090920108737', 'messages': '00000000000000000000000000000003.0.7056767754077798', 'branch:to:call_model': '00000000000000000000000000000003.0.22059023329132854'},
                'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000001.0.7040775356287469'}, 'call_model': {'branch:to:call_model': '00000000000000000000000000000002.0.9300422176788571'}},
                'channel_values': {'messages': [HumanMessage(content="hi! I'm bob"), AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')]}
            },
            metadata={'source': 'loop', 'writes': {'call_model': {'messages': AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?')}}, 'step': 1, 'parents': {}, 'thread_id': '1'},
            parent_config={...},
            pending_writes=[]
        ),
        CheckpointTuple(
            config={...},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:22.278960+00:00',
                'id': '1f029ca3-0874-6612-8000-339f2abc83b1',
                'channel_versions': {'__start__': '00000000000000000000000000000002.0.18673090920108737', 'messages': '00000000000000000000000000000002.0.30296526818059655', 'branch:to:call_model': '00000000000000000000000000000002.0.9300422176788571'},
                'versions_seen': {'__input__': {}, '__start__': {'__start__': '00000000000000000000000000000001.0.7040775356287469'}},
                'channel_values': {'messages': [HumanMessage(content="hi! I'm bob")], 'branch:to:call_model': None}
            },
            metadata={'source': 'loop', 'writes': None, 'step': 0, 'parents': {}, 'thread_id': '1'},
            parent_config={...},
            pending_writes=[('8cbd75e0-3720-b056-04f7-71ac805140a0', 'messages', AIMessage(content='Hi Bob! How are you doing today? Is there anything I can help you with?'))]
        ),
        CheckpointTuple(
            config={'configurable': {'thread_id': '1', 'checkpoint_ns': '', 'checkpoint_id': '1f029ca3-0870-6ce2-bfff-1f3f14c3e565'}},
            checkpoint={
                'v': 3,
                'ts': '2025-05-05T16:01:22.277497+00:00',
                'id': '1f029ca3-0870-6ce2-bfff-1f3f14c3e565',
                'channel_versions': {'__start__': '00000000000000000000000000000001.0.7040775356287469'},
                'versions_seen': {'__input__': {}},
                'channel_values': {'__start__': {'messages': [{'role': 'user', 'content': "hi! I'm bob"}]}}
            },
            metadata={'source': 'input', 'writes': {'__start__': {'messages': [{'role': 'user', 'content': "hi! I'm bob"}]}}, 'step': -1, 'parents': {}, 'thread_id': '1'},
            parent_config=None,
            pending_writes=[('d458367b-8265-812c-18e2-33001d199ce6', 'messages', [{'role': 'user', 'content': "hi! I'm bob"}]), ('d458367b-8265-812c-18e2-33001d199ce6', 'branch:to:call_model', None)]
        )
    ]
    python  theme={null}
thread_id = "1"
checkpointer.delete_thread(thread_id)
```

## Prebuilt memory tools

**LangMem** is a LangChain-maintained library that offers tools for managing long-term memories in your agent. See the [LangMem documentation](https://langchain-ai.github.io/langmem/) for usage examples.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langgraph/add-memory.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
<Accordion title="Long-term memory with semantic search">
```

Example 2 (unknown):
```unknown
</Accordion>

## Manage short-term memory

With [short-term memory](#add-short-term-memory) enabled, long conversations can exceed the LLM's context window. Common solutions are:

* [Trim messages](#trim-messages): Remove first or last N messages (before calling LLM)
* [Delete messages](#delete-messages) from LangGraph state permanently
* [Summarize messages](#summarize-messages): Summarize earlier messages in the history and replace them with a summary
* [Manage checkpoints](#manage-checkpoints) to store and retrieve message history
* Custom strategies (e.g., message filtering, etc.)

This allows the agent to keep track of the conversation without exceeding the LLM's context window.

### Trim messages

Most LLMs have a maximum supported context window (denominated in tokens). One way to decide when to truncate messages is to count the tokens in the message history and truncate whenever it approaches that limit. If you're using LangChain, you can use the trim messages utility and specify the number of tokens to keep from the list, as well as the `strategy` (e.g., keep the last `max_tokens`) to use for handling the boundary.

To trim message history, use the [`trim_messages`](https://python.langchain.com/api_reference/core/messages/langchain_core.messages.utils.trim_messages.html) function:
```

Example 3 (unknown):
```unknown
<Accordion title="Full example: trim messages">
```

Example 4 (unknown):
```unknown

```

---

## Alice creates an assistant

**URL:** llms-txt#alice-creates-an-assistant

alice_assistant = await alice.assistants.create()
print(f"✅ Alice created assistant: {alice_assistant['assistant_id']}")

---

## LangSmith Observability

**URL:** llms-txt#langsmith-observability

**Contents:**
- Prerequisites
- Enable tracing
- Trace selectively

Source: https://docs.langchain.com/oss/python/langgraph/observability

Traces are a series of steps that your application takes to go from input to output. Each of these individual steps is represented by a run. You can use [LangSmith](https://smith.langchain.com/) to visualize these execution steps. To use it, [enable tracing for your application](/langsmith/trace-with-langgraph). This enables you to do the following:

* [Debug a locally running application](/langsmith/observability-studio#debug-langsmith-traces).
* [Evaluate the application performance](/oss/python/langchain/evals).
* [Monitor the application](/langsmith/dashboards).

Before you begin, ensure you have the following:

* **A LangSmith account**: Sign up (for free) or log in at [smith.langchain.com](https://smith.langchain.com).
* **A LangSmith API key**: Follow the [Create an API key](/langsmith/create-account-api-key#create-an-api-key) guide.

To enable tracing for your application, set the following environment variables:

By default, the trace will be logged to the project with the name `default`. To configure a custom project name, see [Log to a project](#log-to-a-project).

For more information, see [Trace with LangGraph](/langsmith/trace-with-langgraph).

You may opt to trace specific invocations or parts of your application using LangSmith's `tracing_context` context manager:

```python  theme={null}
import langsmith as ls

**Examples:**

Example 1 (unknown):
```unknown
By default, the trace will be logged to the project with the name `default`. To configure a custom project name, see [Log to a project](#log-to-a-project).

For more information, see [Trace with LangGraph](/langsmith/trace-with-langgraph).

## Trace selectively

You may opt to trace specific invocations or parts of your application using LangSmith's `tracing_context` context manager:
```

---

## How to sync prompts with GitHub

**URL:** llms-txt#how-to-sync-prompts-with-github

**Contents:**
- Prerequisites
- Understanding LangSmith "Prompt Commits" and webhooks
- Implementing a FastAPI server for webhook reception
- Configuring the webhook in LangSmith
- The workflow in action
- Beyond a simple commit

Source: https://docs.langchain.com/langsmith/prompt-commit

LangSmith provides a collaborative interface to create, test, and iterate on prompts.

While you can [dynamically fetch prompts](/langsmith/manage-prompts-programmatically#pull-a-prompt) from LangSmith into your application at runtime, you may prefer to sync prompts with your own database or version control system. To support this workflow, LangSmith allows you to receive notifications of prompt updates via webhooks.

**Why sync prompts with GitHub?**

* **Version Control:** Keep your prompts versioned alongside your application code in a familiar system.
* **CI/CD Integration:** Trigger automated staging or production deployments when critical prompts change.

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=a7fd1ae2a70f91c14298803a48785f89" alt="Prompt Webhook Diagram" data-og-width="1336" width="1336" data-og-height="343" height="343" data-path="langsmith/images/prompt-excalidraw.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=02f868ec42337b43a533f23effa76417 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=68806f6d9d1e5b8dbaf49d98294190da 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=133aeb6d3a880b989c2246632b8c0d5d 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=fc7091cce5fec3407e005f798db85544 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=d789978f57574ec4f0c75beac19fc10c 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-excalidraw.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=d6362e5787b7fd1a5db69b3d704912bb 2500w" />

Before we begin, ensure you have the following set up:

1. **GitHub Account:** A standard GitHub account.

2. **GitHub Repository:** Create a new (or choose an existing) repository where your LangSmith prompt manifests will be stored. This could be the same repository as your application code or a dedicated one for prompts.

3. **GitHub Personal Access Token (PAT):**

* LangSmith webhooks don't directly interact with GitHub—they call an intermediary server that *you* create.
   * This server requires a GitHub PAT to authenticate and make commits to your repository.
   * Must include the `repo` scope (`public_repo` is sufficient for public repositories).
   * Go to **GitHub > Settings > Developer settings > Personal access tokens > Tokens (classic)**.
   * Click **Generate new token (classic)**.
   * Name it (e.g., "LangSmith Prompt Sync"), set an expiration, and select the required scopes.
   * Click **Generate token** and **copy it immediately** — it won't be shown again.
   * Store the token securely and provide it as an environment variable to your server.

## Understanding LangSmith "Prompt Commits" and webhooks

In LangSmith, when you save changes to a prompt, you're essentially creating a new version or a "Prompt Commit." These commits are what can trigger webhooks.

The webhook will send a JSON payload containing the new **prompt manifest**.

<Accordion title="Sample Webhook Payload">
  
</Accordion>

<Note>
  It's important to understand that LangSmith webhooks for prompt commits are generally triggered at the **workspace level**. This means if *any* prompt within your LangSmith workspace is modified and a "prompt commit" is saved, the webhook will fire and send the updated manifest of the prompt. The payloads are identifiable by prompt id. Your receiving server should be designed with this in mind.
</Note>

## Implementing a FastAPI server for webhook reception

To effectively process webhook notifications from LangSmith when prompts are updated, an intermediary server application is necessary. This server will act as the receiver for HTTP POST requests sent by LangSmith. For demonstration purposes in this guide, we will outline the creation of a simple FastAPI application to fulfill this role.

This publicly accessible server will be responsible for:

1. **Receiving Webhook Requests:** Listening for incoming HTTP POST requests.
2. **Parsing Payloads:** Extracting and interpreting the JSON-formatted prompt manifest from the request body.
3. **Committing to GitHub:** Programmatically creating a new commit in your specified GitHub repository, containing the updated prompt manifest. This ensures your prompts remain version-controlled and synchronized with changes made in LangSmith.

For deployment, platforms like [Render.com](https://render.com/) (offering a suitable free tier), Vercel, Fly.io, or other cloud providers (AWS, GCP, Azure) can be utilized to host the FastAPI application and obtain a public URL.

The server's core functionality will include an endpoint for webhook reception, logic for parsing the manifest, and integration with the GitHub API (using a Personal Access Token for authentication) to manage commits.

<Accordion title="Minimal FastAPI Server Code ()">
  `main.py`

This server will listen for incoming webhooks from LangSmith and commit the received prompt manifest to your GitHub repository.

**Key aspects of this server:**

* **Configuration (`.env`):** It expects a `.env` file with your `GITHUB_TOKEN`, `GITHUB_REPO_OWNER`, and `GITHUB_REPO_NAME`. You can also customize `GITHUB_FILE_PATH` (default: `LangSmith_prompt_manifest.json`) and `GITHUB_BRANCH` (default: `main`).
  * **GitHub Interaction:** The `commit_manifest_to_github` function handles the logic of fetching the current file's SHA (to update it) and then committing the new manifest content.
  * **Webhook Endpoint (`/webhook/commit`):** This is the URL path your LangSmith webhook will target.
  * **Error Handling:** Basic error handling for GitHub API interactions is included.

**Deploy this server to your chosen platform (e.g., Render) and note down its public URL (e.g., `https://prompt-commit-webhook.onrender.com`).**
</Accordion>

## Configuring the webhook in LangSmith

Once your FastAPI server is deployed and you have its public URL, you can configure the webhook in LangSmith:

1. Navigate to your LangSmith workspace.

2. Go to the **Prompts** section. Here you'll see a list of your prompts.

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=7e61c83cdd67749970d8f0e401066d60" alt="LangSmith Prompts section" data-og-width="2996" width="2996" data-og-height="852" height="852" data-path="langsmith/images/prompt-commit-main.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=f492027577eacd4131954de447fa77f2 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=b5f7ea835f9cddd0724a209869c2512e 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=9aceebb242173d56a79e4974eb0fc7cd 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=2ec5c08e0a4682b84a202ebb52bf981d 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=7dce8f5f164d40ab0f47dbf7e308382e 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-main.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=03f8d9d0d9368ec370a71f7605f019a2 2500w" />

3. On the top right of the Prompts page, click the **+ Webhook** button.

4. You'll be presented with a form to configure your webhook:

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=775cc6392de007e894c42400117d113e" alt="LangSmith Webhook configuration modal" data-og-width="3008" width="3008" data-og-height="1454" height="1454" data-path="langsmith/images/prompt-commit-webhook.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=a1d037dbc657bc0758b444d94d458c91 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=708b8a9d27bd584fdd3a4a8df17be36d 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=080f345e1d97aeac9b0d15a0d762fd42 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=387781e1444e51ff64cc2b0f7f02cd26 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=c855c18d16698e49737ea6f581162970 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-webhook.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=38e417a519b578f880d59a6c23efb102 2500w" />

* **Webhook URL:** Enter the full public URL of your deployed FastAPI server's endpoint. For our example server, this would be `https://prompt-commit-webhook.onrender.com/webhook/commit`.
   * **Headers (Optional):**
     * You can add custom headers that LangSmith will send with each webhook request.

5. **Test the Webhook:** LangSmith provides a "Send Test Notification" button. Use this to send a sample payload to your server. Check your server logs (e.g., on Render) to ensure it receives the request and processes it successfully (or to debug any issues).

6. **Save** the webhook configuration.

## The workflow in action

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=823988be6300f39a6e9de784b34a2a77" alt="Workflow Diagram showing: User saves prompt in LangSmith, LangSmith sends webhook to FastAPI Server, which interacts with GitHub to update files" data-og-width="2922" width="2922" data-og-height="1014" height="1014" data-path="langsmith/images/prompt-sequence-diagram.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=13a26887fccdca822c175912ed7fbd3b 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=07e46cc25aa6d0ebe76b14ce9057936b 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=887758bfcf886c3062177706b7f22fb1 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=a5aa30f606eac545f30a715eccfd80a1 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=32cae9f09ec30759550214f3c3e490ff 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-sequence-diagram.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=bced33a052aa88056de397389f9f7d64 2500w" />

Now, with everything set up, here's what happens:

1. **Prompt Modification:** A user (developer or non-technical team member) modifies a prompt in the LangSmith UI and saves it, creating a new "prompt commit."

2. **Webhook Trigger:** LangSmith detects this new prompt commit and triggers the configured webhook.

3. **HTTP Request:** LangSmith sends an HTTP POST request to the public URL of your FastAPI server (e.g., `https://prompt-commit-webhook.onrender.com/webhook/commit`). The body of this request contains the JSON prompt manifest for the entire workspace.

4. **Server Receives Payload:** Your FastAPI server's endpoint receives the request.

5. **GitHub Commit:** The server parses the JSON manifest from the request body. It then uses the configured GitHub Personal Access Token, repository owner, repository name, file path, and branch to:

* Check if the manifest file already exists in the repository on the specified branch to get its SHA (this is necessary for updating an existing file).
   * Create a new commit with the latest prompt manifest, either creating the file or updating it if it already exists. The commit message will indicate that it's an update from LangSmith.

6. **Confirmation:** You should see the new commit appear in your GitHub repository.

<img src="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=213d6364ce20e4acf4e3eb7fe8c1b13d" alt="Manifest commited to Github" data-og-width="2982" width="2982" data-og-height="1270" height="1270" data-path="langsmith/images/prompt-commit-github.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=280&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=f03e1a469e28196f66bc1f92993e6045 280w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=560&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=645f3cf20850a03a89a2e56a53d95719 560w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=840&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=418f7716a8521e3d57a4381d4ebd4d08 840w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=1100&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=34af751c0c20b176c715f0c6f86654f1 1100w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=1650&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=13309faa18bde23df5e6df56521823fb 1650w, https://mintcdn.com/langchain-5e9cc07a/H9jA2WRyA-MV4-H0/langsmith/images/prompt-commit-github.png?w=2500&fit=max&auto=format&n=H9jA2WRyA-MV4-H0&q=85&s=f17d618b6d8e237aa8be023cccea4fd3 2500w" />

You've now successfully synced your LangSmith prompts with GitHub!

## Beyond a simple commit

Our example FastAPI server performs a direct commit of the entire prompt manifest. However, this is just the starting point. You can extend the server's functionality to perform more sophisticated actions:

* **Granular Commits:** Parse the manifest and commit changes to individual prompt files if you prefer a more granular structure in your repository.
* **Trigger CI/CD:** Instead of (or in addition to) committing, have the server trigger a CI/CD pipeline (e.g., Jenkins, GitHub Actions, GitLab CI) to deploy a staging environment, run tests, or build new application versions.
* **Update Databases/Caches:** If your application loads prompts from a database or cache, update these stores directly.
* **Notifications:** Send notifications to Slack, email, or other communication channels about prompt changes.
* **Selective Processing:** Based on metadata within the LangSmith payload (if available, e.g., which specific prompt changed or by whom), you could apply different logic.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/prompt-commit.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Accordion>

<Note>
  It's important to understand that LangSmith webhooks for prompt commits are generally triggered at the **workspace level**. This means if *any* prompt within your LangSmith workspace is modified and a "prompt commit" is saved, the webhook will fire and send the updated manifest of the prompt. The payloads are identifiable by prompt id. Your receiving server should be designed with this in mind.
</Note>

## Implementing a FastAPI server for webhook reception

To effectively process webhook notifications from LangSmith when prompts are updated, an intermediary server application is necessary. This server will act as the receiver for HTTP POST requests sent by LangSmith. For demonstration purposes in this guide, we will outline the creation of a simple FastAPI application to fulfill this role.

This publicly accessible server will be responsible for:

1. **Receiving Webhook Requests:** Listening for incoming HTTP POST requests.
2. **Parsing Payloads:** Extracting and interpreting the JSON-formatted prompt manifest from the request body.
3. **Committing to GitHub:** Programmatically creating a new commit in your specified GitHub repository, containing the updated prompt manifest. This ensures your prompts remain version-controlled and synchronized with changes made in LangSmith.

For deployment, platforms like [Render.com](https://render.com/) (offering a suitable free tier), Vercel, Fly.io, or other cloud providers (AWS, GCP, Azure) can be utilized to host the FastAPI application and obtain a public URL.

The server's core functionality will include an endpoint for webhook reception, logic for parsing the manifest, and integration with the GitHub API (using a Personal Access Token for authentication) to manage commits.

<Accordion title="Minimal FastAPI Server Code ()">
  `main.py`

  This server will listen for incoming webhooks from LangSmith and commit the received prompt manifest to your GitHub repository.
```

---

## Create child run

**URL:** llms-txt#create-child-run

child_run_id = uuid4()
post_run(child_run_id, "OpenAI Call", "llm", {"messages": messages}, parent_run_id)

---

## Prevent logging of sensitive data in traces

**URL:** llms-txt#prevent-logging-of-sensitive-data-in-traces

**Contents:**
- Rule-based masking of inputs and outputs
- Processing Inputs & Outputs for a Single Function
- Quick starts
  - Regex

Source: https://docs.langchain.com/langsmith/mask-inputs-outputs

In some situations, you may need to prevent the inputs and outputs of your traces from being logged for privacy or security reasons. LangSmith provides a way to filter the inputs and outputs of your traces before they are sent to the LangSmith backend.

If you want to completely hide the inputs and outputs of your traces, you can set the following environment variables when running your application:

This works for both the LangSmith SDK (Python and TypeScript) and LangChain.

You can also customize and override this behavior for a given `Client` instance. This can be done by setting the `hide_inputs` and `hide_outputs` parameters on the `Client` object (`hideInputs` and `hideOutputs` in TypeScript).

For the example below, we will simply return an empty object for both `hide_inputs` and `hide_outputs`, but you can customize this to your needs.

## Rule-based masking of inputs and outputs

<Info>
  This feature is available in the following LangSmith SDK versions:

* Python: 0.1.81 and above
  * TypeScript: 0.1.33 and above
</Info>

To mask specific data in inputs and outputs, you can use the `create_anonymizer` / `createAnonymizer` function and pass the newly created anonymizer when instantiating the client. The anonymizer can be either constructed from a list of regex patterns and the replacement values or from a function that accepts and returns a string value.

The anonymizer will be skipped for inputs if `LANGSMITH_HIDE_INPUTS = true`. Same applies for outputs if `LANGSMITH_HIDE_OUTPUTS = true`.

However, if inputs or outputs are to be sent to client, the `anonymizer` method will take precedence over functions found in `hide_inputs` and `hide_outputs`. By default, the `create_anonymizer` will only look at maximum of 10 nesting levels deep, which can be configured via the `max_depth` parameter.

Please note, that using the anonymizer might incur a performance hit with complex regular expressions or large payloads, as the anonymizer serializes the payload to JSON before processing.

<Note>
  Improving the performance of `anonymizer` API is on our roadmap! If you are encountering performance issues, please contact us at [support@langchain.dev](mailto:support@langchain.dev).
</Note>

<img src="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=ac9ba9a6729029a7fa38da03e1466a1a" alt="" data-og-width="1708" width="1708" data-og-height="717" height="717" data-path="langsmith/images/hide-inputs-outputs.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=280&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=7ded12c0345f47d55e9802083c5032d0 280w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=560&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8cbe74d09660d8c65e8a75dd78cdb24e 560w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=840&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=8cb8c0b5c926e46522b9539b0262ee7a 840w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=1100&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=9b8ef244796fad943ec76b0aa5733f80 1100w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=1650&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=87f35d63f42f05c49a220d5b8a87787a 1650w, https://mintcdn.com/langchain-5e9cc07a/0B2PFrFBMRWNccee/langsmith/images/hide-inputs-outputs.png?w=2500&fit=max&auto=format&n=0B2PFrFBMRWNccee&q=85&s=5173e30032c065646c13e9b9c6a95fb5 2500w" />

Older versions of LangSmith SDKs can use the `hide_inputs` and `hide_outputs` parameters to achieve the same effect. You can also use these parameters to process the inputs and outputs more efficiently as well.

## Processing Inputs & Outputs for a Single Function

<Info>
  The `process_outputs` parameter is available in LangSmith SDK version 0.1.98 and above for Python.
</Info>

In addition to client-level input and output processing, LangSmith provides function-level processing through the `process_inputs` and `process_outputs` parameters of the `@traceable` decorator.

These parameters accept functions that allow you to transform the inputs and outputs of a specific function before they are logged to LangSmith. This is useful for reducing payload size, removing sensitive information, or customizing how an object should be serialized and represented in LangSmith for a particular function.

Here's an example of how to use `process_inputs` and `process_outputs`:

In this example, `process_inputs` creates a new dictionary with processed input data, and `process_outputs` transforms the output into a specific format before logging to LangSmith.

<Warning>
  It's recommended to avoid mutating the source objects in the processor functions. Instead, create and return new objects with the processed data.
</Warning>

For asynchronous functions, the usage is similar:

These function-level processors take precedence over client-level processors (`hide_inputs` and `hide_outputs`) when both are defined.

You can combine rule-based masking with various anonymizers to scrub sensitive information from inputs and outputs. In this how-to-guide, we'll cover working with regex, Microsoft Presidio, and Amazon Comprehend.

<Info>
  The implementation below is not exhaustive and may miss some formats or edge cases. Test any implementation thoroughly before using it in production.
</Info>

You can use regex to mask inputs and outputs before they are sent to LangSmith. The implementation below masks email addresses, phone numbers, full names, credit card numbers, and SSNs.

```python  theme={null}
import re
import openai
from langsmith import Client
from langsmith.wrappers import wrap_openai

**Examples:**

Example 1 (unknown):
```unknown
This works for both the LangSmith SDK (Python and TypeScript) and LangChain.

You can also customize and override this behavior for a given `Client` instance. This can be done by setting the `hide_inputs` and `hide_outputs` parameters on the `Client` object (`hideInputs` and `hideOutputs` in TypeScript).

For the example below, we will simply return an empty object for both `hide_inputs` and `hide_outputs`, but you can customize this to your needs.

<CodeGroup>
```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown
</CodeGroup>

## Rule-based masking of inputs and outputs

<Info>
  This feature is available in the following LangSmith SDK versions:

  * Python: 0.1.81 and above
  * TypeScript: 0.1.33 and above
</Info>

To mask specific data in inputs and outputs, you can use the `create_anonymizer` / `createAnonymizer` function and pass the newly created anonymizer when instantiating the client. The anonymizer can be either constructed from a list of regex patterns and the replacement values or from a function that accepts and returns a string value.

The anonymizer will be skipped for inputs if `LANGSMITH_HIDE_INPUTS = true`. Same applies for outputs if `LANGSMITH_HIDE_OUTPUTS = true`.

However, if inputs or outputs are to be sent to client, the `anonymizer` method will take precedence over functions found in `hide_inputs` and `hide_outputs`. By default, the `create_anonymizer` will only look at maximum of 10 nesting levels deep, which can be configured via the `max_depth` parameter.

<CodeGroup>
```

Example 4 (unknown):
```unknown

```

---

## Query traces (SDK)

**URL:** llms-txt#query-traces-(sdk)

**Contents:**
- Use filter arguments
  - List all runs in a project
  - List LLM and Chat runs in the last 24 hours
  - List root runs in a project
  - List runs without errors
  - List runs by run ID
- Use filter query language
  - List all root runs in a conversational thread
  - List all runs called "extractor" whose root of the trace was assigned feedback "user\_score" score of 1
  - List runs with "star\_rating" key whose score is greater than 4

Source: https://docs.langchain.com/langsmith/export-traces

<Tip>
  **Recommended Reading**

Before diving into this content, it might be helpful to read the following:

* [Run (span) data format](/langsmith/run-data-format)
  * <RegionalUrl type="api" suffix="/redoc" text="LangSmith API Reference" />
  * [LangSmith trace query syntax](/langsmith/trace-query-syntax)
</Tip>

<Note>
  **If you are looking to export a large volume of traces, we recommend that you use the [Bulk Data Export](./data-export) functionality, as it will better handle large data volumes and will support automatic retries and parallelization across partitions.**
</Note>

The recommended way to query runs (the span data in LangSmith traces) is to use the `list_runs` method in the SDK or `/runs/query` endpoint in the API.

LangSmith stores traces in a simple format that is specified in the [Run (span) data format](/langsmith/run-data-format).

## Use filter arguments

For simple queries, you don't have to rely on our query syntax. You can use the filter arguments specified in the [filter arguments reference](/langsmith/trace-query-syntax#filter-arguments).

<Warning>
  **Prerequisites**

Initialize the client before running the below code snippets.
</Warning>

Below are some examples of ways to list runs using keyword arguments:

### List all runs in a project

### List LLM and Chat runs in the last 24 hours

### List root runs in a project

Root runs are runs that have no parents. These are assigned a value of `True` for `is_root`. You can use this to filter for root runs.

### List runs without errors

### List runs by run ID

<Warning>
  **Ignores Other Arguments**

If you provide a list of run IDs in the way described above, it will ignore all other filtering arguments like `project_name`, `run_type`, etc. and directly return the runs matching the given IDs.
</Warning>

If you have a list of run IDs, you can list them directly:

## Use filter query language

For more complex queries, you can use the query language described in the [filter query language reference](/langsmith/trace-query-syntax#filter-query-language).

### List all root runs in a conversational thread

This is the way to fetch runs in a conversational thread. For more information on setting up threads, refer to our [how-to guide on setting up threads](./threads).
Threads are grouped by setting a shared thread ID. The LangSmith UI lets you use any one of the following three metadata keys: `session_id`, `conversation_id`, or `thread_id`. The session ID is also known as the tracing project ID. The following query matches on any of them.

### List all runs called "extractor" whose root of the trace was assigned feedback "user\_score" score of 1

### List runs with "star\_rating" key whose score is greater than 4

### List runs that took longer than 5 seconds to complete

### List all runs that have "error" not equal to null

### List all runs where start\_time is greater than a specific timestamp

### List all runs that contain the string "substring"

### List all runs that are tagged with the git hash "2aa1cf4"

### List all runs that started after a specific timestamp and either have "error" not equal to null or a "Correctness" feedback score equal to 0

### Complex query: List all runs where tags include "experimental" or "beta" and latency is greater than 2 seconds

### Search trace trees by full text

You can use the `search()` function without any specific field to do a full text search across all string fields in a run. This allows you to quickly find traces that match a search term.

### Check for presence of metadata

If you want to check for the presence of metadata, you can use the `eq` operator, optionally with an `and` statement to match by value. This is useful if you want to log more structured information about your runs.

### Check for environment details in metadata

A common pattern is to add environment information to your traces via metadata. If you want to filter for runs containing environment metadata, you can use the same pattern as above:

### Check for conversation ID in metadata

Another common way to associate traces in the same conversation is by using a shared conversation ID. If you want to filter runs based on a conversation ID in this way, you can search for that ID in the metadata.

### Negative filtering on key-value pairs

You can use negative filtering on metadata, input, and output key-value pairs to exclude specific runs from your results. Here are some examples for metadata key-value pairs but the same logic applies to input and output key-value pairs.

### Combine multiple filters

If you want to combine multiple conditions to refine your search, you can use the `and` operator along with other filtering functions. Here's how you can search for runs named "ChatOpenAI" that also have a specific `conversation_id` in their metadata:

List all runs named "RetrieveDocs" whose root run has a "user\_score" feedback of 1 and any run in the full trace is named "ExpandQuery".

This type of query is useful if you want to extract a specific run conditional on various states or steps being reached within the trace.

### Advanced: export flattened trace view with child tool usage

The following Python example demonstrates how to export a flattened view of traces, including information on the tools (from nested runs) used by the agent within each trace.
This can be used to analyze the behavior of your agents across multiple traces.

This example queries all tool runs within a specified number of days and groups them by their parent (root) run ID. It then fetches the relevant information for each root run, such as the run name, inputs, outputs, and combines that information with the child run information.

To optimize the query, the example:

1. Selects only the necessary fields when querying tool runs to reduce query time.
2. Fetches root runs in batches while processing tool runs concurrently.

<CodeGroup>
  
</CodeGroup>

### Advanced: export retriever IO for traces with feedback

This query is useful if you want to fine-tune embeddings or diagnose end-to-end system performance issues based on retriever behavior.
The following Python example demonstrates how to export retriever inputs and outputs within traces that have a specific feedback score.

<CodeGroup>
  
</CodeGroup>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/export-traces.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

Below are some examples of ways to list runs using keyword arguments:

### List all runs in a project

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown
</CodeGroup>

### List LLM and Chat runs in the last 24 hours

<CodeGroup>
```

---

## Schema for structured output

**URL:** llms-txt#schema-for-structured-output

from pydantic import BaseModel, Field

class SearchQuery(BaseModel):
    search_query: str = Field(None, description="Query that is optimized web search.")
    justification: str = Field(
        None, description="Why this query is relevant to the user's request."
    )

---

## Thread 1: Write to long-term memory

**URL:** llms-txt#thread-1:-write-to-long-term-memory

config1 = {"configurable": {"thread_id": str(uuid.uuid4())}}
agent.invoke({
    "messages": [{"role": "user", "content": "Save my preferences to /memories/preferences.txt"}]
}, config=config1)

---

## Update the user_name in the agent state

**URL:** llms-txt#update-the-user_name-in-the-agent-state

@tool
def update_user_name(
    new_name: str,
    runtime: ToolRuntime
) -> Command:
    """Update the user's name."""
    return Command(update={"user_name": new_name})
python  theme={null}
from dataclasses import dataclass
from langchain_openai import ChatOpenAI
from langchain.agents import create_agent
from langchain.tools import tool, ToolRuntime

USER_DATABASE = {
    "user123": {
        "name": "Alice Johnson",
        "account_type": "Premium",
        "balance": 5000,
        "email": "alice@example.com"
    },
    "user456": {
        "name": "Bob Smith",
        "account_type": "Standard",
        "balance": 1200,
        "email": "bob@example.com"
    }
}

@dataclass
class UserContext:
    user_id: str

@tool
def get_account_info(runtime: ToolRuntime[UserContext]) -> str:
    """Get the current user's account information."""
    user_id = runtime.context.user_id

if user_id in USER_DATABASE:
        user = USER_DATABASE[user_id]
        return f"Account holder: {user['name']}\nType: {user['account_type']}\nBalance: ${user['balance']}"
    return "User not found"

model = ChatOpenAI(model="gpt-4o")
agent = create_agent(
    model,
    tools=[get_account_info],
    context_schema=UserContext,
    system_prompt="You are a financial assistant."
)

result = agent.invoke(
    {"messages": [{"role": "user", "content": "What's my current balance?"}]},
    context=UserContext(user_id="user123")
)
python expandable theme={null}
from typing import Any
from langgraph.store.memory import InMemoryStore
from langchain.agents import create_agent
from langchain.tools import tool, ToolRuntime

**Examples:**

Example 1 (unknown):
```unknown
#### Context

Access immutable configuration and contextual data like user IDs, session details, or application-specific configuration through `runtime.context`.

Tools can access runtime context through `ToolRuntime`:
```

Example 2 (unknown):
```unknown
#### Memory (Store)

Access persistent data across conversations using the store. The store is accessed via `runtime.store` and allows you to save and retrieve user-specific or application-specific data.

Tools can access and update the store through `ToolRuntime`:
```

---

## You can access the store directly to get the value

**URL:** llms-txt#you-can-access-the-store-directly-to-get-the-value

store.get(("users",), "user_123").value
```

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langchain/long-term-memory.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Our SQL queries will only work if we filter on the exact string values that are in the DB.

**URL:** llms-txt#our-sql-queries-will-only-work-if-we-filter-on-the-exact-string-values-that-are-in-the-db.

---

## Chat models

**URL:** llms-txt#chat-models

**Contents:**
- Featured providers
- Chat Completions API
- All chat models

Source: https://docs.langchain.com/oss/python/integrations/chat/index

[Chat models](/oss/python/langchain/models) are language models that use a sequence of [messages](/oss/python/langchain/messages) as inputs and return messages as outputs <Tooltip tip="Older models that do not follow the chat model interface and instead use an interface that takes a string as input and returns a string as output. These models typically do not include the prefix 'Chat' in their name or include 'LLM' as a suffix.">(as opposed to traditional, plaintext LLMs)</Tooltip>.

## Featured providers

<Info>
  **While these LangChain classes support the indicated advanced feature**, you may need to refer to provider-specific documentation to learn which hosted models or backends support the feature.
</Info>

| Model                                                                          | [Tool calling](/oss/python/langchain/tools) | [Structured output](/oss/python/langchain/structured-output/) | JSON mode | Local | [Multimodal](/oss/python/langchain/messages#multimodal) |
| ------------------------------------------------------------------------------ | ------------------------------------------- | ------------------------------------------------------------- | --------- | ----- | ------------------------------------------------------- |
| [`ChatAnthropic`](/oss/python/integrations/chat/anthropic)                     | ✅                                           | ✅                                                             | ❌         | ❌     | ✅                                                       |
| [`ChatOpenAI`](/oss/python/integrations/chat/openai)                           | ✅                                           | ✅                                                             | ✅         | ❌     | ✅                                                       |
| [`AzureChatOpenAI`](/oss/python/integrations/chat/azure_chat_openai)           | ✅                                           | ✅                                                             | ✅         | ❌     | ✅                                                       |
| [`ChatVertexAI`](/oss/python/integrations/chat/google_vertex_ai)               | ✅                                           | ✅                                                             | ❌         | ❌     | ✅                                                       |
| [`ChatGoogleGenerativeAI`](/oss/python/integrations/chat/google_generative_ai) | ✅                                           | ✅                                                             | ❌         | ❌     | ✅                                                       |
| [`ChatGroq`](/oss/python/integrations/chat/groq)                               | ✅                                           | ✅                                                             | ✅         | ❌     | ❌                                                       |
| [`ChatBedrock`](/oss/python/integrations/chat/bedrock)                         | ✅                                           | ✅                                                             | ❌         | ❌     | ❌                                                       |
| [`ChatHuggingFace`](/oss/python/integrations/chat/huggingface)                 | ✅                                           | ✅                                                             | ❌         | ✅     | ❌                                                       |
| [`ChatOllama`](/oss/python/integrations/chat/ollama)                           | ✅                                           | ✅                                                             | ✅         | ✅     | ❌                                                       |
| [`ChatWatsonx`](/oss/python/integrations/chat/ibm_watsonx)                     | ✅                                           | ✅                                                             | ✅         | ❌     | ✅                                                       |
| [`ChatXAI`](/oss/python/integrations/chat/xai)                                 | ✅                                           | ✅                                                             | ❌         | ❌     | ❌                                                       |
| [`ChatNVIDIA`](/oss/python/integrations/chat/nvidia_ai_endpoints)              | ✅                                           | ✅                                                             | ✅         | ✅     | ✅                                                       |
| [`ChatCohere`](/oss/python/integrations/chat/cohere)                           | ✅                                           | ✅                                                             | ❌         | ❌     | ❌                                                       |
| [`ChatMistralAI`](/oss/python/integrations/chat/mistralai)                     | ✅                                           | ✅                                                             | ❌         | ❌     | ❌                                                       |
| [`ChatTogether`](/oss/python/integrations/chat/together)                       | ✅                                           | ✅                                                             | ✅         | ❌     | ❌                                                       |
| [`ChatFireworks`](/oss/python/integrations/chat/fireworks)                     | ✅                                           | ✅                                                             | ✅         | ❌     | ❌                                                       |
| [`ChatLlamaCpp`](/oss/python/integrations/chat/llamacpp)                       | ✅                                           | ✅                                                             | ❌         | ✅     | ❌                                                       |
| [`ChatDatabricks`](/oss/python/integrations/chat/databricks)                   | ✅                                           | ✅                                                             | ❌         | ❌     | ❌                                                       |
| [`ChatPerplexity`](/oss/python/integrations/chat/perplexity)                   | ❌                                           | ✅                                                             | ✅         | ❌     | ✅                                                       |

## Chat Completions API

Certain model providers offer endpoints that are compatible with OpenAI's [Chat Completions API](https://platform.openai.com/docs/api-reference/chat). In such case, you can use [`ChatOpenAI`](/oss/python/integrations/chat/openai) with a custom `base_url` to connect to these endpoints.

<Accordion title="Example: OpenRouter">
  To use OpenRouter, you will need to sign up for an account and obtain an [API key](https://openrouter.ai/docs/api-reference/authentication).

Refer to the [OpenRouter documentation](https://openrouter.ai/docs/quickstart) for more details.

<Note>
    To capture [reasoning tokens](https://openrouter.ai/docs/use-cases/reasoning-tokens),

1. Switch imports from `langchain_openai` to `langchain_deepseek`
    2. Use `ChatDeepSeek` instead of `ChatOpenAI`. You will need to change param `base_url` to `api_base`.
    3. Adjust reasoning parameters as needed under `extra_body`, e.g.:

This is a known limitation with `ChatOpenAI` and will be addressed in a future release.
  </Note>
</Accordion>

<Columns cols={3}>
  <Card title="Abso" icon="link" href="/oss/python/integrations/chat/abso" arrow="true" cta="View guide" />

<Card title="AI21 Labs" icon="link" href="/oss/python/integrations/chat/ai21" arrow="true" cta="View guide" />

<Card title="AI/ML API" icon="link" href="/oss/python/integrations/chat/aimlapi" arrow="true" cta="View guide" />

<Card title="Alibaba Cloud PAI EAS" icon="link" href="/oss/python/integrations/chat/alibaba_cloud_pai_eas" arrow="true" cta="View guide" />

<Card title="Anthropic" icon="link" href="/oss/python/integrations/chat/anthropic" arrow="true" cta="View guide" />

<Card title="AzureAIChatCompletionsModel" icon="link" href="/oss/python/integrations/chat/azure_ai" arrow="true" cta="View guide" />

<Card title="Azure OpenAI" icon="link" href="/oss/python/integrations/chat/azure_chat_openai" arrow="true" cta="View guide" />

<Card title="Azure ML Endpoint" icon="link" href="/oss/python/integrations/chat/azureml_chat_endpoint" arrow="true" cta="View guide" />

<Card title="Baichuan Chat" icon="link" href="/oss/python/integrations/chat/baichuan" arrow="true" cta="View guide" />

<Card title="Baidu Qianfan" icon="link" href="/oss/python/integrations/chat/baidu_qianfan_endpoint" arrow="true" cta="View guide" />

<Card title="Baseten" icon="link" href="/oss/python/integrations/chat/baseten" arrow="true" cta="View guide" />

<Card title="AWS Bedrock" icon="link" href="/oss/python/integrations/chat/bedrock" arrow="true" cta="View guide" />

<Card title="Cerebras" icon="link" href="/oss/python/integrations/chat/cerebras" arrow="true" cta="View guide" />

<Card title="CloudflareWorkersAI" icon="link" href="/oss/python/integrations/chat/cloudflare_workersai" arrow="true" cta="View guide" />

<Card title="Cohere" icon="link" href="/oss/python/integrations/chat/cohere" arrow="true" cta="View guide" />

<Card title="ContextualAI" icon="link" href="/oss/python/integrations/chat/contextual" arrow="true" cta="View guide" />

<Card title="Coze Chat" icon="link" href="/oss/python/integrations/chat/coze" arrow="true" cta="View guide" />

<Card title="Dappier AI" icon="link" href="/oss/python/integrations/chat/dappier" arrow="true" cta="View guide" />

<Card title="Databricks" icon="link" href="/oss/python/integrations/chat/databricks" arrow="true" cta="View guide" />

<Card title="DeepInfra" icon="link" href="/oss/python/integrations/chat/deepinfra" arrow="true" cta="View guide" />

<Card title="DeepSeek" icon="link" href="/oss/python/integrations/chat/deepseek" arrow="true" cta="View guide" />

<Card title="Eden AI" icon="link" href="/oss/python/integrations/chat/edenai" arrow="true" cta="View guide" />

<Card title="EverlyAI" icon="link" href="/oss/python/integrations/chat/everlyai" arrow="true" cta="View guide" />

<Card title="Featherless AI" icon="link" href="/oss/python/integrations/chat/featherless_ai" arrow="true" cta="View guide" />

<Card title="Fireworks" icon="link" href="/oss/python/integrations/chat/fireworks" arrow="true" cta="View guide" />

<Card title="ChatFriendli" icon="link" href="/oss/python/integrations/chat/friendli" arrow="true" cta="View guide" />

<Card title="Google Gemini" icon="link" href="/oss/python/integrations/chat/google_generative_ai" arrow="true" cta="View guide" />

<Card title="Google Cloud Vertex AI" icon="link" href="/oss/python/integrations/chat/google_vertex_ai" arrow="true" cta="View guide" />

<Card title="GPTRouter" icon="link" href="/oss/python/integrations/chat/gpt_router" arrow="true" cta="View guide" />

<Card title="DigitalOcean Gradient" icon="link" href="/oss/python/integrations/chat/gradientai" arrow="true" cta="View guide" />

<Card title="GreenNode" icon="link" href="/oss/python/integrations/chat/greennode" arrow="true" cta="View guide" />

<Card title="Groq" icon="link" href="/oss/python/integrations/chat/groq" arrow="true" cta="View guide" />

<Card title="ChatHuggingFace" icon="link" href="/oss/python/integrations/chat/huggingface" arrow="true" cta="View guide" />

<Card title="IBM watsonx.ai" icon="link" href="/oss/python/integrations/chat/ibm_watsonx" arrow="true" cta="View guide" />

<Card title="JinaChat" icon="link" href="/oss/python/integrations/chat/jinachat" arrow="true" cta="View guide" />

<Card title="Kinetica" icon="link" href="/oss/python/integrations/chat/kinetica" arrow="true" cta="View guide" />

<Card title="Konko" icon="link" href="/oss/python/integrations/chat/konko" arrow="true" cta="View guide" />

<Card title="LiteLLM" icon="link" href="/oss/python/integrations/chat/litellm" arrow="true" cta="View guide" />

<Card title="Llama 2 Chat" icon="link" href="/oss/python/integrations/chat/llama2_chat" arrow="true" cta="View guide" />

<Card title="Llama API" icon="link" href="/oss/python/integrations/chat/llama_api" arrow="true" cta="View guide" />

<Card title="LlamaEdge" icon="link" href="/oss/python/integrations/chat/llama_edge" arrow="true" cta="View guide" />

<Card title="Llama.cpp" icon="link" href="/oss/python/integrations/chat/llamacpp" arrow="true" cta="View guide" />

<Card title="maritalk" icon="link" href="/oss/python/integrations/chat/maritalk" arrow="true" cta="View guide" />

<Card title="MiniMax" icon="link" href="/oss/python/integrations/chat/minimax" arrow="true" cta="View guide" />

<Card title="MistralAI" icon="link" href="/oss/python/integrations/chat/mistralai" arrow="true" cta="View guide" />

<Card title="MLX" icon="link" href="/oss/python/integrations/chat/mlx" arrow="true" cta="View guide" />

<Card title="ModelScope" icon="link" href="/oss/python/integrations/chat/modelscope_chat_endpoint" arrow="true" cta="View guide" />

<Card title="Moonshot" icon="link" href="/oss/python/integrations/chat/moonshot" arrow="true" cta="View guide" />

<Card title="Naver" icon="link" href="/oss/python/integrations/chat/naver" arrow="true" cta="View guide" />

<Card title="Nebius" icon="link" href="/oss/python/integrations/chat/nebius" arrow="true" cta="View guide" />

<Card title="Netmind" icon="link" href="/oss/python/integrations/chat/netmind" arrow="true" cta="View guide" />

<Card title="NVIDIA AI Endpoints" icon="link" href="/oss/python/integrations/chat/nvidia_ai_endpoints" arrow="true" cta="View guide" />

<Card title="ChatOCIModelDeployment" icon="link" href="/oss/python/integrations/chat/oci_data_science" arrow="true" cta="View guide" />

<Card title="OCIGenAI" icon="link" href="/oss/python/integrations/chat/oci_generative_ai" arrow="true" cta="View guide" />

<Card title="ChatOctoAI" icon="link" href="/oss/python/integrations/chat/octoai" arrow="true" cta="View guide" />

<Card title="Ollama" icon="link" href="/oss/python/integrations/chat/ollama" arrow="true" cta="View guide" />

<Card title="OpenAI" icon="link" href="/oss/python/integrations/chat/openai" arrow="true" cta="View guide" />

<Card title="Outlines" icon="link" href="/oss/python/integrations/chat/outlines" arrow="true" cta="View guide" />

<Card title="Perplexity" icon="link" href="/oss/python/integrations/chat/perplexity" arrow="true" cta="View guide" />

<Card title="Pipeshift" icon="link" href="/oss/python/integrations/chat/pipeshift" arrow="true" cta="View guide" />

<Card title="ChatPredictionGuard" icon="link" href="/oss/python/integrations/chat/predictionguard" arrow="true" cta="View guide" />

<Card title="PremAI" icon="link" href="/oss/python/integrations/chat/premai" arrow="true" cta="View guide" />

<Card title="PromptLayer ChatOpenAI" icon="link" href="/oss/python/integrations/chat/promptlayer_chatopenai" arrow="true" cta="View guide" />

<Card title="Qwen QwQ" icon="link" href="/oss/python/integrations/chat/qwq" arrow="true" cta="View guide" />

<Card title="Qwen" icon="link" href="/oss/python/integrations/chat/qwen" arrow="true" cta="View guide" />

<Card title="Reka" icon="link" href="/oss/python/integrations/chat/reka" arrow="true" cta="View guide" />

<Card title="RunPod Chat Model" icon="link" href="/oss/python/integrations/chat/runpod" arrow="true" cta="View guide" />

<Card title="SambaNova" icon="link" href="/oss/python/integrations/chat/sambanova" arrow="true" cta="View guide" />

<Card title="ChatSeekrFlow" icon="link" href="/oss/python/integrations/chat/seekrflow" arrow="true" cta="View guide" />

<Card title="Snowflake Cortex" icon="link" href="/oss/python/integrations/chat/snowflake" arrow="true" cta="View guide" />

<Card title="SparkLLM Chat" icon="link" href="/oss/python/integrations/chat/sparkllm" arrow="true" cta="View guide" />

<Card title="Nebula (Symbl.ai)" icon="link" href="/oss/python/integrations/chat/symblai_nebula" arrow="true" cta="View guide" />

<Card title="Tencent Hunyuan" icon="link" href="/oss/python/integrations/chat/tencent_hunyuan" arrow="true" cta="View guide" />

<Card title="Together" icon="link" href="/oss/python/integrations/chat/together" arrow="true" cta="View guide" />

<Card title="Tongyi Qwen" icon="link" href="/oss/python/integrations/chat/tongyi" arrow="true" cta="View guide" />

<Card title="Upstage" icon="link" href="/oss/python/integrations/chat/upstage" arrow="true" cta="View guide" />

<Card title="vLLM Chat" icon="link" href="/oss/python/integrations/chat/vllm" arrow="true" cta="View guide" />

<Card title="Volc Engine Maas" icon="link" href="/oss/python/integrations/chat/volcengine_maas" arrow="true" cta="View guide" />

<Card title="ChatWriter" icon="link" href="/oss/python/integrations/chat/writer" arrow="true" cta="View guide" />

<Card title="xAI" icon="link" href="/oss/python/integrations/chat/xai" arrow="true" cta="View guide" />

<Card title="Xinference" icon="link" href="/oss/python/integrations/chat/xinference" arrow="true" cta="View guide" />

<Card title="YandexGPT" icon="link" href="/oss/python/integrations/chat/yandex" arrow="true" cta="View guide" />

<Card title="ChatYI" icon="link" href="/oss/python/integrations/chat/yi" arrow="true" cta="View guide" />

<Card title="Yuan2.0" icon="link" href="/oss/python/integrations/chat/yuan2" arrow="true" cta="View guide" />

<Card title="ZHIPU AI" icon="link" href="/oss/python/integrations/chat/zhipuai" arrow="true" cta="View guide" />
</Columns>

<Info>
  If you'd like to contribute an integration, see [Contributing integrations](/oss/python/contributing#add-a-new-integration).
</Info>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/python/integrations/chat/index.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
Refer to the [OpenRouter documentation](https://openrouter.ai/docs/quickstart) for more details.

  <Note>
    To capture [reasoning tokens](https://openrouter.ai/docs/use-cases/reasoning-tokens),

    1. Switch imports from `langchain_openai` to `langchain_deepseek`
    2. Use `ChatDeepSeek` instead of `ChatOpenAI`. You will need to change param `base_url` to `api_base`.
    3. Adjust reasoning parameters as needed under `extra_body`, e.g.:
```

---

## Call the function with traced attachments

**URL:** llms-txt#call-the-function-with-traced-attachments

**Contents:**
  - TypeScript

result = trace_with_attachments(
    val=val,
    text=text,
    image=image_attachment,
    audio=audio_attachment,
    video=video_attachment,
    pdf=pdf_attachment,
    csv=csv_attachment,
)
typescript TypeScript theme={null}
type AttachmentData = Uint8Array | ArrayBuffer;
type Attachments = Record<string, [string, AttachmentData]>;

extractAttachments?: (
    ...args: Parameters<Func>
) => [Attachments | undefined, KVMap];
typescript TypeScript theme={null}
import { traceable } from "langsmith/traceable";

const traceableWithAttachments = traceable(
    (
        val: number,
        text: string,
        attachment: Uint8Array,
        attachment2: ArrayBuffer,
        attachment3: Uint8Array,
        attachment4: ArrayBuffer,
        attachment5: Uint8Array,
    ) =>
        `Processed: ${val}, ${text}, ${attachment.length}, ${attachment2.byteLength}, ${attachment3.length}, ${attachment4.byteLength}, ${attachment5.byteLength}`,
    {
        name: "traceWithAttachments",
        extractAttachments: (
            val: number,
            text: string,
            attachment: Uint8Array,
            attachment2: ArrayBuffer,
            attachment3: Uint8Array,
            attachment4: ArrayBuffer,
            attachment5: Uint8Array,
        ) => [
            {
                "image inputs": ["image/png", attachment],
                "mp3 inputs": ["audio/mpeg", new Uint8Array(attachment2)],
                "video inputs": ["video/mp4", attachment3],
                "pdf inputs": ["application/pdf", new Uint8Array(attachment4)],
                "csv inputs": ["text/csv", new Uint8Array(attachment5)],
            },
            { val, text },
        ],
    }
);

const fs = Deno // or Node.js fs module
const image = await fs.readFile("my_image.png"); // Uint8Array
const mp3Buffer = await fs.readFile("my_mp3.mp3");
const mp3ArrayBuffer = mp3Buffer.buffer; // Convert to ArrayBuffer
const video = await fs.readFile("my_video.mp4"); // Uint8Array
const pdfBuffer = await fs.readFile("my_document.pdf");
const pdfArrayBuffer = pdfBuffer.buffer; // Convert to ArrayBuffer
const csv = await fs.readFile("test-vals.csv"); // Uint8Array

// Define example parameters
const val = 42;
const text = "Hello, world!";

// Call traceableWithAttachments with the files
const result = await traceableWithAttachments(
    val, text, image, mp3ArrayBuffer, video, pdfArrayBuffer, csv
);
```

Here is how the above would look in the LangSmith UI. You can expand each attachment to view its contents.

<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=cb21a1c6d8904d1d7b2215652a6127a5" alt="" data-og-width="3012" width="3012" data-og-height="1696" height="1696" data-path="langsmith/images/trace-with-attachments.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=4caa7aaa44cd296b2f30ff8d6f6d7199 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=01a4392a7dbf3d10184778d2ab3737a1 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=e8047eabe350453619c255e88d6fe1d5 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9b0bbb43e10ea30cf466fb65502af907 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=0060d9877954b82d34593d8789f7d0a5 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/trace-with-attachments.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=ec15ad89f02769defc2d5f5637d88e11 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/upload-files-with-traces.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
### TypeScript

In the TypeScript SDK, you can add attachments to traces by using `Uint8Array` or `ArrayBuffer` as data types. Each attachment's MIME type is specified within `extractAttachments`:

* `Uint8Array`: Useful for handling binary data directly.
* `ArrayBuffer`: Represents fixed-length binary data, which can be converted to `Uint8Array` as needed.

Wrap your function with `traceable` and include your attachments within the `extractAttachments` option.

In the TypeScript SDK, the `extractAttachments` function is an optional parameter in the `traceable` configuration. When the traceable-wrapped function is invoked, it extracts binary data (e.g., images, audio files) from your inputs and logs them alongside other trace data, specifying their MIME types.

Note that you cannot directly pass in a file path in the TypeScript SDK, as accessing local files is not supported in all runtime environments.
```

Example 2 (unknown):
```unknown

```

---

## Create a parent run

**URL:** llms-txt#create-a-parent-run

parent_run = construct_run(
    name="Parent Run",
    run_type="chain",
    inputs={"main_question": "Tell me about France"},
)

---

## Memory

**URL:** llms-txt#memory

**Contents:**
- Add short-term memory
  - Use in production
  - Use in subgraphs

Source: https://docs.langchain.com/oss/python/langgraph/add-memory

AI applications need [memory](/oss/python/concepts/memory) to share context across multiple interactions. In LangGraph, you can add two types of memory:

* [Add short-term memory](#add-short-term-memory) as a part of your agent's [state](/oss/python/langgraph/graph-api#state) to enable multi-turn conversations.
* [Add long-term memory](#add-long-term-memory) to store user-specific or application-level data across sessions.

## Add short-term memory

**Short-term** memory (thread-level [persistence](/oss/python/langgraph/persistence)) enables agents to track multi-turn conversations. To add short-term memory:

### Use in production

In production, use a checkpointer backed by a database:

<Accordion title="Example: using Postgres checkpointer">

<Tip>
    You need to call `checkpointer.setup()` the first time you're using Postgres checkpointer
  </Tip>

<Tabs>
    <Tab title="Sync">
      
    </Tab>

<Tab title="Async">
      
    </Tab>
  </Tabs>
</Accordion>

<Accordion title="Example: using [MongoDB](https://pypi.org/project/langgraph-checkpoint-mongodb/) checkpointer">

<Note>
    **Setup**
    To use the MongoDB checkpointer, you will need a MongoDB cluster. Follow [this guide](https://www.mongodb.com/docs/guides/atlas/cluster/) to create a cluster if you don't already have one.
  </Note>

<Tabs>
    <Tab title="Sync">
      
    </Tab>

<Tab title="Async">
      
    </Tab>
  </Tabs>
</Accordion>

<Accordion title="Example: using Redis checkpointer">

<Tip>
    You need to call `checkpointer.setup()` the first time you're using Redis checkpointer.
  </Tip>

<Tabs>
    <Tab title="Sync">
      
    </Tab>

<Tab title="Async">
      
    </Tab>
  </Tabs>
</Accordion>

If your graph contains [subgraphs](/oss/python/langgraph/use-subgraphs), you only need to provide the checkpointer when compiling the parent graph. LangGraph will automatically propagate the checkpointer to the child subgraphs.

```python  theme={null}
from langgraph.graph import START, StateGraph
from langgraph.checkpoint.memory import InMemorySaver
from typing import TypedDict

class State(TypedDict):
    foo: str

**Examples:**

Example 1 (unknown):
```unknown
### Use in production

In production, use a checkpointer backed by a database:
```

Example 2 (unknown):
```unknown
<Accordion title="Example: using Postgres checkpointer">
```

Example 3 (unknown):
```unknown
<Tip>
    You need to call `checkpointer.setup()` the first time you're using Postgres checkpointer
  </Tip>

  <Tabs>
    <Tab title="Sync">
```

Example 4 (unknown):
```unknown
</Tab>

    <Tab title="Async">
```

---

## Thinking in LangGraph

**URL:** llms-txt#thinking-in-langgraph

**Contents:**
- Start with the process you want to automate
- Step 1: Map out your workflow as discrete steps
- Step 2: Identify what each step needs to do
  - LLM Steps
  - Data Steps
  - Action Steps
  - User Input Steps
- Step 3: Design your state
  - What belongs in state?
  - Keep state raw, format prompts on-demand

Source: https://docs.langchain.com/oss/python/langgraph/thinking-in-langgraph

Learn how to think about building agents with LangGraph by breaking down a customer support email agent into discrete steps

LangGraph can change how you think about the agents you build. When you build an agent with LangGraph, you will first break it apart into discrete steps called **nodes**. Then, you will describe the different decisions and transitions for each of your nodes. Finally, you will connect your nodes together through a shared **state** that each node can read from and write to. In this tutorial, we'll guide you through the thought process of building a customer support email agent with LangGraph.

## Start with the process you want to automate

Imagine that you need to build an AI agent that handles customer support emails. Your product team has given you these requirements:

* Read incoming customer emails
* Classify them by urgency and topic
* Search relevant documentation to answer questions
* Draft appropriate responses
* Escalate complex issues to human agents
* Schedule follow-ups when needed

Example scenarios to handle:

1. Simple product question: "How do I reset my password?"
2. Bug report: "The export feature crashes when I select PDF format"
3. Urgent billing issue: "I was charged twice for my subscription!"
4. Feature request: "Can you add dark mode to the mobile app?"
5. Complex technical issue: "Our API integration fails intermittently with 504 errors"

To implement an agent in LangGraph, you will usually follow the same five steps.

## Step 1: Map out your workflow as discrete steps

Start by identifying the distinct steps in your process. Each step will become a **node** (a function that does one specific thing). Then sketch how these steps connect to each other.

The arrows show possible paths, but the actual decision of which path to take happens inside each node.

Now that you've identified the components in your workflow, let's understand what each node needs to do:

* Read Email: Extract and parse the email content
* Classify Intent: Use an LLM to categorize urgency and topic, then route to appropriate action
* Doc Search: Query your knowledge base for relevant information
* Bug Track: Create or update issue in tracking system
* Draft Reply: Generate an appropriate response
* Human Review: Escalate to human agent for approval or handling
* Send Reply: Dispatch the email response

<Tip>
  Notice that some nodes make decisions about where to go next (Classify Intent, Draft Reply, Human Review), while others always proceed to the same next step (Read Email always goes to Classify Intent, Doc Search always goes to Draft Reply).
</Tip>

## Step 2: Identify what each step needs to do

For each node in your graph, determine what type of operation it represents and what context it needs to work properly.

<CardGroup cols={2}>
  <Card title="LLM Steps" icon="brain" href="#llm-steps">
    Use when you need to understand, analyze, generate text, or make reasoning decisions
  </Card>

<Card title="Data Steps" icon="database" href="#data-steps">
    Use when you need to retrieve information from external sources
  </Card>

<Card title="Action Steps" icon="bolt" href="#action-steps">
    Use when you need to perform external actions
  </Card>

<Card title="User Input Steps" icon="user" href="#user-input-steps">
    Use when you need human intervention
  </Card>
</CardGroup>

When a step needs to understand, analyze, generate text, or make reasoning decisions:

<AccordionGroup>
  <Accordion title="Classify Intent Node">
    * Static context (prompt): Classification categories, urgency definitions, response format
    * Dynamic context (from state): Email content, sender information
    * Desired outcome: Structured classification that determines routing
  </Accordion>

<Accordion title="Draft Reply Node">
    * Static context (prompt): Tone guidelines, company policies, response templates
    * Dynamic context (from state): Classification results, search results, customer history
    * Desired outcome: Professional email response ready for review
  </Accordion>
</AccordionGroup>

When a step needs to retrieve information from external sources:

<AccordionGroup>
  <Accordion title="Document Search Node">
    * Parameters: Query built from intent and topic
    * Retry strategy: Yes, with exponential backoff for transient failures
    * Caching: Could cache common queries to reduce API calls
  </Accordion>

<Accordion title="Customer History Lookup">
    * Parameters: Customer email or ID from state
    * Retry strategy: Yes, but with fallback to basic info if unavailable
    * Caching: Yes, with time-to-live to balance freshness and performance
  </Accordion>
</AccordionGroup>

When a step needs to perform an external action:

<AccordionGroup>
  <Accordion title="Send Reply Node">
    * When to execute: After approval (human or automated)
    * Retry strategy: Yes, with exponential backoff for network issues
    * Should not cache: Each send is a unique action
  </Accordion>

<Accordion title="Bug Track Node">
    * When to execute: Always when intent is "bug"
    * Retry strategy: Yes, critical to not lose bug reports
    * Returns: Ticket ID to include in response
  </Accordion>
</AccordionGroup>

When a step needs human intervention:

<AccordionGroup>
  <Accordion title="Human Review Node">
    * Context for decision: Original email, draft response, urgency, classification
    * Expected input format: Approval boolean plus optional edited response
    * When triggered: High urgency, complex issues, or quality concerns
  </Accordion>
</AccordionGroup>

## Step 3: Design your state

State is the shared [memory](/oss/python/concepts/memory) accessible to all nodes in your agent. Think of it as the notebook your agent uses to keep track of everything it learns and decides as it works through the process.

### What belongs in state?

Ask yourself these questions about each piece of data:

<CardGroup cols={2}>
  <Card title="Include in State" icon="check">
    Does it need to persist across steps? If yes, it goes in state.
  </Card>

<Card title="Don't Store" icon="code">
    Can you derive it from other data? If yes, compute it when needed instead of storing it in state.
  </Card>
</CardGroup>

For our email agent, we need to track:

* The original email and sender info (can't reconstruct these)
* Classification results (needed by multiple downstream nodes)
* Search results and customer data (expensive to re-fetch)
* The draft response (needs to persist through review)
* Execution metadata (for debugging and recovery)

### Keep state raw, format prompts on-demand

<Tip>
  A key principle: your state should store raw data, not formatted text. Format prompts inside nodes when you need them.
</Tip>

This separation means:

* Different nodes can format the same data differently for their needs
* You can change prompt templates without modifying your state schema
* Debugging is clearer - you see exactly what data each node received
* Your agent can evolve without breaking existing state

Let's define our state:

```python  theme={null}
from typing import TypedDict, Literal

**Examples:**

Example 1 (unknown):
```unknown
The arrows show possible paths, but the actual decision of which path to take happens inside each node.

Now that you've identified the components in your workflow, let's understand what each node needs to do:

* Read Email: Extract and parse the email content
* Classify Intent: Use an LLM to categorize urgency and topic, then route to appropriate action
* Doc Search: Query your knowledge base for relevant information
* Bug Track: Create or update issue in tracking system
* Draft Reply: Generate an appropriate response
* Human Review: Escalate to human agent for approval or handling
* Send Reply: Dispatch the email response

<Tip>
  Notice that some nodes make decisions about where to go next (Classify Intent, Draft Reply, Human Review), while others always proceed to the same next step (Read Email always goes to Classify Intent, Doc Search always goes to Draft Reply).
</Tip>

## Step 2: Identify what each step needs to do

For each node in your graph, determine what type of operation it represents and what context it needs to work properly.

<CardGroup cols={2}>
  <Card title="LLM Steps" icon="brain" href="#llm-steps">
    Use when you need to understand, analyze, generate text, or make reasoning decisions
  </Card>

  <Card title="Data Steps" icon="database" href="#data-steps">
    Use when you need to retrieve information from external sources
  </Card>

  <Card title="Action Steps" icon="bolt" href="#action-steps">
    Use when you need to perform external actions
  </Card>

  <Card title="User Input Steps" icon="user" href="#user-input-steps">
    Use when you need human intervention
  </Card>
</CardGroup>

### LLM Steps

When a step needs to understand, analyze, generate text, or make reasoning decisions:

<AccordionGroup>
  <Accordion title="Classify Intent Node">
    * Static context (prompt): Classification categories, urgency definitions, response format
    * Dynamic context (from state): Email content, sender information
    * Desired outcome: Structured classification that determines routing
  </Accordion>

  <Accordion title="Draft Reply Node">
    * Static context (prompt): Tone guidelines, company policies, response templates
    * Dynamic context (from state): Classification results, search results, customer history
    * Desired outcome: Professional email response ready for review
  </Accordion>
</AccordionGroup>

### Data Steps

When a step needs to retrieve information from external sources:

<AccordionGroup>
  <Accordion title="Document Search Node">
    * Parameters: Query built from intent and topic
    * Retry strategy: Yes, with exponential backoff for transient failures
    * Caching: Could cache common queries to reduce API calls
  </Accordion>

  <Accordion title="Customer History Lookup">
    * Parameters: Customer email or ID from state
    * Retry strategy: Yes, but with fallback to basic info if unavailable
    * Caching: Yes, with time-to-live to balance freshness and performance
  </Accordion>
</AccordionGroup>

### Action Steps

When a step needs to perform an external action:

<AccordionGroup>
  <Accordion title="Send Reply Node">
    * When to execute: After approval (human or automated)
    * Retry strategy: Yes, with exponential backoff for network issues
    * Should not cache: Each send is a unique action
  </Accordion>

  <Accordion title="Bug Track Node">
    * When to execute: Always when intent is "bug"
    * Retry strategy: Yes, critical to not lose bug reports
    * Returns: Ticket ID to include in response
  </Accordion>
</AccordionGroup>

### User Input Steps

When a step needs human intervention:

<AccordionGroup>
  <Accordion title="Human Review Node">
    * Context for decision: Original email, draft response, urgency, classification
    * Expected input format: Approval boolean plus optional edited response
    * When triggered: High urgency, complex issues, or quality concerns
  </Accordion>
</AccordionGroup>

## Step 3: Design your state

State is the shared [memory](/oss/python/concepts/memory) accessible to all nodes in your agent. Think of it as the notebook your agent uses to keep track of everything it learns and decides as it works through the process.

### What belongs in state?

Ask yourself these questions about each piece of data:

<CardGroup cols={2}>
  <Card title="Include in State" icon="check">
    Does it need to persist across steps? If yes, it goes in state.
  </Card>

  <Card title="Don't Store" icon="code">
    Can you derive it from other data? If yes, compute it when needed instead of storing it in state.
  </Card>
</CardGroup>

For our email agent, we need to track:

* The original email and sender info (can't reconstruct these)
* Classification results (needed by multiple downstream nodes)
* Search results and customer data (expensive to re-fetch)
* The draft response (needs to persist through review)
* Execution metadata (for debugging and recovery)

### Keep state raw, format prompts on-demand

<Tip>
  A key principle: your state should store raw data, not formatted text. Format prompts inside nodes when you need them.
</Tip>

This separation means:

* Different nodes can format the same data differently for their needs
* You can change prompt templates without modifying your state schema
* Debugging is clearer - you see exactly what data each node received
* Your agent can evolve without breaking existing state

Let's define our state:
```

---

## Workflow execution configuration with a unique thread identifier

**URL:** llms-txt#workflow-execution-configuration-with-a-unique-thread-identifier

config = {
    "configurable": {
        "thread_id": "1"  # Unique identifier to track workflow execution
    }
}

---

## Composite evaluators

**URL:** llms-txt#composite-evaluators

**Contents:**
- Create a composite evaluator using the UI
  - 1. Navigate to the tracing project or dataset
  - 2. Configure the composite evaluator
  - 3. View composite evaluator results
- Create composite feedback with the SDK
  - 1. Configure evaluators on a dataset
  - 2. Create composite feedback

Source: https://docs.langchain.com/langsmith/composite-evaluators

*Composite evaluators* are a way to combine multiple evaluator scores into a single [score](/langsmith/evaluation-concepts#evaluator-outputs). This is useful when you want to evaluate multiple aspects of your application and combine the results into a single result.

## Create a composite evaluator using the UI

You can create composite evaluators on a [tracing project](/langsmith/observability-concepts#projects) (for [online evaluations](/langsmith/evaluation-concepts#online-evaluation)) or a [dataset](/langsmith/evaluation-concepts#datasets) (for [offline evaluations](/langsmith/evaluation-concepts#offline-evaluation)). With composite evaluators in the UI, you can compute a weighted average or weighted sum of multiple evaluator scores, with configurable weights.

<div style={{ textAlign: 'center' }}>
  <img className="block dark:hidden" src="https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=b3859ada8b576ebeaf5399ff15359b10" alt="LangSmith UI showing an LLM call trace called ChatOpenAI with a system and human input followed by an AI Output." data-og-width="756" width="756" data-og-height="594" height="594" data-path="langsmith/images/create_composite_evaluator-light.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=280&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=9bab5ad812328acdd6ffe858f487262b 280w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=560&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=4637a2dc732f945d98b0214023266180 560w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=840&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=c3e7b24dde21ed45f481b7a513ecc256 840w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=1100&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=1310a99e2a8b37d68d78f794b8ce6606 1100w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=1650&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=6beb89dcc6ec734b2ad012bc46c58821 1650w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-light.png?w=2500&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=ba7fd7ba48a3e46d8701b6f64bb68f66 2500w" />

<img className="hidden dark:block" src="https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=ac13f4d2d4a5e3b67285284150b7d592" alt="LangSmith UI showing an LLM call trace called ChatOpenAI with a system and human input followed by an AI Output." data-og-width="761" width="761" data-og-height="585" height="585" data-path="langsmith/images/create_composite_evaluator-dark.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=280&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=bfc19d802f0327a579d90e519441cf9a 280w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=560&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=23ab26db75e25795c17abf07e487ba5d 560w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=840&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=7ce9597b62f3e68b2dc1afa5f17f0e8c 840w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=1100&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=ee7058d60185a820fe23decf003bd2c1 1100w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=1650&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=cff38ad541c55d6834edfa67f5650818 1650w, https://mintcdn.com/langchain-5e9cc07a/cRRwi1N4-QohYC73/langsmith/images/create_composite_evaluator-dark.png?w=2500&fit=max&auto=format&n=cRRwi1N4-QohYC73&q=85&s=0f85093799a489eff72dae01ed5b6d94 2500w" />
</div>

### 1. Navigate to the tracing project or dataset

To start configuring a composite evaluator, navigate to the **Tracing Projects** or **Dataset & Experiments** tab and select a project or dataset.

* From within a tracing project: **+ New** > **Evaluator** > **Composite score**
* From within a dataset: **+ Evaluator** > **Composite score**

### 2. Configure the composite evaluator

1. Name your evaluator.
2. Select an aggregation method, either **Average** or **Sum**.
   * **Average**: ∑(weight\*score) / ∑(weight).
   * **Sum**: ∑(weight\*score).
3. Add the feedback keys you want to include in the composite score.
4. Add the weights for the feedback keys. By default, the weights are equal for each feedback key. Adjust the weights to increase or decrease the importance of specific feedback keys in the final score.
5. Click **Create** to save the evaluator.

<Tip> If you need to adjust the weights for the composite scores, they can be updated after the evaluator is created. The resulting scores will be updated for all runs that have the evaluator configured. </Tip>

### 3. View composite evaluator results

Composite scores are attached to a run as **feedback**, similarly to feedback from a single evaluator. How you can view them depends on where the evaluation was run:

**On a tracing project**:

* Composite scores appear as feedback on runs.
* [Filter for runs](/langsmith/filter-traces-in-application) with a composite score, or where the composite score meets a certain threshold.
* [Create a chart](/langsmith/dashboards#custom-dashboards) to visualize trends in the composite score over time.

* View the composite scores in the experiments tab. You can also filter and sort experiments based on the average composite score of their runs.
* Click into an experiment to view the composite score for each run.

<Note> If any of the constituent evaluators are not configured on the run, the composite score will not be calculated for that run. </Note>

## Create composite feedback with the SDK

This guide describes setting up an evaluation that uses multiple evaluators and combines their scores with a custom aggregation function.

<Note> Requires langsmith>=0.4.29 </Note>

### 1. Configure evaluators on a dataset

Start by configuring your evaluators. In this example, the application generates a tweet from a blog introduction and uses three evaluators — summary, tone, and formatting — to assess the output.

If you already have your own dataset with evaluators configured, you can skip this step.

<Accordion title="Configure evaluators on a dataset.">
  
</Accordion>

### 2. Create composite feedback

Create composite feedback that aggregates the individual evaluator scores using your custom function. This example uses a weighted average of the individual evaluator scores.

<Accordion title="Create a composite feedback.">
  
</Accordion>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/composite-evaluators.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
</Accordion>

### 2. Create composite feedback

Create composite feedback that aggregates the individual evaluator scores using your custom function. This example uses a weighted average of the individual evaluator scores.

<Accordion title="Create a composite feedback.">
```

---

## Process all results after evaluation completes

**URL:** llms-txt#process-all-results-after-evaluation-completes

**Contents:**
- Related

for result in results:
    print("Input:", result["run"].inputs)
    print("Output:", result["run"].outputs)

# Access individual evaluation results
    for eval_result in result["evaluation_results"]["results"]:
        print(f"  {eval_result.key}: {eval_result.score}")
```

With `blocking=True`, your processing code runs only after all evaluations are complete, avoiding mixed output with evaluation logs.

For more information on running evaluations without uploading results, refer to [Run an evaluation locally](/langsmith/local).

* [Evaluate your LLM application](/langsmith/evaluate-llm-application)
* [Run an evaluation locally](/langsmith/local)
* [Fetch performance metrics from an experiment](/langsmith/fetch-perf-metrics-experiment)

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/read-local-experiment-results.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## >             }

**URL:** llms-txt#>-------------}

---

## Unified access to content blocks

**URL:** llms-txt#unified-access-to-content-blocks

**Contents:**
  - Benefits
- Simplified package
  - Namespace

for block in response.content_blocks:
    if block["type"] == "reasoning":
        print(f"Model reasoning: {block['reasoning']}")
    elif block["type"] == "text":
        print(f"Response: {block['text']}")
    elif block["type"] == "tool_call":
        print(f"Tool call: {block['name']}({block['args']})")
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
### Benefits

* **Provider agnostic**: Access reasoning traces, citations, built-in tools (web search, code interpreters, etc.), and other features using the same API regardless of provider
* **Type safe**: Full type hints for all content block types
* **Backward compatible**: Standard content can be [loaded lazily](/oss/python/langchain/messages#standard-content-blocks), so there are no associated breaking changes

For more information, see our guide on [content blocks](/oss/python/langchain/messages#standard-content-blocks).

***

## Simplified package

LangChain v1 streamlines the [`langchain`](https://pypi.org/project/langchain/) package namespace to focus on essential building blocks for agents. The refined namespace exposes the most useful and relevant functionality:

### Namespace

| Module                                                                                | What's available                                                                                                                                                                                                                                                          | Notes                                 |
| ------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------- |
| [`langchain.agents`](https://reference.langchain.com/python/langchain/agents)         | [`create_agent`](https://reference.langchain.com/python/langchain/agents/#langchain.agents.create_agent), [`AgentState`](https://reference.langchain.com/python/langchain/agents/#langchain.agents.AgentState)                                                            | Core agent creation functionality     |
| [`langchain.messages`](https://reference.langchain.com/python/langchain/messages)     | Message types, [content blocks](https://reference.langchain.com/python/langchain/messages/#langchain.messages.ContentBlock), [`trim_messages`](https://reference.langchain.com/python/langchain/messages/#langchain.messages.trim_messages)                               | Re-exported from @\[`langchain-core`] |
| [`langchain.tools`](https://reference.langchain.com/python/langchain/tools)           | [`@tool`](https://reference.langchain.com/python/langchain/tools/#langchain.tools.tool), [`BaseTool`](https://reference.langchain.com/python/langchain/tools/#langchain.tools.BaseTool), injection helpers                                                                | Re-exported from @\[`langchain-core`] |
| [`langchain.chat_models`](https://reference.langchain.com/python/langchain/models)    | [`init_chat_model`](https://reference.langchain.com/python/langchain/models/#langchain.chat_models.init_chat_model), [`BaseChatModel`](https://reference.langchain.com/python/langchain_core/language_models/#langchain_core.language_models.chat_models.BaseChatModel)   | Unified model initialization          |
| [`langchain.embeddings`](https://reference.langchain.com/python/langchain/embeddings) | [`Embeddings`](https://reference.langchain.com/python/langchain_core/embeddings/#langchain_core.embeddings.embeddings.Embeddings), [`init_embeddings`](https://reference.langchain.com/python/langchain_core/embeddings/#langchain_core.embeddings.embeddings.Embeddings) | Embedding models                      |

Most of these are re-exported from `langchain-core` for convenience, which gives you a focused API surface for building agents.
```

---

## Try to access without a token

**URL:** llms-txt#try-to-access-without-a-token

unauthenticated_client = get_client(url="http://localhost:2024")
try:
    await unauthenticated_client.threads.create()
    print("❌ Unauthenticated access should fail!")
except Exception as e:
    print("✅ Unauthenticated access blocked:", e)

---

## See trace: https://smith.langchain.com/public/882f9ecf-5057-426a-ae98-0edf84fdcaf9/r

**URL:** llms-txt#see-trace:-https://smith.langchain.com/public/882f9ecf-5057-426a-ae98-0edf84fdcaf9/r

**Contents:**
- Ensure all traces are submitted before exiting
  - Using the LangSmith SDK
  - Using LangChain

MyClass(13).combine(29)
python Python theme={null}
  from langsmith import Client

@traceable(client=client)
  async def my_traced_func():
    # Your code here...
    pass

try:
    await my_traced_func()
  finally:
    await client.flush()
  typescript TypeScript theme={null}
  import { Client } from "langsmith";

const langsmithClient = new Client({});

const myTracedFunc = traceable(async () => {
    // Your code here...
  },{ client: langsmithClient });

try {
    await myTracedFunc();
  } finally {
    await langsmithClient.flush();
  }
  ```
</CodeGroup>

If you are using LangChain, please refer to our [LangChain tracing guide](/langsmith/trace-with-langchain#ensure-all-traces-are-submitted-before-exiting).

If you prefer a video tutorial, check out the [Tracing Basics video](https://academy.langchain.com/pages/intro-to-langsmith-preview) from the Introduction to LangSmith Course.

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/annotate-code.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
## Ensure all traces are submitted before exiting

LangSmith's tracing is done in a background thread to avoid obstructing your production application. This means that your process may end before all traces are successfully posted to LangSmith. Here are some options for ensuring all traces are submitted before exiting your application.

### Using the LangSmith SDK

If you are using the LangSmith SDK standalone, you can use the `flush` method before exit:

<CodeGroup>
```

Example 2 (unknown):
```unknown

```

---

## Log multimodal traces

**URL:** llms-txt#log-multimodal-traces

Source: https://docs.langchain.com/langsmith/log-multimodal-traces

LangSmith supports logging and rendering images as part of traces. This is currently supported for multimodal LLM runs.

In order to log images, use `wrap_openai`/ `wrapOpenAI` in Python or TypeScript respectively and pass an image URL or base64 encoded image as part of the input.

The image will be rendered as part of the trace in the LangSmith UI.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=ff41711a0992c77f86cbc9f523e2ae93" alt="" data-og-width="1600" width="1600" data-og-height="1216" height="1216" data-path="langsmith/images/multimodal.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=d1119193b53a405869cbda1d17c88544 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=147037549a28d87622e4c7d4d15ccc2b 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=145003b20883ea39001adaf0eaf45529 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=01cc9ca22bca3312a5d4c1b356e5b8fc 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=047b36000ced498139fa793c1815440a 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/multimodal.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=f7868994ae8fd23e9239b4b8d77ee4a0 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/log-multimodal-traces.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown

```

---

## Since this is **more specific** than both the generic @auth.on handler and the @auth.on.threads handler,

**URL:** llms-txt#since-this-is-**more-specific**-than-both-the-generic-@auth.on-handler-and-the-@auth.on.threads-handler,

---

## Manage prompts

**URL:** llms-txt#manage-prompts

**Contents:**
- Commit tags
  - Create a tag
  - Move a tag
  - Delete a tag
  - Use tags in code

Source: https://docs.langchain.com/langsmith/manage-prompts

LangSmith provides several tools to help you manage your [*prompts*](/langsmith/prompt-engineering-concepts) effectively. This page describes the following features:

* [Commit tags](#commit-tags) for version control and environment management.
* [Webhook triggers](#trigger-a-webhook-on-prompt-commit) for automating workflows when prompts are updated.
* [Public prompt hub](#public-prompt-hub) for discovering and using community-created prompts.

[*Commit tags*](/langsmith/prompt-engineering-concepts#tags) are labels that reference a specific [*commit*](/langsmith/prompt-engineering-concepts#commits) in your prompt's version history. They help you mark significant versions and control which versions run in different environments. By referencing tags rather than commit IDs in your code, you can update which version is being used without modifying the code itself.

Each tag references exactly one commit, though you can reassign a tag to point to a different commit.

<Note>
  **Not to be confused with resource tags**: Commit tags are specific to prompt versioning and reference individual commits in a prompt's history. [Resource tags](/langsmith/set-up-resource-tags) are key-value pairs used to organize workspace resources like projects, datasets, and prompts. While both can use similar naming conventions (like `prod` or `staging`), commit tags control **which version** of a prompt runs, while resource tags help you **organize and filter** resources across your workspace.
</Note>

To create a tag, navigate to the **Commits** tab for a prompt. Click on the tag icon next to the commit you want to tag. Click **New Tag** and enter a name for the tag.

<img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b0cb7961f70d5c0bab9af960041bc54f" alt="" data-og-width="2868" width="2868" data-og-height="992" height="992" data-path="langsmith/images/commits-tab.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=5786acfc0582c73c73efb5535a954ab4 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=410aa69f0ef5cc13ff7651df331495b7 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=b9845d256b71636a9bb6ee60c774a29e 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=e16686b15bf2a95709a5d963ffc339d0 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=cb9560e6aa774505cb9ff1857f95ae61 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/commits-tab.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=bef88e11fa0de6173fc4dfd9c9339f39 2500w" /> <img src="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=cc27df9c5392a9b71319969c14924c61" alt="" data-og-width="1410" width="1410" data-og-height="872" height="872" data-path="langsmith/images/create-new-prompt-tag.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=280&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=ed473769995e6148b60aec9cdd652ab6 280w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=560&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=1f817be111dfc54af9717f9cdb664752 560w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=840&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=fb0b979bf3362bd8faf796e4d617ac1c 840w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=1100&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=22c63285bd22dd0c82d53b8d46c6638b 1100w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=1650&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=1b4d05163bd948c4bce8ea08b5ceb70f 1650w, https://mintcdn.com/langchain-5e9cc07a/aKRoUGXX6ygp4DlC/langsmith/images/create-new-prompt-tag.png?w=2500&fit=max&auto=format&n=aKRoUGXX6ygp4DlC&q=85&s=c34b5ce29b2f1914399b6a084885e09a 2500w" />

To point a tag to a different commit, click on the tag icon next to the destination commit, and select the tag you want to move. This will automatically update the tag to point to the new commit.

<img src="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=3cb3c6218961cbdd8f6f1fb6d06b50e3" alt="" data-og-width="874" width="874" data-og-height="694" height="694" data-path="langsmith/images/move-prompt-tag.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=280&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=c2094e7486cfd3a7f4d7979e7883d1bc 280w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=560&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=163481cc4580e4fe7934a5e02497fb9f 560w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=840&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=9d53ef06dc6d69cc4024821fe8cfc32d 840w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=1100&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=00ce6c08638961bfbbe5713c0066929b 1100w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=1650&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=fa898ee3d7089b443e741d4f10b7845a 1650w, https://mintcdn.com/langchain-5e9cc07a/4kN8yiLrZX_amfFn/langsmith/images/move-prompt-tag.png?w=2500&fit=max&auto=format&n=4kN8yiLrZX_amfFn&q=85&s=cd97d2004b3b0a2ac0d3c7e4d3e7fff7 2500w" />

To delete a tag, click on the delete icon next to the tag you want to delete. This will delete the tag altogether and it will no longer be associated with any commit.

Tags provide a stable way to reference specific versions of your prompts in code. Instead of using commit hashes directly, you can reference tags that can be updated without changing your code.

Here is an example of pulling a prompt by tag in Python:

```python  theme={null}
prompt = client.pull_prompt("joke-generator:prod")

---

## Set up custom authentication

**URL:** llms-txt#set-up-custom-authentication

**Contents:**
- 1. Create your app
- 2. Add authentication

Source: https://docs.langchain.com/langsmith/set-up-custom-auth

In this tutorial, we will build a chatbot that only lets specific users access it. We'll start with the LangGraph template and add token-based security step by step. By the end, you'll have a working chatbot that checks for valid tokens before allowing access.

This is part 1 of our authentication series:

1. Set up custom authentication (you are here) - Control who can access your bot
2. [Make conversations private](/langsmith/resource-auth) - Let users have private conversations
3. [Connect an authentication provider](/langsmith/add-auth-server) - Add real user accounts and validate using OAuth2 for production

This guide assumes basic familiarity with the following concepts:

* [**Authentication & Access Control**](/langsmith/auth)
* [**LangSmith**](/langsmith/home)

<Note>
  Custom auth is only available for LangSmith SaaS deployments or Enterprise Self-Hosted deployments.
</Note>

## 1. Create your app

Create a new chatbot using the LangGraph starter template:

The template gives us a placeholder LangGraph app. Try it out by installing the local dependencies and running the development server:

The server will start and open [Studio](/langsmith/studio) in your browser:

If you were to self-host this on the public internet, anyone could access it.

<img src="https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=3ca2c9a8d65891ef71abfb7ad0aae7d3" alt="No authentication: the dev server is publicly reachable, anyone can access the bot if exposed to the internet." data-og-width="1974" width="1974" data-og-height="1412" height="1412" data-path="langsmith/images/no-auth.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=280&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=67bfe450ee04d2432e5e1b86cfa0af1c 280w, https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=560&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=087f8083981ae85eeca794bdca3e0e05 560w, https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=840&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=7967264c0243918be1a8561d4db89586 840w, https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=1100&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=fd9d62383850b137834bfc7e35bc4533 1100w, https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=1650&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=66100323459f51596c53b3d941e3f85d 1650w, https://mintcdn.com/langchain-5e9cc07a/N1xJUsnxxRqnrjxV/langsmith/images/no-auth.png?w=2500&fit=max&auto=format&n=N1xJUsnxxRqnrjxV&q=85&s=a7b9157f67b3094370cc5399d917a164 2500w" />

## 2. Add authentication

Now that you have a base LangGraph app, add authentication to it.

<Note>
  In this tutorial, you will start with a hard-coded token for example purposes. You will get to a "production-ready" authentication scheme in the third tutorial.
</Note>

The [Auth](https://reference.langchain.com/python/langsmith/deployment/sdk/#langgraph_sdk.auth.Auth) object lets you register an authentication function that the LangSmith deployment will run on every request. This function receives each request and decides whether to accept or reject.

Create a new file `src/security/auth.py`. This is where your code will live to check if users are allowed to access your bot:

```python {highlight={10,15-16}} title="src/security/auth.py" theme={null}
from langgraph_sdk import Auth

**Examples:**

Example 1 (unknown):
```unknown

```

Example 2 (unknown):
```unknown
</CodeGroup>

The template gives us a placeholder LangGraph app. Try it out by installing the local dependencies and running the development server:

<CodeGroup>
```

Example 3 (unknown):
```unknown

```

Example 4 (unknown):
```unknown

```

---

## How to evaluate a graph

**URL:** llms-txt#how-to-evaluate-a-graph

**Contents:**
- End-to-end evaluations
  - Define a graph

Source: https://docs.langchain.com/langsmith/evaluate-graph

<Info>
  [langgraph](https://langchain-ai.github.io/langgraph/)
</Info>

`langgraph` is a library for building stateful, multi-actor applications with LLMs, used to create agent and multi-agent workflows. Evaluating `langgraph` graphs can be challenging because a single invocation can involve many LLM calls, and which LLM calls are made may depend on the outputs of preceding calls. In this guide we will focus on the mechanics of how to pass graphs and graph nodes to `evaluate()` / `aevaluate()`. For evaluation techniques and best practices when building agents head to the [langgraph docs](https://langchain-ai.github.io/langgraph/tutorials/#evaluation).

## End-to-end evaluations

The most common type of evaluation is an end-to-end one, where we want to evaluate the final graph output for each example input.

Lets construct a simple ReACT agent to start:

```python  theme={null}
from typing import Annotated, Literal, TypedDict
from langchain.chat_models import init_chat_model
from langchain.tools import tool
from langgraph.prebuilt import ToolNode
from langgraph.graph import END, START, StateGraph
from langgraph.graph.message import add_messages

class State(TypedDict):
    # Messages have the type "list". The 'add_messages' function
    # in the annotation defines how this state key should be updated
    # (in this case, it appends messages to the list, rather than overwriting them)
    messages: Annotated[list, add_messages]

---

## Parent graph

**URL:** llms-txt#parent-graph

**Contents:**
- View subgraph state
- Stream subgraph outputs

builder = StateGraph(State)
builder.add_node("node_1", subgraph)
builder.add_edge(START, "node_1")

checkpointer = MemorySaver()
graph = builder.compile(checkpointer=checkpointer)
python  theme={null}
subgraph_builder = StateGraph(...)
subgraph = subgraph_builder.compile(checkpointer=True)
python  theme={null}
  from langgraph.graph import START, StateGraph
  from langgraph.checkpoint.memory import MemorySaver
  from langgraph.types import interrupt, Command
  from typing_extensions import TypedDict

class State(TypedDict):
      foo: str

def subgraph_node_1(state: State):
      value = interrupt("Provide value:")
      return {"foo": state["foo"] + value}

subgraph_builder = StateGraph(State)
  subgraph_builder.add_node(subgraph_node_1)
  subgraph_builder.add_edge(START, "subgraph_node_1")

subgraph = subgraph_builder.compile()

builder = StateGraph(State)
  builder.add_node("node_1", subgraph)
  builder.add_edge(START, "node_1")

checkpointer = MemorySaver()
  graph = builder.compile(checkpointer=checkpointer)

config = {"configurable": {"thread_id": "1"}}

graph.invoke({"foo": ""}, config)
  parent_state = graph.get_state(config)

# This will be available only when the subgraph is interrupted.
  # Once you resume the graph, you won't be able to access the subgraph state.
  subgraph_state = graph.get_state(config, subgraphs=True).tasks[0].state

# resume the subgraph
  graph.invoke(Command(resume="bar"), config)
  python  theme={null}
for chunk in graph.stream(
    {"foo": "foo"},
    subgraphs=True, # [!code highlight]
    stream_mode="updates",
):
    print(chunk)
python  theme={null}
  from typing_extensions import TypedDict
  from langgraph.graph.state import StateGraph, START

# Define subgraph
  class SubgraphState(TypedDict):
      foo: str
      bar: str

def subgraph_node_1(state: SubgraphState):
      return {"bar": "bar"}

def subgraph_node_2(state: SubgraphState):
      # note that this node is using a state key ('bar') that is only available in the subgraph
      # and is sending update on the shared state key ('foo')
      return {"foo": state["foo"] + state["bar"]}

subgraph_builder = StateGraph(SubgraphState)
  subgraph_builder.add_node(subgraph_node_1)
  subgraph_builder.add_node(subgraph_node_2)
  subgraph_builder.add_edge(START, "subgraph_node_1")
  subgraph_builder.add_edge("subgraph_node_1", "subgraph_node_2")
  subgraph = subgraph_builder.compile()

# Define parent graph
  class ParentState(TypedDict):
      foo: str

def node_1(state: ParentState):
      return {"foo": "hi! " + state["foo"]}

builder = StateGraph(ParentState)
  builder.add_node("node_1", node_1)
  builder.add_node("node_2", subgraph)
  builder.add_edge(START, "node_1")
  builder.add_edge("node_1", "node_2")
  graph = builder.compile()

for chunk in graph.stream(
      {"foo": "foo"},
      stream_mode="updates",
      subgraphs=True, # [!code highlight]
  ):
      print(chunk)
  
  ((), {'node_1': {'foo': 'hi! foo'}})
  (('node_2:e58e5673-a661-ebb0-70d4-e298a7fc28b7',), {'subgraph_node_1': {'bar': 'bar'}})
  (('node_2:e58e5673-a661-ebb0-70d4-e298a7fc28b7',), {'subgraph_node_2': {'foo': 'hi! foobar'}})
  ((), {'node_2': {'foo': 'hi! foobar'}})
  ```
</Accordion>

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/oss/langgraph/use-subgraphs.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

**Examples:**

Example 1 (unknown):
```unknown
If you want the subgraph to **have its own memory**, you can compile it with the appropriate checkpointer option. This is useful in [multi-agent](/oss/python/langchain/multi-agent) systems, if you want agents to keep track of their internal message histories:
```

Example 2 (unknown):
```unknown
## View subgraph state

When you enable [persistence](/oss/python/langgraph/persistence), you can [inspect the graph state](/oss/python/langgraph/persistence#checkpoints) (checkpoint) via the appropriate method. To view the subgraph state, you can use the subgraphs option.

You can inspect the graph state via `graph.get_state(config)`. To view the subgraph state, you can use `graph.get_state(config, subgraphs=True)`.

<Warning>
  **Available **only** when interrupted**
  Subgraph state can only be viewed **when the subgraph is interrupted**. Once you resume the graph, you won't be able to access the subgraph state.
</Warning>

<Accordion title="View interrupted subgraph state">
```

Example 3 (unknown):
```unknown
1. This will be available only when the subgraph is interrupted. Once you resume the graph, you won't be able to access the subgraph state.
</Accordion>

## Stream subgraph outputs

To include outputs from subgraphs in the streamed outputs, you can set the subgraphs option in the stream method of the parent graph. This will stream outputs from both the parent graph and any subgraphs.
```

Example 4 (unknown):
```unknown
<Accordion title="Stream from subgraphs">
```

---

## model_1 is tagged with "joke"

**URL:** llms-txt#model_1-is-tagged-with-"joke"

model_1 = init_chat_model(model="gpt-4o-mini", tags=['joke'])

---

## This invocation will take ~1 second due to the slow_task execution

**URL:** llms-txt#this-invocation-will-take-~1-second-due-to-the-slow_task-execution

**Contents:**
- Human-in-the-loop
  - Basic human-in-the-loop workflow

try:
    # First invocation will raise an exception due to the `get_info` task failing
    main.invoke({'any_input': 'foobar'}, config=config)
except ValueError:
    pass  # Handle the failure gracefully
python  theme={null}
main.invoke(None, config=config)
pycon  theme={null}
'Ran slow task.'
python  theme={null}
from langgraph.func import entrypoint, task
from langgraph.types import Command, interrupt

@task
def step_1(input_query):
    """Append bar."""
    return f"{input_query} bar"

@task
def human_feedback(input_query):
    """Append user input."""
    feedback = interrupt(f"Please provide feedback: {input_query}")
    return f"{input_query} {feedback}"

@task
def step_3(input_query):
    """Append qux."""
    return f"{input_query} qux"
python  theme={null}
from langgraph.checkpoint.memory import InMemorySaver

checkpointer = InMemorySaver()

@entrypoint(checkpointer=checkpointer)
def graph(input_query):
    result_1 = step_1(input_query).result()
    result_2 = human_feedback(result_1).result()
    result_3 = step_3(result_2).result()

return result_3
python  theme={null}
config = {"configurable": {"thread_id": "1"}}

for event in graph.stream("foo", config):
    print(event)
    print("\n")
python  theme={null}

**Examples:**

Example 1 (unknown):
```unknown
When we resume execution, we won't need to re-run the `slow_task` as its result is already saved in the checkpoint.
```

Example 2 (unknown):
```unknown

```

Example 3 (unknown):
```unknown
## Human-in-the-loop

The functional API supports [human-in-the-loop](/oss/python/langgraph/interrupts) workflows using the [`interrupt`](https://reference.langchain.com/python/langgraph/types/#langgraph.types.interrupt) function and the `Command` primitive.

### Basic human-in-the-loop workflow

We will create three [tasks](/oss/python/langgraph/functional-api#task):

1. Append `"bar"`.
2. Pause for human input. When resuming, append human input.
3. Append `"qux"`.
```

Example 4 (unknown):
```unknown
We can now compose these tasks in an [entrypoint](/oss/python/langgraph/functional-api#entrypoint):
```

---

## maxReplicas: 16

**URL:** llms-txt#maxreplicas:-16

---

## Share or unshare a trace publicly

**URL:** llms-txt#share-or-unshare-a-trace-publicly

Source: https://docs.langchain.com/langsmith/share-trace

<Warning>
  **Sharing a trace publicly will make it accessible to anyone with the link. Make sure you're not sharing sensitive information.**

If your self-hosted or hybrid LangSmith deployment is within a VPC, then the public link is accessible only to members authenticated within your VPC. For enhanced security, we recommend configuring your instance with a private URL accessible only to users with access to your network.
</Warning>

To share a trace publicly, simply click on the **Share** button in the upper right hand side of any trace view.
<img src="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=f4d51afcb8b75809a08cf254b1797172" alt="" data-og-width="2011" width="2011" data-og-height="1005" height="1005" data-path="langsmith/images/share-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=280&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=2580f397804e880fa5772dd5541347b3 280w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=560&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=d73de3d28cddf8585257cc5671218af4 560w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=840&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=9495226170662b9eb0c270e2c9443210 840w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=1100&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=5f6f3b2a45a50a6610dd16f591651a82 1100w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=1650&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=ef2e10b3ae15f87d85bf8b5bde7f9e02 1650w, https://mintcdn.com/langchain-5e9cc07a/ImHGLQW1HnQYwnJV/langsmith/images/share-trace.png?w=2500&fit=max&auto=format&n=ImHGLQW1HnQYwnJV&q=85&s=a2fb5e488e6b18113b6dd82457fc1720 2500w" />

This will open a dialog where you can copy the link to the trace.

Shared traces will be accessible to anyone with the link, even if they don't have a LangSmith account. They will be able to view the trace, but not edit it.

To "unshare" a trace, either:

1. Click on **Unshare** by clicking on **Public** in the upper right hand corner of any publicly shared trace, then **Unshare** in the dialog.
   <img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=30504d6c7fe0ee5d3c6bf9b52a9c3d77" alt="" data-og-width="750" width="750" data-og-height="223" height="223" data-path="langsmith/images/unshare-trace.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=fd6850366fbdadfe8b60af3d675b7e7a 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=f992e5a88562a93b88a0ce114452d426 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=322987d1e066b41d6c5eef49ad95f4a7 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=0a9ff17d3ebb1e7ab9c3777bc9eea051 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=be39ee08bd403a1c890687feaa3eb870 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=99898693ec9d411c396104fc8dc9196d 2500w" />

2. Navigate to your organization's list of publicly shared traces, by clicking on **Settings** -> **Shared URLs**, then click on **Unshare** next to the trace you want to unshare.
   <img src="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=e139222bbde3e2b9530e92164e0e1efe" alt="" data-og-width="2294" width="2294" data-og-height="1113" height="1113" data-path="langsmith/images/unshare-trace-list-share.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=280&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=fcd07bdf6a4968cefb9d13ab1c447e17 280w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=560&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=5010be488c821b690b0c63b3eeb47e1c 560w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=840&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=aba6af3a7889f20a7b7c00ca01633bde 840w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=1100&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=efb8fd990042f594a07dde88d61a434c 1100w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=1650&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=309427d94d2db88d43930b7de9b8ac65 1650w, https://mintcdn.com/langchain-5e9cc07a/1RIJxfRpkszanJLL/langsmith/images/unshare-trace-list-share.png?w=2500&fit=max&auto=format&n=1RIJxfRpkszanJLL&q=85&s=2b708410fd513598eb49e354aae33571 2500w" />

<Callout icon="pen-to-square" iconType="regular">
  [Edit the source of this page on GitHub.](https://github.com/langchain-ai/docs/edit/main/src/langsmith/share-trace.mdx)
</Callout>

<Tip icon="terminal" iconType="regular">
  [Connect these docs programmatically](/use-these-docs) to Claude, VSCode, and more via MCP for real-time answers.
</Tip>

---

## Organization and workspace operations reference

**URL:** llms-txt#organization-and-workspace-operations-reference

**Contents:**
- Contents
- Legend
- Organization-level operations
  - Organization settings
  - Workspaces
  - Organization members
  - Roles and permissions
  - SSO and authentication
  - SCIM
  - Access policies

Source: https://docs.langchain.com/langsmith/organization-workspace-operations

This page provides a comprehensive reference table of [workspace](/langsmith/administration-overview#workspaces) and [organization](/langsmith/administration-overview#organizations) operations and which roles can perform them.

The list includes API operations in LangSmith along with:

* Which system roles can perform each operation.
* The specific permission string required.
* Notes about partial access or special cases.

<Info>
  For an overview of LangSmith's RBAC system, role definitions, and permission concepts, refer to [Role-based access control](/langsmith/rbac).
</Info>

| Organization-level operations                                                                                                                                                                                                                                                                               | Workspace-level operations                                                                                                                                                                                                                                                                                    |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Core management:**<br />• [Organization settings](#organization-settings): Org info and configuration<br />• [Workspaces](#workspaces): Workspace management<br />• [Organization members](#organization-members): Member management<br />• [Roles and permissions](#roles-and-permissions): Custom roles | **Core resources:**<br />• [Projects](#projects): Organize traces and runs<br />• [Runs](#runs): Individual execution traces<br />• [Datasets](#datasets): Test datasets for evaluation<br />• [Examples](#examples): Individual dataset examples<br />• [Experiments](#experiments): Comparative experiments |
| **Security and authentication:**<br />• [SSO and authentication](#sso-and-authentication): Single sign-on setup<br />• [SCIM](#scim): Identity provisioning<br />• [Access policies](#access-policies): Attribute-based access control                                                                      | **Monitoring and analysis:**<br />• [Rules](#rules): Automated run rules<br />• [Alerts](#alerts): Alert rules for monitoring<br />• [Feedback](#feedback): Scores and labels on outputs<br />• [Annotation Queues](#annotation-queues): Human review queues<br />• [Charts](#charts): Custom visualizations  |
| **Billing and accounts:**<br />• [Billing and payments](#billing-and-payments): Subscription management<br />• [API keys](#api-keys): Org-level keys                                                                                                                                                        | **Development and configuration:**<br />• [Prompts](#prompts): Prompt templates (LangChain Hub)<br />• [Deployments](#deployments): Deployment configurations<br />• [MCP Servers](#mcp-servers): Model Context Protocol servers                                                                              |
| **Analytics:**<br />• [Charts and dashboards](#organization-charts-and-dashboards): Org-level visualizations<br />• [Usage and analytics](#usage-and-analytics): Usage tracking and TTL settings                                                                                                            | **Workspace management:**<br />• [Workspace settings](#workspace-settings-and-management): Members, settings<br />• [Tags](#tags): Metadata tagging system<br />• [Bulk Exports](#bulk-exports): Data export operations                                                                                       |

**Additional information:**

* [User-level operations](#user-level-operations): Operations for all authenticated users
* [Permission inheritance](#permission-inheritance): How roles inherit across org/workspaces

* ✓ **Allowed**: User with this role can perform this action
* ✗ **Not Allowed**: User with this role cannot perform this action
* ⚠ **Partial**: User has limited access (see notes)

## Organization-level operations

<Info>
  Organization-level operations are controlled by organization roles, which are separate from the RBAC feature. Learn more in the [Role-based access control](/langsmith/rbac#organization-roles) guide.
</Info>

### Organization settings

| Operation                   | Org Admin | Org User | Org Viewer | Required Permission   |
| --------------------------- | :-------: | :------: | :--------: | --------------------- |
| View organization info      |     ✓     |     ✓    |      ✓     | `organization:read`   |
| View organization dashboard |     ✓     |     ✓    |      ✓     | `organization:read`   |
| Update organization info    |     ✓     |     ✗    |      ✗     | `organization:manage` |
| View billing info           |     ✓     |     ✓    |      ✓     | `organization:read`   |
| View company info           |     ✓     |     ✓    |      ✓     | `organization:read`   |
| Set company info            |     ✓     |     ✗    |      ✗     | `organization:manage` |

Organization-level workspace management operations.

| Operation           | Org Admin | Org User | Org Viewer | Required Permission   |
| ------------------- | :-------: | :------: | :--------: | --------------------- |
| List all workspaces |     ✓     |     ✓    |      ✓     | `organization:read`   |
| Create workspace    |     ✓     |     ✗    |      ✗     | `organization:manage` |

### Organization members

| Operation                       | Org Admin | Org User | Org Viewer | Required Permission   |
| ------------------------------- | :-------: | :------: | :--------: | --------------------- |
| View organization members       |     ✓     |     ✓    |      ✓     | `organization:read`   |
| View active org members         |     ✓     |     ✓    |      ✓     | `organization:read`   |
| View pending org members        |     ✓     |     ✓    |      ✓     | `organization:read`   |
| Invite member to organization   |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Invite members (batch)          |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Add basic auth members          |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Remove organization member      |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Update organization member role |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Delete pending org member       |     ✓     |     ✗    |      ✗     | `organization:manage` |

### Roles and permissions

| Operation                  | Org Admin | Org User | Org Viewer | Required Permission   |
| -------------------------- | :-------: | :------: | :--------: | --------------------- |
| List organization roles    |     ✓     |     ✓    |      ✓     | `organization:read`   |
| List available permissions |     ✓     |     ✓    |      ✓     | N/A (user-level)      |
| Create custom role         |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Update custom role         |     ✓     |     ✗    |      ✗     | `organization:manage` |
| Delete custom role         |     ✓     |     ✗    |      ✗     | `organization:manage` |

### SSO and authentication

| Operation                    | Org Admin | Org User | Org Viewer | Required Permission   |
| ---------------------------- | :-------: | :------: | :--------: | --------------------- |
| View SSO settings            |     ✓     |     ✓   