# MCPサーバー評価ガイド

## 概要

このドキュメントでは、MCPサーバーの包括的な評価を作成するためのガイダンスを提供します。評価は、LLMが提供されたツールのみを使用して現実的で複雑な質問に答えるために、MCPサーバーを効果的に使用できるかをテストします。

---

## クイックリファレンス

### 評価要件
- 人間が読みやすい10個の質問を作成
- 質問は読み取り専用、独立、非破壊的でなければならない
- 各質問は複数のツール呼び出しを必要とする（潜在的に数十回）
- 答えは単一で検証可能な値でなければならない
- 答えは安定的でなければならない（時間の経過で変化しない）

### 出力形式
```xml
<evaluation>
   <qa_pair>
      <question>ここに質問を記載</question>
      <answer>単一の検証可能な答え</answer>
   </qa_pair>
</evaluation>
```

---

## 評価の目的

MCPサーバーの品質の尺度は、サーバーがツールをどれだけ良く、包括的に実装しているかではなく、これらの実装（入力/出力スキーマ、ドキュメント文字列/説明、機能）が、他のコンテキストなしでMCPサーバーのみにアクセスできるLLMが現実的で難しい質問に答えることをどれだけよく可能にするかです。

## 評価の概要

読み取り専用、独立、非破壊的、そして冪等な操作のみを必要とする人間が読みやすい10個の質問を作成します。各質問は以下の特徴を持つべきです：
- 現実的
- 明確で簡潔
- 曖昧でない
- 複雑で、潜在的に数十回のツール呼び出しやステップを必要とする
- 事前に特定する単一の検証可能な値で答えられる

## 質問ガイドライン

### 核心要件

1. **質問は独立していなければならない**
   - 各質問は他の質問の答えに依存してはならない
   - 他の質問の処理から事前の書き込み操作を仮定してはならない

2. **質問は非破壊的で冪等なツールの使用のみを必要としなければならない**
   - 正しい答えに到達するために状態を変更することを指示または要求してはならない

3. **質問は現実的、明確、簡潔、複雑でなければならない**
   - 他のLLMが答えるために複数（潜在的に数十）のツールまたはステップを使用する必要がある

### 複雑さと深さ

4. **質問は深い探索を必要としなければならない**
   - 複数のサブ質問と順次ツール呼び出しを必要とするマルチホップ質問を検討
   - 各ステップは前の質問で見つかった情報から利益を得るべき

5. **質問は広範なページングを必要とする場合がある**
   - 複数ページの結果をページングする必要がある場合がある
   - ニッチな情報を見つけるために古いデータ（1〜2年前）をクエリする必要がある場合がある
   - 質問は困難でなければならない

6. **質問は深い理解を必要としなければならない**
   - 表面的な知識ではなく
   - 証拠を必要とする真/偽の質問として複雑なアイデアを提起する場合がある
   - LLMが異なる仮説を検索しなければならない多肢選択形式を使用する場合がある

7. **質問は単純なキーワード検索で解決できてはならない**
   - ターゲットコンテンツから特定のキーワードを含めない
   - 同義語、関連概念、または言い換えを使用
   - 複数の検索、複数の関連項目の分析、コンテキストの抽出、その後答えの導出を必要とする

### ツールテスト

8. **質問はツールの戻り値をストレステストすべき**
   - LLMを圧倒する大きなJSONオブジェクトまたはリストを返すツールを誘発する場合がある
   - 複数のデータモダリティの理解を必要とすべき：
     - IDと名前
     - タイムスタンプと日時（月、日、年、秒）
     - ファイルID、名前、拡張子、MIMEタイプ
     - URL、GIDなど
   - ツールがすべての有用な形式のデータを返す能力を調査すべき

9. **質問はほとんど実際の人間の使用ケースを反映すべき**
   - LLMによって支援される人間が気にする情報検索タスクの種類

10. **質問は数十のツール呼び出しを必要とする場合がある**
    - これは限られたコンテキストを持つLLMに挑戦する
    - MCPサーバーツールが返される情報を減らすことを奨励する

11. **曖昧な質問を含める**
    - 曖昧であるか、どのツールを呼び出すかについて困難な決定を必要とする場合がある
    - LLMが潜在的にミスをしたり、誤解したりすることを強制する
    - 曖昧さにもかかわらず、単一の検証可能な答えがまだあることを確認する

### 安定性

12. **質問は答えが変化しないように設計されなければならない**
    - 動的な「現在の状態」に依存する質問をしない
    - 例えば、以下をカウントしない：
      - 投稿へのリアクション数
      - スレッドへの返信数
      - チャンネルのメンバー数

13. **MCPサーバーが作成する質問の種類を制限させない**
    - 挑戦的で複雑な質問を作成する
    - 一部は利用可能なMCPサーバーツールで解決できない可能性がある
    - 質問は特定の出力形式を必要とする場合がある（日時 vs エポックタイム、JSON vs MARKDOWN）
    - 質問は完了するために数十のツール呼び出しを必要とする場合がある

## 答えガイドライン

### 検証

1. **答えは直接の文字列比較で検証可能でなければならない**
   - 答えが多くの形式で書き直される可能性がある場合は、質問で出力形式を明確に指定する
   - 例：「YYYY/MM/DDを使用」、「TrueまたはFalseで応答」、「A、B、C、またはDのみで答える」
   - 答えは以下のような単一の検証可能な値であるべき：
     - ユーザーID、ユーザー名、表示名、名、姓
     - チャンネルID、チャンネル名
     - メッセージID、文字列
     - URL、タイトル
     - 数値量
     - タイムスタンプ、日時
     - ブール値（真/偽の質問用）
     - メールアドレス、電話番号
     - ファイルID、ファイル名、ファイル拡張子
     - 多肢選択の答え
   - 答えは特別なフォーマットや複雑で構造化された出力を必要としてはならない
   - 答えは直接の文字列比較を使用して検証される

### 可読性

2. **答えは一般的に人間が読みやすい形式を好むべき**
   - 例：名前、名、姓、日時、ファイル名、メッセージ文字列、URL、yes/no、true/false、a/b/c/d
   - 不透明なIDよりも（ただしIDも許容される）
   - 答えの大部分は人間が読みやすいものであるべき

### 安定性

3. **答えは安定的/定常的でなければならない**
   - 古いコンテンツを見る（例：終了した会話、開始されたプロジェクト、回答された質問）
   - 常に同じ答えを返す「閉じた」概念に基づいて質問を作成する
   - 質問は非定常な答えから隔離するために固定された時間枠を考慮するよう求める場合がある
   - 変更される可能性が低いコンテキストに依存する
   - 例：論文名を見つける場合、後で公開された論文と混同されないように十分に具体的である

4. **答えは明確で曖昧でない必要がある**
   - 質問は単一の明確な答えがあるように設計されなければならない
   - 答えはMCPサーバーツールを使用して導出できる

### 多様性

5. **答えは多様でなければならない**
   - 答えは多様なモダリティと形式の単一の検証可能な値であるべき
   - ユーザー概念：ユーザーID、ユーザー名、表示名、名、姓、メールアドレス、電話番号
   - チャンネル概念：チャンネルID、チャンネル名、チャンネルトピック
   - メッセージ概念：メッセージID、メッセージ文字列、タイムスタンプ、月、日、年

6. **答えは複雑な構造であってはならない**
   - 値のリストではない
   - 複雑なオブジェクトではない
   - IDまたは文字列のリストではない
   - 自然言語テキストではない
   - 答えが直接の文字列比較を使用して簡単に検証できる場合を除く
   - そして現実的に再現可能である
   - LLMが同じリストを他の順序や形式で返す可能性は低いはず

## 評価プロセス

### ステップ1：ドキュメント検査

ターゲットAPIのドキュメントを読んで理解する：
- 利用可能なエンドポイントと機能
- 曖昧さが存在する場合は、Webから追加情報を取得
- このステップを可能な限り並列化
- 各サブエージェントがファイルシステムまたはWeb上のドキュメントのみを調べていることを確認

### ステップ2：ツール検査

MCPサーバーで利用可能なツールをリスト：
- MCPサーバーを直接検査
- 入力/出力スキーマ、ドキュメント文字列、説明を理解
- この段階ではツール自体を呼び出さない

### ステップ3：理解の発展

良い理解が得られるまでステップ1と2を繰り返す：
- 複数回反復
- 作成したいタスクの種類を考える
- 理解を洗練する
- いかなる段階でもMCPサーバー実装自体のコードを読まない
- 直感と理解を使用して、合理的で現実的だが非常に挑戦的なタスクを作成

### ステップ4：読み取り専用コンテンツ検査

APIとツールを理解した後、MCPサーバーツールを使用：
- 読み取り専用および非破壊的な操作のみを使用してコンテンツを検査
- 目標：現実的な質問を作成するための特定のコンテンツ（例：ユーザー、チャンネル、メッセージ、プロジェクト、タスク）を特定
- 状態を変更するツールを呼び出さない
- MCPサーバー実装自体のコードを読まない
- 個々のサブエージェントが独立した探索を追求してこのステップを並列化
- 各サブエージェントが読み取り専用、非破壊的、冪等な操作のみを実行していることを確認
- 注意：一部のツールはコンテキストが不足する原因となる大量のデータを返す可能性がある
- 探索のために増分的、小さく、ターゲットを絞ったツール呼び出しを行う
- すべてのツール呼び出しリクエストで、結果を制限するために`limit`パラメータを使用（<10）
- ページネーションを使用

### ステップ5：タスク生成

コンテンツを検査した後、人間が読みやすい10個の質問を作成：
- LLMはMCPサーバーでこれらに答えることができるはず
- 上記のすべての質問と答えのガイドラインに従う

## 出力形式

各QAペアは質問と答えで構成されます。出力はこの構造を持つXMLファイルである必要があります：

```xml
<evaluation>
   <qa_pair>
      <question>2024年Q2に作成され、完了したタスクが最も多いプロジェクトを見つけてください。プロジェクト名は何ですか？</question>
      <answer>ウェブサイトリデザイン</answer>
   </qa_pair>
   <qa_pair>
      <question>2024年3月に閉じられた「bug」ラベル付きのイシューを検索してください。最も多くのイシューを閉じたユーザーは誰ですか？ユーザー名を提供してください。</question>
      <answer>sarah_dev</answer>
   </qa_pair>
   <qa_pair>
      <question>/apiディレクトリ内のファイルを変更し、2024年1月1日から1月31日の間にマージされたプルリクエストを探してください。これらのPRに何人の異なるコントリビューターが作業しましたか？</question>
      <answer>7</answer>
   </qa_pair>
   <qa_pair>
      <question>2023年以前に作成された最も多くのスターを持つリポジトリを見つけてください。リポジトリ名は何ですか？</question>
      <answer>data-pipeline</answer>
   </qa_pair>
</evaluation>
```

## 評価例

### 良い質問

**例1：深い探索を必要とするマルチホップ質問（GitHub MCP）**
```xml
<qa_pair>
   <question>2023年Q3にアーカイブされ、以前は組織内で最もフォークされたプロジェクトだったリポジトリを見つけてください。そのリポジトリで使用されていた主要なプログラミング言語は何ですか？</question>
   <answer>Python</answer>
</qa_pair>
```

この質問が良い理由：
- アーカイブされたリポジトリを見つけるために複数の検索が必要
- アーカイブ前に最も多くのフォークを持っていたものを特定する必要がある
- 言語のためにリポジトリの詳細を調べる必要がある
- 答えは単純で検証可能な値
- 変更されない履歴（閉じられた）データに基づいている

**例2：キーワードマッチングなしでコンテキストの理解を必要とする（プロジェクト管理MCP）**
```xml
<qa_pair>
   <question>2023年後半に完了した顧客オンボーディングの改善に焦点を当てたイニシアチブを見つけてください。プロジェクトリーダーは完了後に振り返りドキュメントを作成しました。その時点でのリーダーの役職は何でしたか？</question>
   <answer>プロダクトマネージャー</answer>
</qa_pair>
```

この質問が良い理由：
- 特定のプロジェクト名を使用しない（「顧客オンボーディングの改善に焦点を当てたイニシアチブ」）
- 特定の時間枠から完了したプロジェクトを見つける必要がある
- プロジェクトリーダーとその役割を特定する必要がある
- 振り返りドキュメントからコンテキストを理解する必要がある
- 答えは人間が読みやすく安定している
- 完了した作業に基づいている（変更されない）

**例3：複数ステップを必要とする複雑な集計（イシュートラッカーMCP）**
```xml
<qa_pair>
   <question>2024年1月に報告されたすべてのバグの中で、重要な優先度とマークされたもののうち、割り当てられたバグの最も高い割合を48時間以内に解決したアサイニーは誰ですか？アサイニーのユーザー名を提供してください。</question>
   <answer>alex_eng</answer>
</qa_pair>
```

この質問が良い理由：
- 日付、優先度、ステータスでバグをフィルタリングする必要がある
- アサイニーごとにグループ化して解決率を計算する必要がある
- 48時間のウィンドウを決定するためにタイムスタンプを理解する必要がある
- ページネーションをテスト（処理する潜在的に多くのバグ）
- 答えは単一のユーザー名
- 特定の期間の履歴データに基づいている

**例4：複数のデータタイプ間での統合が必要（CRM MCP）**
```xml
<qa_pair>
   <question>2023年Q4にスタータープランからエンタープライズプランにアップグレードし、最高の年間契約価値を持っていたアカウントを見つけてください。このアカウントはどの業界で運営されていますか？</question>
   <answer>ヘルスケア</answer>
</qa_pair>
```

この質問が良い理由：
- サブスクリプション層の変更を理解する必要がある
- 特定の時間枠でアップグレードイベントを特定する必要がある
- 契約価値を比較する必要がある
- アカウントの業界情報にアクセスする必要がある
- 答えは単純で検証可能
- 完了した履歴トランザクションに基づいている

### 悪い質問

**例1：時間の経過で答えが変化する**
```xml
<qa_pair>
   <question>現在エンジニアリングチームに割り当てられているオープンイシューはいくつありますか？</question>
   <answer>47</answer>
</qa_pair>
```

この質問が悪い理由：
- イシューが作成、閉じられる、または再割り当てされると答えが変化する
- 安定的/定常的なデータに基づいていない
- 動的な「現在の状態」に依存している

**例2：キーワード検索で簡単すぎる**
```xml
<qa_pair>
   <question>「認証機能を追加」というタイトルのプルリクエストを見つけて、誰が作成したか教えてください。</question>
   <answer>developer123</answer>
</qa_pair>
```

この質問が悪い理由：
- 正確なタイトルの単純なキーワード検索で解決できる
- 深い探索や理解を必要としない
- 統合や分析が必要ない

**例3：曖昧な答えの形式**
```xml
<qa_pair>
   <question>Pythonを主要言語として持つすべてのリポジトリをリストしてください。</question>
   <answer>repo1, repo2, repo3, data-pipeline, ml-tools</answer>
</qa_pair>
```

この質問が悪い理由：
- 答えは任意の順序で返される可能性のあるリスト
- 直接の文字列比較で検証するのが困難
- LLMは異なる形式で（JSON配列、カンマ区切り、改行区切り）フォーマットする可能性がある
- 特定の集計（カウント）または最上級（最も多くのスター）を求める方が良い

## 検証プロセス

評価を作成した後：

1. **XMLファイルを調べて**スキーマを理解
2. **各タスクの指示を読み込み**、MCPサーバーとツールを使用して並列に、自分でタスクを解決することで正しい答えを特定
3. **書き込みまたは破壊的な操作を必要とする操作にフラグを立てる**
4. **すべての正しい答えを蓄積**し、ドキュメント内の誤った答えを置き換える
5. **書き込みまたは破壊的な操作を必要とする`<qa_pair>`を削除**

コンテキストが不足しないようにタスクの解決を並列化し、すべての答えを蓄積して最後にファイルに変更を加えることを忘れないでください。

## 品質評価作成のヒント

1. **タスクを生成する前によく考えて計画する**
2. **機会があるところで並列化**してプロセスを高速化し、コンテキストを管理
3. **人間が実際に達成したいと思う現実的な使用ケースに焦点を当てる**
4. **MCPサーバーの機能の限界をテストする挑戦的な質問を作成**
5. **履歴データと閉じた概念を使用して安定性を確保**
6. **MCPサーバーツールを使用して自分で質問を解決して答えを検証**
7. **プロセス中に学んだことに基づいて反復し、洗練する**

---

# 評価の実行

評価ファイルを作成した後、提供された評価ハーネスを使用してMCPサーバーをテストできます。

## セットアップ

1. **依存関係のインストール**

   ```bash
   pip install -r scripts/requirements.txt
   ```

   または手動でインストール：
   ```bash
   pip install anthropic mcp
   ```

2. **APIキーの設定**

   ```bash
   export ANTHROPIC_API_KEY=your_api_key_here
   ```

## 評価ファイル形式

評価ファイルは`<qa_pair>`要素を含むXML形式を使用します：

```xml
<evaluation>
   <qa_pair>
      <question>2024年Q2に作成され、完了したタスクが最も多いプロジェクトを見つけてください。プロジェクト名は何ですか？</question>
      <answer>ウェブサイトリデザイン</answer>
   </qa_pair>
   <qa_pair>
      <question>2024年3月に閉じられた「bug」ラベル付きのイシューを検索してください。最も多くのイシューを閉じたユーザーは誰ですか？ユーザー名を提供してください。</question>
      <answer>sarah_dev</answer>
   </qa_pair>
</evaluation>
```

## 評価の実行

評価スクリプト（`scripts/evaluation.py`）は3つのトランスポートタイプをサポートします：

**重要：**
- **stdioトランスポート**：評価スクリプトは自動的にMCPサーバープロセスを起動して管理します。サーバーを手動で実行しないでください。
- **sse/httpトランスポート**：評価を実行する前にMCPサーバーを別途起動する必要があります。スクリプトは指定されたURLで既に実行中のサーバーに接続します。

### 1. ローカルSTDIOサーバー

ローカル実行MCPサーバーの場合（スクリプトが自動的にサーバーを起動）：

```bash
python scripts/evaluation.py \
  -t stdio \
  -c python \
  -a my_mcp_server.py \
  evaluation.xml
```

環境変数付き：
```bash
python scripts/evaluation.py \
  -t stdio \
  -c python \
  -a my_mcp_server.py \
  -e API_KEY=abc123 \
  -e DEBUG=true \
  evaluation.xml
```

### 2. Server-Sent Events (SSE)

SSEベースのMCPサーバーの場合（最初にサーバーを起動する必要があります）：

```bash
python scripts/evaluation.py \
  -t sse \
  -u https://example.com/mcp \
  -H "Authorization: Bearer token123" \
  -H "X-Custom-Header: value" \
  evaluation.xml
```

### 3. HTTP（ストリーマブルHTTP）

HTTPベースのMCPサーバーの場合（最初にサーバーを起動する必要があります）：

```bash
python scripts/evaluation.py \
  -t http \
  -u https://example.com/mcp \
  -H "Authorization: Bearer token123" \
  evaluation.xml
```

## コマンドラインオプション

```
使用法: evaluation.py [-h] [-t {stdio,sse,http}] [-m MODEL] [-c COMMAND]
                     [-a ARGS [ARGS ...]] [-e ENV [ENV ...]] [-u URL]
                     [-H HEADERS [HEADERS ...]] [-o OUTPUT]
                     eval_file

位置引数:
  eval_file             評価XMLファイルへのパス

オプション引数:
  -h, --help            ヘルプメッセージを表示
  -t, --transport       トランスポートタイプ: stdio、sse、またはhttp（デフォルト: stdio）
  -m, --model           使用するClaudeモデル（デフォルト: claude-3-7-sonnet-20250219）
  -o, --output          レポートの出力ファイル（デフォルト: stdoutに出力）

stdioオプション:
  -c, --command         MCPサーバーを実行するコマンド（例：python、node）
  -a, --args            コマンドの引数（例：server.py）
  -e, --env             KEY=VALUE形式の環境変数

sse/httpオプション:
  -u, --url             MCPサーバーURL
  -H, --header          'Key: Value'形式のHTTPヘッダー
```

## 出力

評価スクリプトは以下を含む詳細なレポートを生成します：

- **サマリー統計**：
  - 精度（正解/合計）
  - 平均タスク継続時間
  - タスクごとの平均ツール呼び出し
  - 合計ツール呼び出し

- **タスクごとの結果**：
  - プロンプトと期待される応答
  - エージェントからの実際の応答
  - 答えが正しかったかどうか（✅/❌）
  - 継続時間とツール呼び出しの詳細
  - エージェントのアプローチの要約
  - ツールに関するエージェントのフィードバック

### レポートをファイルに保存

```bash
python scripts/evaluation.py \
  -t stdio \
  -c python \
  -a my_server.py \
  -o evaluation_report.md \
  evaluation.xml
```

## 完全な例のワークフロー

評価の作成と実行の完全な例：

1. **評価ファイルを作成**（`my_evaluation.xml`）：

```xml
<evaluation>
   <qa_pair>
      <question>2024年1月に最も多くのイシューを作成したユーザーを見つけてください。ユーザー名は何ですか？</question>
      <answer>alice_developer</answer>
   </qa_pair>
   <qa_pair>
      <question>2024年Q1にマージされたすべてのプルリクエストの中で、どのリポジトリが最も多くを持っていましたか？リポジトリ名を提供してください。</question>
      <answer>backend-api</answer>
   </qa_pair>
   <qa_pair>
      <question>2023年12月に完了し、開始から終了まで最も長い期間を要したプロジェクトを見つけてください。何日かかりましたか？</question>
      <answer>127</answer>
   </qa_pair>
</evaluation>
```

2. **依存関係をインストール**：

```bash
pip install -r scripts/requirements.txt
export ANTHROPIC_API_KEY=your_api_key
```

3. **評価を実行**：

```bash
python scripts/evaluation.py \
  -t stdio \
  -c python \
  -a github_mcp_server.py \
  -e GITHUB_TOKEN=ghp_xxx \
  -o github_eval_report.md \
  my_evaluation.xml
```

4. **`github_eval_report.md`でレポートを確認**して：
   - どの質問が合格/失敗したかを見る
   - ツールに関するエージェントのフィードバックを読む
   - 改善すべき領域を特定する
   - MCPサーバーの設計を反復する

## トラブルシューティング

### 接続エラー

接続エラーが発生した場合：
- **STDIO**：コマンドと引数が正しいことを確認
- **SSE/HTTP**：URLがアクセス可能でヘッダーが正しいことを確認
- 必要なAPIキーが環境変数またはヘッダーに設定されていることを確認

### 低精度

多くの評価が失敗する場合：
- 各タスクのエージェントのフィードバックを確認
- ツールの説明が明確で包括的かどうかを確認
- 入力パラメータが十分に文書化されていることを確認
- ツールがデータを返しすぎたり、少なすぎたりしないか検討
- エラーメッセージが実行可能であることを確認

### タイムアウトの問題

タスクがタイムアウトする場合：
- より能力の高いモデルを使用（例：`claude-3-7-sonnet-20250219`）
- ツールがデータを返しすぎていないか確認
- ページネーションが正しく機能していることを確認
- 複雑な質問を簡略化することを検討