**NOTE:** This is heavily WIP! This line will be removed when the langref is considered complete, and at that point, missing sections and outdated information will be considered bugs. If you'd like to contribute to this (other than minor corrections of obvious mistakes), **definitely** mention it in the [langref Zulip channel](https://roc.zulipchat.com/#narrow/channel/316715-contributing/topic/language.20reference/with/564909757) before getting started on anything!

# Language Reference

This is Roc's language reference (or _langref_ for short).

If you're looking for a beginner tutoral, check out [roc-lang.org/tutorial](https://roc-lang.org/tutorial) instead; the langref is a detailed reference intended for experienced Roc programmers.

## Outline

- [Expressions](expressions)
  - [Values](expressions#values)
    - [Reference Counting](expressions#reference-counting)
    - [Reference Cycles](expressions#reference-cycles)
    - [Opportunistic Mutation](expressions#opportunistic-mutation)
  - [Block Expressions](expressions#block-expressions)
- [Statements](statements)
  - [`=` (assignment)](statements#assignment)
  - [`import`](statements#import)
  - [`expect`](statements#expect)
  - [`return`](statements#return)
  - [`break`](statements#break)
  - [`continue`](statements#continue)
  - [Block Statements](statements#block-statements)
- [Conditionals](conditionals)
  - [`if`](conditionals#if)
  - [`else`](conditionals#else)
    - [`else if`](conditionals#else-if)
  - [`and`](conditionals#and)
  - [`or`](conditionals#or)
  - [`match`](conditionals#match)
- [Pattern Matching](pattern-matching)
  - [`match`](pattern-matching#match)
    - [Branch Alternatives](pattern-matching#alternatives)
    - [`if` Guards on Branches](pattern-matching#if-guards-on-branches)
  - [Exhaustiveness](pattern-matching#exhaustiveness)
    - [Catch-all Patterns (`_`)](pattern-matching#catch-all-patterns-underscore)
  - [Destructuring](pattern-matching#destructuring)
    - [Destructuring Assignments (with `=`)](pattern-matching#destructuring-assignments)
- [Functions](functions)
  - [Pure Functions](functions#pure-functions)
  - [Effectful Functions](functions#effectful-functions)
    - [`!` suffix](functions#!-suffix)
  - [Recursive Functions](functions#recursive-functions)
    - [Self-recursive Functions](functions#self-recursive-functions)
    - [Mutually Recursive Functions](functions#mutually-recursive-functions)
  - [Tail Calls](functions#tail-calls)
    - [Self-tail Calls](functions#self-tail-calls)
    - [Tail Call Optimization](functions#tail-call-optimization)
      - [Modulo Cons](functions#modulo-cons)
- [Naming](naming)
  - [Shadowing](naming#shadowing)
  - [Constants](naming#constants)
  - [Variables (with `var`)](naming#variables)
    - [`var` keyword](naming#var-keyword)
    - [`$` suffix](naming#$-suffix)
  - [Type Variables](naming#type-variables)
  - [Type Aliases](naming#type-aliases)
    - [Parameterized Type Aliases](naming#parameterized-type-aliases)
  - [Module Names](naming#module-names)
  - [`as`](naming#as)
- [Modules](modules)
  - [Type Modules](modules#type-modules)
  - [Imports](modules#imports)
  - [Package Modules](modules#package-modules)
  - [Platform Modules](modules#platform-modules)
  - [Application Modules](modules#application-modules)
- [Types](types)
  - [Type Annotations](types#type-annotations)
    - [Where Clauses](types#where-clauses)
  - [Nominal Types](types#nominal-types)
    - [Opaque Nominal Types](types#opaque-nominal-types)
  - [Structural Types](types#structural-types)
  - [Type Aliases](types#type-aliases)
- [Static Dispatch](static-dispatch)
  - [Methods](static-dispatch#methods)
  - [Where Clauses](static-dispatch#where-clauses)
  - [Aliases](static-dispatch#aliases)
- [Operators](operators)
  - [Desugaring](operators#desugaring)
  - [Binary Infix Operations](operators#binary-infix-operations)
    - [And](operators#and)
    - [Or](operators#or)
    - [Arithmetic Operators](operators#arithmetic-operators)
    - [Comparison Operators](operators#comparison-operators)
  - [Unary Prefix Operators](operators#unary-prefix-operators)
    - [`-` (`.negate()`)](operators#-)
    - [`!` (`.not()`)](operators#-1)
  - [Unary Postfix Operators](operators#unary-postfix-operators)
    - [`?` (unwrap if `Ok`; early `return` if `Err`)](operators#-2)
    - [`[…]` (subscript operator)](operators#-subscript-operator)
- [Collections](collections)
  - [Structural Records](collections#structural-records)
  - [Nominal Records](collections#nominal-records)
  - [Tuples](collections#tuples)
  - [Structural Tag Unions](collections#structural-tag-unions)
  - [Nominal Tag Unions](collections#nominal-tag-unions)
  - [Builtin Collections](collections#builtin-collections)
- [Loops](loops)
  - [`for` Loops](loops#for)
  - [`while` Loop](loops#while)
  - [Infinite Loops](loops#infinite-loops)
