# Format Selection Guide

Choose the right output format for your research needs.

## Decision Tree

```
Is this comparing multiple options?
  ├─ YES → Use Comparison Format
  └─ NO ↓

Is this time-sensitive or simple?
  ├─ YES → Use Quick Brief
  └─ NO ↓

Does this require formal/extensive documentation?
  ├─ YES → Use Comprehensive Report
  └─ NO → Use Research Summary (default)
```

## Format Overview

| Format | Length | When to Use | Template |
|--------|--------|-------------|----------|
| [Research Summary](research-summary-format.md) | 500-1000 words | Most research requests (default) | [Template](research-summary-template.md) |
| [Comprehensive Report](comprehensive-report-format.md) | 1500+ words | Formal docs, strategic decisions | [Template](comprehensive-report-template.md) |
| [Quick Brief](quick-brief-format.md) | 200-400 words | Time-sensitive, simple topics | [Template](quick-brief-template.md) |
| [Comparison](comparison-format.md) | 800-1200 words | Evaluating options | [Template](comparison-template.md) |

## Formatting Guidelines

### Headings
- Use `#` for title
- Use `##` for major sections
- Use `###` for subsections
- Keep heading hierarchy consistent

### Lists
- Use `-` for bullet points
- Use `1.` for numbered lists
- Keep list items parallel in structure

### Emphasis
- Use `**bold**` for key terms and section labels
- Use `*italic*` for emphasis
- Use sparingly for maximum impact

### Citations
- Always use `<mention-page url="...">Page Title</mention-page>` for source pages
- Include citation immediately after referenced information
- Group all sources in a "Sources" section at the end

### Tables
- Use for structured data comparison
- Keep columns to 3-5 for readability
- Include header row
- Align content appropriately

### Code Blocks
Use when including:
- Technical specifications
- Configuration examples
- Command examples

```
Example code or configuration here
```

## Content Guidelines

### Executive Summaries
- Lead with the most important finding
- Include 1-2 key implications
- Make it standalone (reader gets value without reading further)
- Target 2-3 sentences for summaries, 1 paragraph for reports

### Key Findings
- Start with a clear headline
- Support with specific evidence
- Include relevant data points or quotes
- Cite source immediately
- Focus on actionable insights

### Recommendations
- Make them specific and actionable
- Explain the "why" behind each recommendation
- Prioritize clearly (Priority 1, 2, 3 or High/Medium/Low)
- Include implementation hints when relevant

### Source Citations
- Link to original pages using mentions
- Note if information is outdated (check last-edited dates)
- Credit specific sections when quoting
- Group related sources together

