# Platform Setup Checklists

Complete setup checklists for major ad platforms.

## Contents
- Google Ads Setup (Account Foundation, Conversion Tracking, Analytics Integration, Audience Setup, Campaign Readiness, Ad Extensions, Brand Protection)
- Meta Ads Setup (Business Manager Foundation, Pixel & Tracking, Domain & Aggregated Events, Audience Setup, Catalog, Creative Assets, Compliance)
- LinkedIn Ads Setup (Campaign Manager Foundation, Insight Tag & Tracking, Audience Setup, Lead Gen Forms, Document Ads, Creative Assets, Budget Considerations)
- Twitter/X Ads Setup (Account Foundation, Tracking, Audience Setup, Creative)
- TikTok Ads Setup (Account Foundation, Pixel & Tracking, Audience Setup, Creative)
- Universal Pre-Launch Checklist

## Google Ads Setup

### Account Foundation

- [ ] Google Ads account created and verified
- [ ] Billing information added
- [ ] Time zone and currency set correctly
- [ ] Account access granted to team members

### Conversion Tracking

- [ ] Google tag installed on all pages
- [ ] Conversion actions created (purchase, lead, signup)
- [ ] Conversion values assigned (if applicable)
- [ ] Enhanced conversions enabled
- [ ] Test conversions firing correctly
- [ ] Import conversions from GA4 (optional)

### Analytics Integration

- [ ] Google Analytics 4 linked
- [ ] Auto-tagging enabled
- [ ] GA4 audiences available in Google Ads
- [ ] Cross-domain tracking set up (if multiple domains)

### Audience Setup

- [ ] Remarketing tag verified
- [ ] Website visitor audiences created:
  - All visitors (180 days)
  - Key page visitors (pricing, demo, features)
  - Converters (for exclusion)
- [ ] Customer match lists uploaded
- [ ] Similar audiences enabled

### Campaign Readiness

- [ ] Negative keyword lists created:
  - Universal negatives (free, jobs, careers, reviews, complaints)
  - Competitor negatives (if needed)
  - Irrelevant industry terms
- [ ] Location targeting set (include/exclude)
- [ ] Language targeting set
- [ ] Ad schedule configured (if B2B, business hours)
- [ ] Device bid adjustments considered

### Ad Extensions

- [ ] Sitelinks (4-6 relevant pages)
- [ ] Callouts (key benefits, offers)
- [ ] Structured snippets (features, types, services)
- [ ] Call extension (if phone leads valuable)
- [ ] Lead form extension (if using)
- [ ] Price extensions (if applicable)
- [ ] Image extensions (where available)

### Brand Protection

- [ ] Brand campaign running (protect branded terms)
- [ ] Competitor campaigns considered
- [ ] Brand terms in negative lists for non-brand campaigns

---

## Meta Ads Setup

### Business Manager Foundation

- [ ] Business Manager created
- [ ] Business verified (if running certain ad types)
- [ ] Ad account created within Business Manager
- [ ] Payment method added
- [ ] Team access configured with proper roles

### Pixel & Tracking

- [ ] Meta Pixel installed on all pages
- [ ] Standard events configured:
  - PageView (automatic)
  - ViewContent (product/feature pages)
  - Lead (form submissions)
  - Purchase (conversions)
  - AddToCart (if e-commerce)
  - InitiateCheckout (if e-commerce)
- [ ] Conversions API (CAPI) set up for server-side tracking
- [ ] Event Match Quality score > 6
- [ ] Test events in Events Manager

### Domain & Aggregated Events

- [ ] Domain verified in Business Manager
- [ ] Aggregated Event Measurement configured
- [ ] Top 8 events prioritized in order of importance
- [ ] Web events prioritized for iOS 14+ tracking

### Audience Setup

- [ ] Custom audiences created:
  - Website visitors (all, 30/60/90/180 days)
  - Key page visitors
  - Video viewers (25%, 50%, 75%, 95%)
  - Page/Instagram engagers
  - Customer list uploaded
- [ ] Lookalike audiences created (1%, 1-3%)
- [ ] Saved audiences for common targeting

### Catalog (E-commerce)

- [ ] Product catalog connected
- [ ] Product feed updating correctly
- [ ] Catalog sales campaigns enabled
- [ ] Dynamic product ads configured

### Creative Assets

- [ ] Images in correct sizes:
  - Feed: 1080x1080 (1:1)
  - Stories/Reels: 1080x1920 (9:16)
  - Landscape: 1200x628 (1.91:1)
- [ ] Videos in correct formats
- [ ] Ad copy variations ready
- [ ] UTM parameters in all destination URLs

### Compliance

- [ ] Special Ad Categories declared (if housing, credit, employment, politics)
- [ ] Landing page complies with Meta policies
- [ ] No prohibited content in ads

---

## LinkedIn Ads Setup

### Campaign Manager Foundation

- [ ] Campaign Manager account created
- [ ] Company Page connected
- [ ] Billing information added
- [ ] Team access configured

### Insight Tag & Tracking

- [ ] LinkedIn Insight Tag installed on all pages
- [ ] Tag verified and firing
- [ ] Conversion tracking configured:
  - URL-based conversions
  - Event-specific conversions
- [ ] Conversion values set (if applicable)

### Audience Setup

- [ ] Matched Audiences created:
  - Website retargeting audiences
  - Company list uploaded (for ABM)
  - Contact list uploaded
- [ ] Lookalike audiences created
- [ ] Saved audiences for common targeting

### Lead Gen Forms (if using)

- [ ] Lead gen form templates created
- [ ] Form fields selected (minimize for conversion)
- [ ] Privacy policy URL added
- [ ] Thank you message configured
- [ ] CRM integration set up (or CSV export process)

### Document Ads (if using)

- [ ] Documents uploaded (PDF, PowerPoint)
- [ ] Gating configured (full gate or preview)
- [ ] Lead gen form connected

### Creative Assets

- [ ] Single image ads: 1200x627 (1.91:1) or 1080x1080 (1:1)
- [ ] Carousel images ready
- [ ] Video specs met (if using)
- [ ] Ad copy within character limits:
  - Intro text: 600 max, 150 recommended
  - Headline: 200 max, 70 recommended

### Budget Considerations

- [ ] Budget realistic for LinkedIn CPCs ($8-15+ typical)
- [ ] Audience size validated (50K+ recommended)
- [ ] Daily vs. lifetime budget decided
- [ ] Bid strategy selected

---

## Twitter/X Ads Setup

### Account Foundation

- [ ] Ads account created
- [ ] Payment method added
- [ ] Account verified (if required)

### Tracking

- [ ] Twitter Pixel installed
- [ ] Conversion events created
- [ ] Website tag verified

### Audience Setup

- [ ] Tailored audiences created:
  - Website visitors
  - Customer lists
- [ ] Follower lookalikes identified
- [ ] Interest and keyword targets researched

### Creative

- [ ] Tweet copy within 280 characters
- [ ] Images: 1200x675 (1.91:1) or 1200x1200 (1:1)
- [ ] Video specs met (if using)
- [ ] Cards configured (website, app, etc.)

---

## TikTok Ads Setup

### Account Foundation

- [ ] TikTok Ads Manager account created
- [ ] Business verification completed
- [ ] Payment method added

### Pixel & Tracking

- [ ] TikTok Pixel installed
- [ ] Events configured (ViewContent, Purchase, etc.)
- [ ] Events API set up (recommended)

### Audience Setup

- [ ] Custom audiences created
- [ ] Lookalike audiences created
- [ ] Interest categories identified

### Creative

- [ ] Vertical video (9:16) ready
- [ ] Native-feeling content (not too polished)
- [ ] First 3 seconds are compelling hooks
- [ ] Captions added (most watch without sound)
- [ ] Music/sounds selected (licensed if needed)

---

## Universal Pre-Launch Checklist

Before launching any campaign:

- [ ] Conversion tracking tested with real conversion
- [ ] Landing page loads fast (<3 sec)
- [ ] Landing page mobile-friendly
- [ ] UTM parameters working
- [ ] Budget set correctly (daily vs. lifetime)
- [ ] Start/end dates correct
- [ ] Targeting matches intended audience
- [ ] Ad creative approved
- [ ] Team notified of launch
- [ ] Reporting dashboard ready
