# 흔한 한국어 오류 패턴

이 문서는 자주 발생하는 한국어 오류 패턴과 교정 방법을 정리한 것입니다.

## 목차

1. [헷갈리기 쉬운 단어](#헷갈리기-쉬운-단어)
2. [띄어쓰기 오류 패턴](#띄어쓰기-오류-패턴)
3. [조사 사용 오류](#조사-사용-오류)
4. [어미 사용 오류](#어미-사용-오류)
5. [문장 부호 오류](#문장-부호-오류)

---

## 헷갈리기 쉬운 단어

### 1. 되/돼

**규칙**: "되어"의 준말이 "돼"

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 되요 | 돼요 | "되어요"의 준말 |
| 됬어요 | 됐어요 | "되었어요"의 준말 |
| 안되요 | 안 돼요 | "안 되어요"의 준말 |
| 어떻게되요? | 어떻게 돼요? | "어떻게 되어요?"의 준말 |

**확인 방법**: "하다"를 "해"로 바꾸는 것처럼, "되다"는 "돼"로 바꿈

### 2. -ㄴ지/-는지

**규칙**:
- 형용사 + -ㄴ지
- 동사 + -는지

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 좋는지 | 좋은지 | 형용사 "좋다" |
| 가는지 | 가는지 | ✅ 동사 "가다" |
| 많는지 | 많은지 | 형용사 "많다" |
| 하는지 | 하는지 | ✅ 동사 "하다" |

### 3. -ㄹ게/-를게

**규칙**: 항상 "-ㄹ게"만 사용 (받침 유무 관계없음)

| 틀린 표현 | 올바른 표현 |
|---------|----------|
| 하를게요 | 할게요 |
| 먹을게요 | 먹을게요 ✅ |
| 갈게요 | 갈게요 ✅ |
| 볼게요 | 볼게요 ✅ |

### 4. 던/든

**던**: 과거 회상
**든**: 선택

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 그때 먹든 음식 | 그때 먹던 음식 | 과거 회상 |
| 뭐던 좋아요 | 뭐든 좋아요 | 선택 |
| 갔든 곳 | 갔던 곳 | 과거 회상 |
| 어디던지 | 어디든지 | 선택 |

### 5. -로써/-로서

**-로써**: 수단, 도구 (with)
**-로서**: 자격, 지위 (as)

| 올바른 예 | 의미 |
|---------|------|
| 칼로써 자른다 | 수단 (칼을 사용하여) |
| 학생으로서 | 자격 (학생의 자격으로) |
| 이것으로써 | 수단 (이것을 사용하여) |
| 대표로서 | 자격 (대표의 자격으로) |

### 6. 안/않

**안**: 부정 부사 (동사/형용사 앞)
**않**: 보조 형용사 (-지 않다)

| 틀린 표현 | 올바른 표현 |
|---------|----------|
| 하지 안다 | 하지 않다 |
| 않 해요 | 안 해요 |
| 좋지 안아요 | 좋지 않아요 |
| 않 가요 | 안 가요 |

### 7. 웬/왠

**웬**: "어찌 된" (what)
**왠**: "왜 그런" (why) → 거의 "왠지"에만 사용

| 올바른 예 | 설명 |
|---------|------|
| 웬 일이야? | 어찌 된 일이야? |
| 왠지 모르게 | 왜 그런지 모르게 |
| 웬만하면 | 어찌 되든 |

**기억법**: "왠"은 거의 "왠지"에만 사용, 나머지는 "웬"

### 8. 어떻게/어떡해

**어떻게**: 방법, 상태 (how)
**어떡해**: "어떻게 해"의 준말

| 올바른 예 | 설명 |
|---------|------|
| 어떻게 했어? | 방법 질문 |
| 어떡해? | "어떻게 해?"의 준말 |
| 어떻게 가요? | 방법 질문 |
| 어떡하지? | "어떻게 하지?"의 준말 |

---

## 띄어쓰기 오류 패턴

### 1. 의존명사 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 할수있다 | 할 수 있다 | "수"는 의존명사 |
| 먹을만큼 | 먹을 만큼 | "만큼"은 의존명사 |
| 하는것 | 하는 것 | "것"은 의존명사 |
| 갈뿐이다 | 갈 뿐이다 | "뿐"은 의존명사 |
| 하는데 | 하는 데 | "데"는 의존명사 (장소) |
| 먹을줄알다 | 먹을 줄 알다 | "줄"은 의존명사 |

### 2. 보조용언 오류

**원칙**: 띄어 쓰기 (하지만 붙여 쓰기도 허용)

| 원칙 | 허용 | 설명 |
|-----|------|------|
| 해 주세요 | 해주세요 | 보조용언 "-아/어 주다" |
| 하고 있습니다 | 하고있습니다 | 보조용언 "-고 있다" |
| 해 보세요 | 해보세요 | 보조용언 "-아/어 보다" |
| 하게 하다 | 하게하다 | 보조용언 "-게 하다" |

**권장**: 격식체에서는 띄어 쓰기

### 3. 단위명사 오류

| 격식체 (권장) | 비격식체 (허용) |
|-----------|-------------|
| 10 개 | 10개 |
| 5 명 | 5명 |
| 3 권 | 3권 |
| 100 원 | 100원 |

### 4. 합성어 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 사과 나무 | 사과나무 | 합성어 |
| 손 목 시계 | 손목시계 | 합성어 |
| 먹 거리 | 먹거리 | 합성어 |
| 읽을 거리 | 읽을거리 | 합성어 |

### 5. 부사 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 아주 | 아주 ✅ | 부사는 띄어 쓰기 |
| 매우좋다 | 매우 좋다 | 부사 "매우" |
| 너무나빨리 | 너무나 빨리 | 부사 띄어 쓰기 |
| 정말로좋다 | 정말로 좋다 | 부사 "정말로" |

---

## 조사 사용 오류

### 1. -을/를 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 사과을 | 사과를 | 받침 X → "-를" |
| 책를 | 책을 | 받침 O → "-을" |
| 물을 | 물을 ✅ | 받침 O → "-을" |
| 차을 | 차를 | 받침 X → "-를" |

### 2. -이/가 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 사과이 | 사과가 | 받침 X → "-가" |
| 책가 | 책이 | 받침 O → "-이" |
| 물이 | 물이 ✅ | 받침 O → "-이" |
| 차이 | 차가 | 받침 X → "-가" |

### 3. -은/는 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 사과은 | 사과는 | 받침 X → "-는" |
| 책는 | 책은 | 받침 O → "-은" |
| 물은 | 물은 ✅ | 받침 O → "-은" |
| 차은 | 차는 | 받침 X → "-는" |

### 4. -와/과 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 사과과 | 사과와 | 받침 X → "-와" |
| 책와 | 책과 | 받침 O → "-과" |
| 물과 | 물과 ✅ | 받침 O → "-과" |
| 차과 | 차와 | 받침 X → "-와" |

---

## 어미 사용 오류

### 1. -ㅂ니다/습니다 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 먹읍니다 | 먹습니다 | 받침 O → "-습니다" |
| 갑니다 | 갑니다 ✅ | 받침 X → "-ㅂ니다" |
| 있읍니다 | 있습니다 | 받침 O → "-습니다" |

### 2. -아요/-어요 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 가아요 | 가요 | "가+아요" → "가요" |
| 서어요 | 서요 | "서+어요" → "서요" |
| 하아요 | 해요 | "하+아요" → "해요" |
| 오아요 | 와요 | "오+아요" → "와요" |

### 3. -ㄹ까요/-을까요 오류

| 틀린 표현 | 올바른 표현 | 설명 |
|---------|----------|------|
| 먹을까요 | 먹을까요 ✅ | 받침 O → "-을까요" |
| 갈까요 | 갈까요 ✅ | 받침 X → "-ㄹ까요" |
| 읽을까요 | 읽을까요 ✅ | 받침 O → "-을까요" |

---

## 문장 부호 오류

### 1. 과도한 쉼표 사용

**오류 패턴**: 영어식 쉼표 사용

| 틀린 예 | 올바른 예 |
|--------|----------|
| 나는, 학교에 갔다. | 나는 학교에 갔다. |
| 사과, 배, 그리고 포도 | 사과, 배, 포도 |
| 만약 비가 오면, 우산을 가져가세요. | 만약 비가 오면 우산을 가져가세요. |

**규칙**: 한국어는 영어보다 쉼표를 적게 사용

### 2. 불필요한 느낌표 과다 사용

**오류 패턴**: 과도한 강조

| 틀린 예 | 올바른 예 |
|--------|----------|
| 안녕하세요!!! | 안녕하세요! |
| 좋아요!!! 정말 좋아요!!! | 좋아요! 정말 좋아요. |

**규칙**: 격식체 문서에서는 느낌표를 최소화

### 3. 따옴표 혼용

**규칙**: 큰따옴표와 작은따옴표를 일관되게 사용

| 혼란스러운 예 | 올바른 예 |
|-----------|----------|
| 그는 '안녕"이라고 했다. | 그는 "안녕"이라고 했다. |
| "hello'라고 썼다. | "hello"라고 썼다. |

### 4. 마침표 누락

**오류 패턴**: 문장 끝 마침표 생략

| 틀린 예 | 올바른 예 |
|--------|----------|
| 오늘은 날씨가 좋다 그래서 산책을 갔다 | 오늘은 날씨가 좋다. 그래서 산책을 갔다. |

---

## 검사 전략

### 우선순위

1. **최우선**: 명백한 맞춤법 오류 (되요 → 돼요)
2. **높음**: 띄어쓰기 오류 (할수있다 → 할 수 있다)
3. **중간**: 조사 사용 오류
4. **낮음**: 스타일 개선 제안

### 문맥 고려 사항

- **비격식체**: 일부 규칙을 느슨하게 적용
- **구어체**: 줄임말이나 생략 허용
- **기술 문서**: 전문 용어와 외래어 주의
- **코드 주석**: 간결함을 우선

### 확신도 표시

- ✅ **확실한 오류**: 규칙 명백히 위반
- ⚠️ **권장 사항**: 더 나은 표현 존재
- 💡 **제안**: 선택적 개선 사항
