# 한국어 문법 및 맞춤법 규칙

이 문서는 한국어 문법 검사 시 참조할 표준 규칙을 정리한 것입니다.

## 목차

1. [맞춤법 규칙](#맞춤법-규칙)
2. [띄어쓰기 규칙](#띄어쓰기-규칙)
3. [문법 구조 규칙](#문법-구조-규칙)
4. [구두점 규칙](#구두점-규칙)

---

## 맞춤법 규칙

### 1. 사이시옷 사용

**규칙**: 순우리말 + 순우리말, 순우리말 + 한자어, 한자어 + 순우리말 조합에서 사이시옷 사용

**올바른 예**:
- 나뭇잎, 나뭇가지, 나뭇결
- 곳간, 숫자, 찻잔, 툇마루
- 횟수, 댓수

**틀린 예**:
- ❌ 나무잎 → ✅ 나뭇잎
- ❌ 차잔 → ✅ 찻잔
- ❌ 회수 (횟수의 의미) → ✅ 횟수

**예외**: 한자어 + 한자어는 사이시옷을 쓰지 않음 (예: 회사일, 차고지)

### 2. 준말과 원말

**-ㄴ/는 것, -ㄹ/을 것**:
- ❌ ~ㄴ걸 → ✅ ~ㄴ 걸 또는 ~ㄴ 것을
- ❌ ~ㄹ껄 → ✅ ~ㄹ 걸 또는 ~ㄹ 것을

**되/돼**:
- "되어"의 준말 → "돼"
- ✅ 돼요, 됐어요, 될 거예요
- ❌ 되요 → ✅ 돼요
- ❌ 됬어요 → ✅ 됐어요

**-ㄹ게/를게**:
- ❌ ~를게요 → ✅ ~ㄹ게요
- 예: 할게요, 먹을게요, 갈게요

### 3. 외래어 표기

**규칙**: 국립국어원 외래어 표기법 준수

**흔한 오류**:
- ❌ 캐릭터 → ✅ 캐릭터 (character)
- ❌ 쉐어 → ✅ 셰어 (share)
- ❌ 디바이스 → ✅ 디바이스 (device)
- ❌ 어플 → ✅ 앱 (app)

### 4. 두음법칙

**규칙**: 단어 첫머리에서 "ㄹ"이 발음되지 않는 경우

**올바른 예**:
- ✅ 여자, 요일, 양심, 역사
- ❌ 녀자, 료일, 량심, 력사

**예외**: 성(姓)과 단어 중간에는 두음법칙을 적용하지 않음
- 이순신, 신라, 광한루

---

## 띄어쓰기 규칙

### 1. 의존명사

**규칙**: 의존명사는 앞말과 띄어 씀

**흔한 의존명사**:
- 것, 수, 만큼, 뿐, 데, 바, 지, 듯, 따름, 줄

**올바른 예**:
- ✅ 할 수 있다, 먹을 만큼, 공부하는 것
- ❌ 할수있다, 먹을만큼, 공부하는것

**예외**: "것"이 대명사로 쓰일 때는 띄어 쓰지만, 자주 쓰여 붙여 쓰는 것도 허용되는 경우 있음

### 2. 보조용언

**규칙**: 보조용언은 앞말과 띄어 씀 (원칙상), 하지만 붙여 쓰는 것도 허용

**주요 보조용언**:
- -아/어 주다, -고 있다, -아/어 보다, -게 하다, -지 않다

**올바른 예** (둘 다 가능):
- ✅ 해 주세요 / 해주세요
- ✅ 하고 있습니다 / 하고있습니다
- ✅ 해 보세요 / 해보세요

**권장**: 격식체 문서에서는 띄어 쓰기, 비격식체에서는 자유롭게

### 3. 단위명사

**규칙**: 수를 나타내는 말 뒤에 오는 단위명사는 띄어 씀

**올바른 예**:
- ✅ 10 개, 5 명, 3 권, 20 년
- ❌ 10개, 5명, 3권, 20년 (비격식체에서는 허용)

**예외**: 비격식체나 일상 대화에서는 붙여 쓰는 것도 허용됨

### 4. 합성어와 연결어

**규칙**: 두 개 이상의 단어가 결합하여 하나의 의미를 이루는 합성어는 붙여 씀

**올바른 예**:
- ✅ 먹거리, 볼거리, 읽을거리
- ✅ 사과나무, 강아지, 손목시계
- ❌ 사과 나무, 강 아지, 손목 시계

### 5. 조사

**규칙**: 조사는 앞말에 붙여 씀

**올바른 예**:
- ✅ 나는, 너를, 그가, 집에서
- ❌ 나 는, 너 를, 그 가, 집 에서

---

## 문법 구조 규칙

### 1. 시제 일치

**규칙**: 문장 내에서 시제는 일관되게 유지

**올바른 예**:
- ✅ 나는 어제 학교에 갔고, 친구를 만났다.
- ❌ 나는 어제 학교에 가고, 친구를 만났다.

### 2. 주어와 서술어 호응

**규칙**: 주어와 서술어는 수와 인칭에서 호응해야 함

**올바른 예**:
- ✅ 학생들이 공부를 한다.
- ❌ 학생들이 공부를 합니다. (존대 불일치 - 문맥에 따라 허용 가능)

### 3. 이중 부정 피하기

**규칙**: 불필요한 이중 부정은 피함

**올바른 예**:
- ✅ 가능합니다.
- ❌ 불가능하지 않습니다. (의도적 강조가 아니라면)

### 4. 조사 사용

**-을/를**:
- 받침 O + 을: 책을, 밥을
- 받침 X + 를: 사과를, 차를

**-이/가**:
- 받침 O + 이: 책이, 밥이
- 받침 X + 가: 사과가, 차가

**-은/는**:
- 받침 O + 은: 책은, 밥은
- 받침 X + 는: 사과는, 차는

**-와/과**:
- 받침 O + 과: 책과, 밥과
- 받침 X + 와: 사과와, 차와

### 5. 높임법

**규칙**: 문장 내에서 높임법은 일관되게 사용

**올바른 예**:
- ✅ 선생님께서 말씀하셨습니다.
- ❌ 선생님이 말했습니다. (높임 불일치)

---

## 구두점 규칙

### 1. 쉼표(,)

**사용 시점**:
- 같은 자격의 어구를 나열할 때
- 짧은 문장을 이어 줄 때
- 문장의 연결 관계를 분명히 할 때

**올바른 예**:
- 사과, 배, 포도를 샀다.
- 날씨가 좋으면, 산책을 가겠다.

**주의**: 한국어는 영어보다 쉼표를 덜 사용함. 과도한 쉼표는 피하기

### 2. 마침표(.)

**사용 시점**:
- 서술, 명령, 청유의 문장 끝
- 완결된 문장의 끝

**올바른 예**:
- 나는 학교에 갔다.
- 공부하자.

### 3. 물음표(?)

**사용 시점**:
- 의문문의 끝

**올바른 예**:
- 너는 어디에 가니?
- 이것이 맞나요?

### 4. 느낌표(!)

**사용 시점**:
- 감탄이나 강한 느낌을 나타낼 때

**올바른 예**:
- 와! 정말 아름답다!
- 조용히 하세요!

**주의**: 과도한 느낌표 사용은 피하기 (특히 격식체 문서)

### 5. 따옴표(" ", ' ')

**사용 시점**:
- 직접 인용할 때
- 강조할 때
- 특별한 의미를 나타낼 때

**올바른 예**:
- 그는 "안녕"이라고 말했다.
- 이 '특별한' 순간을 기억하세요.

### 6. 가운뎃점(·)

**사용 시점**:
- 열거할 때 각 단어 사이에
- 외래어의 원어 표기에서

**올바른 예**:
- 사과·배·포도
- John F. Kennedy

---

## 검사 시 주의사항

### 문맥 고려

문법 규칙이 항상 절대적이지는 않습니다. 다음 상황에서는 유연하게 적용:

1. **비격식체 문서**: 구어체나 블로그 글에서는 일부 규칙을 느슨하게 적용
2. **강조 목적**: 의도적인 반복이나 변형
3. **고유명사**: 브랜드명이나 특별한 표기
4. **기술 용어**: IT 용어나 전문 용어

### 확신 수준

오류를 지적할 때 확신 수준을 표시:
- **확실한 오류**: 맞춤법/띄어쓰기 규칙 위반
- **권장 사항**: 더 나은 표현이 있을 때
- **스타일 제안**: 선택의 문제일 때
