# 품사 다양성 패턴 (11-13)

**우선순위: 높음** - 검출 정확도: 82.99% AUC

---

## 패턴 11: 명사 과다 사용

**검출 기준**:
- 명사 비율이 내용어의 35%를 초과
- 명사화 구문 지배: -기, -음/-ㅁ 명사화
- 동사가 더 자연스러운 곳에 추상 명사 사용

**과학적 근거**:
- KatFishNet은 품사 다양성이 강력한 AI 텍스트 지표임을 보여줌(82.99% AUC)
- LLM은 기술적이고 정보적인 텍스트를 위해 명사를 선호함
- 인간 글쓰기는 동사 표현과 함께 더 균형 잡힌 품사 분포를 사용함

**발생 원인**:
- 높은 명사 밀도를 가진 격식체/기술 텍스트로 학습된 LLM
- 명사화가 더 "격식적" 또는 "전문적"으로 인식됨
- 자연스러운 구어체 한국어 패턴에 대한 인식 부족

**수정 방법**:
- 명사 구문을 동사 기반 표현으로 전환하세요
- 추상 명사 대신 능동 동사를 사용하세요
- -기 형태를 직접 동사 활용으로 변환하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 프로젝트의 성공은 팀원들의 노력의 결과입니다. 지속적인 개선이 필요합니다.
```

*수정 후 (자연스러운 글)*:
```
이 프로젝트가 성공한 건 팀원들이 노력한 덕분입니다. 계속 개선해야 합니다.
```

*설명*: 명사 "성공"을 동사 "성공한"으로, "노력"을 "노력한"으로, "개선"을 "개선해야"로 변경했습니다. 과도한 의 조사를 제거했습니다. 더 역동적이고 자연스럽습니다.

---

## 패턴 12: 동사/형용사 빈곤

**검출 기준**:
- 내용어의 동사 + 형용사 비율이 25% 미만
- 동사 대신 명사를 사용한 정적인 설명
- 일반적인 수식어에 의존하고 서술적인 형용사 부족

**과학적 근거**:
- 명사 과다 사용 패턴의 역
- 인간은 뉘앙스를 위해 더 풍부한 동사와 형용사 어휘를 사용함
- 품사 다양성은 인간 글쓰기와 강하게 연관됨(82.99% AUC)

**발생 원인**:
- 명사 중심의 정보 스타일에 대한 LLM 선호
- 학습 데이터의 제한된 동사/형용사 다양성
- "안전한" 일반적인 표현에 대한 경향

**수정 방법**:
- 명사구를 동사 표현으로 교체하세요
- 생동감을 위해 서술적인 형용사를 추가하세요
- 일반적인 하다 구문 대신 특정 동작 동사를 사용하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 제품은 고품질의 소재로 제작되었습니다. 사용자의 만족도가 높습니다.
```

*수정 후 (자연스러운 글)*:
```
이 제품은 좋은 소재로 만들었습니다. 사용자들이 만족해합니다.
```

*설명*: 명사구 "고품질의 소재"를 형용사 + 명사 "좋은 소재"로 변경했습니다. 정적인 "만족도가 높습니다"를 진행 중인 동작을 보여주는 능동 동사 "만족해합니다"로 전환했습니다.

---

## 패턴 13: 품사 N-gram 단조로움

**검출 기준**:
- 낮은 품사 2연쇄/3연쇄 다양성 점수
- 반복적인 문법 구조(예: 반복되는 명사 + -의 + 명사 패턴)
- 자주 나타나는 동일한 품사 연쇄

**과학적 근거**:
- LLM은 확률적으로 흔한 품사 패턴을 반복함
- 인간 글쓰기는 더 큰 문법적 다양성을 보여줌
- N-gram 다양성은 인간 vs AI 텍스트의 강력한 지표

**발생 원인**:
- 확률적 텍스트 생성이 흔한 패턴을 선호함
- 의식적인 문체 변화 부족
- 특정 문법 구조에 대한 학습 데이터 편향

**수정 방법**:
- 의도적으로 문법 구조를 다양화하세요
- 명사 중심과 동사 중심 문장을 혼합하세요
- 다른 문장 구조를 번갈아 사용하세요

**예시**:

*수정 전 (AI 작문)*:
```
프로젝트의 목표는 사용자의 만족도의 향상입니다. 팀의 역량의 강화가 필요합니다.
```

*수정 후 (자연스러운 글)*:
```
프로젝트 목표는 사용자 만족도를 높이는 겁니다. 팀 역량을 키워야 합니다.
```

*설명*: 반복적인 의 패턴을 제거했습니다. 명사 구문(첫 문장)과 직접 동사(두 번째 문장)를 혼합했습니다. 명사-의-명사 단조로움을 줄였습니다.
