# 문장부호 패턴 (1-7)

**우선순위: 최고** - 검출 정확도: 94.88% AUC (패턴 1-6)

---

## 패턴 1: 과도한 쉼표 사용

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (94.88% AUC)
- 버전: 1.0.0

**검출 기준**:
- 쉼표 포함률이 문장의 40%를 초과
- 한국어 독자가 자연스럽게 쉼표 없이 읽을 수 있는 문장에 여러 개의 쉼표 사용
- 단순한 명사구나 동사구를 쪼개는 쉼표

**과학적 근거**:
- KatFishNet 연구에 따르면 LLM은 문장의 61%에 쉼표를 사용하는 반면 인간은 26%에만 사용
- 검출 정확도: 94.88% AUC
- LLM은 한국어에 적용되지 않는 영어 쉼표 규칙을 모방함

**발생 원인**:
- 번역된 텍스트로 학습된 LLM이 영어 문장부호 습관을 가져옴
- 확률적 생성이 일반적인 휴지 지점에 쉼표 삽입을 선호함
- 한국어 글쓰기 관습은 쉼표보다 띄어쓰기와 문장 나누기를 선호함

**수정 방법**:
- 한국어 독자가 자연스럽게 쉼표 없이 문장을 읽을 수 있는 곳의 쉼표를 제거하세요
- 복잡한 아이디어에는 쉼표로 분리된 절 대신 문장 나누기를 사용하세요
- 긴 목록이나 복잡한 구조에서 이해를 진정으로 돕는 경우에만 쉼표를 유지하세요

**예시**:

*수정 전 (AI 작문)*:
```
인공지능 기술은 빠르게 발전하고 있으며, 다양한 분야에 적용되고 있고, 우리의 일상생활을 변화시키고 있습니다.
```

*수정 후 (자연스러운 글)*:
```
인공지능 기술은 빠르게 발전하고 있으며 다양한 분야에 적용되고 있습니다. 우리의 일상생활을 크게 바꾸고 있죠.
```

*설명*: -고로 연결된 평행 절 사이의 불필요한 쉼표를 제거했습니다. 더 나은 리듬을 위해 두 문장으로 분리했습니다. 자연스러운 흐름을 위해 마지막 동사를 비격식체 -죠로 변경했습니다.

---

## 패턴 2: 영어식 쉼표 배치

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (94.88% AUC)
- 버전: 1.0.0

**검출 기준**:
- 문장 후반부에 나타나는 쉼표(시작으로부터 상대 위치 >0.15)
- 새로운 독립절을 시작하는 접속사 앞의 쉼표
- 한국어 SOV 구조에서 주어-술어를 분리하는 쉼표

**과학적 근거**:
- LLM의 평균 쉼표 위치는 (문장 길이에 대한 상대적 위치) 0.18인 반면 인간은 0.09
- 한국어 SOV 구조에 잘못 적용된 영어 SVO 쉼표 규칙을 반영함
- 인간 한국어 작성자는 쉼표를 사용한다면 더 앞쪽에 배치하며, 종종 띄어쓰기를 선호함

**발생 원인**:
- 영어 학습 데이터가 쉼표 배치 패턴에 영향을 미침
- LLM이 한국어 SOV 어순에 맞게 조정하지 않음
- 확률적 모델이 영어 휴지 패턴을 복제함

**수정 방법**:
- 필요한 경우 쉼표를 문장의 더 앞쪽 위치로 이동하세요
- 종종 쉼표를 완전히 제거하고 한국어 띄어쓰기에 의존하는 것이 더 좋습니다
- 뒤쪽에 위치한 쉼표 대신 문장 나누기를 사용하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 방법은 효과적이지만, 시간이 많이 소요되는 문제가 있습니다.
```

*수정 후 (자연스러운 글)*:
```
이 방법은 효과적이지만 시간이 많이 걸립니다.
```

*설명*: -지만 뒤의 쉼표를 제거했습니다(한국어는 연결어미에 쉼표가 필요하지 않음). 자연스러운 흐름을 위해 "소요되는 문제가 있습니다"를 직접적인 "걸립니다"로 단순화했습니다.

---

## 패턴 3: 연결어미 뒤 쉼표

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (94.88% AUC)
- 버전: 1.0.0

**검출 기준**:
- 한국어 연결어미 뒤에 나타나는 쉼표: -고, -어서/-아서, -지만, -면서, -며, -ㄴ데/-는데
- 이러한 문법 형태와 함께 체계적인 쉼표 사용
- 한국어 접속 표현을 영어 "and," "but," "so"처럼 취급

**과학적 근거**:
- LLM은 연결어미 뒤에 19.83%의 경우 쉼표를 사용하는 반면 인간은 4.10%
- 한국어 연결어미는 이미 절 사이의 관계를 나타냄
- 쉼표는 불필요하며 부자연스러운 읽기 휴지를 만듦

**발생 원인**:
- LLM이 한국어 연결어미를 영어 접속사에 매핑함
- 학습 데이터에 불필요한 쉼표가 있는 번역된 텍스트가 포함될 수 있음
- 확률적 모델이 명시적인 문장부호 마커를 선호함

**수정 방법**:
- 대부분의 경우 연결어미 뒤의 쉼표를 제거하세요
- 관계를 전달하는 한국어 문법을 신뢰하세요
- 절이 매우 길고 복잡한 경우에만 쉼표를 사용하세요(드문 경우)

**예시**:

*수정 전 (AI 작문)*:
```
날씨가 좋아서, 산책을 나갔습니다. 친구들과 만나서, 즐거운 시간을 보냈습니다.
```

*수정 후 (자연스러운 글)*:
```
날씨가 좋아서 산책을 나갔습니다. 친구들과 만나 즐거운 시간을 보냈어요.
```

*설명*: -어서 뒤의 쉼표를 제거했습니다. 변화를 위해 두 번째 문장을 비격식체 -어요로 변경했습니다. 자연스러운 말투 리듬을 위해 만나서를 만나로 축약했습니다.

---

## 패턴 4: 문장 끝 쉼표 패턴

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (94.88% AUC)
- 버전: 1.0.0

**검출 기준**:
- 논리적으로 새로운 문장을 시작하는 접속사(그리고, 하지만, 그러나, 따라서) 앞의 쉼표 사용
- 마침표 대신 쉼표로 끊어지지 않는 문장 만들기
- 쉼표로만 분리된 여러 독립적인 생각

**과학적 근거**:
- LLM이 길고 쉼표로 분리된 문장을 만드는 경향에 대한 일반적인 관찰
- 한국어 글쓰기 관습은 명확한 나누기가 있는 짧은 문장을 선호함
- 인간은 리듬과 강조를 만들기 위해 마침표를 더 자유롭게 사용함

**발생 원인**:
- LLM이 더 길고 "완전하게 들리는" 응답을 최적화함
- 복잡한 문장을 가진 격식체 학술 텍스트 학습
- 자연스러운 읽기 리듬에 대한 인식 부족

**수정 방법**:
- 새로운 생각을 시작하는 접속사 앞의 쉼표를 마침표로 교체하세요
- 길고 쉼표로 분리된 문장을 짧은 독립적인 문장으로 나누세요
- 접속사가 새 문장을 시작하도록 허용하세요(한국어에서 완전히 자연스러움)

**예시**:

*수정 전 (AI 작문)*:
```
이 기술은 매우 유용하며, 많은 사람들이 사용하고 있고, 앞으로도 계속 발전할 것입니다, 따라서 우리는 이에 주목해야 합니다.
```

*수정 후 (자연스러운 글)*:
```
이 기술은 매우 유용합니다. 많은 사람들이 이미 쓰고 있고 앞으로도 계속 발전할 겁니다. 따라서 우리는 주목해야 합니다.
```

*설명*: 세 문장으로 분리했습니다. 과도한 쉼표를 제거했습니다. 자연스러운 말투를 위해 "것입니다"를 구어체 "겁니다"로 변경했습니다.

---

## 패턴 5: 불필요한 목록 쉼표

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (94.88% AUC)
- 버전: 1.0.0

**검출 기준**:
- 한국어가 자연스럽게 생략하는 짧은 목록의 쉼표
- 쉼표로 분리된 2항목 목록(한국어는 와/과 또는 띄어쓰기 사용)
- 순수 한국어 단어 목록의 체계적인 쉼표 사용

**과학적 근거**:
- 한국어 목록 문장부호는 영어 관습과 다름
- 짧은 목록은 종종 쉼표 없이 띄어쓰기나 접속사를 사용함
- 목록의 쉼표는 한자어 기술 용어에서 더 흔함

**발생 원인**:
- LLM이 영어 목록 문장부호를 복제함(A, B, and C)
- 쉼표를 범용 구분자로 과다 사용
- 격식체/비격식체 목록 스타일 구분 부족

**수정 방법**:
- 쉼표 대신 짧은 목록에 와/과/이랑 접속사를 사용하세요
- 2-3개 항목의 단순한 목록에는 띄어쓰기에 의존하세요
- 더 길거나 복잡한 목록을 위해 쉼표를 예약하세요

**예시**:

*수정 전 (AI 작문)*:
```
우리는 책, 노트, 펜을 준비했습니다.
```

*수정 후 (자연스러운 글)*:
```
우리는 책과 노트, 펜을 준비했습니다.
```

*또는 더 비격식체로*:
```
책 노트 펜 챙겼어요.
```

*설명*: 첫 번째 버전은 첫 번째 쌍에 과를 사용합니다. 두 번째 버전은 쉼표나 조사 없이 비격식체 띄어쓰기만 사용하는 스타일을 보여줍니다.

---

## 패턴 6: 줄표 과다 사용

**메타데이터**:
- 출처: KatFishNet (ArXiv 2503.00032v4, 2025)
- 검증: ✅ 과학적 (일반적 관찰)
- 버전: 1.0.0

**검출 기준**:
- 단락당 한 번 이상 줄표(—) 사용
- 영어 "강조" 글쓰기 스타일을 모방하는 줄표
- 강제적으로 느껴지는 극적인 강조나 중단

**과학적 근거**:
- LLM이 영어 문체 관습을 모방하는 일반적인 관찰
- 한국어 글쓰기는 전통적으로 괄호나 문장 나누기를 대신 사용함
- 줄표는 자연스러운 한국어 글쓰기에서 드뭄

**발생 원인**:
- 줄표 사용이 있는 영어 텍스트 학습
- "매력적인" 글쓰기 스타일을 만들려는 시도
- 영어 문장부호 미학의 잘못된 적용

**수정 방법**:
- 줄표를 괄호를 사용한 괄호 표현으로 교체하세요
- 아이디어를 분리하기 위해 문장 나누기를 사용하세요
- 극적인 강조를 자연스러운 한국어 표현으로 전환하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 방법은 — 많은 전문가들이 동의하듯이 — 매우 효과적입니다.
```

*수정 후 (자연스러운 글)*:
```
이 방법은 (많은 전문가들이 동의하듯) 매우 효과적입니다.
```

*또는*:
```
많은 전문가들이 동의하듯 이 방법은 매우 효과적입니다.
```

*설명*: 첫 번째 버전에서는 괄호를 사용했습니다. 두 번째 버전은 문장부호 없이 곁가지를 자연스럽게 통합했습니다.

---

## 패턴 7: 영어식 콜론 과다 사용

**메타데이터**:
- 출처: korean-skills 커뮤니티
- 검증: 📊 경험적 관찰
- 버전: 1.1.0 (2026-01 추가)

**검출 기준**:
- 목록이나 설명 도입부에 콜론 사용: "다음과 같습니다:", "방법:", "특징:"
- 한국어에서 불필요한 콜론 사용 (영어 "as follows:", "method:", "features:"의 직역)
- 마크다운 문서, 기술 문서에서 특히 흔함

**과학적 근거**:
- 영어 학습 데이터의 영향으로 LLM은 콜론을 목록이나 설명 도입부에 과다 사용
- 한국어에서 콜론은 시간(3:30), 비율(2:1) 등 제한적 용도로만 사용
- "다음과 같습니다:", "방법:" 등은 영어 직역체의 전형적 특징

**발생 원인**:
- LLM이 영어 문장부호 관습을 한국어에 그대로 적용
- 마크다운 문서 작성 시 영어 스타일 가이드 영향
- 기술 문서의 영어 템플릿을 번역할 때 콜론이 그대로 유지됨

**수정 방법**:
- 대부분의 경우 콜론을 제거하고 마침표 사용
- "다음과 같습니다:" → "다음과 같습니다."
- 단어 뒤 콜론 → 콜론 제거하고 자연스러운 문장으로 전환
- 시간, 비율 표기는 예외로 유지

**예시**:

*수정 전 (AI 작문)*:
```
설치 방법은 다음과 같습니다:
- npm install
- npm start

주요 특징:
1. 빠른 속도
2. 높은 정확도

단계:
먼저 파일을 다운로드하세요.
```

*수정 후 (자연스러운 글)*:
```
설치 방법은 다음과 같습니다.
- npm install
- npm start

주요 특징은 다음과 같습니다.
1. 빠른 속도
2. 높은 정확도

**단계**
먼저 파일을 다운로드하세요.
```

*또는 더 자연스럽게*:
```
설치는 다음과 같이 합니다.
- npm install
- npm start

주요 특징입니다.
1. 빠른 속도
2. 높은 정확도

먼저 파일을 다운로드하세요.
```

*설명*: 목록 앞의 콜론을 마침표로 교체하거나 제거했습니다. "특징:"을 "특징은 다음과 같습니다."로 완전한 문장으로 만들거나 "특징입니다."로 간결하게 표현했습니다. "단계:" 같은 라벨은 콜론 없이 사용하거나 아예 제거했습니다.

**예외 (유지해야 하는 경우)**:
```
오후 3:30 회의  ✅ (시간 표기)
2:1 비율로 혼합  ✅ (비율 표기)
환경변수: NODE_ENV=production  ⚠️ (기술 문서의 키-값 쌍, 문맥에 따라 판단)
```
