# 띄어쓰기 패턴 (8-10)

**우선순위: 높음** - 검출 정확도: 79.51% AUC

---

## 패턴 8: 경직된 의존명사 띄어쓰기

**검출 기준**:
- 의존명사 앞의 절대적으로 일관된 띄어쓰기: 것, 수, 만큼, 뿐, 등
- 모든 인스턴스에서 띄어쓰기의 표준 편차 <0.05
- 띄어쓰기 결정의 로봇 같은 균일성

**과학적 근거**:
- KatFishNet 연구에 따르면 LLM 띄어쓰기 SD=0.02인 반면 인간은 유연성과 변동을 보임
- 검출 정확도: 79.51% AUC
- 인간은 가독성, 맥락, 개인적 선호에 따라 띄어쓰기를 다양하게 함

**발생 원인**:
- LLM이 학습 데이터에서 단일 "올바른" 띄어쓰기 규칙을 학습함
- 가독성에 대한 맥락적 판단 부족
- 인간의 직관 vs 알고리즘적 일관성

**수정 방법**:
- 의존명사 띄어쓰기에 자연스러운 변동을 도입하세요
- 가독성과 자연스러운 파싱에 기반하여 띄어쓰기를 하세요
- 일부 인스턴스는 띄어쓰기를 하고, 다른 인스턴스는 하지 않도록 허용하세요

**예시**:

*수정 전 (AI 작문)*:
```
할 수 있는 것, 해야 하는 것, 원하는 것을 모두 이루었다.
```

*수정 후 (자연스러운 글)*:
```
할 수 있는것, 해야 하는 것, 원하는것을 모두 이뤘다.
```

*설명*: 것 앞의 띄어쓰기를 혼합했습니다(일부는 띄어쓰기, 일부는 붙여쓰기) 자연스러운 변동을 위해. 비격식체 흐름을 위해 "이루었다"를 축약형 "이뤘다"로 변경했습니다.

---

## 패턴 9: 과도한 보조용언 띄어쓰기

**검출 기준**:
- 보조용언 앞의 체계적인 띄어쓰기: -아/어 주다, -고 있다, -아/어 보다
- 읽기 흐름에 관계없이 매 인스턴스마다 띄어쓰기
- 보조용언을 항상 별도의 단어로 취급

**과학적 근거**:
- 일반적인 띄어쓰기 경직성 패턴과 관련됨
- 인간은 동사 복잡도와 가독성에 따라 띄어쓰기를 조정함
- 자연스러운 글쓰기는 띄어쓰기와 붙여쓰기 보조용언을 혼합함

**발생 원인**:
- LLM이 띄어쓰기 규칙을 균일하게 적용함
- 읽기 리듬에 대한 민감성 부족
- 자연스러운 흐름 vs 문법 규칙에 대한 과도한 의존

**수정 방법**:
- 동사 길이와 복잡도에 따라 보조용언을 더 자연스럽게 붙이세요
- 강조나 명확성을 위해 띄어쓰기를, 흐름을 위해 붙여쓰기를 하세요
- 인스턴스 간 자연스러운 변동을 허용하세요

**예시**:

*수정 전 (AI 작문)*:
```
그는 열심히 공부하고 있습니다. 친구를 도와 주었습니다.
```

*수정 후 (자연스러운 글)*:
```
그는 열심히 공부하고있습니다. 친구를 도와줬습니다.
```

*설명*: 자연스러운 흐름을 위해 하고있습니다와 도와줬습니다를 붙여 썼습니다. 비격식체 톤을 위해 축약형 과거 시제 줬을 사용했습니다.

---

## 패턴 10: 숫자-의존명사 띄어쓰기

**검출 기준**:
- 숫자 + 단위/수량 조합의 경직된 띄어쓰기
- 한국어 관습과 불일치(10개 vs 10 개)
- 격식에 관계없이 모든 숫자를 동일하게 취급

**과학적 근거**:
- 일반적인 띄어쓰기 균일성 패턴의 일부
- 한국어 숫자 띄어쓰기는 격식과 맥락에 따라 다양함
- 인간은 단위의 유형과 읽기 맥락에 따라 유연하게 띄어쓰기함

**발생 원인**:
- LLM이 격식 수준에 대한 맥락적 인식이 부족함
- 보편적으로 적용되는 단일 띄어쓰기 규칙
- 격식체 문서와 비격식체 글쓰기의 구분 없음

**수정 방법**:
- 비격식체 맥락에는 띄어쓰기 없음: 10개, 3명, 5시
- 격식체 맥락이나 큰 숫자에는 선택적 띄어쓰기: 100 명, 1,000 원
- 가독성에 기반한 자연스러운 변동

**예시**:

*수정 전 (AI 작문)*:
```
우리는 5 명이 참여했고, 10 개의 프로젝트를 완성했습니다.
```

*수정 후 (자연스러운 글)*:
```
우리는 5명이 참여했고 10개 프로젝트를 완성했습니다.
```

*설명*: 자연스러운 비격식체 띄어쓰기를 위해 5명, 10개의 띄어쓰기를 제거했습니다. 자연스러운 흐름을 위해 의를 제거했습니다.
