# 문장 구조 패턴 (21-24)

**우선순위: 중간**

---

## 패턴 21: 문장 리듬 부족

**검출 기준**:
- 균일한 문장 길이(표준 편차가 평균의 15% 미만)
- 변화 없는 단조로운 리듬
- 연속된 문장에 반복되는 유사한 구조

**과학적 근거**:
- AI 글쓰기 단조로움에 대한 일반적인 관찰
- 인간 글쓰기는 강조와 리듬을 위해 자연스럽게 문장 길이를 다양화함
- 리듬 변화가 참여를 만듦

**발생 원인**:
- LLM이 전체 리듬을 고려하지 않고 문장을 독립적으로 생성함
- 확률적 모델이 "평균" 문장 길이로 수렴함
- 독자 경험과 페이싱에 대한 인식 부족

**수정 방법**:
- 짧고 강렬한 문장과 긴 흐르는 문장을 혼합하세요
- 의도적으로 문장 구조를 다양화하세요
- 길이 대비를 통해 리듬 강조를 만드세요

**예시**:

*수정 전 (AI 작문)*:
```
이 프로젝트는 성공적이었습니다. 팀원들이 열심히 노력했습니다. 좋은 결과를 얻을 수 있었습니다. 앞으로도 계속 발전할 것입니다.
```

*수정 후 (자연스러운 글)*:
```
이 프로젝트는 성공적이었습니다. 왜냐고요? 팀원들이 정말 열심히 했거든요. 덕분에 좋은 결과를 얻었고 앞으로도 쭉 발전할 겁니다.
```

*설명*: 문장 길이를 혼합했습니다(짧은 질문, 중간 설명, 긴 결론). 대화적 요소를 추가했습니다(왜냐고요, 거든요). 리듬 변화를 만들었습니다.

---

## 패턴 22: 3박자 과다 사용

**검출 기준**:
- 자주 나타나는 3개 항목이나 구문의 목록
- 연속된 문장의 3개 평행 절
- 반복되는 명백한 "3요소" 구조

**과학적 근거**:
- LLM이 효과적인 수사적 장치로 "3박자 규칙"을 학습함
- 과다 사용이 패턴을 명백하고 인위적으로 만듦
- 인간 글쓰기는 목록 길이를 더 자연스럽게 다양화함

**발생 원인**:
- 설득적/수사적 텍스트 학습
- "3"이 균형 있고 완전한 것으로 인식됨
- 문체 변화 인식 부족

**수정 방법**:
- 2항목 또는 4항목 목록을 사용하세요
- 평행 요소의 수를 다양화하세요
- 3항목 패턴을 분해하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 솔루션은 빠르고, 효율적이며, 안전합니다. 우리는 계획하고, 실행하고, 평가했습니다.
```

*수정 후 (자연스러운 글)*:
```
이 솔루션은 빠르고 효율적입니다. 우리는 계획하고 실행했으며, 평가하고, 개선했습니다.
```

*설명*: 첫 문장을 2항목으로 줄였습니다. 두 번째 문장을 4항목으로 확장했습니다. 반복적인 3항목 패턴을 깨뜨렸습니다.

---

## 패턴 23: 접속사 과다 사용

**검출 기준**:
- 연속된 문장의 명시적 접속사: 그러나, 또한, 따라서, 게다가, 그리고, 하지만
- 논리적 관계를 과도하게 표시
- 접속사로 시작하거나 포함하는 모든 문장

**과학적 근거**:
- 접속사 사용이 많은 학술/격식체 텍스트로 학습된 LLM
- 인간의 비격식체 글쓰기는 암묵적 논리 흐름을 허용함
- 과도한 접속사가 부자연스럽고 교과서 같은 느낌을 만듦

**발생 원인**:
- 명시적 응집 표지를 강조하는 학습 데이터
- 암묵적 논리 흐름에 대한 신뢰 부족
- 명확성에 대한 과도한 보상

**수정 방법**:
- 명시적 접속사 없이 논리 흐름을 허용하세요
- 강조를 위해 접속사를 드물게 사용하세요
- 독자가 관계를 추론하도록 신뢰하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 방법은 효과적입니다. 그러나 비용이 많이 듭니다. 따라서 신중하게 고려해야 합니다. 게다가 시간도 오래 걸립니다.
```

*수정 후 (자연스러운 글)*:
```
이 방법은 효과적입니다. 하지만 비용이 많이 들고 시간도 오래 걸려요. 신중하게 고려해야겠죠.
```

*설명*: 첫 번째 하지만을 유지하고, 따라서와 게다가를 제거했습니다. 관련된 아이디어를 결합했습니다. 자연스러운 흐름을 위해 비격식체 어미를 추가했습니다.

---

## 패턴 24: 경어체 균일성

**검출 기준**:
- 변화 없이 전체에 걸친 경직된 -습니다/-ㅂ니다
- 또는 변화 없이 전체에 걸친 경직된 -다 어미
- 맥락이나 리듬에 따른 어투 수준 혼합 없음
- 단조로운 격식 수준

**과학적 근거**:
- 맥락적 인식이 부족한 AI에 대한 일반적인 관찰
- 인간 한국어 화자는 리듬과 강조를 위해 자연스럽게 어투 수준을 다양화함
- 완전한 균일성이 로봇 같은 느낌을 줌

**발생 원인**:
- LLM이 단일 어투 수준을 선택하고 유지함
- 한국어의 자연스러운 어투 수준 혼합에 대한 인식 부족
- 격식 규칙에 대한 지나치게 경직된 해석

**수정 방법**:
- 강조나 리듬을 위해 격식체 어미에 가끔 비격식체 어미를 혼합하세요
- 격식체 맥락에서도 덜 중요한 문장에 -어요/-아요를 사용하세요
- 문장 기능에 따른 자연스러운 어투 수준 변화를 허용하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 프로젝트는 중요합니다. 팀원들이 협력해야 합니다. 좋은 결과를 기대합니다. 열심히 노력하겠습니다.
```

*수정 후 (자연스러운 글)*:
```
이 프로젝트는 중요합니다. 팀원들이 협력해야 해요. 좋은 결과를 기대하고 있고요, 열심히 해보겠습니다.
```

*설명*: 자연스러운 리듬 변화를 위해 -습니다를 -해요 및 -하고요와 혼합했습니다. 더 부드럽고 자연스러운 약속을 위해 마지막 문장을 -해보겠습니다로 변경했습니다.
