# 어휘 패턴 (14-20)

**우선순위: 중간**

---

## 패턴 14: AI 어휘 과다 사용

**검출 기준**:
- 일반적인 서술어 빈번한 사용: 중요하다, 핵심적, 효과적, 지속가능한, 혁신적, 다양한, 필수적
- 같은 단락에 여러 AI 유행어
- 구체적인 세부 사항 없는 모호한 최상급

**과학적 근거**:
- AI 글쓰기 감지 연구 전반에 걸친 일반적인 관찰
- 이러한 단어는 LLM 출력에서 불균형적으로 나타남
- 인간 글쓰기는 더 구체적이고 맥락에 적합한 서술어를 사용함

**발생 원인**:
- 비즈니스/기술 어휘에 대한 학습 데이터 편향
- LLM이 구체적인 도메인 지식이 부족하여 일반적인 용어로 대체함
- 확률적 생성이 흔한 서술어를 선호함

**수정 방법**:
- 일반적인 서술어를 구체적이고 명확한 세부 사항으로 교체하세요
- 맥락에 적합한 어휘를 사용하세요
- 불필요한 최상급을 제거하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 혁신적인 솔루션은 효과적으로 다양한 문제를 해결하며, 지속가능한 발전에 핵심적인 역할을 합니다.
```

*수정 후 (자연스러운 글)*:
```
이 솔루션은 여러 문제를 잘 풀어내며 장기적 발전에 도움이 됩니다.
```

*설명*: "혁신적", "효과적으로", "핵심적인"을 제거했습니다. "다양한"을 "여러"로, "지속가능한"을 "장기적"으로 교체했습니다. 더 근거 있고 구체적입니다.

---

## 패턴 15: 불필요한 한자어

**검출 기준**:
- 순수 한국어가 더 자연스러운 곳에 격식체 한자어 사용
- 흔한 패턴: 진행하다 → 하다, 실시하다 → 하다, 수행하다 → 하다
- 비격식체 맥락에 지나치게 격식적인 어투

**과학적 근거**:
- 격식체 문서로 학습된 LLM이 한자어 어휘를 선호함
- 인간의 비격식체 글쓰기는 순수 한국어 대응어를 사용함
- 어투 불일치가 부자연스러운 느낌을 만듦

**발생 원인**:
- 격식체 문어 한국어로 치우친 학습 데이터
- 구어체/비격식체 한국어 규범에 대한 인식 부족
- 한자어가 더 "세련된" 것으로 인식됨

**수정 방법**:
- 한자어를 순수 한국어 대응어로 교체하세요
- 어휘를 적절한 격식 수준에 맞추세요
- 비격식체 맥락에는 일상 한국어를 사용하세요

**예시**:

*수정 전 (AI 작문)*:
```
우리는 프로젝트를 진행하고, 테스트를 실시하며, 결과를 분석했습니다.
```

*수정 후 (자연스러운 글)*:
```
우리는 프로젝트를 하고, 테스트하고, 결과를 분석했습니다.
```

*또는 더 비격식체로*:
```
프로젝트 하고 테스트하고 결과 분석했어요.
```

*설명*: "진행하다"와 "실시하다"를 간단한 "하다"로 교체했습니다. 두 번째 버전은 조사 생략과 함께 완전히 비격식체 어투를 보여줍니다.

---

## 패턴 16: 영어 관용구 직역

**검출 기준**:
- 영어 관용구의 직접 번역인 한국어 구문
- 흔한 패턴: "~의 중심에", "~를 통해", "X에서 Y까지", "~의 세계"
- 한국어 말하기 패턴과 맞지 않는 부자연스러운 표현

**과학적 근거**:
- 번역된 텍스트로 학습된 LLM
- 영어 관용구가 한국어로 문자 그대로 매핑됨
- 인간 한국어는 다른 관용 표현을 사용함

**발생 원인**:
- 번역을 포함하는 학습 데이터
- 영어 패턴으로부터의 교차 언어 전이
- 한국어 고유 표현법에 대한 인식 부족

**수정 방법**:
- 영어 직역을 한국어 고유 표현으로 교체하세요
- 자연스러운 한국어 관용구와 표현법을 사용하세요
- 한국어 사고 패턴에 맞게 문장을 재구성하세요

**예시**:

*수정 전 (AI 작문)*:
```
이 기술은 산업의 중심에 있으며, 혁신을 통해 미래를 만들어갑니다. A에서 Z까지 모든 것을 다룹니다.
```

*수정 후 (자연스러운 글)*:
```
이 기술은 산업에서 핵심이며 혁신으로 미래를 만듭니다. 모든 걸 다룹니다.
```

*설명*: "중심에"("at the center"의 직역), "통해"("through"의 직역), "A에서 Z까지"("from A to Z"의 직역)를 제거했습니다. 더 자연스러운 한국어 표현법입니다.

---

## 패턴 17: 불필요한 복수형 '-들' 과다 사용

**메타데이터**:
- 출처: korean-skills community
- 검증: 📊 경험적
- 버전: 1.2.0

**검출 기준**:
- 수량 표현과 '-들'의 중복 사용: "많은 학생들", "세 권의 책들"
- 일반적 복수 맥락에서 불필요한 '-들' 강조: "기능들", "서비스들"
- 문맥상 복수가 명확한데도 '-들' 추가

**과학적 근거**:
- 영어 훈련 데이터의 영향으로 AI가 복수를 명시적으로 표현하려는 경향
- 한국어는 복수형이 문법적으로 필수가 아니며, 문맥으로 복수를 표현
- 인간의 한국어 글쓰기는 '-들'을 강조나 명확화가 필요할 때만 선택적으로 사용

**발생 원인**:
- 영어 복수형 문법(필수)의 직접 전이
- LLM이 복수를 명시하려는 과도한 시도
- 한국어 복수 표현의 선택적 특성에 대한 인식 부족

**수정 방법**:
- 수량사가 있으면 '-들' 제거: "책들 세 권" → "책 세 권"
- 수식어와 '-들' 중복 해소: "많은 학생들" → "많은 학생"
- 문맥상 복수가 명확하면 '-들' 생략: "기능들을 개선" → "기능을 개선"
- 복수 강조가 필요한 경우에만 '-들' 유지

**'-들' 사용이 자연스러운 경우**:
- 복수 강조 필요: "아이들이 놀고 있다" (여러 명임을 강조)
- 불특정 다수: "사람들은 모두 안다" (일반화된 집단)
- 대비/구분: "학생들은 교실에, 선생님들은 교무실에" (두 그룹 대비)
- 호격: "여러분들" (문법적으로는 중복이나 관용적 표현)

**예시**:

*수정 전 (AI 작문)*:
```
많은 사용자들이 새로운 기능들을 요청했고, 우리는 세 가지 기능들을 추가했습니다. 이 기능들은 여러 서비스들에서 사용할 수 있습니다.
```

*수정 후 (자연스러운 글)*:
```
많은 사용자가 새 기능을 요청했고, 우리는 세 가지 기능을 추가했습니다. 이 기능은 여러 서비스에서 쓸 수 있습니다.
```

*설명*: "많은 사용자들" → "많은 사용자" (수식어와 중복), "새로운 기능들" → "새 기능" (일반적 복수), "세 가지 기능들" → "세 가지 기능" (수량사와 중복), "여러 서비스들" → "여러 서비스" (수식어와 중복)을 수정했습니다.

*부분적으로 자연스러운 예*:
```
학생들이 책 세 권을 샀다. (✅ 학생들 - 복수 강조 자연스러움)
학생이 책들 세 권을 샀다. (❌ 책들 - 수량사와 중복 부자연스러움)
```

---

## 패턴 18: 불필요한 대명사 반복

**메타데이터**:
- 출처: korean-skills community
- 검증: 📊 경험적
- 버전: 1.3.0

**검출 기준**:
- 대명사의 과도한 반복: "그것은", "이것은", "저것은"
- 문맥상 명확한 대상을 대명사로 다시 지칭
- 선행사가 바로 앞 문장에 있는데도 대명사 사용

**과학적 근거**:
- 영어는 대명사 사용이 필수적이나 한국어는 생략이 자연스러움
- 영어 "it is", "this is", "that is" 패턴의 직접 전이
- 한국어 원어민은 문맥이 명확하면 대명사를 생략하고 바로 서술함

**발생 원인**:
- 영어 문법 구조의 직접 번역
- LLM이 영어 훈련 데이터의 대명사 패턴을 한국어에 적용
- 한국어가 대명사 생략이 자연스러운 pro-drop 언어임을 간과

**수정 방법**:
- 선행사가 명확하면 대명사 제거하고 바로 서술: "그것은 중요하다" → "중요하다"
- 지시대명사를 지시관형사+명사로 교체: "이것은" → "이 문제는"
- 문맥상 불필요한 대명사 생략

**예시**:

*수정 전 (AI 작문)*:
```
이 프로젝트는 성공적이었습니다. 그것은 팀원들의 노력 덕분입니다. 그것은 앞으로도 계속될 것입니다.
```

*수정 후 (자연스러운 글)*:
```
이 프로젝트는 성공적이었습니다. 팀원들의 노력 덕분이죠. 앞으로도 계속될 거예요.
```

*설명*: 두 개의 "그것은"을 제거했습니다. 첫 번째는 바로 서술하고, 두 번째는 문맥상 명확하므로 생략했습니다.

*추가 예시*:
```
❌ "새로운 기능을 추가했습니다. 그것은 사용자 경험을 개선합니다."
✅ "새로운 기능을 추가했습니다. 사용자 경험을 개선하죠."

❌ "문제가 발생했습니다. 이것은 버그 때문입니다."
✅ "문제가 발생했습니다. 버그 때문이에요."
```

---

## 패턴 19: 과도한 지시관형사 사용

**메타데이터**:
- 출처: korean-skills community
- 검증: 📊 경험적
- 버전: 1.3.0

**검출 기준**:
- 동일한 지시관형사의 반복: "해당 기능", "해당 결과", "해당 문서"
- 격식체 지시관형사 과다: "본(本)", "당(當)", "동(同)"
- 일반 지시관형사로 충분한데 격식체 사용

**과학적 근거**:
- 격식체 문서(법률, 행정 문서)로 훈련된 LLM의 편향
- "해당"은 법률/행정 용어로 일상적 글쓰기에서는 부자연스러움
- 한국어 원어민은 "이/그/저" 또는 관형사 생략을 선호

**발생 원인**:
- 격식체 문어 한국어 훈련 데이터 편향
- 구어체/비격식체 한국어 규범에 대한 인식 부족
- "해당"을 중립적 지시어로 과도하게 사용

**수정 방법**:
- "해당"을 "이/그" 또는 명사만으로 교체: "해당 기능" → "이 기능" 또는 "기능"
- 격식체 관형사를 일반형으로: "본 문서" → "이 문서"
- 문맥상 명확하면 지시관형사 생략

**예시**:

*수정 전 (AI 작문)*:
```
해당 기능을 사용하면 해당 결과를 얻을 수 있습니다. 해당 방법은 매우 효과적입니다.
```

*수정 후 (자연스러운 글)*:
```
이 기능을 쓰면 결과를 얻을 수 있어요. 방법이 아주 효과적이에요.
```

*설명*: 세 번째 "해당"을 "이", 생략, 생략으로 수정했습니다. 반복을 피하고 자연스러운 흐름을 만들었습니다.

*추가 예시*:
```
❌ "본 문서에서 해당 내용을 확인하시기 바랍니다."
✅ "이 문서에서 내용을 확인해 주세요."

❌ "해당 문제는 해당 팀이 해결할 것입니다."
✅ "이 문제는 팀에서 해결할 거예요."
```

---

## 패턴 20: 주어 생략 미흡

**메타데이터**:
- 출처: korean-skills community
- 검증: 📊 경험적
- 버전: 1.3.0

**검출 기준**:
- 연속된 문장에서 동일 주어 반복: "나는... 나는... 나는..."
- 문맥상 명확한 주어를 계속 명시
- 영어식 주어 필수 패턴

**과학적 근거**:
- 한국어는 pro-drop 언어로 주어 생략이 문법적으로 허용되고 자연스러움
- 영어는 주어가 필수이나 한국어는 문맥으로 파악 가능하면 생략
- 주어 반복은 한국어 원어민에게 어색하고 장황하게 느껴짐

**발생 원인**:
- 영어 문법 구조(SVO 필수)의 직접 전이
- LLM이 영어 훈련 데이터의 주어 필수 패턴을 한국어에 적용
- 한국어 주어 생략 규칙에 대한 인식 부족

**수정 방법**:
- 문맥상 명확하면 주어 생략: "나는 갔다. 나는 샀다." → "갔다. 샀다."
- 첫 문장에만 주어 명시하고 이후 생략
- 주어 전환 시에만 명시

**주어 생략 가능한 경우**:
- 선행 문장과 주어가 동일할 때
- 대화나 비격식체 글에서 화자가 명확할 때
- 일반적 진리나 경험을 서술할 때

**주어 유지해야 하는 경우**:
- 주어가 바뀔 때 (대비/전환)
- 여러 주어가 교차할 때 (혼동 방지)
- 강조가 필요할 때

**예시**:

*수정 전 (AI 작문)*:
```
나는 아침에 일어났습니다. 나는 커피를 마셨습니다. 나는 출근했습니다.
```

*수정 후 (자연스러운 글)*:
```
아침에 일어났어요. 커피 마시고 출근했어요.
```

*설명*: 세 문장 모두 주어가 "나"로 동일하고 문맥상 명확하므로 생략했습니다. 문장도 자연스럽게 연결했습니다.

*주어 전환 예시*:
```
✅ "철수는 학교에 갔다. 영희는 집에 있었다." (주어 바뀜 - 유지)
✅ "나는 영화 봤어. 친구는 게임 했고." (대비 - 유지)
❌ "나는 밥 먹었어. 나는 설거지했어. 나는 쉬었어." (반복 - 생략 필요)
✅ "밥 먹고 설거지하고 쉬었어." (생략)
```

*격식체에서도 생략 가능*:
```
❌ "연구팀은 실험을 진행했다. 연구팀은 데이터를 분석했다. 연구팀은 결과를 발표했다."
✅ "연구팀은 실험을 진행하고 데이터를 분석한 뒤 결과를 발표했다."
```
